#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:object-value
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object-value.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }
$ json <<< '\''{"foo":null}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":null}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":null}'\''
$ json <<< '\''{"foo":false}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":false}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":false}'\''
$ json <<< '\''{"foo":true}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":true}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":true}'\''
$ json <<< '\''{"foo":123}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":123}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":123}'\''
$ json <<< '\''{"foo":"foo"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"foo"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"foo"}'\''
$ json <<< '\''{"foo":"type"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"type"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"type"}'\''
$ json <<< '\''{"foo":"null"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"null"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"null"}'\''
$ json <<< '\''{"foo":"boolean"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"boolean"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"boolean"}'\''
$ json <<< '\''{"foo":"number"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"number"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"number"}'\''
$ json <<< '\''{"foo":"string"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"string"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"string"}'\''
$ json <<< '\''{"foo":"object"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"object"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"object"}'\''
$ json <<< '\''{"foo":"array"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"array"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"array"}'\''
$ json <<< '\''{"foo":"list"}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":"list"}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":"list"}'\''
$ json <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":{}}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":{}}'\''
$ json <<< '\''{"foo":{"foo":"bar"}}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":{"foo":"bar"}}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":{"foo":"bar"}}'\''
$ json <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":[]}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":[]}'\''
$ json <<< '\''{"foo":["foo","bar"]}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"foo":["foo","bar"]}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"foo":["foo","bar"]}'\''
$ json <<< '\''{"type":null}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":null}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":null}'\''
$ json <<< '\''{"type":false}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":false}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":false}'\''
$ json <<< '\''{"type":true}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":true}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":true}'\''
$ json <<< '\''{"type":123}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":123}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":123}'\''
$ json <<< '\''{"type":"foo"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":"foo"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"foo"}'\''
$ json <<< '\''{"type":"type"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":"type"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"type"}'\''
$ json <<< '\''{"type":"null"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":"null"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"null"}'\''
$ json <<< '\''{"type":"boolean"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":"boolean"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"boolean"}'\''
$ json <<< '\''{"type":"number"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":"number"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"number"}'\''
$ json <<< '\''{"type":"string"}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":"string"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":"string"}'\''
$ json <<< '\''{"type":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two
json: error: <stdin>:1:1: {"type":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object"}'\''
$ json <<< '\''{"type":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two
json: error: <stdin>:1:1: {"type":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array"}'\''
$ json <<< '\''{"type":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two
json: error: <stdin>:1:1: {"type":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list"}'\''
$ json <<< '\''{"type":{}}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":{}}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":{}}'\''
$ json <<< '\''{"type":{"foo":"bar"}}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":{"foo":"bar"}}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":{"foo":"bar"}}'\''
$ json <<< '\''{"type":[]}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":[]}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":[]}'\''
$ json <<< '\''{"type":["foo","bar"]}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array" or "list"
json: error: <stdin>:1:9: {"type":["foo","bar"]}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":["foo","bar"]}'\''
$ json <<< '\''{"name":null}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":null}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":null}'\''
$ json <<< '\''{"name":false}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":false}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":false}'\''
$ json <<< '\''{"name":true}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":true}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":true}'\''
$ json <<< '\''{"name":123}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":123}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":123}'\''
$ json <<< '\''{"name":"foo"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"foo"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"foo"}'\''
$ json <<< '\''{"name":"type"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"type"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"type"}'\''
$ json <<< '\''{"name":"null"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"null"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"null"}'\''
$ json <<< '\''{"name":"boolean"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"boolean"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"boolean"}'\''
$ json <<< '\''{"name":"number"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"number"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"number"}'\''
$ json <<< '\''{"name":"string"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"string"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"string"}'\''
$ json <<< '\''{"name":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"object"}'\''
$ json <<< '\''{"name":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"array"}'\''
$ json <<< '\''{"name":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"list"}'\''
$ json <<< '\''{"name":{}}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":{}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":{}}'\''
$ json <<< '\''{"name":{"foo":"bar"}}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":{"foo":"bar"}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":{"foo":"bar"}}'\''
$ json <<< '\''{"name":[]}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":[]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":[]}'\''
$ json <<< '\''{"name":["foo","bar"]}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":["foo","bar"]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":["foo","bar"]}'\''
$ json <<< '\''{"plain":null}'\''
{
    "plain": null
}
$ json <<< '\''{"plain":false}'\''
{
    "plain": false
}
$ json <<< '\''{"plain":true}'\''
{
    "plain": true
}
$ json <<< '\''{"plain":123}'\''
{
    "plain": 123
}
$ json <<< '\''{"plain":"foo"}'\''
{
    "plain": "foo"
}
$ json <<< '\''{"plain":"type"}'\''
{
    "plain": "type"
}
$ json <<< '\''{"plain":"null"}'\''
{
    "plain": "null"
}
$ json <<< '\''{"plain":"boolean"}'\''
{
    "plain": "boolean"
}
$ json <<< '\''{"plain":"number"}'\''
{
    "plain": "number"
}
$ json <<< '\''{"plain":"string"}'\''
{
    "plain": "string"
}
$ json <<< '\''{"plain":"object"}'\''
{
    "plain": "object"
}
$ json <<< '\''{"plain":"array"}'\''
{
    "plain": "array"
}
$ json <<< '\''{"plain":"list"}'\''
{
    "plain": "list"
}
$ json <<< '\''{"plain":{}}'\''
json: error: <stdin>:1:10: meta error: invalid "plain" object: value must be `null'\'', a boolean, a number or a string
json: error: <stdin>:1:10: {"plain":{}}
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''{"plain":{}}'\''
$ json <<< '\''{"plain":{"foo":"bar"}}'\''
json: error: <stdin>:1:10: meta error: invalid "plain" object: value must be `null'\'', a boolean, a number or a string
json: error: <stdin>:1:10: {"plain":{"foo":"bar"}}
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''{"plain":{"foo":"bar"}}'\''
$ json <<< '\''{"plain":[]}'\''
json: error: <stdin>:1:10: meta error: invalid "plain" object: value must be `null'\'', a boolean, a number or a string
json: error: <stdin>:1:10: {"plain":[]}
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''{"plain":[]}'\''
$ json <<< '\''{"plain":["foo","bar"]}'\''
json: error: <stdin>:1:10: meta error: invalid "plain" object: value must be `null'\'', a boolean, a number or a string
json: error: <stdin>:1:10: {"plain":["foo","bar"]}
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''{"plain":["foo","bar"]}'\'''
) -L object-value.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"foo":null}'\'''
json <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null}'\'''

echo '$ json <<< '\''{"foo":false}'\'''
json <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":false}'\'''

echo '$ json <<< '\''{"foo":true}'\'''
json <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":true}'\'''

echo '$ json <<< '\''{"foo":123}'\'''
json <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":123}'\'''

echo '$ json <<< '\''{"foo":"foo"}'\'''
json <<< '{"foo":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"foo"}'\'''

echo '$ json <<< '\''{"foo":"type"}'\'''
json <<< '{"foo":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"type"}'\'''

echo '$ json <<< '\''{"foo":"null"}'\'''
json <<< '{"foo":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"null"}'\'''

echo '$ json <<< '\''{"foo":"boolean"}'\'''
json <<< '{"foo":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"boolean"}'\'''

echo '$ json <<< '\''{"foo":"number"}'\'''
json <<< '{"foo":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"number"}'\'''

echo '$ json <<< '\''{"foo":"string"}'\'''
json <<< '{"foo":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"string"}'\'''

echo '$ json <<< '\''{"foo":"object"}'\'''
json <<< '{"foo":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"object"}'\'''

echo '$ json <<< '\''{"foo":"array"}'\'''
json <<< '{"foo":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"array"}'\'''

echo '$ json <<< '\''{"foo":"list"}'\'''
json <<< '{"foo":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"list"}'\'''

echo '$ json <<< '\''{"foo":{}}'\'''
json <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":{}}'\'''

echo '$ json <<< '\''{"foo":{"foo":"bar"}}'\'''
json <<< '{"foo":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"foo":[]}'\'''
json <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[]}'\'''

echo '$ json <<< '\''{"foo":["foo","bar"]}'\'''
json <<< '{"foo":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":null}'\'''
json <<< '{"type":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":null}'\'''

echo '$ json <<< '\''{"type":false}'\'''
json <<< '{"type":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":false}'\'''

echo '$ json <<< '\''{"type":true}'\'''
json <<< '{"type":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":true}'\'''

echo '$ json <<< '\''{"type":123}'\'''
json <<< '{"type":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":123}'\'''

echo '$ json <<< '\''{"type":"foo"}'\'''
json <<< '{"type":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"foo"}'\'''

echo '$ json <<< '\''{"type":"type"}'\'''
json <<< '{"type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"type"}'\'''

echo '$ json <<< '\''{"type":"null"}'\'''
json <<< '{"type":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"null"}'\'''

echo '$ json <<< '\''{"type":"boolean"}'\'''
json <<< '{"type":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"boolean"}'\'''

echo '$ json <<< '\''{"type":"number"}'\'''
json <<< '{"type":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"number"}'\'''

echo '$ json <<< '\''{"type":"string"}'\'''
json <<< '{"type":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"string"}'\'''

echo '$ json <<< '\''{"type":"object"}'\'''
json <<< '{"type":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object"}'\'''

echo '$ json <<< '\''{"type":"array"}'\'''
json <<< '{"type":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array"}'\'''

echo '$ json <<< '\''{"type":"list"}'\'''
json <<< '{"type":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list"}'\'''

echo '$ json <<< '\''{"type":{}}'\'''
json <<< '{"type":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":{}}'\'''

echo '$ json <<< '\''{"type":{"foo":"bar"}}'\'''
json <<< '{"type":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":[]}'\'''
json <<< '{"type":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":[]}'\'''

echo '$ json <<< '\''{"type":["foo","bar"]}'\'''
json <<< '{"type":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":["foo","bar"]}'\'''

echo '$ json <<< '\''{"name":null}'\'''
json <<< '{"name":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":null}'\'''

echo '$ json <<< '\''{"name":false}'\'''
json <<< '{"name":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":false}'\'''

echo '$ json <<< '\''{"name":true}'\'''
json <<< '{"name":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":true}'\'''

echo '$ json <<< '\''{"name":123}'\'''
json <<< '{"name":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":123}'\'''

echo '$ json <<< '\''{"name":"foo"}'\'''
json <<< '{"name":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"foo"}'\'''

echo '$ json <<< '\''{"name":"type"}'\'''
json <<< '{"name":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"type"}'\'''

echo '$ json <<< '\''{"name":"null"}'\'''
json <<< '{"name":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"null"}'\'''

echo '$ json <<< '\''{"name":"boolean"}'\'''
json <<< '{"name":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"boolean"}'\'''

echo '$ json <<< '\''{"name":"number"}'\'''
json <<< '{"name":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"number"}'\'''

echo '$ json <<< '\''{"name":"string"}'\'''
json <<< '{"name":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"string"}'\'''

echo '$ json <<< '\''{"name":"object"}'\'''
json <<< '{"name":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"object"}'\'''

echo '$ json <<< '\''{"name":"array"}'\'''
json <<< '{"name":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"array"}'\'''

echo '$ json <<< '\''{"name":"list"}'\'''
json <<< '{"name":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"list"}'\'''

echo '$ json <<< '\''{"name":{}}'\'''
json <<< '{"name":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":{}}'\'''

echo '$ json <<< '\''{"name":{"foo":"bar"}}'\'''
json <<< '{"name":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"name":[]}'\'''
json <<< '{"name":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":[]}'\'''

echo '$ json <<< '\''{"name":["foo","bar"]}'\'''
json <<< '{"name":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":["foo","bar"]}'\'''

echo '$ json <<< '\''{"plain":null}'\'''
json <<< '{"plain":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":null}'\'''

echo '$ json <<< '\''{"plain":false}'\'''
json <<< '{"plain":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":false}'\'''

echo '$ json <<< '\''{"plain":true}'\'''
json <<< '{"plain":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":true}'\'''

echo '$ json <<< '\''{"plain":123}'\'''
json <<< '{"plain":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":123}'\'''

echo '$ json <<< '\''{"plain":"foo"}'\'''
json <<< '{"plain":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"foo"}'\'''

echo '$ json <<< '\''{"plain":"type"}'\'''
json <<< '{"plain":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"type"}'\'''

echo '$ json <<< '\''{"plain":"null"}'\'''
json <<< '{"plain":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"null"}'\'''

echo '$ json <<< '\''{"plain":"boolean"}'\'''
json <<< '{"plain":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"boolean"}'\'''

echo '$ json <<< '\''{"plain":"number"}'\'''
json <<< '{"plain":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"number"}'\'''

echo '$ json <<< '\''{"plain":"string"}'\'''
json <<< '{"plain":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"string"}'\'''

echo '$ json <<< '\''{"plain":"object"}'\'''
json <<< '{"plain":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"object"}'\'''

echo '$ json <<< '\''{"plain":"array"}'\'''
json <<< '{"plain":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"array"}'\'''

echo '$ json <<< '\''{"plain":"list"}'\'''
json <<< '{"plain":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":"list"}'\'''

echo '$ json <<< '\''{"plain":{}}'\'''
json <<< '{"plain":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":{}}'\'''

echo '$ json <<< '\''{"plain":{"foo":"bar"}}'\'''
json <<< '{"plain":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"plain":[]}'\'''
json <<< '{"plain":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":[]}'\'''

echo '$ json <<< '\''{"plain":["foo","bar"]}'\'''
json <<< '{"plain":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":["foo","bar"]}'\'''
)

