#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-bar-basic-val-object-bar-basic-fuu-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-bar-basic-val-object-bar-basic-fuu-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"bar":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"bar":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"bar":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"bar":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
) -L list-object-foo-basic-object-bar-basic-val-object-bar-basic-fuu-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
)

