#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array-list6
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array-list6.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[[]]'\''
[[]]'
) -L open-array-list6.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[[]]'\'''
)

