#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-bar-plain-val-object-foo-basic-fuu-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-bar-plain-val-object-foo-basic-fuu-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"boz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"buz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"boz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"buz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"boz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"buz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"boz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"buz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"boz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"buz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"boz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"buz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
) -L list-object-foo-basic-object-bar-plain-val-object-foo-basic-fuu-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
)

