#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C checker:const-false
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L const-false.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }
$ json-litex -d '\''"0"'\'' <<< '\''null'\''
json: error: <stdin>:1:1: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json-litex -d '\''"0"'\'' <<< '\''null'\''
$ json-litex -d '\''"0"'\'' <<< '\''false'\''
json: error: <stdin>:1:1: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json-litex -d '\''"0"'\'' <<< '\''false'\''
$ json-litex -d '\''"0"'\'' <<< '\''true'\''
json: error: <stdin>:1:1: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json-litex -d '\''"0"'\'' <<< '\''true'\''
$ json-litex -d '\''"0"'\'' <<< '\''123'\''
json: error: <stdin>:1:1: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json-litex -d '\''"0"'\'' <<< '\''123'\''
$ json-litex -d '\''"0"'\'' <<< '\''"zzz"'\''
json: error: <stdin>:1:1: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:1: "zzz"
json: error: <stdin>:1:1: ^
command failed: json-litex -d '\''"0"'\'' <<< '\''"zzz"'\''
$ json-litex -d '\''"0"'\'' <<< '\''[]'\''
$ json-litex -d '\''"0"'\'' <<< '\''{}'\''
$ json-litex -d '\''"0"'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[null]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[false]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[true]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[123]'\''
$ json-litex -d '\''"0"'\'' <<< '\''["zzz"]'\''
json: error: <stdin>:1:2: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:2: ["zzz"]
json: error: <stdin>:1:2:  ^
command failed: json-litex -d '\''"0"'\'' <<< '\''["zzz"]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[[]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":null}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":false}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":true}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":123}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":"zzz"}'\''
json: error: <stdin>:1:8: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:8: {"foo":"zzz"}
json: error: <stdin>:1:8:        ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":"zzz"}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{}}'\''
$ json-litex -d '\''"0"'\'' <<< '\''[[null]]'\''
json: error: <stdin>:1:3: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:3: [[null]]
json: error: <stdin>:1:3:   ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[[null]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[[false]]'\''
json: error: <stdin>:1:3: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:3: [[false]]
json: error: <stdin>:1:3:   ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[[false]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[[true]]'\''
json: error: <stdin>:1:3: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:3: [[true]]
json: error: <stdin>:1:3:   ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[[true]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[[123]]'\''
json: error: <stdin>:1:3: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:3: [[123]]
json: error: <stdin>:1:3:   ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[[123]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[["zzz"]]'\''
json: error: <stdin>:1:3: filter library: path check error: expression falsified: root value -> expression "0"
json: error: <stdin>:1:3: [["zzz"]]
json: error: <stdin>:1:3:   ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[["zzz"]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[[[]]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[[{}]]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":null}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":null}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":false}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":false}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":false}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":true}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":true}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":true}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":123}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":123}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":123}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":"zzz"}]'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: [{"foo":"zzz"}]
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":"zzz"}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":[]}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":{}}]'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[null]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[null]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[null]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[false]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[false]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[false]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[true]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[true]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[true]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[123]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":[123]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[123]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":["zzz"]}'\''
json: error: <stdin>:1:9: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:9: {"foo":["zzz"]}
json: error: <stdin>:1:9:         ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":["zzz"]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[[]]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[{}]}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":null}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":null}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":null}}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":false}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":false}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":false}}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":true}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":true}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":true}}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":123}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":123}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":123}}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\''
json: error: <stdin>:1:15: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:15: {"foo":{"bar":"zzz"}}
json: error: <stdin>:1:15:               ^
command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":[]}}'\''
$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":{}}}'\'''
) -L const-false.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }'

echo '$ json-litex -d '\''"0"'\'' <<< '\''null'\'''
json-litex -d '"0"' <<< 'null' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''null'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''false'\'''
json-litex -d '"0"' <<< 'false' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''false'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''true'\'''
json-litex -d '"0"' <<< 'true' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''true'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''123'\'''
json-litex -d '"0"' <<< '123' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''123'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''"zzz"'\'''
json-litex -d '"0"' <<< '"zzz"' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''"zzz"'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[]'\'''
json-litex -d '"0"' <<< '[]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{}'\'''
json-litex -d '"0"' <<< '{}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[null]'\'''
json-litex -d '"0"' <<< '[null]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[null]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[false]'\'''
json-litex -d '"0"' <<< '[false]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[false]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[true]'\'''
json-litex -d '"0"' <<< '[true]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[true]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[123]'\'''
json-litex -d '"0"' <<< '[123]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[123]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''["zzz"]'\'''
json-litex -d '"0"' <<< '["zzz"]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''["zzz"]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[[]]'\'''
json-litex -d '"0"' <<< '[[]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[[]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{}]'\'''
json-litex -d '"0"' <<< '[{}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":null}'\'''
json-litex -d '"0"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":null}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":false}'\'''
json-litex -d '"0"' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":false}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":true}'\'''
json-litex -d '"0"' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":true}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":123}'\'''
json-litex -d '"0"' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":123}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":"zzz"}'\'''
json-litex -d '"0"' <<< '{"foo":"zzz"}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":"zzz"}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[]}'\'''
json-litex -d '"0"' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{}}'\'''
json-litex -d '"0"' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{}}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[[null]]'\'''
json-litex -d '"0"' <<< '[[null]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[[null]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[[false]]'\'''
json-litex -d '"0"' <<< '[[false]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[[false]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[[true]]'\'''
json-litex -d '"0"' <<< '[[true]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[[true]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[[123]]'\'''
json-litex -d '"0"' <<< '[[123]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[[123]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[["zzz"]]'\'''
json-litex -d '"0"' <<< '[["zzz"]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[["zzz"]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[[[]]]'\'''
json-litex -d '"0"' <<< '[[[]]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[[[]]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[[{}]]'\'''
json-litex -d '"0"' <<< '[[{}]]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[[{}]]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":null}]'\'''
json-litex -d '"0"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":false}]'\'''
json-litex -d '"0"' <<< '[{"foo":false}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":false}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":true}]'\'''
json-litex -d '"0"' <<< '[{"foo":true}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":true}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":123}]'\'''
json-litex -d '"0"' <<< '[{"foo":123}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":123}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":"zzz"}]'\'''
json-litex -d '"0"' <<< '[{"foo":"zzz"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":"zzz"}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":[]}]'\'''
json-litex -d '"0"' <<< '[{"foo":[]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":[]}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''[{"foo":{}}]'\'''
json-litex -d '"0"' <<< '[{"foo":{}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''[{"foo":{}}]'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[null]}'\'''
json-litex -d '"0"' <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[null]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[false]}'\'''
json-litex -d '"0"' <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[false]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[true]}'\'''
json-litex -d '"0"' <<< '{"foo":[true]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[true]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[123]}'\'''
json-litex -d '"0"' <<< '{"foo":[123]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[123]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":["zzz"]}'\'''
json-litex -d '"0"' <<< '{"foo":["zzz"]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":["zzz"]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[[]]}'\'''
json-litex -d '"0"' <<< '{"foo":[[]]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[[]]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":[{}]}'\'''
json-litex -d '"0"' <<< '{"foo":[{}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":[{}]}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":null}}'\'''
json-litex -d '"0"' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":false}}'\'''
json-litex -d '"0"' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":true}}'\'''
json-litex -d '"0"' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":123}}'\'''
json-litex -d '"0"' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\'''
json-litex -d '"0"' <<< '{"foo":{"bar":"zzz"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":"zzz"}}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json-litex -d '"0"' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json-litex -d '"0"' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''"0"'\'' <<< '\''{"foo":{"bar":{}}}'\'''
)

