#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-dup
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-dup.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":[{"plain":null},{"plain":null}]}'\''
json: error: <stdin>:1:39: attribute error: invalid "list" type object: duplicated '\''plain'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:39: ":"list","args":[{"plain":null},{"plain":null}]}
json: error: <stdin>:1:39:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"plain":null},{"plain":null}]}'\''
$ json <<< '\''{"type":"list","args":[{"plain":false},{"plain":false}]}'\''
json: error: <stdin>:1:40: attribute error: invalid "list" type object: duplicated '\''plain'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:40: :"list","args":[{"plain":false},{"plain":false}]}
json: error: <stdin>:1:40:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"plain":false},{"plain":false}]}'\''
$ json <<< '\''{"type":"list","args":[{"plain":true},{"plain":true}]}'\''
json: error: <stdin>:1:39: attribute error: invalid "list" type object: duplicated '\''plain'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:39: ":"list","args":[{"plain":true},{"plain":true}]}
json: error: <stdin>:1:39:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"plain":true},{"plain":true}]}'\''
$ json <<< '\''{"type":"list","args":[{"plain":123},{"plain":123}]}'\''
json: error: <stdin>:1:38: attribute error: invalid "list" type object: duplicated '\''plain'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:38: e":"list","args":[{"plain":123},{"plain":123}]}
json: error: <stdin>:1:38:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"plain":123},{"plain":123}]}'\''
$ json <<< '\''{"type":"list","args":[{"plain":"foo"},{"plain":"foo"}]}'\''
json: error: <stdin>:1:40: attribute error: invalid "list" type object: duplicated '\''plain'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:40: :"list","args":[{"plain":"foo"},{"plain":"foo"}]}
json: error: <stdin>:1:40:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"plain":"foo"},{"plain":"foo"}]}'\''
$ json <<< '\''{"type":"list","args":["type","type"]}'\''
json: error: <stdin>:1:31: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:31: {"type":"list","args":["type","type"]}
json: error: <stdin>:1:31:                               ^
command failed: json <<< '\''{"type":"list","args":["type","type"]}'\''
$ json <<< '\''{"type":"list","args":["null","null"]}'\''
json: error: <stdin>:1:31: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:31: {"type":"list","args":["null","null"]}
json: error: <stdin>:1:31:                               ^
command failed: json <<< '\''{"type":"list","args":["null","null"]}'\''
$ json <<< '\''{"type":"list","args":["boolean","boolean"]}'\''
json: error: <stdin>:1:34: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:34: "type":"list","args":["boolean","boolean"]}
json: error: <stdin>:1:34:                                 ^
command failed: json <<< '\''{"type":"list","args":["boolean","boolean"]}'\''
$ json <<< '\''{"type":"list","args":["number","number"]}'\''
json: error: <stdin>:1:33: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:33: {"type":"list","args":["number","number"]}
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''{"type":"list","args":["number","number"]}'\''
$ json <<< '\''{"type":"list","args":["string","string"]}'\''
json: error: <stdin>:1:33: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:33: {"type":"list","args":["string","string"]}
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''{"type":"list","args":["string","string"]}'\''
$ json <<< '\''{"type":"list","args":["object","object"]}'\''
json: error: <stdin>:1:33: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:33: {"type":"list","args":["object","object"]}
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''{"type":"list","args":["object","object"]}'\''
$ json <<< '\''{"type":"list","args":["array","array"]}'\''
json: error: <stdin>:1:32: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:32: {"type":"list","args":["array","array"]}
json: error: <stdin>:1:32:                                ^
command failed: json <<< '\''{"type":"list","args":["array","array"]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\''
json: error: <stdin>:1:52: attribute error: invalid "list" type object: duplicated '\''object'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:52: s":[{"type":"object","args":[]},{"type":"object","args":[]}]}
json: error: <stdin>:1:52:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":"type"}]}'\''
json: error: <stdin>:1:55: attribute error: invalid "list" type object: duplicated '\''open array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:55: [{"type":"array","args":"type"},{"type":"array","args":"type"}]}
json: error: <stdin>:1:55:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":"type"}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:57: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:57: "type":"array","args":["type"]},{"type":"array","args":["type"]}]
json: error: <stdin>:1:57:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\'''
) -L list-dup.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":[{"plain":null},{"plain":null}]}'\'''
json <<< '{"type":"list","args":[{"plain":null},{"plain":null}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":null},{"plain":null}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"plain":false},{"plain":false}]}'\'''
json <<< '{"type":"list","args":[{"plain":false},{"plain":false}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":false},{"plain":false}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"plain":true},{"plain":true}]}'\'''
json <<< '{"type":"list","args":[{"plain":true},{"plain":true}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":true},{"plain":true}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"plain":123},{"plain":123}]}'\'''
json <<< '{"type":"list","args":[{"plain":123},{"plain":123}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":123},{"plain":123}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"plain":"foo"},{"plain":"foo"}]}'\'''
json <<< '{"type":"list","args":[{"plain":"foo"},{"plain":"foo"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":"foo"},{"plain":"foo"}]}'\'''

echo '$ json <<< '\''{"type":"list","args":["type","type"]}'\'''
json <<< '{"type":"list","args":["type","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","null"]}'\'''
json <<< '{"type":"list","args":["null","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","boolean"]}'\'''
json <<< '{"type":"list","args":["boolean","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","number"]}'\'''
json <<< '{"type":"list","args":["number","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","string"]}'\'''
json <<< '{"type":"list","args":["string","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","object"]}'\'''
json <<< '{"type":"list","args":["object","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","array"]}'\'''
json <<< '{"type":"list","args":["array","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","array"]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":"type"}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":"type"}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\'''
)

