#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-esc
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-esc.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo -e '\''"\\\x0"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\0"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x0"'\''|json -b 1
$ echo -e '\''"\\\x0"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\0"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x0"'\''|json -b 2
$ echo -e '\''"\\\x0"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\0"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x0"'\''|json -b 3
$ echo -e '\''"\\\x0"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\0"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x0"'\''|json -b 4
$ echo -e '\''"\\\x0"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\0"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x0"'\''|json -b 5
$ echo -e '\''"\\\x1"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x01"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1"'\''|json -b 1
$ echo -e '\''"\\\x1"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x01"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1"'\''|json -b 2
$ echo -e '\''"\\\x1"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x01"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1"'\''|json -b 3
$ echo -e '\''"\\\x1"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x01"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1"'\''|json -b 4
$ echo -e '\''"\\\x1"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x01"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1"'\''|json -b 5
$ echo -e '\''"\\\x2"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x02"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x2"'\''|json -b 1
$ echo -e '\''"\\\x2"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x02"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x2"'\''|json -b 2
$ echo -e '\''"\\\x2"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x02"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x2"'\''|json -b 3
$ echo -e '\''"\\\x2"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x02"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x2"'\''|json -b 4
$ echo -e '\''"\\\x2"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x02"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x2"'\''|json -b 5
$ echo -e '\''"\\\x3"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x03"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x3"'\''|json -b 1
$ echo -e '\''"\\\x3"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x03"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x3"'\''|json -b 2
$ echo -e '\''"\\\x3"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x03"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x3"'\''|json -b 3
$ echo -e '\''"\\\x3"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x03"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x3"'\''|json -b 4
$ echo -e '\''"\\\x3"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x03"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x3"'\''|json -b 5
$ echo -e '\''"\\\x4"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x04"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x4"'\''|json -b 1
$ echo -e '\''"\\\x4"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x04"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x4"'\''|json -b 2
$ echo -e '\''"\\\x4"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x04"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x4"'\''|json -b 3
$ echo -e '\''"\\\x4"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x04"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x4"'\''|json -b 4
$ echo -e '\''"\\\x4"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x04"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x4"'\''|json -b 5
$ echo -e '\''"\\\x5"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x05"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x5"'\''|json -b 1
$ echo -e '\''"\\\x5"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x05"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x5"'\''|json -b 2
$ echo -e '\''"\\\x5"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x05"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x5"'\''|json -b 3
$ echo -e '\''"\\\x5"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x05"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x5"'\''|json -b 4
$ echo -e '\''"\\\x5"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x05"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x5"'\''|json -b 5
$ echo -e '\''"\\\x6"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x06"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x6"'\''|json -b 1
$ echo -e '\''"\\\x6"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x06"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x6"'\''|json -b 2
$ echo -e '\''"\\\x6"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x06"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x6"'\''|json -b 3
$ echo -e '\''"\\\x6"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x06"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x6"'\''|json -b 4
$ echo -e '\''"\\\x6"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x06"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x6"'\''|json -b 5
$ echo -e '\''"\\\x7"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7"'\''|json -b 1
$ echo -e '\''"\\\x7"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7"'\''|json -b 2
$ echo -e '\''"\\\x7"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7"'\''|json -b 3
$ echo -e '\''"\\\x7"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7"'\''|json -b 4
$ echo -e '\''"\\\x7"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x7"'\''|json -b 5
$ echo -e '\''"\\\x8"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x8"'\''|json -b 1
$ echo -e '\''"\\\x8"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x8"'\''|json -b 2
$ echo -e '\''"\\\x8"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x8"'\''|json -b 3
$ echo -e '\''"\\\x8"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x8"'\''|json -b 4
$ echo -e '\''"\\\x8"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x8"'\''|json -b 5
$ echo -e '\''"\\\x9"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\t"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x9"'\''|json -b 1
$ echo -e '\''"\\\x9"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\t"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x9"'\''|json -b 2
$ echo -e '\''"\\\x9"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\t"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x9"'\''|json -b 3
$ echo -e '\''"\\\x9"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\t"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x9"'\''|json -b 4
$ echo -e '\''"\\\x9"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\t"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x9"'\''|json -b 5
$ echo -e '\''"\\\xa"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\n"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xa"'\''|json -b 1
$ echo -e '\''"\\\xa"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\n"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xa"'\''|json -b 2
$ echo -e '\''"\\\xa"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\n"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xa"'\''|json -b 3
$ echo -e '\''"\\\xa"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\n"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xa"'\''|json -b 4
$ echo -e '\''"\\\xa"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\n"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xa"'\''|json -b 5
$ echo -e '\''"\\\xb"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\v"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xb"'\''|json -b 1
$ echo -e '\''"\\\xb"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\v"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xb"'\''|json -b 2
$ echo -e '\''"\\\xb"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\v"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xb"'\''|json -b 3
$ echo -e '\''"\\\xb"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\v"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xb"'\''|json -b 4
$ echo -e '\''"\\\xb"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\v"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xb"'\''|json -b 5
$ echo -e '\''"\\\xc"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xc"'\''|json -b 1
$ echo -e '\''"\\\xc"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xc"'\''|json -b 2
$ echo -e '\''"\\\xc"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xc"'\''|json -b 3
$ echo -e '\''"\\\xc"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xc"'\''|json -b 4
$ echo -e '\''"\\\xc"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xc"'\''|json -b 5
$ echo -e '\''"\\\xd"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\r"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xd"'\''|json -b 1
$ echo -e '\''"\\\xd"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\r"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xd"'\''|json -b 2
$ echo -e '\''"\\\xd"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\r"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xd"'\''|json -b 3
$ echo -e '\''"\\\xd"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\r"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xd"'\''|json -b 4
$ echo -e '\''"\\\xd"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\r"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xd"'\''|json -b 5
$ echo -e '\''"\\\xe"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xe"'\''|json -b 1
$ echo -e '\''"\\\xe"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xe"'\''|json -b 2
$ echo -e '\''"\\\xe"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xe"'\''|json -b 3
$ echo -e '\''"\\\xe"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xe"'\''|json -b 4
$ echo -e '\''"\\\xe"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xe"'\''|json -b 5
$ echo -e '\''"\\\xf"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xf"'\''|json -b 1
$ echo -e '\''"\\\xf"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xf"'\''|json -b 2
$ echo -e '\''"\\\xf"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xf"'\''|json -b 3
$ echo -e '\''"\\\xf"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xf"'\''|json -b 4
$ echo -e '\''"\\\xf"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x0f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\xf"'\''|json -b 5
$ echo -e '\''"\\\x10"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x10"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x10"'\''|json -b 1
$ echo -e '\''"\\\x10"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x10"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x10"'\''|json -b 2
$ echo -e '\''"\\\x10"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x10"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x10"'\''|json -b 3
$ echo -e '\''"\\\x10"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x10"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x10"'\''|json -b 4
$ echo -e '\''"\\\x10"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x10"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x10"'\''|json -b 5
$ echo -e '\''"\\\x11"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x11"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x11"'\''|json -b 1
$ echo -e '\''"\\\x11"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x11"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x11"'\''|json -b 2
$ echo -e '\''"\\\x11"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x11"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x11"'\''|json -b 3
$ echo -e '\''"\\\x11"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x11"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x11"'\''|json -b 4
$ echo -e '\''"\\\x11"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x11"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x11"'\''|json -b 5
$ echo -e '\''"\\\x12"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x12"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x12"'\''|json -b 1
$ echo -e '\''"\\\x12"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x12"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x12"'\''|json -b 2
$ echo -e '\''"\\\x12"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x12"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x12"'\''|json -b 3
$ echo -e '\''"\\\x12"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x12"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x12"'\''|json -b 4
$ echo -e '\''"\\\x12"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x12"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x12"'\''|json -b 5
$ echo -e '\''"\\\x13"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x13"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x13"'\''|json -b 1
$ echo -e '\''"\\\x13"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x13"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x13"'\''|json -b 2
$ echo -e '\''"\\\x13"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x13"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x13"'\''|json -b 3
$ echo -e '\''"\\\x13"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x13"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x13"'\''|json -b 4
$ echo -e '\''"\\\x13"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x13"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x13"'\''|json -b 5
$ echo -e '\''"\\\x14"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x14"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x14"'\''|json -b 1
$ echo -e '\''"\\\x14"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x14"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x14"'\''|json -b 2
$ echo -e '\''"\\\x14"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x14"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x14"'\''|json -b 3
$ echo -e '\''"\\\x14"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x14"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x14"'\''|json -b 4
$ echo -e '\''"\\\x14"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x14"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x14"'\''|json -b 5
$ echo -e '\''"\\\x15"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x15"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x15"'\''|json -b 1
$ echo -e '\''"\\\x15"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x15"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x15"'\''|json -b 2
$ echo -e '\''"\\\x15"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x15"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x15"'\''|json -b 3
$ echo -e '\''"\\\x15"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x15"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x15"'\''|json -b 4
$ echo -e '\''"\\\x15"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x15"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x15"'\''|json -b 5
$ echo -e '\''"\\\x16"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x16"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x16"'\''|json -b 1
$ echo -e '\''"\\\x16"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x16"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x16"'\''|json -b 2
$ echo -e '\''"\\\x16"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x16"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x16"'\''|json -b 3
$ echo -e '\''"\\\x16"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x16"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x16"'\''|json -b 4
$ echo -e '\''"\\\x16"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x16"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x16"'\''|json -b 5
$ echo -e '\''"\\\x17"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x17"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x17"'\''|json -b 1
$ echo -e '\''"\\\x17"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x17"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x17"'\''|json -b 2
$ echo -e '\''"\\\x17"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x17"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x17"'\''|json -b 3
$ echo -e '\''"\\\x17"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x17"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x17"'\''|json -b 4
$ echo -e '\''"\\\x17"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x17"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x17"'\''|json -b 5
$ echo -e '\''"\\\x18"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x18"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x18"'\''|json -b 1
$ echo -e '\''"\\\x18"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x18"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x18"'\''|json -b 2
$ echo -e '\''"\\\x18"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x18"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x18"'\''|json -b 3
$ echo -e '\''"\\\x18"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x18"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x18"'\''|json -b 4
$ echo -e '\''"\\\x18"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x18"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x18"'\''|json -b 5
$ echo -e '\''"\\\x19"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x19"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x19"'\''|json -b 1
$ echo -e '\''"\\\x19"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x19"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x19"'\''|json -b 2
$ echo -e '\''"\\\x19"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x19"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x19"'\''|json -b 3
$ echo -e '\''"\\\x19"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x19"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x19"'\''|json -b 4
$ echo -e '\''"\\\x19"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x19"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x19"'\''|json -b 5
$ echo -e '\''"\\\x1a"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1a"'\''|json -b 1
$ echo -e '\''"\\\x1a"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1a"'\''|json -b 2
$ echo -e '\''"\\\x1a"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1a"'\''|json -b 3
$ echo -e '\''"\\\x1a"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1a"'\''|json -b 4
$ echo -e '\''"\\\x1a"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1a"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1a"'\''|json -b 5
$ echo -e '\''"\\\x1b"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1b"'\''|json -b 1
$ echo -e '\''"\\\x1b"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1b"'\''|json -b 2
$ echo -e '\''"\\\x1b"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1b"'\''|json -b 3
$ echo -e '\''"\\\x1b"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1b"'\''|json -b 4
$ echo -e '\''"\\\x1b"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1b"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1b"'\''|json -b 5
$ echo -e '\''"\\\x1c"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1c"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1c"'\''|json -b 1
$ echo -e '\''"\\\x1c"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1c"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1c"'\''|json -b 2
$ echo -e '\''"\\\x1c"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1c"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1c"'\''|json -b 3
$ echo -e '\''"\\\x1c"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1c"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1c"'\''|json -b 4
$ echo -e '\''"\\\x1c"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1c"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1c"'\''|json -b 5
$ echo -e '\''"\\\x1d"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1d"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1d"'\''|json -b 1
$ echo -e '\''"\\\x1d"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1d"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1d"'\''|json -b 2
$ echo -e '\''"\\\x1d"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1d"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1d"'\''|json -b 3
$ echo -e '\''"\\\x1d"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1d"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1d"'\''|json -b 4
$ echo -e '\''"\\\x1d"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1d"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1d"'\''|json -b 5
$ echo -e '\''"\\\x1e"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1e"'\''|json -b 1
$ echo -e '\''"\\\x1e"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1e"'\''|json -b 2
$ echo -e '\''"\\\x1e"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1e"'\''|json -b 3
$ echo -e '\''"\\\x1e"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1e"'\''|json -b 4
$ echo -e '\''"\\\x1e"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1e"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1e"'\''|json -b 5
$ echo -e '\''"\\\x1f"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1f"'\''|json -b 1
$ echo -e '\''"\\\x1f"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1f"'\''|json -b 2
$ echo -e '\''"\\\x1f"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1f"'\''|json -b 3
$ echo -e '\''"\\\x1f"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1f"'\''|json -b 4
$ echo -e '\''"\\\x1f"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\\x1f"
json: error: <stdin>:1:3:    ^
command failed: echo -e '\''"\\\x1f"'\''|json -b 5'
) -L string-esc.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo -e '\''"\\\x0"'\''|json -b 1'
echo -e '"\\\x0"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x0"'\''|json -b 1'

echo '$ echo -e '\''"\\\x0"'\''|json -b 2'
echo -e '"\\\x0"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x0"'\''|json -b 2'

echo '$ echo -e '\''"\\\x0"'\''|json -b 3'
echo -e '"\\\x0"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x0"'\''|json -b 3'

echo '$ echo -e '\''"\\\x0"'\''|json -b 4'
echo -e '"\\\x0"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x0"'\''|json -b 4'

echo '$ echo -e '\''"\\\x0"'\''|json -b 5'
echo -e '"\\\x0"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x0"'\''|json -b 5'

echo '$ echo -e '\''"\\\x1"'\''|json -b 1'
echo -e '"\\\x1"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1"'\''|json -b 1'

echo '$ echo -e '\''"\\\x1"'\''|json -b 2'
echo -e '"\\\x1"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1"'\''|json -b 2'

echo '$ echo -e '\''"\\\x1"'\''|json -b 3'
echo -e '"\\\x1"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1"'\''|json -b 3'

echo '$ echo -e '\''"\\\x1"'\''|json -b 4'
echo -e '"\\\x1"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1"'\''|json -b 4'

echo '$ echo -e '\''"\\\x1"'\''|json -b 5'
echo -e '"\\\x1"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1"'\''|json -b 5'

echo '$ echo -e '\''"\\\x2"'\''|json -b 1'
echo -e '"\\\x2"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x2"'\''|json -b 1'

echo '$ echo -e '\''"\\\x2"'\''|json -b 2'
echo -e '"\\\x2"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x2"'\''|json -b 2'

echo '$ echo -e '\''"\\\x2"'\''|json -b 3'
echo -e '"\\\x2"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x2"'\''|json -b 3'

echo '$ echo -e '\''"\\\x2"'\''|json -b 4'
echo -e '"\\\x2"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x2"'\''|json -b 4'

echo '$ echo -e '\''"\\\x2"'\''|json -b 5'
echo -e '"\\\x2"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x2"'\''|json -b 5'

echo '$ echo -e '\''"\\\x3"'\''|json -b 1'
echo -e '"\\\x3"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x3"'\''|json -b 1'

echo '$ echo -e '\''"\\\x3"'\''|json -b 2'
echo -e '"\\\x3"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x3"'\''|json -b 2'

echo '$ echo -e '\''"\\\x3"'\''|json -b 3'
echo -e '"\\\x3"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x3"'\''|json -b 3'

echo '$ echo -e '\''"\\\x3"'\''|json -b 4'
echo -e '"\\\x3"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x3"'\''|json -b 4'

echo '$ echo -e '\''"\\\x3"'\''|json -b 5'
echo -e '"\\\x3"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x3"'\''|json -b 5'

echo '$ echo -e '\''"\\\x4"'\''|json -b 1'
echo -e '"\\\x4"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x4"'\''|json -b 1'

echo '$ echo -e '\''"\\\x4"'\''|json -b 2'
echo -e '"\\\x4"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x4"'\''|json -b 2'

echo '$ echo -e '\''"\\\x4"'\''|json -b 3'
echo -e '"\\\x4"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x4"'\''|json -b 3'

echo '$ echo -e '\''"\\\x4"'\''|json -b 4'
echo -e '"\\\x4"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x4"'\''|json -b 4'

echo '$ echo -e '\''"\\\x4"'\''|json -b 5'
echo -e '"\\\x4"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x4"'\''|json -b 5'

echo '$ echo -e '\''"\\\x5"'\''|json -b 1'
echo -e '"\\\x5"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x5"'\''|json -b 1'

echo '$ echo -e '\''"\\\x5"'\''|json -b 2'
echo -e '"\\\x5"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x5"'\''|json -b 2'

echo '$ echo -e '\''"\\\x5"'\''|json -b 3'
echo -e '"\\\x5"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x5"'\''|json -b 3'

echo '$ echo -e '\''"\\\x5"'\''|json -b 4'
echo -e '"\\\x5"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x5"'\''|json -b 4'

echo '$ echo -e '\''"\\\x5"'\''|json -b 5'
echo -e '"\\\x5"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x5"'\''|json -b 5'

echo '$ echo -e '\''"\\\x6"'\''|json -b 1'
echo -e '"\\\x6"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x6"'\''|json -b 1'

echo '$ echo -e '\''"\\\x6"'\''|json -b 2'
echo -e '"\\\x6"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x6"'\''|json -b 2'

echo '$ echo -e '\''"\\\x6"'\''|json -b 3'
echo -e '"\\\x6"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x6"'\''|json -b 3'

echo '$ echo -e '\''"\\\x6"'\''|json -b 4'
echo -e '"\\\x6"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x6"'\''|json -b 4'

echo '$ echo -e '\''"\\\x6"'\''|json -b 5'
echo -e '"\\\x6"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x6"'\''|json -b 5'

echo '$ echo -e '\''"\\\x7"'\''|json -b 1'
echo -e '"\\\x7"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7"'\''|json -b 1'

echo '$ echo -e '\''"\\\x7"'\''|json -b 2'
echo -e '"\\\x7"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7"'\''|json -b 2'

echo '$ echo -e '\''"\\\x7"'\''|json -b 3'
echo -e '"\\\x7"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7"'\''|json -b 3'

echo '$ echo -e '\''"\\\x7"'\''|json -b 4'
echo -e '"\\\x7"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7"'\''|json -b 4'

echo '$ echo -e '\''"\\\x7"'\''|json -b 5'
echo -e '"\\\x7"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x7"'\''|json -b 5'

echo '$ echo -e '\''"\\\x8"'\''|json -b 1'
echo -e '"\\\x8"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x8"'\''|json -b 1'

echo '$ echo -e '\''"\\\x8"'\''|json -b 2'
echo -e '"\\\x8"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x8"'\''|json -b 2'

echo '$ echo -e '\''"\\\x8"'\''|json -b 3'
echo -e '"\\\x8"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x8"'\''|json -b 3'

echo '$ echo -e '\''"\\\x8"'\''|json -b 4'
echo -e '"\\\x8"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x8"'\''|json -b 4'

echo '$ echo -e '\''"\\\x8"'\''|json -b 5'
echo -e '"\\\x8"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x8"'\''|json -b 5'

echo '$ echo -e '\''"\\\x9"'\''|json -b 1'
echo -e '"\\\x9"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x9"'\''|json -b 1'

echo '$ echo -e '\''"\\\x9"'\''|json -b 2'
echo -e '"\\\x9"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x9"'\''|json -b 2'

echo '$ echo -e '\''"\\\x9"'\''|json -b 3'
echo -e '"\\\x9"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x9"'\''|json -b 3'

echo '$ echo -e '\''"\\\x9"'\''|json -b 4'
echo -e '"\\\x9"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x9"'\''|json -b 4'

echo '$ echo -e '\''"\\\x9"'\''|json -b 5'
echo -e '"\\\x9"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x9"'\''|json -b 5'

echo '$ echo -e '\''"\\\xa"'\''|json -b 1'
echo -e '"\\\xa"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\xa"'\''|json -b 1'

echo '$ echo -e '\''"\\\xa"'\''|json -b 2'
echo -e '"\\\xa"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\xa"'\''|json -b 2'

echo '$ echo -e '\''"\\\xa"'\''|json -b 3'
echo -e '"\\\xa"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\xa"'\''|json -b 3'

echo '$ echo -e '\''"\\\xa"'\''|json -b 4'
echo -e '"\\\xa"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\xa"'\''|json -b 4'

echo '$ echo -e '\''"\\\xa"'\''|json -b 5'
echo -e '"\\\xa"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\xa"'\''|json -b 5'

echo '$ echo -e '\''"\\\xb"'\''|json -b 1'
echo -e '"\\\xb"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\xb"'\''|json -b 1'

echo '$ echo -e '\''"\\\xb"'\''|json -b 2'
echo -e '"\\\xb"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\xb"'\''|json -b 2'

echo '$ echo -e '\''"\\\xb"'\''|json -b 3'
echo -e '"\\\xb"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\xb"'\''|json -b 3'

echo '$ echo -e '\''"\\\xb"'\''|json -b 4'
echo -e '"\\\xb"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\xb"'\''|json -b 4'

echo '$ echo -e '\''"\\\xb"'\''|json -b 5'
echo -e '"\\\xb"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\xb"'\''|json -b 5'

echo '$ echo -e '\''"\\\xc"'\''|json -b 1'
echo -e '"\\\xc"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\xc"'\''|json -b 1'

echo '$ echo -e '\''"\\\xc"'\''|json -b 2'
echo -e '"\\\xc"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\xc"'\''|json -b 2'

echo '$ echo -e '\''"\\\xc"'\''|json -b 3'
echo -e '"\\\xc"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\xc"'\''|json -b 3'

echo '$ echo -e '\''"\\\xc"'\''|json -b 4'
echo -e '"\\\xc"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\xc"'\''|json -b 4'

echo '$ echo -e '\''"\\\xc"'\''|json -b 5'
echo -e '"\\\xc"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\xc"'\''|json -b 5'

echo '$ echo -e '\''"\\\xd"'\''|json -b 1'
echo -e '"\\\xd"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\xd"'\''|json -b 1'

echo '$ echo -e '\''"\\\xd"'\''|json -b 2'
echo -e '"\\\xd"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\xd"'\''|json -b 2'

echo '$ echo -e '\''"\\\xd"'\''|json -b 3'
echo -e '"\\\xd"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\xd"'\''|json -b 3'

echo '$ echo -e '\''"\\\xd"'\''|json -b 4'
echo -e '"\\\xd"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\xd"'\''|json -b 4'

echo '$ echo -e '\''"\\\xd"'\''|json -b 5'
echo -e '"\\\xd"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\xd"'\''|json -b 5'

echo '$ echo -e '\''"\\\xe"'\''|json -b 1'
echo -e '"\\\xe"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\xe"'\''|json -b 1'

echo '$ echo -e '\''"\\\xe"'\''|json -b 2'
echo -e '"\\\xe"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\xe"'\''|json -b 2'

echo '$ echo -e '\''"\\\xe"'\''|json -b 3'
echo -e '"\\\xe"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\xe"'\''|json -b 3'

echo '$ echo -e '\''"\\\xe"'\''|json -b 4'
echo -e '"\\\xe"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\xe"'\''|json -b 4'

echo '$ echo -e '\''"\\\xe"'\''|json -b 5'
echo -e '"\\\xe"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\xe"'\''|json -b 5'

echo '$ echo -e '\''"\\\xf"'\''|json -b 1'
echo -e '"\\\xf"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\xf"'\''|json -b 1'

echo '$ echo -e '\''"\\\xf"'\''|json -b 2'
echo -e '"\\\xf"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\xf"'\''|json -b 2'

echo '$ echo -e '\''"\\\xf"'\''|json -b 3'
echo -e '"\\\xf"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\xf"'\''|json -b 3'

echo '$ echo -e '\''"\\\xf"'\''|json -b 4'
echo -e '"\\\xf"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\xf"'\''|json -b 4'

echo '$ echo -e '\''"\\\xf"'\''|json -b 5'
echo -e '"\\\xf"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\xf"'\''|json -b 5'

echo '$ echo -e '\''"\\\x10"'\''|json -b 1'
echo -e '"\\\x10"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x10"'\''|json -b 1'

echo '$ echo -e '\''"\\\x10"'\''|json -b 2'
echo -e '"\\\x10"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x10"'\''|json -b 2'

echo '$ echo -e '\''"\\\x10"'\''|json -b 3'
echo -e '"\\\x10"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x10"'\''|json -b 3'

echo '$ echo -e '\''"\\\x10"'\''|json -b 4'
echo -e '"\\\x10"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x10"'\''|json -b 4'

echo '$ echo -e '\''"\\\x10"'\''|json -b 5'
echo -e '"\\\x10"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x10"'\''|json -b 5'

echo '$ echo -e '\''"\\\x11"'\''|json -b 1'
echo -e '"\\\x11"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x11"'\''|json -b 1'

echo '$ echo -e '\''"\\\x11"'\''|json -b 2'
echo -e '"\\\x11"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x11"'\''|json -b 2'

echo '$ echo -e '\''"\\\x11"'\''|json -b 3'
echo -e '"\\\x11"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x11"'\''|json -b 3'

echo '$ echo -e '\''"\\\x11"'\''|json -b 4'
echo -e '"\\\x11"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x11"'\''|json -b 4'

echo '$ echo -e '\''"\\\x11"'\''|json -b 5'
echo -e '"\\\x11"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x11"'\''|json -b 5'

echo '$ echo -e '\''"\\\x12"'\''|json -b 1'
echo -e '"\\\x12"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x12"'\''|json -b 1'

echo '$ echo -e '\''"\\\x12"'\''|json -b 2'
echo -e '"\\\x12"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x12"'\''|json -b 2'

echo '$ echo -e '\''"\\\x12"'\''|json -b 3'
echo -e '"\\\x12"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x12"'\''|json -b 3'

echo '$ echo -e '\''"\\\x12"'\''|json -b 4'
echo -e '"\\\x12"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x12"'\''|json -b 4'

echo '$ echo -e '\''"\\\x12"'\''|json -b 5'
echo -e '"\\\x12"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x12"'\''|json -b 5'

echo '$ echo -e '\''"\\\x13"'\''|json -b 1'
echo -e '"\\\x13"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x13"'\''|json -b 1'

echo '$ echo -e '\''"\\\x13"'\''|json -b 2'
echo -e '"\\\x13"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x13"'\''|json -b 2'

echo '$ echo -e '\''"\\\x13"'\''|json -b 3'
echo -e '"\\\x13"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x13"'\''|json -b 3'

echo '$ echo -e '\''"\\\x13"'\''|json -b 4'
echo -e '"\\\x13"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x13"'\''|json -b 4'

echo '$ echo -e '\''"\\\x13"'\''|json -b 5'
echo -e '"\\\x13"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x13"'\''|json -b 5'

echo '$ echo -e '\''"\\\x14"'\''|json -b 1'
echo -e '"\\\x14"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x14"'\''|json -b 1'

echo '$ echo -e '\''"\\\x14"'\''|json -b 2'
echo -e '"\\\x14"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x14"'\''|json -b 2'

echo '$ echo -e '\''"\\\x14"'\''|json -b 3'
echo -e '"\\\x14"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x14"'\''|json -b 3'

echo '$ echo -e '\''"\\\x14"'\''|json -b 4'
echo -e '"\\\x14"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x14"'\''|json -b 4'

echo '$ echo -e '\''"\\\x14"'\''|json -b 5'
echo -e '"\\\x14"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x14"'\''|json -b 5'

echo '$ echo -e '\''"\\\x15"'\''|json -b 1'
echo -e '"\\\x15"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x15"'\''|json -b 1'

echo '$ echo -e '\''"\\\x15"'\''|json -b 2'
echo -e '"\\\x15"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x15"'\''|json -b 2'

echo '$ echo -e '\''"\\\x15"'\''|json -b 3'
echo -e '"\\\x15"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x15"'\''|json -b 3'

echo '$ echo -e '\''"\\\x15"'\''|json -b 4'
echo -e '"\\\x15"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x15"'\''|json -b 4'

echo '$ echo -e '\''"\\\x15"'\''|json -b 5'
echo -e '"\\\x15"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x15"'\''|json -b 5'

echo '$ echo -e '\''"\\\x16"'\''|json -b 1'
echo -e '"\\\x16"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x16"'\''|json -b 1'

echo '$ echo -e '\''"\\\x16"'\''|json -b 2'
echo -e '"\\\x16"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x16"'\''|json -b 2'

echo '$ echo -e '\''"\\\x16"'\''|json -b 3'
echo -e '"\\\x16"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x16"'\''|json -b 3'

echo '$ echo -e '\''"\\\x16"'\''|json -b 4'
echo -e '"\\\x16"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x16"'\''|json -b 4'

echo '$ echo -e '\''"\\\x16"'\''|json -b 5'
echo -e '"\\\x16"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x16"'\''|json -b 5'

echo '$ echo -e '\''"\\\x17"'\''|json -b 1'
echo -e '"\\\x17"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x17"'\''|json -b 1'

echo '$ echo -e '\''"\\\x17"'\''|json -b 2'
echo -e '"\\\x17"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x17"'\''|json -b 2'

echo '$ echo -e '\''"\\\x17"'\''|json -b 3'
echo -e '"\\\x17"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x17"'\''|json -b 3'

echo '$ echo -e '\''"\\\x17"'\''|json -b 4'
echo -e '"\\\x17"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x17"'\''|json -b 4'

echo '$ echo -e '\''"\\\x17"'\''|json -b 5'
echo -e '"\\\x17"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x17"'\''|json -b 5'

echo '$ echo -e '\''"\\\x18"'\''|json -b 1'
echo -e '"\\\x18"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x18"'\''|json -b 1'

echo '$ echo -e '\''"\\\x18"'\''|json -b 2'
echo -e '"\\\x18"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x18"'\''|json -b 2'

echo '$ echo -e '\''"\\\x18"'\''|json -b 3'
echo -e '"\\\x18"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x18"'\''|json -b 3'

echo '$ echo -e '\''"\\\x18"'\''|json -b 4'
echo -e '"\\\x18"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x18"'\''|json -b 4'

echo '$ echo -e '\''"\\\x18"'\''|json -b 5'
echo -e '"\\\x18"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x18"'\''|json -b 5'

echo '$ echo -e '\''"\\\x19"'\''|json -b 1'
echo -e '"\\\x19"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x19"'\''|json -b 1'

echo '$ echo -e '\''"\\\x19"'\''|json -b 2'
echo -e '"\\\x19"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x19"'\''|json -b 2'

echo '$ echo -e '\''"\\\x19"'\''|json -b 3'
echo -e '"\\\x19"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x19"'\''|json -b 3'

echo '$ echo -e '\''"\\\x19"'\''|json -b 4'
echo -e '"\\\x19"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x19"'\''|json -b 4'

echo '$ echo -e '\''"\\\x19"'\''|json -b 5'
echo -e '"\\\x19"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x19"'\''|json -b 5'

echo '$ echo -e '\''"\\\x1a"'\''|json -b 1'
echo -e '"\\\x1a"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1a"'\''|json -b 1'

echo '$ echo -e '\''"\\\x1a"'\''|json -b 2'
echo -e '"\\\x1a"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1a"'\''|json -b 2'

echo '$ echo -e '\''"\\\x1a"'\''|json -b 3'
echo -e '"\\\x1a"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1a"'\''|json -b 3'

echo '$ echo -e '\''"\\\x1a"'\''|json -b 4'
echo -e '"\\\x1a"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1a"'\''|json -b 4'

echo '$ echo -e '\''"\\\x1a"'\''|json -b 5'
echo -e '"\\\x1a"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1a"'\''|json -b 5'

echo '$ echo -e '\''"\\\x1b"'\''|json -b 1'
echo -e '"\\\x1b"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1b"'\''|json -b 1'

echo '$ echo -e '\''"\\\x1b"'\''|json -b 2'
echo -e '"\\\x1b"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1b"'\''|json -b 2'

echo '$ echo -e '\''"\\\x1b"'\''|json -b 3'
echo -e '"\\\x1b"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1b"'\''|json -b 3'

echo '$ echo -e '\''"\\\x1b"'\''|json -b 4'
echo -e '"\\\x1b"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1b"'\''|json -b 4'

echo '$ echo -e '\''"\\\x1b"'\''|json -b 5'
echo -e '"\\\x1b"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1b"'\''|json -b 5'

echo '$ echo -e '\''"\\\x1c"'\''|json -b 1'
echo -e '"\\\x1c"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1c"'\''|json -b 1'

echo '$ echo -e '\''"\\\x1c"'\''|json -b 2'
echo -e '"\\\x1c"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1c"'\''|json -b 2'

echo '$ echo -e '\''"\\\x1c"'\''|json -b 3'
echo -e '"\\\x1c"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1c"'\''|json -b 3'

echo '$ echo -e '\''"\\\x1c"'\''|json -b 4'
echo -e '"\\\x1c"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1c"'\''|json -b 4'

echo '$ echo -e '\''"\\\x1c"'\''|json -b 5'
echo -e '"\\\x1c"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1c"'\''|json -b 5'

echo '$ echo -e '\''"\\\x1d"'\''|json -b 1'
echo -e '"\\\x1d"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1d"'\''|json -b 1'

echo '$ echo -e '\''"\\\x1d"'\''|json -b 2'
echo -e '"\\\x1d"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1d"'\''|json -b 2'

echo '$ echo -e '\''"\\\x1d"'\''|json -b 3'
echo -e '"\\\x1d"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1d"'\''|json -b 3'

echo '$ echo -e '\''"\\\x1d"'\''|json -b 4'
echo -e '"\\\x1d"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1d"'\''|json -b 4'

echo '$ echo -e '\''"\\\x1d"'\''|json -b 5'
echo -e '"\\\x1d"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1d"'\''|json -b 5'

echo '$ echo -e '\''"\\\x1e"'\''|json -b 1'
echo -e '"\\\x1e"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1e"'\''|json -b 1'

echo '$ echo -e '\''"\\\x1e"'\''|json -b 2'
echo -e '"\\\x1e"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1e"'\''|json -b 2'

echo '$ echo -e '\''"\\\x1e"'\''|json -b 3'
echo -e '"\\\x1e"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1e"'\''|json -b 3'

echo '$ echo -e '\''"\\\x1e"'\''|json -b 4'
echo -e '"\\\x1e"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1e"'\''|json -b 4'

echo '$ echo -e '\''"\\\x1e"'\''|json -b 5'
echo -e '"\\\x1e"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1e"'\''|json -b 5'

echo '$ echo -e '\''"\\\x1f"'\''|json -b 1'
echo -e '"\\\x1f"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1f"'\''|json -b 1'

echo '$ echo -e '\''"\\\x1f"'\''|json -b 2'
echo -e '"\\\x1f"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1f"'\''|json -b 2'

echo '$ echo -e '\''"\\\x1f"'\''|json -b 3'
echo -e '"\\\x1f"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1f"'\''|json -b 3'

echo '$ echo -e '\''"\\\x1f"'\''|json -b 4'
echo -e '"\\\x1f"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1f"'\''|json -b 4'

echo '$ echo -e '\''"\\\x1f"'\''|json -b 5'
echo -e '"\\\x1f"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\\\x1f"'\''|json -b 5'
)

