#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:46
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 46.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -Tc <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"array","args":[]}}]}]}'\'' && echo OK
OK
$ json -Tc <<< '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"array","args":[]}}]}]}}]}'\'' && echo OK
OK
$ json -Tc <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"array","args":[]}}]}'\'' && echo OK
OK
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]}]}'\''
json: error: <stdin>:1:99: attribute error: invalid "list" type object: duplicated '\''object'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:99: e":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":
json: error: <stdin>:1:99:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]}]}'\''
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[]}}]}'\''
json: error: <stdin>:1:74: attribute error: invalid "list" type object: duplicated '\''open array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:74: rgs":{"type":"dict","args":[]}},{"type":"array","args":{"type":"d
json: error: <stdin>:1:74:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[]}}]}'\''
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[]}]}]}'\''
json: error: <stdin>:1:76: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:76: s":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"
json: error: <stdin>:1:76:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[]}]}]}'\''
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[]}}]}]}'\'' && echo OK
json: error: <stdin>:1:70: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:145)
json: error: <stdin>:1:70: t","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"ty
json: error: <stdin>:1:70:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[]}}]}]}'\'' && echo OK
$ json -Tc -V <<< '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[]}}]}]}}]}'\'' && echo OK
json: error: <stdin>:1:116: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:191)
json: error: <stdin>:1:116: t","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"ty
json: error: <stdin>:1:116:                                 ^
command failed: json -Tc -V <<< '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[]}}]}]}}]}'\'' && echo OK
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"object","args":[]}}]}'\'' && echo OK
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:97)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":{"type":"dict","args":[]}},{"type
json: error: <stdin>:1:47:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"object","args":[]}}]}'\'' && echo OK
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":["object"]}]}'\'' && echo OK
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:74)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":{"type":"dict","args":[]}},{"type
json: error: <stdin>:1:47:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":["object"]}]}'\'' && echo OK
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":"object"}]}'\'' && echo OK
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:97)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":{"type":"dict","args":[]}},{"type
json: error: <stdin>:1:47:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":"object"}]}'\'' && echo OK
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}]}'\'' && echo OK
json: error: <stdin>:1:145: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
json: error: <stdin>:1:145: t","args":[{"name":"foo","type":{"type":"dict","args":[{"name":"b
json: error: <stdin>:1:145:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}]}'\'' && echo OK
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}'\'' && echo OK
json: error: <stdin>:1:97: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:47)
json: error: <stdin>:1:97: gs":[]}},{"type":"array","args":{"type":"dict","args":[{"name":"b
json: error: <stdin>:1:97:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}'\'' && echo OK
$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[{"name":"bar","type":"type"}]}]}]}'\'' && echo OK
json: error: <stdin>:1:100: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
json: error: <stdin>:1:100: ":[]}]},{"type":"array","args":[{"type":"dict","args":[{"name":"b
json: error: <stdin>:1:100:                                 ^
command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[{"name":"bar","type":"type"}]}]}]}'\'' && echo OK'
) -L 46.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -Tc <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"array","args":[]}}]}]}'\'' && echo OK'
json -Tc <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"array","args":[]}}]}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"array","args":[]}}]}]}'\'' && echo OK'

echo '$ json -Tc <<< '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"array","args":[]}}]}]}}]}'\'' && echo OK'
json -Tc <<< '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"array","args":[]}}]}]}}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc <<< '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"array","args":[]}}]}]}}]}'\'' && echo OK'

echo '$ json -Tc <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"array","args":[]}}]}'\'' && echo OK'
json -Tc <<< '{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"array","args":[]}}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"array","args":[]}}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]}]}'\'''
json -Tc -V <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]}]}' 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]}]}'\'''

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[]}}]}'\'''
json -Tc -V <<< '{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[]}}]}' 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[]}}]}'\'''

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[]}]}]}'\'''
json -Tc -V <<< '{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[]}]}]}' 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[]}]}]}'\'''

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[]}}]}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[]}}]}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[]}}]}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[]}}]}]}}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[]}}]}]}}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"type":"object","args":[{"name":"bar","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[]}}]}]}}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"object","args":[]}}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"object","args":[]}}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"object","args":[]}}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":["object"]}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":["object"]}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":["object"]}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":"object"}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":"object"}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":"object"}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[]}}]},{"type":"object","args":[{"name":"foo","type":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":{"type":"dict","args":[]}},{"type":"array","args":{"type":"dict","args":[{"name":"bar","type":"type"}]}}]}'\'' && echo OK'

echo '$ json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[{"name":"bar","type":"type"}]}]}]}'\'' && echo OK'
json -Tc -V <<< '{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[{"name":"bar","type":"type"}]}]}]}' && echo OK 2>&1 ||
echo 'command failed: json -Tc -V <<< '\''{"type":"list","args":[{"type":"array","args":[{"type":"dict","args":[]}]},{"type":"array","args":[{"type":"dict","args":[{"name":"bar","type":"type"}]}]}]}'\'' && echo OK'
)

