#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict-expr-quote
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr-quote.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }
$ json '\''`'\''
json: error: <stdin>:2:3: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:3: "c","type":"number"}],"expr":\n"`"}
json: error: <stdin>:2:3:                                  ^
command failed: json '\''`'\''
$ json '\''``'\''
json: error: <stdin>:2:2: meta error: invalid dict expression: empty quoted key
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"``"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''``'\''
$ json '\''```'\''
json: error: <stdin>:2:5: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:5: ","type":"number"}],"expr":\n"```"}
json: error: <stdin>:2:5:                                  ^
command failed: json '\''```'\''
$ json '\''````'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"````"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''````'\''
$ json '\''`a`'\''
100
$ json '\''`b`'\''
010
$ json '\''`c`'\''
001
$ json '\''`x`'\''
json: error: <stdin>:2:2: attribute error: invalid "dict" type object: expression key not found ("dict" is defined at 1:1)
json: error: <stdin>:2:2: :"c","type":"number"}],"expr":\n"`x`"}
json: error: <stdin>:2:2:                                  ^
command failed: json '\''`x`'\'''
) -L dict-expr-quote.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'$'\n"'"$1"'"}'|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr 's|^/attr/expr/bits=||p'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }'

echo '$ json '\''`'\'''
json '`' 2>&1 ||
echo 'command failed: json '\''`'\'''

echo '$ json '\''``'\'''
json '``' 2>&1 ||
echo 'command failed: json '\''``'\'''

echo '$ json '\''```'\'''
json '```' 2>&1 ||
echo 'command failed: json '\''```'\'''

echo '$ json '\''````'\'''
json '````' 2>&1 ||
echo 'command failed: json '\''````'\'''

echo '$ json '\''`a`'\'''
json '`a`' 2>&1 ||
echo 'command failed: json '\''`a`'\'''

echo '$ json '\''`b`'\'''
json '`b`' 2>&1 ||
echo 'command failed: json '\''`b`'\'''

echo '$ json '\''`c`'\'''
json '`c`' 2>&1 ||
echo 'command failed: json '\''`c`'\'''

echo '$ json '\''`x`'\'''
json '`x`' 2>&1 ||
echo 'command failed: json '\''`x`'\'''
)

