#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-basic-object-basic-val-object-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-basic-object-basic-val-object-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
{"baa":[{}],"buu":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
{"baa":[{}],"buu":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
{"baa":[{}],"buu":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
{"baa":[{}],"buu":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
{"baa":[{}],"buu":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
{"baa":[{}],"buu":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
{"baa":[{}],"buu":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
{"baa":null,"buu":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
{"baa":null,"buu":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
{"baa":null,"buu":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
{"baa":null,"buu":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
{"baa":null,"buu":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
{"baa":null,"buu":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
{"baa":null,"buu":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
{"baa":false,"buu":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
{"baa":false,"buu":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
{"baa":false,"buu":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
{"baa":false,"buu":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
{"baa":false,"buu":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
{"baa":false,"buu":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
{"baa":false,"buu":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
{"baa":456,"buu":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
{"baa":456,"buu":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
{"baa":456,"buu":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
{"baa":456,"buu":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
{"baa":456,"buu":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
{"baa":456,"buu":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
{"baa":456,"buu":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
{"baa":"bar","buu":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
{"baa":"bar","buu":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
{"baa":"bar","buu":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
{"baa":"bar","buu":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
{"baa":"bar","buu":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
{"baa":"bar","buu":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
{"baa":"bar","buu":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
{"baa":{},"buu":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
{"baa":{},"buu":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
{"baa":{},"buu":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
{"baa":{},"buu":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
{"baa":{},"buu":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
{"baa":{},"buu":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
{"baa":{},"buu":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
{"baa":[],"buu":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
{"baa":[],"buu":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
{"baa":[],"buu":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
{"baa":[],"buu":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
{"baa":[],"buu":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
{"baa":[],"buu":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
{"baa":[],"buu":[]}
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
{"baa":[{}],"buu":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
{"baa":[{}],"buu":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
{"baa":[{}],"buu":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
{"baa":[{}],"buu":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
{"baa":[{}],"buu":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
{"baa":[{}],"buu":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
{"baa":[{}],"buu":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
{"baa":null,"buu":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
{"baa":null,"buu":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
{"baa":null,"buu":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
{"baa":null,"buu":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
{"baa":null,"buu":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
{"baa":null,"buu":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
{"baa":null,"buu":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
{"baa":false,"buu":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
{"baa":false,"buu":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
{"baa":false,"buu":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
{"baa":false,"buu":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
{"baa":false,"buu":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
{"baa":false,"buu":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
{"baa":false,"buu":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
{"baa":456,"buu":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
{"baa":456,"buu":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
{"baa":456,"buu":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
{"baa":456,"buu":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
{"baa":456,"buu":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
{"baa":456,"buu":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
{"baa":456,"buu":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
{"baa":"bar","buu":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
{"baa":"bar","buu":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
{"baa":"bar","buu":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
{"baa":"bar","buu":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
{"baa":"bar","buu":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
{"baa":"bar","buu":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
{"baa":"bar","buu":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
{"baa":{},"buu":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
{"baa":{},"buu":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
{"baa":{},"buu":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
{"baa":{},"buu":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
{"baa":{},"buu":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
{"baa":{},"buu":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
{"baa":{},"buu":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
{"baa":[],"buu":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
{"baa":[],"buu":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
{"baa":[],"buu":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
{"baa":[],"buu":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
{"baa":[],"buu":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
{"baa":[],"buu":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
{"baa":[],"buu":[]}
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[{}],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":456,"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"bar","buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{},"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[],"buu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
) -L list-basic-object-basic-val-object-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[],"buu":[]}'\'''
)

