#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:type
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L type.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"object","foo":null}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":null}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":null}'\''
$ json <<< '\''{"type":"object","foo":false}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":false}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":false}'\''
$ json <<< '\''{"type":"object","foo":true}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":true}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":true}'\''
$ json <<< '\''{"type":"object","foo":123}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":123}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":123}'\''
$ json <<< '\''{"type":"object","foo":"foo"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"foo"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"foo"}'\''
$ json <<< '\''{"type":"object","foo":"type"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"type"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"type"}'\''
$ json <<< '\''{"type":"object","foo":"null"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"null"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"null"}'\''
$ json <<< '\''{"type":"object","foo":"boolean"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"boolean"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"boolean"}'\''
$ json <<< '\''{"type":"object","foo":"number"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"number"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"number"}'\''
$ json <<< '\''{"type":"object","foo":"string"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"string"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"string"}'\''
$ json <<< '\''{"type":"object","foo":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"object"}'\''
$ json <<< '\''{"type":"object","foo":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"array"}'\''
$ json <<< '\''{"type":"object","foo":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"list"}'\''
$ json <<< '\''{"type":"object","foo":"dict"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":"dict"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":"dict"}'\''
$ json <<< '\''{"type":"object","foo":{}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":{}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":{}}'\''
$ json <<< '\''{"type":"object","foo":{"foo":"bar"}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":{"foo":"ba
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"object","foo":[]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":[]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":[]}'\''
$ json <<< '\''{"type":"object","foo":["foo","bar"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":["foo","ba
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":["foo","bar"]}'\''
$ json <<< '\''{"type":"object","foo":[{"name":"baz","type":"object"}]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":[{"name":"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":[{"name":"baz","type":"object"}]}'\''
$ json <<< '\''{"type":"object","foo":["boolean","number"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"object","foo":["boolean"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"object","foo":["boolean","number"]}'\''
$ json <<< '\''{"type":"object","args":null}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":null}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":null}'\''
$ json <<< '\''{"type":"object","args":false}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":false}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":false}'\''
$ json <<< '\''{"type":"object","args":true}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":true}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":true}'\''
$ json <<< '\''{"type":"object","args":123}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":123}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":123}'\''
$ json <<< '\''{"type":"object","args":"foo"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"foo"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"foo"}'\''
$ json <<< '\''{"type":"object","args":"type"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"type"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"type"}'\''
$ json <<< '\''{"type":"object","args":"null"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"null"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"null"}'\''
$ json <<< '\''{"type":"object","args":"boolean"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"boolean"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"boolean"}'\''
$ json <<< '\''{"type":"object","args":"number"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"number"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"number"}'\''
$ json <<< '\''{"type":"object","args":"string"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"string"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"string"}'\''
$ json <<< '\''{"type":"object","args":"object"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"object"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"object"}'\''
$ json <<< '\''{"type":"object","args":"array"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"array"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"array"}'\''
$ json <<< '\''{"type":"object","args":"list"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"list"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"list"}'\''
$ json <<< '\''{"type":"object","args":"dict"}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":"dict"}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":"dict"}'\''
$ json <<< '\''{"type":"object","args":{}}'\''
json: error: <stdin>:1:25: meta error: empty objects are not allowed
json: error: <stdin>:1:25: {"type":"object","args":{}}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":{}}'\''
$ json <<< '\''{"type":"object","args":{"foo":"bar"}}'\''
json: error: <stdin>:1:26: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:26: {"type":"object","args":{"foo":"bar"}}
json: error: <stdin>:1:26:                          ^
command failed: json <<< '\''{"type":"object","args":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"object","args":[]}'\''
{
    "type": "object",
    "args": []
}
$ json <<< '\''{"type":"object","args":["foo","bar"]}'\''
json: error: <stdin>:1:26: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:26: {"type":"object","args":["foo","bar"]}
json: error: <stdin>:1:26:                          ^
command failed: json <<< '\''{"type":"object","args":["foo","bar"]}'\''
$ json <<< '\''{"type":"object","args":[{"name":"baz","type":"object"}]}'\''
{
    "type": "object",
    "args": [
        {
            "name": "baz",
            "type": "object"
        }
    ]
}
$ json <<< '\''{"type":"object","args":["boolean","number"]}'\''
json: error: <stdin>:1:25: meta error: invalid "object" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:25: {"type":"object","args":["boolean","number"]}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"object","args":["boolean","number"]}'\''
$ json <<< '\''{"type":"array","foo":null}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":null}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":null}'\''
$ json <<< '\''{"type":"array","foo":false}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":false}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":false}'\''
$ json <<< '\''{"type":"array","foo":true}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":true}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":true}'\''
$ json <<< '\''{"type":"array","foo":123}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":123}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":123}'\''
$ json <<< '\''{"type":"array","foo":"foo"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"foo"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"foo"}'\''
$ json <<< '\''{"type":"array","foo":"type"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"type"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"type"}'\''
$ json <<< '\''{"type":"array","foo":"null"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"null"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"null"}'\''
$ json <<< '\''{"type":"array","foo":"boolean"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"boolean"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"boolean"}'\''
$ json <<< '\''{"type":"array","foo":"number"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"number"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"number"}'\''
$ json <<< '\''{"type":"array","foo":"string"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"string"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"string"}'\''
$ json <<< '\''{"type":"array","foo":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"object"}'\''
$ json <<< '\''{"type":"array","foo":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"array"}'\''
$ json <<< '\''{"type":"array","foo":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"list"}'\''
$ json <<< '\''{"type":"array","foo":"dict"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":"dict"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":"dict"}'\''
$ json <<< '\''{"type":"array","foo":{}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":{}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":{}}'\''
$ json <<< '\''{"type":"array","foo":{"foo":"bar"}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":{"foo":"bar
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"array","foo":[]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":[]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":[]}'\''
$ json <<< '\''{"type":"array","foo":["foo","bar"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":["foo","bar
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":["foo","bar"]}'\''
$ json <<< '\''{"type":"array","foo":[{"name":"baz","type":"object"}]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":[{"name":"b
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":[{"name":"baz","type":"object"}]}'\''
$ json <<< '\''{"type":"array","foo":["boolean","number"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"array","foo":["boolean",
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"array","foo":["boolean","number"]}'\''
$ json <<< '\''{"type":"array","args":null}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":null}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":null}'\''
$ json <<< '\''{"type":"array","args":false}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":false}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":false}'\''
$ json <<< '\''{"type":"array","args":true}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":true}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":true}'\''
$ json <<< '\''{"type":"array","args":123}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":123}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":123}'\''
$ json <<< '\''{"type":"array","args":"foo"}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":"foo"}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":"foo"}'\''
$ json <<< '\''{"type":"array","args":"type"}'\''
{
    "type": "array",
    "args": "type"
}
$ json <<< '\''{"type":"array","args":"null"}'\''
{
    "type": "array",
    "args": "null"
}
$ json <<< '\''{"type":"array","args":"boolean"}'\''
{
    "type": "array",
    "args": "boolean"
}
$ json <<< '\''{"type":"array","args":"number"}'\''
{
    "type": "array",
    "args": "number"
}
$ json <<< '\''{"type":"array","args":"string"}'\''
{
    "type": "array",
    "args": "string"
}
$ json <<< '\''{"type":"array","args":"object"}'\''
{
    "type": "array",
    "args": "object"
}
$ json <<< '\''{"type":"array","args":"array"}'\''
{
    "type": "array",
    "args": "array"
}
$ json <<< '\''{"type":"array","args":"list"}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":"list"}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":"list"}'\''
$ json <<< '\''{"type":"array","args":"dict"}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":"dict"}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":"dict"}'\''
$ json <<< '\''{"type":"array","args":{}}'\''
json: error: <stdin>:1:24: meta error: empty objects are not allowed
json: error: <stdin>:1:24: {"type":"array","args":{}}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":{}}'\''
$ json <<< '\''{"type":"array","args":{"foo":"bar"}}'\''
json: error: <stdin>:1:25: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:25: {"type":"array","args":{"foo":"bar"}}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"array","args":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"array","args":[]}'\''
{
    "type": "array",
    "args": []
}
$ json <<< '\''{"type":"array","args":["foo","bar"]}'\''
json: error: <stdin>:1:25: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:25: {"type":"array","args":["foo","bar"]}
json: error: <stdin>:1:25:                         ^
command failed: json <<< '\''{"type":"array","args":["foo","bar"]}'\''
$ json <<< '\''{"type":"array","args":[{"name":"baz","type":"object"}]}'\''
json: error: <stdin>:1:24: meta error: invalid "array" object: value of "args" must be a type or an array of types
json: error: <stdin>:1:24: {"type":"array","args":[{"name":"baz","type":"object"}]}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"array","args":[{"name":"baz","type":"object"}]}'\''
$ json <<< '\''{"type":"array","args":["boolean","number"]}'\''
{
    "type": "array",
    "args": [
        "boolean",
        "number"
    ]
}
$ json <<< '\''{"type":"list","foo":null}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":null}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":null}'\''
$ json <<< '\''{"type":"list","foo":false}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":false}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":false}'\''
$ json <<< '\''{"type":"list","foo":true}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":true}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":true}'\''
$ json <<< '\''{"type":"list","foo":123}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":123}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":123}'\''
$ json <<< '\''{"type":"list","foo":"foo"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"foo"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"foo"}'\''
$ json <<< '\''{"type":"list","foo":"type"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"type"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"type"}'\''
$ json <<< '\''{"type":"list","foo":"null"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"null"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"null"}'\''
$ json <<< '\''{"type":"list","foo":"boolean"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"boolean"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"boolean"}'\''
$ json <<< '\''{"type":"list","foo":"number"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"number"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"number"}'\''
$ json <<< '\''{"type":"list","foo":"string"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"string"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"string"}'\''
$ json <<< '\''{"type":"list","foo":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"object"}'\''
$ json <<< '\''{"type":"list","foo":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"array"}'\''
$ json <<< '\''{"type":"list","foo":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"list"}'\''
$ json <<< '\''{"type":"list","foo":"dict"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":"dict"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":"dict"}'\''
$ json <<< '\''{"type":"list","foo":{}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":{}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":{}}'\''
$ json <<< '\''{"type":"list","foo":{"foo":"bar"}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":{"foo":"bar"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"list","foo":[]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":[]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":[]}'\''
$ json <<< '\''{"type":"list","foo":["foo","bar"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":["foo","bar"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":["foo","bar"]}'\''
$ json <<< '\''{"type":"list","foo":[{"name":"baz","type":"object"}]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":[{"name":"ba
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":[{"name":"baz","type":"object"}]}'\''
$ json <<< '\''{"type":"list","foo":["boolean","number"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"list","foo":["boolean","
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"list","foo":["boolean","number"]}'\''
$ json <<< '\''{"type":"list","args":null}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":null}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":null}'\''
$ json <<< '\''{"type":"list","args":false}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":false}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":false}'\''
$ json <<< '\''{"type":"list","args":true}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":true}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":true}'\''
$ json <<< '\''{"type":"list","args":123}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":123}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":123}'\''
$ json <<< '\''{"type":"list","args":"foo"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"foo"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"foo"}'\''
$ json <<< '\''{"type":"list","args":"type"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"type"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"type"}'\''
$ json <<< '\''{"type":"list","args":"null"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"null"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"null"}'\''
$ json <<< '\''{"type":"list","args":"boolean"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"boolean"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"boolean"}'\''
$ json <<< '\''{"type":"list","args":"number"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"number"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"number"}'\''
$ json <<< '\''{"type":"list","args":"string"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"string"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"string"}'\''
$ json <<< '\''{"type":"list","args":"object"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"object"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"object"}'\''
$ json <<< '\''{"type":"list","args":"array"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"array"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"array"}'\''
$ json <<< '\''{"type":"list","args":"list"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"list"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"list"}'\''
$ json <<< '\''{"type":"list","args":"dict"}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":"dict"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":"dict"}'\''
$ json <<< '\''{"type":"list","args":{}}'\''
json: error: <stdin>:1:23: meta error: empty objects are not allowed
json: error: <stdin>:1:23: {"type":"list","args":{}}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":{}}'\''
$ json <<< '\''{"type":"list","args":{"foo":"bar"}}'\''
json: error: <stdin>:1:24: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:24: {"type":"list","args":{"foo":"bar"}}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"list","args":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"list","args":[]}'\''
{
    "type": "list",
    "args": [],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["foo","bar"]}'\''
json: error: <stdin>:1:24: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:24: {"type":"list","args":["foo","bar"]}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"list","args":["foo","bar"]}'\''
$ json <<< '\''{"type":"list","args":[{"name":"baz","type":"object"}]}'\''
json: error: <stdin>:1:23: meta error: invalid "list" object: value of "args" must be an array of types
json: error: <stdin>:1:23: {"type":"list","args":[{"name":"baz","type":"object"}]}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"list","args":[{"name":"baz","type":"object"}]}'\''
$ json <<< '\''{"type":"list","args":["boolean","number"]}'\''
{
    "type": "list",
    "args": [
        "boolean",
        "number"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": null,
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": "number",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"dict","foo":null}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":null}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":null}'\''
$ json <<< '\''{"type":"dict","foo":false}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":false}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":false}'\''
$ json <<< '\''{"type":"dict","foo":true}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":true}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":true}'\''
$ json <<< '\''{"type":"dict","foo":123}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":123}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":123}'\''
$ json <<< '\''{"type":"dict","foo":"foo"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"foo"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"foo"}'\''
$ json <<< '\''{"type":"dict","foo":"type"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"type"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"type"}'\''
$ json <<< '\''{"type":"dict","foo":"null"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"null"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"null"}'\''
$ json <<< '\''{"type":"dict","foo":"boolean"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"boolean"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"boolean"}'\''
$ json <<< '\''{"type":"dict","foo":"number"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"number"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"number"}'\''
$ json <<< '\''{"type":"dict","foo":"string"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"string"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"string"}'\''
$ json <<< '\''{"type":"dict","foo":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"object"}'\''
$ json <<< '\''{"type":"dict","foo":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"array"}'\''
$ json <<< '\''{"type":"dict","foo":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"list"}'\''
$ json <<< '\''{"type":"dict","foo":"dict"}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":"dict"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":"dict"}'\''
$ json <<< '\''{"type":"dict","foo":{}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":{}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":{}}'\''
$ json <<< '\''{"type":"dict","foo":{"foo":"bar"}}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":{"foo":"bar"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"dict","foo":[]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":[]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":[]}'\''
$ json <<< '\''{"type":"dict","foo":["foo","bar"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":["foo","bar"
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":["foo","bar"]}'\''
$ json <<< '\''{"type":"dict","foo":[{"name":"baz","type":"object"}]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":[{"name":"ba
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":[{"name":"baz","type":"object"}]}'\''
$ json <<< '\''{"type":"dict","foo":["boolean","number"]}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of second argument is not "args"
json: error: <stdin>:1:1: {"type":"dict","foo":["boolean","
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","foo":["boolean","number"]}'\''
$ json <<< '\''{"type":"dict","args":null}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":null}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":null}'\''
$ json <<< '\''{"type":"dict","args":false}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":false}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":false}'\''
$ json <<< '\''{"type":"dict","args":true}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":true}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":true}'\''
$ json <<< '\''{"type":"dict","args":123}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":123}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":123}'\''
$ json <<< '\''{"type":"dict","args":"foo"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"foo"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"foo"}'\''
$ json <<< '\''{"type":"dict","args":"type"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"type"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"type"}'\''
$ json <<< '\''{"type":"dict","args":"null"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"null"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"null"}'\''
$ json <<< '\''{"type":"dict","args":"boolean"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"boolean"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"boolean"}'\''
$ json <<< '\''{"type":"dict","args":"number"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"number"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"number"}'\''
$ json <<< '\''{"type":"dict","args":"string"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"string"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"string"}'\''
$ json <<< '\''{"type":"dict","args":"object"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"object"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"object"}'\''
$ json <<< '\''{"type":"dict","args":"array"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"array"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"array"}'\''
$ json <<< '\''{"type":"dict","args":"list"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"list"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"list"}'\''
$ json <<< '\''{"type":"dict","args":"dict"}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":"dict"}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":"dict"}'\''
$ json <<< '\''{"type":"dict","args":{}}'\''
json: error: <stdin>:1:23: meta error: empty objects are not allowed
json: error: <stdin>:1:23: {"type":"dict","args":{}}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":{}}'\''
$ json <<< '\''{"type":"dict","args":{"foo":"bar"}}'\''
json: error: <stdin>:1:24: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:24: {"type":"dict","args":{"foo":"bar"}}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"dict","args":{"foo":"bar"}}'\''
$ json <<< '\''{"type":"dict","args":[]}'\''
{
    "type": "dict",
    "args": [],
    "expr": null,
    "attr": {
        "args": null,
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":["foo","bar"]}'\''
json: error: <stdin>:1:24: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:24: {"type":"dict","args":["foo","bar"]}
json: error: <stdin>:1:24:                        ^
command failed: json <<< '\''{"type":"dict","args":["foo","bar"]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"object"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "object"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":["boolean","number"]}'\''
json: error: <stdin>:1:23: meta error: invalid "dict" object: value of "args" must be an array of "name" objects
json: error: <stdin>:1:23: {"type":"dict","args":["boolean","number"]}
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''{"type":"dict","args":["boolean","number"]}'\'''
) -L type.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"object","foo":null}'\'''
json <<< '{"type":"object","foo":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":null}'\'''

echo '$ json <<< '\''{"type":"object","foo":false}'\'''
json <<< '{"type":"object","foo":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":false}'\'''

echo '$ json <<< '\''{"type":"object","foo":true}'\'''
json <<< '{"type":"object","foo":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":true}'\'''

echo '$ json <<< '\''{"type":"object","foo":123}'\'''
json <<< '{"type":"object","foo":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":123}'\'''

echo '$ json <<< '\''{"type":"object","foo":"foo"}'\'''
json <<< '{"type":"object","foo":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"foo"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"type"}'\'''
json <<< '{"type":"object","foo":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"type"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"null"}'\'''
json <<< '{"type":"object","foo":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"null"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"boolean"}'\'''
json <<< '{"type":"object","foo":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"boolean"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"number"}'\'''
json <<< '{"type":"object","foo":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"number"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"string"}'\'''
json <<< '{"type":"object","foo":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"string"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"object"}'\'''
json <<< '{"type":"object","foo":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"object"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"array"}'\'''
json <<< '{"type":"object","foo":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"array"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"list"}'\'''
json <<< '{"type":"object","foo":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"list"}'\'''

echo '$ json <<< '\''{"type":"object","foo":"dict"}'\'''
json <<< '{"type":"object","foo":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":"dict"}'\'''

echo '$ json <<< '\''{"type":"object","foo":{}}'\'''
json <<< '{"type":"object","foo":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":{}}'\'''

echo '$ json <<< '\''{"type":"object","foo":{"foo":"bar"}}'\'''
json <<< '{"type":"object","foo":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"object","foo":[]}'\'''
json <<< '{"type":"object","foo":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":[]}'\'''

echo '$ json <<< '\''{"type":"object","foo":["foo","bar"]}'\'''
json <<< '{"type":"object","foo":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"object","foo":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"object","foo":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"object","foo":["boolean","number"]}'\'''
json <<< '{"type":"object","foo":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","foo":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"object","args":null}'\'''
json <<< '{"type":"object","args":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":null}'\'''

echo '$ json <<< '\''{"type":"object","args":false}'\'''
json <<< '{"type":"object","args":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":false}'\'''

echo '$ json <<< '\''{"type":"object","args":true}'\'''
json <<< '{"type":"object","args":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":true}'\'''

echo '$ json <<< '\''{"type":"object","args":123}'\'''
json <<< '{"type":"object","args":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":123}'\'''

echo '$ json <<< '\''{"type":"object","args":"foo"}'\'''
json <<< '{"type":"object","args":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"foo"}'\'''

echo '$ json <<< '\''{"type":"object","args":"type"}'\'''
json <<< '{"type":"object","args":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"type"}'\'''

echo '$ json <<< '\''{"type":"object","args":"null"}'\'''
json <<< '{"type":"object","args":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"null"}'\'''

echo '$ json <<< '\''{"type":"object","args":"boolean"}'\'''
json <<< '{"type":"object","args":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"boolean"}'\'''

echo '$ json <<< '\''{"type":"object","args":"number"}'\'''
json <<< '{"type":"object","args":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"number"}'\'''

echo '$ json <<< '\''{"type":"object","args":"string"}'\'''
json <<< '{"type":"object","args":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"string"}'\'''

echo '$ json <<< '\''{"type":"object","args":"object"}'\'''
json <<< '{"type":"object","args":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"object"}'\'''

echo '$ json <<< '\''{"type":"object","args":"array"}'\'''
json <<< '{"type":"object","args":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"array"}'\'''

echo '$ json <<< '\''{"type":"object","args":"list"}'\'''
json <<< '{"type":"object","args":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"list"}'\'''

echo '$ json <<< '\''{"type":"object","args":"dict"}'\'''
json <<< '{"type":"object","args":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":"dict"}'\'''

echo '$ json <<< '\''{"type":"object","args":{}}'\'''
json <<< '{"type":"object","args":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":{}}'\'''

echo '$ json <<< '\''{"type":"object","args":{"foo":"bar"}}'\'''
json <<< '{"type":"object","args":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"object","args":[]}'\'''
json <<< '{"type":"object","args":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":[]}'\'''

echo '$ json <<< '\''{"type":"object","args":["foo","bar"]}'\'''
json <<< '{"type":"object","args":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"object","args":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"object","args":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"object","args":["boolean","number"]}'\'''
json <<< '{"type":"object","args":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"object","args":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"array","foo":null}'\'''
json <<< '{"type":"array","foo":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":null}'\'''

echo '$ json <<< '\''{"type":"array","foo":false}'\'''
json <<< '{"type":"array","foo":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":false}'\'''

echo '$ json <<< '\''{"type":"array","foo":true}'\'''
json <<< '{"type":"array","foo":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":true}'\'''

echo '$ json <<< '\''{"type":"array","foo":123}'\'''
json <<< '{"type":"array","foo":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":123}'\'''

echo '$ json <<< '\''{"type":"array","foo":"foo"}'\'''
json <<< '{"type":"array","foo":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"foo"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"type"}'\'''
json <<< '{"type":"array","foo":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"type"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"null"}'\'''
json <<< '{"type":"array","foo":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"null"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"boolean"}'\'''
json <<< '{"type":"array","foo":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"boolean"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"number"}'\'''
json <<< '{"type":"array","foo":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"number"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"string"}'\'''
json <<< '{"type":"array","foo":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"string"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"object"}'\'''
json <<< '{"type":"array","foo":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"object"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"array"}'\'''
json <<< '{"type":"array","foo":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"array"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"list"}'\'''
json <<< '{"type":"array","foo":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"list"}'\'''

echo '$ json <<< '\''{"type":"array","foo":"dict"}'\'''
json <<< '{"type":"array","foo":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":"dict"}'\'''

echo '$ json <<< '\''{"type":"array","foo":{}}'\'''
json <<< '{"type":"array","foo":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":{}}'\'''

echo '$ json <<< '\''{"type":"array","foo":{"foo":"bar"}}'\'''
json <<< '{"type":"array","foo":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"array","foo":[]}'\'''
json <<< '{"type":"array","foo":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":[]}'\'''

echo '$ json <<< '\''{"type":"array","foo":["foo","bar"]}'\'''
json <<< '{"type":"array","foo":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"array","foo":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"array","foo":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"array","foo":["boolean","number"]}'\'''
json <<< '{"type":"array","foo":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","foo":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":null}'\'''
json <<< '{"type":"array","args":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":null}'\'''

echo '$ json <<< '\''{"type":"array","args":false}'\'''
json <<< '{"type":"array","args":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":false}'\'''

echo '$ json <<< '\''{"type":"array","args":true}'\'''
json <<< '{"type":"array","args":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":true}'\'''

echo '$ json <<< '\''{"type":"array","args":123}'\'''
json <<< '{"type":"array","args":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":123}'\'''

echo '$ json <<< '\''{"type":"array","args":"foo"}'\'''
json <<< '{"type":"array","args":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"foo"}'\'''

echo '$ json <<< '\''{"type":"array","args":"type"}'\'''
json <<< '{"type":"array","args":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"type"}'\'''

echo '$ json <<< '\''{"type":"array","args":"null"}'\'''
json <<< '{"type":"array","args":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"null"}'\'''

echo '$ json <<< '\''{"type":"array","args":"boolean"}'\'''
json <<< '{"type":"array","args":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"boolean"}'\'''

echo '$ json <<< '\''{"type":"array","args":"number"}'\'''
json <<< '{"type":"array","args":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"number"}'\'''

echo '$ json <<< '\''{"type":"array","args":"string"}'\'''
json <<< '{"type":"array","args":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"string"}'\'''

echo '$ json <<< '\''{"type":"array","args":"object"}'\'''
json <<< '{"type":"array","args":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"object"}'\'''

echo '$ json <<< '\''{"type":"array","args":"array"}'\'''
json <<< '{"type":"array","args":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"array"}'\'''

echo '$ json <<< '\''{"type":"array","args":"list"}'\'''
json <<< '{"type":"array","args":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"list"}'\'''

echo '$ json <<< '\''{"type":"array","args":"dict"}'\'''
json <<< '{"type":"array","args":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":"dict"}'\'''

echo '$ json <<< '\''{"type":"array","args":{}}'\'''
json <<< '{"type":"array","args":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"foo":"bar"}}'\'''
json <<< '{"type":"array","args":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"array","args":[]}'\'''
json <<< '{"type":"array","args":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[]}'\'''

echo '$ json <<< '\''{"type":"array","args":["foo","bar"]}'\'''
json <<< '{"type":"array","args":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"array","args":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","number"]}'\'''
json <<< '{"type":"array","args":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"list","foo":null}'\'''
json <<< '{"type":"list","foo":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":null}'\'''

echo '$ json <<< '\''{"type":"list","foo":false}'\'''
json <<< '{"type":"list","foo":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":false}'\'''

echo '$ json <<< '\''{"type":"list","foo":true}'\'''
json <<< '{"type":"list","foo":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":true}'\'''

echo '$ json <<< '\''{"type":"list","foo":123}'\'''
json <<< '{"type":"list","foo":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":123}'\'''

echo '$ json <<< '\''{"type":"list","foo":"foo"}'\'''
json <<< '{"type":"list","foo":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"foo"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"type"}'\'''
json <<< '{"type":"list","foo":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"type"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"null"}'\'''
json <<< '{"type":"list","foo":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"null"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"boolean"}'\'''
json <<< '{"type":"list","foo":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"boolean"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"number"}'\'''
json <<< '{"type":"list","foo":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"number"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"string"}'\'''
json <<< '{"type":"list","foo":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"string"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"object"}'\'''
json <<< '{"type":"list","foo":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"object"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"array"}'\'''
json <<< '{"type":"list","foo":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"array"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"list"}'\'''
json <<< '{"type":"list","foo":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"list"}'\'''

echo '$ json <<< '\''{"type":"list","foo":"dict"}'\'''
json <<< '{"type":"list","foo":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":"dict"}'\'''

echo '$ json <<< '\''{"type":"list","foo":{}}'\'''
json <<< '{"type":"list","foo":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":{}}'\'''

echo '$ json <<< '\''{"type":"list","foo":{"foo":"bar"}}'\'''
json <<< '{"type":"list","foo":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"list","foo":[]}'\'''
json <<< '{"type":"list","foo":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":[]}'\'''

echo '$ json <<< '\''{"type":"list","foo":["foo","bar"]}'\'''
json <<< '{"type":"list","foo":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"list","foo":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"list","foo":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"list","foo":["boolean","number"]}'\'''
json <<< '{"type":"list","foo":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","foo":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":null}'\'''
json <<< '{"type":"list","args":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":null}'\'''

echo '$ json <<< '\''{"type":"list","args":false}'\'''
json <<< '{"type":"list","args":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":false}'\'''

echo '$ json <<< '\''{"type":"list","args":true}'\'''
json <<< '{"type":"list","args":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":true}'\'''

echo '$ json <<< '\''{"type":"list","args":123}'\'''
json <<< '{"type":"list","args":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":123}'\'''

echo '$ json <<< '\''{"type":"list","args":"foo"}'\'''
json <<< '{"type":"list","args":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"foo"}'\'''

echo '$ json <<< '\''{"type":"list","args":"type"}'\'''
json <<< '{"type":"list","args":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"type"}'\'''

echo '$ json <<< '\''{"type":"list","args":"null"}'\'''
json <<< '{"type":"list","args":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"null"}'\'''

echo '$ json <<< '\''{"type":"list","args":"boolean"}'\'''
json <<< '{"type":"list","args":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"boolean"}'\'''

echo '$ json <<< '\''{"type":"list","args":"number"}'\'''
json <<< '{"type":"list","args":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"number"}'\'''

echo '$ json <<< '\''{"type":"list","args":"string"}'\'''
json <<< '{"type":"list","args":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"string"}'\'''

echo '$ json <<< '\''{"type":"list","args":"object"}'\'''
json <<< '{"type":"list","args":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"object"}'\'''

echo '$ json <<< '\''{"type":"list","args":"array"}'\'''
json <<< '{"type":"list","args":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"array"}'\'''

echo '$ json <<< '\''{"type":"list","args":"list"}'\'''
json <<< '{"type":"list","args":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"list"}'\'''

echo '$ json <<< '\''{"type":"list","args":"dict"}'\'''
json <<< '{"type":"list","args":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":"dict"}'\'''

echo '$ json <<< '\''{"type":"list","args":{}}'\'''
json <<< '{"type":"list","args":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":{}}'\'''

echo '$ json <<< '\''{"type":"list","args":{"foo":"bar"}}'\'''
json <<< '{"type":"list","args":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"list","args":[]}'\'''
json <<< '{"type":"list","args":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[]}'\'''

echo '$ json <<< '\''{"type":"list","args":["foo","bar"]}'\'''
json <<< '{"type":"list","args":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"list","args":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","number"]}'\'''
json <<< '{"type":"list","args":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"dict","foo":null}'\'''
json <<< '{"type":"dict","foo":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":null}'\'''

echo '$ json <<< '\''{"type":"dict","foo":false}'\'''
json <<< '{"type":"dict","foo":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":false}'\'''

echo '$ json <<< '\''{"type":"dict","foo":true}'\'''
json <<< '{"type":"dict","foo":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":true}'\'''

echo '$ json <<< '\''{"type":"dict","foo":123}'\'''
json <<< '{"type":"dict","foo":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":123}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"foo"}'\'''
json <<< '{"type":"dict","foo":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"foo"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"type"}'\'''
json <<< '{"type":"dict","foo":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"type"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"null"}'\'''
json <<< '{"type":"dict","foo":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"null"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"boolean"}'\'''
json <<< '{"type":"dict","foo":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"boolean"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"number"}'\'''
json <<< '{"type":"dict","foo":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"number"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"string"}'\'''
json <<< '{"type":"dict","foo":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"string"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"object"}'\'''
json <<< '{"type":"dict","foo":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"object"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"array"}'\'''
json <<< '{"type":"dict","foo":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"array"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"list"}'\'''
json <<< '{"type":"dict","foo":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"list"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":"dict"}'\'''
json <<< '{"type":"dict","foo":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":"dict"}'\'''

echo '$ json <<< '\''{"type":"dict","foo":{}}'\'''
json <<< '{"type":"dict","foo":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":{}}'\'''

echo '$ json <<< '\''{"type":"dict","foo":{"foo":"bar"}}'\'''
json <<< '{"type":"dict","foo":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"dict","foo":[]}'\'''
json <<< '{"type":"dict","foo":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":[]}'\'''

echo '$ json <<< '\''{"type":"dict","foo":["foo","bar"]}'\'''
json <<< '{"type":"dict","foo":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"dict","foo":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"dict","foo":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"dict","foo":["boolean","number"]}'\'''
json <<< '{"type":"dict","foo":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","foo":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"dict","args":null}'\'''
json <<< '{"type":"dict","args":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":null}'\'''

echo '$ json <<< '\''{"type":"dict","args":false}'\'''
json <<< '{"type":"dict","args":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":false}'\'''

echo '$ json <<< '\''{"type":"dict","args":true}'\'''
json <<< '{"type":"dict","args":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":true}'\'''

echo '$ json <<< '\''{"type":"dict","args":123}'\'''
json <<< '{"type":"dict","args":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":123}'\'''

echo '$ json <<< '\''{"type":"dict","args":"foo"}'\'''
json <<< '{"type":"dict","args":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"foo"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"type"}'\'''
json <<< '{"type":"dict","args":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"type"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"null"}'\'''
json <<< '{"type":"dict","args":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"null"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"boolean"}'\'''
json <<< '{"type":"dict","args":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"boolean"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"number"}'\'''
json <<< '{"type":"dict","args":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"number"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"string"}'\'''
json <<< '{"type":"dict","args":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"string"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"object"}'\'''
json <<< '{"type":"dict","args":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"object"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"array"}'\'''
json <<< '{"type":"dict","args":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"array"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"list"}'\'''
json <<< '{"type":"dict","args":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"list"}'\'''

echo '$ json <<< '\''{"type":"dict","args":"dict"}'\'''
json <<< '{"type":"dict","args":"dict"}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":"dict"}'\'''

echo '$ json <<< '\''{"type":"dict","args":{}}'\'''
json <<< '{"type":"dict","args":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":{}}'\'''

echo '$ json <<< '\''{"type":"dict","args":{"foo":"bar"}}'\'''
json <<< '{"type":"dict","args":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"type":"dict","args":[]}'\'''
json <<< '{"type":"dict","args":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[]}'\'''

echo '$ json <<< '\''{"type":"dict","args":["foo","bar"]}'\'''
json <<< '{"type":"dict","args":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":["foo","bar"]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":["boolean","number"]}'\'''
json <<< '{"type":"dict","args":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":["boolean","number"]}'\'''
)

