#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def:node-closed-array-list-any2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-closed-array-list-any2.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};'
) -L node-closed-array-list-any2.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d'; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'''
)

