#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object8.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
{"foo":{"bar":null}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
{"foo":{"bar":false}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
{"foo":{"bar":true}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
{"foo":{"bar":123}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
{"foo":{"bar":"foo"}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
{"foo":{"bar":{}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
{"foo":{"bar":[]}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
{"foo":{"bar":null}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:15: {"foo":{"bar":false}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:15: {"foo":{"bar":true}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:15: {"foo":{"bar":123}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:15: {"foo":{"bar":"foo"}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:15: {"foo":{"bar":{}}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:15: {"foo":{"bar":[]}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":{"bar":null}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
{"foo":{"bar":false}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
{"foo":{"bar":true}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":{"bar":123}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":{"bar":"foo"}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":{"bar":{}}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:15: {"foo":{"bar":[]}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:15: {"foo":{"bar":null}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:15: {"foo":{"bar":false}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:15: {"foo":{"bar":true}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
{"foo":{"bar":123}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:15: {"foo":{"bar":"foo"}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:15: {"foo":{"bar":{}}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:15: {"foo":{"bar":[]}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":{"bar":null}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":{"bar":false}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":{"bar":true}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":{"bar":123}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
{"foo":{"bar":"foo"}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":{"bar":{}}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:15: {"foo":{"bar":[]}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: {"foo":{"bar":null}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: {"foo":{"bar":false}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: {"foo":{"bar":true}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: {"foo":{"bar":123}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: {"foo":{"bar":"foo"}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
{"foo":{"bar":{}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: {"foo":{"bar":[]}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:15: {"foo":{"bar":null}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:15: {"foo":{"bar":false}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:15: {"foo":{"bar":true}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:15: {"foo":{"bar":123}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:15: {"foo":{"bar":"foo"}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:15: {"foo":{"bar":{}}}
json: error: <stdin>:1:15:               ^
{"foo":{"bar":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\''
{"foo":{"bar":[]}}'
) -L object8.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}' <<< '{"foo":{"bar":"foo"}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"type"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}' <<< '{"foo":{"bar":"foo"}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"null"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}' <<< '{"foo":{"bar":"foo"}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"boolean"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}' <<< '{"foo":{"bar":"foo"}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"number"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '{"foo":{"bar":"foo"}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}' <<< '{"foo":{"bar":"foo"}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"object"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}' <<< '{"foo":{"bar":null}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":null}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}' <<< '{"foo":{"bar":false}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":false}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}' <<< '{"foo":{"bar":true}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":true}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}' <<< '{"foo":{"bar":123}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":123}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}' <<< '{"foo":{"bar":"foo"}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":"foo"}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}' <<< '{"foo":{"bar":{}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":{}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}' <<< '{"foo":{"bar":[]}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":"array"}]}}]}'\'' <<< '\''{"foo":{"bar":[]}}'\'''
)

