#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object-list3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object-list3.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
) -L object-list3.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
)

