#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:closed-array9
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L closed-array9.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,null]'\''
[null,false,null]
$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,false]'\''
[null,false,false]
$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,true]'\''
[null,false,true]
$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,123]'\''
[null,false,123]
$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,"baz"]'\''
[null,false,"baz"]
$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,{}]'\''
[null,false,{}]
$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,[]]'\''
[null,false,[]]
$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,null]'\''
[null,null,null]
$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,false]'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:12: [null,null,false]
json: error: <stdin>:1:12:            ^
[null,null,
command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,false]'\''
$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,true]'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:12: [null,null,true]
json: error: <stdin>:1:12:            ^
[null,null,
command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,true]'\''
$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,123]'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:12: [null,null,123]
json: error: <stdin>:1:12:            ^
[null,null,
command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,123]'\''
$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,"baz"]'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:12: [null,null,"baz"]
json: error: <stdin>:1:12:            ^
[null,null,
command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,"baz"]'\''
$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,{}]'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:12: [null,null,{}]
json: error: <stdin>:1:12:            ^
[null,null,
command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,{}]'\''
$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,[]]'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:12: [null,null,[]]
json: error: <stdin>:1:12:            ^
[null,null,
command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,[]]'\''
$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,null]'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:13: [false,true,null]
json: error: <stdin>:1:13:             ^
[false,true,
command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,null]'\''
$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,false]'\''
[false,true,false]
$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,true]'\''
[false,true,true]
$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,123]'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:13: [false,true,123]
json: error: <stdin>:1:13:             ^
[false,true,
command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,123]'\''
$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,"baz"]'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:13: [false,true,"baz"]
json: error: <stdin>:1:13:             ^
[false,true,
command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,"baz"]'\''
$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,{}]'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:13: [false,true,{}]
json: error: <stdin>:1:13:             ^
[false,true,
command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,{}]'\''
$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,[]]'\''
json: error: <stdin>:1:13: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:13: [false,true,[]]
json: error: <stdin>:1:13:             ^
[false,true,
command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,[]]'\''
$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,null]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:10: [123,456,null]
json: error: <stdin>:1:10:          ^
[123,456,
command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,null]'\''
$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,false]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:10: [123,456,false]
json: error: <stdin>:1:10:          ^
[123,456,
command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,false]'\''
$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,true]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:10: [123,456,true]
json: error: <stdin>:1:10:          ^
[123,456,
command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,true]'\''
$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,123]'\''
[123,456,123]
$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,"baz"]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:10: [123,456,"baz"]
json: error: <stdin>:1:10:          ^
[123,456,
command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,"baz"]'\''
$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,{}]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:10: [123,456,{}]
json: error: <stdin>:1:10:          ^
[123,456,
command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,{}]'\''
$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,[]]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:10: [123,456,[]]
json: error: <stdin>:1:10:          ^
[123,456,
command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,[]]'\''
$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",null]'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:14: ["foo","bar",null]
json: error: <stdin>:1:14:              ^
["foo","bar",
command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",null]'\''
$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",false]'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:14: ["foo","bar",false]
json: error: <stdin>:1:14:              ^
["foo","bar",
command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",false]'\''
$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",true]'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:14: ["foo","bar",true]
json: error: <stdin>:1:14:              ^
["foo","bar",
command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",true]'\''
$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",123]'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:14: ["foo","bar",123]
json: error: <stdin>:1:14:              ^
["foo","bar",
command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",123]'\''
$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar","baz"]'\''
["foo","bar","baz"]
$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",{}]'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:14: ["foo","bar",{}]
json: error: <stdin>:1:14:              ^
["foo","bar",
command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",{}]'\''
$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",[]]'\''
json: error: <stdin>:1:14: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:14: ["foo","bar",[]]
json: error: <stdin>:1:14:              ^
["foo","bar",
command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",[]]'\''
$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},null]'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: [{},{"foo":1},null]
json: error: <stdin>:1:15:               ^
[{},{"foo":1},
command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},null]'\''
$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},false]'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: [{},{"foo":1},false]
json: error: <stdin>:1:15:               ^
[{},{"foo":1},
command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},false]'\''
$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},true]'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: [{},{"foo":1},true]
json: error: <stdin>:1:15:               ^
[{},{"foo":1},
command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},true]'\''
$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},123]'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: [{},{"foo":1},123]
json: error: <stdin>:1:15:               ^
[{},{"foo":1},
command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},123]'\''
$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},"baz"]'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: [{},{"foo":1},"baz"]
json: error: <stdin>:1:15:               ^
[{},{"foo":1},
command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},"baz"]'\''
$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},{}]'\''
[{},{"foo":1},{}]
$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},[]]'\''
json: error: <stdin>:1:15: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:15: [{},{"foo":1},[]]
json: error: <stdin>:1:15:               ^
[{},{"foo":1},
command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},[]]'\''
$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],null]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:10: [[],[[]],null]
json: error: <stdin>:1:10:          ^
[[],[[]],
command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],null]'\''
$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],false]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:10: [[],[[]],false]
json: error: <stdin>:1:10:          ^
[[],[[]],
command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],false]'\''
$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],true]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:10: [[],[[]],true]
json: error: <stdin>:1:10:          ^
[[],[[]],
command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],true]'\''
$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],123]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:10: [[],[[]],123]
json: error: <stdin>:1:10:          ^
[[],[[]],
command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],123]'\''
$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],"baz"]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:10: [[],[[]],"baz"]
json: error: <stdin>:1:10:          ^
[[],[[]],
command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],"baz"]'\''
$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],{}]'\''
json: error: <stdin>:1:10: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:10: [[],[[]],{}]
json: error: <stdin>:1:10:          ^
[[],[[]],
command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],{}]'\''
$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],[]]'\''
[[],[[]],[]]'
) -L closed-array9.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,null]'\'''
json -d '{"type":"array","args":["type","type","type"]}' <<< '[null,false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,false]'\'''
json -d '{"type":"array","args":["type","type","type"]}' <<< '[null,false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,true]'\'''
json -d '{"type":"array","args":["type","type","type"]}' <<< '[null,false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,123]'\'''
json -d '{"type":"array","args":["type","type","type"]}' <<< '[null,false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,"baz"]'\'''
json -d '{"type":"array","args":["type","type","type"]}' <<< '[null,false,"baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,"baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,{}]'\'''
json -d '{"type":"array","args":["type","type","type"]}' <<< '[null,false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,[]]'\'''
json -d '{"type":"array","args":["type","type","type"]}' <<< '[null,false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","type"]}'\'' <<< '\''[null,false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,null]'\'''
json -d '{"type":"array","args":["type","type","null"]}' <<< '[null,null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,false]'\'''
json -d '{"type":"array","args":["type","type","null"]}' <<< '[null,null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,true]'\'''
json -d '{"type":"array","args":["type","type","null"]}' <<< '[null,null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,123]'\'''
json -d '{"type":"array","args":["type","type","null"]}' <<< '[null,null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,"baz"]'\'''
json -d '{"type":"array","args":["type","type","null"]}' <<< '[null,null,"baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,"baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,{}]'\'''
json -d '{"type":"array","args":["type","type","null"]}' <<< '[null,null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,[]]'\'''
json -d '{"type":"array","args":["type","type","null"]}' <<< '[null,null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","null"]}'\'' <<< '\''[null,null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,null]'\'''
json -d '{"type":"array","args":["type","type","boolean"]}' <<< '[false,true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,false]'\'''
json -d '{"type":"array","args":["type","type","boolean"]}' <<< '[false,true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,true]'\'''
json -d '{"type":"array","args":["type","type","boolean"]}' <<< '[false,true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,123]'\'''
json -d '{"type":"array","args":["type","type","boolean"]}' <<< '[false,true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,"baz"]'\'''
json -d '{"type":"array","args":["type","type","boolean"]}' <<< '[false,true,"baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,"baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,{}]'\'''
json -d '{"type":"array","args":["type","type","boolean"]}' <<< '[false,true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,[]]'\'''
json -d '{"type":"array","args":["type","type","boolean"]}' <<< '[false,true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","boolean"]}'\'' <<< '\''[false,true,[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,null]'\'''
json -d '{"type":"array","args":["type","type","number"]}' <<< '[123,456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,false]'\'''
json -d '{"type":"array","args":["type","type","number"]}' <<< '[123,456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,true]'\'''
json -d '{"type":"array","args":["type","type","number"]}' <<< '[123,456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,123]'\'''
json -d '{"type":"array","args":["type","type","number"]}' <<< '[123,456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,"baz"]'\'''
json -d '{"type":"array","args":["type","type","number"]}' <<< '[123,456,"baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,"baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,{}]'\'''
json -d '{"type":"array","args":["type","type","number"]}' <<< '[123,456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,[]]'\'''
json -d '{"type":"array","args":["type","type","number"]}' <<< '[123,456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","number"]}'\'' <<< '\''[123,456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",null]'\'''
json -d '{"type":"array","args":["type","type","string"]}' <<< '["foo","bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",false]'\'''
json -d '{"type":"array","args":["type","type","string"]}' <<< '["foo","bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",true]'\'''
json -d '{"type":"array","args":["type","type","string"]}' <<< '["foo","bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",123]'\'''
json -d '{"type":"array","args":["type","type","string"]}' <<< '["foo","bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar","baz"]'\'''
json -d '{"type":"array","args":["type","type","string"]}' <<< '["foo","bar","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",{}]'\'''
json -d '{"type":"array","args":["type","type","string"]}' <<< '["foo","bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",[]]'\'''
json -d '{"type":"array","args":["type","type","string"]}' <<< '["foo","bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","string"]}'\'' <<< '\''["foo","bar",[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},null]'\'''
json -d '{"type":"array","args":["type","type","object"]}' <<< '[{},{"foo":1},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},false]'\'''
json -d '{"type":"array","args":["type","type","object"]}' <<< '[{},{"foo":1},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},true]'\'''
json -d '{"type":"array","args":["type","type","object"]}' <<< '[{},{"foo":1},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},123]'\'''
json -d '{"type":"array","args":["type","type","object"]}' <<< '[{},{"foo":1},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},"baz"]'\'''
json -d '{"type":"array","args":["type","type","object"]}' <<< '[{},{"foo":1},"baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},"baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},{}]'\'''
json -d '{"type":"array","args":["type","type","object"]}' <<< '[{},{"foo":1},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},[]]'\'''
json -d '{"type":"array","args":["type","type","object"]}' <<< '[{},{"foo":1},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","object"]}'\'' <<< '\''[{},{"foo":1},[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],null]'\'''
json -d '{"type":"array","args":["type","type","array"]}' <<< '[[],[[]],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],false]'\'''
json -d '{"type":"array","args":["type","type","array"]}' <<< '[[],[[]],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],true]'\'''
json -d '{"type":"array","args":["type","type","array"]}' <<< '[[],[[]],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],123]'\'''
json -d '{"type":"array","args":["type","type","array"]}' <<< '[[],[[]],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],"baz"]'\'''
json -d '{"type":"array","args":["type","type","array"]}' <<< '[[],[[]],"baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],"baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],{}]'\'''
json -d '{"type":"array","args":["type","type","array"]}' <<< '[[],[[]],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],[]]'\'''
json -d '{"type":"array","args":["type","type","array"]}' <<< '[[],[[]],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type","array"]}'\'' <<< '\''[[],[[]],[]]'\'''
)

