#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-foo-plain-val-object-foo-basic-fuu-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-foo-plain-val-object-foo-basic-fuu-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":456}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"baz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":456}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"baz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":456}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"baz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":456}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"baz"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":456}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"baz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":456}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"baz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":456}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"baz"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":456}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"baz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":456}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"baz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":456}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"baz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":456}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"baz"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":456}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"baz"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":456}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"baz"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":456}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"baz"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":456}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":"baz"}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"bar","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"bar"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":456}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"baz"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
) -L list-object-foo-basic-object-foo-plain-val-object-foo-basic-fuu-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":"bar","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":"bar","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":"bar","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":"bar","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":"bar","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":"bar","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
)

