#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr:builtins3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L builtins3.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }
$ test-expr '\''date(timestamp)'\'' '\''1539512224'\''
1
$ test-expr '\''date(timestamp)'\'' '\''"1539512224"'\''
1
$ test-expr '\''date(long_iso)'\'' '\''1539512224'\''
0
$ test-expr '\''date(long_iso)'\'' '\''"1539512224"'\''
0
$ test-expr '\''date(iso_8601)'\'' '\''1539512224'\''
0
$ test-expr '\''date(iso_8601)'\'' '\''"1539512224"'\''
0
$ test-expr '\''date(full_iso)'\'' '\''1539512224'\''
0
$ test-expr '\''date(full_iso)'\'' '\''"1539512224"'\''
0
$ test-expr '\''date(c_locale)'\'' '\''1539512224'\''
0
$ test-expr '\''date(c_locale)'\'' '\''"1539512224"'\''
0
$ test-expr '\''date(timestamp)'\'' '\''"2018-10-14 13:17:04"'\''
0
$ test-expr '\''date(long_iso)'\'' '\''"2018-10-14 13:17:04"'\''
1
$ test-expr '\''date(iso_8601)'\'' '\''"2018-10-14 13:17:04"'\''
0
$ test-expr '\''date(full_iso)'\'' '\''"2018-10-14 13:17:04"'\''
0
$ test-expr '\''date(c_locale)'\'' '\''"2018-10-14 13:17:04"'\''
0
$ test-expr '\''date(timestamp)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\''
0
$ test-expr '\''date(long_iso)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\''
0
$ test-expr '\''date(iso_8601)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\''
1
$ test-expr '\''date(full_iso)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\''
0
$ test-expr '\''date(c_locale)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\''
0
$ test-expr '\''date(timestamp)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\''
0
$ test-expr '\''date(long_iso)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\''
0
$ test-expr '\''date(iso_8601)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\''
0
$ test-expr '\''date(full_iso)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\''
1
$ test-expr '\''date(c_locale)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\''
0
$ test-expr '\''date(timestamp)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\''
0
$ test-expr '\''date(long_iso)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\''
0
$ test-expr '\''date(iso_8601)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\''
0
$ test-expr '\''date(full_iso)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\''
0
$ test-expr '\''date(c_locale)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\''
1'
) -L builtins3.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'

echo '$ test-expr '\''date(timestamp)'\'' '\''1539512224'\'''
test-expr 'date(timestamp)' '1539512224' 2>&1 ||
echo 'command failed: test-expr '\''date(timestamp)'\'' '\''1539512224'\'''

echo '$ test-expr '\''date(timestamp)'\'' '\''"1539512224"'\'''
test-expr 'date(timestamp)' '"1539512224"' 2>&1 ||
echo 'command failed: test-expr '\''date(timestamp)'\'' '\''"1539512224"'\'''

echo '$ test-expr '\''date(long_iso)'\'' '\''1539512224'\'''
test-expr 'date(long_iso)' '1539512224' 2>&1 ||
echo 'command failed: test-expr '\''date(long_iso)'\'' '\''1539512224'\'''

echo '$ test-expr '\''date(long_iso)'\'' '\''"1539512224"'\'''
test-expr 'date(long_iso)' '"1539512224"' 2>&1 ||
echo 'command failed: test-expr '\''date(long_iso)'\'' '\''"1539512224"'\'''

echo '$ test-expr '\''date(iso_8601)'\'' '\''1539512224'\'''
test-expr 'date(iso_8601)' '1539512224' 2>&1 ||
echo 'command failed: test-expr '\''date(iso_8601)'\'' '\''1539512224'\'''

echo '$ test-expr '\''date(iso_8601)'\'' '\''"1539512224"'\'''
test-expr 'date(iso_8601)' '"1539512224"' 2>&1 ||
echo 'command failed: test-expr '\''date(iso_8601)'\'' '\''"1539512224"'\'''

echo '$ test-expr '\''date(full_iso)'\'' '\''1539512224'\'''
test-expr 'date(full_iso)' '1539512224' 2>&1 ||
echo 'command failed: test-expr '\''date(full_iso)'\'' '\''1539512224'\'''

echo '$ test-expr '\''date(full_iso)'\'' '\''"1539512224"'\'''
test-expr 'date(full_iso)' '"1539512224"' 2>&1 ||
echo 'command failed: test-expr '\''date(full_iso)'\'' '\''"1539512224"'\'''

echo '$ test-expr '\''date(c_locale)'\'' '\''1539512224'\'''
test-expr 'date(c_locale)' '1539512224' 2>&1 ||
echo 'command failed: test-expr '\''date(c_locale)'\'' '\''1539512224'\'''

echo '$ test-expr '\''date(c_locale)'\'' '\''"1539512224"'\'''
test-expr 'date(c_locale)' '"1539512224"' 2>&1 ||
echo 'command failed: test-expr '\''date(c_locale)'\'' '\''"1539512224"'\'''

echo '$ test-expr '\''date(timestamp)'\'' '\''"2018-10-14 13:17:04"'\'''
test-expr 'date(timestamp)' '"2018-10-14 13:17:04"' 2>&1 ||
echo 'command failed: test-expr '\''date(timestamp)'\'' '\''"2018-10-14 13:17:04"'\'''

echo '$ test-expr '\''date(long_iso)'\'' '\''"2018-10-14 13:17:04"'\'''
test-expr 'date(long_iso)' '"2018-10-14 13:17:04"' 2>&1 ||
echo 'command failed: test-expr '\''date(long_iso)'\'' '\''"2018-10-14 13:17:04"'\'''

echo '$ test-expr '\''date(iso_8601)'\'' '\''"2018-10-14 13:17:04"'\'''
test-expr 'date(iso_8601)' '"2018-10-14 13:17:04"' 2>&1 ||
echo 'command failed: test-expr '\''date(iso_8601)'\'' '\''"2018-10-14 13:17:04"'\'''

echo '$ test-expr '\''date(full_iso)'\'' '\''"2018-10-14 13:17:04"'\'''
test-expr 'date(full_iso)' '"2018-10-14 13:17:04"' 2>&1 ||
echo 'command failed: test-expr '\''date(full_iso)'\'' '\''"2018-10-14 13:17:04"'\'''

echo '$ test-expr '\''date(c_locale)'\'' '\''"2018-10-14 13:17:04"'\'''
test-expr 'date(c_locale)' '"2018-10-14 13:17:04"' 2>&1 ||
echo 'command failed: test-expr '\''date(c_locale)'\'' '\''"2018-10-14 13:17:04"'\'''

echo '$ test-expr '\''date(timestamp)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''
test-expr 'date(timestamp)' '"2018-10-14T13:17:04.087142150Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(timestamp)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''

echo '$ test-expr '\''date(long_iso)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''
test-expr 'date(long_iso)' '"2018-10-14T13:17:04.087142150Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(long_iso)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''

echo '$ test-expr '\''date(iso_8601)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''
test-expr 'date(iso_8601)' '"2018-10-14T13:17:04.087142150Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(iso_8601)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''

echo '$ test-expr '\''date(full_iso)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''
test-expr 'date(full_iso)' '"2018-10-14T13:17:04.087142150Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(full_iso)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''

echo '$ test-expr '\''date(c_locale)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''
test-expr 'date(c_locale)' '"2018-10-14T13:17:04.087142150Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(c_locale)'\'' '\''"2018-10-14T13:17:04.087142150Z"'\'''

echo '$ test-expr '\''date(timestamp)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''
test-expr 'date(timestamp)' '"2018-10-14 13:17:04.095305614 +0300"' 2>&1 ||
echo 'command failed: test-expr '\''date(timestamp)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''

echo '$ test-expr '\''date(long_iso)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''
test-expr 'date(long_iso)' '"2018-10-14 13:17:04.095305614 +0300"' 2>&1 ||
echo 'command failed: test-expr '\''date(long_iso)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''

echo '$ test-expr '\''date(iso_8601)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''
test-expr 'date(iso_8601)' '"2018-10-14 13:17:04.095305614 +0300"' 2>&1 ||
echo 'command failed: test-expr '\''date(iso_8601)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''

echo '$ test-expr '\''date(full_iso)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''
test-expr 'date(full_iso)' '"2018-10-14 13:17:04.095305614 +0300"' 2>&1 ||
echo 'command failed: test-expr '\''date(full_iso)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''

echo '$ test-expr '\''date(c_locale)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''
test-expr 'date(c_locale)' '"2018-10-14 13:17:04.095305614 +0300"' 2>&1 ||
echo 'command failed: test-expr '\''date(c_locale)'\'' '\''"2018-10-14 13:17:04.095305614 +0300"'\'''

echo '$ test-expr '\''date(timestamp)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''
test-expr 'date(timestamp)' '"Sun Oct 14 13:17:04 EEST 2018"' 2>&1 ||
echo 'command failed: test-expr '\''date(timestamp)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''

echo '$ test-expr '\''date(long_iso)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''
test-expr 'date(long_iso)' '"Sun Oct 14 13:17:04 EEST 2018"' 2>&1 ||
echo 'command failed: test-expr '\''date(long_iso)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''

echo '$ test-expr '\''date(iso_8601)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''
test-expr 'date(iso_8601)' '"Sun Oct 14 13:17:04 EEST 2018"' 2>&1 ||
echo 'command failed: test-expr '\''date(iso_8601)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''

echo '$ test-expr '\''date(full_iso)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''
test-expr 'date(full_iso)' '"Sun Oct 14 13:17:04 EEST 2018"' 2>&1 ||
echo 'command failed: test-expr '\''date(full_iso)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''

echo '$ test-expr '\''date(c_locale)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''
test-expr 'date(c_locale)' '"Sun Oct 14 13:17:04 EEST 2018"' 2>&1 ||
echo 'command failed: test-expr '\''date(c_locale)'\'' '\''"Sun Oct 14 13:17:04 EEST 2018"'\'''
)

