#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-ast:op1
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L op1.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ test-expr '\''a < b'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(lt)
$ test-expr '\''a > b'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(gt)
$ test-expr '\''a <= b'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(le)
$ test-expr '\''a >= b'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
$ test-expr '\''a == b'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(eq)
$ test-expr '\''a != b'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
$ test-expr '\''a && b'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 make_bool()
$ test-expr '\''a || b'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 make_bool()
$ test-expr '\''a < B'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(lt)
$ test-expr '\''a > B'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(gt)
$ test-expr '\''a <= B'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(le)
$ test-expr '\''a >= B'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
$ test-expr '\''a == B'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(eq)
$ test-expr '\''a != B'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
$ test-expr '\''a && B'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
$ test-expr '\''a || B'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
$ test-expr '\''a < !b'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 cmp_op(lt)
$ test-expr '\''a > !b'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 cmp_op(gt)
$ test-expr '\''a <= !b'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 cmp_op(le)
$ test-expr '\''a >= !b'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 cmp_op(ge)
$ test-expr '\''a == !b'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 cmp_op(eq)
$ test-expr '\''a != !b'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 cmp_op(ne)
$ test-expr '\''a && !b'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
$ test-expr '\''a || !b'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
$ test-expr '\''a < !B'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 cmp_op(lt)
$ test-expr '\''a > !B'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 cmp_op(gt)
$ test-expr '\''a <= !B'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 cmp_op(le)
$ test-expr '\''a >= !B'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 cmp_op(ge)
$ test-expr '\''a == !B'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 cmp_op(eq)
$ test-expr '\''a != !B'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 cmp_op(ne)
$ test-expr '\''a && !B'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
$ test-expr '\''a || !B'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
$ test-expr '\''A < b'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(lt)
$ test-expr '\''A > b'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(gt)
$ test-expr '\''A <= b'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(le)
$ test-expr '\''A >= b'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
$ test-expr '\''A == b'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(eq)
$ test-expr '\''A != b'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
$ test-expr '\''A && b'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 make_bool()
$ test-expr '\''A || b'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 make_bool()
$ test-expr '\''A < B'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(lt)
$ test-expr '\''A > B'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(gt)
$ test-expr '\''A <= B'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(le)
$ test-expr '\''A >= B'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
$ test-expr '\''A == B'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(eq)
$ test-expr '\''A != B'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
$ test-expr '\''A && B'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
$ test-expr '\''A || B'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
$ test-expr '\''A < !b'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 cmp_op(lt)
$ test-expr '\''A > !b'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 cmp_op(gt)
$ test-expr '\''A <= !b'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 cmp_op(le)
$ test-expr '\''A >= !b'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 cmp_op(ge)
$ test-expr '\''A == !b'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 cmp_op(eq)
$ test-expr '\''A != !b'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 cmp_op(ne)
$ test-expr '\''A && !b'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
$ test-expr '\''A || !b'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
$ test-expr '\''A < !B'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 cmp_op(lt)
$ test-expr '\''A > !B'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 cmp_op(gt)
$ test-expr '\''A <= !B'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 cmp_op(le)
$ test-expr '\''A >= !B'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 cmp_op(ge)
$ test-expr '\''A == !B'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 cmp_op(eq)
$ test-expr '\''A != !B'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 cmp_op(ne)
$ test-expr '\''A && !B'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
$ test-expr '\''A || !B'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
$ test-expr '\''!a < b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 cmp_op(lt)
$ test-expr '\''!a > b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 cmp_op(gt)
$ test-expr '\''!a <= b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 cmp_op(le)
$ test-expr '\''!a >= b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 cmp_op(ge)
$ test-expr '\''!a == b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 cmp_op(eq)
$ test-expr '\''!a != b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 cmp_op(ne)
$ test-expr '\''!a && b'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 make_bool()
$ test-expr '\''!a || b'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 make_bool()
$ test-expr '\''!a < B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 cmp_op(lt)
$ test-expr '\''!a > B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 cmp_op(gt)
$ test-expr '\''!a <= B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 cmp_op(le)
$ test-expr '\''!a >= B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 cmp_op(ge)
$ test-expr '\''!a == B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 cmp_op(eq)
$ test-expr '\''!a != B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 cmp_op(ne)
$ test-expr '\''!a && B'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
$ test-expr '\''!a || B'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
$ test-expr '\''!a < !b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(lt)
$ test-expr '\''!a > !b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(gt)
$ test-expr '\''!a <= !b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(le)
$ test-expr '\''!a >= !b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(ge)
$ test-expr '\''!a == !b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(eq)
$ test-expr '\''!a != !b'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(ne)
$ test-expr '\''!a && !b'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
$ test-expr '\''!a || !b'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
$ test-expr '\''!a < !B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(lt)
$ test-expr '\''!a > !B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(gt)
$ test-expr '\''!a <= !B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(le)
$ test-expr '\''!a >= !B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(ge)
$ test-expr '\''!a == !B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(eq)
$ test-expr '\''!a != !B'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(ne)
$ test-expr '\''!a && !B'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
$ test-expr '\''!a || !B'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
$ test-expr '\''!A < b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 cmp_op(lt)
$ test-expr '\''!A > b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 cmp_op(gt)
$ test-expr '\''!A <= b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 cmp_op(le)
$ test-expr '\''!A >= b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 cmp_op(ge)
$ test-expr '\''!A == b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 cmp_op(eq)
$ test-expr '\''!A != b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 cmp_op(ne)
$ test-expr '\''!A && b'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 make_bool()
$ test-expr '\''!A || b'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 make_bool()
$ test-expr '\''!A < B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 cmp_op(lt)
$ test-expr '\''!A > B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 cmp_op(gt)
$ test-expr '\''!A <= B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 cmp_op(le)
$ test-expr '\''!A >= B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 cmp_op(ge)
$ test-expr '\''!A == B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 cmp_op(eq)
$ test-expr '\''!A != B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 cmp_op(ne)
$ test-expr '\''!A && B'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
$ test-expr '\''!A || B'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
$ test-expr '\''!A < !b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(lt)
$ test-expr '\''!A > !b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(gt)
$ test-expr '\''!A <= !b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(le)
$ test-expr '\''!A >= !b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(ge)
$ test-expr '\''!A == !b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(eq)
$ test-expr '\''!A != !b'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 cmp_op(ne)
$ test-expr '\''!A && !b'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
$ test-expr '\''!A || !b'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
$ test-expr '\''!A < !B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(lt)
$ test-expr '\''!A > !B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(gt)
$ test-expr '\''!A <= !B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(le)
$ test-expr '\''!A >= !B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(ge)
$ test-expr '\''!A == !B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(eq)
$ test-expr '\''!A != !B'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 cmp_op(ne)
$ test-expr '\''!A && !B'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
$ test-expr '\''!A || !B'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()'
) -L op1.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ test-expr '\''a < b'\'''
test-expr 'a < b' 2>&1 ||
echo 'command failed: test-expr '\''a < b'\'''

echo '$ test-expr '\''a > b'\'''
test-expr 'a > b' 2>&1 ||
echo 'command failed: test-expr '\''a > b'\'''

echo '$ test-expr '\''a <= b'\'''
test-expr 'a <= b' 2>&1 ||
echo 'command failed: test-expr '\''a <= b'\'''

echo '$ test-expr '\''a >= b'\'''
test-expr 'a >= b' 2>&1 ||
echo 'command failed: test-expr '\''a >= b'\'''

echo '$ test-expr '\''a == b'\'''
test-expr 'a == b' 2>&1 ||
echo 'command failed: test-expr '\''a == b'\'''

echo '$ test-expr '\''a != b'\'''
test-expr 'a != b' 2>&1 ||
echo 'command failed: test-expr '\''a != b'\'''

echo '$ test-expr '\''a && b'\'''
test-expr 'a && b' 2>&1 ||
echo 'command failed: test-expr '\''a && b'\'''

echo '$ test-expr '\''a || b'\'''
test-expr 'a || b' 2>&1 ||
echo 'command failed: test-expr '\''a || b'\'''

echo '$ test-expr '\''a < B'\'''
test-expr 'a < B' 2>&1 ||
echo 'command failed: test-expr '\''a < B'\'''

echo '$ test-expr '\''a > B'\'''
test-expr 'a > B' 2>&1 ||
echo 'command failed: test-expr '\''a > B'\'''

echo '$ test-expr '\''a <= B'\'''
test-expr 'a <= B' 2>&1 ||
echo 'command failed: test-expr '\''a <= B'\'''

echo '$ test-expr '\''a >= B'\'''
test-expr 'a >= B' 2>&1 ||
echo 'command failed: test-expr '\''a >= B'\'''

echo '$ test-expr '\''a == B'\'''
test-expr 'a == B' 2>&1 ||
echo 'command failed: test-expr '\''a == B'\'''

echo '$ test-expr '\''a != B'\'''
test-expr 'a != B' 2>&1 ||
echo 'command failed: test-expr '\''a != B'\'''

echo '$ test-expr '\''a && B'\'''
test-expr 'a && B' 2>&1 ||
echo 'command failed: test-expr '\''a && B'\'''

echo '$ test-expr '\''a || B'\'''
test-expr 'a || B' 2>&1 ||
echo 'command failed: test-expr '\''a || B'\'''

echo '$ test-expr '\''a < !b'\'''
test-expr 'a < !b' 2>&1 ||
echo 'command failed: test-expr '\''a < !b'\'''

echo '$ test-expr '\''a > !b'\'''
test-expr 'a > !b' 2>&1 ||
echo 'command failed: test-expr '\''a > !b'\'''

echo '$ test-expr '\''a <= !b'\'''
test-expr 'a <= !b' 2>&1 ||
echo 'command failed: test-expr '\''a <= !b'\'''

echo '$ test-expr '\''a >= !b'\'''
test-expr 'a >= !b' 2>&1 ||
echo 'command failed: test-expr '\''a >= !b'\'''

echo '$ test-expr '\''a == !b'\'''
test-expr 'a == !b' 2>&1 ||
echo 'command failed: test-expr '\''a == !b'\'''

echo '$ test-expr '\''a != !b'\'''
test-expr 'a != !b' 2>&1 ||
echo 'command failed: test-expr '\''a != !b'\'''

echo '$ test-expr '\''a && !b'\'''
test-expr 'a && !b' 2>&1 ||
echo 'command failed: test-expr '\''a && !b'\'''

echo '$ test-expr '\''a || !b'\'''
test-expr 'a || !b' 2>&1 ||
echo 'command failed: test-expr '\''a || !b'\'''

echo '$ test-expr '\''a < !B'\'''
test-expr 'a < !B' 2>&1 ||
echo 'command failed: test-expr '\''a < !B'\'''

echo '$ test-expr '\''a > !B'\'''
test-expr 'a > !B' 2>&1 ||
echo 'command failed: test-expr '\''a > !B'\'''

echo '$ test-expr '\''a <= !B'\'''
test-expr 'a <= !B' 2>&1 ||
echo 'command failed: test-expr '\''a <= !B'\'''

echo '$ test-expr '\''a >= !B'\'''
test-expr 'a >= !B' 2>&1 ||
echo 'command failed: test-expr '\''a >= !B'\'''

echo '$ test-expr '\''a == !B'\'''
test-expr 'a == !B' 2>&1 ||
echo 'command failed: test-expr '\''a == !B'\'''

echo '$ test-expr '\''a != !B'\'''
test-expr 'a != !B' 2>&1 ||
echo 'command failed: test-expr '\''a != !B'\'''

echo '$ test-expr '\''a && !B'\'''
test-expr 'a && !B' 2>&1 ||
echo 'command failed: test-expr '\''a && !B'\'''

echo '$ test-expr '\''a || !B'\'''
test-expr 'a || !B' 2>&1 ||
echo 'command failed: test-expr '\''a || !B'\'''

echo '$ test-expr '\''A < b'\'''
test-expr 'A < b' 2>&1 ||
echo 'command failed: test-expr '\''A < b'\'''

echo '$ test-expr '\''A > b'\'''
test-expr 'A > b' 2>&1 ||
echo 'command failed: test-expr '\''A > b'\'''

echo '$ test-expr '\''A <= b'\'''
test-expr 'A <= b' 2>&1 ||
echo 'command failed: test-expr '\''A <= b'\'''

echo '$ test-expr '\''A >= b'\'''
test-expr 'A >= b' 2>&1 ||
echo 'command failed: test-expr '\''A >= b'\'''

echo '$ test-expr '\''A == b'\'''
test-expr 'A == b' 2>&1 ||
echo 'command failed: test-expr '\''A == b'\'''

echo '$ test-expr '\''A != b'\'''
test-expr 'A != b' 2>&1 ||
echo 'command failed: test-expr '\''A != b'\'''

echo '$ test-expr '\''A && b'\'''
test-expr 'A && b' 2>&1 ||
echo 'command failed: test-expr '\''A && b'\'''

echo '$ test-expr '\''A || b'\'''
test-expr 'A || b' 2>&1 ||
echo 'command failed: test-expr '\''A || b'\'''

echo '$ test-expr '\''A < B'\'''
test-expr 'A < B' 2>&1 ||
echo 'command failed: test-expr '\''A < B'\'''

echo '$ test-expr '\''A > B'\'''
test-expr 'A > B' 2>&1 ||
echo 'command failed: test-expr '\''A > B'\'''

echo '$ test-expr '\''A <= B'\'''
test-expr 'A <= B' 2>&1 ||
echo 'command failed: test-expr '\''A <= B'\'''

echo '$ test-expr '\''A >= B'\'''
test-expr 'A >= B' 2>&1 ||
echo 'command failed: test-expr '\''A >= B'\'''

echo '$ test-expr '\''A == B'\'''
test-expr 'A == B' 2>&1 ||
echo 'command failed: test-expr '\''A == B'\'''

echo '$ test-expr '\''A != B'\'''
test-expr 'A != B' 2>&1 ||
echo 'command failed: test-expr '\''A != B'\'''

echo '$ test-expr '\''A && B'\'''
test-expr 'A && B' 2>&1 ||
echo 'command failed: test-expr '\''A && B'\'''

echo '$ test-expr '\''A || B'\'''
test-expr 'A || B' 2>&1 ||
echo 'command failed: test-expr '\''A || B'\'''

echo '$ test-expr '\''A < !b'\'''
test-expr 'A < !b' 2>&1 ||
echo 'command failed: test-expr '\''A < !b'\'''

echo '$ test-expr '\''A > !b'\'''
test-expr 'A > !b' 2>&1 ||
echo 'command failed: test-expr '\''A > !b'\'''

echo '$ test-expr '\''A <= !b'\'''
test-expr 'A <= !b' 2>&1 ||
echo 'command failed: test-expr '\''A <= !b'\'''

echo '$ test-expr '\''A >= !b'\'''
test-expr 'A >= !b' 2>&1 ||
echo 'command failed: test-expr '\''A >= !b'\'''

echo '$ test-expr '\''A == !b'\'''
test-expr 'A == !b' 2>&1 ||
echo 'command failed: test-expr '\''A == !b'\'''

echo '$ test-expr '\''A != !b'\'''
test-expr 'A != !b' 2>&1 ||
echo 'command failed: test-expr '\''A != !b'\'''

echo '$ test-expr '\''A && !b'\'''
test-expr 'A && !b' 2>&1 ||
echo 'command failed: test-expr '\''A && !b'\'''

echo '$ test-expr '\''A || !b'\'''
test-expr 'A || !b' 2>&1 ||
echo 'command failed: test-expr '\''A || !b'\'''

echo '$ test-expr '\''A < !B'\'''
test-expr 'A < !B' 2>&1 ||
echo 'command failed: test-expr '\''A < !B'\'''

echo '$ test-expr '\''A > !B'\'''
test-expr 'A > !B' 2>&1 ||
echo 'command failed: test-expr '\''A > !B'\'''

echo '$ test-expr '\''A <= !B'\'''
test-expr 'A <= !B' 2>&1 ||
echo 'command failed: test-expr '\''A <= !B'\'''

echo '$ test-expr '\''A >= !B'\'''
test-expr 'A >= !B' 2>&1 ||
echo 'command failed: test-expr '\''A >= !B'\'''

echo '$ test-expr '\''A == !B'\'''
test-expr 'A == !B' 2>&1 ||
echo 'command failed: test-expr '\''A == !B'\'''

echo '$ test-expr '\''A != !B'\'''
test-expr 'A != !B' 2>&1 ||
echo 'command failed: test-expr '\''A != !B'\'''

echo '$ test-expr '\''A && !B'\'''
test-expr 'A && !B' 2>&1 ||
echo 'command failed: test-expr '\''A && !B'\'''

echo '$ test-expr '\''A || !B'\'''
test-expr 'A || !B' 2>&1 ||
echo 'command failed: test-expr '\''A || !B'\'''

echo '$ test-expr '\''!a < b'\'''
test-expr '!a < b' 2>&1 ||
echo 'command failed: test-expr '\''!a < b'\'''

echo '$ test-expr '\''!a > b'\'''
test-expr '!a > b' 2>&1 ||
echo 'command failed: test-expr '\''!a > b'\'''

echo '$ test-expr '\''!a <= b'\'''
test-expr '!a <= b' 2>&1 ||
echo 'command failed: test-expr '\''!a <= b'\'''

echo '$ test-expr '\''!a >= b'\'''
test-expr '!a >= b' 2>&1 ||
echo 'command failed: test-expr '\''!a >= b'\'''

echo '$ test-expr '\''!a == b'\'''
test-expr '!a == b' 2>&1 ||
echo 'command failed: test-expr '\''!a == b'\'''

echo '$ test-expr '\''!a != b'\'''
test-expr '!a != b' 2>&1 ||
echo 'command failed: test-expr '\''!a != b'\'''

echo '$ test-expr '\''!a && b'\'''
test-expr '!a && b' 2>&1 ||
echo 'command failed: test-expr '\''!a && b'\'''

echo '$ test-expr '\''!a || b'\'''
test-expr '!a || b' 2>&1 ||
echo 'command failed: test-expr '\''!a || b'\'''

echo '$ test-expr '\''!a < B'\'''
test-expr '!a < B' 2>&1 ||
echo 'command failed: test-expr '\''!a < B'\'''

echo '$ test-expr '\''!a > B'\'''
test-expr '!a > B' 2>&1 ||
echo 'command failed: test-expr '\''!a > B'\'''

echo '$ test-expr '\''!a <= B'\'''
test-expr '!a <= B' 2>&1 ||
echo 'command failed: test-expr '\''!a <= B'\'''

echo '$ test-expr '\''!a >= B'\'''
test-expr '!a >= B' 2>&1 ||
echo 'command failed: test-expr '\''!a >= B'\'''

echo '$ test-expr '\''!a == B'\'''
test-expr '!a == B' 2>&1 ||
echo 'command failed: test-expr '\''!a == B'\'''

echo '$ test-expr '\''!a != B'\'''
test-expr '!a != B' 2>&1 ||
echo 'command failed: test-expr '\''!a != B'\'''

echo '$ test-expr '\''!a && B'\'''
test-expr '!a && B' 2>&1 ||
echo 'command failed: test-expr '\''!a && B'\'''

echo '$ test-expr '\''!a || B'\'''
test-expr '!a || B' 2>&1 ||
echo 'command failed: test-expr '\''!a || B'\'''

echo '$ test-expr '\''!a < !b'\'''
test-expr '!a < !b' 2>&1 ||
echo 'command failed: test-expr '\''!a < !b'\'''

echo '$ test-expr '\''!a > !b'\'''
test-expr '!a > !b' 2>&1 ||
echo 'command failed: test-expr '\''!a > !b'\'''

echo '$ test-expr '\''!a <= !b'\'''
test-expr '!a <= !b' 2>&1 ||
echo 'command failed: test-expr '\''!a <= !b'\'''

echo '$ test-expr '\''!a >= !b'\'''
test-expr '!a >= !b' 2>&1 ||
echo 'command failed: test-expr '\''!a >= !b'\'''

echo '$ test-expr '\''!a == !b'\'''
test-expr '!a == !b' 2>&1 ||
echo 'command failed: test-expr '\''!a == !b'\'''

echo '$ test-expr '\''!a != !b'\'''
test-expr '!a != !b' 2>&1 ||
echo 'command failed: test-expr '\''!a != !b'\'''

echo '$ test-expr '\''!a && !b'\'''
test-expr '!a && !b' 2>&1 ||
echo 'command failed: test-expr '\''!a && !b'\'''

echo '$ test-expr '\''!a || !b'\'''
test-expr '!a || !b' 2>&1 ||
echo 'command failed: test-expr '\''!a || !b'\'''

echo '$ test-expr '\''!a < !B'\'''
test-expr '!a < !B' 2>&1 ||
echo 'command failed: test-expr '\''!a < !B'\'''

echo '$ test-expr '\''!a > !B'\'''
test-expr '!a > !B' 2>&1 ||
echo 'command failed: test-expr '\''!a > !B'\'''

echo '$ test-expr '\''!a <= !B'\'''
test-expr '!a <= !B' 2>&1 ||
echo 'command failed: test-expr '\''!a <= !B'\'''

echo '$ test-expr '\''!a >= !B'\'''
test-expr '!a >= !B' 2>&1 ||
echo 'command failed: test-expr '\''!a >= !B'\'''

echo '$ test-expr '\''!a == !B'\'''
test-expr '!a == !B' 2>&1 ||
echo 'command failed: test-expr '\''!a == !B'\'''

echo '$ test-expr '\''!a != !B'\'''
test-expr '!a != !B' 2>&1 ||
echo 'command failed: test-expr '\''!a != !B'\'''

echo '$ test-expr '\''!a && !B'\'''
test-expr '!a && !B' 2>&1 ||
echo 'command failed: test-expr '\''!a && !B'\'''

echo '$ test-expr '\''!a || !B'\'''
test-expr '!a || !B' 2>&1 ||
echo 'command failed: test-expr '\''!a || !B'\'''

echo '$ test-expr '\''!A < b'\'''
test-expr '!A < b' 2>&1 ||
echo 'command failed: test-expr '\''!A < b'\'''

echo '$ test-expr '\''!A > b'\'''
test-expr '!A > b' 2>&1 ||
echo 'command failed: test-expr '\''!A > b'\'''

echo '$ test-expr '\''!A <= b'\'''
test-expr '!A <= b' 2>&1 ||
echo 'command failed: test-expr '\''!A <= b'\'''

echo '$ test-expr '\''!A >= b'\'''
test-expr '!A >= b' 2>&1 ||
echo 'command failed: test-expr '\''!A >= b'\'''

echo '$ test-expr '\''!A == b'\'''
test-expr '!A == b' 2>&1 ||
echo 'command failed: test-expr '\''!A == b'\'''

echo '$ test-expr '\''!A != b'\'''
test-expr '!A != b' 2>&1 ||
echo 'command failed: test-expr '\''!A != b'\'''

echo '$ test-expr '\''!A && b'\'''
test-expr '!A && b' 2>&1 ||
echo 'command failed: test-expr '\''!A && b'\'''

echo '$ test-expr '\''!A || b'\'''
test-expr '!A || b' 2>&1 ||
echo 'command failed: test-expr '\''!A || b'\'''

echo '$ test-expr '\''!A < B'\'''
test-expr '!A < B' 2>&1 ||
echo 'command failed: test-expr '\''!A < B'\'''

echo '$ test-expr '\''!A > B'\'''
test-expr '!A > B' 2>&1 ||
echo 'command failed: test-expr '\''!A > B'\'''

echo '$ test-expr '\''!A <= B'\'''
test-expr '!A <= B' 2>&1 ||
echo 'command failed: test-expr '\''!A <= B'\'''

echo '$ test-expr '\''!A >= B'\'''
test-expr '!A >= B' 2>&1 ||
echo 'command failed: test-expr '\''!A >= B'\'''

echo '$ test-expr '\''!A == B'\'''
test-expr '!A == B' 2>&1 ||
echo 'command failed: test-expr '\''!A == B'\'''

echo '$ test-expr '\''!A != B'\'''
test-expr '!A != B' 2>&1 ||
echo 'command failed: test-expr '\''!A != B'\'''

echo '$ test-expr '\''!A && B'\'''
test-expr '!A && B' 2>&1 ||
echo 'command failed: test-expr '\''!A && B'\'''

echo '$ test-expr '\''!A || B'\'''
test-expr '!A || B' 2>&1 ||
echo 'command failed: test-expr '\''!A || B'\'''

echo '$ test-expr '\''!A < !b'\'''
test-expr '!A < !b' 2>&1 ||
echo 'command failed: test-expr '\''!A < !b'\'''

echo '$ test-expr '\''!A > !b'\'''
test-expr '!A > !b' 2>&1 ||
echo 'command failed: test-expr '\''!A > !b'\'''

echo '$ test-expr '\''!A <= !b'\'''
test-expr '!A <= !b' 2>&1 ||
echo 'command failed: test-expr '\''!A <= !b'\'''

echo '$ test-expr '\''!A >= !b'\'''
test-expr '!A >= !b' 2>&1 ||
echo 'command failed: test-expr '\''!A >= !b'\'''

echo '$ test-expr '\''!A == !b'\'''
test-expr '!A == !b' 2>&1 ||
echo 'command failed: test-expr '\''!A == !b'\'''

echo '$ test-expr '\''!A != !b'\'''
test-expr '!A != !b' 2>&1 ||
echo 'command failed: test-expr '\''!A != !b'\'''

echo '$ test-expr '\''!A && !b'\'''
test-expr '!A && !b' 2>&1 ||
echo 'command failed: test-expr '\''!A && !b'\'''

echo '$ test-expr '\''!A || !b'\'''
test-expr '!A || !b' 2>&1 ||
echo 'command failed: test-expr '\''!A || !b'\'''

echo '$ test-expr '\''!A < !B'\'''
test-expr '!A < !B' 2>&1 ||
echo 'command failed: test-expr '\''!A < !B'\'''

echo '$ test-expr '\''!A > !B'\'''
test-expr '!A > !B' 2>&1 ||
echo 'command failed: test-expr '\''!A > !B'\'''

echo '$ test-expr '\''!A <= !B'\'''
test-expr '!A <= !B' 2>&1 ||
echo 'command failed: test-expr '\''!A <= !B'\'''

echo '$ test-expr '\''!A >= !B'\'''
test-expr '!A >= !B' 2>&1 ||
echo 'command failed: test-expr '\''!A >= !B'\'''

echo '$ test-expr '\''!A == !B'\'''
test-expr '!A == !B' 2>&1 ||
echo 'command failed: test-expr '\''!A == !B'\'''

echo '$ test-expr '\''!A != !B'\'''
test-expr '!A != !B' 2>&1 ||
echo 'command failed: test-expr '\''!A != !B'\'''

echo '$ test-expr '\''!A && !B'\'''
test-expr '!A && !B' 2>&1 ||
echo 'command failed: test-expr '\''!A && !B'\'''

echo '$ test-expr '\''!A || !B'\'''
test-expr '!A || !B' 2>&1 ||
echo 'command failed: test-expr '\''!A || !B'\'''
)

