#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-ast:null-char
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L null-char.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }
$ alias test-expr='\''test-expr -n. -E'\''
$ test-expr '\''#`a`'\'' '\''"....."'\''
0
$ test-expr '\''#`a`'\'' '\''"......"'\''
0
$ test-expr '\''#`a`'\'' '\''"......."'\''
0
$ test-expr '\''#`a`'\'' '\''"........"'\''
0
$ test-expr '\''#`a`'\'' '\''"........."'\''
0
$ test-expr '\''#`a`'\'' '\''".........."'\''
0
$ test-expr '\''#`a`'\'' '\''"........a"'\''
1
$ test-expr '\''#`a`'\'' '\''".......a"'\''
1
$ test-expr '\''#`a`'\'' '\''"......a"'\''
1
$ test-expr '\''#`a`'\'' '\''"......a."'\''
1
$ test-expr '\''#`a`'\'' '\''"......a.."'\''
1
$ test-expr '\''#`a`'\'' '\''"......aa"'\''
2
$ test-expr '\''#`a`'\'' '\''".....a"'\''
1
$ test-expr '\''#`a`'\'' '\''".....a."'\''
1
$ test-expr '\''#`a`'\'' '\''".....a.."'\''
1
$ test-expr '\''#`a`'\'' '\''".....aa"'\''
2
$ test-expr '\''#`a`'\'' '\''"....a"'\''
1
$ test-expr '\''#`a`'\'' '\''"....a."'\''
1
$ test-expr '\''#`a`'\'' '\''"....a.."'\''
1
$ test-expr '\''#`a`'\'' '\''"....a..."'\''
1
$ test-expr '\''#`a`'\'' '\''"....a...."'\''
1
$ test-expr '\''#`a`'\'' '\''"....a..a"'\''
2
$ test-expr '\''#`a`'\'' '\''"....a.a"'\''
2
$ test-expr '\''#`a`'\'' '\''"....aa"'\''
2
$ test-expr '\''#`a`'\'' '\''"....aa."'\''
2
$ test-expr '\''#`a`'\'' '\''"....aa.."'\''
2
$ test-expr '\''#`a`'\'' '\''"....aaa"'\''
3
$ test-expr '\''#`a`'\'' '\''"...a."'\''
1
$ test-expr '\''#`a`'\'' '\''"...a.."'\''
1
$ test-expr '\''#`a`'\'' '\''"...a..."'\''
1
$ test-expr '\''#`a`'\'' '\''"...a...."'\''
1
$ test-expr '\''#`a`'\'' '\''"...a..a"'\''
2
$ test-expr '\''#`a`'\'' '\''"...a.a"'\''
2
$ test-expr '\''#`a`'\'' '\''"...aa"'\''
2
$ test-expr '\''#`a`'\'' '\''"...aa."'\''
2
$ test-expr '\''#`a`'\'' '\''"...aa.."'\''
2
$ test-expr '\''#`a`'\'' '\''"...aaa"'\''
3
$ test-expr '\''#`a`'\'' '\''"..a.."'\''
1
$ test-expr '\''#`a`'\'' '\''"..a..."'\''
1
$ test-expr '\''#`a`'\'' '\''"..a...."'\''
1
$ test-expr '\''#`a`'\'' '\''"..a....."'\''
1
$ test-expr '\''#`a`'\'' '\''"..a......"'\''
1
$ test-expr '\''#`a`'\'' '\''"..a....a"'\''
2
$ test-expr '\''#`a`'\'' '\''"..a...a"'\''
2
$ test-expr '\''#`a`'\'' '\''"..a..a"'\''
2
$ test-expr '\''#`a`'\'' '\''"..a..a."'\''
2
$ test-expr '\''#`a`'\'' '\''"..a..a.."'\''
2
$ test-expr '\''#`a`'\'' '\''"..a..aa"'\''
3
$ test-expr '\''#`a`'\'' '\''"..a.a"'\''
2
$ test-expr '\''#`a`'\'' '\''"..a.a."'\''
2
$ test-expr '\''#`a`'\'' '\''"..a.a.."'\''
2
$ test-expr '\''#`a`'\'' '\''"..a.aa"'\''
3
$ test-expr '\''#`a`'\'' '\''"..aa."'\''
2
$ test-expr '\''#`a`'\'' '\''"..aa.."'\''
2
$ test-expr '\''#`a`'\'' '\''"..aa..."'\''
2
$ test-expr '\''#`a`'\'' '\''"..aa...."'\''
2
$ test-expr '\''#`a`'\'' '\''"..aa..a"'\''
3
$ test-expr '\''#`a`'\'' '\''"..aa.a"'\''
3
$ test-expr '\''#`a`'\'' '\''"..aaa"'\''
3
$ test-expr '\''#`a`'\'' '\''"..aaa."'\''
3
$ test-expr '\''#`a`'\'' '\''"..aaa.."'\''
3
$ test-expr '\''#`a`'\'' '\''"..aaaa"'\''
4
$ test-expr '\''#`a`'\'' '\''".a..."'\''
1
$ test-expr '\''#`a`'\'' '\''".a...."'\''
1
$ test-expr '\''#`a`'\'' '\''".a....."'\''
1
$ test-expr '\''#`a`'\'' '\''".a......"'\''
1
$ test-expr '\''#`a`'\'' '\''".a....a"'\''
2
$ test-expr '\''#`a`'\'' '\''".a...a"'\''
2
$ test-expr '\''#`a`'\'' '\''".a..a"'\''
2
$ test-expr '\''#`a`'\'' '\''".a..a."'\''
2
$ test-expr '\''#`a`'\'' '\''".a..a.."'\''
2
$ test-expr '\''#`a`'\'' '\''".a..aa"'\''
3
$ test-expr '\''#`a`'\'' '\''".a.a."'\''
2
$ test-expr '\''#`a`'\'' '\''".a.a.."'\''
2
$ test-expr '\''#`a`'\'' '\''".a.aa"'\''
3
$ test-expr '\''#`a`'\'' '\''".aa.."'\''
2
$ test-expr '\''#`a`'\'' '\''".aa..."'\''
2
$ test-expr '\''#`a`'\'' '\''".aa...."'\''
2
$ test-expr '\''#`a`'\'' '\''".aa..a"'\''
3
$ test-expr '\''#`a`'\'' '\''".aa.a"'\''
3
$ test-expr '\''#`a`'\'' '\''".aaa."'\''
3
$ test-expr '\''#`a`'\'' '\''".aaa.."'\''
3
$ test-expr '\''#`a`'\'' '\''".aaaa"'\''
4
$ test-expr '\''#`a`'\'' '\''"a...."'\''
1
$ test-expr '\''#`a`'\'' '\''"a....."'\''
1
$ test-expr '\''#`a`'\'' '\''"a......"'\''
1
$ test-expr '\''#`a`'\'' '\''"a......."'\''
1
$ test-expr '\''#`a`'\'' '\''"a........"'\''
1
$ test-expr '\''#`a`'\'' '\''"a......a"'\''
2
$ test-expr '\''#`a`'\'' '\''"a.....a"'\''
2
$ test-expr '\''#`a`'\'' '\''"a....a"'\''
2
$ test-expr '\''#`a`'\'' '\''"a....a."'\''
2
$ test-expr '\''#`a`'\'' '\''"a....a.."'\''
2
$ test-expr '\''#`a`'\'' '\''"a....aa"'\''
3
$ test-expr '\''#`a`'\'' '\''"a...a"'\''
2
$ test-expr '\''#`a`'\'' '\''"a...a."'\''
2
$ test-expr '\''#`a`'\'' '\''"a...a.."'\''
2
$ test-expr '\''#`a`'\'' '\''"a...aa"'\''
3
$ test-expr '\''#`a`'\'' '\''"a..a."'\''
2
$ test-expr '\''#`a`'\'' '\''"a..a.."'\''
2
$ test-expr '\''#`a`'\'' '\''"a..a..."'\''
2
$ test-expr '\''#`a`'\'' '\''"a..a...."'\''
2
$ test-expr '\''#`a`'\'' '\''"a..a..a"'\''
3
$ test-expr '\''#`a`'\'' '\''"a..a.a"'\''
3
$ test-expr '\''#`a`'\'' '\''"a..aa"'\''
3
$ test-expr '\''#`a`'\'' '\''"a..aa."'\''
3
$ test-expr '\''#`a`'\'' '\''"a..aa.."'\''
3
$ test-expr '\''#`a`'\'' '\''"a..aaa"'\''
4
$ test-expr '\''#`a`'\'' '\''"a.a.."'\''
2
$ test-expr '\''#`a`'\'' '\''"a.a..."'\''
2
$ test-expr '\''#`a`'\'' '\''"a.a...."'\''
2
$ test-expr '\''#`a`'\'' '\''"a.a..a"'\''
3
$ test-expr '\''#`a`'\'' '\''"a.a.a"'\''
3
$ test-expr '\''#`a`'\'' '\''"a.aa."'\''
3
$ test-expr '\''#`a`'\'' '\''"a.aa.."'\''
3
$ test-expr '\''#`a`'\'' '\''"a.aaa"'\''
4
$ test-expr '\''#`a`'\'' '\''"aa..."'\''
2
$ test-expr '\''#`a`'\'' '\''"aa...."'\''
2
$ test-expr '\''#`a`'\'' '\''"aa....."'\''
2
$ test-expr '\''#`a`'\'' '\''"aa......"'\''
2
$ test-expr '\''#`a`'\'' '\''"aa....a"'\''
3
$ test-expr '\''#`a`'\'' '\''"aa...a"'\''
3
$ test-expr '\''#`a`'\'' '\''"aa..a"'\''
3
$ test-expr '\''#`a`'\'' '\''"aa..a."'\''
3
$ test-expr '\''#`a`'\'' '\''"aa..a.."'\''
3
$ test-expr '\''#`a`'\'' '\''"aa..aa"'\''
4
$ test-expr '\''#`a`'\'' '\''"aa.a."'\''
3
$ test-expr '\''#`a`'\'' '\''"aa.a.."'\''
3
$ test-expr '\''#`a`'\'' '\''"aa.aa"'\''
4
$ test-expr '\''#`a`'\'' '\''"aaa.."'\''
3
$ test-expr '\''#`a`'\'' '\''"aaa..."'\''
3
$ test-expr '\''#`a`'\'' '\''"aaa...."'\''
3
$ test-expr '\''#`a`'\'' '\''"aaa..a"'\''
4
$ test-expr '\''#`a`'\'' '\''"aaa.a"'\''
4
$ test-expr '\''#`a`'\'' '\''"aaaa."'\''
4
$ test-expr '\''#`a`'\'' '\''"aaaa.."'\''
4
$ test-expr '\''#`a`'\'' '\''"aaaaa"'\''
5
$ test-expr '\''#`ab`'\'' '\''"....."'\''
0
$ test-expr '\''#`ab`'\'' '\''"......"'\''
0
$ test-expr '\''#`ab`'\'' '\''"......."'\''
0
$ test-expr '\''#`ab`'\'' '\''"........"'\''
0
$ test-expr '\''#`ab`'\'' '\''"........."'\''
0
$ test-expr '\''#`ab`'\'' '\''".........."'\''
0
$ test-expr '\''#`ab`'\'' '\''"........ab"'\''
1
$ test-expr '\''#`ab`'\'' '\''".......ab"'\''
1
$ test-expr '\''#`ab`'\'' '\''"......ab"'\''
1
$ test-expr '\''#`ab`'\'' '\''"......ab."'\''
1
$ test-expr '\''#`ab`'\'' '\''"......ab.."'\''
1
$ test-expr '\''#`ab`'\'' '\''"......abab"'\''
2
$ test-expr '\''#`ab`'\'' '\''".....ab"'\''
1
$ test-expr '\''#`ab`'\'' '\''".....ab."'\''
1
$ test-expr '\''#`ab`'\'' '\''".....ab.."'\''
1
$ test-expr '\''#`ab`'\'' '\''".....abab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"....ab"'\''
1
$ test-expr '\''#`ab`'\'' '\''"....ab."'\''
1
$ test-expr '\''#`ab`'\'' '\''"....ab.."'\''
1
$ test-expr '\''#`ab`'\'' '\''"....ab..."'\''
1
$ test-expr '\''#`ab`'\'' '\''"....ab...."'\''
1
$ test-expr '\''#`ab`'\'' '\''"....ab..ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"....ab.ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"....abab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"....abab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"....abab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"....ababab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"...ab."'\''
1
$ test-expr '\''#`ab`'\'' '\''"...ab.."'\''
1
$ test-expr '\''#`ab`'\'' '\''"...ab..."'\''
1
$ test-expr '\''#`ab`'\'' '\''"...ab...."'\''
1
$ test-expr '\''#`ab`'\'' '\''"...ab..ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"...ab.ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"...abab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"...abab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"...abab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"...ababab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"..ab.."'\''
1
$ test-expr '\''#`ab`'\'' '\''"..ab..."'\''
1
$ test-expr '\''#`ab`'\'' '\''"..ab...."'\''
1
$ test-expr '\''#`ab`'\'' '\''"..ab....."'\''
1
$ test-expr '\''#`ab`'\'' '\''"..ab......"'\''
1
$ test-expr '\''#`ab`'\'' '\''"..ab....ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab...ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab..ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab..ab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab..ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab..abab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"..ab.ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab.ab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab.ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..ab.abab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"..abab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..abab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..abab..."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..abab...."'\''
2
$ test-expr '\''#`ab`'\'' '\''"..abab..ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"..abab.ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"..ababab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"..ababab."'\''
3
$ test-expr '\''#`ab`'\'' '\''"..ababab.."'\''
3
$ test-expr '\''#`ab`'\'' '\''"..abababab"'\''
4
$ test-expr '\''#`ab`'\'' '\''".ab..."'\''
1
$ test-expr '\''#`ab`'\'' '\''".ab...."'\''
1
$ test-expr '\''#`ab`'\'' '\''".ab....."'\''
1
$ test-expr '\''#`ab`'\'' '\''".ab......"'\''
1
$ test-expr '\''#`ab`'\'' '\''".ab....ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''".ab...ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''".ab..ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''".ab..ab."'\''
2
$ test-expr '\''#`ab`'\'' '\''".ab..ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''".ab..abab"'\''
3
$ test-expr '\''#`ab`'\'' '\''".ab.ab."'\''
2
$ test-expr '\''#`ab`'\'' '\''".ab.ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''".ab.abab"'\''
3
$ test-expr '\''#`ab`'\'' '\''".abab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''".abab..."'\''
2
$ test-expr '\''#`ab`'\'' '\''".abab...."'\''
2
$ test-expr '\''#`ab`'\'' '\''".abab..ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''".abab.ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''".ababab."'\''
3
$ test-expr '\''#`ab`'\'' '\''".ababab.."'\''
3
$ test-expr '\''#`ab`'\'' '\''".abababab"'\''
4
$ test-expr '\''#`ab`'\'' '\''"ab...."'\''
1
$ test-expr '\''#`ab`'\'' '\''"ab....."'\''
1
$ test-expr '\''#`ab`'\'' '\''"ab......"'\''
1
$ test-expr '\''#`ab`'\'' '\''"ab......."'\''
1
$ test-expr '\''#`ab`'\'' '\''"ab........"'\''
1
$ test-expr '\''#`ab`'\'' '\''"ab......ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab.....ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab....ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab....ab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab....ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab....abab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab...ab"'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab...ab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab...ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab...abab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab..ab."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab..ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab..ab..."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab..ab...."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab..ab..ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab..ab.ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab..abab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab..abab."'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab..abab.."'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab..ababab"'\''
4
$ test-expr '\''#`ab`'\'' '\''"ab.ab.."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab.ab..."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab.ab...."'\''
2
$ test-expr '\''#`ab`'\'' '\''"ab.ab..ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab.ab.ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab.abab."'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab.abab.."'\''
3
$ test-expr '\''#`ab`'\'' '\''"ab.ababab"'\''
4
$ test-expr '\''#`ab`'\'' '\''"abab..."'\''
2
$ test-expr '\''#`ab`'\'' '\''"abab...."'\''
2
$ test-expr '\''#`ab`'\'' '\''"abab....."'\''
2
$ test-expr '\''#`ab`'\'' '\''"abab......"'\''
2
$ test-expr '\''#`ab`'\'' '\''"abab....ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"abab...ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"abab..ab"'\''
3
$ test-expr '\''#`ab`'\'' '\''"abab..ab."'\''
3
$ test-expr '\''#`ab`'\'' '\''"abab..ab.."'\''
3
$ test-expr '\''#`ab`'\'' '\''"abab..abab"'\''
4
$ test-expr '\''#`ab`'\'' '\''"abab.ab."'\''
3
$ test-expr '\''#`ab`'\'' '\''"abab.ab.."'\''
3
$ test-expr '\''#`ab`'\'' '\''"abab.abab"'\''
4
$ test-expr '\''#`ab`'\'' '\''"ababab.."'\''
3
$ test-expr '\''#`ab`'\'' '\''"ababab..."'\''
3
$ test-expr '\''#`ab`'\'' '\''"ababab...."'\''
3
$ test-expr '\''#`ab`'\'' '\''"ababab..ab"'\''
4
$ test-expr '\''#`ab`'\'' '\''"ababab.ab"'\''
4
$ test-expr '\''#`ab`'\'' '\''"abababab."'\''
4
$ test-expr '\''#`ab`'\'' '\''"abababab.."'\''
4
$ test-expr '\''#`ab`'\'' '\''"ababababab"'\''
5
$ test-expr '\''#`abc`'\'' '\''"....."'\''
0
$ test-expr '\''#`abc`'\'' '\''"......"'\''
0
$ test-expr '\''#`abc`'\'' '\''"......."'\''
0
$ test-expr '\''#`abc`'\'' '\''"........"'\''
0
$ test-expr '\''#`abc`'\'' '\''"........."'\''
0
$ test-expr '\''#`abc`'\'' '\''".........."'\''
0
$ test-expr '\''#`abc`'\'' '\''"........abc"'\''
1
$ test-expr '\''#`abc`'\'' '\''".......abc"'\''
1
$ test-expr '\''#`abc`'\'' '\''"......abc"'\''
1
$ test-expr '\''#`abc`'\'' '\''"......abc."'\''
1
$ test-expr '\''#`abc`'\'' '\''"......abc.."'\''
1
$ test-expr '\''#`abc`'\'' '\''"......abcabc"'\''
2
$ test-expr '\''#`abc`'\'' '\''".....abc"'\''
1
$ test-expr '\''#`abc`'\'' '\''".....abc."'\''
1
$ test-expr '\''#`abc`'\'' '\''".....abc.."'\''
1
$ test-expr '\''#`abc`'\'' '\''".....abcabc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"....abc"'\''
1
$ test-expr '\''#`abc`'\'' '\''"....abc."'\''
1
$ test-expr '\''#`abc`'\'' '\''"....abc.."'\''
1
$ test-expr '\''#`abc`'\'' '\''"....abc..."'\''
1
$ test-expr '\''#`abc`'\'' '\''"....abc...."'\''
1
$ test-expr '\''#`abc`'\'' '\''"....abc..abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"....abc.abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"....abcabc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"....abcabc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"....abcabc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"....abcabcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"...abc."'\''
1
$ test-expr '\''#`abc`'\'' '\''"...abc.."'\''
1
$ test-expr '\''#`abc`'\'' '\''"...abc..."'\''
1
$ test-expr '\''#`abc`'\'' '\''"...abc...."'\''
1
$ test-expr '\''#`abc`'\'' '\''"...abc..abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"...abc.abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"...abcabc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"...abcabc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"...abcabc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"...abcabcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abc.."'\''
1
$ test-expr '\''#`abc`'\'' '\''"..abc..."'\''
1
$ test-expr '\''#`abc`'\'' '\''"..abc...."'\''
1
$ test-expr '\''#`abc`'\'' '\''"..abc....."'\''
1
$ test-expr '\''#`abc`'\'' '\''"..abc......"'\''
1
$ test-expr '\''#`abc`'\'' '\''"..abc....abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc...abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc..abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc..abc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc..abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc..abcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abc.abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc.abc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc.abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abc.abcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abcabc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abcabc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abcabc..."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abcabc...."'\''
2
$ test-expr '\''#`abc`'\'' '\''"..abcabc..abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abcabc.abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abcabcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abcabcabc."'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abcabcabc.."'\''
3
$ test-expr '\''#`abc`'\'' '\''"..abcabcabcabc"'\''
4
$ test-expr '\''#`abc`'\'' '\''".abc..."'\''
1
$ test-expr '\''#`abc`'\'' '\''".abc...."'\''
1
$ test-expr '\''#`abc`'\'' '\''".abc....."'\''
1
$ test-expr '\''#`abc`'\'' '\''".abc......"'\''
1
$ test-expr '\''#`abc`'\'' '\''".abc....abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''".abc...abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''".abc..abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''".abc..abc."'\''
2
$ test-expr '\''#`abc`'\'' '\''".abc..abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''".abc..abcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''".abc.abc."'\''
2
$ test-expr '\''#`abc`'\'' '\''".abc.abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''".abc.abcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''".abcabc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''".abcabc..."'\''
2
$ test-expr '\''#`abc`'\'' '\''".abcabc...."'\''
2
$ test-expr '\''#`abc`'\'' '\''".abcabc..abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''".abcabc.abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''".abcabcabc."'\''
3
$ test-expr '\''#`abc`'\'' '\''".abcabcabc.."'\''
3
$ test-expr '\''#`abc`'\'' '\''".abcabcabcabc"'\''
4
$ test-expr '\''#`abc`'\'' '\''"abc...."'\''
1
$ test-expr '\''#`abc`'\'' '\''"abc....."'\''
1
$ test-expr '\''#`abc`'\'' '\''"abc......"'\''
1
$ test-expr '\''#`abc`'\'' '\''"abc......."'\''
1
$ test-expr '\''#`abc`'\'' '\''"abc........"'\''
1
$ test-expr '\''#`abc`'\'' '\''"abc......abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc.....abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc....abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc....abc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc....abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc....abcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc...abc"'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc...abc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc...abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc...abcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc..abc."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc..abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc..abc..."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc..abc...."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc..abc..abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc..abc.abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc..abcabc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc..abcabc."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc..abcabc.."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc..abcabcabc"'\''
4
$ test-expr '\''#`abc`'\'' '\''"abc.abc.."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc.abc..."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc.abc...."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abc.abc..abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc.abc.abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc.abcabc."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc.abcabc.."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abc.abcabcabc"'\''
4
$ test-expr '\''#`abc`'\'' '\''"abcabc..."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abcabc...."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abcabc....."'\''
2
$ test-expr '\''#`abc`'\'' '\''"abcabc......"'\''
2
$ test-expr '\''#`abc`'\'' '\''"abcabc....abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabc...abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabc..abc"'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabc..abc."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabc..abc.."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabc..abcabc"'\''
4
$ test-expr '\''#`abc`'\'' '\''"abcabc.abc."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabc.abc.."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabc.abcabc"'\''
4
$ test-expr '\''#`abc`'\'' '\''"abcabcabc.."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabcabc..."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabcabc...."'\''
3
$ test-expr '\''#`abc`'\'' '\''"abcabcabc..abc"'\''
4
$ test-expr '\''#`abc`'\'' '\''"abcabcabc.abc"'\''
4
$ test-expr '\''#`abc`'\'' '\''"abcabcabcabc."'\''
4
$ test-expr '\''#`abc`'\'' '\''"abcabcabcabc.."'\''
4
$ test-expr '\''#`abc`'\'' '\''"abcabcabcabcabc"'\''
5'
) -L null-char.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'

echo '$ alias test-expr='\''test-expr -n. -E'\'''
alias test-expr='test-expr -n. -E' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -n. -E'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....."'\'''
test-expr '#`a`' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"......"'\'''
test-expr '#`a`' '"......"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"......"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"......."'\'''
test-expr '#`a`' '"......."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"......."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"........"'\'''
test-expr '#`a`' '"........"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"........"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"........."'\'''
test-expr '#`a`' '"........."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"........."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".........."'\'''
test-expr '#`a`' '".........."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".........."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"........a"'\'''
test-expr '#`a`' '"........a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"........a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".......a"'\'''
test-expr '#`a`' '".......a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".......a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"......a"'\'''
test-expr '#`a`' '"......a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"......a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"......a."'\'''
test-expr '#`a`' '"......a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"......a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"......a.."'\'''
test-expr '#`a`' '"......a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"......a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"......aa"'\'''
test-expr '#`a`' '"......aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"......aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".....a"'\'''
test-expr '#`a`' '".....a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".....a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".....a."'\'''
test-expr '#`a`' '".....a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".....a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".....a.."'\'''
test-expr '#`a`' '".....a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".....a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".....aa"'\'''
test-expr '#`a`' '".....aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".....aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....a"'\'''
test-expr '#`a`' '"....a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....a."'\'''
test-expr '#`a`' '"....a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....a.."'\'''
test-expr '#`a`' '"....a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....a..."'\'''
test-expr '#`a`' '"....a..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....a..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....a...."'\'''
test-expr '#`a`' '"....a...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....a...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....a..a"'\'''
test-expr '#`a`' '"....a..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....a..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....a.a"'\'''
test-expr '#`a`' '"....a.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....a.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....aa"'\'''
test-expr '#`a`' '"....aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....aa."'\'''
test-expr '#`a`' '"....aa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....aa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....aa.."'\'''
test-expr '#`a`' '"....aa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....aa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"....aaa"'\'''
test-expr '#`a`' '"....aaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"....aaa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...a."'\'''
test-expr '#`a`' '"...a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...a.."'\'''
test-expr '#`a`' '"...a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...a..."'\'''
test-expr '#`a`' '"...a..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...a..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...a...."'\'''
test-expr '#`a`' '"...a...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...a...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...a..a"'\'''
test-expr '#`a`' '"...a..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...a..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...a.a"'\'''
test-expr '#`a`' '"...a.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...a.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...aa"'\'''
test-expr '#`a`' '"...aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...aa."'\'''
test-expr '#`a`' '"...aa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...aa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...aa.."'\'''
test-expr '#`a`' '"...aa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...aa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"...aaa"'\'''
test-expr '#`a`' '"...aaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"...aaa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a.."'\'''
test-expr '#`a`' '"..a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a..."'\'''
test-expr '#`a`' '"..a..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a...."'\'''
test-expr '#`a`' '"..a...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a....."'\'''
test-expr '#`a`' '"..a....."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a....."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a......"'\'''
test-expr '#`a`' '"..a......"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a......"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a....a"'\'''
test-expr '#`a`' '"..a....a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a....a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a...a"'\'''
test-expr '#`a`' '"..a...a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a...a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a..a"'\'''
test-expr '#`a`' '"..a..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a..a."'\'''
test-expr '#`a`' '"..a..a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a..a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a..a.."'\'''
test-expr '#`a`' '"..a..a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a..a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a..aa"'\'''
test-expr '#`a`' '"..a..aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a..aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a.a"'\'''
test-expr '#`a`' '"..a.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a.a."'\'''
test-expr '#`a`' '"..a.a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a.a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a.a.."'\'''
test-expr '#`a`' '"..a.a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a.a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..a.aa"'\'''
test-expr '#`a`' '"..a.aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..a.aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aa."'\'''
test-expr '#`a`' '"..aa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aa.."'\'''
test-expr '#`a`' '"..aa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aa..."'\'''
test-expr '#`a`' '"..aa..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aa..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aa...."'\'''
test-expr '#`a`' '"..aa...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aa...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aa..a"'\'''
test-expr '#`a`' '"..aa..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aa..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aa.a"'\'''
test-expr '#`a`' '"..aa.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aa.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aaa"'\'''
test-expr '#`a`' '"..aaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aaa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aaa."'\'''
test-expr '#`a`' '"..aaa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aaa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aaa.."'\'''
test-expr '#`a`' '"..aaa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aaa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"..aaaa"'\'''
test-expr '#`a`' '"..aaaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"..aaaa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a..."'\'''
test-expr '#`a`' '".a..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a...."'\'''
test-expr '#`a`' '".a...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a....."'\'''
test-expr '#`a`' '".a....."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a....."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a......"'\'''
test-expr '#`a`' '".a......"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a......"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a....a"'\'''
test-expr '#`a`' '".a....a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a....a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a...a"'\'''
test-expr '#`a`' '".a...a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a...a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a..a"'\'''
test-expr '#`a`' '".a..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a..a."'\'''
test-expr '#`a`' '".a..a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a..a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a..a.."'\'''
test-expr '#`a`' '".a..a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a..a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a..aa"'\'''
test-expr '#`a`' '".a..aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a..aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a.a."'\'''
test-expr '#`a`' '".a.a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a.a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a.a.."'\'''
test-expr '#`a`' '".a.a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a.a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".a.aa"'\'''
test-expr '#`a`' '".a.aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".a.aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aa.."'\'''
test-expr '#`a`' '".aa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aa..."'\'''
test-expr '#`a`' '".aa..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aa..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aa...."'\'''
test-expr '#`a`' '".aa...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aa...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aa..a"'\'''
test-expr '#`a`' '".aa..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aa..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aa.a"'\'''
test-expr '#`a`' '".aa.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aa.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aaa."'\'''
test-expr '#`a`' '".aaa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aaa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aaa.."'\'''
test-expr '#`a`' '".aaa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aaa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''".aaaa"'\'''
test-expr '#`a`' '".aaaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''".aaaa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a...."'\'''
test-expr '#`a`' '"a...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a....."'\'''
test-expr '#`a`' '"a....."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a....."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a......"'\'''
test-expr '#`a`' '"a......"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a......"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a......."'\'''
test-expr '#`a`' '"a......."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a......."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a........"'\'''
test-expr '#`a`' '"a........"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a........"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a......a"'\'''
test-expr '#`a`' '"a......a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a......a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.....a"'\'''
test-expr '#`a`' '"a.....a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.....a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a....a"'\'''
test-expr '#`a`' '"a....a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a....a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a....a."'\'''
test-expr '#`a`' '"a....a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a....a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a....a.."'\'''
test-expr '#`a`' '"a....a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a....a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a....aa"'\'''
test-expr '#`a`' '"a....aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a....aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a...a"'\'''
test-expr '#`a`' '"a...a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a...a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a...a."'\'''
test-expr '#`a`' '"a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a...a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a...a.."'\'''
test-expr '#`a`' '"a...a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a...a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a...aa"'\'''
test-expr '#`a`' '"a...aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a...aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..a."'\'''
test-expr '#`a`' '"a..a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..a.."'\'''
test-expr '#`a`' '"a..a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..a..."'\'''
test-expr '#`a`' '"a..a..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..a..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..a...."'\'''
test-expr '#`a`' '"a..a...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..a...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..a..a"'\'''
test-expr '#`a`' '"a..a..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..a..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..a.a"'\'''
test-expr '#`a`' '"a..a.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..a.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..aa"'\'''
test-expr '#`a`' '"a..aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..aa."'\'''
test-expr '#`a`' '"a..aa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..aa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..aa.."'\'''
test-expr '#`a`' '"a..aa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..aa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a..aaa"'\'''
test-expr '#`a`' '"a..aaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a..aaa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.a.."'\'''
test-expr '#`a`' '"a.a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.a..."'\'''
test-expr '#`a`' '"a.a..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.a..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.a...."'\'''
test-expr '#`a`' '"a.a...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.a...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.a..a"'\'''
test-expr '#`a`' '"a.a..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.a..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.a.a"'\'''
test-expr '#`a`' '"a.a.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.a.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.aa."'\'''
test-expr '#`a`' '"a.aa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.aa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.aa.."'\'''
test-expr '#`a`' '"a.aa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.aa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"a.aaa"'\'''
test-expr '#`a`' '"a.aaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"a.aaa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa..."'\'''
test-expr '#`a`' '"aa..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa...."'\'''
test-expr '#`a`' '"aa...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa....."'\'''
test-expr '#`a`' '"aa....."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa....."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa......"'\'''
test-expr '#`a`' '"aa......"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa......"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa....a"'\'''
test-expr '#`a`' '"aa....a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa....a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa...a"'\'''
test-expr '#`a`' '"aa...a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa...a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa..a"'\'''
test-expr '#`a`' '"aa..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa..a."'\'''
test-expr '#`a`' '"aa..a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa..a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa..a.."'\'''
test-expr '#`a`' '"aa..a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa..a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa..aa"'\'''
test-expr '#`a`' '"aa..aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa..aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa.a."'\'''
test-expr '#`a`' '"aa.a."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa.a."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa.a.."'\'''
test-expr '#`a`' '"aa.a.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa.a.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aa.aa"'\'''
test-expr '#`a`' '"aa.aa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aa.aa"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaa.."'\'''
test-expr '#`a`' '"aaa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaa..."'\'''
test-expr '#`a`' '"aaa..."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaa..."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaa...."'\'''
test-expr '#`a`' '"aaa...."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaa...."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaa..a"'\'''
test-expr '#`a`' '"aaa..a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaa..a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaa.a"'\'''
test-expr '#`a`' '"aaa.a"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaa.a"'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaaa."'\'''
test-expr '#`a`' '"aaaa."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaaa."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaaa.."'\'''
test-expr '#`a`' '"aaaa.."' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaaa.."'\'''

echo '$ test-expr '\''#`a`'\'' '\''"aaaaa"'\'''
test-expr '#`a`' '"aaaaa"' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'' '\''"aaaaa"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....."'\'''
test-expr '#`ab`' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"......"'\'''
test-expr '#`ab`' '"......"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"......"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"......."'\'''
test-expr '#`ab`' '"......."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"......."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"........"'\'''
test-expr '#`ab`' '"........"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"........"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"........."'\'''
test-expr '#`ab`' '"........."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"........."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".........."'\'''
test-expr '#`ab`' '".........."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".........."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"........ab"'\'''
test-expr '#`ab`' '"........ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"........ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".......ab"'\'''
test-expr '#`ab`' '".......ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".......ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"......ab"'\'''
test-expr '#`ab`' '"......ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"......ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"......ab."'\'''
test-expr '#`ab`' '"......ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"......ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"......ab.."'\'''
test-expr '#`ab`' '"......ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"......ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"......abab"'\'''
test-expr '#`ab`' '"......abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"......abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".....ab"'\'''
test-expr '#`ab`' '".....ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".....ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".....ab."'\'''
test-expr '#`ab`' '".....ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".....ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".....ab.."'\'''
test-expr '#`ab`' '".....ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".....ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".....abab"'\'''
test-expr '#`ab`' '".....abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".....abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ab"'\'''
test-expr '#`ab`' '"....ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ab."'\'''
test-expr '#`ab`' '"....ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ab.."'\'''
test-expr '#`ab`' '"....ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ab..."'\'''
test-expr '#`ab`' '"....ab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ab...."'\'''
test-expr '#`ab`' '"....ab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ab..ab"'\'''
test-expr '#`ab`' '"....ab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ab.ab"'\'''
test-expr '#`ab`' '"....ab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....abab"'\'''
test-expr '#`ab`' '"....abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....abab."'\'''
test-expr '#`ab`' '"....abab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....abab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....abab.."'\'''
test-expr '#`ab`' '"....abab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....abab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"....ababab"'\'''
test-expr '#`ab`' '"....ababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"....ababab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...ab."'\'''
test-expr '#`ab`' '"...ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...ab.."'\'''
test-expr '#`ab`' '"...ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...ab..."'\'''
test-expr '#`ab`' '"...ab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...ab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...ab...."'\'''
test-expr '#`ab`' '"...ab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...ab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...ab..ab"'\'''
test-expr '#`ab`' '"...ab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...ab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...ab.ab"'\'''
test-expr '#`ab`' '"...ab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...ab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...abab"'\'''
test-expr '#`ab`' '"...abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...abab."'\'''
test-expr '#`ab`' '"...abab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...abab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...abab.."'\'''
test-expr '#`ab`' '"...abab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...abab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"...ababab"'\'''
test-expr '#`ab`' '"...ababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"...ababab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab.."'\'''
test-expr '#`ab`' '"..ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab..."'\'''
test-expr '#`ab`' '"..ab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab...."'\'''
test-expr '#`ab`' '"..ab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab....."'\'''
test-expr '#`ab`' '"..ab....."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab....."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab......"'\'''
test-expr '#`ab`' '"..ab......"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab......"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab....ab"'\'''
test-expr '#`ab`' '"..ab....ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab....ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab...ab"'\'''
test-expr '#`ab`' '"..ab...ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab...ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab..ab"'\'''
test-expr '#`ab`' '"..ab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab..ab."'\'''
test-expr '#`ab`' '"..ab..ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab..ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab..ab.."'\'''
test-expr '#`ab`' '"..ab..ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab..ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab..abab"'\'''
test-expr '#`ab`' '"..ab..abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab..abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab.ab"'\'''
test-expr '#`ab`' '"..ab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab.ab."'\'''
test-expr '#`ab`' '"..ab.ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab.ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab.ab.."'\'''
test-expr '#`ab`' '"..ab.ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab.ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ab.abab"'\'''
test-expr '#`ab`' '"..ab.abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ab.abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..abab."'\'''
test-expr '#`ab`' '"..abab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..abab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..abab.."'\'''
test-expr '#`ab`' '"..abab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..abab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..abab..."'\'''
test-expr '#`ab`' '"..abab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..abab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..abab...."'\'''
test-expr '#`ab`' '"..abab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..abab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..abab..ab"'\'''
test-expr '#`ab`' '"..abab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..abab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..abab.ab"'\'''
test-expr '#`ab`' '"..abab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..abab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ababab"'\'''
test-expr '#`ab`' '"..ababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ababab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ababab."'\'''
test-expr '#`ab`' '"..ababab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ababab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..ababab.."'\'''
test-expr '#`ab`' '"..ababab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..ababab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"..abababab"'\'''
test-expr '#`ab`' '"..abababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"..abababab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab..."'\'''
test-expr '#`ab`' '".ab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab...."'\'''
test-expr '#`ab`' '".ab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab....."'\'''
test-expr '#`ab`' '".ab....."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab....."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab......"'\'''
test-expr '#`ab`' '".ab......"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab......"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab....ab"'\'''
test-expr '#`ab`' '".ab....ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab....ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab...ab"'\'''
test-expr '#`ab`' '".ab...ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab...ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab..ab"'\'''
test-expr '#`ab`' '".ab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab..ab."'\'''
test-expr '#`ab`' '".ab..ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab..ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab..ab.."'\'''
test-expr '#`ab`' '".ab..ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab..ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab..abab"'\'''
test-expr '#`ab`' '".ab..abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab..abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab.ab."'\'''
test-expr '#`ab`' '".ab.ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab.ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab.ab.."'\'''
test-expr '#`ab`' '".ab.ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab.ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ab.abab"'\'''
test-expr '#`ab`' '".ab.abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ab.abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".abab.."'\'''
test-expr '#`ab`' '".abab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".abab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".abab..."'\'''
test-expr '#`ab`' '".abab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".abab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".abab...."'\'''
test-expr '#`ab`' '".abab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".abab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".abab..ab"'\'''
test-expr '#`ab`' '".abab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".abab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".abab.ab"'\'''
test-expr '#`ab`' '".abab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".abab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ababab."'\'''
test-expr '#`ab`' '".ababab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ababab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".ababab.."'\'''
test-expr '#`ab`' '".ababab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".ababab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''".abababab"'\'''
test-expr '#`ab`' '".abababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''".abababab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab...."'\'''
test-expr '#`ab`' '"ab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab....."'\'''
test-expr '#`ab`' '"ab....."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab....."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab......"'\'''
test-expr '#`ab`' '"ab......"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab......"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab......."'\'''
test-expr '#`ab`' '"ab......."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab......."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab........"'\'''
test-expr '#`ab`' '"ab........"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab........"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab......ab"'\'''
test-expr '#`ab`' '"ab......ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab......ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.....ab"'\'''
test-expr '#`ab`' '"ab.....ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.....ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab....ab"'\'''
test-expr '#`ab`' '"ab....ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab....ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab....ab."'\'''
test-expr '#`ab`' '"ab....ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab....ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab....ab.."'\'''
test-expr '#`ab`' '"ab....ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab....ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab....abab"'\'''
test-expr '#`ab`' '"ab....abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab....abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab...ab"'\'''
test-expr '#`ab`' '"ab...ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab...ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab...ab."'\'''
test-expr '#`ab`' '"ab...ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab...ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab...ab.."'\'''
test-expr '#`ab`' '"ab...ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab...ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab...abab"'\'''
test-expr '#`ab`' '"ab...abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab...abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..ab."'\'''
test-expr '#`ab`' '"ab..ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..ab.."'\'''
test-expr '#`ab`' '"ab..ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..ab..."'\'''
test-expr '#`ab`' '"ab..ab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..ab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..ab...."'\'''
test-expr '#`ab`' '"ab..ab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..ab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..ab..ab"'\'''
test-expr '#`ab`' '"ab..ab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..ab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..ab.ab"'\'''
test-expr '#`ab`' '"ab..ab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..ab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..abab"'\'''
test-expr '#`ab`' '"ab..abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..abab."'\'''
test-expr '#`ab`' '"ab..abab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..abab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..abab.."'\'''
test-expr '#`ab`' '"ab..abab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..abab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab..ababab"'\'''
test-expr '#`ab`' '"ab..ababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab..ababab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.ab.."'\'''
test-expr '#`ab`' '"ab.ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.ab..."'\'''
test-expr '#`ab`' '"ab.ab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.ab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.ab...."'\'''
test-expr '#`ab`' '"ab.ab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.ab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.ab..ab"'\'''
test-expr '#`ab`' '"ab.ab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.ab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.ab.ab"'\'''
test-expr '#`ab`' '"ab.ab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.ab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.abab."'\'''
test-expr '#`ab`' '"ab.abab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.abab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.abab.."'\'''
test-expr '#`ab`' '"ab.abab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.abab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ab.ababab"'\'''
test-expr '#`ab`' '"ab.ababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ab.ababab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab..."'\'''
test-expr '#`ab`' '"abab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab...."'\'''
test-expr '#`ab`' '"abab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab....."'\'''
test-expr '#`ab`' '"abab....."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab....."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab......"'\'''
test-expr '#`ab`' '"abab......"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab......"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab....ab"'\'''
test-expr '#`ab`' '"abab....ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab....ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab...ab"'\'''
test-expr '#`ab`' '"abab...ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab...ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab..ab"'\'''
test-expr '#`ab`' '"abab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab..ab."'\'''
test-expr '#`ab`' '"abab..ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab..ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab..ab.."'\'''
test-expr '#`ab`' '"abab..ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab..ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab..abab"'\'''
test-expr '#`ab`' '"abab..abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab..abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab.ab."'\'''
test-expr '#`ab`' '"abab.ab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab.ab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab.ab.."'\'''
test-expr '#`ab`' '"abab.ab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab.ab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abab.abab"'\'''
test-expr '#`ab`' '"abab.abab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abab.abab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ababab.."'\'''
test-expr '#`ab`' '"ababab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ababab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ababab..."'\'''
test-expr '#`ab`' '"ababab..."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ababab..."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ababab...."'\'''
test-expr '#`ab`' '"ababab...."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ababab...."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ababab..ab"'\'''
test-expr '#`ab`' '"ababab..ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ababab..ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ababab.ab"'\'''
test-expr '#`ab`' '"ababab.ab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ababab.ab"'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abababab."'\'''
test-expr '#`ab`' '"abababab."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abababab."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"abababab.."'\'''
test-expr '#`ab`' '"abababab.."' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"abababab.."'\'''

echo '$ test-expr '\''#`ab`'\'' '\''"ababababab"'\'''
test-expr '#`ab`' '"ababababab"' 2>&1 ||
echo 'command failed: test-expr '\''#`ab`'\'' '\''"ababababab"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....."'\'''
test-expr '#`abc`' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"......"'\'''
test-expr '#`abc`' '"......"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"......"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"......."'\'''
test-expr '#`abc`' '"......."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"......."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"........"'\'''
test-expr '#`abc`' '"........"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"........"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"........."'\'''
test-expr '#`abc`' '"........."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"........."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".........."'\'''
test-expr '#`abc`' '".........."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".........."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"........abc"'\'''
test-expr '#`abc`' '"........abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"........abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".......abc"'\'''
test-expr '#`abc`' '".......abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".......abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"......abc"'\'''
test-expr '#`abc`' '"......abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"......abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"......abc."'\'''
test-expr '#`abc`' '"......abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"......abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"......abc.."'\'''
test-expr '#`abc`' '"......abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"......abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"......abcabc"'\'''
test-expr '#`abc`' '"......abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"......abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".....abc"'\'''
test-expr '#`abc`' '".....abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".....abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".....abc."'\'''
test-expr '#`abc`' '".....abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".....abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".....abc.."'\'''
test-expr '#`abc`' '".....abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".....abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".....abcabc"'\'''
test-expr '#`abc`' '".....abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".....abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abc"'\'''
test-expr '#`abc`' '"....abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abc."'\'''
test-expr '#`abc`' '"....abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abc.."'\'''
test-expr '#`abc`' '"....abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abc..."'\'''
test-expr '#`abc`' '"....abc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abc...."'\'''
test-expr '#`abc`' '"....abc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abc..abc"'\'''
test-expr '#`abc`' '"....abc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abc.abc"'\'''
test-expr '#`abc`' '"....abc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abcabc"'\'''
test-expr '#`abc`' '"....abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abcabc."'\'''
test-expr '#`abc`' '"....abcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abcabc.."'\'''
test-expr '#`abc`' '"....abcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"....abcabcabc"'\'''
test-expr '#`abc`' '"....abcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"....abcabcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abc."'\'''
test-expr '#`abc`' '"...abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abc.."'\'''
test-expr '#`abc`' '"...abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abc..."'\'''
test-expr '#`abc`' '"...abc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abc...."'\'''
test-expr '#`abc`' '"...abc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abc..abc"'\'''
test-expr '#`abc`' '"...abc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abc.abc"'\'''
test-expr '#`abc`' '"...abc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abcabc"'\'''
test-expr '#`abc`' '"...abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abcabc."'\'''
test-expr '#`abc`' '"...abcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abcabc.."'\'''
test-expr '#`abc`' '"...abcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"...abcabcabc"'\'''
test-expr '#`abc`' '"...abcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"...abcabcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc.."'\'''
test-expr '#`abc`' '"..abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc..."'\'''
test-expr '#`abc`' '"..abc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc...."'\'''
test-expr '#`abc`' '"..abc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc....."'\'''
test-expr '#`abc`' '"..abc....."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc....."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc......"'\'''
test-expr '#`abc`' '"..abc......"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc......"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc....abc"'\'''
test-expr '#`abc`' '"..abc....abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc....abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc...abc"'\'''
test-expr '#`abc`' '"..abc...abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc...abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc..abc"'\'''
test-expr '#`abc`' '"..abc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc..abc."'\'''
test-expr '#`abc`' '"..abc..abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc..abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc..abc.."'\'''
test-expr '#`abc`' '"..abc..abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc..abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc..abcabc"'\'''
test-expr '#`abc`' '"..abc..abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc..abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc.abc"'\'''
test-expr '#`abc`' '"..abc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc.abc."'\'''
test-expr '#`abc`' '"..abc.abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc.abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc.abc.."'\'''
test-expr '#`abc`' '"..abc.abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc.abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abc.abcabc"'\'''
test-expr '#`abc`' '"..abc.abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abc.abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabc."'\'''
test-expr '#`abc`' '"..abcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabc.."'\'''
test-expr '#`abc`' '"..abcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabc..."'\'''
test-expr '#`abc`' '"..abcabc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabc...."'\'''
test-expr '#`abc`' '"..abcabc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabc..abc"'\'''
test-expr '#`abc`' '"..abcabc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabc.abc"'\'''
test-expr '#`abc`' '"..abcabc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabcabc"'\'''
test-expr '#`abc`' '"..abcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabcabc."'\'''
test-expr '#`abc`' '"..abcabcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabcabc.."'\'''
test-expr '#`abc`' '"..abcabcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"..abcabcabcabc"'\'''
test-expr '#`abc`' '"..abcabcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"..abcabcabcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc..."'\'''
test-expr '#`abc`' '".abc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc...."'\'''
test-expr '#`abc`' '".abc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc....."'\'''
test-expr '#`abc`' '".abc....."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc....."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc......"'\'''
test-expr '#`abc`' '".abc......"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc......"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc....abc"'\'''
test-expr '#`abc`' '".abc....abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc....abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc...abc"'\'''
test-expr '#`abc`' '".abc...abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc...abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc..abc"'\'''
test-expr '#`abc`' '".abc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc..abc."'\'''
test-expr '#`abc`' '".abc..abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc..abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc..abc.."'\'''
test-expr '#`abc`' '".abc..abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc..abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc..abcabc"'\'''
test-expr '#`abc`' '".abc..abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc..abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc.abc."'\'''
test-expr '#`abc`' '".abc.abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc.abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc.abc.."'\'''
test-expr '#`abc`' '".abc.abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc.abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abc.abcabc"'\'''
test-expr '#`abc`' '".abc.abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abc.abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabc.."'\'''
test-expr '#`abc`' '".abcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabc..."'\'''
test-expr '#`abc`' '".abcabc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabc...."'\'''
test-expr '#`abc`' '".abcabc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabc..abc"'\'''
test-expr '#`abc`' '".abcabc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabc.abc"'\'''
test-expr '#`abc`' '".abcabc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabcabc."'\'''
test-expr '#`abc`' '".abcabcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabcabc.."'\'''
test-expr '#`abc`' '".abcabcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''".abcabcabcabc"'\'''
test-expr '#`abc`' '".abcabcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''".abcabcabcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc...."'\'''
test-expr '#`abc`' '"abc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc....."'\'''
test-expr '#`abc`' '"abc....."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc....."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc......"'\'''
test-expr '#`abc`' '"abc......"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc......"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc......."'\'''
test-expr '#`abc`' '"abc......."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc......."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc........"'\'''
test-expr '#`abc`' '"abc........"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc........"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc......abc"'\'''
test-expr '#`abc`' '"abc......abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc......abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.....abc"'\'''
test-expr '#`abc`' '"abc.....abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.....abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc....abc"'\'''
test-expr '#`abc`' '"abc....abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc....abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc....abc."'\'''
test-expr '#`abc`' '"abc....abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc....abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc....abc.."'\'''
test-expr '#`abc`' '"abc....abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc....abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc....abcabc"'\'''
test-expr '#`abc`' '"abc....abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc....abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc...abc"'\'''
test-expr '#`abc`' '"abc...abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc...abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc...abc."'\'''
test-expr '#`abc`' '"abc...abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc...abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc...abc.."'\'''
test-expr '#`abc`' '"abc...abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc...abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc...abcabc"'\'''
test-expr '#`abc`' '"abc...abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc...abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abc."'\'''
test-expr '#`abc`' '"abc..abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abc.."'\'''
test-expr '#`abc`' '"abc..abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abc..."'\'''
test-expr '#`abc`' '"abc..abc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abc...."'\'''
test-expr '#`abc`' '"abc..abc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abc..abc"'\'''
test-expr '#`abc`' '"abc..abc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abc.abc"'\'''
test-expr '#`abc`' '"abc..abc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abcabc"'\'''
test-expr '#`abc`' '"abc..abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abcabc."'\'''
test-expr '#`abc`' '"abc..abcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abcabc.."'\'''
test-expr '#`abc`' '"abc..abcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc..abcabcabc"'\'''
test-expr '#`abc`' '"abc..abcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc..abcabcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abc.."'\'''
test-expr '#`abc`' '"abc.abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abc..."'\'''
test-expr '#`abc`' '"abc.abc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abc...."'\'''
test-expr '#`abc`' '"abc.abc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abc..abc"'\'''
test-expr '#`abc`' '"abc.abc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abc.abc"'\'''
test-expr '#`abc`' '"abc.abc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abcabc."'\'''
test-expr '#`abc`' '"abc.abcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abcabc.."'\'''
test-expr '#`abc`' '"abc.abcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abc.abcabcabc"'\'''
test-expr '#`abc`' '"abc.abcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abc.abcabcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc..."'\'''
test-expr '#`abc`' '"abcabc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc...."'\'''
test-expr '#`abc`' '"abcabc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc....."'\'''
test-expr '#`abc`' '"abcabc....."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc....."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc......"'\'''
test-expr '#`abc`' '"abcabc......"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc......"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc....abc"'\'''
test-expr '#`abc`' '"abcabc....abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc....abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc...abc"'\'''
test-expr '#`abc`' '"abcabc...abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc...abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc..abc"'\'''
test-expr '#`abc`' '"abcabc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc..abc."'\'''
test-expr '#`abc`' '"abcabc..abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc..abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc..abc.."'\'''
test-expr '#`abc`' '"abcabc..abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc..abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc..abcabc"'\'''
test-expr '#`abc`' '"abcabc..abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc..abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc.abc."'\'''
test-expr '#`abc`' '"abcabc.abc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc.abc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc.abc.."'\'''
test-expr '#`abc`' '"abcabc.abc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc.abc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabc.abcabc"'\'''
test-expr '#`abc`' '"abcabc.abcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabc.abcabc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabc.."'\'''
test-expr '#`abc`' '"abcabcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabc..."'\'''
test-expr '#`abc`' '"abcabcabc..."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabc..."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabc...."'\'''
test-expr '#`abc`' '"abcabcabc...."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabc...."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabc..abc"'\'''
test-expr '#`abc`' '"abcabcabc..abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabc..abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabc.abc"'\'''
test-expr '#`abc`' '"abcabcabc.abc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabc.abc"'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabcabc."'\'''
test-expr '#`abc`' '"abcabcabcabc."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabcabc."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabcabc.."'\'''
test-expr '#`abc`' '"abcabcabcabc.."' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabcabc.."'\'''

echo '$ test-expr '\''#`abc`'\'' '\''"abcabcabcabcabc"'\'''
test-expr '#`abc`' '"abcabcabcabcabc"' 2>&1 ||
echo 'command failed: test-expr '\''#`abc`'\'' '\''"abcabcabcabcabc"'\'''
)

