#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-ast:basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L basic.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ test-expr '\''0'\''
0 const_num(0)
$ test-expr '\''1'\''
0 const_num(1)
$ test-expr -e '\''-0'\''
test-expr: error:1:1: compiler error: unexpected char
test-expr: error:1:1: compiler error: -0
test-expr: error:1:1: compiler error: ^
command failed: test-expr -e '\''-0'\''
$ test-expr -e '\''-1'\''
test-expr: error:1:1: compiler error: unexpected char
test-expr: error:1:1: compiler error: -1
test-expr: error:1:1: compiler error: ^
command failed: test-expr -e '\''-1'\''
$ test-expr 9223372036854775807
0 const_num(9223372036854775807)
$ test-expr -e -9223372036854775807
test-expr: error:1:1: compiler error: unexpected char
test-expr: error:1:1: compiler error: -9223372036854775807
test-expr: error:1:1: compiler error: ^
command failed: test-expr -e -9223372036854775807
$ test-expr 18446744073709551614
0 const_num(18446744073709551614)
$ test-expr 18446744073709551615
0 const_num(18446744073709551615)
$ test-expr 18446744073709551616
test-expr: error:1:1: compiler error: invalid number
test-expr: error:1:1: compiler error: 18446744073709551616
test-expr: error:1:1: compiler error: ^
command failed: test-expr 18446744073709551616
$ test-expr '\''`a`'\''
0 match_str("a")
$ test-expr '\''``'\''
test-expr: error:1:1: compiler error: empty string
test-expr: error:1:1: compiler error: ``
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''``'\''
$ test-expr '\''```'\''
test-expr: error:1:4: compiler error: unexpected end of expression
test-expr: error:1:4: compiler error: ```
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''```'\''
$ test-expr '\''````'\''
0 match_str("`")
$ test-expr '\''`a``b`'\''
0 match_str("a`b")
$ test-expr '\''`a``b``c'\''
test-expr: error:1:9: compiler error: unexpected end of expression
test-expr: error:1:9: compiler error: `a``b``c
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''`a``b``c'\''
$ test-expr '\''`a``b``c`'\''
0 match_str("a`b`c")
$ test-expr '\''/a/'\''
0 match_rex("a")
$ test-expr '\''//'\''
test-expr: error:1:1: compiler error: empty regex
test-expr: error:1:1: compiler error: //
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''//'\''
$ test-expr '\''///'\''
test-expr: error:1:4: compiler error: unexpected end of expression
test-expr: error:1:4: compiler error: ///
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''///'\''
$ test-expr '\''////'\''
0 match_rex("/")
$ test-expr '\''/a//b/'\''
0 match_rex("a/b")
$ test-expr '\''/a//b//c'\''
test-expr: error:1:9: compiler error: unexpected end of expression
test-expr: error:1:9: compiler error: /a//b//c
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''/a//b//c'\''
$ test-expr '\''/a//b//c/'\''
0 match_rex("a/b/c")
$ test-expr "'\''a'\''"
0 match_rex("a")
$ test-expr "'\''a'\''I"
0 match_rex("a","I")
$ test-expr "'\''a'\''S"
0 match_rex("a","S")
$ test-expr "'\''a'\''U"
0 match_rex("a","U")
$ test-expr "'\'''\''"
test-expr: error:1:1: compiler error: empty regex
test-expr: error:1:1: compiler error: '\'''\''
test-expr: error:1:1: compiler error: ^
command failed: test-expr "'\'''\''"
$ test-expr "'\'''\'''\''"
test-expr: error:1:4: compiler error: unexpected end of expression
test-expr: error:1:4: compiler error: '\'''\'''\''
test-expr: error:1:4: compiler error:    ^
command failed: test-expr "'\'''\'''\''"
$ test-expr "'\'''\'''\'''\''"
0 match_rex("'\''")
$ test-expr "'\''a'\'''\''b'\''"
0 match_rex("a'\''b")
$ test-expr "'\''a'\'''\''b'\'''\''c"
test-expr: error:1:9: compiler error: unexpected end of expression
test-expr: error:1:9: compiler error: '\''a'\'''\''b'\'''\''c
test-expr: error:1:9: compiler error:         ^
command failed: test-expr "'\''a'\'''\''b'\'''\''c"
$ test-expr "'\''a'\'''\''b'\'''\''c'\''"
0 match_rex("a'\''b'\''c")
$ test-expr '\''A'\''
0 call_builtin(A)
$ test-expr '\''A()'\''
0 call_builtin(A)
$ test-expr '\''A(1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: A(1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(1)'\''
$ test-expr '\''A(`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: A(`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(`a`)'\''
$ test-expr '\''A(/a/)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(/a/)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(/a/)'\''
$ test-expr '\''A(a)'\''
test-expr: error:1:3: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:3: compiler error: A(a)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(a)'\''
$ test-expr '\''A(a())'\''
test-expr: error:1:3: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:3: compiler error: A(a())
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(a())'\''
$ test-expr '\''A(N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: A(N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(N1)'\''
$ test-expr '\''A(S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: A(S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(S1)'\''
$ test-expr '\''A(N1())'\''
test-expr: error:1:5: compiler error: unexpected token
test-expr: error:1:5: compiler error: A(N1())
test-expr: error:1:5: compiler error:     ^
command failed: test-expr '\''A(N1())'\''
$ test-expr '\''A(S1())'\''
test-expr: error:1:5: compiler error: unexpected token
test-expr: error:1:5: compiler error: A(S1())
test-expr: error:1:5: compiler error:     ^
command failed: test-expr '\''A(S1())'\''
$ test-expr '\''A(#`a`)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(#`a`)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(#`a`)'\''
$ test-expr '\''A(#/a/)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(#/a/)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(#/a/)'\''
$ test-expr '\''A(1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(1,2)'\''
$ test-expr '\''A(1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(1,`a`)'\''
$ test-expr '\''A(1,/a/)'\''
test-expr: error:1:5: compiler error: unexpected token
test-expr: error:1:5: compiler error: A(1,/a/)
test-expr: error:1:5: compiler error:     ^
command failed: test-expr '\''A(1,/a/)'\''
$ test-expr '\''A(1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(1,N1)'\''
$ test-expr '\''A(1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(1,S1)'\''
$ test-expr '\''A(`a`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(`a`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(`a`,1)'\''
$ test-expr '\''A(`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(`a`,`b`)'\''
$ test-expr '\''A(`a`,/b/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A(`a`,/b/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A(`a`,/b/)'\''
$ test-expr '\''A(`a`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(`a`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(`a`,N1)'\''
$ test-expr '\''A(`a`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(`a`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(`a`,S1)'\''
$ test-expr '\''A(/a/,1)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(/a/,1)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(/a/,1)'\''
$ test-expr '\''A(/a/,`b`)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(/a/,`b`)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(/a/,`b`)'\''
$ test-expr '\''A(/a/,/b/)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(/a/,/b/)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(/a/,/b/)'\''
$ test-expr '\''A(/a/,N1)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(/a/,N1)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(/a/,N1)'\''
$ test-expr '\''A(/a/,S1)'\''
test-expr: error:1:3: compiler error: unexpected token
test-expr: error:1:3: compiler error: A(/a/,S1)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''A(/a/,S1)'\''
$ test-expr '\''A(N1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(N1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(N1,1)'\''
$ test-expr '\''A(N1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(N1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(N1,`a`)'\''
$ test-expr '\''A(N1,/a/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A(N1,/a/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A(N1,/a/)'\''
$ test-expr '\''A(N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(N1,N2)'\''
$ test-expr '\''A(N1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(N1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(N1,S1)'\''
$ test-expr '\''A(S1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(S1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(S1,1)'\''
$ test-expr '\''A(S1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(S1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(S1,`a`)'\''
$ test-expr '\''A(S1,/a/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A(S1,/a/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A(S1,/a/)'\''
$ test-expr '\''A(S1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(S1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(S1,N1)'\''
$ test-expr '\''A(S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: A(S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A(S1,S2)'\''
$ test-expr '\''A1()'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: A1()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1()'\''
$ test-expr '\''A1(1)'\''
0 const_num(1)
1 call_builtin(A1)
$ test-expr '\''A1(`a`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A1'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A1(`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(`a`)'\''
$ test-expr '\''A1(/a/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/)'\''
$ test-expr '\''A1(a)'\''
test-expr: error:1:4: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:4: compiler error: A1(a)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(a)'\''
$ test-expr '\''A1(a())'\''
test-expr: error:1:4: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:4: compiler error: A1(a())
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(a())'\''
$ test-expr '\''A1(N1)'\''
0 const_id(N1)
1 call_builtin(A1)
$ test-expr '\''A1(S1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A1'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A1(S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(S1)'\''
$ test-expr '\''A1(N1())'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(N1())
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(N1())'\''
$ test-expr '\''A1(S1())'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(S1())
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(S1())'\''
$ test-expr '\''A1(#`a`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(#`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(#`a`)'\''
$ test-expr '\''A1(#/a/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(#/a/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(#/a/)'\''
$ test-expr '\''A1(1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,2)'\''
$ test-expr '\''A1(1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,`a`)'\''
$ test-expr '\''A1(1,/a/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(1,/a/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(1,/a/)'\''
$ test-expr '\''A1(1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,N1)'\''
$ test-expr '\''A1(1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,S1)'\''
$ test-expr '\''A1(`a`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(`a`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,1)'\''
$ test-expr '\''A1(`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,`b`)'\''
$ test-expr '\''A1(`a`,/b/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A1(`a`,/b/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A1(`a`,/b/)'\''
$ test-expr '\''A1(`a`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(`a`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,N1)'\''
$ test-expr '\''A1(`a`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(`a`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,S1)'\''
$ test-expr '\''A1(/a/,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,1)'\''
$ test-expr '\''A1(/a/,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,`b`)'\''
$ test-expr '\''A1(/a/,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,/b/)'\''
$ test-expr '\''A1(/a/,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,N1)'\''
$ test-expr '\''A1(/a/,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,S1)'\''
$ test-expr '\''A1(N1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(N1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,1)'\''
$ test-expr '\''A1(N1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(N1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,`a`)'\''
$ test-expr '\''A1(N1,/a/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(N1,/a/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(N1,/a/)'\''
$ test-expr '\''A1(N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,N2)'\''
$ test-expr '\''A1(N1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(N1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,S1)'\''
$ test-expr '\''A1(S1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(S1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,1)'\''
$ test-expr '\''A1(S1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(S1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,`a`)'\''
$ test-expr '\''A1(S1,/a/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(S1,/a/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(S1,/a/)'\''
$ test-expr '\''A1(S1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(S1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,N1)'\''
$ test-expr '\''A1(S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: A1(S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,S2)'\''
$ test-expr '\''A1(1,2,3)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,2,3)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,2,3)'\''
$ test-expr '\''A1(1,2,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,2,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,2,`a`)'\''
$ test-expr '\''A1(1,2,/a/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A1(1,2,/a/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A1(1,2,/a/)'\''
$ test-expr '\''A1(1,2,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,2,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,2,N1)'\''
$ test-expr '\''A1(1,2,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,2,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,2,S1)'\''
$ test-expr '\''A1(1,`a`,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,`a`,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,`a`,2)'\''
$ test-expr '\''A1(1,`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,`a`,`b`)'\''
$ test-expr '\''A1(1,`a`,/b/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A1(1,`a`,/b/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A1(1,`a`,/b/)'\''
$ test-expr '\''A1(1,`a`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,`a`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,`a`,N1)'\''
$ test-expr '\''A1(1,`a`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,`a`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,`a`,S1)'\''
$ test-expr '\''A1(1,/a/,2)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(1,/a/,2)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(1,/a/,2)'\''
$ test-expr '\''A1(1,/a/,`b`)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(1,/a/,`b`)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(1,/a/,`b`)'\''
$ test-expr '\''A1(1,/a/,/b/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(1,/a/,/b/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(1,/a/,/b/)'\''
$ test-expr '\''A1(1,/a/,N1)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(1,/a/,N1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(1,/a/,N1)'\''
$ test-expr '\''A1(1,/a/,S1)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A1(1,/a/,S1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A1(1,/a/,S1)'\''
$ test-expr '\''A1(1,N1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,N1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,N1,2)'\''
$ test-expr '\''A1(1,N1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,N1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,N1,`a`)'\''
$ test-expr '\''A1(1,N1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A1(1,N1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A1(1,N1,/a/)'\''
$ test-expr '\''A1(1,N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,N1,N2)'\''
$ test-expr '\''A1(1,N1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,N1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,N1,S1)'\''
$ test-expr '\''A1(1,S1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,S1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,S1,2)'\''
$ test-expr '\''A1(1,S1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,S1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,S1,`a`)'\''
$ test-expr '\''A1(1,S1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A1(1,S1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A1(1,S1,/a/)'\''
$ test-expr '\''A1(1,S1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,S1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,S1,N1)'\''
$ test-expr '\''A1(1,S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(1,S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(1,S1,S2)'\''
$ test-expr '\''A1(`a`,1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,1,2)'\''
$ test-expr '\''A1(`a`,1,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,1,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,1,`b`)'\''
$ test-expr '\''A1(`a`,1,/b/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A1(`a`,1,/b/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A1(`a`,1,/b/)'\''
$ test-expr '\''A1(`a`,1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,1,N1)'\''
$ test-expr '\''A1(`a`,1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,1,S1)'\''
$ test-expr '\''A1(`a`,`b`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,`b`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,`b`,1)'\''
$ test-expr '\''A1(`a`,`b`,`c`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,`b`,`c`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,`b`,`c`)'\''
$ test-expr '\''A1(`a`,`b`,/c/)'\''
test-expr: error:1:12: compiler error: unexpected token
test-expr: error:1:12: compiler error: A1(`a`,`b`,/c/)
test-expr: error:1:12: compiler error:            ^
command failed: test-expr '\''A1(`a`,`b`,/c/)'\''
$ test-expr '\''A1(`a`,`b`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,`b`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,`b`,N1)'\''
$ test-expr '\''A1(`a`,`b`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,`b`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,`b`,S1)'\''
$ test-expr '\''A1(`a`,/b/,1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A1(`a`,/b/,1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A1(`a`,/b/,1)'\''
$ test-expr '\''A1(`a`,/b/,`c`)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A1(`a`,/b/,`c`)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A1(`a`,/b/,`c`)'\''
$ test-expr '\''A1(`a`,/b/,/c/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A1(`a`,/b/,/c/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A1(`a`,/b/,/c/)'\''
$ test-expr '\''A1(`a`,/b/,N1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A1(`a`,/b/,N1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A1(`a`,/b/,N1)'\''
$ test-expr '\''A1(`a`,/b/,S1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A1(`a`,/b/,S1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A1(`a`,/b/,S1)'\''
$ test-expr '\''A1(`a`,N1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,N1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,N1,1)'\''
$ test-expr '\''A1(`a`,N1,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,N1,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,N1,`b`)'\''
$ test-expr '\''A1(`a`,N1,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A1(`a`,N1,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A1(`a`,N1,/b/)'\''
$ test-expr '\''A1(`a`,N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,N1,N2)'\''
$ test-expr '\''A1(`a`,N1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,N1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,N1,S1)'\''
$ test-expr '\''A1(`a`,S1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,S1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,S1,1)'\''
$ test-expr '\''A1(`a`,S1,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,S1,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,S1,`b`)'\''
$ test-expr '\''A1(`a`,S1,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A1(`a`,S1,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A1(`a`,S1,/b/)'\''
$ test-expr '\''A1(`a`,S1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,S1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,S1,N1)'\''
$ test-expr '\''A1(`a`,S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(`a`,S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(`a`,S1,S2)'\''
$ test-expr '\''A1(/a/,1,2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,1,2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,1,2)'\''
$ test-expr '\''A1(/a/,1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,1,`b`)'\''
$ test-expr '\''A1(/a/,1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,1,/b/)'\''
$ test-expr '\''A1(/a/,1,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,1,N1)'\''
$ test-expr '\''A1(/a/,1,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,1,S1)'\''
$ test-expr '\''A1(/a/,`b`,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,`b`,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,`b`,1)'\''
$ test-expr '\''A1(/a/,`b`,`c`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,`b`,`c`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,`b`,`c`)'\''
$ test-expr '\''A1(/a/,`b`,/c/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,`b`,/c/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,`b`,/c/)'\''
$ test-expr '\''A1(/a/,`b`,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,`b`,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,`b`,N1)'\''
$ test-expr '\''A1(/a/,`b`,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,`b`,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,`b`,S1)'\''
$ test-expr '\''A1(/a/,/b/,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,/b/,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,/b/,1)'\''
$ test-expr '\''A1(/a/,/b/,`c`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,/b/,`c`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,/b/,`c`)'\''
$ test-expr '\''A1(/a/,/b/,/c/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,/b/,/c/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,/b/,/c/)'\''
$ test-expr '\''A1(/a/,/b/,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,/b/,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,/b/,N1)'\''
$ test-expr '\''A1(/a/,/b/,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,/b/,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,/b/,S1)'\''
$ test-expr '\''A1(/a/,N1,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,N1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,N1,1)'\''
$ test-expr '\''A1(/a/,N1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,N1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,N1,`b`)'\''
$ test-expr '\''A1(/a/,N1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,N1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,N1,/b/)'\''
$ test-expr '\''A1(/a/,N1,N2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,N1,N2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,N1,N2)'\''
$ test-expr '\''A1(/a/,N1,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,N1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,N1,S1)'\''
$ test-expr '\''A1(/a/,S1,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,S1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,S1,1)'\''
$ test-expr '\''A1(/a/,S1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,S1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,S1,`b`)'\''
$ test-expr '\''A1(/a/,S1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,S1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,S1,/b/)'\''
$ test-expr '\''A1(/a/,S1,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,S1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,S1,N1)'\''
$ test-expr '\''A1(/a/,S1,S2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A1(/a/,S1,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A1(/a/,S1,S2)'\''
$ test-expr '\''A1(N1,1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,1,2)'\''
$ test-expr '\''A1(N1,1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,1,`a`)'\''
$ test-expr '\''A1(N1,1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A1(N1,1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A1(N1,1,/a/)'\''
$ test-expr '\''A1(N1,1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,1,N2)'\''
$ test-expr '\''A1(N1,1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,1,S1)'\''
$ test-expr '\''A1(N1,`a`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,`a`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,`a`,1)'\''
$ test-expr '\''A1(N1,`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,`a`,`b`)'\''
$ test-expr '\''A1(N1,`a`,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A1(N1,`a`,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A1(N1,`a`,/b/)'\''
$ test-expr '\''A1(N1,`a`,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,`a`,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,`a`,N2)'\''
$ test-expr '\''A1(N1,`a`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,`a`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,`a`,S1)'\''
$ test-expr '\''A1(N1,/a/,1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(N1,/a/,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(N1,/a/,1)'\''
$ test-expr '\''A1(N1,/a/,`b`)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(N1,/a/,`b`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(N1,/a/,`b`)'\''
$ test-expr '\''A1(N1,/a/,/b/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(N1,/a/,/b/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(N1,/a/,/b/)'\''
$ test-expr '\''A1(N1,/a/,N2)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(N1,/a/,N2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(N1,/a/,N2)'\''
$ test-expr '\''A1(N1,/a/,S1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(N1,/a/,S1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(N1,/a/,S1)'\''
$ test-expr '\''A1(N1,N2,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,N2,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,N2,1)'\''
$ test-expr '\''A1(N1,N2,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,N2,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,N2,`a`)'\''
$ test-expr '\''A1(N1,N2,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A1(N1,N2,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A1(N1,N2,/a/)'\''
$ test-expr '\''A1(N1,N2,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,N2,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,N2,N1)'\''
$ test-expr '\''A1(N1,N2,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,N2,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,N2,S1)'\''
$ test-expr '\''A1(N1,S1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,S1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,S1,1)'\''
$ test-expr '\''A1(N1,S1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,S1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,S1,`a`)'\''
$ test-expr '\''A1(N1,S1,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A1(N1,S1,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A1(N1,S1,/a/)'\''
$ test-expr '\''A1(N1,S1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,S1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,S1,N2)'\''
$ test-expr '\''A1(N1,S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(N1,S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(N1,S1,S2)'\''
$ test-expr '\''A1(S1,1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,1,2)'\''
$ test-expr '\''A1(S1,1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,1,`a`)'\''
$ test-expr '\''A1(S1,1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A1(S1,1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A1(S1,1,/a/)'\''
$ test-expr '\''A1(S1,1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,1,N1)'\''
$ test-expr '\''A1(S1,1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,1,S2)'\''
$ test-expr '\''A1(S1,`a`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,`a`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,`a`,1)'\''
$ test-expr '\''A1(S1,`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,`a`,`b`)'\''
$ test-expr '\''A1(S1,`a`,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A1(S1,`a`,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A1(S1,`a`,/b/)'\''
$ test-expr '\''A1(S1,`a`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,`a`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,`a`,N1)'\''
$ test-expr '\''A1(S1,`a`,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,`a`,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,`a`,S2)'\''
$ test-expr '\''A1(S1,/a/,1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(S1,/a/,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(S1,/a/,1)'\''
$ test-expr '\''A1(S1,/a/,`b`)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(S1,/a/,`b`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(S1,/a/,`b`)'\''
$ test-expr '\''A1(S1,/a/,/b/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(S1,/a/,/b/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(S1,/a/,/b/)'\''
$ test-expr '\''A1(S1,/a/,N1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(S1,/a/,N1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(S1,/a/,N1)'\''
$ test-expr '\''A1(S1,/a/,S2)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A1(S1,/a/,S2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A1(S1,/a/,S2)'\''
$ test-expr '\''A1(S1,N1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,N1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,N1,1)'\''
$ test-expr '\''A1(S1,N1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,N1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,N1,`a`)'\''
$ test-expr '\''A1(S1,N1,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A1(S1,N1,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A1(S1,N1,/a/)'\''
$ test-expr '\''A1(S1,N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,N1,N2)'\''
$ test-expr '\''A1(S1,N1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,N1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,N1,S2)'\''
$ test-expr '\''A1(S1,S2,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,S2,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,S2,1)'\''
$ test-expr '\''A1(S1,S2,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,S2,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,S2,`a`)'\''
$ test-expr '\''A1(S1,S2,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A1(S1,S2,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A1(S1,S2,/a/)'\''
$ test-expr '\''A1(S1,S2,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,S2,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,S2,N1)'\''
$ test-expr '\''A1(S1,S2,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A1'\'': expected 1 arg, but got 3
test-expr: error:1:1: compiler error: A1(S1,S2,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A1(S1,S2,S1)'\''
$ test-expr '\''A2()'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 0
test-expr: error:1:1: compiler error: A2()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2()'\''
$ test-expr '\''A2(1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 1
test-expr: error:1:1: compiler error: A2(1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1)'\''
$ test-expr '\''A2(`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 1
test-expr: error:1:1: compiler error: A2(`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`)'\''
$ test-expr '\''A2(/a/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/)'\''
$ test-expr '\''A2(a)'\''
test-expr: error:1:4: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:4: compiler error: A2(a)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(a)'\''
$ test-expr '\''A2(a())'\''
test-expr: error:1:4: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:4: compiler error: A2(a())
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(a())'\''
$ test-expr '\''A2(N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 1
test-expr: error:1:1: compiler error: A2(N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1)'\''
$ test-expr '\''A2(S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 1
test-expr: error:1:1: compiler error: A2(S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1)'\''
$ test-expr '\''A2(N1())'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(N1())
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(N1())'\''
$ test-expr '\''A2(S1())'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(S1())
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(S1())'\''
$ test-expr '\''A2(#`a`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(#`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(#`a`)'\''
$ test-expr '\''A2(#/a/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(#/a/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(#/a/)'\''
$ test-expr '\''A2(1,2)'\''
0 const_num(1)
1 const_num(2)
2 call_builtin(A2)
$ test-expr '\''A2(1,`a`)'\''
test-expr: error:1:6: compiler error: builtin function '\''A2'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A2(1,`a`)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,`a`)'\''
$ test-expr '\''A2(1,/a/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(1,/a/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,/a/)'\''
$ test-expr '\''A2(1,N1)'\''
0 const_num(1)
1 const_id(N1)
2 call_builtin(A2)
$ test-expr '\''A2(1,S1)'\''
test-expr: error:1:6: compiler error: builtin function '\''A2'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A2(1,S1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,S1)'\''
$ test-expr '\''A2(`a`,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(`a`,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(`a`,1)'\''
$ test-expr '\''A2(`a`,`b`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(`a`,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(`a`,`b`)'\''
$ test-expr '\''A2(`a`,/b/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A2(`a`,/b/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A2(`a`,/b/)'\''
$ test-expr '\''A2(`a`,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(`a`,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(`a`,N1)'\''
$ test-expr '\''A2(`a`,S1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(`a`,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(`a`,S1)'\''
$ test-expr '\''A2(/a/,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,1)'\''
$ test-expr '\''A2(/a/,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,`b`)'\''
$ test-expr '\''A2(/a/,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,/b/)'\''
$ test-expr '\''A2(/a/,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,N1)'\''
$ test-expr '\''A2(/a/,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,S1)'\''
$ test-expr '\''A2(N1,1)'\''
0 const_id(N1)
1 const_num(1)
2 call_builtin(A2)
$ test-expr '\''A2(N1,`a`)'\''
test-expr: error:1:7: compiler error: builtin function '\''A2'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A2(N1,`a`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,`a`)'\''
$ test-expr '\''A2(N1,/a/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(N1,/a/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,/a/)'\''
$ test-expr '\''A2(N1,N2)'\''
0 const_id(N1)
1 const_id(N2)
2 call_builtin(A2)
$ test-expr '\''A2(N1,S1)'\''
test-expr: error:1:7: compiler error: builtin function '\''A2'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A2(N1,S1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,S1)'\''
$ test-expr '\''A2(S1,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(S1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(S1,1)'\''
$ test-expr '\''A2(S1,`a`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(S1,`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(S1,`a`)'\''
$ test-expr '\''A2(S1,/a/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(S1,/a/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(S1,/a/)'\''
$ test-expr '\''A2(S1,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(S1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(S1,N1)'\''
$ test-expr '\''A2(S1,S2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A2'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A2(S1,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(S1,S2)'\''
$ test-expr '\''A2(1,2,3)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,2,3)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,2,3)'\''
$ test-expr '\''A2(1,2,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,2,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,2,`a`)'\''
$ test-expr '\''A2(1,2,/a/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A2(1,2,/a/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A2(1,2,/a/)'\''
$ test-expr '\''A2(1,2,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,2,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,2,N1)'\''
$ test-expr '\''A2(1,2,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,2,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,2,S1)'\''
$ test-expr '\''A2(1,`a`,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,`a`,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,`a`,2)'\''
$ test-expr '\''A2(1,`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,`a`,`b`)'\''
$ test-expr '\''A2(1,`a`,/b/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A2(1,`a`,/b/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A2(1,`a`,/b/)'\''
$ test-expr '\''A2(1,`a`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,`a`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,`a`,N1)'\''
$ test-expr '\''A2(1,`a`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,`a`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,`a`,S1)'\''
$ test-expr '\''A2(1,/a/,2)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(1,/a/,2)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,/a/,2)'\''
$ test-expr '\''A2(1,/a/,`b`)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(1,/a/,`b`)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,/a/,`b`)'\''
$ test-expr '\''A2(1,/a/,/b/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(1,/a/,/b/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,/a/,/b/)'\''
$ test-expr '\''A2(1,/a/,N1)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(1,/a/,N1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,/a/,N1)'\''
$ test-expr '\''A2(1,/a/,S1)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A2(1,/a/,S1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A2(1,/a/,S1)'\''
$ test-expr '\''A2(1,N1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,N1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,N1,2)'\''
$ test-expr '\''A2(1,N1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,N1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,N1,`a`)'\''
$ test-expr '\''A2(1,N1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A2(1,N1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A2(1,N1,/a/)'\''
$ test-expr '\''A2(1,N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,N1,N2)'\''
$ test-expr '\''A2(1,N1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,N1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,N1,S1)'\''
$ test-expr '\''A2(1,S1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,S1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,S1,2)'\''
$ test-expr '\''A2(1,S1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,S1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,S1,`a`)'\''
$ test-expr '\''A2(1,S1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A2(1,S1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A2(1,S1,/a/)'\''
$ test-expr '\''A2(1,S1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,S1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,S1,N1)'\''
$ test-expr '\''A2(1,S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(1,S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(1,S1,S2)'\''
$ test-expr '\''A2(`a`,1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,1,2)'\''
$ test-expr '\''A2(`a`,1,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,1,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,1,`b`)'\''
$ test-expr '\''A2(`a`,1,/b/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A2(`a`,1,/b/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A2(`a`,1,/b/)'\''
$ test-expr '\''A2(`a`,1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,1,N1)'\''
$ test-expr '\''A2(`a`,1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,1,S1)'\''
$ test-expr '\''A2(`a`,`b`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,`b`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,`b`,1)'\''
$ test-expr '\''A2(`a`,`b`,`c`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,`b`,`c`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,`b`,`c`)'\''
$ test-expr '\''A2(`a`,`b`,/c/)'\''
test-expr: error:1:12: compiler error: unexpected token
test-expr: error:1:12: compiler error: A2(`a`,`b`,/c/)
test-expr: error:1:12: compiler error:            ^
command failed: test-expr '\''A2(`a`,`b`,/c/)'\''
$ test-expr '\''A2(`a`,`b`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,`b`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,`b`,N1)'\''
$ test-expr '\''A2(`a`,`b`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,`b`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,`b`,S1)'\''
$ test-expr '\''A2(`a`,/b/,1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A2(`a`,/b/,1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A2(`a`,/b/,1)'\''
$ test-expr '\''A2(`a`,/b/,`c`)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A2(`a`,/b/,`c`)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A2(`a`,/b/,`c`)'\''
$ test-expr '\''A2(`a`,/b/,/c/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A2(`a`,/b/,/c/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A2(`a`,/b/,/c/)'\''
$ test-expr '\''A2(`a`,/b/,N1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A2(`a`,/b/,N1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A2(`a`,/b/,N1)'\''
$ test-expr '\''A2(`a`,/b/,S1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A2(`a`,/b/,S1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A2(`a`,/b/,S1)'\''
$ test-expr '\''A2(`a`,N1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,N1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,N1,1)'\''
$ test-expr '\''A2(`a`,N1,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,N1,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,N1,`b`)'\''
$ test-expr '\''A2(`a`,N1,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A2(`a`,N1,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A2(`a`,N1,/b/)'\''
$ test-expr '\''A2(`a`,N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,N1,N2)'\''
$ test-expr '\''A2(`a`,N1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,N1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,N1,S1)'\''
$ test-expr '\''A2(`a`,S1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,S1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,S1,1)'\''
$ test-expr '\''A2(`a`,S1,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,S1,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,S1,`b`)'\''
$ test-expr '\''A2(`a`,S1,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A2(`a`,S1,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A2(`a`,S1,/b/)'\''
$ test-expr '\''A2(`a`,S1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,S1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,S1,N1)'\''
$ test-expr '\''A2(`a`,S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(`a`,S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(`a`,S1,S2)'\''
$ test-expr '\''A2(/a/,1,2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,1,2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,1,2)'\''
$ test-expr '\''A2(/a/,1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,1,`b`)'\''
$ test-expr '\''A2(/a/,1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,1,/b/)'\''
$ test-expr '\''A2(/a/,1,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,1,N1)'\''
$ test-expr '\''A2(/a/,1,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,1,S1)'\''
$ test-expr '\''A2(/a/,`b`,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,`b`,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,`b`,1)'\''
$ test-expr '\''A2(/a/,`b`,`c`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,`b`,`c`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,`b`,`c`)'\''
$ test-expr '\''A2(/a/,`b`,/c/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,`b`,/c/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,`b`,/c/)'\''
$ test-expr '\''A2(/a/,`b`,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,`b`,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,`b`,N1)'\''
$ test-expr '\''A2(/a/,`b`,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,`b`,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,`b`,S1)'\''
$ test-expr '\''A2(/a/,/b/,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,/b/,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,/b/,1)'\''
$ test-expr '\''A2(/a/,/b/,`c`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,/b/,`c`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,/b/,`c`)'\''
$ test-expr '\''A2(/a/,/b/,/c/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,/b/,/c/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,/b/,/c/)'\''
$ test-expr '\''A2(/a/,/b/,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,/b/,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,/b/,N1)'\''
$ test-expr '\''A2(/a/,/b/,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,/b/,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,/b/,S1)'\''
$ test-expr '\''A2(/a/,N1,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,N1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,N1,1)'\''
$ test-expr '\''A2(/a/,N1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,N1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,N1,`b`)'\''
$ test-expr '\''A2(/a/,N1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,N1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,N1,/b/)'\''
$ test-expr '\''A2(/a/,N1,N2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,N1,N2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,N1,N2)'\''
$ test-expr '\''A2(/a/,N1,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,N1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,N1,S1)'\''
$ test-expr '\''A2(/a/,S1,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,S1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,S1,1)'\''
$ test-expr '\''A2(/a/,S1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,S1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,S1,`b`)'\''
$ test-expr '\''A2(/a/,S1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,S1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,S1,/b/)'\''
$ test-expr '\''A2(/a/,S1,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,S1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,S1,N1)'\''
$ test-expr '\''A2(/a/,S1,S2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A2(/a/,S1,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A2(/a/,S1,S2)'\''
$ test-expr '\''A2(N1,1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,1,2)'\''
$ test-expr '\''A2(N1,1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,1,`a`)'\''
$ test-expr '\''A2(N1,1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A2(N1,1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A2(N1,1,/a/)'\''
$ test-expr '\''A2(N1,1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,1,N2)'\''
$ test-expr '\''A2(N1,1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,1,S1)'\''
$ test-expr '\''A2(N1,`a`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,`a`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,`a`,1)'\''
$ test-expr '\''A2(N1,`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,`a`,`b`)'\''
$ test-expr '\''A2(N1,`a`,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A2(N1,`a`,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A2(N1,`a`,/b/)'\''
$ test-expr '\''A2(N1,`a`,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,`a`,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,`a`,N2)'\''
$ test-expr '\''A2(N1,`a`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,`a`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,`a`,S1)'\''
$ test-expr '\''A2(N1,/a/,1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(N1,/a/,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,/a/,1)'\''
$ test-expr '\''A2(N1,/a/,`b`)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(N1,/a/,`b`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,/a/,`b`)'\''
$ test-expr '\''A2(N1,/a/,/b/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(N1,/a/,/b/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,/a/,/b/)'\''
$ test-expr '\''A2(N1,/a/,N2)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(N1,/a/,N2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,/a/,N2)'\''
$ test-expr '\''A2(N1,/a/,S1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(N1,/a/,S1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(N1,/a/,S1)'\''
$ test-expr '\''A2(N1,N2,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,N2,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,N2,1)'\''
$ test-expr '\''A2(N1,N2,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,N2,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,N2,`a`)'\''
$ test-expr '\''A2(N1,N2,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A2(N1,N2,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A2(N1,N2,/a/)'\''
$ test-expr '\''A2(N1,N2,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,N2,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,N2,N1)'\''
$ test-expr '\''A2(N1,N2,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,N2,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,N2,S1)'\''
$ test-expr '\''A2(N1,S1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,S1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,S1,1)'\''
$ test-expr '\''A2(N1,S1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,S1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,S1,`a`)'\''
$ test-expr '\''A2(N1,S1,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A2(N1,S1,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A2(N1,S1,/a/)'\''
$ test-expr '\''A2(N1,S1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,S1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,S1,N2)'\''
$ test-expr '\''A2(N1,S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(N1,S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(N1,S1,S2)'\''
$ test-expr '\''A2(S1,1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,1,2)'\''
$ test-expr '\''A2(S1,1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,1,`a`)'\''
$ test-expr '\''A2(S1,1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A2(S1,1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A2(S1,1,/a/)'\''
$ test-expr '\''A2(S1,1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,1,N1)'\''
$ test-expr '\''A2(S1,1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,1,S2)'\''
$ test-expr '\''A2(S1,`a`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,`a`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,`a`,1)'\''
$ test-expr '\''A2(S1,`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,`a`,`b`)'\''
$ test-expr '\''A2(S1,`a`,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A2(S1,`a`,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A2(S1,`a`,/b/)'\''
$ test-expr '\''A2(S1,`a`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,`a`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,`a`,N1)'\''
$ test-expr '\''A2(S1,`a`,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,`a`,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,`a`,S2)'\''
$ test-expr '\''A2(S1,/a/,1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(S1,/a/,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(S1,/a/,1)'\''
$ test-expr '\''A2(S1,/a/,`b`)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(S1,/a/,`b`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(S1,/a/,`b`)'\''
$ test-expr '\''A2(S1,/a/,/b/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(S1,/a/,/b/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(S1,/a/,/b/)'\''
$ test-expr '\''A2(S1,/a/,N1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(S1,/a/,N1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(S1,/a/,N1)'\''
$ test-expr '\''A2(S1,/a/,S2)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A2(S1,/a/,S2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A2(S1,/a/,S2)'\''
$ test-expr '\''A2(S1,N1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,N1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,N1,1)'\''
$ test-expr '\''A2(S1,N1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,N1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,N1,`a`)'\''
$ test-expr '\''A2(S1,N1,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A2(S1,N1,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A2(S1,N1,/a/)'\''
$ test-expr '\''A2(S1,N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,N1,N2)'\''
$ test-expr '\''A2(S1,N1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,N1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,N1,S2)'\''
$ test-expr '\''A2(S1,S2,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,S2,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,S2,1)'\''
$ test-expr '\''A2(S1,S2,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,S2,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,S2,`a`)'\''
$ test-expr '\''A2(S1,S2,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A2(S1,S2,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A2(S1,S2,/a/)'\''
$ test-expr '\''A2(S1,S2,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,S2,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,S2,N1)'\''
$ test-expr '\''A2(S1,S2,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A2'\'': expected 2 args, but got 3
test-expr: error:1:1: compiler error: A2(S1,S2,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A2(S1,S2,S1)'\''
$ test-expr '\''A3()'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 0
test-expr: error:1:1: compiler error: A3()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3()'\''
$ test-expr '\''A3(1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 1
test-expr: error:1:1: compiler error: A3(1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(1)'\''
$ test-expr '\''A3(`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 1
test-expr: error:1:1: compiler error: A3(`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(`a`)'\''
$ test-expr '\''A3(/a/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/)'\''
$ test-expr '\''A3(a)'\''
test-expr: error:1:4: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:4: compiler error: A3(a)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(a)'\''
$ test-expr '\''A3(a())'\''
test-expr: error:1:4: compiler error: builtin '\''a'\'' is not a value
test-expr: error:1:4: compiler error: A3(a())
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(a())'\''
$ test-expr '\''A3(N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 1
test-expr: error:1:1: compiler error: A3(N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(N1)'\''
$ test-expr '\''A3(S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 1
test-expr: error:1:1: compiler error: A3(S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(S1)'\''
$ test-expr '\''A3(N1())'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(N1())
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(N1())'\''
$ test-expr '\''A3(S1())'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(S1())
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(S1())'\''
$ test-expr '\''A3(#`a`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(#`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(#`a`)'\''
$ test-expr '\''A3(#/a/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(#/a/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(#/a/)'\''
$ test-expr '\''A3(1,2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(1,2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(1,2)'\''
$ test-expr '\''A3(1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(1,`a`)'\''
$ test-expr '\''A3(1,/a/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(1,/a/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,/a/)'\''
$ test-expr '\''A3(1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(1,N1)'\''
$ test-expr '\''A3(1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(1,S1)'\''
$ test-expr '\''A3(`a`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(`a`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(`a`,1)'\''
$ test-expr '\''A3(`a`,`b`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(`a`,`b`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(`a`,`b`)'\''
$ test-expr '\''A3(`a`,/b/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A3(`a`,/b/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(`a`,/b/)'\''
$ test-expr '\''A3(`a`,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(`a`,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(`a`,N1)'\''
$ test-expr '\''A3(`a`,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(`a`,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(`a`,S1)'\''
$ test-expr '\''A3(/a/,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,1)'\''
$ test-expr '\''A3(/a/,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,`b`)'\''
$ test-expr '\''A3(/a/,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,/b/)'\''
$ test-expr '\''A3(/a/,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,N1)'\''
$ test-expr '\''A3(/a/,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,S1)'\''
$ test-expr '\''A3(N1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(N1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(N1,1)'\''
$ test-expr '\''A3(N1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(N1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(N1,`a`)'\''
$ test-expr '\''A3(N1,/a/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(N1,/a/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,/a/)'\''
$ test-expr '\''A3(N1,N2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(N1,N2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(N1,N2)'\''
$ test-expr '\''A3(N1,S1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(N1,S1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(N1,S1)'\''
$ test-expr '\''A3(S1,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(S1,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(S1,1)'\''
$ test-expr '\''A3(S1,`a`)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(S1,`a`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(S1,`a`)'\''
$ test-expr '\''A3(S1,/a/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(S1,/a/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(S1,/a/)'\''
$ test-expr '\''A3(S1,N1)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(S1,N1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(S1,N1)'\''
$ test-expr '\''A3(S1,S2)'\''
test-expr: error:1:1: compiler error: builtin function '\''A3'\'': expected 3 args, but got 2
test-expr: error:1:1: compiler error: A3(S1,S2)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''A3(S1,S2)'\''
$ test-expr '\''A3(1,2,3)'\''
0 const_num(1)
1 const_num(2)
2 const_num(3)
3 call_builtin(A3)
$ test-expr '\''A3(1,2,`a`)'\''
test-expr: error:1:8: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:8: compiler error: A3(1,2,`a`)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(1,2,`a`)'\''
$ test-expr '\''A3(1,2,/a/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A3(1,2,/a/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(1,2,/a/)'\''
$ test-expr '\''A3(1,2,N1)'\''
0 const_num(1)
1 const_num(2)
2 const_id(N1)
3 call_builtin(A3)
$ test-expr '\''A3(1,2,S1)'\''
test-expr: error:1:8: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:8: compiler error: A3(1,2,S1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(1,2,S1)'\''
$ test-expr '\''A3(1,`a`,2)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,`a`,2)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,`a`,2)'\''
$ test-expr '\''A3(1,`a`,`b`)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,`a`,`b`)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,`a`,`b`)'\''
$ test-expr '\''A3(1,`a`,/b/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A3(1,`a`,/b/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(1,`a`,/b/)'\''
$ test-expr '\''A3(1,`a`,N1)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,`a`,N1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,`a`,N1)'\''
$ test-expr '\''A3(1,`a`,S1)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,`a`,S1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,`a`,S1)'\''
$ test-expr '\''A3(1,/a/,2)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(1,/a/,2)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,/a/,2)'\''
$ test-expr '\''A3(1,/a/,`b`)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(1,/a/,`b`)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,/a/,`b`)'\''
$ test-expr '\''A3(1,/a/,/b/)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(1,/a/,/b/)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,/a/,/b/)'\''
$ test-expr '\''A3(1,/a/,N1)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(1,/a/,N1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,/a/,N1)'\''
$ test-expr '\''A3(1,/a/,S1)'\''
test-expr: error:1:6: compiler error: unexpected token
test-expr: error:1:6: compiler error: A3(1,/a/,S1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,/a/,S1)'\''
$ test-expr '\''A3(1,N1,2)'\''
0 const_num(1)
1 const_id(N1)
2 const_num(2)
3 call_builtin(A3)
$ test-expr '\''A3(1,N1,`a`)'\''
test-expr: error:1:9: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:9: compiler error: A3(1,N1,`a`)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(1,N1,`a`)'\''
$ test-expr '\''A3(1,N1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A3(1,N1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(1,N1,/a/)'\''
$ test-expr '\''A3(1,N1,N2)'\''
0 const_num(1)
1 const_id(N1)
2 const_id(N2)
3 call_builtin(A3)
$ test-expr '\''A3(1,N1,S1)'\''
test-expr: error:1:9: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:9: compiler error: A3(1,N1,S1)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(1,N1,S1)'\''
$ test-expr '\''A3(1,S1,2)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,S1,2)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,S1,2)'\''
$ test-expr '\''A3(1,S1,`a`)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,S1,`a`)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,S1,`a`)'\''
$ test-expr '\''A3(1,S1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A3(1,S1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(1,S1,/a/)'\''
$ test-expr '\''A3(1,S1,N1)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,S1,N1)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,S1,N1)'\''
$ test-expr '\''A3(1,S1,S2)'\''
test-expr: error:1:6: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:6: compiler error: A3(1,S1,S2)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''A3(1,S1,S2)'\''
$ test-expr '\''A3(`a`,1,2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,1,2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,1,2)'\''
$ test-expr '\''A3(`a`,1,`b`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,1,`b`)'\''
$ test-expr '\''A3(`a`,1,/b/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A3(`a`,1,/b/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(`a`,1,/b/)'\''
$ test-expr '\''A3(`a`,1,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,1,N1)'\''
$ test-expr '\''A3(`a`,1,S1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,1,S1)'\''
$ test-expr '\''A3(`a`,`b`,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,`b`,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,`b`,1)'\''
$ test-expr '\''A3(`a`,`b`,`c`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,`b`,`c`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,`b`,`c`)'\''
$ test-expr '\''A3(`a`,`b`,/c/)'\''
test-expr: error:1:12: compiler error: unexpected token
test-expr: error:1:12: compiler error: A3(`a`,`b`,/c/)
test-expr: error:1:12: compiler error:            ^
command failed: test-expr '\''A3(`a`,`b`,/c/)'\''
$ test-expr '\''A3(`a`,`b`,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,`b`,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,`b`,N1)'\''
$ test-expr '\''A3(`a`,`b`,S1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,`b`,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,`b`,S1)'\''
$ test-expr '\''A3(`a`,/b/,1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A3(`a`,/b/,1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(`a`,/b/,1)'\''
$ test-expr '\''A3(`a`,/b/,`c`)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A3(`a`,/b/,`c`)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(`a`,/b/,`c`)'\''
$ test-expr '\''A3(`a`,/b/,/c/)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A3(`a`,/b/,/c/)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(`a`,/b/,/c/)'\''
$ test-expr '\''A3(`a`,/b/,N1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A3(`a`,/b/,N1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(`a`,/b/,N1)'\''
$ test-expr '\''A3(`a`,/b/,S1)'\''
test-expr: error:1:8: compiler error: unexpected token
test-expr: error:1:8: compiler error: A3(`a`,/b/,S1)
test-expr: error:1:8: compiler error:        ^
command failed: test-expr '\''A3(`a`,/b/,S1)'\''
$ test-expr '\''A3(`a`,N1,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,N1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,N1,1)'\''
$ test-expr '\''A3(`a`,N1,`b`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,N1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,N1,`b`)'\''
$ test-expr '\''A3(`a`,N1,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A3(`a`,N1,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A3(`a`,N1,/b/)'\''
$ test-expr '\''A3(`a`,N1,N2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,N1,N2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,N1,N2)'\''
$ test-expr '\''A3(`a`,N1,S1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,N1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,N1,S1)'\''
$ test-expr '\''A3(`a`,S1,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,S1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,S1,1)'\''
$ test-expr '\''A3(`a`,S1,`b`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,S1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,S1,`b`)'\''
$ test-expr '\''A3(`a`,S1,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A3(`a`,S1,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A3(`a`,S1,/b/)'\''
$ test-expr '\''A3(`a`,S1,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,S1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,S1,N1)'\''
$ test-expr '\''A3(`a`,S1,S2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(`a`,S1,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(`a`,S1,S2)'\''
$ test-expr '\''A3(/a/,1,2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,1,2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,1,2)'\''
$ test-expr '\''A3(/a/,1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,1,`b`)'\''
$ test-expr '\''A3(/a/,1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,1,/b/)'\''
$ test-expr '\''A3(/a/,1,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,1,N1)'\''
$ test-expr '\''A3(/a/,1,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,1,S1)'\''
$ test-expr '\''A3(/a/,`b`,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,`b`,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,`b`,1)'\''
$ test-expr '\''A3(/a/,`b`,`c`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,`b`,`c`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,`b`,`c`)'\''
$ test-expr '\''A3(/a/,`b`,/c/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,`b`,/c/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,`b`,/c/)'\''
$ test-expr '\''A3(/a/,`b`,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,`b`,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,`b`,N1)'\''
$ test-expr '\''A3(/a/,`b`,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,`b`,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,`b`,S1)'\''
$ test-expr '\''A3(/a/,/b/,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,/b/,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,/b/,1)'\''
$ test-expr '\''A3(/a/,/b/,`c`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,/b/,`c`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,/b/,`c`)'\''
$ test-expr '\''A3(/a/,/b/,/c/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,/b/,/c/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,/b/,/c/)'\''
$ test-expr '\''A3(/a/,/b/,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,/b/,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,/b/,N1)'\''
$ test-expr '\''A3(/a/,/b/,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,/b/,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,/b/,S1)'\''
$ test-expr '\''A3(/a/,N1,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,N1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,N1,1)'\''
$ test-expr '\''A3(/a/,N1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,N1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,N1,`b`)'\''
$ test-expr '\''A3(/a/,N1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,N1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,N1,/b/)'\''
$ test-expr '\''A3(/a/,N1,N2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,N1,N2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,N1,N2)'\''
$ test-expr '\''A3(/a/,N1,S1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,N1,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,N1,S1)'\''
$ test-expr '\''A3(/a/,S1,1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,S1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,S1,1)'\''
$ test-expr '\''A3(/a/,S1,`b`)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,S1,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,S1,`b`)'\''
$ test-expr '\''A3(/a/,S1,/b/)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,S1,/b/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,S1,/b/)'\''
$ test-expr '\''A3(/a/,S1,N1)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,S1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,S1,N1)'\''
$ test-expr '\''A3(/a/,S1,S2)'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: A3(/a/,S1,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(/a/,S1,S2)'\''
$ test-expr '\''A3(N1,1,2)'\''
0 const_id(N1)
1 const_num(1)
2 const_num(2)
3 call_builtin(A3)
$ test-expr '\''A3(N1,1,`a`)'\''
test-expr: error:1:9: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:9: compiler error: A3(N1,1,`a`)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(N1,1,`a`)'\''
$ test-expr '\''A3(N1,1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A3(N1,1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(N1,1,/a/)'\''
$ test-expr '\''A3(N1,1,N2)'\''
0 const_id(N1)
1 const_num(1)
2 const_id(N2)
3 call_builtin(A3)
$ test-expr '\''A3(N1,1,S1)'\''
test-expr: error:1:9: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:9: compiler error: A3(N1,1,S1)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(N1,1,S1)'\''
$ test-expr '\''A3(N1,`a`,1)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,`a`,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,`a`,1)'\''
$ test-expr '\''A3(N1,`a`,`b`)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,`a`,`b`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,`a`,`b`)'\''
$ test-expr '\''A3(N1,`a`,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A3(N1,`a`,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A3(N1,`a`,/b/)'\''
$ test-expr '\''A3(N1,`a`,N2)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,`a`,N2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,`a`,N2)'\''
$ test-expr '\''A3(N1,`a`,S1)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,`a`,S1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,`a`,S1)'\''
$ test-expr '\''A3(N1,/a/,1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(N1,/a/,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,/a/,1)'\''
$ test-expr '\''A3(N1,/a/,`b`)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(N1,/a/,`b`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,/a/,`b`)'\''
$ test-expr '\''A3(N1,/a/,/b/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(N1,/a/,/b/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,/a/,/b/)'\''
$ test-expr '\''A3(N1,/a/,N2)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(N1,/a/,N2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,/a/,N2)'\''
$ test-expr '\''A3(N1,/a/,S1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(N1,/a/,S1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,/a/,S1)'\''
$ test-expr '\''A3(N1,N2,1)'\''
0 const_id(N1)
1 const_id(N2)
2 const_num(1)
3 call_builtin(A3)
$ test-expr '\''A3(N1,N2,`a`)'\''
test-expr: error:1:10: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:10: compiler error: A3(N1,N2,`a`)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(N1,N2,`a`)'\''
$ test-expr '\''A3(N1,N2,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A3(N1,N2,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(N1,N2,/a/)'\''
$ test-expr '\''A3(N1,N2,N1)'\''
0 const_id(N1)
1 const_id(N2)
2 const_id(N1)
3 call_builtin(A3)
$ test-expr '\''A3(N1,N2,S1)'\''
test-expr: error:1:10: compiler error: builtin function '\''A3'\'': arg #3 type mismatch: expected a number
test-expr: error:1:10: compiler error: A3(N1,N2,S1)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(N1,N2,S1)'\''
$ test-expr '\''A3(N1,S1,1)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,S1,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,S1,1)'\''
$ test-expr '\''A3(N1,S1,`a`)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,S1,`a`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,S1,`a`)'\''
$ test-expr '\''A3(N1,S1,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A3(N1,S1,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(N1,S1,/a/)'\''
$ test-expr '\''A3(N1,S1,N2)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,S1,N2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,S1,N2)'\''
$ test-expr '\''A3(N1,S1,S2)'\''
test-expr: error:1:7: compiler error: builtin function '\''A3'\'': arg #2 type mismatch: expected a number
test-expr: error:1:7: compiler error: A3(N1,S1,S2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(N1,S1,S2)'\''
$ test-expr '\''A3(S1,1,2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,1,2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,1,2)'\''
$ test-expr '\''A3(S1,1,`a`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,1,`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,1,`a`)'\''
$ test-expr '\''A3(S1,1,/a/)'\''
test-expr: error:1:9: compiler error: unexpected token
test-expr: error:1:9: compiler error: A3(S1,1,/a/)
test-expr: error:1:9: compiler error:         ^
command failed: test-expr '\''A3(S1,1,/a/)'\''
$ test-expr '\''A3(S1,1,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,1,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,1,N1)'\''
$ test-expr '\''A3(S1,1,S2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,1,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,1,S2)'\''
$ test-expr '\''A3(S1,`a`,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,`a`,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,`a`,1)'\''
$ test-expr '\''A3(S1,`a`,`b`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,`a`,`b`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,`a`,`b`)'\''
$ test-expr '\''A3(S1,`a`,/b/)'\''
test-expr: error:1:11: compiler error: unexpected token
test-expr: error:1:11: compiler error: A3(S1,`a`,/b/)
test-expr: error:1:11: compiler error:           ^
command failed: test-expr '\''A3(S1,`a`,/b/)'\''
$ test-expr '\''A3(S1,`a`,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,`a`,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,`a`,N1)'\''
$ test-expr '\''A3(S1,`a`,S2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,`a`,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,`a`,S2)'\''
$ test-expr '\''A3(S1,/a/,1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(S1,/a/,1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(S1,/a/,1)'\''
$ test-expr '\''A3(S1,/a/,`b`)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(S1,/a/,`b`)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(S1,/a/,`b`)'\''
$ test-expr '\''A3(S1,/a/,/b/)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(S1,/a/,/b/)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(S1,/a/,/b/)'\''
$ test-expr '\''A3(S1,/a/,N1)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(S1,/a/,N1)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(S1,/a/,N1)'\''
$ test-expr '\''A3(S1,/a/,S2)'\''
test-expr: error:1:7: compiler error: unexpected token
test-expr: error:1:7: compiler error: A3(S1,/a/,S2)
test-expr: error:1:7: compiler error:       ^
command failed: test-expr '\''A3(S1,/a/,S2)'\''
$ test-expr '\''A3(S1,N1,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,N1,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,N1,1)'\''
$ test-expr '\''A3(S1,N1,`a`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,N1,`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,N1,`a`)'\''
$ test-expr '\''A3(S1,N1,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A3(S1,N1,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(S1,N1,/a/)'\''
$ test-expr '\''A3(S1,N1,N2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,N1,N2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,N1,N2)'\''
$ test-expr '\''A3(S1,N1,S2)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,N1,S2)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,N1,S2)'\''
$ test-expr '\''A3(S1,S2,1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,S2,1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,S2,1)'\''
$ test-expr '\''A3(S1,S2,`a`)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,S2,`a`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,S2,`a`)'\''
$ test-expr '\''A3(S1,S2,/a/)'\''
test-expr: error:1:10: compiler error: unexpected token
test-expr: error:1:10: compiler error: A3(S1,S2,/a/)
test-expr: error:1:10: compiler error:          ^
command failed: test-expr '\''A3(S1,S2,/a/)'\''
$ test-expr '\''A3(S1,S2,N1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,S2,N1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,S2,N1)'\''
$ test-expr '\''A3(S1,S2,S1)'\''
test-expr: error:1:4: compiler error: builtin function '\''A3'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: A3(S1,S2,S1)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''A3(S1,S2,S1)'\''
$ test-expr '\''#1'\''
test-expr: error:1:2: compiler error: unexpected token
test-expr: error:1:2: compiler error: #1
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''#1'\''
$ test-expr '\''#`a`'\''
0 count_str("a")
$ test-expr '\''#/a/'\''
0 count_rex("a")
$ test-expr '\''#a'\''
test-expr: error:1:2: compiler error: unexpected token
test-expr: error:1:2: compiler error: #a
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''#a'\''
$ test-expr '\''#a()'\''
test-expr: error:1:2: compiler error: unexpected token
test-expr: error:1:2: compiler error: #a()
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''#a()'\''
$ test-expr '\''#N1'\''
test-expr: error:1:2: compiler error: unexpected token
test-expr: error:1:2: compiler error: #N1
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''#N1'\''
$ test-expr '\''#S1'\''
test-expr: error:1:2: compiler error: unexpected token
test-expr: error:1:2: compiler error: #S1
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''#S1'\''
$ test-expr '\''!1'\''
0 const_num(1)
1 not_op()
$ test-expr '\''!`a`'\''
0 match_str("a")
1 not_op()
$ test-expr '\''!/a/'\''
0 match_rex("a")
1 not_op()
$ test-expr '\''!a'\''
0 call_builtin(a)
1 not_op()
$ test-expr '\''!a()'\''
0 call_builtin(a)
1 not_op()
$ test-expr '\''!A1(1)'\''
0 const_num(1)
1 call_builtin(A1)
2 not_op()
$ test-expr '\''!N1'\''
test-expr: error:1:2: compiler error: builtin '\''N1'\'' is not a function
test-expr: error:1:2: compiler error: !N1
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''!N1'\''
$ test-expr '\''!S1'\''
test-expr: error:1:2: compiler error: builtin '\''S1'\'' is not a function
test-expr: error:1:2: compiler error: !S1
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''!S1'\''
$ test-expr '\''(1)'\''
0 const_num(1)
$ test-expr '\''(`a`)'\''
0 match_str("a")
$ test-expr '\''(/a/)'\''
0 match_rex("a")
$ test-expr '\''(a)'\''
0 call_builtin(a)
$ test-expr '\''(a())'\''
0 call_builtin(a)
$ test-expr '\''(A1(1))'\''
0 const_num(1)
1 call_builtin(A1)
$ test-expr '\''(N1)'\''
test-expr: error:1:2: compiler error: builtin '\''N1'\'' is not a function
test-expr: error:1:2: compiler error: (N1)
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''(N1)'\''
$ test-expr '\''(S1)'\''
test-expr: error:1:2: compiler error: builtin '\''S1'\'' is not a function
test-expr: error:1:2: compiler error: (S1)
test-expr: error:1:2: compiler error:  ^
command failed: test-expr '\''(S1)'\'''
) -L basic.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ test-expr '\''0'\'''
test-expr '0' 2>&1 ||
echo 'command failed: test-expr '\''0'\'''

echo '$ test-expr '\''1'\'''
test-expr '1' 2>&1 ||
echo 'command failed: test-expr '\''1'\'''

echo '$ test-expr -e '\''-0'\'''
test-expr -e '-0' 2>&1 ||
echo 'command failed: test-expr -e '\''-0'\'''

echo '$ test-expr -e '\''-1'\'''
test-expr -e '-1' 2>&1 ||
echo 'command failed: test-expr -e '\''-1'\'''

echo '$ test-expr 9223372036854775807'
test-expr 9223372036854775807 2>&1 ||
echo 'command failed: test-expr 9223372036854775807'

echo '$ test-expr -e -9223372036854775807'
test-expr -e -9223372036854775807 2>&1 ||
echo 'command failed: test-expr -e -9223372036854775807'

echo '$ test-expr 18446744073709551614'
test-expr 18446744073709551614 2>&1 ||
echo 'command failed: test-expr 18446744073709551614'

echo '$ test-expr 18446744073709551615'
test-expr 18446744073709551615 2>&1 ||
echo 'command failed: test-expr 18446744073709551615'

echo '$ test-expr 18446744073709551616'
test-expr 18446744073709551616 2>&1 ||
echo 'command failed: test-expr 18446744073709551616'

echo '$ test-expr '\''`a`'\'''
test-expr '`a`' 2>&1 ||
echo 'command failed: test-expr '\''`a`'\'''

echo '$ test-expr '\''``'\'''
test-expr '``' 2>&1 ||
echo 'command failed: test-expr '\''``'\'''

echo '$ test-expr '\''```'\'''
test-expr '```' 2>&1 ||
echo 'command failed: test-expr '\''```'\'''

echo '$ test-expr '\''````'\'''
test-expr '````' 2>&1 ||
echo 'command failed: test-expr '\''````'\'''

echo '$ test-expr '\''`a``b`'\'''
test-expr '`a``b`' 2>&1 ||
echo 'command failed: test-expr '\''`a``b`'\'''

echo '$ test-expr '\''`a``b``c'\'''
test-expr '`a``b``c' 2>&1 ||
echo 'command failed: test-expr '\''`a``b``c'\'''

echo '$ test-expr '\''`a``b``c`'\'''
test-expr '`a``b``c`' 2>&1 ||
echo 'command failed: test-expr '\''`a``b``c`'\'''

echo '$ test-expr '\''/a/'\'''
test-expr '/a/' 2>&1 ||
echo 'command failed: test-expr '\''/a/'\'''

echo '$ test-expr '\''//'\'''
test-expr '//' 2>&1 ||
echo 'command failed: test-expr '\''//'\'''

echo '$ test-expr '\''///'\'''
test-expr '///' 2>&1 ||
echo 'command failed: test-expr '\''///'\'''

echo '$ test-expr '\''////'\'''
test-expr '////' 2>&1 ||
echo 'command failed: test-expr '\''////'\'''

echo '$ test-expr '\''/a//b/'\'''
test-expr '/a//b/' 2>&1 ||
echo 'command failed: test-expr '\''/a//b/'\'''

echo '$ test-expr '\''/a//b//c'\'''
test-expr '/a//b//c' 2>&1 ||
echo 'command failed: test-expr '\''/a//b//c'\'''

echo '$ test-expr '\''/a//b//c/'\'''
test-expr '/a//b//c/' 2>&1 ||
echo 'command failed: test-expr '\''/a//b//c/'\'''

echo '$ test-expr "'\''a'\''"'
test-expr "'a'" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''"'

echo '$ test-expr "'\''a'\''I"'
test-expr "'a'I" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''I"'

echo '$ test-expr "'\''a'\''S"'
test-expr "'a'S" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''S"'

echo '$ test-expr "'\''a'\''U"'
test-expr "'a'U" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''U"'

echo '$ test-expr "'\'''\''"'
test-expr "''" 2>&1 ||
echo 'command failed: test-expr "'\'''\''"'

echo '$ test-expr "'\'''\'''\''"'
test-expr "'''" 2>&1 ||
echo 'command failed: test-expr "'\'''\'''\''"'

echo '$ test-expr "'\'''\'''\'''\''"'
test-expr "''''" 2>&1 ||
echo 'command failed: test-expr "'\'''\'''\'''\''"'

echo '$ test-expr "'\''a'\'''\''b'\''"'
test-expr "'a''b'" 2>&1 ||
echo 'command failed: test-expr "'\''a'\'''\''b'\''"'

echo '$ test-expr "'\''a'\'''\''b'\'''\''c"'
test-expr "'a''b''c" 2>&1 ||
echo 'command failed: test-expr "'\''a'\'''\''b'\'''\''c"'

echo '$ test-expr "'\''a'\'''\''b'\'''\''c'\''"'
test-expr "'a''b''c'" 2>&1 ||
echo 'command failed: test-expr "'\''a'\'''\''b'\'''\''c'\''"'

echo '$ test-expr '\''A'\'''
test-expr 'A' 2>&1 ||
echo 'command failed: test-expr '\''A'\'''

echo '$ test-expr '\''A()'\'''
test-expr 'A()' 2>&1 ||
echo 'command failed: test-expr '\''A()'\'''

echo '$ test-expr '\''A(1)'\'''
test-expr 'A(1)' 2>&1 ||
echo 'command failed: test-expr '\''A(1)'\'''

echo '$ test-expr '\''A(`a`)'\'''
test-expr 'A(`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A(`a`)'\'''

echo '$ test-expr '\''A(/a/)'\'''
test-expr 'A(/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A(/a/)'\'''

echo '$ test-expr '\''A(a)'\'''
test-expr 'A(a)' 2>&1 ||
echo 'command failed: test-expr '\''A(a)'\'''

echo '$ test-expr '\''A(a())'\'''
test-expr 'A(a())' 2>&1 ||
echo 'command failed: test-expr '\''A(a())'\'''

echo '$ test-expr '\''A(N1)'\'''
test-expr 'A(N1)' 2>&1 ||
echo 'command failed: test-expr '\''A(N1)'\'''

echo '$ test-expr '\''A(S1)'\'''
test-expr 'A(S1)' 2>&1 ||
echo 'command failed: test-expr '\''A(S1)'\'''

echo '$ test-expr '\''A(N1())'\'''
test-expr 'A(N1())' 2>&1 ||
echo 'command failed: test-expr '\''A(N1())'\'''

echo '$ test-expr '\''A(S1())'\'''
test-expr 'A(S1())' 2>&1 ||
echo 'command failed: test-expr '\''A(S1())'\'''

echo '$ test-expr '\''A(#`a`)'\'''
test-expr 'A(#`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A(#`a`)'\'''

echo '$ test-expr '\''A(#/a/)'\'''
test-expr 'A(#/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A(#/a/)'\'''

echo '$ test-expr '\''A(1,2)'\'''
test-expr 'A(1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A(1,2)'\'''

echo '$ test-expr '\''A(1,`a`)'\'''
test-expr 'A(1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A(1,`a`)'\'''

echo '$ test-expr '\''A(1,/a/)'\'''
test-expr 'A(1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A(1,/a/)'\'''

echo '$ test-expr '\''A(1,N1)'\'''
test-expr 'A(1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A(1,N1)'\'''

echo '$ test-expr '\''A(1,S1)'\'''
test-expr 'A(1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A(1,S1)'\'''

echo '$ test-expr '\''A(`a`,1)'\'''
test-expr 'A(`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A(`a`,1)'\'''

echo '$ test-expr '\''A(`a`,`b`)'\'''
test-expr 'A(`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A(`a`,`b`)'\'''

echo '$ test-expr '\''A(`a`,/b/)'\'''
test-expr 'A(`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A(`a`,/b/)'\'''

echo '$ test-expr '\''A(`a`,N1)'\'''
test-expr 'A(`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A(`a`,N1)'\'''

echo '$ test-expr '\''A(`a`,S1)'\'''
test-expr 'A(`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A(`a`,S1)'\'''

echo '$ test-expr '\''A(/a/,1)'\'''
test-expr 'A(/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A(/a/,1)'\'''

echo '$ test-expr '\''A(/a/,`b`)'\'''
test-expr 'A(/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A(/a/,`b`)'\'''

echo '$ test-expr '\''A(/a/,/b/)'\'''
test-expr 'A(/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A(/a/,/b/)'\'''

echo '$ test-expr '\''A(/a/,N1)'\'''
test-expr 'A(/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A(/a/,N1)'\'''

echo '$ test-expr '\''A(/a/,S1)'\'''
test-expr 'A(/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A(/a/,S1)'\'''

echo '$ test-expr '\''A(N1,1)'\'''
test-expr 'A(N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A(N1,1)'\'''

echo '$ test-expr '\''A(N1,`a`)'\'''
test-expr 'A(N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A(N1,`a`)'\'''

echo '$ test-expr '\''A(N1,/a/)'\'''
test-expr 'A(N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A(N1,/a/)'\'''

echo '$ test-expr '\''A(N1,N2)'\'''
test-expr 'A(N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A(N1,N2)'\'''

echo '$ test-expr '\''A(N1,S1)'\'''
test-expr 'A(N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A(N1,S1)'\'''

echo '$ test-expr '\''A(S1,1)'\'''
test-expr 'A(S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A(S1,1)'\'''

echo '$ test-expr '\''A(S1,`a`)'\'''
test-expr 'A(S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A(S1,`a`)'\'''

echo '$ test-expr '\''A(S1,/a/)'\'''
test-expr 'A(S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A(S1,/a/)'\'''

echo '$ test-expr '\''A(S1,N1)'\'''
test-expr 'A(S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A(S1,N1)'\'''

echo '$ test-expr '\''A(S1,S2)'\'''
test-expr 'A(S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A(S1,S2)'\'''

echo '$ test-expr '\''A1()'\'''
test-expr 'A1()' 2>&1 ||
echo 'command failed: test-expr '\''A1()'\'''

echo '$ test-expr '\''A1(1)'\'''
test-expr 'A1(1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1)'\'''

echo '$ test-expr '\''A1(`a`)'\'''
test-expr 'A1(`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`)'\'''

echo '$ test-expr '\''A1(/a/)'\'''
test-expr 'A1(/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/)'\'''

echo '$ test-expr '\''A1(a)'\'''
test-expr 'A1(a)' 2>&1 ||
echo 'command failed: test-expr '\''A1(a)'\'''

echo '$ test-expr '\''A1(a())'\'''
test-expr 'A1(a())' 2>&1 ||
echo 'command failed: test-expr '\''A1(a())'\'''

echo '$ test-expr '\''A1(N1)'\'''
test-expr 'A1(N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1)'\'''

echo '$ test-expr '\''A1(S1)'\'''
test-expr 'A1(S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1)'\'''

echo '$ test-expr '\''A1(N1())'\'''
test-expr 'A1(N1())' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1())'\'''

echo '$ test-expr '\''A1(S1())'\'''
test-expr 'A1(S1())' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1())'\'''

echo '$ test-expr '\''A1(#`a`)'\'''
test-expr 'A1(#`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(#`a`)'\'''

echo '$ test-expr '\''A1(#/a/)'\'''
test-expr 'A1(#/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(#/a/)'\'''

echo '$ test-expr '\''A1(1,2)'\'''
test-expr 'A1(1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,2)'\'''

echo '$ test-expr '\''A1(1,`a`)'\'''
test-expr 'A1(1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,`a`)'\'''

echo '$ test-expr '\''A1(1,/a/)'\'''
test-expr 'A1(1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,/a/)'\'''

echo '$ test-expr '\''A1(1,N1)'\'''
test-expr 'A1(1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,N1)'\'''

echo '$ test-expr '\''A1(1,S1)'\'''
test-expr 'A1(1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,S1)'\'''

echo '$ test-expr '\''A1(`a`,1)'\'''
test-expr 'A1(`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,1)'\'''

echo '$ test-expr '\''A1(`a`,`b`)'\'''
test-expr 'A1(`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,`b`)'\'''

echo '$ test-expr '\''A1(`a`,/b/)'\'''
test-expr 'A1(`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,/b/)'\'''

echo '$ test-expr '\''A1(`a`,N1)'\'''
test-expr 'A1(`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,N1)'\'''

echo '$ test-expr '\''A1(`a`,S1)'\'''
test-expr 'A1(`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,S1)'\'''

echo '$ test-expr '\''A1(/a/,1)'\'''
test-expr 'A1(/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,1)'\'''

echo '$ test-expr '\''A1(/a/,`b`)'\'''
test-expr 'A1(/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,`b`)'\'''

echo '$ test-expr '\''A1(/a/,/b/)'\'''
test-expr 'A1(/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,/b/)'\'''

echo '$ test-expr '\''A1(/a/,N1)'\'''
test-expr 'A1(/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,N1)'\'''

echo '$ test-expr '\''A1(/a/,S1)'\'''
test-expr 'A1(/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,S1)'\'''

echo '$ test-expr '\''A1(N1,1)'\'''
test-expr 'A1(N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,1)'\'''

echo '$ test-expr '\''A1(N1,`a`)'\'''
test-expr 'A1(N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,`a`)'\'''

echo '$ test-expr '\''A1(N1,/a/)'\'''
test-expr 'A1(N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,/a/)'\'''

echo '$ test-expr '\''A1(N1,N2)'\'''
test-expr 'A1(N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,N2)'\'''

echo '$ test-expr '\''A1(N1,S1)'\'''
test-expr 'A1(N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,S1)'\'''

echo '$ test-expr '\''A1(S1,1)'\'''
test-expr 'A1(S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,1)'\'''

echo '$ test-expr '\''A1(S1,`a`)'\'''
test-expr 'A1(S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,`a`)'\'''

echo '$ test-expr '\''A1(S1,/a/)'\'''
test-expr 'A1(S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,/a/)'\'''

echo '$ test-expr '\''A1(S1,N1)'\'''
test-expr 'A1(S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,N1)'\'''

echo '$ test-expr '\''A1(S1,S2)'\'''
test-expr 'A1(S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,S2)'\'''

echo '$ test-expr '\''A1(1,2,3)'\'''
test-expr 'A1(1,2,3)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,2,3)'\'''

echo '$ test-expr '\''A1(1,2,`a`)'\'''
test-expr 'A1(1,2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,2,`a`)'\'''

echo '$ test-expr '\''A1(1,2,/a/)'\'''
test-expr 'A1(1,2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,2,/a/)'\'''

echo '$ test-expr '\''A1(1,2,N1)'\'''
test-expr 'A1(1,2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,2,N1)'\'''

echo '$ test-expr '\''A1(1,2,S1)'\'''
test-expr 'A1(1,2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,2,S1)'\'''

echo '$ test-expr '\''A1(1,`a`,2)'\'''
test-expr 'A1(1,`a`,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,`a`,2)'\'''

echo '$ test-expr '\''A1(1,`a`,`b`)'\'''
test-expr 'A1(1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,`a`,`b`)'\'''

echo '$ test-expr '\''A1(1,`a`,/b/)'\'''
test-expr 'A1(1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,`a`,/b/)'\'''

echo '$ test-expr '\''A1(1,`a`,N1)'\'''
test-expr 'A1(1,`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,`a`,N1)'\'''

echo '$ test-expr '\''A1(1,`a`,S1)'\'''
test-expr 'A1(1,`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,`a`,S1)'\'''

echo '$ test-expr '\''A1(1,/a/,2)'\'''
test-expr 'A1(1,/a/,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,/a/,2)'\'''

echo '$ test-expr '\''A1(1,/a/,`b`)'\'''
test-expr 'A1(1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,/a/,`b`)'\'''

echo '$ test-expr '\''A1(1,/a/,/b/)'\'''
test-expr 'A1(1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,/a/,/b/)'\'''

echo '$ test-expr '\''A1(1,/a/,N1)'\'''
test-expr 'A1(1,/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,/a/,N1)'\'''

echo '$ test-expr '\''A1(1,/a/,S1)'\'''
test-expr 'A1(1,/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,/a/,S1)'\'''

echo '$ test-expr '\''A1(1,N1,2)'\'''
test-expr 'A1(1,N1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,N1,2)'\'''

echo '$ test-expr '\''A1(1,N1,`a`)'\'''
test-expr 'A1(1,N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,N1,`a`)'\'''

echo '$ test-expr '\''A1(1,N1,/a/)'\'''
test-expr 'A1(1,N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,N1,/a/)'\'''

echo '$ test-expr '\''A1(1,N1,N2)'\'''
test-expr 'A1(1,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,N1,N2)'\'''

echo '$ test-expr '\''A1(1,N1,S1)'\'''
test-expr 'A1(1,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,N1,S1)'\'''

echo '$ test-expr '\''A1(1,S1,2)'\'''
test-expr 'A1(1,S1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,S1,2)'\'''

echo '$ test-expr '\''A1(1,S1,`a`)'\'''
test-expr 'A1(1,S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,S1,`a`)'\'''

echo '$ test-expr '\''A1(1,S1,/a/)'\'''
test-expr 'A1(1,S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,S1,/a/)'\'''

echo '$ test-expr '\''A1(1,S1,N1)'\'''
test-expr 'A1(1,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,S1,N1)'\'''

echo '$ test-expr '\''A1(1,S1,S2)'\'''
test-expr 'A1(1,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(1,S1,S2)'\'''

echo '$ test-expr '\''A1(`a`,1,2)'\'''
test-expr 'A1(`a`,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,1,2)'\'''

echo '$ test-expr '\''A1(`a`,1,`b`)'\'''
test-expr 'A1(`a`,1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,1,`b`)'\'''

echo '$ test-expr '\''A1(`a`,1,/b/)'\'''
test-expr 'A1(`a`,1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,1,/b/)'\'''

echo '$ test-expr '\''A1(`a`,1,N1)'\'''
test-expr 'A1(`a`,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,1,N1)'\'''

echo '$ test-expr '\''A1(`a`,1,S1)'\'''
test-expr 'A1(`a`,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,1,S1)'\'''

echo '$ test-expr '\''A1(`a`,`b`,1)'\'''
test-expr 'A1(`a`,`b`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,`b`,1)'\'''

echo '$ test-expr '\''A1(`a`,`b`,`c`)'\'''
test-expr 'A1(`a`,`b`,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,`b`,`c`)'\'''

echo '$ test-expr '\''A1(`a`,`b`,/c/)'\'''
test-expr 'A1(`a`,`b`,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,`b`,/c/)'\'''

echo '$ test-expr '\''A1(`a`,`b`,N1)'\'''
test-expr 'A1(`a`,`b`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,`b`,N1)'\'''

echo '$ test-expr '\''A1(`a`,`b`,S1)'\'''
test-expr 'A1(`a`,`b`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,`b`,S1)'\'''

echo '$ test-expr '\''A1(`a`,/b/,1)'\'''
test-expr 'A1(`a`,/b/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,/b/,1)'\'''

echo '$ test-expr '\''A1(`a`,/b/,`c`)'\'''
test-expr 'A1(`a`,/b/,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,/b/,`c`)'\'''

echo '$ test-expr '\''A1(`a`,/b/,/c/)'\'''
test-expr 'A1(`a`,/b/,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,/b/,/c/)'\'''

echo '$ test-expr '\''A1(`a`,/b/,N1)'\'''
test-expr 'A1(`a`,/b/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,/b/,N1)'\'''

echo '$ test-expr '\''A1(`a`,/b/,S1)'\'''
test-expr 'A1(`a`,/b/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,/b/,S1)'\'''

echo '$ test-expr '\''A1(`a`,N1,1)'\'''
test-expr 'A1(`a`,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,N1,1)'\'''

echo '$ test-expr '\''A1(`a`,N1,`b`)'\'''
test-expr 'A1(`a`,N1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,N1,`b`)'\'''

echo '$ test-expr '\''A1(`a`,N1,/b/)'\'''
test-expr 'A1(`a`,N1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,N1,/b/)'\'''

echo '$ test-expr '\''A1(`a`,N1,N2)'\'''
test-expr 'A1(`a`,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,N1,N2)'\'''

echo '$ test-expr '\''A1(`a`,N1,S1)'\'''
test-expr 'A1(`a`,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,N1,S1)'\'''

echo '$ test-expr '\''A1(`a`,S1,1)'\'''
test-expr 'A1(`a`,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,S1,1)'\'''

echo '$ test-expr '\''A1(`a`,S1,`b`)'\'''
test-expr 'A1(`a`,S1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,S1,`b`)'\'''

echo '$ test-expr '\''A1(`a`,S1,/b/)'\'''
test-expr 'A1(`a`,S1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,S1,/b/)'\'''

echo '$ test-expr '\''A1(`a`,S1,N1)'\'''
test-expr 'A1(`a`,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,S1,N1)'\'''

echo '$ test-expr '\''A1(`a`,S1,S2)'\'''
test-expr 'A1(`a`,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(`a`,S1,S2)'\'''

echo '$ test-expr '\''A1(/a/,1,2)'\'''
test-expr 'A1(/a/,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,1,2)'\'''

echo '$ test-expr '\''A1(/a/,1,`b`)'\'''
test-expr 'A1(/a/,1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,1,`b`)'\'''

echo '$ test-expr '\''A1(/a/,1,/b/)'\'''
test-expr 'A1(/a/,1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,1,/b/)'\'''

echo '$ test-expr '\''A1(/a/,1,N1)'\'''
test-expr 'A1(/a/,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,1,N1)'\'''

echo '$ test-expr '\''A1(/a/,1,S1)'\'''
test-expr 'A1(/a/,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,1,S1)'\'''

echo '$ test-expr '\''A1(/a/,`b`,1)'\'''
test-expr 'A1(/a/,`b`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,`b`,1)'\'''

echo '$ test-expr '\''A1(/a/,`b`,`c`)'\'''
test-expr 'A1(/a/,`b`,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,`b`,`c`)'\'''

echo '$ test-expr '\''A1(/a/,`b`,/c/)'\'''
test-expr 'A1(/a/,`b`,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,`b`,/c/)'\'''

echo '$ test-expr '\''A1(/a/,`b`,N1)'\'''
test-expr 'A1(/a/,`b`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,`b`,N1)'\'''

echo '$ test-expr '\''A1(/a/,`b`,S1)'\'''
test-expr 'A1(/a/,`b`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,`b`,S1)'\'''

echo '$ test-expr '\''A1(/a/,/b/,1)'\'''
test-expr 'A1(/a/,/b/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,/b/,1)'\'''

echo '$ test-expr '\''A1(/a/,/b/,`c`)'\'''
test-expr 'A1(/a/,/b/,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,/b/,`c`)'\'''

echo '$ test-expr '\''A1(/a/,/b/,/c/)'\'''
test-expr 'A1(/a/,/b/,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,/b/,/c/)'\'''

echo '$ test-expr '\''A1(/a/,/b/,N1)'\'''
test-expr 'A1(/a/,/b/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,/b/,N1)'\'''

echo '$ test-expr '\''A1(/a/,/b/,S1)'\'''
test-expr 'A1(/a/,/b/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,/b/,S1)'\'''

echo '$ test-expr '\''A1(/a/,N1,1)'\'''
test-expr 'A1(/a/,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,N1,1)'\'''

echo '$ test-expr '\''A1(/a/,N1,`b`)'\'''
test-expr 'A1(/a/,N1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,N1,`b`)'\'''

echo '$ test-expr '\''A1(/a/,N1,/b/)'\'''
test-expr 'A1(/a/,N1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,N1,/b/)'\'''

echo '$ test-expr '\''A1(/a/,N1,N2)'\'''
test-expr 'A1(/a/,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,N1,N2)'\'''

echo '$ test-expr '\''A1(/a/,N1,S1)'\'''
test-expr 'A1(/a/,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,N1,S1)'\'''

echo '$ test-expr '\''A1(/a/,S1,1)'\'''
test-expr 'A1(/a/,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,S1,1)'\'''

echo '$ test-expr '\''A1(/a/,S1,`b`)'\'''
test-expr 'A1(/a/,S1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,S1,`b`)'\'''

echo '$ test-expr '\''A1(/a/,S1,/b/)'\'''
test-expr 'A1(/a/,S1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,S1,/b/)'\'''

echo '$ test-expr '\''A1(/a/,S1,N1)'\'''
test-expr 'A1(/a/,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,S1,N1)'\'''

echo '$ test-expr '\''A1(/a/,S1,S2)'\'''
test-expr 'A1(/a/,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(/a/,S1,S2)'\'''

echo '$ test-expr '\''A1(N1,1,2)'\'''
test-expr 'A1(N1,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,1,2)'\'''

echo '$ test-expr '\''A1(N1,1,`a`)'\'''
test-expr 'A1(N1,1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,1,`a`)'\'''

echo '$ test-expr '\''A1(N1,1,/a/)'\'''
test-expr 'A1(N1,1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,1,/a/)'\'''

echo '$ test-expr '\''A1(N1,1,N2)'\'''
test-expr 'A1(N1,1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,1,N2)'\'''

echo '$ test-expr '\''A1(N1,1,S1)'\'''
test-expr 'A1(N1,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,1,S1)'\'''

echo '$ test-expr '\''A1(N1,`a`,1)'\'''
test-expr 'A1(N1,`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,`a`,1)'\'''

echo '$ test-expr '\''A1(N1,`a`,`b`)'\'''
test-expr 'A1(N1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,`a`,`b`)'\'''

echo '$ test-expr '\''A1(N1,`a`,/b/)'\'''
test-expr 'A1(N1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,`a`,/b/)'\'''

echo '$ test-expr '\''A1(N1,`a`,N2)'\'''
test-expr 'A1(N1,`a`,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,`a`,N2)'\'''

echo '$ test-expr '\''A1(N1,`a`,S1)'\'''
test-expr 'A1(N1,`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,`a`,S1)'\'''

echo '$ test-expr '\''A1(N1,/a/,1)'\'''
test-expr 'A1(N1,/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,/a/,1)'\'''

echo '$ test-expr '\''A1(N1,/a/,`b`)'\'''
test-expr 'A1(N1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,/a/,`b`)'\'''

echo '$ test-expr '\''A1(N1,/a/,/b/)'\'''
test-expr 'A1(N1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,/a/,/b/)'\'''

echo '$ test-expr '\''A1(N1,/a/,N2)'\'''
test-expr 'A1(N1,/a/,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,/a/,N2)'\'''

echo '$ test-expr '\''A1(N1,/a/,S1)'\'''
test-expr 'A1(N1,/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,/a/,S1)'\'''

echo '$ test-expr '\''A1(N1,N2,1)'\'''
test-expr 'A1(N1,N2,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,N2,1)'\'''

echo '$ test-expr '\''A1(N1,N2,`a`)'\'''
test-expr 'A1(N1,N2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,N2,`a`)'\'''

echo '$ test-expr '\''A1(N1,N2,/a/)'\'''
test-expr 'A1(N1,N2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,N2,/a/)'\'''

echo '$ test-expr '\''A1(N1,N2,N1)'\'''
test-expr 'A1(N1,N2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,N2,N1)'\'''

echo '$ test-expr '\''A1(N1,N2,S1)'\'''
test-expr 'A1(N1,N2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,N2,S1)'\'''

echo '$ test-expr '\''A1(N1,S1,1)'\'''
test-expr 'A1(N1,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,S1,1)'\'''

echo '$ test-expr '\''A1(N1,S1,`a`)'\'''
test-expr 'A1(N1,S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,S1,`a`)'\'''

echo '$ test-expr '\''A1(N1,S1,/a/)'\'''
test-expr 'A1(N1,S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,S1,/a/)'\'''

echo '$ test-expr '\''A1(N1,S1,N2)'\'''
test-expr 'A1(N1,S1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,S1,N2)'\'''

echo '$ test-expr '\''A1(N1,S1,S2)'\'''
test-expr 'A1(N1,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(N1,S1,S2)'\'''

echo '$ test-expr '\''A1(S1,1,2)'\'''
test-expr 'A1(S1,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,1,2)'\'''

echo '$ test-expr '\''A1(S1,1,`a`)'\'''
test-expr 'A1(S1,1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,1,`a`)'\'''

echo '$ test-expr '\''A1(S1,1,/a/)'\'''
test-expr 'A1(S1,1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,1,/a/)'\'''

echo '$ test-expr '\''A1(S1,1,N1)'\'''
test-expr 'A1(S1,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,1,N1)'\'''

echo '$ test-expr '\''A1(S1,1,S2)'\'''
test-expr 'A1(S1,1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,1,S2)'\'''

echo '$ test-expr '\''A1(S1,`a`,1)'\'''
test-expr 'A1(S1,`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,`a`,1)'\'''

echo '$ test-expr '\''A1(S1,`a`,`b`)'\'''
test-expr 'A1(S1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,`a`,`b`)'\'''

echo '$ test-expr '\''A1(S1,`a`,/b/)'\'''
test-expr 'A1(S1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,`a`,/b/)'\'''

echo '$ test-expr '\''A1(S1,`a`,N1)'\'''
test-expr 'A1(S1,`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,`a`,N1)'\'''

echo '$ test-expr '\''A1(S1,`a`,S2)'\'''
test-expr 'A1(S1,`a`,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,`a`,S2)'\'''

echo '$ test-expr '\''A1(S1,/a/,1)'\'''
test-expr 'A1(S1,/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,/a/,1)'\'''

echo '$ test-expr '\''A1(S1,/a/,`b`)'\'''
test-expr 'A1(S1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,/a/,`b`)'\'''

echo '$ test-expr '\''A1(S1,/a/,/b/)'\'''
test-expr 'A1(S1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,/a/,/b/)'\'''

echo '$ test-expr '\''A1(S1,/a/,N1)'\'''
test-expr 'A1(S1,/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,/a/,N1)'\'''

echo '$ test-expr '\''A1(S1,/a/,S2)'\'''
test-expr 'A1(S1,/a/,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,/a/,S2)'\'''

echo '$ test-expr '\''A1(S1,N1,1)'\'''
test-expr 'A1(S1,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,N1,1)'\'''

echo '$ test-expr '\''A1(S1,N1,`a`)'\'''
test-expr 'A1(S1,N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,N1,`a`)'\'''

echo '$ test-expr '\''A1(S1,N1,/a/)'\'''
test-expr 'A1(S1,N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,N1,/a/)'\'''

echo '$ test-expr '\''A1(S1,N1,N2)'\'''
test-expr 'A1(S1,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,N1,N2)'\'''

echo '$ test-expr '\''A1(S1,N1,S2)'\'''
test-expr 'A1(S1,N1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,N1,S2)'\'''

echo '$ test-expr '\''A1(S1,S2,1)'\'''
test-expr 'A1(S1,S2,1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,S2,1)'\'''

echo '$ test-expr '\''A1(S1,S2,`a`)'\'''
test-expr 'A1(S1,S2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,S2,`a`)'\'''

echo '$ test-expr '\''A1(S1,S2,/a/)'\'''
test-expr 'A1(S1,S2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,S2,/a/)'\'''

echo '$ test-expr '\''A1(S1,S2,N1)'\'''
test-expr 'A1(S1,S2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,S2,N1)'\'''

echo '$ test-expr '\''A1(S1,S2,S1)'\'''
test-expr 'A1(S1,S2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A1(S1,S2,S1)'\'''

echo '$ test-expr '\''A2()'\'''
test-expr 'A2()' 2>&1 ||
echo 'command failed: test-expr '\''A2()'\'''

echo '$ test-expr '\''A2(1)'\'''
test-expr 'A2(1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1)'\'''

echo '$ test-expr '\''A2(`a`)'\'''
test-expr 'A2(`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`)'\'''

echo '$ test-expr '\''A2(/a/)'\'''
test-expr 'A2(/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/)'\'''

echo '$ test-expr '\''A2(a)'\'''
test-expr 'A2(a)' 2>&1 ||
echo 'command failed: test-expr '\''A2(a)'\'''

echo '$ test-expr '\''A2(a())'\'''
test-expr 'A2(a())' 2>&1 ||
echo 'command failed: test-expr '\''A2(a())'\'''

echo '$ test-expr '\''A2(N1)'\'''
test-expr 'A2(N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1)'\'''

echo '$ test-expr '\''A2(S1)'\'''
test-expr 'A2(S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1)'\'''

echo '$ test-expr '\''A2(N1())'\'''
test-expr 'A2(N1())' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1())'\'''

echo '$ test-expr '\''A2(S1())'\'''
test-expr 'A2(S1())' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1())'\'''

echo '$ test-expr '\''A2(#`a`)'\'''
test-expr 'A2(#`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(#`a`)'\'''

echo '$ test-expr '\''A2(#/a/)'\'''
test-expr 'A2(#/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(#/a/)'\'''

echo '$ test-expr '\''A2(1,2)'\'''
test-expr 'A2(1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,2)'\'''

echo '$ test-expr '\''A2(1,`a`)'\'''
test-expr 'A2(1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,`a`)'\'''

echo '$ test-expr '\''A2(1,/a/)'\'''
test-expr 'A2(1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,/a/)'\'''

echo '$ test-expr '\''A2(1,N1)'\'''
test-expr 'A2(1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,N1)'\'''

echo '$ test-expr '\''A2(1,S1)'\'''
test-expr 'A2(1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,S1)'\'''

echo '$ test-expr '\''A2(`a`,1)'\'''
test-expr 'A2(`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,1)'\'''

echo '$ test-expr '\''A2(`a`,`b`)'\'''
test-expr 'A2(`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,`b`)'\'''

echo '$ test-expr '\''A2(`a`,/b/)'\'''
test-expr 'A2(`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,/b/)'\'''

echo '$ test-expr '\''A2(`a`,N1)'\'''
test-expr 'A2(`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,N1)'\'''

echo '$ test-expr '\''A2(`a`,S1)'\'''
test-expr 'A2(`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,S1)'\'''

echo '$ test-expr '\''A2(/a/,1)'\'''
test-expr 'A2(/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,1)'\'''

echo '$ test-expr '\''A2(/a/,`b`)'\'''
test-expr 'A2(/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,`b`)'\'''

echo '$ test-expr '\''A2(/a/,/b/)'\'''
test-expr 'A2(/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,/b/)'\'''

echo '$ test-expr '\''A2(/a/,N1)'\'''
test-expr 'A2(/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,N1)'\'''

echo '$ test-expr '\''A2(/a/,S1)'\'''
test-expr 'A2(/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,S1)'\'''

echo '$ test-expr '\''A2(N1,1)'\'''
test-expr 'A2(N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,1)'\'''

echo '$ test-expr '\''A2(N1,`a`)'\'''
test-expr 'A2(N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,`a`)'\'''

echo '$ test-expr '\''A2(N1,/a/)'\'''
test-expr 'A2(N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,/a/)'\'''

echo '$ test-expr '\''A2(N1,N2)'\'''
test-expr 'A2(N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,N2)'\'''

echo '$ test-expr '\''A2(N1,S1)'\'''
test-expr 'A2(N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,S1)'\'''

echo '$ test-expr '\''A2(S1,1)'\'''
test-expr 'A2(S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,1)'\'''

echo '$ test-expr '\''A2(S1,`a`)'\'''
test-expr 'A2(S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,`a`)'\'''

echo '$ test-expr '\''A2(S1,/a/)'\'''
test-expr 'A2(S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,/a/)'\'''

echo '$ test-expr '\''A2(S1,N1)'\'''
test-expr 'A2(S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,N1)'\'''

echo '$ test-expr '\''A2(S1,S2)'\'''
test-expr 'A2(S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,S2)'\'''

echo '$ test-expr '\''A2(1,2,3)'\'''
test-expr 'A2(1,2,3)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,2,3)'\'''

echo '$ test-expr '\''A2(1,2,`a`)'\'''
test-expr 'A2(1,2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,2,`a`)'\'''

echo '$ test-expr '\''A2(1,2,/a/)'\'''
test-expr 'A2(1,2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,2,/a/)'\'''

echo '$ test-expr '\''A2(1,2,N1)'\'''
test-expr 'A2(1,2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,2,N1)'\'''

echo '$ test-expr '\''A2(1,2,S1)'\'''
test-expr 'A2(1,2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,2,S1)'\'''

echo '$ test-expr '\''A2(1,`a`,2)'\'''
test-expr 'A2(1,`a`,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,`a`,2)'\'''

echo '$ test-expr '\''A2(1,`a`,`b`)'\'''
test-expr 'A2(1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,`a`,`b`)'\'''

echo '$ test-expr '\''A2(1,`a`,/b/)'\'''
test-expr 'A2(1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,`a`,/b/)'\'''

echo '$ test-expr '\''A2(1,`a`,N1)'\'''
test-expr 'A2(1,`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,`a`,N1)'\'''

echo '$ test-expr '\''A2(1,`a`,S1)'\'''
test-expr 'A2(1,`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,`a`,S1)'\'''

echo '$ test-expr '\''A2(1,/a/,2)'\'''
test-expr 'A2(1,/a/,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,/a/,2)'\'''

echo '$ test-expr '\''A2(1,/a/,`b`)'\'''
test-expr 'A2(1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,/a/,`b`)'\'''

echo '$ test-expr '\''A2(1,/a/,/b/)'\'''
test-expr 'A2(1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,/a/,/b/)'\'''

echo '$ test-expr '\''A2(1,/a/,N1)'\'''
test-expr 'A2(1,/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,/a/,N1)'\'''

echo '$ test-expr '\''A2(1,/a/,S1)'\'''
test-expr 'A2(1,/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,/a/,S1)'\'''

echo '$ test-expr '\''A2(1,N1,2)'\'''
test-expr 'A2(1,N1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,N1,2)'\'''

echo '$ test-expr '\''A2(1,N1,`a`)'\'''
test-expr 'A2(1,N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,N1,`a`)'\'''

echo '$ test-expr '\''A2(1,N1,/a/)'\'''
test-expr 'A2(1,N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,N1,/a/)'\'''

echo '$ test-expr '\''A2(1,N1,N2)'\'''
test-expr 'A2(1,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,N1,N2)'\'''

echo '$ test-expr '\''A2(1,N1,S1)'\'''
test-expr 'A2(1,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,N1,S1)'\'''

echo '$ test-expr '\''A2(1,S1,2)'\'''
test-expr 'A2(1,S1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,S1,2)'\'''

echo '$ test-expr '\''A2(1,S1,`a`)'\'''
test-expr 'A2(1,S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,S1,`a`)'\'''

echo '$ test-expr '\''A2(1,S1,/a/)'\'''
test-expr 'A2(1,S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,S1,/a/)'\'''

echo '$ test-expr '\''A2(1,S1,N1)'\'''
test-expr 'A2(1,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,S1,N1)'\'''

echo '$ test-expr '\''A2(1,S1,S2)'\'''
test-expr 'A2(1,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(1,S1,S2)'\'''

echo '$ test-expr '\''A2(`a`,1,2)'\'''
test-expr 'A2(`a`,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,1,2)'\'''

echo '$ test-expr '\''A2(`a`,1,`b`)'\'''
test-expr 'A2(`a`,1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,1,`b`)'\'''

echo '$ test-expr '\''A2(`a`,1,/b/)'\'''
test-expr 'A2(`a`,1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,1,/b/)'\'''

echo '$ test-expr '\''A2(`a`,1,N1)'\'''
test-expr 'A2(`a`,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,1,N1)'\'''

echo '$ test-expr '\''A2(`a`,1,S1)'\'''
test-expr 'A2(`a`,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,1,S1)'\'''

echo '$ test-expr '\''A2(`a`,`b`,1)'\'''
test-expr 'A2(`a`,`b`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,`b`,1)'\'''

echo '$ test-expr '\''A2(`a`,`b`,`c`)'\'''
test-expr 'A2(`a`,`b`,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,`b`,`c`)'\'''

echo '$ test-expr '\''A2(`a`,`b`,/c/)'\'''
test-expr 'A2(`a`,`b`,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,`b`,/c/)'\'''

echo '$ test-expr '\''A2(`a`,`b`,N1)'\'''
test-expr 'A2(`a`,`b`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,`b`,N1)'\'''

echo '$ test-expr '\''A2(`a`,`b`,S1)'\'''
test-expr 'A2(`a`,`b`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,`b`,S1)'\'''

echo '$ test-expr '\''A2(`a`,/b/,1)'\'''
test-expr 'A2(`a`,/b/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,/b/,1)'\'''

echo '$ test-expr '\''A2(`a`,/b/,`c`)'\'''
test-expr 'A2(`a`,/b/,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,/b/,`c`)'\'''

echo '$ test-expr '\''A2(`a`,/b/,/c/)'\'''
test-expr 'A2(`a`,/b/,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,/b/,/c/)'\'''

echo '$ test-expr '\''A2(`a`,/b/,N1)'\'''
test-expr 'A2(`a`,/b/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,/b/,N1)'\'''

echo '$ test-expr '\''A2(`a`,/b/,S1)'\'''
test-expr 'A2(`a`,/b/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,/b/,S1)'\'''

echo '$ test-expr '\''A2(`a`,N1,1)'\'''
test-expr 'A2(`a`,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,N1,1)'\'''

echo '$ test-expr '\''A2(`a`,N1,`b`)'\'''
test-expr 'A2(`a`,N1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,N1,`b`)'\'''

echo '$ test-expr '\''A2(`a`,N1,/b/)'\'''
test-expr 'A2(`a`,N1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,N1,/b/)'\'''

echo '$ test-expr '\''A2(`a`,N1,N2)'\'''
test-expr 'A2(`a`,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,N1,N2)'\'''

echo '$ test-expr '\''A2(`a`,N1,S1)'\'''
test-expr 'A2(`a`,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,N1,S1)'\'''

echo '$ test-expr '\''A2(`a`,S1,1)'\'''
test-expr 'A2(`a`,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,S1,1)'\'''

echo '$ test-expr '\''A2(`a`,S1,`b`)'\'''
test-expr 'A2(`a`,S1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,S1,`b`)'\'''

echo '$ test-expr '\''A2(`a`,S1,/b/)'\'''
test-expr 'A2(`a`,S1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,S1,/b/)'\'''

echo '$ test-expr '\''A2(`a`,S1,N1)'\'''
test-expr 'A2(`a`,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,S1,N1)'\'''

echo '$ test-expr '\''A2(`a`,S1,S2)'\'''
test-expr 'A2(`a`,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(`a`,S1,S2)'\'''

echo '$ test-expr '\''A2(/a/,1,2)'\'''
test-expr 'A2(/a/,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,1,2)'\'''

echo '$ test-expr '\''A2(/a/,1,`b`)'\'''
test-expr 'A2(/a/,1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,1,`b`)'\'''

echo '$ test-expr '\''A2(/a/,1,/b/)'\'''
test-expr 'A2(/a/,1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,1,/b/)'\'''

echo '$ test-expr '\''A2(/a/,1,N1)'\'''
test-expr 'A2(/a/,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,1,N1)'\'''

echo '$ test-expr '\''A2(/a/,1,S1)'\'''
test-expr 'A2(/a/,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,1,S1)'\'''

echo '$ test-expr '\''A2(/a/,`b`,1)'\'''
test-expr 'A2(/a/,`b`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,`b`,1)'\'''

echo '$ test-expr '\''A2(/a/,`b`,`c`)'\'''
test-expr 'A2(/a/,`b`,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,`b`,`c`)'\'''

echo '$ test-expr '\''A2(/a/,`b`,/c/)'\'''
test-expr 'A2(/a/,`b`,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,`b`,/c/)'\'''

echo '$ test-expr '\''A2(/a/,`b`,N1)'\'''
test-expr 'A2(/a/,`b`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,`b`,N1)'\'''

echo '$ test-expr '\''A2(/a/,`b`,S1)'\'''
test-expr 'A2(/a/,`b`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,`b`,S1)'\'''

echo '$ test-expr '\''A2(/a/,/b/,1)'\'''
test-expr 'A2(/a/,/b/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,/b/,1)'\'''

echo '$ test-expr '\''A2(/a/,/b/,`c`)'\'''
test-expr 'A2(/a/,/b/,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,/b/,`c`)'\'''

echo '$ test-expr '\''A2(/a/,/b/,/c/)'\'''
test-expr 'A2(/a/,/b/,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,/b/,/c/)'\'''

echo '$ test-expr '\''A2(/a/,/b/,N1)'\'''
test-expr 'A2(/a/,/b/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,/b/,N1)'\'''

echo '$ test-expr '\''A2(/a/,/b/,S1)'\'''
test-expr 'A2(/a/,/b/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,/b/,S1)'\'''

echo '$ test-expr '\''A2(/a/,N1,1)'\'''
test-expr 'A2(/a/,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,N1,1)'\'''

echo '$ test-expr '\''A2(/a/,N1,`b`)'\'''
test-expr 'A2(/a/,N1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,N1,`b`)'\'''

echo '$ test-expr '\''A2(/a/,N1,/b/)'\'''
test-expr 'A2(/a/,N1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,N1,/b/)'\'''

echo '$ test-expr '\''A2(/a/,N1,N2)'\'''
test-expr 'A2(/a/,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,N1,N2)'\'''

echo '$ test-expr '\''A2(/a/,N1,S1)'\'''
test-expr 'A2(/a/,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,N1,S1)'\'''

echo '$ test-expr '\''A2(/a/,S1,1)'\'''
test-expr 'A2(/a/,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,S1,1)'\'''

echo '$ test-expr '\''A2(/a/,S1,`b`)'\'''
test-expr 'A2(/a/,S1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,S1,`b`)'\'''

echo '$ test-expr '\''A2(/a/,S1,/b/)'\'''
test-expr 'A2(/a/,S1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,S1,/b/)'\'''

echo '$ test-expr '\''A2(/a/,S1,N1)'\'''
test-expr 'A2(/a/,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,S1,N1)'\'''

echo '$ test-expr '\''A2(/a/,S1,S2)'\'''
test-expr 'A2(/a/,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(/a/,S1,S2)'\'''

echo '$ test-expr '\''A2(N1,1,2)'\'''
test-expr 'A2(N1,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,1,2)'\'''

echo '$ test-expr '\''A2(N1,1,`a`)'\'''
test-expr 'A2(N1,1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,1,`a`)'\'''

echo '$ test-expr '\''A2(N1,1,/a/)'\'''
test-expr 'A2(N1,1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,1,/a/)'\'''

echo '$ test-expr '\''A2(N1,1,N2)'\'''
test-expr 'A2(N1,1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,1,N2)'\'''

echo '$ test-expr '\''A2(N1,1,S1)'\'''
test-expr 'A2(N1,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,1,S1)'\'''

echo '$ test-expr '\''A2(N1,`a`,1)'\'''
test-expr 'A2(N1,`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,`a`,1)'\'''

echo '$ test-expr '\''A2(N1,`a`,`b`)'\'''
test-expr 'A2(N1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,`a`,`b`)'\'''

echo '$ test-expr '\''A2(N1,`a`,/b/)'\'''
test-expr 'A2(N1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,`a`,/b/)'\'''

echo '$ test-expr '\''A2(N1,`a`,N2)'\'''
test-expr 'A2(N1,`a`,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,`a`,N2)'\'''

echo '$ test-expr '\''A2(N1,`a`,S1)'\'''
test-expr 'A2(N1,`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,`a`,S1)'\'''

echo '$ test-expr '\''A2(N1,/a/,1)'\'''
test-expr 'A2(N1,/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,/a/,1)'\'''

echo '$ test-expr '\''A2(N1,/a/,`b`)'\'''
test-expr 'A2(N1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,/a/,`b`)'\'''

echo '$ test-expr '\''A2(N1,/a/,/b/)'\'''
test-expr 'A2(N1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,/a/,/b/)'\'''

echo '$ test-expr '\''A2(N1,/a/,N2)'\'''
test-expr 'A2(N1,/a/,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,/a/,N2)'\'''

echo '$ test-expr '\''A2(N1,/a/,S1)'\'''
test-expr 'A2(N1,/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,/a/,S1)'\'''

echo '$ test-expr '\''A2(N1,N2,1)'\'''
test-expr 'A2(N1,N2,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,N2,1)'\'''

echo '$ test-expr '\''A2(N1,N2,`a`)'\'''
test-expr 'A2(N1,N2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,N2,`a`)'\'''

echo '$ test-expr '\''A2(N1,N2,/a/)'\'''
test-expr 'A2(N1,N2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,N2,/a/)'\'''

echo '$ test-expr '\''A2(N1,N2,N1)'\'''
test-expr 'A2(N1,N2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,N2,N1)'\'''

echo '$ test-expr '\''A2(N1,N2,S1)'\'''
test-expr 'A2(N1,N2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,N2,S1)'\'''

echo '$ test-expr '\''A2(N1,S1,1)'\'''
test-expr 'A2(N1,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,S1,1)'\'''

echo '$ test-expr '\''A2(N1,S1,`a`)'\'''
test-expr 'A2(N1,S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,S1,`a`)'\'''

echo '$ test-expr '\''A2(N1,S1,/a/)'\'''
test-expr 'A2(N1,S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,S1,/a/)'\'''

echo '$ test-expr '\''A2(N1,S1,N2)'\'''
test-expr 'A2(N1,S1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,S1,N2)'\'''

echo '$ test-expr '\''A2(N1,S1,S2)'\'''
test-expr 'A2(N1,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(N1,S1,S2)'\'''

echo '$ test-expr '\''A2(S1,1,2)'\'''
test-expr 'A2(S1,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,1,2)'\'''

echo '$ test-expr '\''A2(S1,1,`a`)'\'''
test-expr 'A2(S1,1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,1,`a`)'\'''

echo '$ test-expr '\''A2(S1,1,/a/)'\'''
test-expr 'A2(S1,1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,1,/a/)'\'''

echo '$ test-expr '\''A2(S1,1,N1)'\'''
test-expr 'A2(S1,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,1,N1)'\'''

echo '$ test-expr '\''A2(S1,1,S2)'\'''
test-expr 'A2(S1,1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,1,S2)'\'''

echo '$ test-expr '\''A2(S1,`a`,1)'\'''
test-expr 'A2(S1,`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,`a`,1)'\'''

echo '$ test-expr '\''A2(S1,`a`,`b`)'\'''
test-expr 'A2(S1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,`a`,`b`)'\'''

echo '$ test-expr '\''A2(S1,`a`,/b/)'\'''
test-expr 'A2(S1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,`a`,/b/)'\'''

echo '$ test-expr '\''A2(S1,`a`,N1)'\'''
test-expr 'A2(S1,`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,`a`,N1)'\'''

echo '$ test-expr '\''A2(S1,`a`,S2)'\'''
test-expr 'A2(S1,`a`,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,`a`,S2)'\'''

echo '$ test-expr '\''A2(S1,/a/,1)'\'''
test-expr 'A2(S1,/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,/a/,1)'\'''

echo '$ test-expr '\''A2(S1,/a/,`b`)'\'''
test-expr 'A2(S1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,/a/,`b`)'\'''

echo '$ test-expr '\''A2(S1,/a/,/b/)'\'''
test-expr 'A2(S1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,/a/,/b/)'\'''

echo '$ test-expr '\''A2(S1,/a/,N1)'\'''
test-expr 'A2(S1,/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,/a/,N1)'\'''

echo '$ test-expr '\''A2(S1,/a/,S2)'\'''
test-expr 'A2(S1,/a/,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,/a/,S2)'\'''

echo '$ test-expr '\''A2(S1,N1,1)'\'''
test-expr 'A2(S1,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,N1,1)'\'''

echo '$ test-expr '\''A2(S1,N1,`a`)'\'''
test-expr 'A2(S1,N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,N1,`a`)'\'''

echo '$ test-expr '\''A2(S1,N1,/a/)'\'''
test-expr 'A2(S1,N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,N1,/a/)'\'''

echo '$ test-expr '\''A2(S1,N1,N2)'\'''
test-expr 'A2(S1,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,N1,N2)'\'''

echo '$ test-expr '\''A2(S1,N1,S2)'\'''
test-expr 'A2(S1,N1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,N1,S2)'\'''

echo '$ test-expr '\''A2(S1,S2,1)'\'''
test-expr 'A2(S1,S2,1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,S2,1)'\'''

echo '$ test-expr '\''A2(S1,S2,`a`)'\'''
test-expr 'A2(S1,S2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,S2,`a`)'\'''

echo '$ test-expr '\''A2(S1,S2,/a/)'\'''
test-expr 'A2(S1,S2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,S2,/a/)'\'''

echo '$ test-expr '\''A2(S1,S2,N1)'\'''
test-expr 'A2(S1,S2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,S2,N1)'\'''

echo '$ test-expr '\''A2(S1,S2,S1)'\'''
test-expr 'A2(S1,S2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A2(S1,S2,S1)'\'''

echo '$ test-expr '\''A3()'\'''
test-expr 'A3()' 2>&1 ||
echo 'command failed: test-expr '\''A3()'\'''

echo '$ test-expr '\''A3(1)'\'''
test-expr 'A3(1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1)'\'''

echo '$ test-expr '\''A3(`a`)'\'''
test-expr 'A3(`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`)'\'''

echo '$ test-expr '\''A3(/a/)'\'''
test-expr 'A3(/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/)'\'''

echo '$ test-expr '\''A3(a)'\'''
test-expr 'A3(a)' 2>&1 ||
echo 'command failed: test-expr '\''A3(a)'\'''

echo '$ test-expr '\''A3(a())'\'''
test-expr 'A3(a())' 2>&1 ||
echo 'command failed: test-expr '\''A3(a())'\'''

echo '$ test-expr '\''A3(N1)'\'''
test-expr 'A3(N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1)'\'''

echo '$ test-expr '\''A3(S1)'\'''
test-expr 'A3(S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1)'\'''

echo '$ test-expr '\''A3(N1())'\'''
test-expr 'A3(N1())' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1())'\'''

echo '$ test-expr '\''A3(S1())'\'''
test-expr 'A3(S1())' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1())'\'''

echo '$ test-expr '\''A3(#`a`)'\'''
test-expr 'A3(#`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(#`a`)'\'''

echo '$ test-expr '\''A3(#/a/)'\'''
test-expr 'A3(#/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(#/a/)'\'''

echo '$ test-expr '\''A3(1,2)'\'''
test-expr 'A3(1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,2)'\'''

echo '$ test-expr '\''A3(1,`a`)'\'''
test-expr 'A3(1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,`a`)'\'''

echo '$ test-expr '\''A3(1,/a/)'\'''
test-expr 'A3(1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,/a/)'\'''

echo '$ test-expr '\''A3(1,N1)'\'''
test-expr 'A3(1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,N1)'\'''

echo '$ test-expr '\''A3(1,S1)'\'''
test-expr 'A3(1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,S1)'\'''

echo '$ test-expr '\''A3(`a`,1)'\'''
test-expr 'A3(`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,1)'\'''

echo '$ test-expr '\''A3(`a`,`b`)'\'''
test-expr 'A3(`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,`b`)'\'''

echo '$ test-expr '\''A3(`a`,/b/)'\'''
test-expr 'A3(`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,/b/)'\'''

echo '$ test-expr '\''A3(`a`,N1)'\'''
test-expr 'A3(`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,N1)'\'''

echo '$ test-expr '\''A3(`a`,S1)'\'''
test-expr 'A3(`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,S1)'\'''

echo '$ test-expr '\''A3(/a/,1)'\'''
test-expr 'A3(/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,1)'\'''

echo '$ test-expr '\''A3(/a/,`b`)'\'''
test-expr 'A3(/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,`b`)'\'''

echo '$ test-expr '\''A3(/a/,/b/)'\'''
test-expr 'A3(/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,/b/)'\'''

echo '$ test-expr '\''A3(/a/,N1)'\'''
test-expr 'A3(/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,N1)'\'''

echo '$ test-expr '\''A3(/a/,S1)'\'''
test-expr 'A3(/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,S1)'\'''

echo '$ test-expr '\''A3(N1,1)'\'''
test-expr 'A3(N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,1)'\'''

echo '$ test-expr '\''A3(N1,`a`)'\'''
test-expr 'A3(N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,`a`)'\'''

echo '$ test-expr '\''A3(N1,/a/)'\'''
test-expr 'A3(N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,/a/)'\'''

echo '$ test-expr '\''A3(N1,N2)'\'''
test-expr 'A3(N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,N2)'\'''

echo '$ test-expr '\''A3(N1,S1)'\'''
test-expr 'A3(N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,S1)'\'''

echo '$ test-expr '\''A3(S1,1)'\'''
test-expr 'A3(S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,1)'\'''

echo '$ test-expr '\''A3(S1,`a`)'\'''
test-expr 'A3(S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,`a`)'\'''

echo '$ test-expr '\''A3(S1,/a/)'\'''
test-expr 'A3(S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,/a/)'\'''

echo '$ test-expr '\''A3(S1,N1)'\'''
test-expr 'A3(S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,N1)'\'''

echo '$ test-expr '\''A3(S1,S2)'\'''
test-expr 'A3(S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,S2)'\'''

echo '$ test-expr '\''A3(1,2,3)'\'''
test-expr 'A3(1,2,3)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,2,3)'\'''

echo '$ test-expr '\''A3(1,2,`a`)'\'''
test-expr 'A3(1,2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,2,`a`)'\'''

echo '$ test-expr '\''A3(1,2,/a/)'\'''
test-expr 'A3(1,2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,2,/a/)'\'''

echo '$ test-expr '\''A3(1,2,N1)'\'''
test-expr 'A3(1,2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,2,N1)'\'''

echo '$ test-expr '\''A3(1,2,S1)'\'''
test-expr 'A3(1,2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,2,S1)'\'''

echo '$ test-expr '\''A3(1,`a`,2)'\'''
test-expr 'A3(1,`a`,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,`a`,2)'\'''

echo '$ test-expr '\''A3(1,`a`,`b`)'\'''
test-expr 'A3(1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,`a`,`b`)'\'''

echo '$ test-expr '\''A3(1,`a`,/b/)'\'''
test-expr 'A3(1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,`a`,/b/)'\'''

echo '$ test-expr '\''A3(1,`a`,N1)'\'''
test-expr 'A3(1,`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,`a`,N1)'\'''

echo '$ test-expr '\''A3(1,`a`,S1)'\'''
test-expr 'A3(1,`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,`a`,S1)'\'''

echo '$ test-expr '\''A3(1,/a/,2)'\'''
test-expr 'A3(1,/a/,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,/a/,2)'\'''

echo '$ test-expr '\''A3(1,/a/,`b`)'\'''
test-expr 'A3(1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,/a/,`b`)'\'''

echo '$ test-expr '\''A3(1,/a/,/b/)'\'''
test-expr 'A3(1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,/a/,/b/)'\'''

echo '$ test-expr '\''A3(1,/a/,N1)'\'''
test-expr 'A3(1,/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,/a/,N1)'\'''

echo '$ test-expr '\''A3(1,/a/,S1)'\'''
test-expr 'A3(1,/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,/a/,S1)'\'''

echo '$ test-expr '\''A3(1,N1,2)'\'''
test-expr 'A3(1,N1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,N1,2)'\'''

echo '$ test-expr '\''A3(1,N1,`a`)'\'''
test-expr 'A3(1,N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,N1,`a`)'\'''

echo '$ test-expr '\''A3(1,N1,/a/)'\'''
test-expr 'A3(1,N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,N1,/a/)'\'''

echo '$ test-expr '\''A3(1,N1,N2)'\'''
test-expr 'A3(1,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,N1,N2)'\'''

echo '$ test-expr '\''A3(1,N1,S1)'\'''
test-expr 'A3(1,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,N1,S1)'\'''

echo '$ test-expr '\''A3(1,S1,2)'\'''
test-expr 'A3(1,S1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,S1,2)'\'''

echo '$ test-expr '\''A3(1,S1,`a`)'\'''
test-expr 'A3(1,S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,S1,`a`)'\'''

echo '$ test-expr '\''A3(1,S1,/a/)'\'''
test-expr 'A3(1,S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,S1,/a/)'\'''

echo '$ test-expr '\''A3(1,S1,N1)'\'''
test-expr 'A3(1,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,S1,N1)'\'''

echo '$ test-expr '\''A3(1,S1,S2)'\'''
test-expr 'A3(1,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(1,S1,S2)'\'''

echo '$ test-expr '\''A3(`a`,1,2)'\'''
test-expr 'A3(`a`,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,1,2)'\'''

echo '$ test-expr '\''A3(`a`,1,`b`)'\'''
test-expr 'A3(`a`,1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,1,`b`)'\'''

echo '$ test-expr '\''A3(`a`,1,/b/)'\'''
test-expr 'A3(`a`,1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,1,/b/)'\'''

echo '$ test-expr '\''A3(`a`,1,N1)'\'''
test-expr 'A3(`a`,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,1,N1)'\'''

echo '$ test-expr '\''A3(`a`,1,S1)'\'''
test-expr 'A3(`a`,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,1,S1)'\'''

echo '$ test-expr '\''A3(`a`,`b`,1)'\'''
test-expr 'A3(`a`,`b`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,`b`,1)'\'''

echo '$ test-expr '\''A3(`a`,`b`,`c`)'\'''
test-expr 'A3(`a`,`b`,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,`b`,`c`)'\'''

echo '$ test-expr '\''A3(`a`,`b`,/c/)'\'''
test-expr 'A3(`a`,`b`,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,`b`,/c/)'\'''

echo '$ test-expr '\''A3(`a`,`b`,N1)'\'''
test-expr 'A3(`a`,`b`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,`b`,N1)'\'''

echo '$ test-expr '\''A3(`a`,`b`,S1)'\'''
test-expr 'A3(`a`,`b`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,`b`,S1)'\'''

echo '$ test-expr '\''A3(`a`,/b/,1)'\'''
test-expr 'A3(`a`,/b/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,/b/,1)'\'''

echo '$ test-expr '\''A3(`a`,/b/,`c`)'\'''
test-expr 'A3(`a`,/b/,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,/b/,`c`)'\'''

echo '$ test-expr '\''A3(`a`,/b/,/c/)'\'''
test-expr 'A3(`a`,/b/,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,/b/,/c/)'\'''

echo '$ test-expr '\''A3(`a`,/b/,N1)'\'''
test-expr 'A3(`a`,/b/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,/b/,N1)'\'''

echo '$ test-expr '\''A3(`a`,/b/,S1)'\'''
test-expr 'A3(`a`,/b/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,/b/,S1)'\'''

echo '$ test-expr '\''A3(`a`,N1,1)'\'''
test-expr 'A3(`a`,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,N1,1)'\'''

echo '$ test-expr '\''A3(`a`,N1,`b`)'\'''
test-expr 'A3(`a`,N1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,N1,`b`)'\'''

echo '$ test-expr '\''A3(`a`,N1,/b/)'\'''
test-expr 'A3(`a`,N1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,N1,/b/)'\'''

echo '$ test-expr '\''A3(`a`,N1,N2)'\'''
test-expr 'A3(`a`,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,N1,N2)'\'''

echo '$ test-expr '\''A3(`a`,N1,S1)'\'''
test-expr 'A3(`a`,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,N1,S1)'\'''

echo '$ test-expr '\''A3(`a`,S1,1)'\'''
test-expr 'A3(`a`,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,S1,1)'\'''

echo '$ test-expr '\''A3(`a`,S1,`b`)'\'''
test-expr 'A3(`a`,S1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,S1,`b`)'\'''

echo '$ test-expr '\''A3(`a`,S1,/b/)'\'''
test-expr 'A3(`a`,S1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,S1,/b/)'\'''

echo '$ test-expr '\''A3(`a`,S1,N1)'\'''
test-expr 'A3(`a`,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,S1,N1)'\'''

echo '$ test-expr '\''A3(`a`,S1,S2)'\'''
test-expr 'A3(`a`,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(`a`,S1,S2)'\'''

echo '$ test-expr '\''A3(/a/,1,2)'\'''
test-expr 'A3(/a/,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,1,2)'\'''

echo '$ test-expr '\''A3(/a/,1,`b`)'\'''
test-expr 'A3(/a/,1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,1,`b`)'\'''

echo '$ test-expr '\''A3(/a/,1,/b/)'\'''
test-expr 'A3(/a/,1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,1,/b/)'\'''

echo '$ test-expr '\''A3(/a/,1,N1)'\'''
test-expr 'A3(/a/,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,1,N1)'\'''

echo '$ test-expr '\''A3(/a/,1,S1)'\'''
test-expr 'A3(/a/,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,1,S1)'\'''

echo '$ test-expr '\''A3(/a/,`b`,1)'\'''
test-expr 'A3(/a/,`b`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,`b`,1)'\'''

echo '$ test-expr '\''A3(/a/,`b`,`c`)'\'''
test-expr 'A3(/a/,`b`,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,`b`,`c`)'\'''

echo '$ test-expr '\''A3(/a/,`b`,/c/)'\'''
test-expr 'A3(/a/,`b`,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,`b`,/c/)'\'''

echo '$ test-expr '\''A3(/a/,`b`,N1)'\'''
test-expr 'A3(/a/,`b`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,`b`,N1)'\'''

echo '$ test-expr '\''A3(/a/,`b`,S1)'\'''
test-expr 'A3(/a/,`b`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,`b`,S1)'\'''

echo '$ test-expr '\''A3(/a/,/b/,1)'\'''
test-expr 'A3(/a/,/b/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,/b/,1)'\'''

echo '$ test-expr '\''A3(/a/,/b/,`c`)'\'''
test-expr 'A3(/a/,/b/,`c`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,/b/,`c`)'\'''

echo '$ test-expr '\''A3(/a/,/b/,/c/)'\'''
test-expr 'A3(/a/,/b/,/c/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,/b/,/c/)'\'''

echo '$ test-expr '\''A3(/a/,/b/,N1)'\'''
test-expr 'A3(/a/,/b/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,/b/,N1)'\'''

echo '$ test-expr '\''A3(/a/,/b/,S1)'\'''
test-expr 'A3(/a/,/b/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,/b/,S1)'\'''

echo '$ test-expr '\''A3(/a/,N1,1)'\'''
test-expr 'A3(/a/,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,N1,1)'\'''

echo '$ test-expr '\''A3(/a/,N1,`b`)'\'''
test-expr 'A3(/a/,N1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,N1,`b`)'\'''

echo '$ test-expr '\''A3(/a/,N1,/b/)'\'''
test-expr 'A3(/a/,N1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,N1,/b/)'\'''

echo '$ test-expr '\''A3(/a/,N1,N2)'\'''
test-expr 'A3(/a/,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,N1,N2)'\'''

echo '$ test-expr '\''A3(/a/,N1,S1)'\'''
test-expr 'A3(/a/,N1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,N1,S1)'\'''

echo '$ test-expr '\''A3(/a/,S1,1)'\'''
test-expr 'A3(/a/,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,S1,1)'\'''

echo '$ test-expr '\''A3(/a/,S1,`b`)'\'''
test-expr 'A3(/a/,S1,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,S1,`b`)'\'''

echo '$ test-expr '\''A3(/a/,S1,/b/)'\'''
test-expr 'A3(/a/,S1,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,S1,/b/)'\'''

echo '$ test-expr '\''A3(/a/,S1,N1)'\'''
test-expr 'A3(/a/,S1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,S1,N1)'\'''

echo '$ test-expr '\''A3(/a/,S1,S2)'\'''
test-expr 'A3(/a/,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(/a/,S1,S2)'\'''

echo '$ test-expr '\''A3(N1,1,2)'\'''
test-expr 'A3(N1,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,1,2)'\'''

echo '$ test-expr '\''A3(N1,1,`a`)'\'''
test-expr 'A3(N1,1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,1,`a`)'\'''

echo '$ test-expr '\''A3(N1,1,/a/)'\'''
test-expr 'A3(N1,1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,1,/a/)'\'''

echo '$ test-expr '\''A3(N1,1,N2)'\'''
test-expr 'A3(N1,1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,1,N2)'\'''

echo '$ test-expr '\''A3(N1,1,S1)'\'''
test-expr 'A3(N1,1,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,1,S1)'\'''

echo '$ test-expr '\''A3(N1,`a`,1)'\'''
test-expr 'A3(N1,`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,`a`,1)'\'''

echo '$ test-expr '\''A3(N1,`a`,`b`)'\'''
test-expr 'A3(N1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,`a`,`b`)'\'''

echo '$ test-expr '\''A3(N1,`a`,/b/)'\'''
test-expr 'A3(N1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,`a`,/b/)'\'''

echo '$ test-expr '\''A3(N1,`a`,N2)'\'''
test-expr 'A3(N1,`a`,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,`a`,N2)'\'''

echo '$ test-expr '\''A3(N1,`a`,S1)'\'''
test-expr 'A3(N1,`a`,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,`a`,S1)'\'''

echo '$ test-expr '\''A3(N1,/a/,1)'\'''
test-expr 'A3(N1,/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,/a/,1)'\'''

echo '$ test-expr '\''A3(N1,/a/,`b`)'\'''
test-expr 'A3(N1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,/a/,`b`)'\'''

echo '$ test-expr '\''A3(N1,/a/,/b/)'\'''
test-expr 'A3(N1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,/a/,/b/)'\'''

echo '$ test-expr '\''A3(N1,/a/,N2)'\'''
test-expr 'A3(N1,/a/,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,/a/,N2)'\'''

echo '$ test-expr '\''A3(N1,/a/,S1)'\'''
test-expr 'A3(N1,/a/,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,/a/,S1)'\'''

echo '$ test-expr '\''A3(N1,N2,1)'\'''
test-expr 'A3(N1,N2,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,N2,1)'\'''

echo '$ test-expr '\''A3(N1,N2,`a`)'\'''
test-expr 'A3(N1,N2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,N2,`a`)'\'''

echo '$ test-expr '\''A3(N1,N2,/a/)'\'''
test-expr 'A3(N1,N2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,N2,/a/)'\'''

echo '$ test-expr '\''A3(N1,N2,N1)'\'''
test-expr 'A3(N1,N2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,N2,N1)'\'''

echo '$ test-expr '\''A3(N1,N2,S1)'\'''
test-expr 'A3(N1,N2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,N2,S1)'\'''

echo '$ test-expr '\''A3(N1,S1,1)'\'''
test-expr 'A3(N1,S1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,S1,1)'\'''

echo '$ test-expr '\''A3(N1,S1,`a`)'\'''
test-expr 'A3(N1,S1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,S1,`a`)'\'''

echo '$ test-expr '\''A3(N1,S1,/a/)'\'''
test-expr 'A3(N1,S1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,S1,/a/)'\'''

echo '$ test-expr '\''A3(N1,S1,N2)'\'''
test-expr 'A3(N1,S1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,S1,N2)'\'''

echo '$ test-expr '\''A3(N1,S1,S2)'\'''
test-expr 'A3(N1,S1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(N1,S1,S2)'\'''

echo '$ test-expr '\''A3(S1,1,2)'\'''
test-expr 'A3(S1,1,2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,1,2)'\'''

echo '$ test-expr '\''A3(S1,1,`a`)'\'''
test-expr 'A3(S1,1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,1,`a`)'\'''

echo '$ test-expr '\''A3(S1,1,/a/)'\'''
test-expr 'A3(S1,1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,1,/a/)'\'''

echo '$ test-expr '\''A3(S1,1,N1)'\'''
test-expr 'A3(S1,1,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,1,N1)'\'''

echo '$ test-expr '\''A3(S1,1,S2)'\'''
test-expr 'A3(S1,1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,1,S2)'\'''

echo '$ test-expr '\''A3(S1,`a`,1)'\'''
test-expr 'A3(S1,`a`,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,`a`,1)'\'''

echo '$ test-expr '\''A3(S1,`a`,`b`)'\'''
test-expr 'A3(S1,`a`,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,`a`,`b`)'\'''

echo '$ test-expr '\''A3(S1,`a`,/b/)'\'''
test-expr 'A3(S1,`a`,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,`a`,/b/)'\'''

echo '$ test-expr '\''A3(S1,`a`,N1)'\'''
test-expr 'A3(S1,`a`,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,`a`,N1)'\'''

echo '$ test-expr '\''A3(S1,`a`,S2)'\'''
test-expr 'A3(S1,`a`,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,`a`,S2)'\'''

echo '$ test-expr '\''A3(S1,/a/,1)'\'''
test-expr 'A3(S1,/a/,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,/a/,1)'\'''

echo '$ test-expr '\''A3(S1,/a/,`b`)'\'''
test-expr 'A3(S1,/a/,`b`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,/a/,`b`)'\'''

echo '$ test-expr '\''A3(S1,/a/,/b/)'\'''
test-expr 'A3(S1,/a/,/b/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,/a/,/b/)'\'''

echo '$ test-expr '\''A3(S1,/a/,N1)'\'''
test-expr 'A3(S1,/a/,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,/a/,N1)'\'''

echo '$ test-expr '\''A3(S1,/a/,S2)'\'''
test-expr 'A3(S1,/a/,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,/a/,S2)'\'''

echo '$ test-expr '\''A3(S1,N1,1)'\'''
test-expr 'A3(S1,N1,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,N1,1)'\'''

echo '$ test-expr '\''A3(S1,N1,`a`)'\'''
test-expr 'A3(S1,N1,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,N1,`a`)'\'''

echo '$ test-expr '\''A3(S1,N1,/a/)'\'''
test-expr 'A3(S1,N1,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,N1,/a/)'\'''

echo '$ test-expr '\''A3(S1,N1,N2)'\'''
test-expr 'A3(S1,N1,N2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,N1,N2)'\'''

echo '$ test-expr '\''A3(S1,N1,S2)'\'''
test-expr 'A3(S1,N1,S2)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,N1,S2)'\'''

echo '$ test-expr '\''A3(S1,S2,1)'\'''
test-expr 'A3(S1,S2,1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,S2,1)'\'''

echo '$ test-expr '\''A3(S1,S2,`a`)'\'''
test-expr 'A3(S1,S2,`a`)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,S2,`a`)'\'''

echo '$ test-expr '\''A3(S1,S2,/a/)'\'''
test-expr 'A3(S1,S2,/a/)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,S2,/a/)'\'''

echo '$ test-expr '\''A3(S1,S2,N1)'\'''
test-expr 'A3(S1,S2,N1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,S2,N1)'\'''

echo '$ test-expr '\''A3(S1,S2,S1)'\'''
test-expr 'A3(S1,S2,S1)' 2>&1 ||
echo 'command failed: test-expr '\''A3(S1,S2,S1)'\'''

echo '$ test-expr '\''#1'\'''
test-expr '#1' 2>&1 ||
echo 'command failed: test-expr '\''#1'\'''

echo '$ test-expr '\''#`a`'\'''
test-expr '#`a`' 2>&1 ||
echo 'command failed: test-expr '\''#`a`'\'''

echo '$ test-expr '\''#/a/'\'''
test-expr '#/a/' 2>&1 ||
echo 'command failed: test-expr '\''#/a/'\'''

echo '$ test-expr '\''#a'\'''
test-expr '#a' 2>&1 ||
echo 'command failed: test-expr '\''#a'\'''

echo '$ test-expr '\''#a()'\'''
test-expr '#a()' 2>&1 ||
echo 'command failed: test-expr '\''#a()'\'''

echo '$ test-expr '\''#N1'\'''
test-expr '#N1' 2>&1 ||
echo 'command failed: test-expr '\''#N1'\'''

echo '$ test-expr '\''#S1'\'''
test-expr '#S1' 2>&1 ||
echo 'command failed: test-expr '\''#S1'\'''

echo '$ test-expr '\''!1'\'''
test-expr '!1' 2>&1 ||
echo 'command failed: test-expr '\''!1'\'''

echo '$ test-expr '\''!`a`'\'''
test-expr '!`a`' 2>&1 ||
echo 'command failed: test-expr '\''!`a`'\'''

echo '$ test-expr '\''!/a/'\'''
test-expr '!/a/' 2>&1 ||
echo 'command failed: test-expr '\''!/a/'\'''

echo '$ test-expr '\''!a'\'''
test-expr '!a' 2>&1 ||
echo 'command failed: test-expr '\''!a'\'''

echo '$ test-expr '\''!a()'\'''
test-expr '!a()' 2>&1 ||
echo 'command failed: test-expr '\''!a()'\'''

echo '$ test-expr '\''!A1(1)'\'''
test-expr '!A1(1)' 2>&1 ||
echo 'command failed: test-expr '\''!A1(1)'\'''

echo '$ test-expr '\''!N1'\'''
test-expr '!N1' 2>&1 ||
echo 'command failed: test-expr '\''!N1'\'''

echo '$ test-expr '\''!S1'\'''
test-expr '!S1' 2>&1 ||
echo 'command failed: test-expr '\''!S1'\'''

echo '$ test-expr '\''(1)'\'''
test-expr '(1)' 2>&1 ||
echo 'command failed: test-expr '\''(1)'\'''

echo '$ test-expr '\''(`a`)'\'''
test-expr '(`a`)' 2>&1 ||
echo 'command failed: test-expr '\''(`a`)'\'''

echo '$ test-expr '\''(/a/)'\'''
test-expr '(/a/)' 2>&1 ||
echo 'command failed: test-expr '\''(/a/)'\'''

echo '$ test-expr '\''(a)'\'''
test-expr '(a)' 2>&1 ||
echo 'command failed: test-expr '\''(a)'\'''

echo '$ test-expr '\''(a())'\'''
test-expr '(a())' 2>&1 ||
echo 'command failed: test-expr '\''(a())'\'''

echo '$ test-expr '\''(A1(1))'\'''
test-expr '(A1(1))' 2>&1 ||
echo 'command failed: test-expr '\''(A1(1))'\'''

echo '$ test-expr '\''(N1)'\'''
test-expr '(N1)' 2>&1 ||
echo 'command failed: test-expr '\''(N1)'\'''

echo '$ test-expr '\''(S1)'\'''
test-expr '(S1)' 2>&1 ||
echo 'command failed: test-expr '\''(S1)'\'''
)

