#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:dyn-lib2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dyn-lib2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ json() { json0 -F "$@"; }
$ json ./foo.so
json: error: ./foo.so: filter library: failed loading library
command failed: json ./foo.so
$ json -- ./foo.so
json: error: ./foo.so: filter library: failed loading library
command failed: json -- ./foo.so
$ json -- ./foo.so a b c
json: error: ./foo.so: filter library: failed loading library
command failed: json -- ./foo.so a b c
$ json -- ./foo.so -- ./bar.so
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
json: error: ./foo.so: filter library: failed loading library
command failed: json -- ./foo.so -- ./bar.so
$ json -- ./foo.so a b c -- ./bar.so d e
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
json: error: ./foo.so: filter library: failed loading library
command failed: json -- ./foo.so a b c -- ./bar.so d e
$ json -V ./foo.so
json: error: ./foo.so: filter library: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V ./foo.so
$ json -V -- ./foo.so
json: error: ./foo.so: filter library: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so
$ json -V -- ./foo.so a b c
json: error: ./foo.so: filter library: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so a b c
$ json -V -- ./foo.so -- ./bar.so
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
json: error: ./foo.so: filter library: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so -- ./bar.so
$ json -V -- ./foo.so a b c -- ./bar.so d e
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
json: error: ./foo.so: filter library: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so a b c -- ./bar.so d e
$ json() { json0 -f "$@" <<< '\'''\''; }
$ json -F -- ./foo.so
json: error: ./foo.so: filter library: failed loading library
command failed: json -F -- ./foo.so
$ json -F -- ./foo.so -- ./bar.so
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
json: error: ./foo.so: filter library: failed loading library
command failed: json -F -- ./foo.so -- ./bar.so
$ json -- ./foo.so
json: error: ./foo.so: filter library: failed loading library
command failed: json -- ./foo.so
$ json -- ./foo.so a b c
json: error: ./foo.so: filter library: failed loading library
command failed: json -- ./foo.so a b c
$ json -- ./foo.so -- ./bar.so
json: error: ./foo.so: filter library #1: failed loading library
command failed: json -- ./foo.so -- ./bar.so
$ json -- ./foo.so a b c -- ./bar.so d e
json: error: ./foo.so: filter library #1: failed loading library
command failed: json -- ./foo.so a b c -- ./bar.so d e
$ json -V ./foo.so
json: error: option `-f|--filter-libs'\'' requires at least one filter command line arguments group
command failed: json -V ./foo.so
$ json -V -- ./foo.so
json: error: ./foo.so: filter library: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so
$ json -V -- ./foo.so a b c
json: error: ./foo.so: filter library: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so a b c
$ json -V -- ./foo.so -- ./bar.so
json: error: ./foo.so: filter library #1: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so -- ./bar.so
$ json -V -- ./foo.so a b c -- ./bar.so d e
json: error: ./foo.so: filter library #1: failed loading library: dlopen failed: ./foo.so: cannot open shared object file: No such file or directory
command failed: json -V -- ./foo.so a b c -- ./bar.so d e'
) -L dyn-lib2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ json() { json0 -F "$@"; }'
json() { json0 -F "$@"; } 2>&1 ||
echo 'command failed: json() { json0 -F "$@"; }'

echo '$ json ./foo.so'
json ./foo.so 2>&1 ||
echo 'command failed: json ./foo.so'

echo '$ json -- ./foo.so'
json -- ./foo.so 2>&1 ||
echo 'command failed: json -- ./foo.so'

echo '$ json -- ./foo.so a b c'
json -- ./foo.so a b c 2>&1 ||
echo 'command failed: json -- ./foo.so a b c'

echo '$ json -- ./foo.so -- ./bar.so'
json -- ./foo.so -- ./bar.so 2>&1 ||
echo 'command failed: json -- ./foo.so -- ./bar.so'

echo '$ json -- ./foo.so a b c -- ./bar.so d e'
json -- ./foo.so a b c -- ./bar.so d e 2>&1 ||
echo 'command failed: json -- ./foo.so a b c -- ./bar.so d e'

echo '$ json -V ./foo.so'
json -V ./foo.so 2>&1 ||
echo 'command failed: json -V ./foo.so'

echo '$ json -V -- ./foo.so'
json -V -- ./foo.so 2>&1 ||
echo 'command failed: json -V -- ./foo.so'

echo '$ json -V -- ./foo.so a b c'
json -V -- ./foo.so a b c 2>&1 ||
echo 'command failed: json -V -- ./foo.so a b c'

echo '$ json -V -- ./foo.so -- ./bar.so'
json -V -- ./foo.so -- ./bar.so 2>&1 ||
echo 'command failed: json -V -- ./foo.so -- ./bar.so'

echo '$ json -V -- ./foo.so a b c -- ./bar.so d e'
json -V -- ./foo.so a b c -- ./bar.so d e 2>&1 ||
echo 'command failed: json -V -- ./foo.so a b c -- ./bar.so d e'

echo '$ json() { json0 -f "$@" <<< '\'''\''; }'
json() { json0 -f "$@" <<< ''; } 2>&1 ||
echo 'command failed: json() { json0 -f "$@" <<< '\'''\''; }'

echo '$ json -F -- ./foo.so'
json -F -- ./foo.so 2>&1 ||
echo 'command failed: json -F -- ./foo.so'

echo '$ json -F -- ./foo.so -- ./bar.so'
json -F -- ./foo.so -- ./bar.so 2>&1 ||
echo 'command failed: json -F -- ./foo.so -- ./bar.so'

echo '$ json -- ./foo.so'
json -- ./foo.so 2>&1 ||
echo 'command failed: json -- ./foo.so'

echo '$ json -- ./foo.so a b c'
json -- ./foo.so a b c 2>&1 ||
echo 'command failed: json -- ./foo.so a b c'

echo '$ json -- ./foo.so -- ./bar.so'
json -- ./foo.so -- ./bar.so 2>&1 ||
echo 'command failed: json -- ./foo.so -- ./bar.so'

echo '$ json -- ./foo.so a b c -- ./bar.so d e'
json -- ./foo.so a b c -- ./bar.so d e 2>&1 ||
echo 'command failed: json -- ./foo.so a b c -- ./bar.so d e'

echo '$ json -V ./foo.so'
json -V ./foo.so 2>&1 ||
echo 'command failed: json -V ./foo.so'

echo '$ json -V -- ./foo.so'
json -V -- ./foo.so 2>&1 ||
echo 'command failed: json -V -- ./foo.so'

echo '$ json -V -- ./foo.so a b c'
json -V -- ./foo.so a b c 2>&1 ||
echo 'command failed: json -V -- ./foo.so a b c'

echo '$ json -V -- ./foo.so -- ./bar.so'
json -V -- ./foo.so -- ./bar.so 2>&1 ||
echo 'command failed: json -V -- ./foo.so -- ./bar.so'

echo '$ json -V -- ./foo.so a b c -- ./bar.so d e'
json -V -- ./foo.so a b c -- ./bar.so d e 2>&1 ||
echo 'command failed: json -V -- ./foo.so a b c -- ./bar.so d e'
)

