#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:ascii
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L ascii.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }
$ squote() { sed -r '\''s/^[#$]/\\\0/'\''; }
$ set -o pipefail
$ echo -ne '\''\x0'\''|json -b 1
\u0000
$ echo -ne '\''\x0'\''|json -b 2
\u0000
$ echo -ne '\''\x0'\''|json -b 3
\u0000
$ echo -ne '\''\x1'\''|json -b 1
\u0001
$ echo -ne '\''\x1'\''|json -b 2
\u0001
$ echo -ne '\''\x1'\''|json -b 3
\u0001
$ echo -ne '\''\x2'\''|json -b 1
\u0002
$ echo -ne '\''\x2'\''|json -b 2
\u0002
$ echo -ne '\''\x2'\''|json -b 3
\u0002
$ echo -ne '\''\x3'\''|json -b 1
\u0003
$ echo -ne '\''\x3'\''|json -b 2
\u0003
$ echo -ne '\''\x3'\''|json -b 3
\u0003
$ echo -ne '\''\x4'\''|json -b 1
\u0004
$ echo -ne '\''\x4'\''|json -b 2
\u0004
$ echo -ne '\''\x4'\''|json -b 3
\u0004
$ echo -ne '\''\x5'\''|json -b 1
\u0005
$ echo -ne '\''\x5'\''|json -b 2
\u0005
$ echo -ne '\''\x5'\''|json -b 3
\u0005
$ echo -ne '\''\x6'\''|json -b 1
\u0006
$ echo -ne '\''\x6'\''|json -b 2
\u0006
$ echo -ne '\''\x6'\''|json -b 3
\u0006
$ echo -ne '\''\x7'\''|json -b 1
\u0007
$ echo -ne '\''\x7'\''|json -b 2
\u0007
$ echo -ne '\''\x7'\''|json -b 3
\u0007
$ echo -ne '\''\x8'\''|json -b 1
\b
$ echo -ne '\''\x8'\''|json -b 2
\b
$ echo -ne '\''\x8'\''|json -b 3
\b
$ echo -ne '\''\x9'\''|json -b 1
\t
$ echo -ne '\''\x9'\''|json -b 2
\t
$ echo -ne '\''\x9'\''|json -b 3
\t
$ echo -ne '\''\xa'\''|json -b 1
\n
$ echo -ne '\''\xa'\''|json -b 2
\n
$ echo -ne '\''\xa'\''|json -b 3
\n
$ echo -ne '\''\xb'\''|json -b 1
\u000b
$ echo -ne '\''\xb'\''|json -b 2
\u000b
$ echo -ne '\''\xb'\''|json -b 3
\u000b
$ echo -ne '\''\xc'\''|json -b 1
\f
$ echo -ne '\''\xc'\''|json -b 2
\f
$ echo -ne '\''\xc'\''|json -b 3
\f
$ echo -ne '\''\xd'\''|json -b 1
\r
$ echo -ne '\''\xd'\''|json -b 2
\r
$ echo -ne '\''\xd'\''|json -b 3
\r
$ echo -ne '\''\xe'\''|json -b 1
\u000e
$ echo -ne '\''\xe'\''|json -b 2
\u000e
$ echo -ne '\''\xe'\''|json -b 3
\u000e
$ echo -ne '\''\xf'\''|json -b 1
\u000f
$ echo -ne '\''\xf'\''|json -b 2
\u000f
$ echo -ne '\''\xf'\''|json -b 3
\u000f
$ echo -ne '\''\x10'\''|json -b 1
\u0010
$ echo -ne '\''\x10'\''|json -b 2
\u0010
$ echo -ne '\''\x10'\''|json -b 3
\u0010
$ echo -ne '\''\x11'\''|json -b 1
\u0011
$ echo -ne '\''\x11'\''|json -b 2
\u0011
$ echo -ne '\''\x11'\''|json -b 3
\u0011
$ echo -ne '\''\x12'\''|json -b 1
\u0012
$ echo -ne '\''\x12'\''|json -b 2
\u0012
$ echo -ne '\''\x12'\''|json -b 3
\u0012
$ echo -ne '\''\x13'\''|json -b 1
\u0013
$ echo -ne '\''\x13'\''|json -b 2
\u0013
$ echo -ne '\''\x13'\''|json -b 3
\u0013
$ echo -ne '\''\x14'\''|json -b 1
\u0014
$ echo -ne '\''\x14'\''|json -b 2
\u0014
$ echo -ne '\''\x14'\''|json -b 3
\u0014
$ echo -ne '\''\x15'\''|json -b 1
\u0015
$ echo -ne '\''\x15'\''|json -b 2
\u0015
$ echo -ne '\''\x15'\''|json -b 3
\u0015
$ echo -ne '\''\x16'\''|json -b 1
\u0016
$ echo -ne '\''\x16'\''|json -b 2
\u0016
$ echo -ne '\''\x16'\''|json -b 3
\u0016
$ echo -ne '\''\x17'\''|json -b 1
\u0017
$ echo -ne '\''\x17'\''|json -b 2
\u0017
$ echo -ne '\''\x17'\''|json -b 3
\u0017
$ echo -ne '\''\x18'\''|json -b 1
\u0018
$ echo -ne '\''\x18'\''|json -b 2
\u0018
$ echo -ne '\''\x18'\''|json -b 3
\u0018
$ echo -ne '\''\x19'\''|json -b 1
\u0019
$ echo -ne '\''\x19'\''|json -b 2
\u0019
$ echo -ne '\''\x19'\''|json -b 3
\u0019
$ echo -ne '\''\x1a'\''|json -b 1
\u001a
$ echo -ne '\''\x1a'\''|json -b 2
\u001a
$ echo -ne '\''\x1a'\''|json -b 3
\u001a
$ echo -ne '\''\x1b'\''|json -b 1
\u001b
$ echo -ne '\''\x1b'\''|json -b 2
\u001b
$ echo -ne '\''\x1b'\''|json -b 3
\u001b
$ echo -ne '\''\x1c'\''|json -b 1
\u001c
$ echo -ne '\''\x1c'\''|json -b 2
\u001c
$ echo -ne '\''\x1c'\''|json -b 3
\u001c
$ echo -ne '\''\x1d'\''|json -b 1
\u001d
$ echo -ne '\''\x1d'\''|json -b 2
\u001d
$ echo -ne '\''\x1d'\''|json -b 3
\u001d
$ echo -ne '\''\x1e'\''|json -b 1
\u001e
$ echo -ne '\''\x1e'\''|json -b 2
\u001e
$ echo -ne '\''\x1e'\''|json -b 3
\u001e
$ echo -ne '\''\x1f'\''|json -b 1
\u001f
$ echo -ne '\''\x1f'\''|json -b 2
\u001f
$ echo -ne '\''\x1f'\''|json -b 3
\u001f
$ echo -n '\'' '\''|json -b 1
 
$ echo -n '\'' '\''|json -b 2
 
$ echo -n '\'' '\''|json -b 3
 
$ echo -n '\''!'\''|json -b 1
!
$ echo -n '\''!'\''|json -b 2
!
$ echo -n '\''!'\''|json -b 3
!
$ echo -n '\''"'\''|json -b 1
\"
$ echo -n '\''"'\''|json -b 2
\"
$ echo -n '\''"'\''|json -b 3
\"
$ echo -n '\''#'\''|json -b 1|squote
\#
$ echo -n '\''#'\''|json -b 2|squote
\#
$ echo -n '\''#'\''|json -b 3|squote
\#
$ echo -n '\''$'\''|json -b 1|squote
\$
$ echo -n '\''$'\''|json -b 2|squote
\$
$ echo -n '\''$'\''|json -b 3|squote
\$
$ echo -n '\''%'\''|json -b 1
%
$ echo -n '\''%'\''|json -b 2
%
$ echo -n '\''%'\''|json -b 3
%
$ echo -n '\''&'\''|json -b 1
&
$ echo -n '\''&'\''|json -b 2
&
$ echo -n '\''&'\''|json -b 3
&
$ echo -ne '\''\x27'\''|json -b 1
'\''
$ echo -ne '\''\x27'\''|json -b 2
'\''
$ echo -ne '\''\x27'\''|json -b 3
'\''
$ echo -n '\''('\''|json -b 1
(
$ echo -n '\''('\''|json -b 2
(
$ echo -n '\''('\''|json -b 3
(
$ echo -n '\'')'\''|json -b 1
)
$ echo -n '\'')'\''|json -b 2
)
$ echo -n '\'')'\''|json -b 3
)
$ echo -n '\''*'\''|json -b 1
*
$ echo -n '\''*'\''|json -b 2
*
$ echo -n '\''*'\''|json -b 3
*
$ echo -n '\''+'\''|json -b 1
+
$ echo -n '\''+'\''|json -b 2
+
$ echo -n '\''+'\''|json -b 3
+
$ echo -n '\'','\''|json -b 1
,
$ echo -n '\'','\''|json -b 2
,
$ echo -n '\'','\''|json -b 3
,
$ echo -n '\''-'\''|json -b 1
-
$ echo -n '\''-'\''|json -b 2
-
$ echo -n '\''-'\''|json -b 3
-
$ echo -n '\''.'\''|json -b 1
.
$ echo -n '\''.'\''|json -b 2
.
$ echo -n '\''.'\''|json -b 3
.
$ echo -n '\''/'\''|json -b 1
/
$ echo -n '\''/'\''|json -b 2
/
$ echo -n '\''/'\''|json -b 3
/
$ echo -n '\''0'\''|json -b 1
0
$ echo -n '\''0'\''|json -b 2
0
$ echo -n '\''0'\''|json -b 3
0
$ echo -n '\''1'\''|json -b 1
1
$ echo -n '\''1'\''|json -b 2
1
$ echo -n '\''1'\''|json -b 3
1
$ echo -n '\''2'\''|json -b 1
2
$ echo -n '\''2'\''|json -b 2
2
$ echo -n '\''2'\''|json -b 3
2
$ echo -n '\''3'\''|json -b 1
3
$ echo -n '\''3'\''|json -b 2
3
$ echo -n '\''3'\''|json -b 3
3
$ echo -n '\''4'\''|json -b 1
4
$ echo -n '\''4'\''|json -b 2
4
$ echo -n '\''4'\''|json -b 3
4
$ echo -n '\''5'\''|json -b 1
5
$ echo -n '\''5'\''|json -b 2
5
$ echo -n '\''5'\''|json -b 3
5
$ echo -n '\''6'\''|json -b 1
6
$ echo -n '\''6'\''|json -b 2
6
$ echo -n '\''6'\''|json -b 3
6
$ echo -n '\''7'\''|json -b 1
7
$ echo -n '\''7'\''|json -b 2
7
$ echo -n '\''7'\''|json -b 3
7
$ echo -n '\''8'\''|json -b 1
8
$ echo -n '\''8'\''|json -b 2
8
$ echo -n '\''8'\''|json -b 3
8
$ echo -n '\''9'\''|json -b 1
9
$ echo -n '\''9'\''|json -b 2
9
$ echo -n '\''9'\''|json -b 3
9
$ echo -n '\'':'\''|json -b 1
:
$ echo -n '\'':'\''|json -b 2
:
$ echo -n '\'':'\''|json -b 3
:
$ echo -n '\'';'\''|json -b 1
;
$ echo -n '\'';'\''|json -b 2
;
$ echo -n '\'';'\''|json -b 3
;
$ echo -n '\''<'\''|json -b 1
<
$ echo -n '\''<'\''|json -b 2
<
$ echo -n '\''<'\''|json -b 3
<
$ echo -n '\''='\''|json -b 1
=
$ echo -n '\''='\''|json -b 2
=
$ echo -n '\''='\''|json -b 3
=
$ echo -n '\''>'\''|json -b 1
>
$ echo -n '\''>'\''|json -b 2
>
$ echo -n '\''>'\''|json -b 3
>
$ echo -n '\''?'\''|json -b 1
?
$ echo -n '\''?'\''|json -b 2
?
$ echo -n '\''?'\''|json -b 3
?
$ echo -n '\''@'\''|json -b 1
@
$ echo -n '\''@'\''|json -b 2
@
$ echo -n '\''@'\''|json -b 3
@
$ echo -n '\''A'\''|json -b 1
A
$ echo -n '\''A'\''|json -b 2
A
$ echo -n '\''A'\''|json -b 3
A
$ echo -n '\''B'\''|json -b 1
B
$ echo -n '\''B'\''|json -b 2
B
$ echo -n '\''B'\''|json -b 3
B
$ echo -n '\''C'\''|json -b 1
C
$ echo -n '\''C'\''|json -b 2
C
$ echo -n '\''C'\''|json -b 3
C
$ echo -n '\''D'\''|json -b 1
D
$ echo -n '\''D'\''|json -b 2
D
$ echo -n '\''D'\''|json -b 3
D
$ echo -n '\''E'\''|json -b 1
E
$ echo -n '\''E'\''|json -b 2
E
$ echo -n '\''E'\''|json -b 3
E
$ echo -n '\''F'\''|json -b 1
F
$ echo -n '\''F'\''|json -b 2
F
$ echo -n '\''F'\''|json -b 3
F
$ echo -n '\''G'\''|json -b 1
G
$ echo -n '\''G'\''|json -b 2
G
$ echo -n '\''G'\''|json -b 3
G
$ echo -n '\''H'\''|json -b 1
H
$ echo -n '\''H'\''|json -b 2
H
$ echo -n '\''H'\''|json -b 3
H
$ echo -n '\''I'\''|json -b 1
I
$ echo -n '\''I'\''|json -b 2
I
$ echo -n '\''I'\''|json -b 3
I
$ echo -n '\''J'\''|json -b 1
J
$ echo -n '\''J'\''|json -b 2
J
$ echo -n '\''J'\''|json -b 3
J
$ echo -n '\''K'\''|json -b 1
K
$ echo -n '\''K'\''|json -b 2
K
$ echo -n '\''K'\''|json -b 3
K
$ echo -n '\''L'\''|json -b 1
L
$ echo -n '\''L'\''|json -b 2
L
$ echo -n '\''L'\''|json -b 3
L
$ echo -n '\''M'\''|json -b 1
M
$ echo -n '\''M'\''|json -b 2
M
$ echo -n '\''M'\''|json -b 3
M
$ echo -n '\''N'\''|json -b 1
N
$ echo -n '\''N'\''|json -b 2
N
$ echo -n '\''N'\''|json -b 3
N
$ echo -n '\''O'\''|json -b 1
O
$ echo -n '\''O'\''|json -b 2
O
$ echo -n '\''O'\''|json -b 3
O
$ echo -n '\''P'\''|json -b 1
P
$ echo -n '\''P'\''|json -b 2
P
$ echo -n '\''P'\''|json -b 3
P
$ echo -n '\''Q'\''|json -b 1
Q
$ echo -n '\''Q'\''|json -b 2
Q
$ echo -n '\''Q'\''|json -b 3
Q
$ echo -n '\''R'\''|json -b 1
R
$ echo -n '\''R'\''|json -b 2
R
$ echo -n '\''R'\''|json -b 3
R
$ echo -n '\''S'\''|json -b 1
S
$ echo -n '\''S'\''|json -b 2
S
$ echo -n '\''S'\''|json -b 3
S
$ echo -n '\''T'\''|json -b 1
T
$ echo -n '\''T'\''|json -b 2
T
$ echo -n '\''T'\''|json -b 3
T
$ echo -n '\''U'\''|json -b 1
U
$ echo -n '\''U'\''|json -b 2
U
$ echo -n '\''U'\''|json -b 3
U
$ echo -n '\''V'\''|json -b 1
V
$ echo -n '\''V'\''|json -b 2
V
$ echo -n '\''V'\''|json -b 3
V
$ echo -n '\''W'\''|json -b 1
W
$ echo -n '\''W'\''|json -b 2
W
$ echo -n '\''W'\''|json -b 3
W
$ echo -n '\''X'\''|json -b 1
X
$ echo -n '\''X'\''|json -b 2
X
$ echo -n '\''X'\''|json -b 3
X
$ echo -n '\''Y'\''|json -b 1
Y
$ echo -n '\''Y'\''|json -b 2
Y
$ echo -n '\''Y'\''|json -b 3
Y
$ echo -n '\''Z'\''|json -b 1
Z
$ echo -n '\''Z'\''|json -b 2
Z
$ echo -n '\''Z'\''|json -b 3
Z
$ echo -n '\''['\''|json -b 1
[
$ echo -n '\''['\''|json -b 2
[
$ echo -n '\''['\''|json -b 3
[
$ echo -n '\''\'\''|json -b 1
\\
$ echo -n '\''\'\''|json -b 2
\\
$ echo -n '\''\'\''|json -b 3
\\
$ echo -n '\'']'\''|json -b 1
]
$ echo -n '\'']'\''|json -b 2
]
$ echo -n '\'']'\''|json -b 3
]
$ echo -n '\''^'\''|json -b 1
^
$ echo -n '\''^'\''|json -b 2
^
$ echo -n '\''^'\''|json -b 3
^
$ echo -n '\''_'\''|json -b 1
_
$ echo -n '\''_'\''|json -b 2
_
$ echo -n '\''_'\''|json -b 3
_
$ echo -n '\''`'\''|json -b 1
`
$ echo -n '\''`'\''|json -b 2
`
$ echo -n '\''`'\''|json -b 3
`
$ echo -n '\''a'\''|json -b 1
a
$ echo -n '\''a'\''|json -b 2
a
$ echo -n '\''a'\''|json -b 3
a
$ echo -n '\''b'\''|json -b 1
b
$ echo -n '\''b'\''|json -b 2
b
$ echo -n '\''b'\''|json -b 3
b
$ echo -n '\''c'\''|json -b 1
c
$ echo -n '\''c'\''|json -b 2
c
$ echo -n '\''c'\''|json -b 3
c
$ echo -n '\''d'\''|json -b 1
d
$ echo -n '\''d'\''|json -b 2
d
$ echo -n '\''d'\''|json -b 3
d
$ echo -n '\''e'\''|json -b 1
e
$ echo -n '\''e'\''|json -b 2
e
$ echo -n '\''e'\''|json -b 3
e
$ echo -n '\''f'\''|json -b 1
f
$ echo -n '\''f'\''|json -b 2
f
$ echo -n '\''f'\''|json -b 3
f
$ echo -n '\''g'\''|json -b 1
g
$ echo -n '\''g'\''|json -b 2
g
$ echo -n '\''g'\''|json -b 3
g
$ echo -n '\''h'\''|json -b 1
h
$ echo -n '\''h'\''|json -b 2
h
$ echo -n '\''h'\''|json -b 3
h
$ echo -n '\''i'\''|json -b 1
i
$ echo -n '\''i'\''|json -b 2
i
$ echo -n '\''i'\''|json -b 3
i
$ echo -n '\''j'\''|json -b 1
j
$ echo -n '\''j'\''|json -b 2
j
$ echo -n '\''j'\''|json -b 3
j
$ echo -n '\''k'\''|json -b 1
k
$ echo -n '\''k'\''|json -b 2
k
$ echo -n '\''k'\''|json -b 3
k
$ echo -n '\''l'\''|json -b 1
l
$ echo -n '\''l'\''|json -b 2
l
$ echo -n '\''l'\''|json -b 3
l
$ echo -n '\''m'\''|json -b 1
m
$ echo -n '\''m'\''|json -b 2
m
$ echo -n '\''m'\''|json -b 3
m
$ echo -n '\''n'\''|json -b 1
n
$ echo -n '\''n'\''|json -b 2
n
$ echo -n '\''n'\''|json -b 3
n
$ echo -n '\''o'\''|json -b 1
o
$ echo -n '\''o'\''|json -b 2
o
$ echo -n '\''o'\''|json -b 3
o
$ echo -n '\''p'\''|json -b 1
p
$ echo -n '\''p'\''|json -b 2
p
$ echo -n '\''p'\''|json -b 3
p
$ echo -n '\''q'\''|json -b 1
q
$ echo -n '\''q'\''|json -b 2
q
$ echo -n '\''q'\''|json -b 3
q
$ echo -n '\''r'\''|json -b 1
r
$ echo -n '\''r'\''|json -b 2
r
$ echo -n '\''r'\''|json -b 3
r
$ echo -n '\''s'\''|json -b 1
s
$ echo -n '\''s'\''|json -b 2
s
$ echo -n '\''s'\''|json -b 3
s
$ echo -n '\''t'\''|json -b 1
t
$ echo -n '\''t'\''|json -b 2
t
$ echo -n '\''t'\''|json -b 3
t
$ echo -n '\''u'\''|json -b 1
u
$ echo -n '\''u'\''|json -b 2
u
$ echo -n '\''u'\''|json -b 3
u
$ echo -n '\''v'\''|json -b 1
v
$ echo -n '\''v'\''|json -b 2
v
$ echo -n '\''v'\''|json -b 3
v
$ echo -n '\''w'\''|json -b 1
w
$ echo -n '\''w'\''|json -b 2
w
$ echo -n '\''w'\''|json -b 3
w
$ echo -n '\''x'\''|json -b 1
x
$ echo -n '\''x'\''|json -b 2
x
$ echo -n '\''x'\''|json -b 3
x
$ echo -n '\''y'\''|json -b 1
y
$ echo -n '\''y'\''|json -b 2
y
$ echo -n '\''y'\''|json -b 3
y
$ echo -n '\''z'\''|json -b 1
z
$ echo -n '\''z'\''|json -b 2
z
$ echo -n '\''z'\''|json -b 3
z
$ echo -n '\''{'\''|json -b 1
{
$ echo -n '\''{'\''|json -b 2
{
$ echo -n '\''{'\''|json -b 3
{
$ echo -n '\''|'\''|json -b 1
|
$ echo -n '\''|'\''|json -b 2
|
$ echo -n '\''|'\''|json -b 3
|
$ echo -n '\''}'\''|json -b 1
}
$ echo -n '\''}'\''|json -b 2
}
$ echo -n '\''}'\''|json -b 3
}
$ echo -n '\''~'\''|json -b 1
~
$ echo -n '\''~'\''|json -b 2
~
$ echo -n '\''~'\''|json -b 3
~
$ echo -ne '\''\x7f'\''|json -b 1
\u007f
$ echo -ne '\''\x7f'\''|json -b 2
\u007f
$ echo -ne '\''\x7f'\''|json -b 3
\u007f'
) -L ascii.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'

echo '$ squote() { sed -r '\''s/^[#$]/\\\0/'\''; }'
squote() { sed -r 's/^[#$]/\\\0/'; } 2>&1 ||
echo 'command failed: squote() { sed -r '\''s/^[#$]/\\\0/'\''; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ echo -ne '\''\x0'\''|json -b 1'
echo -ne '\x0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x0'\''|json -b 1'

echo '$ echo -ne '\''\x0'\''|json -b 2'
echo -ne '\x0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x0'\''|json -b 2'

echo '$ echo -ne '\''\x0'\''|json -b 3'
echo -ne '\x0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x0'\''|json -b 3'

echo '$ echo -ne '\''\x1'\''|json -b 1'
echo -ne '\x1'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x1'\''|json -b 1'

echo '$ echo -ne '\''\x1'\''|json -b 2'
echo -ne '\x1'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x1'\''|json -b 2'

echo '$ echo -ne '\''\x1'\''|json -b 3'
echo -ne '\x1'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x1'\''|json -b 3'

echo '$ echo -ne '\''\x2'\''|json -b 1'
echo -ne '\x2'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x2'\''|json -b 1'

echo '$ echo -ne '\''\x2'\''|json -b 2'
echo -ne '\x2'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x2'\''|json -b 2'

echo '$ echo -ne '\''\x2'\''|json -b 3'
echo -ne '\x2'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x2'\''|json -b 3'

echo '$ echo -ne '\''\x3'\''|json -b 1'
echo -ne '\x3'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x3'\''|json -b 1'

echo '$ echo -ne '\''\x3'\''|json -b 2'
echo -ne '\x3'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x3'\''|json -b 2'

echo '$ echo -ne '\''\x3'\''|json -b 3'
echo -ne '\x3'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x3'\''|json -b 3'

echo '$ echo -ne '\''\x4'\''|json -b 1'
echo -ne '\x4'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x4'\''|json -b 1'

echo '$ echo -ne '\''\x4'\''|json -b 2'
echo -ne '\x4'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x4'\''|json -b 2'

echo '$ echo -ne '\''\x4'\''|json -b 3'
echo -ne '\x4'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x4'\''|json -b 3'

echo '$ echo -ne '\''\x5'\''|json -b 1'
echo -ne '\x5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x5'\''|json -b 1'

echo '$ echo -ne '\''\x5'\''|json -b 2'
echo -ne '\x5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x5'\''|json -b 2'

echo '$ echo -ne '\''\x5'\''|json -b 3'
echo -ne '\x5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x5'\''|json -b 3'

echo '$ echo -ne '\''\x6'\''|json -b 1'
echo -ne '\x6'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x6'\''|json -b 1'

echo '$ echo -ne '\''\x6'\''|json -b 2'
echo -ne '\x6'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x6'\''|json -b 2'

echo '$ echo -ne '\''\x6'\''|json -b 3'
echo -ne '\x6'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x6'\''|json -b 3'

echo '$ echo -ne '\''\x7'\''|json -b 1'
echo -ne '\x7'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x7'\''|json -b 1'

echo '$ echo -ne '\''\x7'\''|json -b 2'
echo -ne '\x7'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x7'\''|json -b 2'

echo '$ echo -ne '\''\x7'\''|json -b 3'
echo -ne '\x7'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x7'\''|json -b 3'

echo '$ echo -ne '\''\x8'\''|json -b 1'
echo -ne '\x8'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x8'\''|json -b 1'

echo '$ echo -ne '\''\x8'\''|json -b 2'
echo -ne '\x8'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x8'\''|json -b 2'

echo '$ echo -ne '\''\x8'\''|json -b 3'
echo -ne '\x8'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x8'\''|json -b 3'

echo '$ echo -ne '\''\x9'\''|json -b 1'
echo -ne '\x9'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x9'\''|json -b 1'

echo '$ echo -ne '\''\x9'\''|json -b 2'
echo -ne '\x9'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x9'\''|json -b 2'

echo '$ echo -ne '\''\x9'\''|json -b 3'
echo -ne '\x9'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x9'\''|json -b 3'

echo '$ echo -ne '\''\xa'\''|json -b 1'
echo -ne '\xa'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xa'\''|json -b 1'

echo '$ echo -ne '\''\xa'\''|json -b 2'
echo -ne '\xa'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xa'\''|json -b 2'

echo '$ echo -ne '\''\xa'\''|json -b 3'
echo -ne '\xa'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xa'\''|json -b 3'

echo '$ echo -ne '\''\xb'\''|json -b 1'
echo -ne '\xb'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xb'\''|json -b 1'

echo '$ echo -ne '\''\xb'\''|json -b 2'
echo -ne '\xb'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xb'\''|json -b 2'

echo '$ echo -ne '\''\xb'\''|json -b 3'
echo -ne '\xb'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xb'\''|json -b 3'

echo '$ echo -ne '\''\xc'\''|json -b 1'
echo -ne '\xc'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc'\''|json -b 1'

echo '$ echo -ne '\''\xc'\''|json -b 2'
echo -ne '\xc'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc'\''|json -b 2'

echo '$ echo -ne '\''\xc'\''|json -b 3'
echo -ne '\xc'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc'\''|json -b 3'

echo '$ echo -ne '\''\xd'\''|json -b 1'
echo -ne '\xd'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xd'\''|json -b 1'

echo '$ echo -ne '\''\xd'\''|json -b 2'
echo -ne '\xd'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xd'\''|json -b 2'

echo '$ echo -ne '\''\xd'\''|json -b 3'
echo -ne '\xd'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xd'\''|json -b 3'

echo '$ echo -ne '\''\xe'\''|json -b 1'
echo -ne '\xe'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe'\''|json -b 1'

echo '$ echo -ne '\''\xe'\''|json -b 2'
echo -ne '\xe'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe'\''|json -b 2'

echo '$ echo -ne '\''\xe'\''|json -b 3'
echo -ne '\xe'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe'\''|json -b 3'

echo '$ echo -ne '\''\xf'\''|json -b 1'
echo -ne '\xf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf'\''|json -b 1'

echo '$ echo -ne '\''\xf'\''|json -b 2'
echo -ne '\xf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf'\''|json -b 2'

echo '$ echo -ne '\''\xf'\''|json -b 3'
echo -ne '\xf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf'\''|json -b 3'

echo '$ echo -ne '\''\x10'\''|json -b 1'
echo -ne '\x10'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x10'\''|json -b 1'

echo '$ echo -ne '\''\x10'\''|json -b 2'
echo -ne '\x10'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x10'\''|json -b 2'

echo '$ echo -ne '\''\x10'\''|json -b 3'
echo -ne '\x10'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x10'\''|json -b 3'

echo '$ echo -ne '\''\x11'\''|json -b 1'
echo -ne '\x11'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x11'\''|json -b 1'

echo '$ echo -ne '\''\x11'\''|json -b 2'
echo -ne '\x11'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x11'\''|json -b 2'

echo '$ echo -ne '\''\x11'\''|json -b 3'
echo -ne '\x11'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x11'\''|json -b 3'

echo '$ echo -ne '\''\x12'\''|json -b 1'
echo -ne '\x12'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x12'\''|json -b 1'

echo '$ echo -ne '\''\x12'\''|json -b 2'
echo -ne '\x12'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x12'\''|json -b 2'

echo '$ echo -ne '\''\x12'\''|json -b 3'
echo -ne '\x12'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x12'\''|json -b 3'

echo '$ echo -ne '\''\x13'\''|json -b 1'
echo -ne '\x13'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x13'\''|json -b 1'

echo '$ echo -ne '\''\x13'\''|json -b 2'
echo -ne '\x13'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x13'\''|json -b 2'

echo '$ echo -ne '\''\x13'\''|json -b 3'
echo -ne '\x13'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x13'\''|json -b 3'

echo '$ echo -ne '\''\x14'\''|json -b 1'
echo -ne '\x14'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x14'\''|json -b 1'

echo '$ echo -ne '\''\x14'\''|json -b 2'
echo -ne '\x14'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x14'\''|json -b 2'

echo '$ echo -ne '\''\x14'\''|json -b 3'
echo -ne '\x14'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x14'\''|json -b 3'

echo '$ echo -ne '\''\x15'\''|json -b 1'
echo -ne '\x15'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x15'\''|json -b 1'

echo '$ echo -ne '\''\x15'\''|json -b 2'
echo -ne '\x15'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x15'\''|json -b 2'

echo '$ echo -ne '\''\x15'\''|json -b 3'
echo -ne '\x15'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x15'\''|json -b 3'

echo '$ echo -ne '\''\x16'\''|json -b 1'
echo -ne '\x16'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x16'\''|json -b 1'

echo '$ echo -ne '\''\x16'\''|json -b 2'
echo -ne '\x16'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x16'\''|json -b 2'

echo '$ echo -ne '\''\x16'\''|json -b 3'
echo -ne '\x16'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x16'\''|json -b 3'

echo '$ echo -ne '\''\x17'\''|json -b 1'
echo -ne '\x17'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x17'\''|json -b 1'

echo '$ echo -ne '\''\x17'\''|json -b 2'
echo -ne '\x17'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x17'\''|json -b 2'

echo '$ echo -ne '\''\x17'\''|json -b 3'
echo -ne '\x17'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x17'\''|json -b 3'

echo '$ echo -ne '\''\x18'\''|json -b 1'
echo -ne '\x18'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x18'\''|json -b 1'

echo '$ echo -ne '\''\x18'\''|json -b 2'
echo -ne '\x18'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x18'\''|json -b 2'

echo '$ echo -ne '\''\x18'\''|json -b 3'
echo -ne '\x18'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x18'\''|json -b 3'

echo '$ echo -ne '\''\x19'\''|json -b 1'
echo -ne '\x19'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x19'\''|json -b 1'

echo '$ echo -ne '\''\x19'\''|json -b 2'
echo -ne '\x19'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x19'\''|json -b 2'

echo '$ echo -ne '\''\x19'\''|json -b 3'
echo -ne '\x19'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x19'\''|json -b 3'

echo '$ echo -ne '\''\x1a'\''|json -b 1'
echo -ne '\x1a'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x1a'\''|json -b 1'

echo '$ echo -ne '\''\x1a'\''|json -b 2'
echo -ne '\x1a'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x1a'\''|json -b 2'

echo '$ echo -ne '\''\x1a'\''|json -b 3'
echo -ne '\x1a'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x1a'\''|json -b 3'

echo '$ echo -ne '\''\x1b'\''|json -b 1'
echo -ne '\x1b'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x1b'\''|json -b 1'

echo '$ echo -ne '\''\x1b'\''|json -b 2'
echo -ne '\x1b'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x1b'\''|json -b 2'

echo '$ echo -ne '\''\x1b'\''|json -b 3'
echo -ne '\x1b'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x1b'\''|json -b 3'

echo '$ echo -ne '\''\x1c'\''|json -b 1'
echo -ne '\x1c'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x1c'\''|json -b 1'

echo '$ echo -ne '\''\x1c'\''|json -b 2'
echo -ne '\x1c'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x1c'\''|json -b 2'

echo '$ echo -ne '\''\x1c'\''|json -b 3'
echo -ne '\x1c'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x1c'\''|json -b 3'

echo '$ echo -ne '\''\x1d'\''|json -b 1'
echo -ne '\x1d'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x1d'\''|json -b 1'

echo '$ echo -ne '\''\x1d'\''|json -b 2'
echo -ne '\x1d'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x1d'\''|json -b 2'

echo '$ echo -ne '\''\x1d'\''|json -b 3'
echo -ne '\x1d'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x1d'\''|json -b 3'

echo '$ echo -ne '\''\x1e'\''|json -b 1'
echo -ne '\x1e'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x1e'\''|json -b 1'

echo '$ echo -ne '\''\x1e'\''|json -b 2'
echo -ne '\x1e'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x1e'\''|json -b 2'

echo '$ echo -ne '\''\x1e'\''|json -b 3'
echo -ne '\x1e'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x1e'\''|json -b 3'

echo '$ echo -ne '\''\x1f'\''|json -b 1'
echo -ne '\x1f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x1f'\''|json -b 1'

echo '$ echo -ne '\''\x1f'\''|json -b 2'
echo -ne '\x1f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x1f'\''|json -b 2'

echo '$ echo -ne '\''\x1f'\''|json -b 3'
echo -ne '\x1f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x1f'\''|json -b 3'

echo '$ echo -n '\'' '\''|json -b 1'
echo -n ' '|json -b 1 2>&1 ||
echo 'command failed: echo -n '\'' '\''|json -b 1'

echo '$ echo -n '\'' '\''|json -b 2'
echo -n ' '|json -b 2 2>&1 ||
echo 'command failed: echo -n '\'' '\''|json -b 2'

echo '$ echo -n '\'' '\''|json -b 3'
echo -n ' '|json -b 3 2>&1 ||
echo 'command failed: echo -n '\'' '\''|json -b 3'

echo '$ echo -n '\''!'\''|json -b 1'
echo -n '!'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''!'\''|json -b 1'

echo '$ echo -n '\''!'\''|json -b 2'
echo -n '!'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''!'\''|json -b 2'

echo '$ echo -n '\''!'\''|json -b 3'
echo -n '!'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''!'\''|json -b 3'

echo '$ echo -n '\''"'\''|json -b 1'
echo -n '"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 1'

echo '$ echo -n '\''"'\''|json -b 2'
echo -n '"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 2'

echo '$ echo -n '\''"'\''|json -b 3'
echo -n '"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 3'

echo '$ echo -n '\''#'\''|json -b 1|squote'
echo -n '#'|json -b 1|squote 2>&1 ||
echo 'command failed: echo -n '\''#'\''|json -b 1|squote'

echo '$ echo -n '\''#'\''|json -b 2|squote'
echo -n '#'|json -b 2|squote 2>&1 ||
echo 'command failed: echo -n '\''#'\''|json -b 2|squote'

echo '$ echo -n '\''#'\''|json -b 3|squote'
echo -n '#'|json -b 3|squote 2>&1 ||
echo 'command failed: echo -n '\''#'\''|json -b 3|squote'

echo '$ echo -n '\''$'\''|json -b 1|squote'
echo -n '$'|json -b 1|squote 2>&1 ||
echo 'command failed: echo -n '\''$'\''|json -b 1|squote'

echo '$ echo -n '\''$'\''|json -b 2|squote'
echo -n '$'|json -b 2|squote 2>&1 ||
echo 'command failed: echo -n '\''$'\''|json -b 2|squote'

echo '$ echo -n '\''$'\''|json -b 3|squote'
echo -n '$'|json -b 3|squote 2>&1 ||
echo 'command failed: echo -n '\''$'\''|json -b 3|squote'

echo '$ echo -n '\''%'\''|json -b 1'
echo -n '%'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''%'\''|json -b 1'

echo '$ echo -n '\''%'\''|json -b 2'
echo -n '%'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''%'\''|json -b 2'

echo '$ echo -n '\''%'\''|json -b 3'
echo -n '%'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''%'\''|json -b 3'

echo '$ echo -n '\''&'\''|json -b 1'
echo -n '&'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''&'\''|json -b 1'

echo '$ echo -n '\''&'\''|json -b 2'
echo -n '&'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''&'\''|json -b 2'

echo '$ echo -n '\''&'\''|json -b 3'
echo -n '&'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''&'\''|json -b 3'

echo '$ echo -ne '\''\x27'\''|json -b 1'
echo -ne '\x27'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x27'\''|json -b 1'

echo '$ echo -ne '\''\x27'\''|json -b 2'
echo -ne '\x27'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x27'\''|json -b 2'

echo '$ echo -ne '\''\x27'\''|json -b 3'
echo -ne '\x27'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x27'\''|json -b 3'

echo '$ echo -n '\''('\''|json -b 1'
echo -n '('|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''('\''|json -b 1'

echo '$ echo -n '\''('\''|json -b 2'
echo -n '('|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''('\''|json -b 2'

echo '$ echo -n '\''('\''|json -b 3'
echo -n '('|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''('\''|json -b 3'

echo '$ echo -n '\'')'\''|json -b 1'
echo -n ')'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\'')'\''|json -b 1'

echo '$ echo -n '\'')'\''|json -b 2'
echo -n ')'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\'')'\''|json -b 2'

echo '$ echo -n '\'')'\''|json -b 3'
echo -n ')'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\'')'\''|json -b 3'

echo '$ echo -n '\''*'\''|json -b 1'
echo -n '*'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''*'\''|json -b 1'

echo '$ echo -n '\''*'\''|json -b 2'
echo -n '*'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''*'\''|json -b 2'

echo '$ echo -n '\''*'\''|json -b 3'
echo -n '*'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''*'\''|json -b 3'

echo '$ echo -n '\''+'\''|json -b 1'
echo -n '+'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''+'\''|json -b 1'

echo '$ echo -n '\''+'\''|json -b 2'
echo -n '+'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''+'\''|json -b 2'

echo '$ echo -n '\''+'\''|json -b 3'
echo -n '+'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''+'\''|json -b 3'

echo '$ echo -n '\'','\''|json -b 1'
echo -n ','|json -b 1 2>&1 ||
echo 'command failed: echo -n '\'','\''|json -b 1'

echo '$ echo -n '\'','\''|json -b 2'
echo -n ','|json -b 2 2>&1 ||
echo 'command failed: echo -n '\'','\''|json -b 2'

echo '$ echo -n '\'','\''|json -b 3'
echo -n ','|json -b 3 2>&1 ||
echo 'command failed: echo -n '\'','\''|json -b 3'

echo '$ echo -n '\''-'\''|json -b 1'
echo -n '-'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''-'\''|json -b 1'

echo '$ echo -n '\''-'\''|json -b 2'
echo -n '-'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''-'\''|json -b 2'

echo '$ echo -n '\''-'\''|json -b 3'
echo -n '-'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''-'\''|json -b 3'

echo '$ echo -n '\''.'\''|json -b 1'
echo -n '.'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''.'\''|json -b 1'

echo '$ echo -n '\''.'\''|json -b 2'
echo -n '.'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''.'\''|json -b 2'

echo '$ echo -n '\''.'\''|json -b 3'
echo -n '.'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''.'\''|json -b 3'

echo '$ echo -n '\''/'\''|json -b 1'
echo -n '/'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''/'\''|json -b 1'

echo '$ echo -n '\''/'\''|json -b 2'
echo -n '/'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''/'\''|json -b 2'

echo '$ echo -n '\''/'\''|json -b 3'
echo -n '/'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''/'\''|json -b 3'

echo '$ echo -n '\''0'\''|json -b 1'
echo -n '0'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''0'\''|json -b 1'

echo '$ echo -n '\''0'\''|json -b 2'
echo -n '0'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''0'\''|json -b 2'

echo '$ echo -n '\''0'\''|json -b 3'
echo -n '0'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''0'\''|json -b 3'

echo '$ echo -n '\''1'\''|json -b 1'
echo -n '1'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''1'\''|json -b 1'

echo '$ echo -n '\''1'\''|json -b 2'
echo -n '1'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''1'\''|json -b 2'

echo '$ echo -n '\''1'\''|json -b 3'
echo -n '1'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''1'\''|json -b 3'

echo '$ echo -n '\''2'\''|json -b 1'
echo -n '2'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''2'\''|json -b 1'

echo '$ echo -n '\''2'\''|json -b 2'
echo -n '2'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''2'\''|json -b 2'

echo '$ echo -n '\''2'\''|json -b 3'
echo -n '2'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''2'\''|json -b 3'

echo '$ echo -n '\''3'\''|json -b 1'
echo -n '3'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''3'\''|json -b 1'

echo '$ echo -n '\''3'\''|json -b 2'
echo -n '3'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''3'\''|json -b 2'

echo '$ echo -n '\''3'\''|json -b 3'
echo -n '3'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''3'\''|json -b 3'

echo '$ echo -n '\''4'\''|json -b 1'
echo -n '4'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''4'\''|json -b 1'

echo '$ echo -n '\''4'\''|json -b 2'
echo -n '4'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''4'\''|json -b 2'

echo '$ echo -n '\''4'\''|json -b 3'
echo -n '4'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''4'\''|json -b 3'

echo '$ echo -n '\''5'\''|json -b 1'
echo -n '5'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''5'\''|json -b 1'

echo '$ echo -n '\''5'\''|json -b 2'
echo -n '5'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''5'\''|json -b 2'

echo '$ echo -n '\''5'\''|json -b 3'
echo -n '5'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''5'\''|json -b 3'

echo '$ echo -n '\''6'\''|json -b 1'
echo -n '6'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''6'\''|json -b 1'

echo '$ echo -n '\''6'\''|json -b 2'
echo -n '6'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''6'\''|json -b 2'

echo '$ echo -n '\''6'\''|json -b 3'
echo -n '6'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''6'\''|json -b 3'

echo '$ echo -n '\''7'\''|json -b 1'
echo -n '7'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''7'\''|json -b 1'

echo '$ echo -n '\''7'\''|json -b 2'
echo -n '7'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''7'\''|json -b 2'

echo '$ echo -n '\''7'\''|json -b 3'
echo -n '7'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''7'\''|json -b 3'

echo '$ echo -n '\''8'\''|json -b 1'
echo -n '8'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''8'\''|json -b 1'

echo '$ echo -n '\''8'\''|json -b 2'
echo -n '8'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''8'\''|json -b 2'

echo '$ echo -n '\''8'\''|json -b 3'
echo -n '8'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''8'\''|json -b 3'

echo '$ echo -n '\''9'\''|json -b 1'
echo -n '9'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''9'\''|json -b 1'

echo '$ echo -n '\''9'\''|json -b 2'
echo -n '9'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''9'\''|json -b 2'

echo '$ echo -n '\''9'\''|json -b 3'
echo -n '9'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''9'\''|json -b 3'

echo '$ echo -n '\'':'\''|json -b 1'
echo -n ':'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\'':'\''|json -b 1'

echo '$ echo -n '\'':'\''|json -b 2'
echo -n ':'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\'':'\''|json -b 2'

echo '$ echo -n '\'':'\''|json -b 3'
echo -n ':'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\'':'\''|json -b 3'

echo '$ echo -n '\'';'\''|json -b 1'
echo -n ';'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\'';'\''|json -b 1'

echo '$ echo -n '\'';'\''|json -b 2'
echo -n ';'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\'';'\''|json -b 2'

echo '$ echo -n '\'';'\''|json -b 3'
echo -n ';'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\'';'\''|json -b 3'

echo '$ echo -n '\''<'\''|json -b 1'
echo -n '<'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''<'\''|json -b 1'

echo '$ echo -n '\''<'\''|json -b 2'
echo -n '<'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''<'\''|json -b 2'

echo '$ echo -n '\''<'\''|json -b 3'
echo -n '<'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''<'\''|json -b 3'

echo '$ echo -n '\''='\''|json -b 1'
echo -n '='|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''='\''|json -b 1'

echo '$ echo -n '\''='\''|json -b 2'
echo -n '='|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''='\''|json -b 2'

echo '$ echo -n '\''='\''|json -b 3'
echo -n '='|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''='\''|json -b 3'

echo '$ echo -n '\''>'\''|json -b 1'
echo -n '>'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''>'\''|json -b 1'

echo '$ echo -n '\''>'\''|json -b 2'
echo -n '>'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''>'\''|json -b 2'

echo '$ echo -n '\''>'\''|json -b 3'
echo -n '>'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''>'\''|json -b 3'

echo '$ echo -n '\''?'\''|json -b 1'
echo -n '?'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''?'\''|json -b 1'

echo '$ echo -n '\''?'\''|json -b 2'
echo -n '?'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''?'\''|json -b 2'

echo '$ echo -n '\''?'\''|json -b 3'
echo -n '?'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''?'\''|json -b 3'

echo '$ echo -n '\''@'\''|json -b 1'
echo -n '@'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''@'\''|json -b 1'

echo '$ echo -n '\''@'\''|json -b 2'
echo -n '@'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''@'\''|json -b 2'

echo '$ echo -n '\''@'\''|json -b 3'
echo -n '@'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''@'\''|json -b 3'

echo '$ echo -n '\''A'\''|json -b 1'
echo -n 'A'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''A'\''|json -b 1'

echo '$ echo -n '\''A'\''|json -b 2'
echo -n 'A'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''A'\''|json -b 2'

echo '$ echo -n '\''A'\''|json -b 3'
echo -n 'A'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''A'\''|json -b 3'

echo '$ echo -n '\''B'\''|json -b 1'
echo -n 'B'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''B'\''|json -b 1'

echo '$ echo -n '\''B'\''|json -b 2'
echo -n 'B'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''B'\''|json -b 2'

echo '$ echo -n '\''B'\''|json -b 3'
echo -n 'B'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''B'\''|json -b 3'

echo '$ echo -n '\''C'\''|json -b 1'
echo -n 'C'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''C'\''|json -b 1'

echo '$ echo -n '\''C'\''|json -b 2'
echo -n 'C'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''C'\''|json -b 2'

echo '$ echo -n '\''C'\''|json -b 3'
echo -n 'C'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''C'\''|json -b 3'

echo '$ echo -n '\''D'\''|json -b 1'
echo -n 'D'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''D'\''|json -b 1'

echo '$ echo -n '\''D'\''|json -b 2'
echo -n 'D'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''D'\''|json -b 2'

echo '$ echo -n '\''D'\''|json -b 3'
echo -n 'D'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''D'\''|json -b 3'

echo '$ echo -n '\''E'\''|json -b 1'
echo -n 'E'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''E'\''|json -b 1'

echo '$ echo -n '\''E'\''|json -b 2'
echo -n 'E'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''E'\''|json -b 2'

echo '$ echo -n '\''E'\''|json -b 3'
echo -n 'E'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''E'\''|json -b 3'

echo '$ echo -n '\''F'\''|json -b 1'
echo -n 'F'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''F'\''|json -b 1'

echo '$ echo -n '\''F'\''|json -b 2'
echo -n 'F'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''F'\''|json -b 2'

echo '$ echo -n '\''F'\''|json -b 3'
echo -n 'F'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''F'\''|json -b 3'

echo '$ echo -n '\''G'\''|json -b 1'
echo -n 'G'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''G'\''|json -b 1'

echo '$ echo -n '\''G'\''|json -b 2'
echo -n 'G'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''G'\''|json -b 2'

echo '$ echo -n '\''G'\''|json -b 3'
echo -n 'G'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''G'\''|json -b 3'

echo '$ echo -n '\''H'\''|json -b 1'
echo -n 'H'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''H'\''|json -b 1'

echo '$ echo -n '\''H'\''|json -b 2'
echo -n 'H'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''H'\''|json -b 2'

echo '$ echo -n '\''H'\''|json -b 3'
echo -n 'H'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''H'\''|json -b 3'

echo '$ echo -n '\''I'\''|json -b 1'
echo -n 'I'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''I'\''|json -b 1'

echo '$ echo -n '\''I'\''|json -b 2'
echo -n 'I'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''I'\''|json -b 2'

echo '$ echo -n '\''I'\''|json -b 3'
echo -n 'I'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''I'\''|json -b 3'

echo '$ echo -n '\''J'\''|json -b 1'
echo -n 'J'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''J'\''|json -b 1'

echo '$ echo -n '\''J'\''|json -b 2'
echo -n 'J'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''J'\''|json -b 2'

echo '$ echo -n '\''J'\''|json -b 3'
echo -n 'J'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''J'\''|json -b 3'

echo '$ echo -n '\''K'\''|json -b 1'
echo -n 'K'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''K'\''|json -b 1'

echo '$ echo -n '\''K'\''|json -b 2'
echo -n 'K'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''K'\''|json -b 2'

echo '$ echo -n '\''K'\''|json -b 3'
echo -n 'K'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''K'\''|json -b 3'

echo '$ echo -n '\''L'\''|json -b 1'
echo -n 'L'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''L'\''|json -b 1'

echo '$ echo -n '\''L'\''|json -b 2'
echo -n 'L'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''L'\''|json -b 2'

echo '$ echo -n '\''L'\''|json -b 3'
echo -n 'L'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''L'\''|json -b 3'

echo '$ echo -n '\''M'\''|json -b 1'
echo -n 'M'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''M'\''|json -b 1'

echo '$ echo -n '\''M'\''|json -b 2'
echo -n 'M'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''M'\''|json -b 2'

echo '$ echo -n '\''M'\''|json -b 3'
echo -n 'M'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''M'\''|json -b 3'

echo '$ echo -n '\''N'\''|json -b 1'
echo -n 'N'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''N'\''|json -b 1'

echo '$ echo -n '\''N'\''|json -b 2'
echo -n 'N'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''N'\''|json -b 2'

echo '$ echo -n '\''N'\''|json -b 3'
echo -n 'N'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''N'\''|json -b 3'

echo '$ echo -n '\''O'\''|json -b 1'
echo -n 'O'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''O'\''|json -b 1'

echo '$ echo -n '\''O'\''|json -b 2'
echo -n 'O'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''O'\''|json -b 2'

echo '$ echo -n '\''O'\''|json -b 3'
echo -n 'O'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''O'\''|json -b 3'

echo '$ echo -n '\''P'\''|json -b 1'
echo -n 'P'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''P'\''|json -b 1'

echo '$ echo -n '\''P'\''|json -b 2'
echo -n 'P'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''P'\''|json -b 2'

echo '$ echo -n '\''P'\''|json -b 3'
echo -n 'P'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''P'\''|json -b 3'

echo '$ echo -n '\''Q'\''|json -b 1'
echo -n 'Q'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''Q'\''|json -b 1'

echo '$ echo -n '\''Q'\''|json -b 2'
echo -n 'Q'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''Q'\''|json -b 2'

echo '$ echo -n '\''Q'\''|json -b 3'
echo -n 'Q'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''Q'\''|json -b 3'

echo '$ echo -n '\''R'\''|json -b 1'
echo -n 'R'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''R'\''|json -b 1'

echo '$ echo -n '\''R'\''|json -b 2'
echo -n 'R'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''R'\''|json -b 2'

echo '$ echo -n '\''R'\''|json -b 3'
echo -n 'R'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''R'\''|json -b 3'

echo '$ echo -n '\''S'\''|json -b 1'
echo -n 'S'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''S'\''|json -b 1'

echo '$ echo -n '\''S'\''|json -b 2'
echo -n 'S'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''S'\''|json -b 2'

echo '$ echo -n '\''S'\''|json -b 3'
echo -n 'S'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''S'\''|json -b 3'

echo '$ echo -n '\''T'\''|json -b 1'
echo -n 'T'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''T'\''|json -b 1'

echo '$ echo -n '\''T'\''|json -b 2'
echo -n 'T'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''T'\''|json -b 2'

echo '$ echo -n '\''T'\''|json -b 3'
echo -n 'T'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''T'\''|json -b 3'

echo '$ echo -n '\''U'\''|json -b 1'
echo -n 'U'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''U'\''|json -b 1'

echo '$ echo -n '\''U'\''|json -b 2'
echo -n 'U'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''U'\''|json -b 2'

echo '$ echo -n '\''U'\''|json -b 3'
echo -n 'U'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''U'\''|json -b 3'

echo '$ echo -n '\''V'\''|json -b 1'
echo -n 'V'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''V'\''|json -b 1'

echo '$ echo -n '\''V'\''|json -b 2'
echo -n 'V'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''V'\''|json -b 2'

echo '$ echo -n '\''V'\''|json -b 3'
echo -n 'V'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''V'\''|json -b 3'

echo '$ echo -n '\''W'\''|json -b 1'
echo -n 'W'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''W'\''|json -b 1'

echo '$ echo -n '\''W'\''|json -b 2'
echo -n 'W'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''W'\''|json -b 2'

echo '$ echo -n '\''W'\''|json -b 3'
echo -n 'W'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''W'\''|json -b 3'

echo '$ echo -n '\''X'\''|json -b 1'
echo -n 'X'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''X'\''|json -b 1'

echo '$ echo -n '\''X'\''|json -b 2'
echo -n 'X'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''X'\''|json -b 2'

echo '$ echo -n '\''X'\''|json -b 3'
echo -n 'X'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''X'\''|json -b 3'

echo '$ echo -n '\''Y'\''|json -b 1'
echo -n 'Y'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''Y'\''|json -b 1'

echo '$ echo -n '\''Y'\''|json -b 2'
echo -n 'Y'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''Y'\''|json -b 2'

echo '$ echo -n '\''Y'\''|json -b 3'
echo -n 'Y'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''Y'\''|json -b 3'

echo '$ echo -n '\''Z'\''|json -b 1'
echo -n 'Z'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''Z'\''|json -b 1'

echo '$ echo -n '\''Z'\''|json -b 2'
echo -n 'Z'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''Z'\''|json -b 2'

echo '$ echo -n '\''Z'\''|json -b 3'
echo -n 'Z'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''Z'\''|json -b 3'

echo '$ echo -n '\''['\''|json -b 1'
echo -n '['|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''['\''|json -b 1'

echo '$ echo -n '\''['\''|json -b 2'
echo -n '['|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''['\''|json -b 2'

echo '$ echo -n '\''['\''|json -b 3'
echo -n '['|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''['\''|json -b 3'

echo '$ echo -n '\''\'\''|json -b 1'
echo -n '\'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''\'\''|json -b 1'

echo '$ echo -n '\''\'\''|json -b 2'
echo -n '\'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''\'\''|json -b 2'

echo '$ echo -n '\''\'\''|json -b 3'
echo -n '\'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''\'\''|json -b 3'

echo '$ echo -n '\'']'\''|json -b 1'
echo -n ']'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\'']'\''|json -b 1'

echo '$ echo -n '\'']'\''|json -b 2'
echo -n ']'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\'']'\''|json -b 2'

echo '$ echo -n '\'']'\''|json -b 3'
echo -n ']'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\'']'\''|json -b 3'

echo '$ echo -n '\''^'\''|json -b 1'
echo -n '^'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''^'\''|json -b 1'

echo '$ echo -n '\''^'\''|json -b 2'
echo -n '^'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''^'\''|json -b 2'

echo '$ echo -n '\''^'\''|json -b 3'
echo -n '^'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''^'\''|json -b 3'

echo '$ echo -n '\''_'\''|json -b 1'
echo -n '_'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''_'\''|json -b 1'

echo '$ echo -n '\''_'\''|json -b 2'
echo -n '_'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''_'\''|json -b 2'

echo '$ echo -n '\''_'\''|json -b 3'
echo -n '_'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''_'\''|json -b 3'

echo '$ echo -n '\''`'\''|json -b 1'
echo -n '`'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''`'\''|json -b 1'

echo '$ echo -n '\''`'\''|json -b 2'
echo -n '`'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''`'\''|json -b 2'

echo '$ echo -n '\''`'\''|json -b 3'
echo -n '`'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''`'\''|json -b 3'

echo '$ echo -n '\''a'\''|json -b 1'
echo -n 'a'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''a'\''|json -b 1'

echo '$ echo -n '\''a'\''|json -b 2'
echo -n 'a'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''a'\''|json -b 2'

echo '$ echo -n '\''a'\''|json -b 3'
echo -n 'a'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''a'\''|json -b 3'

echo '$ echo -n '\''b'\''|json -b 1'
echo -n 'b'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''b'\''|json -b 1'

echo '$ echo -n '\''b'\''|json -b 2'
echo -n 'b'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''b'\''|json -b 2'

echo '$ echo -n '\''b'\''|json -b 3'
echo -n 'b'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''b'\''|json -b 3'

echo '$ echo -n '\''c'\''|json -b 1'
echo -n 'c'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''c'\''|json -b 1'

echo '$ echo -n '\''c'\''|json -b 2'
echo -n 'c'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''c'\''|json -b 2'

echo '$ echo -n '\''c'\''|json -b 3'
echo -n 'c'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''c'\''|json -b 3'

echo '$ echo -n '\''d'\''|json -b 1'
echo -n 'd'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''d'\''|json -b 1'

echo '$ echo -n '\''d'\''|json -b 2'
echo -n 'd'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''d'\''|json -b 2'

echo '$ echo -n '\''d'\''|json -b 3'
echo -n 'd'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''d'\''|json -b 3'

echo '$ echo -n '\''e'\''|json -b 1'
echo -n 'e'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''e'\''|json -b 1'

echo '$ echo -n '\''e'\''|json -b 2'
echo -n 'e'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''e'\''|json -b 2'

echo '$ echo -n '\''e'\''|json -b 3'
echo -n 'e'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''e'\''|json -b 3'

echo '$ echo -n '\''f'\''|json -b 1'
echo -n 'f'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''f'\''|json -b 1'

echo '$ echo -n '\''f'\''|json -b 2'
echo -n 'f'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''f'\''|json -b 2'

echo '$ echo -n '\''f'\''|json -b 3'
echo -n 'f'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''f'\''|json -b 3'

echo '$ echo -n '\''g'\''|json -b 1'
echo -n 'g'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''g'\''|json -b 1'

echo '$ echo -n '\''g'\''|json -b 2'
echo -n 'g'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''g'\''|json -b 2'

echo '$ echo -n '\''g'\''|json -b 3'
echo -n 'g'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''g'\''|json -b 3'

echo '$ echo -n '\''h'\''|json -b 1'
echo -n 'h'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''h'\''|json -b 1'

echo '$ echo -n '\''h'\''|json -b 2'
echo -n 'h'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''h'\''|json -b 2'

echo '$ echo -n '\''h'\''|json -b 3'
echo -n 'h'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''h'\''|json -b 3'

echo '$ echo -n '\''i'\''|json -b 1'
echo -n 'i'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''i'\''|json -b 1'

echo '$ echo -n '\''i'\''|json -b 2'
echo -n 'i'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''i'\''|json -b 2'

echo '$ echo -n '\''i'\''|json -b 3'
echo -n 'i'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''i'\''|json -b 3'

echo '$ echo -n '\''j'\''|json -b 1'
echo -n 'j'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''j'\''|json -b 1'

echo '$ echo -n '\''j'\''|json -b 2'
echo -n 'j'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''j'\''|json -b 2'

echo '$ echo -n '\''j'\''|json -b 3'
echo -n 'j'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''j'\''|json -b 3'

echo '$ echo -n '\''k'\''|json -b 1'
echo -n 'k'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''k'\''|json -b 1'

echo '$ echo -n '\''k'\''|json -b 2'
echo -n 'k'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''k'\''|json -b 2'

echo '$ echo -n '\''k'\''|json -b 3'
echo -n 'k'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''k'\''|json -b 3'

echo '$ echo -n '\''l'\''|json -b 1'
echo -n 'l'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''l'\''|json -b 1'

echo '$ echo -n '\''l'\''|json -b 2'
echo -n 'l'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''l'\''|json -b 2'

echo '$ echo -n '\''l'\''|json -b 3'
echo -n 'l'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''l'\''|json -b 3'

echo '$ echo -n '\''m'\''|json -b 1'
echo -n 'm'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''m'\''|json -b 1'

echo '$ echo -n '\''m'\''|json -b 2'
echo -n 'm'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''m'\''|json -b 2'

echo '$ echo -n '\''m'\''|json -b 3'
echo -n 'm'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''m'\''|json -b 3'

echo '$ echo -n '\''n'\''|json -b 1'
echo -n 'n'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''n'\''|json -b 1'

echo '$ echo -n '\''n'\''|json -b 2'
echo -n 'n'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''n'\''|json -b 2'

echo '$ echo -n '\''n'\''|json -b 3'
echo -n 'n'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''n'\''|json -b 3'

echo '$ echo -n '\''o'\''|json -b 1'
echo -n 'o'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''o'\''|json -b 1'

echo '$ echo -n '\''o'\''|json -b 2'
echo -n 'o'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''o'\''|json -b 2'

echo '$ echo -n '\''o'\''|json -b 3'
echo -n 'o'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''o'\''|json -b 3'

echo '$ echo -n '\''p'\''|json -b 1'
echo -n 'p'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''p'\''|json -b 1'

echo '$ echo -n '\''p'\''|json -b 2'
echo -n 'p'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''p'\''|json -b 2'

echo '$ echo -n '\''p'\''|json -b 3'
echo -n 'p'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''p'\''|json -b 3'

echo '$ echo -n '\''q'\''|json -b 1'
echo -n 'q'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''q'\''|json -b 1'

echo '$ echo -n '\''q'\''|json -b 2'
echo -n 'q'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''q'\''|json -b 2'

echo '$ echo -n '\''q'\''|json -b 3'
echo -n 'q'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''q'\''|json -b 3'

echo '$ echo -n '\''r'\''|json -b 1'
echo -n 'r'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''r'\''|json -b 1'

echo '$ echo -n '\''r'\''|json -b 2'
echo -n 'r'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''r'\''|json -b 2'

echo '$ echo -n '\''r'\''|json -b 3'
echo -n 'r'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''r'\''|json -b 3'

echo '$ echo -n '\''s'\''|json -b 1'
echo -n 's'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''s'\''|json -b 1'

echo '$ echo -n '\''s'\''|json -b 2'
echo -n 's'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''s'\''|json -b 2'

echo '$ echo -n '\''s'\''|json -b 3'
echo -n 's'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''s'\''|json -b 3'

echo '$ echo -n '\''t'\''|json -b 1'
echo -n 't'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''t'\''|json -b 1'

echo '$ echo -n '\''t'\''|json -b 2'
echo -n 't'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''t'\''|json -b 2'

echo '$ echo -n '\''t'\''|json -b 3'
echo -n 't'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''t'\''|json -b 3'

echo '$ echo -n '\''u'\''|json -b 1'
echo -n 'u'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''u'\''|json -b 1'

echo '$ echo -n '\''u'\''|json -b 2'
echo -n 'u'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''u'\''|json -b 2'

echo '$ echo -n '\''u'\''|json -b 3'
echo -n 'u'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''u'\''|json -b 3'

echo '$ echo -n '\''v'\''|json -b 1'
echo -n 'v'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''v'\''|json -b 1'

echo '$ echo -n '\''v'\''|json -b 2'
echo -n 'v'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''v'\''|json -b 2'

echo '$ echo -n '\''v'\''|json -b 3'
echo -n 'v'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''v'\''|json -b 3'

echo '$ echo -n '\''w'\''|json -b 1'
echo -n 'w'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''w'\''|json -b 1'

echo '$ echo -n '\''w'\''|json -b 2'
echo -n 'w'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''w'\''|json -b 2'

echo '$ echo -n '\''w'\''|json -b 3'
echo -n 'w'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''w'\''|json -b 3'

echo '$ echo -n '\''x'\''|json -b 1'
echo -n 'x'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''x'\''|json -b 1'

echo '$ echo -n '\''x'\''|json -b 2'
echo -n 'x'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''x'\''|json -b 2'

echo '$ echo -n '\''x'\''|json -b 3'
echo -n 'x'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''x'\''|json -b 3'

echo '$ echo -n '\''y'\''|json -b 1'
echo -n 'y'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''y'\''|json -b 1'

echo '$ echo -n '\''y'\''|json -b 2'
echo -n 'y'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''y'\''|json -b 2'

echo '$ echo -n '\''y'\''|json -b 3'
echo -n 'y'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''y'\''|json -b 3'

echo '$ echo -n '\''z'\''|json -b 1'
echo -n 'z'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''z'\''|json -b 1'

echo '$ echo -n '\''z'\''|json -b 2'
echo -n 'z'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''z'\''|json -b 2'

echo '$ echo -n '\''z'\''|json -b 3'
echo -n 'z'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''z'\''|json -b 3'

echo '$ echo -n '\''{'\''|json -b 1'
echo -n '{'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''{'\''|json -b 1'

echo '$ echo -n '\''{'\''|json -b 2'
echo -n '{'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''{'\''|json -b 2'

echo '$ echo -n '\''{'\''|json -b 3'
echo -n '{'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''{'\''|json -b 3'

echo '$ echo -n '\''|'\''|json -b 1'
echo -n '|'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''|'\''|json -b 1'

echo '$ echo -n '\''|'\''|json -b 2'
echo -n '|'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''|'\''|json -b 2'

echo '$ echo -n '\''|'\''|json -b 3'
echo -n '|'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''|'\''|json -b 3'

echo '$ echo -n '\''}'\''|json -b 1'
echo -n '}'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''}'\''|json -b 1'

echo '$ echo -n '\''}'\''|json -b 2'
echo -n '}'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''}'\''|json -b 2'

echo '$ echo -n '\''}'\''|json -b 3'
echo -n '}'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''}'\''|json -b 3'

echo '$ echo -n '\''~'\''|json -b 1'
echo -n '~'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''~'\''|json -b 1'

echo '$ echo -n '\''~'\''|json -b 2'
echo -n '~'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''~'\''|json -b 2'

echo '$ echo -n '\''~'\''|json -b 3'
echo -n '~'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''~'\''|json -b 3'

echo '$ echo -ne '\''\x7f'\''|json -b 1'
echo -ne '\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x7f'\''|json -b 1'

echo '$ echo -ne '\''\x7f'\''|json -b 2'
echo -ne '\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x7f'\''|json -b 2'

echo '$ echo -ne '\''\x7f'\''|json -b 3'
echo -ne '\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x7f'\''|json -b 3'
)

