#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:41
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 41.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\tfoo","type":"null"}],"expr":"`\tfoo"}'\''
json: error: <stdin>:1:70: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:1:70: ","type":"null"}],"expr":"`\\tfoo"}
json: error: <stdin>:1:70:                                  ^
command failed: json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\tfoo","type":"null"}],"expr":"`\tfoo"}'\''
$ json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\tfoo","type":"null"}],"expr":"`\t\tfoo"}'\''
json: error: <stdin>:1:74: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:1:74: "type":"null"}],"expr":"`\\t\\tfoo"}
json: error: <stdin>:1:74:                                   ^
command failed: json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\tfoo","type":"null"}],"expr":"`\t\tfoo"}'\''
$ json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\t\tfoo","type":"null"}],"expr":"`\t\t\tfoo"}'\''
json: error: <stdin>:1:78: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:1:78: ype":"null"}],"expr":"`\\t\\t\\tfoo"}
json: error: <stdin>:1:78:                                    ^
command failed: json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\t\tfoo","type":"null"}],"expr":"`\t\t\tfoo"}'\'''
) -L 41.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\tfoo","type":"null"}],"expr":"`\tfoo"}'\'''
json -V -Tc <<< '{"type":"dict","args":[{"name":"\tfoo","type":"null"}],"expr":"`\tfoo"}' 2>&1 ||
echo 'command failed: json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\tfoo","type":"null"}],"expr":"`\tfoo"}'\'''

echo '$ json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\tfoo","type":"null"}],"expr":"`\t\tfoo"}'\'''
json -V -Tc <<< '{"type":"dict","args":[{"name":"\t\tfoo","type":"null"}],"expr":"`\t\tfoo"}' 2>&1 ||
echo 'command failed: json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\tfoo","type":"null"}],"expr":"`\t\tfoo"}'\'''

echo '$ json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\t\tfoo","type":"null"}],"expr":"`\t\t\tfoo"}'\'''
json -V -Tc <<< '{"type":"dict","args":[{"name":"\t\t\tfoo","type":"null"}],"expr":"`\t\t\tfoo"}' 2>&1 ||
echo 'command failed: json -V -Tc <<< '\''{"type":"dict","args":[{"name":"\t\t\tfoo","type":"null"}],"expr":"`\t\t\tfoo"}'\'''
)

