#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:empty
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L empty.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo|json
json: error: <stdin>:2:1: parse error: unexpected token
json: error: <stdin>:2:1: 
json: error: <stdin>:2:1: ^
command failed: echo|json
$ echo -n|json
json: error: <stdin>:1:1: parse error: unexpected token
json: error: <stdin>:1:1: 
json: error: <stdin>:1:1: ^
command failed: echo -n|json
$ echo -ne '\''\n\n\n\n'\''|json
json: error: <stdin>:5:1: parse error: unexpected token
json: error: <stdin>:5:1: \n\n\n
json: error: <stdin>:5:1:       ^
command failed: echo -ne '\''\n\n\n\n'\''|json
$ echo -ne '\'' \t\n\r'\''|json
json: error: <stdin>:2:2: parse error: unexpected token
json: error: <stdin>:2:2:  \t\n\r
json: error: <stdin>:2:2:        ^
command failed: echo -ne '\'' \t\n\r'\''|json'
) -L empty.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo|json'
echo|json 2>&1 ||
echo 'command failed: echo|json'

echo '$ echo -n|json'
echo -n|json 2>&1 ||
echo 'command failed: echo -n|json'

echo '$ echo -ne '\''\n\n\n\n'\''|json'
echo -ne '\n\n\n\n'|json 2>&1 ||
echo 'command failed: echo -ne '\''\n\n\n\n'\''|json'

echo '$ echo -ne '\'' \t\n\r'\''|json'
echo -ne ' \t\n\r'|json 2>&1 ||
echo 'command failed: echo -ne '\'' \t\n\r'\''|json'
)

