#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:rex-dup
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L rex-dup.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '\''{'\''; for((i=0;i<n;i++));do printf '\''"%s":"/%s/"'\'' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '\''}'\''; }
$ diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; }
$ json-litex -d "$(gen-litex -16)"
{
    "rexes": {
        "size": 16,
        "codes": {
            "type": "patterns",
            "code": {}
        },
        "elems": [
            {
                "text": "0",
                "opts": ""
            },
            {
                "text": "1",
                "opts": ""
            },
            {
                "text": "2",
                "opts": ""
            },
            {
                "text": "3",
                "opts": ""
            },
            {
                "text": "4",
                "opts": ""
            },
            {
                "text": "5",
                "opts": ""
            },
            {
                "text": "6",
                "opts": ""
            },
            {
                "text": "7",
                "opts": ""
            },
            {
                "text": "8",
                "opts": ""
            },
            {
                "text": "9",
                "opts": ""
            },
            {
                "text": "10",
                "opts": ""
            },
            {
                "text": "11",
                "opts": ""
            },
            {
                "text": "12",
                "opts": ""
            },
            {
                "text": "13",
                "opts": ""
            },
            {
                "text": "14",
                "opts": ""
            },
            {
                "text": "15",
                "opts": ""
            }
        ]
    },
    "node": {
        "id": 54,
        "type": "object",
        "node": {
            "size": 16,
            "args": [
                {
                    "key": {
                        "val": "0",
                        "delim": null
                    },
                    "val": {
                        "id": 5,
                        "type": "string",
                        "node": {
                            "val": "/0/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 0
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 0
                    }
                },
                {
                    "key": {
                        "val": "1",
                        "delim": null
                    },
                    "val": {
                        "id": 8,
                        "type": "string",
                        "node": {
                            "val": "/1/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 1
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 1
                    }
                },
                {
                    "key": {
                        "val": "2",
                        "delim": null
                    },
                    "val": {
                        "id": 11,
                        "type": "string",
                        "node": {
                            "val": "/2/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 2
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 2
                    }
                },
                {
                    "key": {
                        "val": "3",
                        "delim": null
                    },
                    "val": {
                        "id": 14,
                        "type": "string",
                        "node": {
                            "val": "/3/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 3
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 3
                    }
                },
                {
                    "key": {
                        "val": "4",
                        "delim": null
                    },
                    "val": {
                        "id": 17,
                        "type": "string",
                        "node": {
                            "val": "/4/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 4
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 4
                    }
                },
                {
                    "key": {
                        "val": "5",
                        "delim": null
                    },
                    "val": {
                        "id": 20,
                        "type": "string",
                        "node": {
                            "val": "/5/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 5
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 5
                    }
                },
                {
                    "key": {
                        "val": "6",
                        "delim": null
                    },
                    "val": {
                        "id": 23,
                        "type": "string",
                        "node": {
                            "val": "/6/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 6
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 6
                    }
                },
                {
                    "key": {
                        "val": "7",
                        "delim": null
                    },
                    "val": {
                        "id": 26,
                        "type": "string",
                        "node": {
                            "val": "/7/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 7
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 7
                    }
                },
                {
                    "key": {
                        "val": "8",
                        "delim": null
                    },
                    "val": {
                        "id": 29,
                        "type": "string",
                        "node": {
                            "val": "/8/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 8
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 8
                    }
                },
                {
                    "key": {
                        "val": "9",
                        "delim": null
                    },
                    "val": {
                        "id": 32,
                        "type": "string",
                        "node": {
                            "val": "/9/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 9
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 9
                    }
                },
                {
                    "key": {
                        "val": "10",
                        "delim": null
                    },
                    "val": {
                        "id": 35,
                        "type": "string",
                        "node": {
                            "val": "/10/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 10
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 10
                    }
                },
                {
                    "key": {
                        "val": "11",
                        "delim": null
                    },
                    "val": {
                        "id": 38,
                        "type": "string",
                        "node": {
                            "val": "/11/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 11
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 11
                    }
                },
                {
                    "key": {
                        "val": "12",
                        "delim": null
                    },
                    "val": {
                        "id": 41,
                        "type": "string",
                        "node": {
                            "val": "/12/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 12
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 12
                    }
                },
                {
                    "key": {
                        "val": "13",
                        "delim": null
                    },
                    "val": {
                        "id": 44,
                        "type": "string",
                        "node": {
                            "val": "/13/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 13
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 13
                    }
                },
                {
                    "key": {
                        "val": "14",
                        "delim": null
                    },
                    "val": {
                        "id": 47,
                        "type": "string",
                        "node": {
                            "val": "/14/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 14
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 14
                    }
                },
                {
                    "key": {
                        "val": "15",
                        "delim": null
                    },
                    "val": {
                        "id": 50,
                        "type": "string",
                        "node": {
                            "val": "/15/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 15
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 15
                    }
                }
            ]
        },
        "attr": {
            "lookup": "0x...",
            "root": {
                "sym": "0",
                "lo": null,
                "eq": {
                    "val": "/0/",
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "1",
                    "lo": null,
                    "eq": {
                        "val": "/1/",
                        "lo": null,
                        "hi": {
                            "sym": "0",
                            "lo": null,
                            "eq": {
                                "val": "/10/",
                                "lo": null,
                                "hi": null
                            },
                            "hi": {
                                "sym": "1",
                                "lo": null,
                                "eq": {
                                    "val": "/11/",
                                    "lo": null,
                                    "hi": null
                                },
                                "hi": {
                                    "sym": "2",
                                    "lo": null,
                                    "eq": {
                                        "val": "/12/",
                                        "lo": null,
                                        "hi": null
                                    },
                                    "hi": {
                                        "sym": "3",
                                        "lo": null,
                                        "eq": {
                                            "val": "/13/",
                                            "lo": null,
                                            "hi": null
                                        },
                                        "hi": {
                                            "sym": "4",
                                            "lo": null,
                                            "eq": {
                                                "val": "/14/",
                                                "lo": null,
                                                "hi": null
                                            },
                                            "hi": {
                                                "sym": "5",
                                                "lo": null,
                                                "eq": {
                                                    "val": "/15/",
                                                    "lo": null,
                                                    "hi": null
                                                },
                                                "hi": null
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    "hi": {
                        "sym": "2",
                        "lo": null,
                        "eq": {
                            "val": "/2/",
                            "lo": null,
                            "hi": null
                        },
                        "hi": {
                            "sym": "3",
                            "lo": null,
                            "eq": {
                                "val": "/3/",
                                "lo": null,
                                "hi": null
                            },
                            "hi": {
                                "sym": "4",
                                "lo": null,
                                "eq": {
                                    "val": "/4/",
                                    "lo": null,
                                    "hi": null
                                },
                                "hi": {
                                    "sym": "5",
                                    "lo": null,
                                    "eq": {
                                        "val": "/5/",
                                        "lo": null,
                                        "hi": null
                                    },
                                    "hi": {
                                        "sym": "6",
                                        "lo": null,
                                        "eq": {
                                            "val": "/6/",
                                            "lo": null,
                                            "hi": null
                                        },
                                        "hi": {
                                            "sym": "7",
                                            "lo": null,
                                            "eq": {
                                                "val": "/7/",
                                                "lo": null,
                                                "hi": null
                                            },
                                            "hi": {
                                                "sym": "8",
                                                "lo": null,
                                                "eq": {
                                                    "val": "/8/",
                                                    "lo": null,
                                                    "hi": null
                                                },
                                                "hi": {
                                                    "sym": "9",
                                                    "lo": null,
                                                    "eq": {
                                                        "val": "/9/",
                                                        "lo": null,
                                                        "hi": null
                                                    },
                                                    "hi": null
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        },
        "parent": null,
        "path": null
    }
}
$ diff-litex -1
--- 16
+++ 1
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 1,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -9,71 +9,11 @@
             {
                 "text": "0",
                 "opts": ""
-            },
-            {
-                "text": "1",
-                "opts": ""
-            },
-            {
-                "text": "2",
-                "opts": ""
-            },
-            {
-                "text": "3",
-                "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 24,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +39,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 0
                     }
                 },
@@ -109,10 +49,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 8,
+                        "id": 6,
                         "type": "string",
                         "node": {
-                            "val": "/1/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -120,11 +60,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 1
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 1
                     }
                 },
@@ -134,10 +74,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 11,
+                        "id": 7,
                         "type": "string",
                         "node": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -145,11 +85,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 2
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 2
                     }
                 },
@@ -159,10 +99,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 14,
+                        "id": 8,
                         "type": "string",
                         "node": {
-                            "val": "/3/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -170,11 +110,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 3
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 3
                     }
                 },
@@ -184,10 +124,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 17,
+                        "id": 9,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -195,11 +135,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 4
                     }
                 },
@@ -209,10 +149,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 20,
+                        "id": 10,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -220,11 +160,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 5
                     }
                 },
@@ -234,10 +174,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 23,
+                        "id": 11,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,11 +185,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 6
                     }
                 },
@@ -259,10 +199,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 26,
+                        "id": 12,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -270,11 +210,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 7
                     }
                 },
@@ -284,10 +224,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 13,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +235,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 8
                     }
                 },
@@ -309,10 +249,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 14,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +260,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 9
                     }
                 },
@@ -334,10 +274,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 15,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +285,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 10
                     }
                 },
@@ -359,10 +299,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 16,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +310,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 11
                     }
                 },
@@ -384,10 +324,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +335,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 12
                     }
                 },
@@ -409,10 +349,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 18,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +360,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 13
                     }
                 },
@@ -434,10 +374,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 19,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +385,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 14
                     }
                 },
@@ -459,10 +399,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +410,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 24,
                         "path": 15
                     }
                 }
@@ -494,13 +434,13 @@
                     "sym": "1",
                     "lo": null,
                     "eq": {
-                        "val": "/1/",
+                        "val": "/0/",
                         "lo": null,
                         "hi": {
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +448,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +456,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +464,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +472,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +480,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -556,7 +496,7 @@
                         "sym": "2",
                         "lo": null,
                         "eq": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "lo": null,
                             "hi": null
                         },
@@ -564,7 +504,7 @@
                             "sym": "3",
                             "lo": null,
                             "eq": {
-                                "val": "/3/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -572,7 +512,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +520,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +528,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +536,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +544,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +552,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/0/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -2
--- 16
+++ 2
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 2,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -13,67 +13,11 @@
             {
                 "text": "1",
                 "opts": ""
-            },
-            {
-                "text": "2",
-                "opts": ""
-            },
-            {
-                "text": "3",
-                "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 26,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +43,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 0
                     }
                 },
@@ -124,7 +68,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 1
                     }
                 },
@@ -134,10 +78,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 11,
+                        "id": 9,
                         "type": "string",
                         "node": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -145,11 +89,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 2
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 2
                     }
                 },
@@ -159,10 +103,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 14,
+                        "id": 10,
                         "type": "string",
                         "node": {
-                            "val": "/3/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -170,11 +114,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 3
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 3
                     }
                 },
@@ -184,10 +128,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 17,
+                        "id": 11,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -195,11 +139,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 4
                     }
                 },
@@ -209,10 +153,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 20,
+                        "id": 12,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -220,11 +164,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 5
                     }
                 },
@@ -234,10 +178,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 23,
+                        "id": 13,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,11 +189,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 6
                     }
                 },
@@ -259,10 +203,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 26,
+                        "id": 14,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -270,11 +214,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 7
                     }
                 },
@@ -284,10 +228,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 15,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +239,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 8
                     }
                 },
@@ -309,10 +253,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 16,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +264,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 9
                     }
                 },
@@ -334,10 +278,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +289,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 10
                     }
                 },
@@ -359,10 +303,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 18,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +314,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 11
                     }
                 },
@@ -384,10 +328,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 19,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +339,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 12
                     }
                 },
@@ -409,10 +353,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +364,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 13
                     }
                 },
@@ -434,10 +378,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 21,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +389,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 14
                     }
                 },
@@ -459,10 +403,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 22,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +414,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 26,
                         "path": 15
                     }
                 }
@@ -500,7 +444,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +452,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +460,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +468,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +476,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +484,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -556,7 +500,7 @@
                         "sym": "2",
                         "lo": null,
                         "eq": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "lo": null,
                             "hi": null
                         },
@@ -564,7 +508,7 @@
                             "sym": "3",
                             "lo": null,
                             "eq": {
-                                "val": "/3/",
+                                "val": "/1/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -572,7 +516,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +524,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/1/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +532,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +540,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +548,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +556,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/1/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -3
--- 16
+++ 3
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 3,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -17,63 +17,11 @@
             {
                 "text": "2",
                 "opts": ""
-            },
-            {
-                "text": "3",
-                "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 28,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +47,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 0
                     }
                 },
@@ -124,7 +72,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 1
                     }
                 },
@@ -149,7 +97,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 2
                     }
                 },
@@ -159,10 +107,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 14,
+                        "id": 12,
                         "type": "string",
                         "node": {
-                            "val": "/3/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -170,11 +118,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 3
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 3
                     }
                 },
@@ -184,10 +132,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 17,
+                        "id": 13,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -195,11 +143,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 4
                     }
                 },
@@ -209,10 +157,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 20,
+                        "id": 14,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -220,11 +168,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 5
                     }
                 },
@@ -234,10 +182,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 23,
+                        "id": 15,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,11 +193,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 6
                     }
                 },
@@ -259,10 +207,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 26,
+                        "id": 16,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -270,11 +218,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 7
                     }
                 },
@@ -284,10 +232,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +243,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 8
                     }
                 },
@@ -309,10 +257,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 18,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +268,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 9
                     }
                 },
@@ -334,10 +282,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 19,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +293,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 10
                     }
                 },
@@ -359,10 +307,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +318,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 11
                     }
                 },
@@ -384,10 +332,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 21,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +343,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 12
                     }
                 },
@@ -409,10 +357,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 22,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +368,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 13
                     }
                 },
@@ -434,10 +382,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +393,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 14
                     }
                 },
@@ -459,10 +407,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 24,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +418,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 28,
                         "path": 15
                     }
                 }
@@ -500,7 +448,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/1/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +456,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/2/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +464,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +472,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +480,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +488,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -564,7 +512,7 @@
                             "sym": "3",
                             "lo": null,
                             "eq": {
-                                "val": "/3/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -572,7 +520,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +528,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/2/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +536,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +544,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +552,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/2/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +560,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/0/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -4
--- 16
+++ 4
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 4,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -21,59 +21,11 @@
             {
                 "text": "3",
                 "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 30,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +51,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 0
                     }
                 },
@@ -124,7 +76,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 1
                     }
                 },
@@ -149,7 +101,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 2
                     }
                 },
@@ -174,7 +126,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 3
                     }
                 },
@@ -184,10 +136,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 17,
+                        "id": 15,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -195,11 +147,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 4
                     }
                 },
@@ -209,10 +161,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 20,
+                        "id": 16,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -220,11 +172,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 5
                     }
                 },
@@ -234,10 +186,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 23,
+                        "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -245,11 +197,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 6
                     }
                 },
@@ -259,10 +211,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 26,
+                        "id": 18,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -270,11 +222,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 7
                     }
                 },
@@ -284,10 +236,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 19,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +247,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 8
                     }
                 },
@@ -309,10 +261,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +272,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 9
                     }
                 },
@@ -334,10 +286,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 21,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +297,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 10
                     }
                 },
@@ -359,10 +311,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 22,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +322,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 11
                     }
                 },
@@ -384,10 +336,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +347,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 12
                     }
                 },
@@ -409,10 +361,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 24,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +372,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 13
                     }
                 },
@@ -434,10 +386,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 25,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +397,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 14
                     }
                 },
@@ -459,10 +411,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +422,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 30,
                         "path": 15
                     }
                 }
@@ -500,7 +452,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/2/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +460,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/3/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +468,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +476,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +484,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +492,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -572,7 +524,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +532,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/1/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +540,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/2/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +548,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/3/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +556,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +564,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/1/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -5
--- 16
+++ 5
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 5,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -25,55 +25,11 @@
             {
                 "text": "4",
                 "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 32,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +55,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 0
                     }
                 },
@@ -124,7 +80,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 1
                     }
                 },
@@ -149,7 +105,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 2
                     }
                 },
@@ -174,7 +130,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 3
                     }
                 },
@@ -199,7 +155,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 4
                     }
                 },
@@ -209,10 +165,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 20,
+                        "id": 18,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -220,11 +176,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 5
                     }
                 },
@@ -234,10 +190,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 23,
+                        "id": 19,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -245,11 +201,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 6
                     }
                 },
@@ -259,10 +215,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 26,
+                        "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -270,11 +226,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 7
                     }
                 },
@@ -284,10 +240,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 21,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +251,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 8
                     }
                 },
@@ -309,10 +265,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 22,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +276,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 9
                     }
                 },
@@ -334,10 +290,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +301,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 10
                     }
                 },
@@ -359,10 +315,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 24,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +326,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 11
                     }
                 },
@@ -384,10 +340,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 25,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +351,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 12
                     }
                 },
@@ -409,10 +365,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +376,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 13
                     }
                 },
@@ -434,10 +390,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 27,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +401,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 14
                     }
                 },
@@ -459,10 +415,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 28,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +426,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 32,
                         "path": 15
                     }
                 }
@@ -500,7 +456,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +464,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +472,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/2/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +480,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/3/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +488,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/4/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +496,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -580,7 +536,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +544,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +552,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +560,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +568,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/4/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -6
--- 16
+++ 6
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 6,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -29,51 +29,11 @@
             {
                 "text": "5",
                 "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 34,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +59,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 0
                     }
                 },
@@ -124,7 +84,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 1
                     }
                 },
@@ -149,7 +109,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 2
                     }
                 },
@@ -174,7 +134,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 3
                     }
                 },
@@ -199,7 +159,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 4
                     }
                 },
@@ -224,7 +184,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 5
                     }
                 },
@@ -234,10 +194,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 23,
+                        "id": 21,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,11 +205,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 6
                     }
                 },
@@ -259,10 +219,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 26,
+                        "id": 22,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -270,11 +230,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 7
                     }
                 },
@@ -284,10 +244,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +255,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 8
                     }
                 },
@@ -309,10 +269,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 24,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +280,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 9
                     }
                 },
@@ -334,10 +294,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 25,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +305,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 10
                     }
                 },
@@ -359,10 +319,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +330,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 5
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 11
                     }
                 },
@@ -384,10 +344,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 27,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +355,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 12
                     }
                 },
@@ -409,10 +369,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 28,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +380,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 13
                     }
                 },
@@ -434,10 +394,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +405,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 14
                     }
                 },
@@ -459,10 +419,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 30,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +430,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 34,
                         "path": 15
                     }
                 }
@@ -500,7 +460,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/4/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +468,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/5/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +476,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +484,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +492,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +500,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -588,7 +548,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +556,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +564,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/2/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +572,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/3/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -7
--- 16
+++ 7
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 7,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -33,47 +33,11 @@
             {
                 "text": "6",
                 "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 36,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +63,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 0
                     }
                 },
@@ -124,7 +88,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 1
                     }
                 },
@@ -149,7 +113,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 2
                     }
                 },
@@ -174,7 +138,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 3
                     }
                 },
@@ -199,7 +163,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 4
                     }
                 },
@@ -224,7 +188,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 5
                     }
                 },
@@ -249,7 +213,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 6
                     }
                 },
@@ -259,10 +223,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 26,
+                        "id": 24,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -270,11 +234,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 7
                     }
                 },
@@ -284,10 +248,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 25,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +259,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 8
                     }
                 },
@@ -309,10 +273,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +284,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 9
                     }
                 },
@@ -334,10 +298,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 27,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +309,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 10
                     }
                 },
@@ -359,10 +323,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 28,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +334,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 11
                     }
                 },
@@ -384,10 +348,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +359,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 5
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 12
                     }
                 },
@@ -409,10 +373,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 30,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/6/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +384,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 6
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 13
                     }
                 },
@@ -434,10 +398,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 31,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +409,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 14
                     }
                 },
@@ -459,10 +423,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +434,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 36,
                         "path": 15
                     }
                 }
@@ -500,7 +464,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/3/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +472,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/4/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +480,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/5/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +488,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/6/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +496,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +504,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -596,7 +560,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +568,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +576,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/2/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -8
--- 16
+++ 8
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 8,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -37,43 +37,11 @@
             {
                 "text": "7",
                 "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 38,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +67,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 0
                     }
                 },
@@ -124,7 +92,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 1
                     }
                 },
@@ -149,7 +117,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 2
                     }
                 },
@@ -174,7 +142,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 3
                     }
                 },
@@ -199,7 +167,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 4
                     }
                 },
@@ -224,7 +192,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 5
                     }
                 },
@@ -249,7 +217,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 6
                     }
                 },
@@ -274,7 +242,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 7
                     }
                 },
@@ -284,10 +252,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 29,
+                        "id": 27,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,11 +263,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 8
                     }
                 },
@@ -309,10 +277,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 28,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +288,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 9
                     }
                 },
@@ -334,10 +302,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +313,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 10
                     }
                 },
@@ -359,10 +327,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 30,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +338,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 11
                     }
                 },
@@ -384,10 +352,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 31,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +363,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 12
                     }
                 },
@@ -409,10 +377,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +388,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 5
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 13
                     }
                 },
@@ -434,10 +402,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 33,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/6/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +413,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 6
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 14
                     }
                 },
@@ -459,10 +427,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 34,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/7/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +438,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 7
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 38,
                         "path": 15
                     }
                 }
@@ -500,7 +468,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/2/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +476,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/3/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +484,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/4/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +492,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/5/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +500,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/6/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +508,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/7/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -604,7 +572,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +580,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/1/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -9
--- 16
+++ 9
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 9,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -41,39 +41,11 @@
             {
                 "text": "8",
                 "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 40,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +71,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 0
                     }
                 },
@@ -124,7 +96,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 1
                     }
                 },
@@ -149,7 +121,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 2
                     }
                 },
@@ -174,7 +146,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 3
                     }
                 },
@@ -199,7 +171,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 4
                     }
                 },
@@ -224,7 +196,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 5
                     }
                 },
@@ -249,7 +221,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 6
                     }
                 },
@@ -274,7 +246,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 7
                     }
                 },
@@ -299,7 +271,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 8
                     }
                 },
@@ -309,10 +281,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 32,
+                        "id": 30,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -320,11 +292,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 9
                     }
                 },
@@ -334,10 +306,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 31,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +317,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 10
                     }
                 },
@@ -359,10 +331,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +342,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 11
                     }
                 },
@@ -384,10 +356,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 33,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +367,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 12
                     }
                 },
@@ -409,10 +381,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 34,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +392,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 13
                     }
                 },
@@ -434,10 +406,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +417,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 5
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 14
                     }
                 },
@@ -459,10 +431,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 36,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/6/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +442,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 6
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 40,
                         "path": 15
                     }
                 }
@@ -500,7 +472,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/1/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +480,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/2/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +488,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/3/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +496,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/4/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +504,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/5/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +512,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/6/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +584,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/0/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -10
--- 16
+++ 10
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 10,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -45,35 +45,11 @@
             {
                 "text": "9",
                 "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 42,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +75,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 0
                     }
                 },
@@ -124,7 +100,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 1
                     }
                 },
@@ -149,7 +125,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 2
                     }
                 },
@@ -174,7 +150,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 3
                     }
                 },
@@ -199,7 +175,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 4
                     }
                 },
@@ -224,7 +200,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 5
                     }
                 },
@@ -249,7 +225,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 6
                     }
                 },
@@ -274,7 +250,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 7
                     }
                 },
@@ -299,7 +275,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 8
                     }
                 },
@@ -324,7 +300,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 9
                     }
                 },
@@ -334,10 +310,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 35,
+                        "id": 33,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,11 +321,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 10
                     }
                 },
@@ -359,10 +335,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 34,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +346,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 11
                     }
                 },
@@ -384,10 +360,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +371,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 12
                     }
                 },
@@ -409,10 +385,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 36,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +396,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 13
                     }
                 },
@@ -434,10 +410,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 37,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +421,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 14
                     }
                 },
@@ -459,10 +435,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +446,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 5
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 42,
                         "path": 15
                     }
                 }
@@ -500,7 +476,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +484,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +492,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/2/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +500,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/3/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +508,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/4/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +516,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/5/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -11
--- 16
+++ 11
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 11,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -49,31 +49,11 @@
             {
                 "text": "10",
                 "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 44,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +79,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 0
                     }
                 },
@@ -124,7 +104,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 1
                     }
                 },
@@ -149,7 +129,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 2
                     }
                 },
@@ -174,7 +154,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 3
                     }
                 },
@@ -199,7 +179,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 4
                     }
                 },
@@ -224,7 +204,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 5
                     }
                 },
@@ -249,7 +229,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 6
                     }
                 },
@@ -274,7 +254,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 7
                     }
                 },
@@ -299,7 +279,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 8
                     }
                 },
@@ -324,7 +304,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 9
                     }
                 },
@@ -349,7 +329,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 10
                     }
                 },
@@ -359,10 +339,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 38,
+                        "id": 36,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -370,11 +350,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 11
                     }
                 },
@@ -384,10 +364,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 37,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +375,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 12
                     }
                 },
@@ -409,10 +389,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +400,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 13
                     }
                 },
@@ -434,10 +414,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 39,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +425,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 14
                     }
                 },
@@ -459,10 +439,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 40,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +450,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 4
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 44,
                         "path": 15
                     }
                 }
@@ -508,7 +488,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +496,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/1/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +504,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/2/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +512,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/3/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +520,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/4/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -12
--- 16
+++ 12
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 12,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -53,27 +53,11 @@
             {
                 "text": "11",
                 "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 46,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +83,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 0
                     }
                 },
@@ -124,7 +108,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 1
                     }
                 },
@@ -149,7 +133,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 2
                     }
                 },
@@ -174,7 +158,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 3
                     }
                 },
@@ -199,7 +183,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 4
                     }
                 },
@@ -224,7 +208,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 5
                     }
                 },
@@ -249,7 +233,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 6
                     }
                 },
@@ -274,7 +258,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 7
                     }
                 },
@@ -299,7 +283,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 8
                     }
                 },
@@ -324,7 +308,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 9
                     }
                 },
@@ -349,7 +333,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 10
                     }
                 },
@@ -374,7 +358,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 11
                     }
                 },
@@ -384,10 +368,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 41,
+                        "id": 39,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,11 +379,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 12
                     }
                 },
@@ -409,10 +393,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 40,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +404,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 13
                     }
                 },
@@ -434,10 +418,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +429,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 14
                     }
                 },
@@ -459,10 +443,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 42,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +454,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 3
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 46,
                         "path": 15
                     }
                 }
@@ -516,7 +500,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +508,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +516,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +524,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -13
--- 16
+++ 13
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 13,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -57,23 +57,11 @@
             {
                 "text": "12",
                 "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 48,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +87,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 0
                     }
                 },
@@ -124,7 +112,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 1
                     }
                 },
@@ -149,7 +137,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 2
                     }
                 },
@@ -174,7 +162,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 3
                     }
                 },
@@ -199,7 +187,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 4
                     }
                 },
@@ -224,7 +212,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 5
                     }
                 },
@@ -249,7 +237,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 6
                     }
                 },
@@ -274,7 +262,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 7
                     }
                 },
@@ -299,7 +287,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 8
                     }
                 },
@@ -324,7 +312,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 9
                     }
                 },
@@ -349,7 +337,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 10
                     }
                 },
@@ -374,7 +362,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 11
                     }
                 },
@@ -399,7 +387,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 12
                     }
                 },
@@ -409,10 +397,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 44,
+                        "id": 42,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -420,11 +408,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 13
                     }
                 },
@@ -434,10 +422,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 43,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +433,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 14
                     }
                 },
@@ -459,10 +447,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +458,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 2
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 48,
                         "path": 15
                     }
                 }
@@ -524,7 +512,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +520,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +528,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/2/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -14
--- 16
+++ 14
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 14,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -61,19 +61,11 @@
             {
                 "text": "13",
                 "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 50,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +91,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 0
                     }
                 },
@@ -124,7 +116,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 1
                     }
                 },
@@ -149,7 +141,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 2
                     }
                 },
@@ -174,7 +166,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 3
                     }
                 },
@@ -199,7 +191,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 4
                     }
                 },
@@ -224,7 +216,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 5
                     }
                 },
@@ -249,7 +241,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 6
                     }
                 },
@@ -274,7 +266,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 7
                     }
                 },
@@ -299,7 +291,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 8
                     }
                 },
@@ -324,7 +316,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 9
                     }
                 },
@@ -349,7 +341,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 10
                     }
                 },
@@ -374,7 +366,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 11
                     }
                 },
@@ -399,7 +391,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 12
                     }
                 },
@@ -424,7 +416,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 13
                     }
                 },
@@ -434,10 +426,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 47,
+                        "id": 45,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,11 +437,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 14
                     }
                 },
@@ -459,10 +451,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 46,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +462,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 1
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 50,
                         "path": 15
                     }
                 }
@@ -532,7 +524,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +532,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -15
--- 16
+++ 15
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 15,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -65,15 +65,11 @@
             {
                 "text": "14",
                 "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
     "node": {
-        "id": 54,
+        "id": 52,
         "type": "object",
         "node": {
             "size": 16,
@@ -99,7 +95,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 0
                     }
                 },
@@ -124,7 +120,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 1
                     }
                 },
@@ -149,7 +145,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 2
                     }
                 },
@@ -174,7 +170,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 3
                     }
                 },
@@ -199,7 +195,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 4
                     }
                 },
@@ -224,7 +220,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 5
                     }
                 },
@@ -249,7 +245,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 6
                     }
                 },
@@ -274,7 +270,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 7
                     }
                 },
@@ -299,7 +295,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 8
                     }
                 },
@@ -324,7 +320,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 9
                     }
                 },
@@ -349,7 +345,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 10
                     }
                 },
@@ -374,7 +370,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 11
                     }
                 },
@@ -399,7 +395,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 12
                     }
                 },
@@ -424,7 +420,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 13
                     }
                 },
@@ -449,7 +445,7 @@
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 14
                     }
                 },
@@ -459,10 +455,10 @@
                         "delim": null
                     },
                     "val": {
-                        "id": 50,
+                        "id": 48,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,11 +466,11 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
-                        "parent": 54,
+                        "parent": 52,
                         "path": 15
                     }
                 }
@@ -540,7 +536,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },'
) -L rex-dup.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '\''{'\''; for((i=0;i<n;i++));do printf '\''"%s":"/%s/"'\'' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '\''}'\''; }'
gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '{'; for((i=0;i<n;i++));do printf '"%s":"/%s/"' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '}'; } 2>&1 ||
echo 'command failed: gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '\''{'\''; for((i=0;i<n;i++));do printf '\''"%s":"/%s/"'\'' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '\''}'\''; }'

echo '$ diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; }'
diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; } 2>&1 ||
echo 'command failed: diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; }'

echo '$ json-litex -d "$(gen-litex -16)"'
json-litex -d "$(gen-litex -16)" 2>&1 ||
echo 'command failed: json-litex -d "$(gen-litex -16)"'

echo '$ diff-litex -1'
diff-litex -1 2>&1 ||
echo 'command failed: diff-litex -1'

echo '$ diff-litex -2'
diff-litex -2 2>&1 ||
echo 'command failed: diff-litex -2'

echo '$ diff-litex -3'
diff-litex -3 2>&1 ||
echo 'command failed: diff-litex -3'

echo '$ diff-litex -4'
diff-litex -4 2>&1 ||
echo 'command failed: diff-litex -4'

echo '$ diff-litex -5'
diff-litex -5 2>&1 ||
echo 'command failed: diff-litex -5'

echo '$ diff-litex -6'
diff-litex -6 2>&1 ||
echo 'command failed: diff-litex -6'

echo '$ diff-litex -7'
diff-litex -7 2>&1 ||
echo 'command failed: diff-litex -7'

echo '$ diff-litex -8'
diff-litex -8 2>&1 ||
echo 'command failed: diff-litex -8'

echo '$ diff-litex -9'
diff-litex -9 2>&1 ||
echo 'command failed: diff-litex -9'

echo '$ diff-litex -10'
diff-litex -10 2>&1 ||
echo 'command failed: diff-litex -10'

echo '$ diff-litex -11'
diff-litex -11 2>&1 ||
echo 'command failed: diff-litex -11'

echo '$ diff-litex -12'
diff-litex -12 2>&1 ||
echo 'command failed: diff-litex -12'

echo '$ diff-litex -13'
diff-litex -13 2>&1 ||
echo 'command failed: diff-litex -13'

echo '$ diff-litex -14'
diff-litex -14 2>&1 ||
echo 'command failed: diff-litex -14'

echo '$ diff-litex -15'
diff-litex -15 2>&1 ||
echo 'command failed: diff-litex -15'
)

