#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-unicode3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-unicode3.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --escape-utf8 "$@"; }
$ echo '\''"\u0040"'\''|json -b 1
"@"
$ echo '\''"\u0040"'\''|json -b 2
"@"
$ echo '\''"\u0040"'\''|json -b 3
"@"
$ echo '\''"\u0040"'\''|json -b 4
"@"
$ echo '\''"\u0040"'\''|json -b 5
"@"
$ echo '\''"\u0040"'\''|json -b 6
"@"
$ echo '\''"\u0040"'\''|json -b 7
"@"
$ echo '\''"\u0040"'\''|json -b 8
"@"
$ echo '\''"\u0041"'\''|json -b 1
"A"
$ echo '\''"\u0041"'\''|json -b 2
"A"
$ echo '\''"\u0041"'\''|json -b 3
"A"
$ echo '\''"\u0041"'\''|json -b 4
"A"
$ echo '\''"\u0041"'\''|json -b 5
"A"
$ echo '\''"\u0041"'\''|json -b 6
"A"
$ echo '\''"\u0041"'\''|json -b 7
"A"
$ echo '\''"\u0041"'\''|json -b 8
"A"
$ echo '\''"\u0042"'\''|json -b 1
"B"
$ echo '\''"\u0042"'\''|json -b 2
"B"
$ echo '\''"\u0042"'\''|json -b 3
"B"
$ echo '\''"\u0042"'\''|json -b 4
"B"
$ echo '\''"\u0042"'\''|json -b 5
"B"
$ echo '\''"\u0042"'\''|json -b 6
"B"
$ echo '\''"\u0042"'\''|json -b 7
"B"
$ echo '\''"\u0042"'\''|json -b 8
"B"
$ echo '\''"\u0043"'\''|json -b 1
"C"
$ echo '\''"\u0043"'\''|json -b 2
"C"
$ echo '\''"\u0043"'\''|json -b 3
"C"
$ echo '\''"\u0043"'\''|json -b 4
"C"
$ echo '\''"\u0043"'\''|json -b 5
"C"
$ echo '\''"\u0043"'\''|json -b 6
"C"
$ echo '\''"\u0043"'\''|json -b 7
"C"
$ echo '\''"\u0043"'\''|json -b 8
"C"
$ echo '\''"\u0044"'\''|json -b 1
"D"
$ echo '\''"\u0044"'\''|json -b 2
"D"
$ echo '\''"\u0044"'\''|json -b 3
"D"
$ echo '\''"\u0044"'\''|json -b 4
"D"
$ echo '\''"\u0044"'\''|json -b 5
"D"
$ echo '\''"\u0044"'\''|json -b 6
"D"
$ echo '\''"\u0044"'\''|json -b 7
"D"
$ echo '\''"\u0044"'\''|json -b 8
"D"
$ echo '\''"\u0045"'\''|json -b 1
"E"
$ echo '\''"\u0045"'\''|json -b 2
"E"
$ echo '\''"\u0045"'\''|json -b 3
"E"
$ echo '\''"\u0045"'\''|json -b 4
"E"
$ echo '\''"\u0045"'\''|json -b 5
"E"
$ echo '\''"\u0045"'\''|json -b 6
"E"
$ echo '\''"\u0045"'\''|json -b 7
"E"
$ echo '\''"\u0045"'\''|json -b 8
"E"
$ echo '\''"\u0046"'\''|json -b 1
"F"
$ echo '\''"\u0046"'\''|json -b 2
"F"
$ echo '\''"\u0046"'\''|json -b 3
"F"
$ echo '\''"\u0046"'\''|json -b 4
"F"
$ echo '\''"\u0046"'\''|json -b 5
"F"
$ echo '\''"\u0046"'\''|json -b 6
"F"
$ echo '\''"\u0046"'\''|json -b 7
"F"
$ echo '\''"\u0046"'\''|json -b 8
"F"
$ echo '\''"\u0047"'\''|json -b 1
"G"
$ echo '\''"\u0047"'\''|json -b 2
"G"
$ echo '\''"\u0047"'\''|json -b 3
"G"
$ echo '\''"\u0047"'\''|json -b 4
"G"
$ echo '\''"\u0047"'\''|json -b 5
"G"
$ echo '\''"\u0047"'\''|json -b 6
"G"
$ echo '\''"\u0047"'\''|json -b 7
"G"
$ echo '\''"\u0047"'\''|json -b 8
"G"
$ echo '\''"\u0048"'\''|json -b 1
"H"
$ echo '\''"\u0048"'\''|json -b 2
"H"
$ echo '\''"\u0048"'\''|json -b 3
"H"
$ echo '\''"\u0048"'\''|json -b 4
"H"
$ echo '\''"\u0048"'\''|json -b 5
"H"
$ echo '\''"\u0048"'\''|json -b 6
"H"
$ echo '\''"\u0048"'\''|json -b 7
"H"
$ echo '\''"\u0048"'\''|json -b 8
"H"
$ echo '\''"\u0049"'\''|json -b 1
"I"
$ echo '\''"\u0049"'\''|json -b 2
"I"
$ echo '\''"\u0049"'\''|json -b 3
"I"
$ echo '\''"\u0049"'\''|json -b 4
"I"
$ echo '\''"\u0049"'\''|json -b 5
"I"
$ echo '\''"\u0049"'\''|json -b 6
"I"
$ echo '\''"\u0049"'\''|json -b 7
"I"
$ echo '\''"\u0049"'\''|json -b 8
"I"
$ echo '\''"\u004a"'\''|json -b 1
"J"
$ echo '\''"\u004a"'\''|json -b 2
"J"
$ echo '\''"\u004a"'\''|json -b 3
"J"
$ echo '\''"\u004a"'\''|json -b 4
"J"
$ echo '\''"\u004a"'\''|json -b 5
"J"
$ echo '\''"\u004a"'\''|json -b 6
"J"
$ echo '\''"\u004a"'\''|json -b 7
"J"
$ echo '\''"\u004a"'\''|json -b 8
"J"
$ echo '\''"\u004b"'\''|json -b 1
"K"
$ echo '\''"\u004b"'\''|json -b 2
"K"
$ echo '\''"\u004b"'\''|json -b 3
"K"
$ echo '\''"\u004b"'\''|json -b 4
"K"
$ echo '\''"\u004b"'\''|json -b 5
"K"
$ echo '\''"\u004b"'\''|json -b 6
"K"
$ echo '\''"\u004b"'\''|json -b 7
"K"
$ echo '\''"\u004b"'\''|json -b 8
"K"
$ echo '\''"\u004c"'\''|json -b 1
"L"
$ echo '\''"\u004c"'\''|json -b 2
"L"
$ echo '\''"\u004c"'\''|json -b 3
"L"
$ echo '\''"\u004c"'\''|json -b 4
"L"
$ echo '\''"\u004c"'\''|json -b 5
"L"
$ echo '\''"\u004c"'\''|json -b 6
"L"
$ echo '\''"\u004c"'\''|json -b 7
"L"
$ echo '\''"\u004c"'\''|json -b 8
"L"
$ echo '\''"\u004d"'\''|json -b 1
"M"
$ echo '\''"\u004d"'\''|json -b 2
"M"
$ echo '\''"\u004d"'\''|json -b 3
"M"
$ echo '\''"\u004d"'\''|json -b 4
"M"
$ echo '\''"\u004d"'\''|json -b 5
"M"
$ echo '\''"\u004d"'\''|json -b 6
"M"
$ echo '\''"\u004d"'\''|json -b 7
"M"
$ echo '\''"\u004d"'\''|json -b 8
"M"
$ echo '\''"\u004e"'\''|json -b 1
"N"
$ echo '\''"\u004e"'\''|json -b 2
"N"
$ echo '\''"\u004e"'\''|json -b 3
"N"
$ echo '\''"\u004e"'\''|json -b 4
"N"
$ echo '\''"\u004e"'\''|json -b 5
"N"
$ echo '\''"\u004e"'\''|json -b 6
"N"
$ echo '\''"\u004e"'\''|json -b 7
"N"
$ echo '\''"\u004e"'\''|json -b 8
"N"
$ echo '\''"\u004f"'\''|json -b 1
"O"
$ echo '\''"\u004f"'\''|json -b 2
"O"
$ echo '\''"\u004f"'\''|json -b 3
"O"
$ echo '\''"\u004f"'\''|json -b 4
"O"
$ echo '\''"\u004f"'\''|json -b 5
"O"
$ echo '\''"\u004f"'\''|json -b 6
"O"
$ echo '\''"\u004f"'\''|json -b 7
"O"
$ echo '\''"\u004f"'\''|json -b 8
"O"
$ echo '\''"\u0050"'\''|json -b 1
"P"
$ echo '\''"\u0050"'\''|json -b 2
"P"
$ echo '\''"\u0050"'\''|json -b 3
"P"
$ echo '\''"\u0050"'\''|json -b 4
"P"
$ echo '\''"\u0050"'\''|json -b 5
"P"
$ echo '\''"\u0050"'\''|json -b 6
"P"
$ echo '\''"\u0050"'\''|json -b 7
"P"
$ echo '\''"\u0050"'\''|json -b 8
"P"
$ echo '\''"\u0051"'\''|json -b 1
"Q"
$ echo '\''"\u0051"'\''|json -b 2
"Q"
$ echo '\''"\u0051"'\''|json -b 3
"Q"
$ echo '\''"\u0051"'\''|json -b 4
"Q"
$ echo '\''"\u0051"'\''|json -b 5
"Q"
$ echo '\''"\u0051"'\''|json -b 6
"Q"
$ echo '\''"\u0051"'\''|json -b 7
"Q"
$ echo '\''"\u0051"'\''|json -b 8
"Q"
$ echo '\''"\u0052"'\''|json -b 1
"R"
$ echo '\''"\u0052"'\''|json -b 2
"R"
$ echo '\''"\u0052"'\''|json -b 3
"R"
$ echo '\''"\u0052"'\''|json -b 4
"R"
$ echo '\''"\u0052"'\''|json -b 5
"R"
$ echo '\''"\u0052"'\''|json -b 6
"R"
$ echo '\''"\u0052"'\''|json -b 7
"R"
$ echo '\''"\u0052"'\''|json -b 8
"R"
$ echo '\''"\u0053"'\''|json -b 1
"S"
$ echo '\''"\u0053"'\''|json -b 2
"S"
$ echo '\''"\u0053"'\''|json -b 3
"S"
$ echo '\''"\u0053"'\''|json -b 4
"S"
$ echo '\''"\u0053"'\''|json -b 5
"S"
$ echo '\''"\u0053"'\''|json -b 6
"S"
$ echo '\''"\u0053"'\''|json -b 7
"S"
$ echo '\''"\u0053"'\''|json -b 8
"S"
$ echo '\''"\u0054"'\''|json -b 1
"T"
$ echo '\''"\u0054"'\''|json -b 2
"T"
$ echo '\''"\u0054"'\''|json -b 3
"T"
$ echo '\''"\u0054"'\''|json -b 4
"T"
$ echo '\''"\u0054"'\''|json -b 5
"T"
$ echo '\''"\u0054"'\''|json -b 6
"T"
$ echo '\''"\u0054"'\''|json -b 7
"T"
$ echo '\''"\u0054"'\''|json -b 8
"T"
$ echo '\''"\u0055"'\''|json -b 1
"U"
$ echo '\''"\u0055"'\''|json -b 2
"U"
$ echo '\''"\u0055"'\''|json -b 3
"U"
$ echo '\''"\u0055"'\''|json -b 4
"U"
$ echo '\''"\u0055"'\''|json -b 5
"U"
$ echo '\''"\u0055"'\''|json -b 6
"U"
$ echo '\''"\u0055"'\''|json -b 7
"U"
$ echo '\''"\u0055"'\''|json -b 8
"U"
$ echo '\''"\u0056"'\''|json -b 1
"V"
$ echo '\''"\u0056"'\''|json -b 2
"V"
$ echo '\''"\u0056"'\''|json -b 3
"V"
$ echo '\''"\u0056"'\''|json -b 4
"V"
$ echo '\''"\u0056"'\''|json -b 5
"V"
$ echo '\''"\u0056"'\''|json -b 6
"V"
$ echo '\''"\u0056"'\''|json -b 7
"V"
$ echo '\''"\u0056"'\''|json -b 8
"V"
$ echo '\''"\u0057"'\''|json -b 1
"W"
$ echo '\''"\u0057"'\''|json -b 2
"W"
$ echo '\''"\u0057"'\''|json -b 3
"W"
$ echo '\''"\u0057"'\''|json -b 4
"W"
$ echo '\''"\u0057"'\''|json -b 5
"W"
$ echo '\''"\u0057"'\''|json -b 6
"W"
$ echo '\''"\u0057"'\''|json -b 7
"W"
$ echo '\''"\u0057"'\''|json -b 8
"W"
$ echo '\''"\u0058"'\''|json -b 1
"X"
$ echo '\''"\u0058"'\''|json -b 2
"X"
$ echo '\''"\u0058"'\''|json -b 3
"X"
$ echo '\''"\u0058"'\''|json -b 4
"X"
$ echo '\''"\u0058"'\''|json -b 5
"X"
$ echo '\''"\u0058"'\''|json -b 6
"X"
$ echo '\''"\u0058"'\''|json -b 7
"X"
$ echo '\''"\u0058"'\''|json -b 8
"X"
$ echo '\''"\u0059"'\''|json -b 1
"Y"
$ echo '\''"\u0059"'\''|json -b 2
"Y"
$ echo '\''"\u0059"'\''|json -b 3
"Y"
$ echo '\''"\u0059"'\''|json -b 4
"Y"
$ echo '\''"\u0059"'\''|json -b 5
"Y"
$ echo '\''"\u0059"'\''|json -b 6
"Y"
$ echo '\''"\u0059"'\''|json -b 7
"Y"
$ echo '\''"\u0059"'\''|json -b 8
"Y"
$ echo '\''"\u005a"'\''|json -b 1
"Z"
$ echo '\''"\u005a"'\''|json -b 2
"Z"
$ echo '\''"\u005a"'\''|json -b 3
"Z"
$ echo '\''"\u005a"'\''|json -b 4
"Z"
$ echo '\''"\u005a"'\''|json -b 5
"Z"
$ echo '\''"\u005a"'\''|json -b 6
"Z"
$ echo '\''"\u005a"'\''|json -b 7
"Z"
$ echo '\''"\u005a"'\''|json -b 8
"Z"
$ echo '\''"\u005b"'\''|json -b 1
"["
$ echo '\''"\u005b"'\''|json -b 2
"["
$ echo '\''"\u005b"'\''|json -b 3
"["
$ echo '\''"\u005b"'\''|json -b 4
"["
$ echo '\''"\u005b"'\''|json -b 5
"["
$ echo '\''"\u005b"'\''|json -b 6
"["
$ echo '\''"\u005b"'\''|json -b 7
"["
$ echo '\''"\u005b"'\''|json -b 8
"["
$ echo '\''"\u005c"'\''|json -b 1
"\\"
$ echo '\''"\u005c"'\''|json -b 2
"\\"
$ echo '\''"\u005c"'\''|json -b 3
"\\"
$ echo '\''"\u005c"'\''|json -b 4
"\\"
$ echo '\''"\u005c"'\''|json -b 5
"\\"
$ echo '\''"\u005c"'\''|json -b 6
"\\"
$ echo '\''"\u005c"'\''|json -b 7
"\\"
$ echo '\''"\u005c"'\''|json -b 8
"\\"
$ echo '\''"\u005d"'\''|json -b 1
"]"
$ echo '\''"\u005d"'\''|json -b 2
"]"
$ echo '\''"\u005d"'\''|json -b 3
"]"
$ echo '\''"\u005d"'\''|json -b 4
"]"
$ echo '\''"\u005d"'\''|json -b 5
"]"
$ echo '\''"\u005d"'\''|json -b 6
"]"
$ echo '\''"\u005d"'\''|json -b 7
"]"
$ echo '\''"\u005d"'\''|json -b 8
"]"
$ echo '\''"\u005e"'\''|json -b 1
"^"
$ echo '\''"\u005e"'\''|json -b 2
"^"
$ echo '\''"\u005e"'\''|json -b 3
"^"
$ echo '\''"\u005e"'\''|json -b 4
"^"
$ echo '\''"\u005e"'\''|json -b 5
"^"
$ echo '\''"\u005e"'\''|json -b 6
"^"
$ echo '\''"\u005e"'\''|json -b 7
"^"
$ echo '\''"\u005e"'\''|json -b 8
"^"
$ echo '\''"\u005f"'\''|json -b 1
"_"
$ echo '\''"\u005f"'\''|json -b 2
"_"
$ echo '\''"\u005f"'\''|json -b 3
"_"
$ echo '\''"\u005f"'\''|json -b 4
"_"
$ echo '\''"\u005f"'\''|json -b 5
"_"
$ echo '\''"\u005f"'\''|json -b 6
"_"
$ echo '\''"\u005f"'\''|json -b 7
"_"
$ echo '\''"\u005f"'\''|json -b 8
"_"'
) -L string-unicode3.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --escape-utf8 "$@"; }'
json() { json0 --literal-value --escape-utf8 "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --escape-utf8 "$@"; }'

echo '$ echo '\''"\u0040"'\''|json -b 1'
echo '"\u0040"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 1'

echo '$ echo '\''"\u0040"'\''|json -b 2'
echo '"\u0040"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 2'

echo '$ echo '\''"\u0040"'\''|json -b 3'
echo '"\u0040"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 3'

echo '$ echo '\''"\u0040"'\''|json -b 4'
echo '"\u0040"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 4'

echo '$ echo '\''"\u0040"'\''|json -b 5'
echo '"\u0040"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 5'

echo '$ echo '\''"\u0040"'\''|json -b 6'
echo '"\u0040"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 6'

echo '$ echo '\''"\u0040"'\''|json -b 7'
echo '"\u0040"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 7'

echo '$ echo '\''"\u0040"'\''|json -b 8'
echo '"\u0040"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0040"'\''|json -b 8'

echo '$ echo '\''"\u0041"'\''|json -b 1'
echo '"\u0041"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 1'

echo '$ echo '\''"\u0041"'\''|json -b 2'
echo '"\u0041"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 2'

echo '$ echo '\''"\u0041"'\''|json -b 3'
echo '"\u0041"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 3'

echo '$ echo '\''"\u0041"'\''|json -b 4'
echo '"\u0041"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 4'

echo '$ echo '\''"\u0041"'\''|json -b 5'
echo '"\u0041"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 5'

echo '$ echo '\''"\u0041"'\''|json -b 6'
echo '"\u0041"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 6'

echo '$ echo '\''"\u0041"'\''|json -b 7'
echo '"\u0041"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 7'

echo '$ echo '\''"\u0041"'\''|json -b 8'
echo '"\u0041"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0041"'\''|json -b 8'

echo '$ echo '\''"\u0042"'\''|json -b 1'
echo '"\u0042"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 1'

echo '$ echo '\''"\u0042"'\''|json -b 2'
echo '"\u0042"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 2'

echo '$ echo '\''"\u0042"'\''|json -b 3'
echo '"\u0042"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 3'

echo '$ echo '\''"\u0042"'\''|json -b 4'
echo '"\u0042"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 4'

echo '$ echo '\''"\u0042"'\''|json -b 5'
echo '"\u0042"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 5'

echo '$ echo '\''"\u0042"'\''|json -b 6'
echo '"\u0042"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 6'

echo '$ echo '\''"\u0042"'\''|json -b 7'
echo '"\u0042"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 7'

echo '$ echo '\''"\u0042"'\''|json -b 8'
echo '"\u0042"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0042"'\''|json -b 8'

echo '$ echo '\''"\u0043"'\''|json -b 1'
echo '"\u0043"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 1'

echo '$ echo '\''"\u0043"'\''|json -b 2'
echo '"\u0043"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 2'

echo '$ echo '\''"\u0043"'\''|json -b 3'
echo '"\u0043"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 3'

echo '$ echo '\''"\u0043"'\''|json -b 4'
echo '"\u0043"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 4'

echo '$ echo '\''"\u0043"'\''|json -b 5'
echo '"\u0043"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 5'

echo '$ echo '\''"\u0043"'\''|json -b 6'
echo '"\u0043"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 6'

echo '$ echo '\''"\u0043"'\''|json -b 7'
echo '"\u0043"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 7'

echo '$ echo '\''"\u0043"'\''|json -b 8'
echo '"\u0043"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0043"'\''|json -b 8'

echo '$ echo '\''"\u0044"'\''|json -b 1'
echo '"\u0044"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 1'

echo '$ echo '\''"\u0044"'\''|json -b 2'
echo '"\u0044"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 2'

echo '$ echo '\''"\u0044"'\''|json -b 3'
echo '"\u0044"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 3'

echo '$ echo '\''"\u0044"'\''|json -b 4'
echo '"\u0044"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 4'

echo '$ echo '\''"\u0044"'\''|json -b 5'
echo '"\u0044"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 5'

echo '$ echo '\''"\u0044"'\''|json -b 6'
echo '"\u0044"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 6'

echo '$ echo '\''"\u0044"'\''|json -b 7'
echo '"\u0044"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 7'

echo '$ echo '\''"\u0044"'\''|json -b 8'
echo '"\u0044"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0044"'\''|json -b 8'

echo '$ echo '\''"\u0045"'\''|json -b 1'
echo '"\u0045"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 1'

echo '$ echo '\''"\u0045"'\''|json -b 2'
echo '"\u0045"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 2'

echo '$ echo '\''"\u0045"'\''|json -b 3'
echo '"\u0045"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 3'

echo '$ echo '\''"\u0045"'\''|json -b 4'
echo '"\u0045"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 4'

echo '$ echo '\''"\u0045"'\''|json -b 5'
echo '"\u0045"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 5'

echo '$ echo '\''"\u0045"'\''|json -b 6'
echo '"\u0045"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 6'

echo '$ echo '\''"\u0045"'\''|json -b 7'
echo '"\u0045"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 7'

echo '$ echo '\''"\u0045"'\''|json -b 8'
echo '"\u0045"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0045"'\''|json -b 8'

echo '$ echo '\''"\u0046"'\''|json -b 1'
echo '"\u0046"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 1'

echo '$ echo '\''"\u0046"'\''|json -b 2'
echo '"\u0046"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 2'

echo '$ echo '\''"\u0046"'\''|json -b 3'
echo '"\u0046"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 3'

echo '$ echo '\''"\u0046"'\''|json -b 4'
echo '"\u0046"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 4'

echo '$ echo '\''"\u0046"'\''|json -b 5'
echo '"\u0046"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 5'

echo '$ echo '\''"\u0046"'\''|json -b 6'
echo '"\u0046"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 6'

echo '$ echo '\''"\u0046"'\''|json -b 7'
echo '"\u0046"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 7'

echo '$ echo '\''"\u0046"'\''|json -b 8'
echo '"\u0046"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0046"'\''|json -b 8'

echo '$ echo '\''"\u0047"'\''|json -b 1'
echo '"\u0047"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 1'

echo '$ echo '\''"\u0047"'\''|json -b 2'
echo '"\u0047"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 2'

echo '$ echo '\''"\u0047"'\''|json -b 3'
echo '"\u0047"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 3'

echo '$ echo '\''"\u0047"'\''|json -b 4'
echo '"\u0047"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 4'

echo '$ echo '\''"\u0047"'\''|json -b 5'
echo '"\u0047"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 5'

echo '$ echo '\''"\u0047"'\''|json -b 6'
echo '"\u0047"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 6'

echo '$ echo '\''"\u0047"'\''|json -b 7'
echo '"\u0047"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 7'

echo '$ echo '\''"\u0047"'\''|json -b 8'
echo '"\u0047"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0047"'\''|json -b 8'

echo '$ echo '\''"\u0048"'\''|json -b 1'
echo '"\u0048"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 1'

echo '$ echo '\''"\u0048"'\''|json -b 2'
echo '"\u0048"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 2'

echo '$ echo '\''"\u0048"'\''|json -b 3'
echo '"\u0048"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 3'

echo '$ echo '\''"\u0048"'\''|json -b 4'
echo '"\u0048"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 4'

echo '$ echo '\''"\u0048"'\''|json -b 5'
echo '"\u0048"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 5'

echo '$ echo '\''"\u0048"'\''|json -b 6'
echo '"\u0048"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 6'

echo '$ echo '\''"\u0048"'\''|json -b 7'
echo '"\u0048"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 7'

echo '$ echo '\''"\u0048"'\''|json -b 8'
echo '"\u0048"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0048"'\''|json -b 8'

echo '$ echo '\''"\u0049"'\''|json -b 1'
echo '"\u0049"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 1'

echo '$ echo '\''"\u0049"'\''|json -b 2'
echo '"\u0049"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 2'

echo '$ echo '\''"\u0049"'\''|json -b 3'
echo '"\u0049"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 3'

echo '$ echo '\''"\u0049"'\''|json -b 4'
echo '"\u0049"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 4'

echo '$ echo '\''"\u0049"'\''|json -b 5'
echo '"\u0049"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 5'

echo '$ echo '\''"\u0049"'\''|json -b 6'
echo '"\u0049"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 6'

echo '$ echo '\''"\u0049"'\''|json -b 7'
echo '"\u0049"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 7'

echo '$ echo '\''"\u0049"'\''|json -b 8'
echo '"\u0049"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0049"'\''|json -b 8'

echo '$ echo '\''"\u004a"'\''|json -b 1'
echo '"\u004a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 1'

echo '$ echo '\''"\u004a"'\''|json -b 2'
echo '"\u004a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 2'

echo '$ echo '\''"\u004a"'\''|json -b 3'
echo '"\u004a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 3'

echo '$ echo '\''"\u004a"'\''|json -b 4'
echo '"\u004a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 4'

echo '$ echo '\''"\u004a"'\''|json -b 5'
echo '"\u004a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 5'

echo '$ echo '\''"\u004a"'\''|json -b 6'
echo '"\u004a"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 6'

echo '$ echo '\''"\u004a"'\''|json -b 7'
echo '"\u004a"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 7'

echo '$ echo '\''"\u004a"'\''|json -b 8'
echo '"\u004a"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u004a"'\''|json -b 8'

echo '$ echo '\''"\u004b"'\''|json -b 1'
echo '"\u004b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 1'

echo '$ echo '\''"\u004b"'\''|json -b 2'
echo '"\u004b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 2'

echo '$ echo '\''"\u004b"'\''|json -b 3'
echo '"\u004b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 3'

echo '$ echo '\''"\u004b"'\''|json -b 4'
echo '"\u004b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 4'

echo '$ echo '\''"\u004b"'\''|json -b 5'
echo '"\u004b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 5'

echo '$ echo '\''"\u004b"'\''|json -b 6'
echo '"\u004b"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 6'

echo '$ echo '\''"\u004b"'\''|json -b 7'
echo '"\u004b"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 7'

echo '$ echo '\''"\u004b"'\''|json -b 8'
echo '"\u004b"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u004b"'\''|json -b 8'

echo '$ echo '\''"\u004c"'\''|json -b 1'
echo '"\u004c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 1'

echo '$ echo '\''"\u004c"'\''|json -b 2'
echo '"\u004c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 2'

echo '$ echo '\''"\u004c"'\''|json -b 3'
echo '"\u004c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 3'

echo '$ echo '\''"\u004c"'\''|json -b 4'
echo '"\u004c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 4'

echo '$ echo '\''"\u004c"'\''|json -b 5'
echo '"\u004c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 5'

echo '$ echo '\''"\u004c"'\''|json -b 6'
echo '"\u004c"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 6'

echo '$ echo '\''"\u004c"'\''|json -b 7'
echo '"\u004c"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 7'

echo '$ echo '\''"\u004c"'\''|json -b 8'
echo '"\u004c"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u004c"'\''|json -b 8'

echo '$ echo '\''"\u004d"'\''|json -b 1'
echo '"\u004d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 1'

echo '$ echo '\''"\u004d"'\''|json -b 2'
echo '"\u004d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 2'

echo '$ echo '\''"\u004d"'\''|json -b 3'
echo '"\u004d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 3'

echo '$ echo '\''"\u004d"'\''|json -b 4'
echo '"\u004d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 4'

echo '$ echo '\''"\u004d"'\''|json -b 5'
echo '"\u004d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 5'

echo '$ echo '\''"\u004d"'\''|json -b 6'
echo '"\u004d"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 6'

echo '$ echo '\''"\u004d"'\''|json -b 7'
echo '"\u004d"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 7'

echo '$ echo '\''"\u004d"'\''|json -b 8'
echo '"\u004d"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u004d"'\''|json -b 8'

echo '$ echo '\''"\u004e"'\''|json -b 1'
echo '"\u004e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 1'

echo '$ echo '\''"\u004e"'\''|json -b 2'
echo '"\u004e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 2'

echo '$ echo '\''"\u004e"'\''|json -b 3'
echo '"\u004e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 3'

echo '$ echo '\''"\u004e"'\''|json -b 4'
echo '"\u004e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 4'

echo '$ echo '\''"\u004e"'\''|json -b 5'
echo '"\u004e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 5'

echo '$ echo '\''"\u004e"'\''|json -b 6'
echo '"\u004e"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 6'

echo '$ echo '\''"\u004e"'\''|json -b 7'
echo '"\u004e"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 7'

echo '$ echo '\''"\u004e"'\''|json -b 8'
echo '"\u004e"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u004e"'\''|json -b 8'

echo '$ echo '\''"\u004f"'\''|json -b 1'
echo '"\u004f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 1'

echo '$ echo '\''"\u004f"'\''|json -b 2'
echo '"\u004f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 2'

echo '$ echo '\''"\u004f"'\''|json -b 3'
echo '"\u004f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 3'

echo '$ echo '\''"\u004f"'\''|json -b 4'
echo '"\u004f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 4'

echo '$ echo '\''"\u004f"'\''|json -b 5'
echo '"\u004f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 5'

echo '$ echo '\''"\u004f"'\''|json -b 6'
echo '"\u004f"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 6'

echo '$ echo '\''"\u004f"'\''|json -b 7'
echo '"\u004f"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 7'

echo '$ echo '\''"\u004f"'\''|json -b 8'
echo '"\u004f"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u004f"'\''|json -b 8'

echo '$ echo '\''"\u0050"'\''|json -b 1'
echo '"\u0050"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 1'

echo '$ echo '\''"\u0050"'\''|json -b 2'
echo '"\u0050"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 2'

echo '$ echo '\''"\u0050"'\''|json -b 3'
echo '"\u0050"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 3'

echo '$ echo '\''"\u0050"'\''|json -b 4'
echo '"\u0050"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 4'

echo '$ echo '\''"\u0050"'\''|json -b 5'
echo '"\u0050"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 5'

echo '$ echo '\''"\u0050"'\''|json -b 6'
echo '"\u0050"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 6'

echo '$ echo '\''"\u0050"'\''|json -b 7'
echo '"\u0050"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 7'

echo '$ echo '\''"\u0050"'\''|json -b 8'
echo '"\u0050"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0050"'\''|json -b 8'

echo '$ echo '\''"\u0051"'\''|json -b 1'
echo '"\u0051"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 1'

echo '$ echo '\''"\u0051"'\''|json -b 2'
echo '"\u0051"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 2'

echo '$ echo '\''"\u0051"'\''|json -b 3'
echo '"\u0051"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 3'

echo '$ echo '\''"\u0051"'\''|json -b 4'
echo '"\u0051"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 4'

echo '$ echo '\''"\u0051"'\''|json -b 5'
echo '"\u0051"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 5'

echo '$ echo '\''"\u0051"'\''|json -b 6'
echo '"\u0051"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 6'

echo '$ echo '\''"\u0051"'\''|json -b 7'
echo '"\u0051"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 7'

echo '$ echo '\''"\u0051"'\''|json -b 8'
echo '"\u0051"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0051"'\''|json -b 8'

echo '$ echo '\''"\u0052"'\''|json -b 1'
echo '"\u0052"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 1'

echo '$ echo '\''"\u0052"'\''|json -b 2'
echo '"\u0052"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 2'

echo '$ echo '\''"\u0052"'\''|json -b 3'
echo '"\u0052"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 3'

echo '$ echo '\''"\u0052"'\''|json -b 4'
echo '"\u0052"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 4'

echo '$ echo '\''"\u0052"'\''|json -b 5'
echo '"\u0052"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 5'

echo '$ echo '\''"\u0052"'\''|json -b 6'
echo '"\u0052"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 6'

echo '$ echo '\''"\u0052"'\''|json -b 7'
echo '"\u0052"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 7'

echo '$ echo '\''"\u0052"'\''|json -b 8'
echo '"\u0052"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0052"'\''|json -b 8'

echo '$ echo '\''"\u0053"'\''|json -b 1'
echo '"\u0053"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 1'

echo '$ echo '\''"\u0053"'\''|json -b 2'
echo '"\u0053"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 2'

echo '$ echo '\''"\u0053"'\''|json -b 3'
echo '"\u0053"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 3'

echo '$ echo '\''"\u0053"'\''|json -b 4'
echo '"\u0053"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 4'

echo '$ echo '\''"\u0053"'\''|json -b 5'
echo '"\u0053"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 5'

echo '$ echo '\''"\u0053"'\''|json -b 6'
echo '"\u0053"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 6'

echo '$ echo '\''"\u0053"'\''|json -b 7'
echo '"\u0053"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 7'

echo '$ echo '\''"\u0053"'\''|json -b 8'
echo '"\u0053"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0053"'\''|json -b 8'

echo '$ echo '\''"\u0054"'\''|json -b 1'
echo '"\u0054"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 1'

echo '$ echo '\''"\u0054"'\''|json -b 2'
echo '"\u0054"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 2'

echo '$ echo '\''"\u0054"'\''|json -b 3'
echo '"\u0054"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 3'

echo '$ echo '\''"\u0054"'\''|json -b 4'
echo '"\u0054"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 4'

echo '$ echo '\''"\u0054"'\''|json -b 5'
echo '"\u0054"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 5'

echo '$ echo '\''"\u0054"'\''|json -b 6'
echo '"\u0054"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 6'

echo '$ echo '\''"\u0054"'\''|json -b 7'
echo '"\u0054"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 7'

echo '$ echo '\''"\u0054"'\''|json -b 8'
echo '"\u0054"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0054"'\''|json -b 8'

echo '$ echo '\''"\u0055"'\''|json -b 1'
echo '"\u0055"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 1'

echo '$ echo '\''"\u0055"'\''|json -b 2'
echo '"\u0055"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 2'

echo '$ echo '\''"\u0055"'\''|json -b 3'
echo '"\u0055"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 3'

echo '$ echo '\''"\u0055"'\''|json -b 4'
echo '"\u0055"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 4'

echo '$ echo '\''"\u0055"'\''|json -b 5'
echo '"\u0055"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 5'

echo '$ echo '\''"\u0055"'\''|json -b 6'
echo '"\u0055"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 6'

echo '$ echo '\''"\u0055"'\''|json -b 7'
echo '"\u0055"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 7'

echo '$ echo '\''"\u0055"'\''|json -b 8'
echo '"\u0055"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0055"'\''|json -b 8'

echo '$ echo '\''"\u0056"'\''|json -b 1'
echo '"\u0056"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 1'

echo '$ echo '\''"\u0056"'\''|json -b 2'
echo '"\u0056"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 2'

echo '$ echo '\''"\u0056"'\''|json -b 3'
echo '"\u0056"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 3'

echo '$ echo '\''"\u0056"'\''|json -b 4'
echo '"\u0056"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 4'

echo '$ echo '\''"\u0056"'\''|json -b 5'
echo '"\u0056"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 5'

echo '$ echo '\''"\u0056"'\''|json -b 6'
echo '"\u0056"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 6'

echo '$ echo '\''"\u0056"'\''|json -b 7'
echo '"\u0056"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 7'

echo '$ echo '\''"\u0056"'\''|json -b 8'
echo '"\u0056"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0056"'\''|json -b 8'

echo '$ echo '\''"\u0057"'\''|json -b 1'
echo '"\u0057"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 1'

echo '$ echo '\''"\u0057"'\''|json -b 2'
echo '"\u0057"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 2'

echo '$ echo '\''"\u0057"'\''|json -b 3'
echo '"\u0057"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 3'

echo '$ echo '\''"\u0057"'\''|json -b 4'
echo '"\u0057"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 4'

echo '$ echo '\''"\u0057"'\''|json -b 5'
echo '"\u0057"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 5'

echo '$ echo '\''"\u0057"'\''|json -b 6'
echo '"\u0057"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 6'

echo '$ echo '\''"\u0057"'\''|json -b 7'
echo '"\u0057"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 7'

echo '$ echo '\''"\u0057"'\''|json -b 8'
echo '"\u0057"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0057"'\''|json -b 8'

echo '$ echo '\''"\u0058"'\''|json -b 1'
echo '"\u0058"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 1'

echo '$ echo '\''"\u0058"'\''|json -b 2'
echo '"\u0058"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 2'

echo '$ echo '\''"\u0058"'\''|json -b 3'
echo '"\u0058"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 3'

echo '$ echo '\''"\u0058"'\''|json -b 4'
echo '"\u0058"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 4'

echo '$ echo '\''"\u0058"'\''|json -b 5'
echo '"\u0058"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 5'

echo '$ echo '\''"\u0058"'\''|json -b 6'
echo '"\u0058"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 6'

echo '$ echo '\''"\u0058"'\''|json -b 7'
echo '"\u0058"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 7'

echo '$ echo '\''"\u0058"'\''|json -b 8'
echo '"\u0058"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0058"'\''|json -b 8'

echo '$ echo '\''"\u0059"'\''|json -b 1'
echo '"\u0059"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 1'

echo '$ echo '\''"\u0059"'\''|json -b 2'
echo '"\u0059"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 2'

echo '$ echo '\''"\u0059"'\''|json -b 3'
echo '"\u0059"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 3'

echo '$ echo '\''"\u0059"'\''|json -b 4'
echo '"\u0059"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 4'

echo '$ echo '\''"\u0059"'\''|json -b 5'
echo '"\u0059"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 5'

echo '$ echo '\''"\u0059"'\''|json -b 6'
echo '"\u0059"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 6'

echo '$ echo '\''"\u0059"'\''|json -b 7'
echo '"\u0059"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 7'

echo '$ echo '\''"\u0059"'\''|json -b 8'
echo '"\u0059"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0059"'\''|json -b 8'

echo '$ echo '\''"\u005a"'\''|json -b 1'
echo '"\u005a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 1'

echo '$ echo '\''"\u005a"'\''|json -b 2'
echo '"\u005a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 2'

echo '$ echo '\''"\u005a"'\''|json -b 3'
echo '"\u005a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 3'

echo '$ echo '\''"\u005a"'\''|json -b 4'
echo '"\u005a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 4'

echo '$ echo '\''"\u005a"'\''|json -b 5'
echo '"\u005a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 5'

echo '$ echo '\''"\u005a"'\''|json -b 6'
echo '"\u005a"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 6'

echo '$ echo '\''"\u005a"'\''|json -b 7'
echo '"\u005a"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 7'

echo '$ echo '\''"\u005a"'\''|json -b 8'
echo '"\u005a"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u005a"'\''|json -b 8'

echo '$ echo '\''"\u005b"'\''|json -b 1'
echo '"\u005b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 1'

echo '$ echo '\''"\u005b"'\''|json -b 2'
echo '"\u005b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 2'

echo '$ echo '\''"\u005b"'\''|json -b 3'
echo '"\u005b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 3'

echo '$ echo '\''"\u005b"'\''|json -b 4'
echo '"\u005b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 4'

echo '$ echo '\''"\u005b"'\''|json -b 5'
echo '"\u005b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 5'

echo '$ echo '\''"\u005b"'\''|json -b 6'
echo '"\u005b"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 6'

echo '$ echo '\''"\u005b"'\''|json -b 7'
echo '"\u005b"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 7'

echo '$ echo '\''"\u005b"'\''|json -b 8'
echo '"\u005b"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u005b"'\''|json -b 8'

echo '$ echo '\''"\u005c"'\''|json -b 1'
echo '"\u005c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 1'

echo '$ echo '\''"\u005c"'\''|json -b 2'
echo '"\u005c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 2'

echo '$ echo '\''"\u005c"'\''|json -b 3'
echo '"\u005c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 3'

echo '$ echo '\''"\u005c"'\''|json -b 4'
echo '"\u005c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 4'

echo '$ echo '\''"\u005c"'\''|json -b 5'
echo '"\u005c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 5'

echo '$ echo '\''"\u005c"'\''|json -b 6'
echo '"\u005c"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 6'

echo '$ echo '\''"\u005c"'\''|json -b 7'
echo '"\u005c"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 7'

echo '$ echo '\''"\u005c"'\''|json -b 8'
echo '"\u005c"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u005c"'\''|json -b 8'

echo '$ echo '\''"\u005d"'\''|json -b 1'
echo '"\u005d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 1'

echo '$ echo '\''"\u005d"'\''|json -b 2'
echo '"\u005d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 2'

echo '$ echo '\''"\u005d"'\''|json -b 3'
echo '"\u005d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 3'

echo '$ echo '\''"\u005d"'\''|json -b 4'
echo '"\u005d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 4'

echo '$ echo '\''"\u005d"'\''|json -b 5'
echo '"\u005d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 5'

echo '$ echo '\''"\u005d"'\''|json -b 6'
echo '"\u005d"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 6'

echo '$ echo '\''"\u005d"'\''|json -b 7'
echo '"\u005d"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 7'

echo '$ echo '\''"\u005d"'\''|json -b 8'
echo '"\u005d"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u005d"'\''|json -b 8'

echo '$ echo '\''"\u005e"'\''|json -b 1'
echo '"\u005e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 1'

echo '$ echo '\''"\u005e"'\''|json -b 2'
echo '"\u005e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 2'

echo '$ echo '\''"\u005e"'\''|json -b 3'
echo '"\u005e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 3'

echo '$ echo '\''"\u005e"'\''|json -b 4'
echo '"\u005e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 4'

echo '$ echo '\''"\u005e"'\''|json -b 5'
echo '"\u005e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 5'

echo '$ echo '\''"\u005e"'\''|json -b 6'
echo '"\u005e"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 6'

echo '$ echo '\''"\u005e"'\''|json -b 7'
echo '"\u005e"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 7'

echo '$ echo '\''"\u005e"'\''|json -b 8'
echo '"\u005e"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u005e"'\''|json -b 8'

echo '$ echo '\''"\u005f"'\''|json -b 1'
echo '"\u005f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 1'

echo '$ echo '\''"\u005f"'\''|json -b 2'
echo '"\u005f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 2'

echo '$ echo '\''"\u005f"'\''|json -b 3'
echo '"\u005f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 3'

echo '$ echo '\''"\u005f"'\''|json -b 4'
echo '"\u005f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 4'

echo '$ echo '\''"\u005f"'\''|json -b 5'
echo '"\u005f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 5'

echo '$ echo '\''"\u005f"'\''|json -b 6'
echo '"\u005f"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 6'

echo '$ echo '\''"\u005f"'\''|json -b 7'
echo '"\u005f"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 7'

echo '$ echo '\''"\u005f"'\''|json -b 8'
echo '"\u005f"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u005f"'\''|json -b 8'
)

