#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number6
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number6.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --multi-obj -b 1 "$@"; }
$ echo 0-00|json
0
-0
0
$ echo 0-01|json
0
-0
1
$ echo 0-02|json
0
-0
2
$ echo 0-03|json
0
-0
3
$ echo 0-04|json
0
-0
4
$ echo 0-05|json
0
-0
5
$ echo 0-06|json
0
-0
6
$ echo 0-07|json
0
-0
7
$ echo 0-08|json
0
-0
8
$ echo 0-09|json
0
-0
9'
) -L number6.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --multi-obj -b 1 "$@"; }'
json() { json0 --literal-value --multi-obj -b 1 "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --multi-obj -b 1 "$@"; }'

echo '$ echo 0-00|json'
echo 0-00|json 2>&1 ||
echo 'command failed: echo 0-00|json'

echo '$ echo 0-01|json'
echo 0-01|json 2>&1 ||
echo 'command failed: echo 0-01|json'

echo '$ echo 0-02|json'
echo 0-02|json 2>&1 ||
echo 'command failed: echo 0-02|json'

echo '$ echo 0-03|json'
echo 0-03|json 2>&1 ||
echo 'command failed: echo 0-03|json'

echo '$ echo 0-04|json'
echo 0-04|json 2>&1 ||
echo 'command failed: echo 0-04|json'

echo '$ echo 0-05|json'
echo 0-05|json 2>&1 ||
echo 'command failed: echo 0-05|json'

echo '$ echo 0-06|json'
echo 0-06|json 2>&1 ||
echo 'command failed: echo 0-06|json'

echo '$ echo 0-07|json'
echo 0-07|json 2>&1 ||
echo 'command failed: echo 0-07|json'

echo '$ echo 0-08|json'
echo 0-08|json 2>&1 ||
echo 'command failed: echo 0-08|json'

echo '$ echo 0-09|json'
echo 0-09|json 2>&1 ||
echo 'command failed: echo 0-09|json'
)

