#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:empty-key
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L empty-key.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''{"":"`x`"}'\''
json: error: <text>:1:2: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:2: {"":"`x`"}
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''{"":"`x`"}'\''
$ json-litex -d '\''{"foo":{"":"`x`"}}'\''
json: error: <text>:1:9: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:9: {"foo":{"":"`x`"}}
json: error: <text>:1:9:         ^
command failed: json-litex -d '\''{"foo":{"":"`x`"}}'\''
$ json-litex -d '\''[{"":"`x`"}]'\''
json: error: <text>:1:3: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:3: [{"":"`x`"}]
json: error: <text>:1:3:   ^
command failed: json-litex -d '\''[{"":"`x`"}]'\''
$ json-litex -d '\''{"bar":{"foo":{"":"`x`"}}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:16: {"bar":{"foo":{"":"`x`"}}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"bar":{"foo":{"":"`x`"}}}'\''
$ json-litex -d '\''{"bar":[{"":"`x`"}]}'\''
json: error: <text>:1:10: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:10: {"bar":[{"":"`x`"}]}
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''{"bar":[{"":"`x`"}]}'\''
$ json-litex -d '\''[{"foo":{"":"`x`"}}]'\''
json: error: <text>:1:10: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:10: [{"foo":{"":"`x`"}}]
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''[{"foo":{"":"`x`"}}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`"}}}}'\''
json: error: <text>:1:23: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:23: {"baz":{"bar":{"foo":{"":"`x`"}}}}
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`"}}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"":"`x`"}]}}'\''
json: error: <text>:1:17: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:17: {"baz":{"bar":[{"":"`x`"}]}}
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''{"baz":{"bar":[{"":"`x`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":{"":"`x`"}}]}'\''
json: error: <text>:1:17: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:17: {"baz":[{"foo":{"":"`x`"}}]}
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''{"baz":[{"foo":{"":"`x`"}}]}'\''
$ json-litex -d '\''[{"bar":{"foo":{"":"`x`"}}}]'\''
json: error: <text>:1:17: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:17: [{"bar":{"foo":{"":"`x`"}}}]
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''[{"bar":{"foo":{"":"`x`"}}}]'\''
$ json-litex -d '\''[{"bar":[{"":"`x`"}]}]'\''
json: error: <text>:1:11: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:11: [{"bar":[{"":"`x`"}]}]
json: error: <text>:1:11:           ^
command failed: json-litex -d '\''[{"bar":[{"":"`x`"}]}]'\''
$ json-litex -d '\''{"a":"`y`","":"`x`"}'\''
json: error: <text>:1:12: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:12: {"a":"`y`","":"`x`"}
json: error: <text>:1:12:            ^
command failed: json-litex -d '\''{"a":"`y`","":"`x`"}'\''
$ json-litex -d '\''{"foo":{"a":"`y`","":"`x`"}}'\''
json: error: <text>:1:19: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:19: {"foo":{"a":"`y`","":"`x`"}}
json: error: <text>:1:19:                   ^
command failed: json-litex -d '\''{"foo":{"a":"`y`","":"`x`"}}'\''
$ json-litex -d '\''[{"a":"`y`","":"`x`"}]'\''
json: error: <text>:1:13: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:13: [{"a":"`y`","":"`x`"}]
json: error: <text>:1:13:             ^
command failed: json-litex -d '\''[{"a":"`y`","":"`x`"}]'\''
$ json-litex -d '\''{"bar":{"foo":{"a":"`y`","":"`x`"}}}'\''
json: error: <text>:1:26: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:26: {"bar":{"foo":{"a":"`y`","":"`x`"}}}
json: error: <text>:1:26:                          ^
command failed: json-litex -d '\''{"bar":{"foo":{"a":"`y`","":"`x`"}}}'\''
$ json-litex -d '\''{"bar":[{"a":"`y`","":"`x`"}]}'\''
json: error: <text>:1:20: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:20: {"bar":[{"a":"`y`","":"`x`"}]}
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''{"bar":[{"a":"`y`","":"`x`"}]}'\''
$ json-litex -d '\''[{"foo":{"a":"`y`","":"`x`"}}]'\''
json: error: <text>:1:20: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:20: [{"foo":{"a":"`y`","":"`x`"}}]
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''[{"foo":{"a":"`y`","":"`x`"}}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`y`","":"`x`"}}}}'\''
json: error: <text>:1:33: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:33: {"baz":{"bar":{"foo":{"a":"`y`","":"`x`"}}}}
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`y`","":"`x`"}}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"a":"`y`","":"`x`"}]}}'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:27: {"baz":{"bar":[{"a":"`y`","":"`x`"}]}}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`y`","":"`x`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":{"a":"`y`","":"`x`"}}]}'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:27: {"baz":[{"foo":{"a":"`y`","":"`x`"}}]}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`y`","":"`x`"}}]}'\''
$ json-litex -d '\''[{"bar":{"foo":{"a":"`y`","":"`x`"}}}]'\''
json: error: <text>:1:27: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:27: [{"bar":{"foo":{"a":"`y`","":"`x`"}}}]
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`y`","":"`x`"}}}]'\''
$ json-litex -d '\''[{"bar":[{"a":"`y`","":"`x`"}]}]'\''
json: error: <text>:1:21: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:21: [{"bar":[{"a":"`y`","":"`x`"}]}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''[{"bar":[{"a":"`y`","":"`x`"}]}]'\''
$ json-litex -d '\''{"":"`x`","a":"`y`"}'\''
json: error: <text>:1:2: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:2: {"":"`x`","a":"`y`"}
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''{"":"`x`","a":"`y`"}'\''
$ json-litex -d '\''{"foo":{"":"`x`","a":"`y`"}}'\''
json: error: <text>:1:9: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:9: {"foo":{"":"`x`","a":"`y`"}}
json: error: <text>:1:9:         ^
command failed: json-litex -d '\''{"foo":{"":"`x`","a":"`y`"}}'\''
$ json-litex -d '\''[{"":"`x`","a":"`y`"}]'\''
json: error: <text>:1:3: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:3: [{"":"`x`","a":"`y`"}]
json: error: <text>:1:3:   ^
command failed: json-litex -d '\''[{"":"`x`","a":"`y`"}]'\''
$ json-litex -d '\''{"bar":{"foo":{"":"`x`","a":"`y`"}}}'\''
json: error: <text>:1:16: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:16: {"bar":{"foo":{"":"`x`","a":"`y`"}}}
json: error: <text>:1:16:                ^
command failed: json-litex -d '\''{"bar":{"foo":{"":"`x`","a":"`y`"}}}'\''
$ json-litex -d '\''{"bar":[{"":"`x`","a":"`y`"}]}'\''
json: error: <text>:1:10: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:10: {"bar":[{"":"`x`","a":"`y`"}]}
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''{"bar":[{"":"`x`","a":"`y`"}]}'\''
$ json-litex -d '\''[{"foo":{"":"`x`","a":"`y`"}}]'\''
json: error: <text>:1:10: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:10: [{"foo":{"":"`x`","a":"`y`"}}]
json: error: <text>:1:10:          ^
command failed: json-litex -d '\''[{"foo":{"":"`x`","a":"`y`"}}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`","a":"`y`"}}}}'\''
json: error: <text>:1:23: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:23: {"baz":{"bar":{"foo":{"":"`x`","a":"`y`"}}}}
json: error: <text>:1:23:                       ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`","a":"`y`"}}}}'\''
$ json-litex -d '\''{"baz":{"bar":[{"":"`x`","a":"`y`"}]}}'\''
json: error: <text>:1:17: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:17: {"baz":{"bar":[{"":"`x`","a":"`y`"}]}}
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''{"baz":{"bar":[{"":"`x`","a":"`y`"}]}}'\''
$ json-litex -d '\''{"baz":[{"foo":{"":"`x`","a":"`y`"}}]}'\''
json: error: <text>:1:17: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:17: {"baz":[{"foo":{"":"`x`","a":"`y`"}}]}
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''{"baz":[{"foo":{"":"`x`","a":"`y`"}}]}'\''
$ json-litex -d '\''[{"bar":{"foo":{"":"`x`","a":"`y`"}}}]'\''
json: error: <text>:1:17: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:17: [{"bar":{"foo":{"":"`x`","a":"`y`"}}}]
json: error: <text>:1:17:                 ^
command failed: json-litex -d '\''[{"bar":{"foo":{"":"`x`","a":"`y`"}}}]'\''
$ json-litex -d '\''[{"bar":[{"":"`x`","a":"`y`"}]}]'\''
json: error: <text>:1:11: filter library: attribute error: invalid object: key is empty
json: error: <text>:1:11: [{"bar":[{"":"`x`","a":"`y`"}]}]
json: error: <text>:1:11:           ^
command failed: json-litex -d '\''[{"bar":[{"":"`x`","a":"`y`"}]}]'\'''
) -L empty-key.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''{"":"`x`"}'\'''
json-litex -d '{"":"`x`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"":"`x`"}'\'''

echo '$ json-litex -d '\''{"foo":{"":"`x`"}}'\'''
json-litex -d '{"foo":{"":"`x`"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":{"":"`x`"}}'\'''

echo '$ json-litex -d '\''[{"":"`x`"}]'\'''
json-litex -d '[{"":"`x`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"":"`x`"}]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":{"":"`x`"}}}'\'''
json-litex -d '{"bar":{"foo":{"":"`x`"}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":{"":"`x`"}}}'\'''

echo '$ json-litex -d '\''{"bar":[{"":"`x`"}]}'\'''
json-litex -d '{"bar":[{"":"`x`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[{"":"`x`"}]}'\'''

echo '$ json-litex -d '\''[{"foo":{"":"`x`"}}]'\'''
json-litex -d '[{"foo":{"":"`x`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":{"":"`x`"}}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`"}}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":{"":"`x`"}}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`"}}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"":"`x`"}]}}'\'''
json-litex -d '{"baz":{"bar":[{"":"`x`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"":"`x`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":{"":"`x`"}}]}'\'''
json-litex -d '{"baz":[{"foo":{"":"`x`"}}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":{"":"`x`"}}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":{"":"`x`"}}}]'\'''
json-litex -d '[{"bar":{"foo":{"":"`x`"}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":{"":"`x`"}}}]'\'''

echo '$ json-litex -d '\''[{"bar":[{"":"`x`"}]}]'\'''
json-litex -d '[{"bar":[{"":"`x`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[{"":"`x`"}]}]'\'''

echo '$ json-litex -d '\''{"a":"`y`","":"`x`"}'\'''
json-litex -d '{"a":"`y`","":"`x`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"a":"`y`","":"`x`"}'\'''

echo '$ json-litex -d '\''{"foo":{"a":"`y`","":"`x`"}}'\'''
json-litex -d '{"foo":{"a":"`y`","":"`x`"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":{"a":"`y`","":"`x`"}}'\'''

echo '$ json-litex -d '\''[{"a":"`y`","":"`x`"}]'\'''
json-litex -d '[{"a":"`y`","":"`x`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"a":"`y`","":"`x`"}]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":{"a":"`y`","":"`x`"}}}'\'''
json-litex -d '{"bar":{"foo":{"a":"`y`","":"`x`"}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":{"a":"`y`","":"`x`"}}}'\'''

echo '$ json-litex -d '\''{"bar":[{"a":"`y`","":"`x`"}]}'\'''
json-litex -d '{"bar":[{"a":"`y`","":"`x`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[{"a":"`y`","":"`x`"}]}'\'''

echo '$ json-litex -d '\''[{"foo":{"a":"`y`","":"`x`"}}]'\'''
json-litex -d '[{"foo":{"a":"`y`","":"`x`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":{"a":"`y`","":"`x`"}}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`y`","":"`x`"}}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":{"a":"`y`","":"`x`"}}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"a":"`y`","":"`x`"}}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"a":"`y`","":"`x`"}]}}'\'''
json-litex -d '{"baz":{"bar":[{"a":"`y`","":"`x`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"a":"`y`","":"`x`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":{"a":"`y`","":"`x`"}}]}'\'''
json-litex -d '{"baz":[{"foo":{"a":"`y`","":"`x`"}}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":{"a":"`y`","":"`x`"}}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":{"a":"`y`","":"`x`"}}}]'\'''
json-litex -d '[{"bar":{"foo":{"a":"`y`","":"`x`"}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":{"a":"`y`","":"`x`"}}}]'\'''

echo '$ json-litex -d '\''[{"bar":[{"a":"`y`","":"`x`"}]}]'\'''
json-litex -d '[{"bar":[{"a":"`y`","":"`x`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[{"a":"`y`","":"`x`"}]}]'\'''

echo '$ json-litex -d '\''{"":"`x`","a":"`y`"}'\'''
json-litex -d '{"":"`x`","a":"`y`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"":"`x`","a":"`y`"}'\'''

echo '$ json-litex -d '\''{"foo":{"":"`x`","a":"`y`"}}'\'''
json-litex -d '{"foo":{"":"`x`","a":"`y`"}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":{"":"`x`","a":"`y`"}}'\'''

echo '$ json-litex -d '\''[{"":"`x`","a":"`y`"}]'\'''
json-litex -d '[{"":"`x`","a":"`y`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"":"`x`","a":"`y`"}]'\'''

echo '$ json-litex -d '\''{"bar":{"foo":{"":"`x`","a":"`y`"}}}'\'''
json-litex -d '{"bar":{"foo":{"":"`x`","a":"`y`"}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":{"":"`x`","a":"`y`"}}}'\'''

echo '$ json-litex -d '\''{"bar":[{"":"`x`","a":"`y`"}]}'\'''
json-litex -d '{"bar":[{"":"`x`","a":"`y`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":[{"":"`x`","a":"`y`"}]}'\'''

echo '$ json-litex -d '\''[{"foo":{"":"`x`","a":"`y`"}}]'\'''
json-litex -d '[{"foo":{"":"`x`","a":"`y`"}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":{"":"`x`","a":"`y`"}}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`","a":"`y`"}}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":{"":"`x`","a":"`y`"}}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":{"":"`x`","a":"`y`"}}}}'\'''

echo '$ json-litex -d '\''{"baz":{"bar":[{"":"`x`","a":"`y`"}]}}'\'''
json-litex -d '{"baz":{"bar":[{"":"`x`","a":"`y`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":[{"":"`x`","a":"`y`"}]}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":{"":"`x`","a":"`y`"}}]}'\'''
json-litex -d '{"baz":[{"foo":{"":"`x`","a":"`y`"}}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":{"":"`x`","a":"`y`"}}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":{"":"`x`","a":"`y`"}}}]'\'''
json-litex -d '[{"bar":{"foo":{"":"`x`","a":"`y`"}}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":{"":"`x`","a":"`y`"}}}]'\'''

echo '$ json-litex -d '\''[{"bar":[{"":"`x`","a":"`y`"}]}]'\'''
json-litex -d '[{"bar":[{"":"`x`","a":"`y`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":[{"":"`x`","a":"`y`"}]}]'\'''
)

