#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:utf8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L utf8.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }
$ echo -ne '\''\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc0'\''|json -b 1
$ echo -ne '\''\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc0'\''|json -b 2
$ echo -ne '\''\xc1'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc1
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc1'\''|json -b 1
$ echo -ne '\''\xc1'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc1
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc1'\''|json -b 2
$ echo -ne '\''\xc2'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2'\''|json -b 1
$ echo -ne '\''\xc2'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2'\''|json -b 2
$ echo -ne '\''\xdf'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf'\''|json -b 1
$ echo -ne '\''\xdf'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf'\''|json -b 2
$ echo -ne '\''\xc2\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2\x7f'\''|json -b 1
$ echo -ne '\''\xc2\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2\x7f'\''|json -b 2
$ echo -ne '\''\xc2\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2\x7f'\''|json -b 3
$ echo -ne '\''\xdf\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf\x7f'\''|json -b 1
$ echo -ne '\''\xdf\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf\x7f'\''|json -b 2
$ echo -ne '\''\xdf\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf\x7f'\''|json -b 3
$ echo -ne '\''\xc2\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2\xc0'\''|json -b 1
$ echo -ne '\''\xc2\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2\xc0'\''|json -b 2
$ echo -ne '\''\xc2\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xc2\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xc2\xc0'\''|json -b 3
$ echo -ne '\''\xdf\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf\xc0'\''|json -b 1
$ echo -ne '\''\xdf\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf\xc0'\''|json -b 2
$ echo -ne '\''\xdf\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xdf\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xdf\xc0'\''|json -b 3
$ echo -ne '\''\xe0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe0'\''|json -b 1
$ echo -ne '\''\xe0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe0'\''|json -b 2
$ echo -ne '\''\xe0\x9f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\x9f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\x9f'\''|json -b 1
$ echo -ne '\''\xe0\x9f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\x9f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\x9f'\''|json -b 2
$ echo -ne '\''\xe0\x9f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\x9f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\x9f'\''|json -b 3
$ echo -ne '\''\xe0\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe0\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe0\xc0'\''|json -b 1
$ echo -ne '\''\xe0\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe0\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe0\xc0'\''|json -b 2
$ echo -ne '\''\xe0\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe0\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe0\xc0'\''|json -b 3
$ echo -ne '\''\xe0\xa0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0'\''|json -b 1
$ echo -ne '\''\xe0\xa0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0'\''|json -b 2
$ echo -ne '\''\xe0\xa0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0'\''|json -b 3
$ echo -ne '\''\xe0\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf'\''|json -b 1
$ echo -ne '\''\xe0\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf'\''|json -b 2
$ echo -ne '\''\xe0\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf'\''|json -b 3
$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 1
$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 2
$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 3
$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 4
$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 1
$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 2
$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 3
$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 4
$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 1
$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 2
$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 3
$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xa0\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 4
$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xe1'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1'\''|json -b 1
$ echo -ne '\''\xe1'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1'\''|json -b 2
$ echo -ne '\''\xe1\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1\x7f'\''|json -b 1
$ echo -ne '\''\xe1\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1\x7f'\''|json -b 2
$ echo -ne '\''\xe1\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1\x7f'\''|json -b 3
$ echo -ne '\''\xe1\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1\xc0'\''|json -b 1
$ echo -ne '\''\xe1\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1\xc0'\''|json -b 2
$ echo -ne '\''\xe1\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe1\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe1\xc0'\''|json -b 3
$ echo -ne '\''\xe1\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80'\''|json -b 1
$ echo -ne '\''\xe1\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80'\''|json -b 2
$ echo -ne '\''\xe1\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80'\''|json -b 3
$ echo -ne '\''\xe1\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf'\''|json -b 1
$ echo -ne '\''\xe1\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf'\''|json -b 2
$ echo -ne '\''\xe1\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf'\''|json -b 3
$ echo -ne '\''\xe1\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 1
$ echo -ne '\''\xe1\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 2
$ echo -ne '\''\xe1\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 3
$ echo -ne '\''\xe1\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 4
$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 1
$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 2
$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 3
$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 4
$ echo -ne '\''\xe1\x80\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 1
$ echo -ne '\''\xe1\x80\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 2
$ echo -ne '\''\xe1\x80\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 3
$ echo -ne '\''\xe1\x80\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 4
$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xe1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xec'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec'\''|json -b 1
$ echo -ne '\''\xec'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec'\''|json -b 2
$ echo -ne '\''\xec\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec\x7f'\''|json -b 1
$ echo -ne '\''\xec\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec\x7f'\''|json -b 2
$ echo -ne '\''\xec\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec\x7f'\''|json -b 3
$ echo -ne '\''\xec\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec\xc0'\''|json -b 1
$ echo -ne '\''\xec\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec\xc0'\''|json -b 2
$ echo -ne '\''\xec\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xec\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xec\xc0'\''|json -b 3
$ echo -ne '\''\xec\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80'\''|json -b 1
$ echo -ne '\''\xec\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80'\''|json -b 2
$ echo -ne '\''\xec\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80'\''|json -b 3
$ echo -ne '\''\xec\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf'\''|json -b 1
$ echo -ne '\''\xec\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf'\''|json -b 2
$ echo -ne '\''\xec\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf'\''|json -b 3
$ echo -ne '\''\xec\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 1
$ echo -ne '\''\xec\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 2
$ echo -ne '\''\xec\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 3
$ echo -ne '\''\xec\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 4
$ echo -ne '\''\xec\xbf\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 1
$ echo -ne '\''\xec\xbf\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 2
$ echo -ne '\''\xec\xbf\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 3
$ echo -ne '\''\xec\xbf\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 4
$ echo -ne '\''\xec\x80\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 1
$ echo -ne '\''\xec\x80\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 2
$ echo -ne '\''\xec\x80\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 3
$ echo -ne '\''\xec\x80\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 4
$ echo -ne '\''\xec\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xec\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xec\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xec\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xec\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xed'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xed
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xed'\''|json -b 1
$ echo -ne '\''\xed'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xed
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xed'\''|json -b 2
$ echo -ne '\''\xed\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xed\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xed\x7f'\''|json -b 1
$ echo -ne '\''\xed\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xed\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xed\x7f'\''|json -b 2
$ echo -ne '\''\xed\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xed\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xed\x7f'\''|json -b 3
$ echo -ne '\''\xed\xa0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\xa0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\xa0'\''|json -b 1
$ echo -ne '\''\xed\xa0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\xa0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\xa0'\''|json -b 2
$ echo -ne '\''\xed\xa0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\xa0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\xa0'\''|json -b 3
$ echo -ne '\''\xed\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80'\''|json -b 1
$ echo -ne '\''\xed\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80'\''|json -b 2
$ echo -ne '\''\xed\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80'\''|json -b 3
$ echo -ne '\''\xed\x9f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f'\''|json -b 1
$ echo -ne '\''\xed\x9f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f'\''|json -b 2
$ echo -ne '\''\xed\x9f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f'\''|json -b 3
$ echo -ne '\''\xed\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 1
$ echo -ne '\''\xed\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 2
$ echo -ne '\''\xed\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 3
$ echo -ne '\''\xed\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 4
$ echo -ne '\''\xed\x9f\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 1
$ echo -ne '\''\xed\x9f\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 2
$ echo -ne '\''\xed\x9f\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 3
$ echo -ne '\''\xed\x9f\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 4
$ echo -ne '\''\xed\x80\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 1
$ echo -ne '\''\xed\x80\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 2
$ echo -ne '\''\xed\x80\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 3
$ echo -ne '\''\xed\x80\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 4
$ echo -ne '\''\xed\x9f\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 1
$ echo -ne '\''\xed\x9f\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 2
$ echo -ne '\''\xed\x9f\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 3
$ echo -ne '\''\xed\x9f\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xed\x9f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 4
$ echo -ne '\''\xee'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee'\''|json -b 1
$ echo -ne '\''\xee'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee'\''|json -b 2
$ echo -ne '\''\xee\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee\x7f'\''|json -b 1
$ echo -ne '\''\xee\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee\x7f'\''|json -b 2
$ echo -ne '\''\xee\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee\x7f'\''|json -b 3
$ echo -ne '\''\xee\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee\xc0'\''|json -b 1
$ echo -ne '\''\xee\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee\xc0'\''|json -b 2
$ echo -ne '\''\xee\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xee\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xee\xc0'\''|json -b 3
$ echo -ne '\''\xee\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80'\''|json -b 1
$ echo -ne '\''\xee\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80'\''|json -b 2
$ echo -ne '\''\xee\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80'\''|json -b 3
$ echo -ne '\''\xee\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf'\''|json -b 1
$ echo -ne '\''\xee\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf'\''|json -b 2
$ echo -ne '\''\xee\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf'\''|json -b 3
$ echo -ne '\''\xee\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 1
$ echo -ne '\''\xee\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 2
$ echo -ne '\''\xee\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 3
$ echo -ne '\''\xee\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 4
$ echo -ne '\''\xee\xbf\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 1
$ echo -ne '\''\xee\xbf\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 2
$ echo -ne '\''\xee\xbf\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 3
$ echo -ne '\''\xee\xbf\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 4
$ echo -ne '\''\xee\x80\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 1
$ echo -ne '\''\xee\x80\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 2
$ echo -ne '\''\xee\x80\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 3
$ echo -ne '\''\xee\x80\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 4
$ echo -ne '\''\xee\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xee\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xee\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xee\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xee\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xef'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef'\''|json -b 1
$ echo -ne '\''\xef'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef'\''|json -b 2
$ echo -ne '\''\xef\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef\x7f'\''|json -b 1
$ echo -ne '\''\xef\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef\x7f'\''|json -b 2
$ echo -ne '\''\xef\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef\x7f'\''|json -b 3
$ echo -ne '\''\xef\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef\xc0'\''|json -b 1
$ echo -ne '\''\xef\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef\xc0'\''|json -b 2
$ echo -ne '\''\xef\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xef\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xef\xc0'\''|json -b 3
$ echo -ne '\''\xef\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80'\''|json -b 1
$ echo -ne '\''\xef\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80'\''|json -b 2
$ echo -ne '\''\xef\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80'\''|json -b 3
$ echo -ne '\''\xef\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf'\''|json -b 1
$ echo -ne '\''\xef\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf'\''|json -b 2
$ echo -ne '\''\xef\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf'\''|json -b 3
$ echo -ne '\''\xef\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 1
$ echo -ne '\''\xef\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 2
$ echo -ne '\''\xef\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 3
$ echo -ne '\''\xef\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 4
$ echo -ne '\''\xef\xbf\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 1
$ echo -ne '\''\xef\xbf\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 2
$ echo -ne '\''\xef\xbf\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 3
$ echo -ne '\''\xef\xbf\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 4
$ echo -ne '\''\xef\x80\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 1
$ echo -ne '\''\xef\x80\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 2
$ echo -ne '\''\xef\x80\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 3
$ echo -ne '\''\xef\x80\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\x80\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 4
$ echo -ne '\''\xef\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xef\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xef\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xef\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xef\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf0'\''|json -b 1
$ echo -ne '\''\xf0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf0'\''|json -b 2
$ echo -ne '\''\xf0\x8f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x8f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x8f'\''|json -b 1
$ echo -ne '\''\xf0\x8f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x8f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x8f'\''|json -b 2
$ echo -ne '\''\xf0\x8f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x8f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x8f'\''|json -b 3
$ echo -ne '\''\xf0\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf0\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf0\xc0'\''|json -b 1
$ echo -ne '\''\xf0\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf0\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf0\xc0'\''|json -b 2
$ echo -ne '\''\xf0\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf0\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf0\xc0'\''|json -b 3
$ echo -ne '\''\xf0\x90'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x90
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x90'\''|json -b 1
$ echo -ne '\''\xf0\x90'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x90
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x90'\''|json -b 2
$ echo -ne '\''\xf0\x90'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x90
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x90'\''|json -b 3
$ echo -ne '\''\xf0\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\xbf'\''|json -b 1
$ echo -ne '\''\xf0\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\xbf'\''|json -b 2
$ echo -ne '\''\xf0\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\xbf'\''|json -b 3
$ echo -ne '\''\xf0\x90\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x90\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 1
$ echo -ne '\''\xf0\x90\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x90\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 2
$ echo -ne '\''\xf0\x90\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x90\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 3
$ echo -ne '\''\xf0\x90\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\x90\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 4
$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf0\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 1
$ echo -ne '\''\xf0\x90\x80'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 2
$ echo -ne '\''\xf0\x90\x80'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 3
$ echo -ne '\''\xf0\x90\x80'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 4
$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 1
$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 2
$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 3
$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 1
$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 2
$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 3
$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\x90\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 5
$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf0\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 5
$ echo -ne '\''\xf1'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1'\''|json -b 1
$ echo -ne '\''\xf1'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1'\''|json -b 2
$ echo -ne '\''\xf1\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1\x7f'\''|json -b 1
$ echo -ne '\''\xf1\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1\x7f'\''|json -b 2
$ echo -ne '\''\xf1\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1\x7f'\''|json -b 3
$ echo -ne '\''\xf1\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1\xc0'\''|json -b 1
$ echo -ne '\''\xf1\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1\xc0'\''|json -b 2
$ echo -ne '\''\xf1\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf1\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf1\xc0'\''|json -b 3
$ echo -ne '\''\xf1\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\x80'\''|json -b 1
$ echo -ne '\''\xf1\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\x80'\''|json -b 2
$ echo -ne '\''\xf1\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\x80'\''|json -b 3
$ echo -ne '\''\xf1\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\xbf'\''|json -b 1
$ echo -ne '\''\xf1\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\xbf'\''|json -b 2
$ echo -ne '\''\xf1\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\xbf'\''|json -b 3
$ echo -ne '\''\xf1\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 1
$ echo -ne '\''\xf1\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 2
$ echo -ne '\''\xf1\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 3
$ echo -ne '\''\xf1\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 4
$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf1\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf1\x80\x80'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 1
$ echo -ne '\''\xf1\x80\x80'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 2
$ echo -ne '\''\xf1\x80\x80'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 3
$ echo -ne '\''\xf1\x80\x80'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 4
$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 1
$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 2
$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 3
$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 4
$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 1
$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 2
$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 3
$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 4
$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 5
$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf1\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 5
$ echo -ne '\''\xf3'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3'\''|json -b 1
$ echo -ne '\''\xf3'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3'\''|json -b 2
$ echo -ne '\''\xf3\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3\x7f'\''|json -b 1
$ echo -ne '\''\xf3\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3\x7f'\''|json -b 2
$ echo -ne '\''\xf3\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3\x7f'\''|json -b 3
$ echo -ne '\''\xf3\xc0'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3\xc0'\''|json -b 1
$ echo -ne '\''\xf3\xc0'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3\xc0'\''|json -b 2
$ echo -ne '\''\xf3\xc0'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf3\xc0
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf3\xc0'\''|json -b 3
$ echo -ne '\''\xf3\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\x80'\''|json -b 1
$ echo -ne '\''\xf3\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\x80'\''|json -b 2
$ echo -ne '\''\xf3\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\x80'\''|json -b 3
$ echo -ne '\''\xf3\xbf'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\xbf'\''|json -b 1
$ echo -ne '\''\xf3\xbf'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\xbf'\''|json -b 2
$ echo -ne '\''\xf3\xbf'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\xbf
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\xbf'\''|json -b 3
$ echo -ne '\''\xf3\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 1
$ echo -ne '\''\xf3\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 2
$ echo -ne '\''\xf3\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 3
$ echo -ne '\''\xf3\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 4
$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf3\xbf\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf3\x80\x80'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 1
$ echo -ne '\''\xf3\x80\x80'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 2
$ echo -ne '\''\xf3\x80\x80'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 3
$ echo -ne '\''\xf3\x80\x80'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 4
$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 1
$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 2
$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 3
$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 4
$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 1
$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 2
$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 3
$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 4
$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 5
$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf3\xbf\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 5
$ echo -ne '\''\xf4'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf4
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf4'\''|json -b 1
$ echo -ne '\''\xf4'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf4
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf4'\''|json -b 2
$ echo -ne '\''\xf4\x7f'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf4\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf4\x7f'\''|json -b 1
$ echo -ne '\''\xf4\x7f'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf4\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf4\x7f'\''|json -b 2
$ echo -ne '\''\xf4\x7f'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf4\x7f
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf4\x7f'\''|json -b 3
$ echo -ne '\''\xf4\x90'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x90
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x90'\''|json -b 1
$ echo -ne '\''\xf4\x90'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x90
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x90'\''|json -b 2
$ echo -ne '\''\xf4\x90'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x90
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x90'\''|json -b 3
$ echo -ne '\''\xf4\x80'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x80'\''|json -b 1
$ echo -ne '\''\xf4\x80'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x80'\''|json -b 2
$ echo -ne '\''\xf4\x80'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x80
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x80'\''|json -b 3
$ echo -ne '\''\xf4\x8f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x8f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x8f'\''|json -b 1
$ echo -ne '\''\xf4\x8f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x8f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x8f'\''|json -b 2
$ echo -ne '\''\xf4\x8f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x8f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x8f'\''|json -b 3
$ echo -ne '\''\xf4\x80\x7f'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 1
$ echo -ne '\''\xf4\x80\x7f'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 2
$ echo -ne '\''\xf4\x80\x7f'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 3
$ echo -ne '\''\xf4\x80\x7f'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x80\x7f
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 4
$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x8f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 1
$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x8f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 2
$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x8f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 3
$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf4\x8f\xc0
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 4
$ echo -ne '\''\xf4\x80\x80'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 1
$ echo -ne '\''\xf4\x80\x80'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 2
$ echo -ne '\''\xf4\x80\x80'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 3
$ echo -ne '\''\xf4\x80\x80'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 4
$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 1
$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 2
$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 3
$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 4
$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 1
$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 2
$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 3
$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 4
$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x80\x80\x7f
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 5
$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 1
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 1
$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 2
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 2
$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 3
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 3
$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 4
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 4
$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 5
json: error: <stdin>:1:4: invalid utf-8 encoding
json: error: <stdin>:1:4: \xf4\x8f\xbf\xc0
json: error: <stdin>:1:4:             ^
command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 5
$ echo -ne '\''\xf5'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5'\''|json -b 1
$ echo -ne '\''\xf5'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5'\''|json -b 2
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 1
A\u2262\u0391.
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 2
A\u2262\u0391.
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 3
A\u2262\u0391.
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 4
A\u2262\u0391.
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 5
A\u2262\u0391.
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 6
A\u2262\u0391.
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 7
A\u2262\u0391.
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 8
A\u2262\u0391.'
) -L utf8.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'

echo '$ echo -ne '\''\xc0'\''|json -b 1'
echo -ne '\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xc0'\''|json -b 2'
echo -ne '\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xc1'\''|json -b 1'
echo -ne '\xc1'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc1'\''|json -b 1'

echo '$ echo -ne '\''\xc1'\''|json -b 2'
echo -ne '\xc1'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc1'\''|json -b 2'

echo '$ echo -ne '\''\xc2'\''|json -b 1'
echo -ne '\xc2'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2'\''|json -b 1'

echo '$ echo -ne '\''\xc2'\''|json -b 2'
echo -ne '\xc2'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2'\''|json -b 2'

echo '$ echo -ne '\''\xdf'\''|json -b 1'
echo -ne '\xdf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf'\''|json -b 1'

echo '$ echo -ne '\''\xdf'\''|json -b 2'
echo -ne '\xdf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf'\''|json -b 2'

echo '$ echo -ne '\''\xc2\x7f'\''|json -b 1'
echo -ne '\xc2\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xc2\x7f'\''|json -b 2'
echo -ne '\xc2\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xc2\x7f'\''|json -b 3'
echo -ne '\xc2\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xdf\x7f'\''|json -b 1'
echo -ne '\xdf\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xdf\x7f'\''|json -b 2'
echo -ne '\xdf\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xdf\x7f'\''|json -b 3'
echo -ne '\xdf\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xc2\xc0'\''|json -b 1'
echo -ne '\xc2\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xc2\xc0'\''|json -b 2'
echo -ne '\xc2\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xc2\xc0'\''|json -b 3'
echo -ne '\xc2\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xdf\xc0'\''|json -b 1'
echo -ne '\xdf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xdf\xc0'\''|json -b 2'
echo -ne '\xdf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xdf\xc0'\''|json -b 3'
echo -ne '\xdf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xe0'\''|json -b 1'
echo -ne '\xe0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0'\''|json -b 1'

echo '$ echo -ne '\''\xe0'\''|json -b 2'
echo -ne '\xe0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0'\''|json -b 2'

echo '$ echo -ne '\''\xe0\x9f'\''|json -b 1'
echo -ne '\xe0\x9f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\x9f'\''|json -b 1'

echo '$ echo -ne '\''\xe0\x9f'\''|json -b 2'
echo -ne '\xe0\x9f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\x9f'\''|json -b 2'

echo '$ echo -ne '\''\xe0\x9f'\''|json -b 3'
echo -ne '\xe0\x9f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\x9f'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xc0'\''|json -b 1'
echo -ne '\xe0\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xc0'\''|json -b 2'
echo -ne '\xe0\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xc0'\''|json -b 3'
echo -ne '\xe0\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0'\''|json -b 1'
echo -ne '\xe0\xa0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0'\''|json -b 2'
echo -ne '\xe0\xa0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0'\''|json -b 3'
echo -ne '\xe0\xa0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xbf'\''|json -b 1'
echo -ne '\xe0\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf'\''|json -b 2'
echo -ne '\xe0\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xbf'\''|json -b 3'
echo -ne '\xe0\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 1'
echo -ne '\xe0\xa0\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 2'
echo -ne '\xe0\xa0\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 3'
echo -ne '\xe0\xa0\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x7f'\''|json -b 4'
echo -ne '\xe0\xa0\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 1'
echo -ne '\xe0\xbf\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 2'
echo -ne '\xe0\xbf\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 3'
echo -ne '\xe0\xbf\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xbf\x7f'\''|json -b 4'
echo -ne '\xe0\xbf\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 1'
echo -ne '\xe0\xa0\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 2'
echo -ne '\xe0\xa0\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 3'
echo -ne '\xe0\xa0\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\xc0'\''|json -b 4'
echo -ne '\xe0\xa0\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 1'
echo -ne '\xe0\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 2'
echo -ne '\xe0\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 3'
echo -ne '\xe0\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xbf\xc0'\''|json -b 4'
echo -ne '\xe0\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xe1'\''|json -b 1'
echo -ne '\xe1'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1'\''|json -b 1'

echo '$ echo -ne '\''\xe1'\''|json -b 2'
echo -ne '\xe1'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1'\''|json -b 2'

echo '$ echo -ne '\''\xe1\x7f'\''|json -b 1'
echo -ne '\xe1\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xe1\x7f'\''|json -b 2'
echo -ne '\xe1\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xe1\x7f'\''|json -b 3'
echo -ne '\xe1\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xc0'\''|json -b 1'
echo -ne '\xe1\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xc0'\''|json -b 2'
echo -ne '\xe1\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xe1\xc0'\''|json -b 3'
echo -ne '\xe1\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xe1\x80'\''|json -b 1'
echo -ne '\xe1\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80'\''|json -b 1'

echo '$ echo -ne '\''\xe1\x80'\''|json -b 2'
echo -ne '\xe1\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80'\''|json -b 2'

echo '$ echo -ne '\''\xe1\x80'\''|json -b 3'
echo -ne '\xe1\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf'\''|json -b 1'
echo -ne '\xe1\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf'\''|json -b 2'
echo -ne '\xe1\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xe1\xbf'\''|json -b 3'
echo -ne '\xe1\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xe1\x80\x7f'\''|json -b 1'
echo -ne '\xe1\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xe1\x80\x7f'\''|json -b 2'
echo -ne '\xe1\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xe1\x80\x7f'\''|json -b 3'
echo -ne '\xe1\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xe1\x80\x7f'\''|json -b 4'
echo -ne '\xe1\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 1'
echo -ne '\xe1\xbf\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 2'
echo -ne '\xe1\xbf\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 3'
echo -ne '\xe1\xbf\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf\x7f'\''|json -b 4'
echo -ne '\xe1\xbf\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xe1\x80\xc0'\''|json -b 1'
echo -ne '\xe1\x80\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xe1\x80\xc0'\''|json -b 2'
echo -ne '\xe1\x80\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xe1\x80\xc0'\''|json -b 3'
echo -ne '\xe1\x80\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xe1\x80\xc0'\''|json -b 4'
echo -ne '\xe1\x80\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 1'
echo -ne '\xe1\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 2'
echo -ne '\xe1\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 3'
echo -ne '\xe1\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xe1\xbf\xc0'\''|json -b 4'
echo -ne '\xe1\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xec'\''|json -b 1'
echo -ne '\xec'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec'\''|json -b 1'

echo '$ echo -ne '\''\xec'\''|json -b 2'
echo -ne '\xec'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec'\''|json -b 2'

echo '$ echo -ne '\''\xec\x7f'\''|json -b 1'
echo -ne '\xec\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xec\x7f'\''|json -b 2'
echo -ne '\xec\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xec\x7f'\''|json -b 3'
echo -ne '\xec\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xec\xc0'\''|json -b 1'
echo -ne '\xec\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xec\xc0'\''|json -b 2'
echo -ne '\xec\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xec\xc0'\''|json -b 3'
echo -ne '\xec\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xec\x80'\''|json -b 1'
echo -ne '\xec\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80'\''|json -b 1'

echo '$ echo -ne '\''\xec\x80'\''|json -b 2'
echo -ne '\xec\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80'\''|json -b 2'

echo '$ echo -ne '\''\xec\x80'\''|json -b 3'
echo -ne '\xec\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf'\''|json -b 1'
echo -ne '\xec\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf'\''|json -b 2'
echo -ne '\xec\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xec\xbf'\''|json -b 3'
echo -ne '\xec\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xec\x80\x7f'\''|json -b 1'
echo -ne '\xec\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xec\x80\x7f'\''|json -b 2'
echo -ne '\xec\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xec\x80\x7f'\''|json -b 3'
echo -ne '\xec\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xec\x80\x7f'\''|json -b 4'
echo -ne '\xec\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xec\xbf\x7f'\''|json -b 1'
echo -ne '\xec\xbf\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf\x7f'\''|json -b 2'
echo -ne '\xec\xbf\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xec\xbf\x7f'\''|json -b 3'
echo -ne '\xec\xbf\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf\x7f'\''|json -b 4'
echo -ne '\xec\xbf\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xec\x80\xc0'\''|json -b 1'
echo -ne '\xec\x80\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xec\x80\xc0'\''|json -b 2'
echo -ne '\xec\x80\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xec\x80\xc0'\''|json -b 3'
echo -ne '\xec\x80\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xec\x80\xc0'\''|json -b 4'
echo -ne '\xec\x80\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xec\xbf\xc0'\''|json -b 1'
echo -ne '\xec\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xec\xbf\xc0'\''|json -b 2'
echo -ne '\xec\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xec\xbf\xc0'\''|json -b 3'
echo -ne '\xec\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xec\xbf\xc0'\''|json -b 4'
echo -ne '\xec\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xed'\''|json -b 1'
echo -ne '\xed'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed'\''|json -b 1'

echo '$ echo -ne '\''\xed'\''|json -b 2'
echo -ne '\xed'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed'\''|json -b 2'

echo '$ echo -ne '\''\xed\x7f'\''|json -b 1'
echo -ne '\xed\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xed\x7f'\''|json -b 2'
echo -ne '\xed\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xed\x7f'\''|json -b 3'
echo -ne '\xed\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xed\xa0'\''|json -b 1'
echo -ne '\xed\xa0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xa0'\''|json -b 1'

echo '$ echo -ne '\''\xed\xa0'\''|json -b 2'
echo -ne '\xed\xa0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xa0'\''|json -b 2'

echo '$ echo -ne '\''\xed\xa0'\''|json -b 3'
echo -ne '\xed\xa0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xa0'\''|json -b 3'

echo '$ echo -ne '\''\xed\x80'\''|json -b 1'
echo -ne '\xed\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80'\''|json -b 1'

echo '$ echo -ne '\''\xed\x80'\''|json -b 2'
echo -ne '\xed\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80'\''|json -b 2'

echo '$ echo -ne '\''\xed\x80'\''|json -b 3'
echo -ne '\xed\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80'\''|json -b 3'

echo '$ echo -ne '\''\xed\x9f'\''|json -b 1'
echo -ne '\xed\x9f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f'\''|json -b 1'

echo '$ echo -ne '\''\xed\x9f'\''|json -b 2'
echo -ne '\xed\x9f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f'\''|json -b 2'

echo '$ echo -ne '\''\xed\x9f'\''|json -b 3'
echo -ne '\xed\x9f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f'\''|json -b 3'

echo '$ echo -ne '\''\xed\x80\x7f'\''|json -b 1'
echo -ne '\xed\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xed\x80\x7f'\''|json -b 2'
echo -ne '\xed\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xed\x80\x7f'\''|json -b 3'
echo -ne '\xed\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xed\x80\x7f'\''|json -b 4'
echo -ne '\xed\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xed\x9f\x7f'\''|json -b 1'
echo -ne '\xed\x9f\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xed\x9f\x7f'\''|json -b 2'
echo -ne '\xed\x9f\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xed\x9f\x7f'\''|json -b 3'
echo -ne '\xed\x9f\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xed\x9f\x7f'\''|json -b 4'
echo -ne '\xed\x9f\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xed\x80\xc0'\''|json -b 1'
echo -ne '\xed\x80\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xed\x80\xc0'\''|json -b 2'
echo -ne '\xed\x80\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xed\x80\xc0'\''|json -b 3'
echo -ne '\xed\x80\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xed\x80\xc0'\''|json -b 4'
echo -ne '\xed\x80\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xed\x9f\xc0'\''|json -b 1'
echo -ne '\xed\x9f\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xed\x9f\xc0'\''|json -b 2'
echo -ne '\xed\x9f\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xed\x9f\xc0'\''|json -b 3'
echo -ne '\xed\x9f\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xed\x9f\xc0'\''|json -b 4'
echo -ne '\xed\x9f\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xee'\''|json -b 1'
echo -ne '\xee'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee'\''|json -b 1'

echo '$ echo -ne '\''\xee'\''|json -b 2'
echo -ne '\xee'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee'\''|json -b 2'

echo '$ echo -ne '\''\xee\x7f'\''|json -b 1'
echo -ne '\xee\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xee\x7f'\''|json -b 2'
echo -ne '\xee\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xee\x7f'\''|json -b 3'
echo -ne '\xee\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xee\xc0'\''|json -b 1'
echo -ne '\xee\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xee\xc0'\''|json -b 2'
echo -ne '\xee\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xee\xc0'\''|json -b 3'
echo -ne '\xee\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xee\x80'\''|json -b 1'
echo -ne '\xee\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80'\''|json -b 1'

echo '$ echo -ne '\''\xee\x80'\''|json -b 2'
echo -ne '\xee\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80'\''|json -b 2'

echo '$ echo -ne '\''\xee\x80'\''|json -b 3'
echo -ne '\xee\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf'\''|json -b 1'
echo -ne '\xee\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf'\''|json -b 2'
echo -ne '\xee\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xee\xbf'\''|json -b 3'
echo -ne '\xee\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xee\x80\x7f'\''|json -b 1'
echo -ne '\xee\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xee\x80\x7f'\''|json -b 2'
echo -ne '\xee\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xee\x80\x7f'\''|json -b 3'
echo -ne '\xee\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xee\x80\x7f'\''|json -b 4'
echo -ne '\xee\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xee\xbf\x7f'\''|json -b 1'
echo -ne '\xee\xbf\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf\x7f'\''|json -b 2'
echo -ne '\xee\xbf\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xee\xbf\x7f'\''|json -b 3'
echo -ne '\xee\xbf\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf\x7f'\''|json -b 4'
echo -ne '\xee\xbf\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xee\x80\xc0'\''|json -b 1'
echo -ne '\xee\x80\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xee\x80\xc0'\''|json -b 2'
echo -ne '\xee\x80\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xee\x80\xc0'\''|json -b 3'
echo -ne '\xee\x80\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xee\x80\xc0'\''|json -b 4'
echo -ne '\xee\x80\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xee\xbf\xc0'\''|json -b 1'
echo -ne '\xee\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xee\xbf\xc0'\''|json -b 2'
echo -ne '\xee\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xee\xbf\xc0'\''|json -b 3'
echo -ne '\xee\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xee\xbf\xc0'\''|json -b 4'
echo -ne '\xee\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xef'\''|json -b 1'
echo -ne '\xef'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef'\''|json -b 1'

echo '$ echo -ne '\''\xef'\''|json -b 2'
echo -ne '\xef'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef'\''|json -b 2'

echo '$ echo -ne '\''\xef\x7f'\''|json -b 1'
echo -ne '\xef\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xef\x7f'\''|json -b 2'
echo -ne '\xef\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xef\x7f'\''|json -b 3'
echo -ne '\xef\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xef\xc0'\''|json -b 1'
echo -ne '\xef\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xef\xc0'\''|json -b 2'
echo -ne '\xef\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xef\xc0'\''|json -b 3'
echo -ne '\xef\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xef\x80'\''|json -b 1'
echo -ne '\xef\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80'\''|json -b 1'

echo '$ echo -ne '\''\xef\x80'\''|json -b 2'
echo -ne '\xef\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80'\''|json -b 2'

echo '$ echo -ne '\''\xef\x80'\''|json -b 3'
echo -ne '\xef\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf'\''|json -b 1'
echo -ne '\xef\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf'\''|json -b 2'
echo -ne '\xef\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xef\xbf'\''|json -b 3'
echo -ne '\xef\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xef\x80\x7f'\''|json -b 1'
echo -ne '\xef\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xef\x80\x7f'\''|json -b 2'
echo -ne '\xef\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xef\x80\x7f'\''|json -b 3'
echo -ne '\xef\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xef\x80\x7f'\''|json -b 4'
echo -ne '\xef\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xef\xbf\x7f'\''|json -b 1'
echo -ne '\xef\xbf\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf\x7f'\''|json -b 2'
echo -ne '\xef\xbf\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xef\xbf\x7f'\''|json -b 3'
echo -ne '\xef\xbf\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf\x7f'\''|json -b 4'
echo -ne '\xef\xbf\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xef\x80\xc0'\''|json -b 1'
echo -ne '\xef\x80\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xef\x80\xc0'\''|json -b 2'
echo -ne '\xef\x80\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xef\x80\xc0'\''|json -b 3'
echo -ne '\xef\x80\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xef\x80\xc0'\''|json -b 4'
echo -ne '\xef\x80\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xef\xbf\xc0'\''|json -b 1'
echo -ne '\xef\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xef\xbf\xc0'\''|json -b 2'
echo -ne '\xef\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xef\xbf\xc0'\''|json -b 3'
echo -ne '\xef\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xef\xbf\xc0'\''|json -b 4'
echo -ne '\xef\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf0'\''|json -b 1'
echo -ne '\xf0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0'\''|json -b 1'

echo '$ echo -ne '\''\xf0'\''|json -b 2'
echo -ne '\xf0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x8f'\''|json -b 1'
echo -ne '\xf0\x8f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x8f'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x8f'\''|json -b 2'
echo -ne '\xf0\x8f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x8f'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x8f'\''|json -b 3'
echo -ne '\xf0\x8f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x8f'\''|json -b 3'

echo '$ echo -ne '\''\xf0\xc0'\''|json -b 1'
echo -ne '\xf0\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xc0'\''|json -b 2'
echo -ne '\xf0\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf0\xc0'\''|json -b 3'
echo -ne '\xf0\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90'\''|json -b 1'
echo -ne '\xf0\x90'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90'\''|json -b 2'
echo -ne '\xf0\x90'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90'\''|json -b 3'
echo -ne '\xf0\x90'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90'\''|json -b 3'

echo '$ echo -ne '\''\xf0\xbf'\''|json -b 1'
echo -ne '\xf0\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf'\''|json -b 2'
echo -ne '\xf0\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xf0\xbf'\''|json -b 3'
echo -ne '\xf0\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x7f'\''|json -b 1'
echo -ne '\xf0\x90\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x7f'\''|json -b 2'
echo -ne '\xf0\x90\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x7f'\''|json -b 3'
echo -ne '\xf0\x90\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x7f'\''|json -b 4'
echo -ne '\xf0\x90\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 1'
echo -ne '\xf0\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 2'
echo -ne '\xf0\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 3'
echo -ne '\xf0\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf0\xbf\xc0'\''|json -b 4'
echo -ne '\xf0\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80'\''|json -b 1'
echo -ne '\xf0\x90\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80'\''|json -b 2'
echo -ne '\xf0\x90\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80'\''|json -b 3'
echo -ne '\xf0\x90\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80'\''|json -b 4'
echo -ne '\xf0\x90\x80'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80'\''|json -b 4'

echo '$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 1'
echo -ne '\xf0\xbf\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 2'
echo -ne '\xf0\xbf\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 3'
echo -ne '\xf0\xbf\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xf0\xbf\xbf'\''|json -b 4'
echo -ne '\xf0\xbf\xbf'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 1'
echo -ne '\xf0\x90\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 2'
echo -ne '\xf0\x90\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 3'
echo -ne '\xf0\x90\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 4'
echo -ne '\xf0\x90\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 5'
echo -ne '\xf0\x90\x80\x7f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json -b 5'

echo '$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 1'
echo -ne '\xf0\xbf\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 2'
echo -ne '\xf0\xbf\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 3'
echo -ne '\xf0\xbf\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 4'
echo -ne '\xf0\xbf\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 5'
echo -ne '\xf0\xbf\xbf\xc0'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json -b 5'

echo '$ echo -ne '\''\xf1'\''|json -b 1'
echo -ne '\xf1'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1'\''|json -b 1'

echo '$ echo -ne '\''\xf1'\''|json -b 2'
echo -ne '\xf1'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1'\''|json -b 2'

echo '$ echo -ne '\''\xf1\x7f'\''|json -b 1'
echo -ne '\xf1\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf1\x7f'\''|json -b 2'
echo -ne '\xf1\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf1\x7f'\''|json -b 3'
echo -ne '\xf1\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf1\xc0'\''|json -b 1'
echo -ne '\xf1\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xc0'\''|json -b 2'
echo -ne '\xf1\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf1\xc0'\''|json -b 3'
echo -ne '\xf1\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf1\x80'\''|json -b 1'
echo -ne '\xf1\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80'\''|json -b 1'

echo '$ echo -ne '\''\xf1\x80'\''|json -b 2'
echo -ne '\xf1\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80'\''|json -b 2'

echo '$ echo -ne '\''\xf1\x80'\''|json -b 3'
echo -ne '\xf1\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80'\''|json -b 3'

echo '$ echo -ne '\''\xf1\xbf'\''|json -b 1'
echo -ne '\xf1\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf'\''|json -b 2'
echo -ne '\xf1\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xf1\xbf'\''|json -b 3'
echo -ne '\xf1\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xf1\x80\x7f'\''|json -b 1'
echo -ne '\xf1\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf1\x80\x7f'\''|json -b 2'
echo -ne '\xf1\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf1\x80\x7f'\''|json -b 3'
echo -ne '\xf1\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf1\x80\x7f'\''|json -b 4'
echo -ne '\xf1\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 1'
echo -ne '\xf1\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 2'
echo -ne '\xf1\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 3'
echo -ne '\xf1\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf1\xbf\xc0'\''|json -b 4'
echo -ne '\xf1\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf1\x80\x80'\''|json -b 1'
echo -ne '\xf1\x80\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 1'

echo '$ echo -ne '\''\xf1\x80\x80'\''|json -b 2'
echo -ne '\xf1\x80\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 2'

echo '$ echo -ne '\''\xf1\x80\x80'\''|json -b 3'
echo -ne '\xf1\x80\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 3'

echo '$ echo -ne '\''\xf1\x80\x80'\''|json -b 4'
echo -ne '\xf1\x80\x80'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 1'
echo -ne '\xf1\xbf\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 2'
echo -ne '\xf1\xbf\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 3'
echo -ne '\xf1\xbf\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xf1\xbf\xbf'\''|json -b 4'
echo -ne '\xf1\xbf\xbf'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf'\''|json -b 4'

echo '$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 1'
echo -ne '\xf1\x80\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 2'
echo -ne '\xf1\x80\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 3'
echo -ne '\xf1\x80\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 4'
echo -ne '\xf1\x80\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 5'
echo -ne '\xf1\x80\x80\x7f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json -b 5'

echo '$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 1'
echo -ne '\xf1\xbf\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 2'
echo -ne '\xf1\xbf\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 3'
echo -ne '\xf1\xbf\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 4'
echo -ne '\xf1\xbf\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 5'
echo -ne '\xf1\xbf\xbf\xc0'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json -b 5'

echo '$ echo -ne '\''\xf3'\''|json -b 1'
echo -ne '\xf3'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3'\''|json -b 1'

echo '$ echo -ne '\''\xf3'\''|json -b 2'
echo -ne '\xf3'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3'\''|json -b 2'

echo '$ echo -ne '\''\xf3\x7f'\''|json -b 1'
echo -ne '\xf3\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf3\x7f'\''|json -b 2'
echo -ne '\xf3\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf3\x7f'\''|json -b 3'
echo -ne '\xf3\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf3\xc0'\''|json -b 1'
echo -ne '\xf3\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xc0'\''|json -b 2'
echo -ne '\xf3\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf3\xc0'\''|json -b 3'
echo -ne '\xf3\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf3\x80'\''|json -b 1'
echo -ne '\xf3\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80'\''|json -b 1'

echo '$ echo -ne '\''\xf3\x80'\''|json -b 2'
echo -ne '\xf3\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80'\''|json -b 2'

echo '$ echo -ne '\''\xf3\x80'\''|json -b 3'
echo -ne '\xf3\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80'\''|json -b 3'

echo '$ echo -ne '\''\xf3\xbf'\''|json -b 1'
echo -ne '\xf3\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf'\''|json -b 2'
echo -ne '\xf3\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xf3\xbf'\''|json -b 3'
echo -ne '\xf3\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xf3\x80\x7f'\''|json -b 1'
echo -ne '\xf3\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf3\x80\x7f'\''|json -b 2'
echo -ne '\xf3\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf3\x80\x7f'\''|json -b 3'
echo -ne '\xf3\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf3\x80\x7f'\''|json -b 4'
echo -ne '\xf3\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 1'
echo -ne '\xf3\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 2'
echo -ne '\xf3\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 3'
echo -ne '\xf3\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf3\xbf\xc0'\''|json -b 4'
echo -ne '\xf3\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf3\x80\x80'\''|json -b 1'
echo -ne '\xf3\x80\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 1'

echo '$ echo -ne '\''\xf3\x80\x80'\''|json -b 2'
echo -ne '\xf3\x80\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 2'

echo '$ echo -ne '\''\xf3\x80\x80'\''|json -b 3'
echo -ne '\xf3\x80\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 3'

echo '$ echo -ne '\''\xf3\x80\x80'\''|json -b 4'
echo -ne '\xf3\x80\x80'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 1'
echo -ne '\xf3\xbf\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 2'
echo -ne '\xf3\xbf\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 3'
echo -ne '\xf3\xbf\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xf3\xbf\xbf'\''|json -b 4'
echo -ne '\xf3\xbf\xbf'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf'\''|json -b 4'

echo '$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 1'
echo -ne '\xf3\x80\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 2'
echo -ne '\xf3\x80\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 3'
echo -ne '\xf3\x80\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 4'
echo -ne '\xf3\x80\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 5'
echo -ne '\xf3\x80\x80\x7f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json -b 5'

echo '$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 1'
echo -ne '\xf3\xbf\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 2'
echo -ne '\xf3\xbf\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 3'
echo -ne '\xf3\xbf\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 4'
echo -ne '\xf3\xbf\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 5'
echo -ne '\xf3\xbf\xbf\xc0'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json -b 5'

echo '$ echo -ne '\''\xf4'\''|json -b 1'
echo -ne '\xf4'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4'\''|json -b 1'

echo '$ echo -ne '\''\xf4'\''|json -b 2'
echo -ne '\xf4'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x7f'\''|json -b 1'
echo -ne '\xf4\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x7f'\''|json -b 2'
echo -ne '\xf4\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x7f'\''|json -b 3'
echo -ne '\xf4\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x90'\''|json -b 1'
echo -ne '\xf4\x90'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x90'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x90'\''|json -b 2'
echo -ne '\xf4\x90'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x90'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x90'\''|json -b 3'
echo -ne '\xf4\x90'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x90'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x80'\''|json -b 1'
echo -ne '\xf4\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x80'\''|json -b 2'
echo -ne '\xf4\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x80'\''|json -b 3'
echo -ne '\xf4\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x8f'\''|json -b 1'
echo -ne '\xf4\x8f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x8f'\''|json -b 2'
echo -ne '\xf4\x8f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x8f'\''|json -b 3'
echo -ne '\xf4\x8f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x80\x7f'\''|json -b 1'
echo -ne '\xf4\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x80\x7f'\''|json -b 2'
echo -ne '\xf4\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x80\x7f'\''|json -b 3'
echo -ne '\xf4\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x80\x7f'\''|json -b 4'
echo -ne '\xf4\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 1'
echo -ne '\xf4\x8f\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 2'
echo -ne '\xf4\x8f\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 3'
echo -ne '\xf4\x8f\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x8f\xc0'\''|json -b 4'
echo -ne '\xf4\x8f\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf4\x80\x80'\''|json -b 1'
echo -ne '\xf4\x80\x80'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x80\x80'\''|json -b 2'
echo -ne '\xf4\x80\x80'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x80\x80'\''|json -b 3'
echo -ne '\xf4\x80\x80'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x80\x80'\''|json -b 4'
echo -ne '\xf4\x80\x80'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80'\''|json -b 4'

echo '$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 1'
echo -ne '\xf4\x8f\xbf'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 2'
echo -ne '\xf4\x8f\xbf'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 3'
echo -ne '\xf4\x8f\xbf'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x8f\xbf'\''|json -b 4'
echo -ne '\xf4\x8f\xbf'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf'\''|json -b 4'

echo '$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 1'
echo -ne '\xf4\x80\x80\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 2'
echo -ne '\xf4\x80\x80\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 3'
echo -ne '\xf4\x80\x80\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 4'
echo -ne '\xf4\x80\x80\x7f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 4'

echo '$ echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 5'
echo -ne '\xf4\x80\x80\x7f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json -b 5'

echo '$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 1'
echo -ne '\xf4\x8f\xbf\xc0'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 1'

echo '$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 2'
echo -ne '\xf4\x8f\xbf\xc0'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 2'

echo '$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 3'
echo -ne '\xf4\x8f\xbf\xc0'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 3'

echo '$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 4'
echo -ne '\xf4\x8f\xbf\xc0'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 4'

echo '$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 5'
echo -ne '\xf4\x8f\xbf\xc0'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json -b 5'

echo '$ echo -ne '\''\xf5'\''|json -b 1'
echo -ne '\xf5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf5'\''|json -b 1'

echo '$ echo -ne '\''\xf5'\''|json -b 2'
echo -ne '\xf5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf5'\''|json -b 2'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 1'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 1'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 2'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 2'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 3'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 3'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 4'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 4'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 5'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 5'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 6'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 6'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 7'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 7'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 8'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json -b 8'
)

