#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array-list5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array-list5.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: ["foo","foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: ["foo","foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: ["foo","foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: ["foo","foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''["foo","foo"]'\''
["foo","foo"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[[],[]]'\'''
) -L open-array-list5.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"foo"}]}}'\'' <<< '\''[[],[]]'\'''
)

