#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-plain-object-basic-val-object-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-plain-object-basic-val-object-basic2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\''
{"faa":null}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\''
{"faa":false}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\''
{"faa":true}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\''
{"faa":123}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\''
{"faa":456}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
{"faa":"foo"}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\''
{"faa":{}}
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"faa":[]}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":null}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":false}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":true}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":123}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":456}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"foo"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":"bar"}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"faa":{}}
json: error: <stdin>:1:8:        ^
{"faa":
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\''
{"faa":[]}'
) -L list-plain-object-basic-val-object-basic2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[]}'\'''
)

