#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-basic-val-object-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-basic-val-object-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[]}'\'''
) -L list-object-basic-val-object-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"baa":[]}'\'''
)

