#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:rex-dup
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L rex-dup.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '\''{'\''; for((i=0;i<n;i++));do printf '\''"%s":"/%s/"'\'' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '\''}'\''; }
$ diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; }
$ json-litex -d "$(gen-litex -16)"
{
    "rexes": {
        "size": 16,
        "codes": {
            "type": "patterns",
            "code": {}
        },
        "elems": [
            {
                "text": "0",
                "opts": ""
            },
            {
                "text": "1",
                "opts": ""
            },
            {
                "text": "2",
                "opts": ""
            },
            {
                "text": "3",
                "opts": ""
            },
            {
                "text": "4",
                "opts": ""
            },
            {
                "text": "5",
                "opts": ""
            },
            {
                "text": "6",
                "opts": ""
            },
            {
                "text": "7",
                "opts": ""
            },
            {
                "text": "8",
                "opts": ""
            },
            {
                "text": "9",
                "opts": ""
            },
            {
                "text": "10",
                "opts": ""
            },
            {
                "text": "11",
                "opts": ""
            },
            {
                "text": "12",
                "opts": ""
            },
            {
                "text": "13",
                "opts": ""
            },
            {
                "text": "14",
                "opts": ""
            },
            {
                "text": "15",
                "opts": ""
            }
        ]
    },
    "node": {
        "id": 54,
        "type": "object",
        "node": {
            "size": 16,
            "args": [
                {
                    "key": {
                        "val": "0",
                        "delim": null
                    },
                    "val": {
                        "id": 5,
                        "type": "string",
                        "node": {
                            "val": "/0/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 0
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 0
                    }
                },
                {
                    "key": {
                        "val": "1",
                        "delim": null
                    },
                    "val": {
                        "id": 8,
                        "type": "string",
                        "node": {
                            "val": "/1/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 1
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 1
                    }
                },
                {
                    "key": {
                        "val": "2",
                        "delim": null
                    },
                    "val": {
                        "id": 11,
                        "type": "string",
                        "node": {
                            "val": "/2/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 2
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 2
                    }
                },
                {
                    "key": {
                        "val": "3",
                        "delim": null
                    },
                    "val": {
                        "id": 14,
                        "type": "string",
                        "node": {
                            "val": "/3/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 3
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 3
                    }
                },
                {
                    "key": {
                        "val": "4",
                        "delim": null
                    },
                    "val": {
                        "id": 17,
                        "type": "string",
                        "node": {
                            "val": "/4/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 4
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 4
                    }
                },
                {
                    "key": {
                        "val": "5",
                        "delim": null
                    },
                    "val": {
                        "id": 20,
                        "type": "string",
                        "node": {
                            "val": "/5/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 5
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 5
                    }
                },
                {
                    "key": {
                        "val": "6",
                        "delim": null
                    },
                    "val": {
                        "id": 23,
                        "type": "string",
                        "node": {
                            "val": "/6/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 6
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 6
                    }
                },
                {
                    "key": {
                        "val": "7",
                        "delim": null
                    },
                    "val": {
                        "id": 26,
                        "type": "string",
                        "node": {
                            "val": "/7/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 7
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 7
                    }
                },
                {
                    "key": {
                        "val": "8",
                        "delim": null
                    },
                    "val": {
                        "id": 29,
                        "type": "string",
                        "node": {
                            "val": "/8/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 8
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 8
                    }
                },
                {
                    "key": {
                        "val": "9",
                        "delim": null
                    },
                    "val": {
                        "id": 32,
                        "type": "string",
                        "node": {
                            "val": "/9/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 9
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 9
                    }
                },
                {
                    "key": {
                        "val": "10",
                        "delim": null
                    },
                    "val": {
                        "id": 35,
                        "type": "string",
                        "node": {
                            "val": "/10/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 10
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 10
                    }
                },
                {
                    "key": {
                        "val": "11",
                        "delim": null
                    },
                    "val": {
                        "id": 38,
                        "type": "string",
                        "node": {
                            "val": "/11/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 11
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 11
                    }
                },
                {
                    "key": {
                        "val": "12",
                        "delim": null
                    },
                    "val": {
                        "id": 41,
                        "type": "string",
                        "node": {
                            "val": "/12/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 12
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 12
                    }
                },
                {
                    "key": {
                        "val": "13",
                        "delim": null
                    },
                    "val": {
                        "id": 44,
                        "type": "string",
                        "node": {
                            "val": "/13/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 13
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 13
                    }
                },
                {
                    "key": {
                        "val": "14",
                        "delim": null
                    },
                    "val": {
                        "id": 47,
                        "type": "string",
                        "node": {
                            "val": "/14/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 14
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 14
                    }
                },
                {
                    "key": {
                        "val": "15",
                        "delim": null
                    },
                    "val": {
                        "id": 50,
                        "type": "string",
                        "node": {
                            "val": "/15/",
                            "delim": null
                        },
                        "attr": {
                            "size": 1,
                            "nodes": [
                                {
                                    "type": "match_rex",
                                    "val": 15
                                }
                            ]
                        },
                        "parent": 54,
                        "path": 15
                    }
                }
            ]
        },
        "attr": {
            "lookup": "0x...",
            "root": {
                "sym": "0",
                "lo": null,
                "eq": {
                    "val": "/0/",
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "1",
                    "lo": null,
                    "eq": {
                        "val": "/1/",
                        "lo": null,
                        "hi": {
                            "sym": "0",
                            "lo": null,
                            "eq": {
                                "val": "/10/",
                                "lo": null,
                                "hi": null
                            },
                            "hi": {
                                "sym": "1",
                                "lo": null,
                                "eq": {
                                    "val": "/11/",
                                    "lo": null,
                                    "hi": null
                                },
                                "hi": {
                                    "sym": "2",
                                    "lo": null,
                                    "eq": {
                                        "val": "/12/",
                                        "lo": null,
                                        "hi": null
                                    },
                                    "hi": {
                                        "sym": "3",
                                        "lo": null,
                                        "eq": {
                                            "val": "/13/",
                                            "lo": null,
                                            "hi": null
                                        },
                                        "hi": {
                                            "sym": "4",
                                            "lo": null,
                                            "eq": {
                                                "val": "/14/",
                                                "lo": null,
                                                "hi": null
                                            },
                                            "hi": {
                                                "sym": "5",
                                                "lo": null,
                                                "eq": {
                                                    "val": "/15/",
                                                    "lo": null,
                                                    "hi": null
                                                },
                                                "hi": null
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    "hi": {
                        "sym": "2",
                        "lo": null,
                        "eq": {
                            "val": "/2/",
                            "lo": null,
                            "hi": null
                        },
                        "hi": {
                            "sym": "3",
                            "lo": null,
                            "eq": {
                                "val": "/3/",
                                "lo": null,
                                "hi": null
                            },
                            "hi": {
                                "sym": "4",
                                "lo": null,
                                "eq": {
                                    "val": "/4/",
                                    "lo": null,
                                    "hi": null
                                },
                                "hi": {
                                    "sym": "5",
                                    "lo": null,
                                    "eq": {
                                        "val": "/5/",
                                        "lo": null,
                                        "hi": null
                                    },
                                    "hi": {
                                        "sym": "6",
                                        "lo": null,
                                        "eq": {
                                            "val": "/6/",
                                            "lo": null,
                                            "hi": null
                                        },
                                        "hi": {
                                            "sym": "7",
                                            "lo": null,
                                            "eq": {
                                                "val": "/7/",
                                                "lo": null,
                                                "hi": null
                                            },
                                            "hi": {
                                                "sym": "8",
                                                "lo": null,
                                                "eq": {
                                                    "val": "/8/",
                                                    "lo": null,
                                                    "hi": null
                                                },
                                                "hi": {
                                                    "sym": "9",
                                                    "lo": null,
                                                    "eq": {
                                                        "val": "/9/",
                                                        "lo": null,
                                                        "hi": null
                                                    },
                                                    "hi": null
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        },
        "parent": null,
        "path": null
    }
}
$ diff-litex -1
--- 16
+++ 1
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 1,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -9,66 +9,6 @@
             {
                 "text": "0",
                 "opts": ""
-            },
-            {
-                "text": "1",
-                "opts": ""
-            },
-            {
-                "text": "2",
-                "opts": ""
-            },
-            {
-                "text": "3",
-                "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -112,7 +52,7 @@
                         "id": 8,
                         "type": "string",
                         "node": {
-                            "val": "/1/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -120,7 +60,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 1
+                                    "val": 0
                                 }
                             ]
                         },
@@ -137,7 +77,7 @@
                         "id": 11,
                         "type": "string",
                         "node": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -145,7 +85,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 2
+                                    "val": 0
                                 }
                             ]
                         },
@@ -162,7 +102,7 @@
                         "id": 14,
                         "type": "string",
                         "node": {
-                            "val": "/3/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -170,7 +110,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 3
+                                    "val": 0
                                 }
                             ]
                         },
@@ -187,7 +127,7 @@
                         "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -195,7 +135,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 0
                                 }
                             ]
                         },
@@ -212,7 +152,7 @@
                         "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -220,7 +160,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 0
                                 }
                             ]
                         },
@@ -237,7 +177,7 @@
                         "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,7 +185,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
@@ -262,7 +202,7 @@
                         "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -270,7 +210,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 0
                                 }
                             ]
                         },
@@ -287,7 +227,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +235,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
@@ -312,7 +252,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +260,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 0
                                 }
                             ]
                         },
@@ -337,7 +277,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +285,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
@@ -362,7 +302,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +310,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 0
                                 }
                             ]
                         },
@@ -387,7 +327,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +335,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
@@ -412,7 +352,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +360,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 0
                                 }
                             ]
                         },
@@ -437,7 +377,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +385,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
@@ -462,7 +402,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +410,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
@@ -494,13 +434,13 @@
                     "sym": "1",
                     "lo": null,
                     "eq": {
-                        "val": "/1/",
+                        "val": "/0/",
                         "lo": null,
                         "hi": {
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +448,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +456,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +464,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +472,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +480,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -556,7 +496,7 @@
                         "sym": "2",
                         "lo": null,
                         "eq": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "lo": null,
                             "hi": null
                         },
@@ -564,7 +504,7 @@
                             "sym": "3",
                             "lo": null,
                             "eq": {
-                                "val": "/3/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -572,7 +512,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +520,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +528,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +536,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +544,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +552,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/0/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -2
--- 16
+++ 2
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 2,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -13,62 +13,6 @@
             {
                 "text": "1",
                 "opts": ""
-            },
-            {
-                "text": "2",
-                "opts": ""
-            },
-            {
-                "text": "3",
-                "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -137,7 +81,7 @@
                         "id": 11,
                         "type": "string",
                         "node": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -145,7 +89,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 2
+                                    "val": 0
                                 }
                             ]
                         },
@@ -162,7 +106,7 @@
                         "id": 14,
                         "type": "string",
                         "node": {
-                            "val": "/3/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -170,7 +114,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 3
+                                    "val": 1
                                 }
                             ]
                         },
@@ -187,7 +131,7 @@
                         "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -195,7 +139,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 0
                                 }
                             ]
                         },
@@ -212,7 +156,7 @@
                         "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -220,7 +164,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 1
                                 }
                             ]
                         },
@@ -237,7 +181,7 @@
                         "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,7 +189,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
@@ -262,7 +206,7 @@
                         "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -270,7 +214,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 1
                                 }
                             ]
                         },
@@ -287,7 +231,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +239,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
@@ -312,7 +256,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +264,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 1
                                 }
                             ]
                         },
@@ -337,7 +281,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +289,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
@@ -362,7 +306,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +314,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 1
                                 }
                             ]
                         },
@@ -387,7 +331,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +339,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
@@ -412,7 +356,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +364,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
@@ -437,7 +381,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +389,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
@@ -462,7 +406,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +414,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 1
                                 }
                             ]
                         },
@@ -500,7 +444,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +452,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +460,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +468,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +476,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +484,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -556,7 +500,7 @@
                         "sym": "2",
                         "lo": null,
                         "eq": {
-                            "val": "/2/",
+                            "val": "/0/",
                             "lo": null,
                             "hi": null
                         },
@@ -564,7 +508,7 @@
                             "sym": "3",
                             "lo": null,
                             "eq": {
-                                "val": "/3/",
+                                "val": "/1/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -572,7 +516,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +524,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/1/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +532,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +540,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +548,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +556,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/1/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -3
--- 16
+++ 3
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 3,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -17,58 +17,6 @@
             {
                 "text": "2",
                 "opts": ""
-            },
-            {
-                "text": "3",
-                "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -162,7 +110,7 @@
                         "id": 14,
                         "type": "string",
                         "node": {
-                            "val": "/3/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -170,7 +118,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 3
+                                    "val": 0
                                 }
                             ]
                         },
@@ -187,7 +135,7 @@
                         "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -195,7 +143,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 1
                                 }
                             ]
                         },
@@ -212,7 +160,7 @@
                         "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -220,7 +168,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 2
                                 }
                             ]
                         },
@@ -237,7 +185,7 @@
                         "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,7 +193,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
@@ -262,7 +210,7 @@
                         "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -270,7 +218,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 1
                                 }
                             ]
                         },
@@ -287,7 +235,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +243,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 2
                                 }
                             ]
                         },
@@ -312,7 +260,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +268,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 0
                                 }
                             ]
                         },
@@ -337,7 +285,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +293,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 1
                                 }
                             ]
                         },
@@ -362,7 +310,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +318,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 2
                                 }
                             ]
                         },
@@ -387,7 +335,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +343,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
@@ -412,7 +360,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +368,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
@@ -437,7 +385,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +393,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
@@ -462,7 +410,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +418,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
@@ -500,7 +448,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/1/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +456,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/2/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +464,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +472,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +480,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +488,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -564,7 +512,7 @@
                             "sym": "3",
                             "lo": null,
                             "eq": {
-                                "val": "/3/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -572,7 +520,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +528,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/2/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +536,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +544,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +552,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/2/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +560,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/0/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -4
--- 16
+++ 4
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 4,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -21,54 +21,6 @@
             {
                 "text": "3",
                 "opts": ""
-            },
-            {
-                "text": "4",
-                "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -187,7 +139,7 @@
                         "id": 17,
                         "type": "string",
                         "node": {
-                            "val": "/4/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -195,7 +147,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 4
+                                    "val": 0
                                 }
                             ]
                         },
@@ -212,7 +164,7 @@
                         "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -220,7 +172,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 1
                                 }
                             ]
                         },
@@ -237,7 +189,7 @@
                         "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -245,7 +197,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 2
                                 }
                             ]
                         },
@@ -262,7 +214,7 @@
                         "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -270,7 +222,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 3
                                 }
                             ]
                         },
@@ -287,7 +239,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +247,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
@@ -312,7 +264,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +272,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 1
                                 }
                             ]
                         },
@@ -337,7 +289,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +297,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 2
                                 }
                             ]
                         },
@@ -362,7 +314,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +322,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 3
                                 }
                             ]
                         },
@@ -387,7 +339,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +347,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
@@ -412,7 +364,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +372,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
@@ -437,7 +389,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +397,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
@@ -462,7 +414,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +422,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 3
                                 }
                             ]
                         },
@@ -500,7 +452,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/2/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +460,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/3/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +468,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +476,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +484,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +492,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -572,7 +524,7 @@
                                 "sym": "4",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/4/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -580,7 +532,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/1/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +540,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/2/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +548,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/3/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +556,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +564,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/1/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -5
--- 16
+++ 5
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 5,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -25,50 +25,6 @@
             {
                 "text": "4",
                 "opts": ""
-            },
-            {
-                "text": "5",
-                "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -212,7 +168,7 @@
                         "id": 20,
                         "type": "string",
                         "node": {
-                            "val": "/5/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -220,7 +176,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 5
+                                    "val": 0
                                 }
                             ]
                         },
@@ -237,7 +193,7 @@
                         "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -245,7 +201,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 1
                                 }
                             ]
                         },
@@ -262,7 +218,7 @@
                         "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -270,7 +226,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 2
                                 }
                             ]
                         },
@@ -287,7 +243,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +251,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 3
                                 }
                             ]
                         },
@@ -312,7 +268,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +276,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 4
                                 }
                             ]
                         },
@@ -337,7 +293,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +301,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
@@ -362,7 +318,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +326,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 1
                                 }
                             ]
                         },
@@ -387,7 +343,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +351,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 2
                                 }
                             ]
                         },
@@ -412,7 +368,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +376,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 3
                                 }
                             ]
                         },
@@ -437,7 +393,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +401,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 4
                                 }
                             ]
                         },
@@ -462,7 +418,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +426,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
@@ -500,7 +456,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +464,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +472,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/2/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +480,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/3/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +488,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/4/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +496,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -580,7 +536,7 @@
                                     "sym": "5",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/5/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -588,7 +544,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +552,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +560,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +568,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/4/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -6
--- 16
+++ 6
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 6,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -29,46 +29,6 @@
             {
                 "text": "5",
                 "opts": ""
-            },
-            {
-                "text": "6",
-                "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -237,7 +197,7 @@
                         "id": 23,
                         "type": "string",
                         "node": {
-                            "val": "/6/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -245,7 +205,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 6
+                                    "val": 0
                                 }
                             ]
                         },
@@ -262,7 +222,7 @@
                         "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -270,7 +230,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 1
                                 }
                             ]
                         },
@@ -287,7 +247,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +255,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 2
                                 }
                             ]
                         },
@@ -312,7 +272,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +280,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 3
                                 }
                             ]
                         },
@@ -337,7 +297,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +305,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 4
                                 }
                             ]
                         },
@@ -362,7 +322,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +330,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 5
                                 }
                             ]
                         },
@@ -387,7 +347,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +355,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
@@ -412,7 +372,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +380,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
@@ -437,7 +397,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +405,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
@@ -462,7 +422,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +430,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 3
                                 }
                             ]
                         },
@@ -500,7 +460,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/4/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +468,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/5/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +476,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +484,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +492,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +500,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -588,7 +548,7 @@
                                         "sym": "6",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/6/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -596,7 +556,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +564,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/2/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +572,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/3/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -7
--- 16
+++ 7
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 7,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -33,42 +33,6 @@
             {
                 "text": "6",
                 "opts": ""
-            },
-            {
-                "text": "7",
-                "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -262,7 +226,7 @@
                         "id": 26,
                         "type": "string",
                         "node": {
-                            "val": "/7/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -270,7 +234,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 7
+                                    "val": 0
                                 }
                             ]
                         },
@@ -287,7 +251,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +259,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 1
                                 }
                             ]
                         },
@@ -312,7 +276,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +284,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 2
                                 }
                             ]
                         },
@@ -337,7 +301,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +309,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 3
                                 }
                             ]
                         },
@@ -362,7 +326,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +334,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 4
                                 }
                             ]
                         },
@@ -387,7 +351,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +359,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 5
                                 }
                             ]
                         },
@@ -412,7 +376,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/6/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +384,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 6
                                 }
                             ]
                         },
@@ -437,7 +401,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +409,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
@@ -462,7 +426,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +434,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 1
                                 }
                             ]
                         },
@@ -500,7 +464,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/3/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +472,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/4/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +480,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/5/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +488,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/6/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +496,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +504,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -596,7 +560,7 @@
                                             "sym": "7",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/7/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -604,7 +568,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +576,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/2/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -8
--- 16
+++ 8
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 8,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -37,38 +37,6 @@
             {
                 "text": "7",
                 "opts": ""
-            },
-            {
-                "text": "8",
-                "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -287,7 +255,7 @@
                         "id": 29,
                         "type": "string",
                         "node": {
-                            "val": "/8/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -295,7 +263,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 8
+                                    "val": 0
                                 }
                             ]
                         },
@@ -312,7 +280,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +288,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 1
                                 }
                             ]
                         },
@@ -337,7 +305,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +313,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 2
                                 }
                             ]
                         },
@@ -362,7 +330,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +338,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 3
                                 }
                             ]
                         },
@@ -387,7 +355,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +363,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 4
                                 }
                             ]
                         },
@@ -412,7 +380,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +388,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 5
                                 }
                             ]
                         },
@@ -437,7 +405,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/6/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +413,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 6
                                 }
                             ]
                         },
@@ -462,7 +430,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/7/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +438,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 7
                                 }
                             ]
                         },
@@ -500,7 +468,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/2/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +476,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/3/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +484,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/4/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +492,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/5/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +500,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/6/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +508,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/7/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -604,7 +572,7 @@
                                                 "sym": "8",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/8/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +580,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/1/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -9
--- 16
+++ 9
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 9,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -41,34 +41,6 @@
             {
                 "text": "8",
                 "opts": ""
-            },
-            {
-                "text": "9",
-                "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -312,7 +284,7 @@
                         "id": 32,
                         "type": "string",
                         "node": {
-                            "val": "/9/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -320,7 +292,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 9
+                                    "val": 0
                                 }
                             ]
                         },
@@ -337,7 +309,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +317,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 1
                                 }
                             ]
                         },
@@ -362,7 +334,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +342,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 2
                                 }
                             ]
                         },
@@ -387,7 +359,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +367,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 3
                                 }
                             ]
                         },
@@ -412,7 +384,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +392,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 4
                                 }
                             ]
                         },
@@ -437,7 +409,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +417,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 5
                                 }
                             ]
                         },
@@ -462,7 +434,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/6/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +442,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 6
                                 }
                             ]
                         },
@@ -500,7 +472,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/1/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +480,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/2/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +488,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/3/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +496,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/4/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +504,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/5/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +512,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/6/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
@@ -612,7 +584,7 @@
                                                     "sym": "9",
                                                     "lo": null,
                                                     "eq": {
-                                                        "val": "/9/",
+                                                        "val": "/0/",
                                                         "lo": null,
                                                         "hi": null
                                                     },
$ diff-litex -10
--- 16
+++ 10
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 10,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -45,30 +45,6 @@
             {
                 "text": "9",
                 "opts": ""
-            },
-            {
-                "text": "10",
-                "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -337,7 +313,7 @@
                         "id": 35,
                         "type": "string",
                         "node": {
-                            "val": "/10/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -345,7 +321,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 10
+                                    "val": 0
                                 }
                             ]
                         },
@@ -362,7 +338,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +346,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 1
                                 }
                             ]
                         },
@@ -387,7 +363,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +371,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 2
                                 }
                             ]
                         },
@@ -412,7 +388,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +396,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 3
                                 }
                             ]
                         },
@@ -437,7 +413,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +421,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 4
                                 }
                             ]
                         },
@@ -462,7 +438,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/5/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +446,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 5
                                 }
                             ]
                         },
@@ -500,7 +476,7 @@
                             "sym": "0",
                             "lo": null,
                             "eq": {
-                                "val": "/10/",
+                                "val": "/0/",
                                 "lo": null,
                                 "hi": null
                             },
@@ -508,7 +484,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/1/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +492,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/2/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +500,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/3/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +508,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/4/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +516,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/5/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -11
--- 16
+++ 11
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 11,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -49,26 +49,6 @@
             {
                 "text": "10",
                 "opts": ""
-            },
-            {
-                "text": "11",
-                "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -362,7 +342,7 @@
                         "id": 38,
                         "type": "string",
                         "node": {
-                            "val": "/11/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -370,7 +350,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 11
+                                    "val": 0
                                 }
                             ]
                         },
@@ -387,7 +367,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +375,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 1
                                 }
                             ]
                         },
@@ -412,7 +392,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +400,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 2
                                 }
                             ]
                         },
@@ -437,7 +417,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +425,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 3
                                 }
                             ]
                         },
@@ -462,7 +442,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/4/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +450,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 4
                                 }
                             ]
                         },
@@ -508,7 +488,7 @@
                                 "sym": "1",
                                 "lo": null,
                                 "eq": {
-                                    "val": "/11/",
+                                    "val": "/0/",
                                     "lo": null,
                                     "hi": null
                                 },
@@ -516,7 +496,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/1/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +504,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/2/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +512,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/3/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +520,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/4/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -12
--- 16
+++ 12
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 12,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -53,22 +53,6 @@
             {
                 "text": "11",
                 "opts": ""
-            },
-            {
-                "text": "12",
-                "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -387,7 +371,7 @@
                         "id": 41,
                         "type": "string",
                         "node": {
-                            "val": "/12/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -395,7 +379,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 12
+                                    "val": 0
                                 }
                             ]
                         },
@@ -412,7 +396,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +404,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 1
                                 }
                             ]
                         },
@@ -437,7 +421,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +429,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 2
                                 }
                             ]
                         },
@@ -462,7 +446,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/3/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +454,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 3
                                 }
                             ]
                         },
@@ -516,7 +500,7 @@
                                     "sym": "2",
                                     "lo": null,
                                     "eq": {
-                                        "val": "/12/",
+                                        "val": "/0/",
                                         "lo": null,
                                         "hi": null
                                     },
@@ -524,7 +508,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/1/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +516,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/2/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +524,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/3/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -13
--- 16
+++ 13
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 13,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -57,18 +57,6 @@
             {
                 "text": "12",
                 "opts": ""
-            },
-            {
-                "text": "13",
-                "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -412,7 +400,7 @@
                         "id": 44,
                         "type": "string",
                         "node": {
-                            "val": "/13/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -420,7 +408,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 13
+                                    "val": 0
                                 }
                             ]
                         },
@@ -437,7 +425,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +433,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 1
                                 }
                             ]
                         },
@@ -462,7 +450,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/2/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +458,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 2
                                 }
                             ]
                         },
@@ -524,7 +512,7 @@
                                         "sym": "3",
                                         "lo": null,
                                         "eq": {
-                                            "val": "/13/",
+                                            "val": "/0/",
                                             "lo": null,
                                             "hi": null
                                         },
@@ -532,7 +520,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/1/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +528,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/2/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -14
--- 16
+++ 14
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 14,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -61,14 +61,6 @@
             {
                 "text": "13",
                 "opts": ""
-            },
-            {
-                "text": "14",
-                "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -437,7 +429,7 @@
                         "id": 47,
                         "type": "string",
                         "node": {
-                            "val": "/14/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -445,7 +437,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 14
+                                    "val": 0
                                 }
                             ]
                         },
@@ -462,7 +454,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/1/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +462,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 1
                                 }
                             ]
                         },
@@ -532,7 +524,7 @@
                                             "sym": "4",
                                             "lo": null,
                                             "eq": {
-                                                "val": "/14/",
+                                                "val": "/0/",
                                                 "lo": null,
                                                 "hi": null
                                             },
@@ -540,7 +532,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/1/",
                                                     "lo": null,
                                                     "hi": null
                                                 },
$ diff-litex -15
--- 16
+++ 15
@@ -1,6 +1,6 @@
 {
     "rexes": {
-        "size": 16,
+        "size": 15,
         "codes": {
             "type": "patterns",
             "code": {}
@@ -65,10 +65,6 @@
             {
                 "text": "14",
                 "opts": ""
-            },
-            {
-                "text": "15",
-                "opts": ""
             }
         ]
     },
@@ -462,7 +458,7 @@
                         "id": 50,
                         "type": "string",
                         "node": {
-                            "val": "/15/",
+                            "val": "/0/",
                             "delim": null
                         },
                         "attr": {
@@ -470,7 +466,7 @@
                             "nodes": [
                                 {
                                     "type": "match_rex",
-                                    "val": 15
+                                    "val": 0
                                 }
                             ]
                         },
@@ -540,7 +536,7 @@
                                                 "sym": "5",
                                                 "lo": null,
                                                 "eq": {
-                                                    "val": "/15/",
+                                                    "val": "/0/",
                                                     "lo": null,
                                                     "hi": null
                                                 },'
) -L rex-dup.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '\''{'\''; for((i=0;i<n;i++));do printf '\''"%s":"/%s/"'\'' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '\''}'\''; }'
gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '{'; for((i=0;i<n;i++));do printf '"%s":"/%s/"' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '}'; } 2>&1 ||
echo 'command failed: gen-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; local m="$((n + 1))"; [[ "$2" =~ ^-[0-9]+$ ]] && m="${2:1}"; local i; echo -n '\''{'\''; for((i=0;i<n;i++));do printf '\''"%s":"/%s/"'\'' $i $((i%m)); [ "$((n - i))" -gt 1 ] && echo -n ","; done; echo '\''}'\''; }'

echo '$ diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; }'
diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; } 2>&1 ||
echo 'command failed: diff-litex() { local n=16; [[ "$1" =~ ^-[0-9]+$ ]] && n="${1:1}"; diff -u -L16 <(json-litex -d "$(gen-litex -16 -16)") -L$n <(json-litex -d "$(gen-litex -16 -$n)"); true; }'

echo '$ json-litex -d "$(gen-litex -16)"'
json-litex -d "$(gen-litex -16)" 2>&1 ||
echo 'command failed: json-litex -d "$(gen-litex -16)"'

echo '$ diff-litex -1'
diff-litex -1 2>&1 ||
echo 'command failed: diff-litex -1'

echo '$ diff-litex -2'
diff-litex -2 2>&1 ||
echo 'command failed: diff-litex -2'

echo '$ diff-litex -3'
diff-litex -3 2>&1 ||
echo 'command failed: diff-litex -3'

echo '$ diff-litex -4'
diff-litex -4 2>&1 ||
echo 'command failed: diff-litex -4'

echo '$ diff-litex -5'
diff-litex -5 2>&1 ||
echo 'command failed: diff-litex -5'

echo '$ diff-litex -6'
diff-litex -6 2>&1 ||
echo 'command failed: diff-litex -6'

echo '$ diff-litex -7'
diff-litex -7 2>&1 ||
echo 'command failed: diff-litex -7'

echo '$ diff-litex -8'
diff-litex -8 2>&1 ||
echo 'command failed: diff-litex -8'

echo '$ diff-litex -9'
diff-litex -9 2>&1 ||
echo 'command failed: diff-litex -9'

echo '$ diff-litex -10'
diff-litex -10 2>&1 ||
echo 'command failed: diff-litex -10'

echo '$ diff-litex -11'
diff-litex -11 2>&1 ||
echo 'command failed: diff-litex -11'

echo '$ diff-litex -12'
diff-litex -12 2>&1 ||
echo 'command failed: diff-litex -12'

echo '$ diff-litex -13'
diff-litex -13 2>&1 ||
echo 'command failed: diff-litex -13'

echo '$ diff-litex -14'
diff-litex -14 2>&1 ||
echo 'command failed: diff-litex -14'

echo '$ diff-litex -15'
diff-litex -15 2>&1 ||
echo 'command failed: diff-litex -15'
)

