#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-flat:op4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L op4.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ test-expr '\''a <= (b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''a <= (b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''a <= (b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''a <= (b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''a <= (b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''a <= (b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''a >= (b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''a >= (b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''a >= (b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''a >= (b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''a >= (b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''a >= (b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''a == (b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''a == (b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''a == (b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''a == (b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''a == (b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''a == (b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''a != (b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''a != (b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''a != (b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''a != (b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''a != (b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''a != (b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''a && (b <= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''a && (b >= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''a && (b == c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''a && (b != c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''a && (b && c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a && (b || c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a || (b <= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''a || (b >= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''a || (b == c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''a || (b != c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''a || (b && c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a || (b || c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a <= (b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''a <= (b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''a <= (b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''a <= (b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''a <= (b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a <= (b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a >= (b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''a >= (b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''a >= (b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''a >= (b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''a >= (b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a >= (b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a == (b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''a == (b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''a == (b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''a == (b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''a == (b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a == (b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a != (b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''a != (b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''a != (b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''a != (b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''a != (b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a != (b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a && (b <= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a && (b >= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a && (b == C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a && (b != C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a && (b && C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''a && (b || C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''a || (b <= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a || (b >= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a || (b == C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a || (b != C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a || (b && C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''a || (b || C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''a <= (b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a <= (b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a >= (b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a >= (b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a == (b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a == (b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a != (b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a != (b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (b <= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a && (b >= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a && (b == !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a && (b != !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (b && !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a && (b || !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a || (b <= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a || (b >= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a || (b == !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a || (b != !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a || (b && !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a || (b || !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a <= (b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a <= (b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a >= (b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a >= (b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a == (b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a == (b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a != (b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a != (b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (b <= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a && (b >= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a && (b == !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a && (b != !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (b && !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a && (b || !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a || (b <= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a || (b >= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a || (b == !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a || (b != !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a || (b && !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a || (b || !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a <= (B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''a <= (B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''a <= (B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''a <= (B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''a <= (B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''a <= (B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''a >= (B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''a >= (B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''a >= (B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''a >= (B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''a >= (B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''a >= (B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''a == (B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''a == (B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''a == (B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''a == (B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''a == (B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''a == (B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''a != (B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''a != (B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''a != (B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''a != (B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''a != (B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''a != (B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''a && (B <= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''a && (B >= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''a && (B == c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''a && (B != c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''a && (B && c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a && (B || c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a || (B <= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''a || (B >= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''a || (B == c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''a || (B != c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''a || (B && c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a || (B || c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''a <= (B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''a <= (B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''a <= (B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''a <= (B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''a <= (B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a <= (B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a >= (B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''a >= (B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''a >= (B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''a >= (B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''a >= (B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a >= (B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a == (B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''a == (B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''a == (B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''a == (B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''a == (B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a == (B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a != (B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''a != (B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''a != (B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''a != (B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''a != (B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a != (B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a && (B <= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a && (B >= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a && (B == C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a && (B != C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a && (B && C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''a && (B || C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''a || (B <= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''a || (B >= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''a || (B == C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''a || (B != C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''a || (B && C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''a || (B || C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''a <= (B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a <= (B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a >= (B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a >= (B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a == (B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a == (B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a != (B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a != (B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (B <= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a && (B >= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a && (B == !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a && (B != !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (B && !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a && (B || !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a || (B <= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a || (B >= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a || (B == !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a || (B != !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a || (B && !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a || (B || !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''a <= (B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a <= (B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a >= (B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a >= (B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a == (B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a == (B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a != (B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a != (B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (B <= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a && (B >= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a && (B == !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a && (B != !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a && (B && !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a && (B || !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a || (B <= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''a || (B >= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''a || (B == !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''a || (B != !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''a || (B && !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a || (B || !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''a <= (!b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (!b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (!b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (!b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (!b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''a <= (!b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''a >= (!b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (!b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (!b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (!b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (!b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''a >= (!b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''a == (!b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (!b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (!b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (!b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (!b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''a == (!b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''a != (!b <= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (!b >= c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (!b == c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (!b != c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (!b && c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''a != (!b || c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''a && (!b <= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''a && (!b >= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''a && (!b == c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''a && (!b != c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''a && (!b && c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a && (!b || c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a || (!b <= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''a || (!b >= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''a || (!b == c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''a || (!b != c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''a || (!b && c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a || (!b || c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a <= (!b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (!b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (!b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (!b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (!b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a <= (!b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a >= (!b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (!b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (!b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (!b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (!b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a >= (!b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a == (!b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (!b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (!b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (!b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (!b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a == (!b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a != (!b <= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (!b >= C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (!b == C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (!b != C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (!b && C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a != (!b || C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a && (!b <= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a && (!b >= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a && (!b == C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a && (!b != C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a && (!b && C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''a && (!b || C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''a || (!b <= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a || (!b >= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a || (!b == C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a || (!b != C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a || (!b && C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''a || (!b || C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''a <= (!b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''a <= (!b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''a <= (!b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''a <= (!b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''a <= (!b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a <= (!b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a >= (!b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''a >= (!b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''a >= (!b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''a >= (!b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (!b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a >= (!b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a == (!b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''a == (!b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''a == (!b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''a == (!b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''a == (!b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a == (!b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a != (!b <= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''a != (!b >= !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''a != (!b == !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''a != (!b != !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''a != (!b && !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a != (!b || !c)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!b <= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a && (!b >= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a && (!b == !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a && (!b != !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!b && !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a && (!b || !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a || (!b <= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a || (!b >= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a || (!b == !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a || (!b != !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a || (!b && !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a || (!b || !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a <= (!b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''a <= (!b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''a <= (!b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''a <= (!b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''a <= (!b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a <= (!b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a >= (!b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''a >= (!b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''a >= (!b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''a >= (!b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (!b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a >= (!b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a == (!b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''a == (!b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''a == (!b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''a == (!b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''a == (!b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a == (!b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a != (!b <= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''a != (!b >= !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''a != (!b == !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''a != (!b != !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''a != (!b && !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a != (!b || !C)'\''
0 call_builtin(a)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!b <= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a && (!b >= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a && (!b == !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a && (!b != !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!b && !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''a && (!b || !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''a || (!b <= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a || (!b >= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a || (!b == !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a || (!b != !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a || (!b && !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''a || (!b || !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''a <= (!B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (!B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (!B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (!B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (!B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''a <= (!B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''a >= (!B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (!B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (!B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (!B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (!B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''a >= (!B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''a == (!B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (!B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (!B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (!B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (!B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''a == (!B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''a != (!B <= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (!B >= c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (!B == c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (!B != c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (!B && c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''a != (!B || c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''a && (!B <= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''a && (!B >= c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''a && (!B == c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''a && (!B != c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''a && (!B && c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a && (!B || c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a || (!B <= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''a || (!B >= c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''a || (!B == c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''a || (!B != c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''a || (!B && c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a || (!B || c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''a <= (!B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''a <= (!B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''a <= (!B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''a <= (!B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''a <= (!B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a <= (!B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a >= (!B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''a >= (!B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''a >= (!B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''a >= (!B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''a >= (!B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a >= (!B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a == (!B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''a == (!B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''a == (!B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''a == (!B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''a == (!B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a == (!B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a != (!B <= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''a != (!B >= C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''a != (!B == C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''a != (!B != C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''a != (!B && C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a != (!B || C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a && (!B <= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a && (!B >= C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a && (!B == C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a && (!B != C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a && (!B && C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''a && (!B || C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''a || (!B <= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''a || (!B >= C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''a || (!B == C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''a || (!B != C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''a || (!B && C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''a || (!B || C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''a <= (!B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''a <= (!B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''a <= (!B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''a <= (!B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''a <= (!B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a <= (!B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a >= (!B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''a >= (!B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''a >= (!B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''a >= (!B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (!B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a >= (!B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a == (!B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''a == (!B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''a == (!B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''a == (!B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''a == (!B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a == (!B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a != (!B <= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''a != (!B >= !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''a != (!B == !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''a != (!B != !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''a != (!B && !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a != (!B || !c)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!B <= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a && (!B >= !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a && (!B == !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a && (!B != !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!B && !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a && (!B || !c)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a || (!B <= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a || (!B >= !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a || (!B == !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a || (!B != !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a || (!B && !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a || (!B || !c)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''a <= (!B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''a <= (!B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''a <= (!B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''a <= (!B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''a <= (!B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a <= (!B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a >= (!B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''a >= (!B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''a >= (!B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''a >= (!B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (!B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a >= (!B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a == (!B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''a == (!B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''a == (!B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''a == (!B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''a == (!B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a == (!B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a != (!B <= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''a != (!B >= !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''a != (!B == !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''a != (!B != !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''a != (!B && !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a != (!B || !C)'\''
0 call_builtin(a)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!B <= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a && (!B >= !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a && (!B == !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a && (!B != !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a && (!B && !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''a && (!B || !C)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''a || (!B <= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''a || (!B >= !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''a || (!B == !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''a || (!B != !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''a || (!B && !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''a || (!B || !C)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A <= (b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''A <= (b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''A <= (b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''A <= (b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''A <= (b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''A <= (b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''A >= (b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''A >= (b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''A >= (b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''A >= (b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''A >= (b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''A >= (b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''A == (b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''A == (b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''A == (b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''A == (b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''A == (b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''A == (b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''A != (b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''A != (b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''A != (b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''A != (b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''A != (b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''A != (b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''A && (b <= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''A && (b >= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''A && (b == c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''A && (b != c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''A && (b && c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A && (b || c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A || (b <= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''A || (b >= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''A || (b == c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''A || (b != c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''A || (b && c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A || (b || c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A <= (b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''A <= (b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''A <= (b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''A <= (b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''A <= (b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A <= (b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A >= (b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''A >= (b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''A >= (b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''A >= (b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''A >= (b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A >= (b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A == (b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''A == (b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''A == (b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''A == (b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''A == (b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A == (b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A != (b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''A != (b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''A != (b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''A != (b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''A != (b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A != (b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A && (b <= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A && (b >= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A && (b == C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A && (b != C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A && (b && C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''A && (b || C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''A || (b <= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A || (b >= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A || (b == C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A || (b != C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A || (b && C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''A || (b || C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''A <= (b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A <= (b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A >= (b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A >= (b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A == (b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A == (b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A != (b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A != (b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (b <= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A && (b >= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A && (b == !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A && (b != !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (b && !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A && (b || !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A || (b <= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A || (b >= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A || (b == !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A || (b != !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A || (b && !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A || (b || !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A <= (b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A <= (b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A >= (b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A >= (b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A == (b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A == (b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A != (b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A != (b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (b <= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A && (b >= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A && (b == !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A && (b != !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (b && !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A && (b || !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A || (b <= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A || (b >= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A || (b == !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A || (b != !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A || (b && !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A || (b || !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A <= (B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''A <= (B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''A <= (B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''A <= (B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''A <= (B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''A <= (B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(le)
$ test-expr '\''A >= (B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''A >= (B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''A >= (B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''A >= (B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''A >= (B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''A >= (B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
$ test-expr '\''A == (B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''A == (B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''A == (B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''A == (B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''A == (B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''A == (B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(eq)
$ test-expr '\''A != (B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''A != (B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''A != (B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''A != (B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''A != (B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''A != (B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
$ test-expr '\''A && (B <= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''A && (B >= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''A && (B == c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''A && (B != c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''A && (B && c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A && (B || c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A || (B <= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
$ test-expr '\''A || (B >= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
$ test-expr '\''A || (B == c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
$ test-expr '\''A || (B != c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
$ test-expr '\''A || (B && c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A || (B || c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 make_bool()
$ test-expr '\''A <= (B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(le)
$ test-expr '\''A <= (B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(le)
$ test-expr '\''A <= (B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(le)
$ test-expr '\''A <= (B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(le)
$ test-expr '\''A <= (B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A <= (B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A >= (B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ge)
$ test-expr '\''A >= (B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ge)
$ test-expr '\''A >= (B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ge)
$ test-expr '\''A >= (B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
$ test-expr '\''A >= (B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A >= (B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A == (B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(eq)
$ test-expr '\''A == (B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(eq)
$ test-expr '\''A == (B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(eq)
$ test-expr '\''A == (B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(eq)
$ test-expr '\''A == (B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A == (B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A != (B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(le)
4 cmp_op(ne)
$ test-expr '\''A != (B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
$ test-expr '\''A != (B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(eq)
4 cmp_op(ne)
$ test-expr '\''A != (B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ne)
$ test-expr '\''A != (B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A != (B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A && (B <= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A && (B >= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A && (B == C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A && (B != C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A && (B && C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''A && (B || C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''A || (B <= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
$ test-expr '\''A || (B >= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
$ test-expr '\''A || (B == C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
$ test-expr '\''A || (B != C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
$ test-expr '\''A || (B && C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
$ test-expr '\''A || (B || C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
$ test-expr '\''A <= (B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A <= (B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A >= (B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A >= (B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A == (B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A == (B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A != (B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A != (B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (B <= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A && (B >= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A && (B == !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A && (B != !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (B && !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A && (B || !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A || (B <= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A || (B >= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A || (B == !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A || (B != !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A || (B && !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A || (B || !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 not_op()
$ test-expr '\''A <= (B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A <= (B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A >= (B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A >= (B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A == (B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A == (B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A != (B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 not_op()
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A != (B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (B <= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A && (B >= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A && (B == !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A && (B != !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A && (B && !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A && (B || !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A || (B <= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
$ test-expr '\''A || (B >= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
$ test-expr '\''A || (B == !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
$ test-expr '\''A || (B != !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
$ test-expr '\''A || (B && !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A || (B || !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 not_op()
$ test-expr '\''A <= (!b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (!b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (!b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (!b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (!b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''A <= (!b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''A >= (!b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (!b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (!b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (!b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (!b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''A >= (!b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''A == (!b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (!b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (!b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (!b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (!b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''A == (!b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''A != (!b <= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (!b >= c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (!b == c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (!b != c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (!b && c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''A != (!b || c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''A && (!b <= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''A && (!b >= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''A && (!b == c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''A && (!b != c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''A && (!b && c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A && (!b || c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A || (!b <= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''A || (!b >= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''A || (!b == c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''A || (!b != c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''A || (!b && c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A || (!b || c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A <= (!b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (!b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (!b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (!b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (!b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A <= (!b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A >= (!b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (!b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (!b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (!b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (!b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A >= (!b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A == (!b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (!b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (!b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (!b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (!b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A == (!b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A != (!b <= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (!b >= C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (!b == C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (!b != C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (!b && C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A != (!b || C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A && (!b <= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A && (!b >= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A && (!b == C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A && (!b != C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A && (!b && C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''A && (!b || C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''A || (!b <= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A || (!b >= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A || (!b == C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A || (!b != C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A || (!b && C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''A || (!b || C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''A <= (!b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''A <= (!b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''A <= (!b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''A <= (!b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''A <= (!b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A <= (!b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A >= (!b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''A >= (!b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''A >= (!b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''A >= (!b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (!b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A >= (!b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A == (!b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''A == (!b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''A == (!b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''A == (!b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''A == (!b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A == (!b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A != (!b <= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''A != (!b >= !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''A != (!b == !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''A != (!b != !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''A != (!b && !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A != (!b || !c)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!b <= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A && (!b >= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A && (!b == !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A && (!b != !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!b && !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A && (!b || !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A || (!b <= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A || (!b >= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A || (!b == !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A || (!b != !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A || (!b && !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A || (!b || !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A <= (!b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''A <= (!b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''A <= (!b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''A <= (!b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''A <= (!b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A <= (!b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A >= (!b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''A >= (!b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''A >= (!b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''A >= (!b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (!b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A >= (!b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A == (!b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''A == (!b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''A == (!b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''A == (!b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''A == (!b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A == (!b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A != (!b <= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''A != (!b >= !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''A != (!b == !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''A != (!b != !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''A != (!b && !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A != (!b || !C)'\''
0 call_builtin(A)
1 call_builtin(b)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!b <= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A && (!b >= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A && (!b == !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A && (!b != !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!b && !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A && (!b || !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A || (!b <= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A || (!b >= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A || (!b == !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A || (!b != !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A || (!b && !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A || (!b || !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A <= (!B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (!B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (!B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (!B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (!B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''A <= (!B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''A >= (!B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (!B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (!B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (!B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (!B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''A >= (!B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''A == (!B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (!B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (!B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (!B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (!B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''A == (!B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''A != (!B <= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (!B >= c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (!B == c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (!B != c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (!B && c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''A != (!B || c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''A && (!B <= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''A && (!B >= c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''A && (!B == c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''A && (!B != c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''A && (!B && c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A && (!B || c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A || (!B <= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''A || (!B >= c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''A || (!B == c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''A || (!B != c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''A || (!B && c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A || (!B || c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''A <= (!B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''A <= (!B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''A <= (!B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''A <= (!B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''A <= (!B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A <= (!B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A >= (!B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''A >= (!B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''A >= (!B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''A >= (!B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''A >= (!B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A >= (!B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A == (!B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''A == (!B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''A == (!B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''A == (!B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''A == (!B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A == (!B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A != (!B <= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''A != (!B >= C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''A != (!B == C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''A != (!B != C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''A != (!B && C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A != (!B || C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A && (!B <= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A && (!B >= C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A && (!B == C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A && (!B != C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A && (!B && C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''A && (!B || C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''A || (!B <= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''A || (!B >= C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''A || (!B == C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''A || (!B != C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''A || (!B && C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''A || (!B || C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''A <= (!B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''A <= (!B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''A <= (!B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''A <= (!B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''A <= (!B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A <= (!B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A >= (!B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''A >= (!B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''A >= (!B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''A >= (!B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (!B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A >= (!B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A == (!B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''A == (!B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''A == (!B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''A == (!B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''A == (!B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A == (!B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A != (!B <= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''A != (!B >= !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''A != (!B == !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''A != (!B != !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''A != (!B && !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A != (!B || !c)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!B <= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A && (!B >= !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A && (!B == !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A && (!B != !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!B && !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A && (!B || !c)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A || (!B <= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A || (!B >= !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A || (!B == !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A || (!B != !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A || (!B && !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A || (!B || !c)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''A <= (!B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''A <= (!B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''A <= (!B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''A <= (!B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''A <= (!B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A <= (!B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A >= (!B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''A >= (!B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''A >= (!B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''A >= (!B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (!B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A >= (!B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A == (!B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''A == (!B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''A == (!B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''A == (!B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''A == (!B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A == (!B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A != (!B <= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''A != (!B >= !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''A != (!B == !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''A != (!B != !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''A != (!B && !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A != (!B || !C)'\''
0 call_builtin(A)
1 call_builtin(B)
2 not_op()
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!B <= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A && (!B >= !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A && (!B == !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A && (!B != !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A && (!B && !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A && (!B || !C)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A || (!B <= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''A || (!B >= !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''A || (!B == !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''A || (!B != !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''A || (!B && !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''A || (!B || !C)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a <= (b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!a <= (b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!a <= (b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!a <= (b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!a <= (b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!a <= (b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!a >= (b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!a >= (b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!a >= (b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!a >= (b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!a >= (b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!a >= (b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!a == (b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!a == (b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!a == (b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!a == (b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!a == (b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!a == (b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!a != (b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!a != (b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!a != (b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!a != (b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!a != (b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!a != (b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!a && (b <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!a && (b >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!a && (b == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!a && (b != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!a && (b && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a && (b || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a || (b <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!a || (b >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!a || (b == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!a || (b != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!a || (b && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a || (b || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a <= (b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!a <= (b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!a <= (b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!a <= (b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!a <= (b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a <= (b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a >= (b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!a >= (b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!a >= (b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!a >= (b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!a >= (b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a >= (b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a == (b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!a == (b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!a == (b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!a == (b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!a == (b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a == (b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a != (b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!a != (b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!a != (b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!a != (b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!a != (b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a != (b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a && (b <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a && (b >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a && (b == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a && (b != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a && (b && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!a && (b || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!a || (b <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a || (b >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a || (b == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a || (b != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a || (b && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!a || (b || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!a <= (b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a <= (b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a >= (b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a >= (b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a == (b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a == (b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a != (b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a != (b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a && (b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a && (b == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a && (b != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (b && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a && (b || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a || (b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a || (b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a || (b == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a || (b != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a || (b && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a || (b || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a <= (b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a <= (b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a >= (b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a >= (b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a == (b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a == (b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a != (b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a != (b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a && (b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a && (b == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a && (b != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (b && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a && (b || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a || (b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a || (b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a || (b == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a || (b != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a || (b && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a || (b || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a <= (B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!a <= (B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!a <= (B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!a <= (B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!a <= (B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!a <= (B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!a >= (B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!a >= (B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!a >= (B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!a >= (B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!a >= (B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!a >= (B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!a == (B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!a == (B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!a == (B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!a == (B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!a == (B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!a == (B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!a != (B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!a != (B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!a != (B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!a != (B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!a != (B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!a != (B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!a && (B <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!a && (B >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!a && (B == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!a && (B != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!a && (B && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a && (B || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a || (B <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!a || (B >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!a || (B == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!a || (B != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!a || (B && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a || (B || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!a <= (B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!a <= (B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!a <= (B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!a <= (B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!a <= (B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a <= (B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a >= (B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!a >= (B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!a >= (B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!a >= (B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!a >= (B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a >= (B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a == (B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!a == (B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!a == (B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!a == (B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!a == (B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a == (B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a != (B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!a != (B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!a != (B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!a != (B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!a != (B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a != (B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a && (B <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a && (B >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a && (B == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a && (B != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a && (B && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!a && (B || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!a || (B <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!a || (B >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!a || (B == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!a || (B != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!a || (B && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!a || (B || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!a <= (B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a <= (B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a >= (B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a >= (B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a == (B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a == (B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a != (B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a != (B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a && (B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a && (B == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a && (B != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (B && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a && (B || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a || (B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a || (B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a || (B == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a || (B != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a || (B && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a || (B || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!a <= (B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a <= (B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a >= (B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a >= (B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a == (B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a == (B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a != (B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a != (B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a && (B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a && (B == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a && (B != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a && (B && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a && (B || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a || (B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!a || (B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!a || (B == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!a || (B != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!a || (B && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a || (B || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!a <= (!b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (!b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (!b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (!b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (!b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!a <= (!b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!a >= (!b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!a >= (!b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!a == (!b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (!b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (!b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (!b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (!b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!a == (!b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!a != (!b <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (!b >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (!b == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (!b != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (!b && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!a != (!b || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!a && (!b <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!a && (!b >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!a && (!b == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!a && (!b != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!a && (!b && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a && (!b || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a || (!b <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!a || (!b >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!a || (!b == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!a || (!b != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!a || (!b && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a || (!b || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a <= (!b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (!b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (!b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (!b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (!b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a <= (!b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a >= (!b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a >= (!b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a == (!b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (!b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (!b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (!b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (!b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a == (!b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a != (!b <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (!b >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (!b == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (!b != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (!b && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a != (!b || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a && (!b <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a && (!b >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a && (!b == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a && (!b != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a && (!b && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!a && (!b || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!a || (!b <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a || (!b >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a || (!b == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a || (!b != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a || (!b && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!a || (!b || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!a <= (!b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!a <= (!b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!a <= (!b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!a <= (!b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!a <= (!b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a <= (!b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a >= (!b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a >= (!b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a == (!b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!a == (!b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!a == (!b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!a == (!b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!a == (!b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a == (!b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a != (!b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!a != (!b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!a != (!b == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!a != (!b != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!a != (!b && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a != (!b || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a && (!b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a && (!b == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a && (!b != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!b && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a && (!b || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a || (!b <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a || (!b >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a || (!b == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a || (!b != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a || (!b && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a || (!b || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a <= (!b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!a <= (!b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!a <= (!b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!a <= (!b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!a <= (!b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a <= (!b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a >= (!b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!a >= (!b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a >= (!b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a == (!b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!a == (!b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!a == (!b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!a == (!b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!a == (!b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a == (!b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a != (!b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!a != (!b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!a != (!b == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!a != (!b != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!a != (!b && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a != (!b || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a && (!b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a && (!b == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a && (!b != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!b && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!a && (!b || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!a || (!b <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a || (!b >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a || (!b == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a || (!b != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a || (!b && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!a || (!b || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!a <= (!B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (!B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (!B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (!B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (!B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!a <= (!B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!a >= (!B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!a >= (!B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!a == (!B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (!B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (!B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (!B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (!B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!a == (!B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!a != (!B <= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (!B >= c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (!B == c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (!B != c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (!B && c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!a != (!B || c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!a && (!B <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!a && (!B >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!a && (!B == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!a && (!B != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!a && (!B && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a && (!B || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a || (!B <= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!a || (!B >= c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!a || (!B == c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!a || (!B != c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!a || (!B && c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a || (!B || c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!a <= (!B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!a <= (!B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!a <= (!B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!a <= (!B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!a <= (!B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a <= (!B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a >= (!B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a >= (!B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a == (!B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!a == (!B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!a == (!B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!a == (!B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!a == (!B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a == (!B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a != (!B <= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!a != (!B >= C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!a != (!B == C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!a != (!B != C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!a != (!B && C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a != (!B || C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a && (!B <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a && (!B >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a && (!B == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a && (!B != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a && (!B && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!a && (!B || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!a || (!B <= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!a || (!B >= C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!a || (!B == C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!a || (!B != C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!a || (!B && C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!a || (!B || C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!a <= (!B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!a <= (!B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!a <= (!B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!a <= (!B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!a <= (!B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a <= (!B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a >= (!B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a >= (!B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a == (!B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!a == (!B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!a == (!B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!a == (!B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!a == (!B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a == (!B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a != (!B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!a != (!B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!a != (!B == !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!a != (!B != !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!a != (!B && !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a != (!B || !c)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a && (!B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a && (!B == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a && (!B != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!B && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a && (!B || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a || (!B <= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a || (!B >= !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a || (!B == !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a || (!B != !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a || (!B && !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a || (!B || !c)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!a <= (!B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!a <= (!B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!a <= (!B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!a <= (!B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!a <= (!B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a <= (!B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a >= (!B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!a >= (!B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a >= (!B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a == (!B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!a == (!B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!a == (!B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!a == (!B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!a == (!B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a == (!B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a != (!B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!a != (!B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!a != (!B == !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!a != (!B != !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!a != (!B && !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a != (!B || !C)'\''
0 call_builtin(a)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a && (!B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a && (!B == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a && (!B != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a && (!B && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!a && (!B || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!a || (!B <= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!a || (!B >= !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!a || (!B == !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!a || (!B != !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!a || (!B && !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!a || (!B || !C)'\''
0 call_builtin(a)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A <= (b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!A <= (b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!A <= (b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!A <= (b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!A <= (b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!A <= (b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!A >= (b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!A >= (b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!A >= (b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!A >= (b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!A >= (b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!A >= (b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!A == (b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!A == (b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!A == (b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!A == (b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!A == (b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!A == (b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!A != (b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!A != (b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!A != (b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!A != (b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!A != (b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!A != (b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!A && (b <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!A && (b >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!A && (b == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!A && (b != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!A && (b && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A && (b || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A || (b <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!A || (b >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!A || (b == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!A || (b != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!A || (b && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A || (b || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A <= (b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!A <= (b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!A <= (b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!A <= (b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!A <= (b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A <= (b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A >= (b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!A >= (b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!A >= (b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!A >= (b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!A >= (b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A >= (b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A == (b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!A == (b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!A == (b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!A == (b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!A == (b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A == (b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A != (b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!A != (b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!A != (b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!A != (b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!A != (b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A != (b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A && (b <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A && (b >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A && (b == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A && (b != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A && (b && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!A && (b || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!A || (b <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A || (b >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A || (b == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A || (b != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A || (b && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!A || (b || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!A <= (b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A <= (b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A >= (b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A >= (b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A == (b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A == (b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A != (b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A != (b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A && (b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A && (b == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A && (b != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (b && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A && (b || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A || (b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A || (b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A || (b == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A || (b != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A || (b && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A || (b || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A <= (b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A <= (b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A >= (b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A >= (b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A == (b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A == (b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A != (b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A != (b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A && (b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A && (b == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A && (b != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (b && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A && (b || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A || (b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A || (b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A || (b == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A || (b != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A || (b && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A || (b || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A <= (B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!A <= (B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!A <= (B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!A <= (B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!A <= (B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!A <= (B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(le)
$ test-expr '\''!A >= (B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!A >= (B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!A >= (B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!A >= (B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!A >= (B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!A >= (B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ge)
$ test-expr '\''!A == (B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!A == (B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!A == (B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!A == (B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!A == (B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!A == (B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(eq)
$ test-expr '\''!A != (B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!A != (B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!A != (B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!A != (B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!A != (B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!A != (B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 cmp_op(ne)
$ test-expr '\''!A && (B <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!A && (B >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!A && (B == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!A && (B != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!A && (B && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A && (B || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A || (B <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(le)
$ test-expr '\''!A || (B >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ge)
$ test-expr '\''!A || (B == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(eq)
$ test-expr '\''!A || (B != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 cmp_op(ne)
$ test-expr '\''!A || (B && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A || (B || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 make_bool()
$ test-expr '\''!A <= (B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(le)
$ test-expr '\''!A <= (B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(le)
$ test-expr '\''!A <= (B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(le)
$ test-expr '\''!A <= (B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(le)
$ test-expr '\''!A <= (B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A <= (B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A >= (B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ge)
$ test-expr '\''!A >= (B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ge)
$ test-expr '\''!A >= (B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ge)
$ test-expr '\''!A >= (B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ge)
$ test-expr '\''!A >= (B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A >= (B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A == (B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(eq)
$ test-expr '\''!A == (B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(eq)
$ test-expr '\''!A == (B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(eq)
$ test-expr '\''!A == (B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(eq)
$ test-expr '\''!A == (B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A == (B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A != (B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(le)
5 cmp_op(ne)
$ test-expr '\''!A != (B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 cmp_op(ne)
$ test-expr '\''!A != (B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(eq)
5 cmp_op(ne)
$ test-expr '\''!A != (B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 cmp_op(ne)
$ test-expr '\''!A != (B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A != (B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A && (B <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A && (B >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A && (B == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A && (B != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A && (B && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!A && (B || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!A || (B <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(le)
$ test-expr '\''!A || (B >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ge)
$ test-expr '\''!A || (B == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(eq)
$ test-expr '\''!A || (B != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 cmp_op(ne)
$ test-expr '\''!A || (B && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
$ test-expr '\''!A || (B || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
$ test-expr '\''!A <= (B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A <= (B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A >= (B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A >= (B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A == (B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A == (B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A != (B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(c)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A != (B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A && (B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A && (B == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A && (B != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (B && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A && (B || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A || (B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A || (B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A || (B == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A || (B != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A || (B && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A || (B || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(c)
6 not_op()
$ test-expr '\''!A <= (B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A <= (B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A >= (B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A >= (B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A == (B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A == (B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A != (B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 call_builtin(C)
4 not_op()
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A != (B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A && (B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A && (B == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A && (B != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A && (B && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A && (B || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A || (B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
$ test-expr '\''!A || (B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
$ test-expr '\''!A || (B == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
$ test-expr '\''!A || (B != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
$ test-expr '\''!A || (B && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_false(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A || (B || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 jump_true(eos)
5 call_builtin(C)
6 not_op()
$ test-expr '\''!A <= (!b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (!b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (!b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (!b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (!b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!A <= (!b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!A >= (!b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!A >= (!b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!A == (!b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (!b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (!b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (!b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (!b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!A == (!b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!A != (!b <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (!b >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (!b == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (!b != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (!b && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!A != (!b || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!A && (!b <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!A && (!b >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!A && (!b == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!A && (!b != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!A && (!b && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A && (!b || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A || (!b <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!A || (!b >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!A || (!b == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!A || (!b != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!A || (!b && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A || (!b || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A <= (!b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (!b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (!b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (!b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (!b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A <= (!b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A >= (!b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A >= (!b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A == (!b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (!b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (!b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (!b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (!b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A == (!b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A != (!b <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (!b >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (!b == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (!b != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (!b && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A != (!b || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A && (!b <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A && (!b >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A && (!b == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A && (!b != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A && (!b && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!A && (!b || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!A || (!b <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A || (!b >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A || (!b == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A || (!b != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A || (!b && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!A || (!b || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!A <= (!b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!A <= (!b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!A <= (!b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!A <= (!b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!A <= (!b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A <= (!b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A >= (!b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A >= (!b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A == (!b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!A == (!b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!A == (!b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!A == (!b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!A == (!b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A == (!b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A != (!b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!A != (!b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!A != (!b == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!A != (!b != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!A != (!b && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A != (!b || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A && (!b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A && (!b == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A && (!b != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!b && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A && (!b || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A || (!b <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A || (!b >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A || (!b == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A || (!b != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A || (!b && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A || (!b || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A <= (!b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!A <= (!b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!A <= (!b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!A <= (!b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!A <= (!b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A <= (!b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A >= (!b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!A >= (!b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A >= (!b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A == (!b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!A == (!b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!A == (!b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!A == (!b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!A == (!b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A == (!b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A != (!b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!A != (!b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!A != (!b == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!A != (!b != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!A != (!b && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A != (!b || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(b)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A && (!b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A && (!b == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A && (!b != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!b && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A && (!b || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A || (!b <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A || (!b >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A || (!b == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A || (!b != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A || (!b && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A || (!b || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(b)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A <= (!B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (!B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (!B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (!B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (!B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!A <= (!B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(le)
$ test-expr '\''!A >= (!B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!A >= (!B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''!A == (!B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (!B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (!B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (!B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (!B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!A == (!B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(eq)
$ test-expr '\''!A != (!B <= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (!B >= c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (!B == c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (!B != c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (!B && c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!A != (!B || c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''!A && (!B <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!A && (!B >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!A && (!B == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!A && (!B != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!A && (!B && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A && (!B || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A || (!B <= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(le)
$ test-expr '\''!A || (!B >= c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ge)
$ test-expr '\''!A || (!B == c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(eq)
$ test-expr '\''!A || (!B != c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 cmp_op(ne)
$ test-expr '\''!A || (!B && c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A || (!B || c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 make_bool()
$ test-expr '\''!A <= (!B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(le)
$ test-expr '\''!A <= (!B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(le)
$ test-expr '\''!A <= (!B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(le)
$ test-expr '\''!A <= (!B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(le)
$ test-expr '\''!A <= (!B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A <= (!B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A >= (!B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A >= (!B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A == (!B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(eq)
$ test-expr '\''!A == (!B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(eq)
$ test-expr '\''!A == (!B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(eq)
$ test-expr '\''!A == (!B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(eq)
$ test-expr '\''!A == (!B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A == (!B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A != (!B <= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(le)
6 cmp_op(ne)
$ test-expr '\''!A != (!B >= C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ge)
6 cmp_op(ne)
$ test-expr '\''!A != (!B == C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(eq)
6 cmp_op(ne)
$ test-expr '\''!A != (!B != C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 cmp_op(ne)
6 cmp_op(ne)
$ test-expr '\''!A != (!B && C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A != (!B || C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(6)
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A && (!B <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A && (!B >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A && (!B == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A && (!B != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A && (!B && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!A && (!B || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!A || (!B <= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(le)
$ test-expr '\''!A || (!B >= C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ge)
$ test-expr '\''!A || (!B == C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(eq)
$ test-expr '\''!A || (!B != C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 cmp_op(ne)
$ test-expr '\''!A || (!B && C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
$ test-expr '\''!A || (!B || C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
$ test-expr '\''!A <= (!B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!A <= (!B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!A <= (!B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!A <= (!B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!A <= (!B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A <= (!B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A >= (!B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A >= (!B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A == (!B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!A == (!B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!A == (!B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!A == (!B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!A == (!B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A == (!B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A != (!B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!A != (!B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!A != (!B == !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!A != (!B != !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!A != (!B && !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A != (!B || !c)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A && (!B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A && (!B == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A && (!B != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!B && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A && (!B || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A || (!B <= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A || (!B >= !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A || (!B == !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A || (!B != !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(c)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A || (!B && !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A || (!B || !c)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 not_op()
$ test-expr '\''!A <= (!B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(le)
$ test-expr '\''!A <= (!B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(le)
$ test-expr '\''!A <= (!B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(le)
$ test-expr '\''!A <= (!B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(le)
$ test-expr '\''!A <= (!B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A <= (!B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A >= (!B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!A >= (!B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A >= (!B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A == (!B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(eq)
$ test-expr '\''!A == (!B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(eq)
$ test-expr '\''!A == (!B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(eq)
$ test-expr '\''!A == (!B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(eq)
$ test-expr '\''!A == (!B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A == (!B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A != (!B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(le)
7 cmp_op(ne)
$ test-expr '\''!A != (!B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!A != (!B == !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(eq)
7 cmp_op(ne)
$ test-expr '\''!A != (!B != !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 not_op()
6 cmp_op(ne)
7 cmp_op(ne)
$ test-expr '\''!A != (!B && !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_false(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A != (!B || !C)'\''
0 call_builtin(A)
1 not_op()
2 call_builtin(B)
3 not_op()
4 jump_true(7)
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A && (!B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A && (!B == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A && (!B != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A && (!B && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A && (!B || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_false(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A || (!B <= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(le)
$ test-expr '\''!A || (!B >= !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''!A || (!B == !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(eq)
$ test-expr '\''!A || (!B != !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 call_builtin(C)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!A || (!B && !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 not_op()
$ test-expr '\''!A || (!B || !C)'\''
0 call_builtin(A)
1 not_op()
2 jump_true(eos)
3 call_builtin(B)
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 not_op()'
) -L op4.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ test-expr '\''a <= (b <= c)'\'''
test-expr 'a <= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b <= c)'\'''

echo '$ test-expr '\''a <= (b >= c)'\'''
test-expr 'a <= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b >= c)'\'''

echo '$ test-expr '\''a <= (b == c)'\'''
test-expr 'a <= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b == c)'\'''

echo '$ test-expr '\''a <= (b != c)'\'''
test-expr 'a <= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b != c)'\'''

echo '$ test-expr '\''a <= (b && c)'\'''
test-expr 'a <= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b && c)'\'''

echo '$ test-expr '\''a <= (b || c)'\'''
test-expr 'a <= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b || c)'\'''

echo '$ test-expr '\''a >= (b <= c)'\'''
test-expr 'a >= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b <= c)'\'''

echo '$ test-expr '\''a >= (b >= c)'\'''
test-expr 'a >= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b >= c)'\'''

echo '$ test-expr '\''a >= (b == c)'\'''
test-expr 'a >= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b == c)'\'''

echo '$ test-expr '\''a >= (b != c)'\'''
test-expr 'a >= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != c)'\'''

echo '$ test-expr '\''a >= (b && c)'\'''
test-expr 'a >= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && c)'\'''

echo '$ test-expr '\''a >= (b || c)'\'''
test-expr 'a >= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || c)'\'''

echo '$ test-expr '\''a == (b <= c)'\'''
test-expr 'a == (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b <= c)'\'''

echo '$ test-expr '\''a == (b >= c)'\'''
test-expr 'a == (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b >= c)'\'''

echo '$ test-expr '\''a == (b == c)'\'''
test-expr 'a == (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b == c)'\'''

echo '$ test-expr '\''a == (b != c)'\'''
test-expr 'a == (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b != c)'\'''

echo '$ test-expr '\''a == (b && c)'\'''
test-expr 'a == (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b && c)'\'''

echo '$ test-expr '\''a == (b || c)'\'''
test-expr 'a == (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b || c)'\'''

echo '$ test-expr '\''a != (b <= c)'\'''
test-expr 'a != (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b <= c)'\'''

echo '$ test-expr '\''a != (b >= c)'\'''
test-expr 'a != (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= c)'\'''

echo '$ test-expr '\''a != (b == c)'\'''
test-expr 'a != (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b == c)'\'''

echo '$ test-expr '\''a != (b != c)'\'''
test-expr 'a != (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b != c)'\'''

echo '$ test-expr '\''a != (b && c)'\'''
test-expr 'a != (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && c)'\'''

echo '$ test-expr '\''a != (b || c)'\'''
test-expr 'a != (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || c)'\'''

echo '$ test-expr '\''a && (b <= c)'\'''
test-expr 'a && (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b <= c)'\'''

echo '$ test-expr '\''a && (b >= c)'\'''
test-expr 'a && (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= c)'\'''

echo '$ test-expr '\''a && (b == c)'\'''
test-expr 'a && (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b == c)'\'''

echo '$ test-expr '\''a && (b != c)'\'''
test-expr 'a && (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != c)'\'''

echo '$ test-expr '\''a && (b && c)'\'''
test-expr 'a && (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b && c)'\'''

echo '$ test-expr '\''a && (b || c)'\'''
test-expr 'a && (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || c)'\'''

echo '$ test-expr '\''a || (b <= c)'\'''
test-expr 'a || (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b <= c)'\'''

echo '$ test-expr '\''a || (b >= c)'\'''
test-expr 'a || (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= c)'\'''

echo '$ test-expr '\''a || (b == c)'\'''
test-expr 'a || (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b == c)'\'''

echo '$ test-expr '\''a || (b != c)'\'''
test-expr 'a || (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != c)'\'''

echo '$ test-expr '\''a || (b && c)'\'''
test-expr 'a || (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && c)'\'''

echo '$ test-expr '\''a || (b || c)'\'''
test-expr 'a || (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b || c)'\'''

echo '$ test-expr '\''a <= (b <= C)'\'''
test-expr 'a <= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b <= C)'\'''

echo '$ test-expr '\''a <= (b >= C)'\'''
test-expr 'a <= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b >= C)'\'''

echo '$ test-expr '\''a <= (b == C)'\'''
test-expr 'a <= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b == C)'\'''

echo '$ test-expr '\''a <= (b != C)'\'''
test-expr 'a <= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b != C)'\'''

echo '$ test-expr '\''a <= (b && C)'\'''
test-expr 'a <= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b && C)'\'''

echo '$ test-expr '\''a <= (b || C)'\'''
test-expr 'a <= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b || C)'\'''

echo '$ test-expr '\''a >= (b <= C)'\'''
test-expr 'a >= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b <= C)'\'''

echo '$ test-expr '\''a >= (b >= C)'\'''
test-expr 'a >= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b >= C)'\'''

echo '$ test-expr '\''a >= (b == C)'\'''
test-expr 'a >= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b == C)'\'''

echo '$ test-expr '\''a >= (b != C)'\'''
test-expr 'a >= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != C)'\'''

echo '$ test-expr '\''a >= (b && C)'\'''
test-expr 'a >= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && C)'\'''

echo '$ test-expr '\''a >= (b || C)'\'''
test-expr 'a >= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || C)'\'''

echo '$ test-expr '\''a == (b <= C)'\'''
test-expr 'a == (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b <= C)'\'''

echo '$ test-expr '\''a == (b >= C)'\'''
test-expr 'a == (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b >= C)'\'''

echo '$ test-expr '\''a == (b == C)'\'''
test-expr 'a == (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b == C)'\'''

echo '$ test-expr '\''a == (b != C)'\'''
test-expr 'a == (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b != C)'\'''

echo '$ test-expr '\''a == (b && C)'\'''
test-expr 'a == (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b && C)'\'''

echo '$ test-expr '\''a == (b || C)'\'''
test-expr 'a == (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b || C)'\'''

echo '$ test-expr '\''a != (b <= C)'\'''
test-expr 'a != (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b <= C)'\'''

echo '$ test-expr '\''a != (b >= C)'\'''
test-expr 'a != (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= C)'\'''

echo '$ test-expr '\''a != (b == C)'\'''
test-expr 'a != (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b == C)'\'''

echo '$ test-expr '\''a != (b != C)'\'''
test-expr 'a != (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b != C)'\'''

echo '$ test-expr '\''a != (b && C)'\'''
test-expr 'a != (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && C)'\'''

echo '$ test-expr '\''a != (b || C)'\'''
test-expr 'a != (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || C)'\'''

echo '$ test-expr '\''a && (b <= C)'\'''
test-expr 'a && (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b <= C)'\'''

echo '$ test-expr '\''a && (b >= C)'\'''
test-expr 'a && (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= C)'\'''

echo '$ test-expr '\''a && (b == C)'\'''
test-expr 'a && (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b == C)'\'''

echo '$ test-expr '\''a && (b != C)'\'''
test-expr 'a && (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != C)'\'''

echo '$ test-expr '\''a && (b && C)'\'''
test-expr 'a && (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b && C)'\'''

echo '$ test-expr '\''a && (b || C)'\'''
test-expr 'a && (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || C)'\'''

echo '$ test-expr '\''a || (b <= C)'\'''
test-expr 'a || (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b <= C)'\'''

echo '$ test-expr '\''a || (b >= C)'\'''
test-expr 'a || (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= C)'\'''

echo '$ test-expr '\''a || (b == C)'\'''
test-expr 'a || (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b == C)'\'''

echo '$ test-expr '\''a || (b != C)'\'''
test-expr 'a || (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != C)'\'''

echo '$ test-expr '\''a || (b && C)'\'''
test-expr 'a || (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && C)'\'''

echo '$ test-expr '\''a || (b || C)'\'''
test-expr 'a || (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b || C)'\'''

echo '$ test-expr '\''a <= (b <= !c)'\'''
test-expr 'a <= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b <= !c)'\'''

echo '$ test-expr '\''a <= (b >= !c)'\'''
test-expr 'a <= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b >= !c)'\'''

echo '$ test-expr '\''a <= (b == !c)'\'''
test-expr 'a <= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b == !c)'\'''

echo '$ test-expr '\''a <= (b != !c)'\'''
test-expr 'a <= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b != !c)'\'''

echo '$ test-expr '\''a <= (b && !c)'\'''
test-expr 'a <= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b && !c)'\'''

echo '$ test-expr '\''a <= (b || !c)'\'''
test-expr 'a <= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b || !c)'\'''

echo '$ test-expr '\''a >= (b <= !c)'\'''
test-expr 'a >= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b <= !c)'\'''

echo '$ test-expr '\''a >= (b >= !c)'\'''
test-expr 'a >= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b >= !c)'\'''

echo '$ test-expr '\''a >= (b == !c)'\'''
test-expr 'a >= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b == !c)'\'''

echo '$ test-expr '\''a >= (b != !c)'\'''
test-expr 'a >= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != !c)'\'''

echo '$ test-expr '\''a >= (b && !c)'\'''
test-expr 'a >= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && !c)'\'''

echo '$ test-expr '\''a >= (b || !c)'\'''
test-expr 'a >= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || !c)'\'''

echo '$ test-expr '\''a == (b <= !c)'\'''
test-expr 'a == (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b <= !c)'\'''

echo '$ test-expr '\''a == (b >= !c)'\'''
test-expr 'a == (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b >= !c)'\'''

echo '$ test-expr '\''a == (b == !c)'\'''
test-expr 'a == (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b == !c)'\'''

echo '$ test-expr '\''a == (b != !c)'\'''
test-expr 'a == (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b != !c)'\'''

echo '$ test-expr '\''a == (b && !c)'\'''
test-expr 'a == (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b && !c)'\'''

echo '$ test-expr '\''a == (b || !c)'\'''
test-expr 'a == (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b || !c)'\'''

echo '$ test-expr '\''a != (b <= !c)'\'''
test-expr 'a != (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b <= !c)'\'''

echo '$ test-expr '\''a != (b >= !c)'\'''
test-expr 'a != (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= !c)'\'''

echo '$ test-expr '\''a != (b == !c)'\'''
test-expr 'a != (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b == !c)'\'''

echo '$ test-expr '\''a != (b != !c)'\'''
test-expr 'a != (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b != !c)'\'''

echo '$ test-expr '\''a != (b && !c)'\'''
test-expr 'a != (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && !c)'\'''

echo '$ test-expr '\''a != (b || !c)'\'''
test-expr 'a != (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || !c)'\'''

echo '$ test-expr '\''a && (b <= !c)'\'''
test-expr 'a && (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b <= !c)'\'''

echo '$ test-expr '\''a && (b >= !c)'\'''
test-expr 'a && (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= !c)'\'''

echo '$ test-expr '\''a && (b == !c)'\'''
test-expr 'a && (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b == !c)'\'''

echo '$ test-expr '\''a && (b != !c)'\'''
test-expr 'a && (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != !c)'\'''

echo '$ test-expr '\''a && (b && !c)'\'''
test-expr 'a && (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b && !c)'\'''

echo '$ test-expr '\''a && (b || !c)'\'''
test-expr 'a && (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || !c)'\'''

echo '$ test-expr '\''a || (b <= !c)'\'''
test-expr 'a || (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b <= !c)'\'''

echo '$ test-expr '\''a || (b >= !c)'\'''
test-expr 'a || (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= !c)'\'''

echo '$ test-expr '\''a || (b == !c)'\'''
test-expr 'a || (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b == !c)'\'''

echo '$ test-expr '\''a || (b != !c)'\'''
test-expr 'a || (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != !c)'\'''

echo '$ test-expr '\''a || (b && !c)'\'''
test-expr 'a || (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && !c)'\'''

echo '$ test-expr '\''a || (b || !c)'\'''
test-expr 'a || (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b || !c)'\'''

echo '$ test-expr '\''a <= (b <= !C)'\'''
test-expr 'a <= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b <= !C)'\'''

echo '$ test-expr '\''a <= (b >= !C)'\'''
test-expr 'a <= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b >= !C)'\'''

echo '$ test-expr '\''a <= (b == !C)'\'''
test-expr 'a <= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b == !C)'\'''

echo '$ test-expr '\''a <= (b != !C)'\'''
test-expr 'a <= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b != !C)'\'''

echo '$ test-expr '\''a <= (b && !C)'\'''
test-expr 'a <= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b && !C)'\'''

echo '$ test-expr '\''a <= (b || !C)'\'''
test-expr 'a <= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (b || !C)'\'''

echo '$ test-expr '\''a >= (b <= !C)'\'''
test-expr 'a >= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b <= !C)'\'''

echo '$ test-expr '\''a >= (b >= !C)'\'''
test-expr 'a >= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b >= !C)'\'''

echo '$ test-expr '\''a >= (b == !C)'\'''
test-expr 'a >= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b == !C)'\'''

echo '$ test-expr '\''a >= (b != !C)'\'''
test-expr 'a >= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != !C)'\'''

echo '$ test-expr '\''a >= (b && !C)'\'''
test-expr 'a >= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && !C)'\'''

echo '$ test-expr '\''a >= (b || !C)'\'''
test-expr 'a >= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || !C)'\'''

echo '$ test-expr '\''a == (b <= !C)'\'''
test-expr 'a == (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b <= !C)'\'''

echo '$ test-expr '\''a == (b >= !C)'\'''
test-expr 'a == (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b >= !C)'\'''

echo '$ test-expr '\''a == (b == !C)'\'''
test-expr 'a == (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b == !C)'\'''

echo '$ test-expr '\''a == (b != !C)'\'''
test-expr 'a == (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b != !C)'\'''

echo '$ test-expr '\''a == (b && !C)'\'''
test-expr 'a == (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b && !C)'\'''

echo '$ test-expr '\''a == (b || !C)'\'''
test-expr 'a == (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (b || !C)'\'''

echo '$ test-expr '\''a != (b <= !C)'\'''
test-expr 'a != (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b <= !C)'\'''

echo '$ test-expr '\''a != (b >= !C)'\'''
test-expr 'a != (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= !C)'\'''

echo '$ test-expr '\''a != (b == !C)'\'''
test-expr 'a != (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b == !C)'\'''

echo '$ test-expr '\''a != (b != !C)'\'''
test-expr 'a != (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b != !C)'\'''

echo '$ test-expr '\''a != (b && !C)'\'''
test-expr 'a != (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && !C)'\'''

echo '$ test-expr '\''a != (b || !C)'\'''
test-expr 'a != (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || !C)'\'''

echo '$ test-expr '\''a && (b <= !C)'\'''
test-expr 'a && (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b <= !C)'\'''

echo '$ test-expr '\''a && (b >= !C)'\'''
test-expr 'a && (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= !C)'\'''

echo '$ test-expr '\''a && (b == !C)'\'''
test-expr 'a && (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b == !C)'\'''

echo '$ test-expr '\''a && (b != !C)'\'''
test-expr 'a && (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != !C)'\'''

echo '$ test-expr '\''a && (b && !C)'\'''
test-expr 'a && (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b && !C)'\'''

echo '$ test-expr '\''a && (b || !C)'\'''
test-expr 'a && (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || !C)'\'''

echo '$ test-expr '\''a || (b <= !C)'\'''
test-expr 'a || (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b <= !C)'\'''

echo '$ test-expr '\''a || (b >= !C)'\'''
test-expr 'a || (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= !C)'\'''

echo '$ test-expr '\''a || (b == !C)'\'''
test-expr 'a || (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b == !C)'\'''

echo '$ test-expr '\''a || (b != !C)'\'''
test-expr 'a || (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != !C)'\'''

echo '$ test-expr '\''a || (b && !C)'\'''
test-expr 'a || (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && !C)'\'''

echo '$ test-expr '\''a || (b || !C)'\'''
test-expr 'a || (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (b || !C)'\'''

echo '$ test-expr '\''a <= (B <= c)'\'''
test-expr 'a <= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B <= c)'\'''

echo '$ test-expr '\''a <= (B >= c)'\'''
test-expr 'a <= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B >= c)'\'''

echo '$ test-expr '\''a <= (B == c)'\'''
test-expr 'a <= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B == c)'\'''

echo '$ test-expr '\''a <= (B != c)'\'''
test-expr 'a <= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B != c)'\'''

echo '$ test-expr '\''a <= (B && c)'\'''
test-expr 'a <= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B && c)'\'''

echo '$ test-expr '\''a <= (B || c)'\'''
test-expr 'a <= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B || c)'\'''

echo '$ test-expr '\''a >= (B <= c)'\'''
test-expr 'a >= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B <= c)'\'''

echo '$ test-expr '\''a >= (B >= c)'\'''
test-expr 'a >= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B >= c)'\'''

echo '$ test-expr '\''a >= (B == c)'\'''
test-expr 'a >= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B == c)'\'''

echo '$ test-expr '\''a >= (B != c)'\'''
test-expr 'a >= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != c)'\'''

echo '$ test-expr '\''a >= (B && c)'\'''
test-expr 'a >= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && c)'\'''

echo '$ test-expr '\''a >= (B || c)'\'''
test-expr 'a >= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || c)'\'''

echo '$ test-expr '\''a == (B <= c)'\'''
test-expr 'a == (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B <= c)'\'''

echo '$ test-expr '\''a == (B >= c)'\'''
test-expr 'a == (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B >= c)'\'''

echo '$ test-expr '\''a == (B == c)'\'''
test-expr 'a == (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B == c)'\'''

echo '$ test-expr '\''a == (B != c)'\'''
test-expr 'a == (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B != c)'\'''

echo '$ test-expr '\''a == (B && c)'\'''
test-expr 'a == (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B && c)'\'''

echo '$ test-expr '\''a == (B || c)'\'''
test-expr 'a == (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B || c)'\'''

echo '$ test-expr '\''a != (B <= c)'\'''
test-expr 'a != (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B <= c)'\'''

echo '$ test-expr '\''a != (B >= c)'\'''
test-expr 'a != (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= c)'\'''

echo '$ test-expr '\''a != (B == c)'\'''
test-expr 'a != (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B == c)'\'''

echo '$ test-expr '\''a != (B != c)'\'''
test-expr 'a != (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B != c)'\'''

echo '$ test-expr '\''a != (B && c)'\'''
test-expr 'a != (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && c)'\'''

echo '$ test-expr '\''a != (B || c)'\'''
test-expr 'a != (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || c)'\'''

echo '$ test-expr '\''a && (B <= c)'\'''
test-expr 'a && (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B <= c)'\'''

echo '$ test-expr '\''a && (B >= c)'\'''
test-expr 'a && (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= c)'\'''

echo '$ test-expr '\''a && (B == c)'\'''
test-expr 'a && (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B == c)'\'''

echo '$ test-expr '\''a && (B != c)'\'''
test-expr 'a && (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != c)'\'''

echo '$ test-expr '\''a && (B && c)'\'''
test-expr 'a && (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B && c)'\'''

echo '$ test-expr '\''a && (B || c)'\'''
test-expr 'a && (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B || c)'\'''

echo '$ test-expr '\''a || (B <= c)'\'''
test-expr 'a || (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B <= c)'\'''

echo '$ test-expr '\''a || (B >= c)'\'''
test-expr 'a || (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B >= c)'\'''

echo '$ test-expr '\''a || (B == c)'\'''
test-expr 'a || (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B == c)'\'''

echo '$ test-expr '\''a || (B != c)'\'''
test-expr 'a || (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B != c)'\'''

echo '$ test-expr '\''a || (B && c)'\'''
test-expr 'a || (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B && c)'\'''

echo '$ test-expr '\''a || (B || c)'\'''
test-expr 'a || (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B || c)'\'''

echo '$ test-expr '\''a <= (B <= C)'\'''
test-expr 'a <= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B <= C)'\'''

echo '$ test-expr '\''a <= (B >= C)'\'''
test-expr 'a <= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B >= C)'\'''

echo '$ test-expr '\''a <= (B == C)'\'''
test-expr 'a <= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B == C)'\'''

echo '$ test-expr '\''a <= (B != C)'\'''
test-expr 'a <= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B != C)'\'''

echo '$ test-expr '\''a <= (B && C)'\'''
test-expr 'a <= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B && C)'\'''

echo '$ test-expr '\''a <= (B || C)'\'''
test-expr 'a <= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B || C)'\'''

echo '$ test-expr '\''a >= (B <= C)'\'''
test-expr 'a >= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B <= C)'\'''

echo '$ test-expr '\''a >= (B >= C)'\'''
test-expr 'a >= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B >= C)'\'''

echo '$ test-expr '\''a >= (B == C)'\'''
test-expr 'a >= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B == C)'\'''

echo '$ test-expr '\''a >= (B != C)'\'''
test-expr 'a >= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != C)'\'''

echo '$ test-expr '\''a >= (B && C)'\'''
test-expr 'a >= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && C)'\'''

echo '$ test-expr '\''a >= (B || C)'\'''
test-expr 'a >= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || C)'\'''

echo '$ test-expr '\''a == (B <= C)'\'''
test-expr 'a == (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B <= C)'\'''

echo '$ test-expr '\''a == (B >= C)'\'''
test-expr 'a == (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B >= C)'\'''

echo '$ test-expr '\''a == (B == C)'\'''
test-expr 'a == (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B == C)'\'''

echo '$ test-expr '\''a == (B != C)'\'''
test-expr 'a == (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B != C)'\'''

echo '$ test-expr '\''a == (B && C)'\'''
test-expr 'a == (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B && C)'\'''

echo '$ test-expr '\''a == (B || C)'\'''
test-expr 'a == (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B || C)'\'''

echo '$ test-expr '\''a != (B <= C)'\'''
test-expr 'a != (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B <= C)'\'''

echo '$ test-expr '\''a != (B >= C)'\'''
test-expr 'a != (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= C)'\'''

echo '$ test-expr '\''a != (B == C)'\'''
test-expr 'a != (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B == C)'\'''

echo '$ test-expr '\''a != (B != C)'\'''
test-expr 'a != (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B != C)'\'''

echo '$ test-expr '\''a != (B && C)'\'''
test-expr 'a != (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && C)'\'''

echo '$ test-expr '\''a != (B || C)'\'''
test-expr 'a != (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || C)'\'''

echo '$ test-expr '\''a && (B <= C)'\'''
test-expr 'a && (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B <= C)'\'''

echo '$ test-expr '\''a && (B >= C)'\'''
test-expr 'a && (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= C)'\'''

echo '$ test-expr '\''a && (B == C)'\'''
test-expr 'a && (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B == C)'\'''

echo '$ test-expr '\''a && (B != C)'\'''
test-expr 'a && (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != C)'\'''

echo '$ test-expr '\''a && (B && C)'\'''
test-expr 'a && (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B && C)'\'''

echo '$ test-expr '\''a && (B || C)'\'''
test-expr 'a && (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B || C)'\'''

echo '$ test-expr '\''a || (B <= C)'\'''
test-expr 'a || (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B <= C)'\'''

echo '$ test-expr '\''a || (B >= C)'\'''
test-expr 'a || (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B >= C)'\'''

echo '$ test-expr '\''a || (B == C)'\'''
test-expr 'a || (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B == C)'\'''

echo '$ test-expr '\''a || (B != C)'\'''
test-expr 'a || (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B != C)'\'''

echo '$ test-expr '\''a || (B && C)'\'''
test-expr 'a || (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B && C)'\'''

echo '$ test-expr '\''a || (B || C)'\'''
test-expr 'a || (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B || C)'\'''

echo '$ test-expr '\''a <= (B <= !c)'\'''
test-expr 'a <= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B <= !c)'\'''

echo '$ test-expr '\''a <= (B >= !c)'\'''
test-expr 'a <= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B >= !c)'\'''

echo '$ test-expr '\''a <= (B == !c)'\'''
test-expr 'a <= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B == !c)'\'''

echo '$ test-expr '\''a <= (B != !c)'\'''
test-expr 'a <= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B != !c)'\'''

echo '$ test-expr '\''a <= (B && !c)'\'''
test-expr 'a <= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B && !c)'\'''

echo '$ test-expr '\''a <= (B || !c)'\'''
test-expr 'a <= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B || !c)'\'''

echo '$ test-expr '\''a >= (B <= !c)'\'''
test-expr 'a >= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B <= !c)'\'''

echo '$ test-expr '\''a >= (B >= !c)'\'''
test-expr 'a >= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B >= !c)'\'''

echo '$ test-expr '\''a >= (B == !c)'\'''
test-expr 'a >= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B == !c)'\'''

echo '$ test-expr '\''a >= (B != !c)'\'''
test-expr 'a >= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != !c)'\'''

echo '$ test-expr '\''a >= (B && !c)'\'''
test-expr 'a >= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && !c)'\'''

echo '$ test-expr '\''a >= (B || !c)'\'''
test-expr 'a >= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || !c)'\'''

echo '$ test-expr '\''a == (B <= !c)'\'''
test-expr 'a == (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B <= !c)'\'''

echo '$ test-expr '\''a == (B >= !c)'\'''
test-expr 'a == (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B >= !c)'\'''

echo '$ test-expr '\''a == (B == !c)'\'''
test-expr 'a == (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B == !c)'\'''

echo '$ test-expr '\''a == (B != !c)'\'''
test-expr 'a == (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B != !c)'\'''

echo '$ test-expr '\''a == (B && !c)'\'''
test-expr 'a == (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B && !c)'\'''

echo '$ test-expr '\''a == (B || !c)'\'''
test-expr 'a == (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B || !c)'\'''

echo '$ test-expr '\''a != (B <= !c)'\'''
test-expr 'a != (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B <= !c)'\'''

echo '$ test-expr '\''a != (B >= !c)'\'''
test-expr 'a != (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= !c)'\'''

echo '$ test-expr '\''a != (B == !c)'\'''
test-expr 'a != (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B == !c)'\'''

echo '$ test-expr '\''a != (B != !c)'\'''
test-expr 'a != (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B != !c)'\'''

echo '$ test-expr '\''a != (B && !c)'\'''
test-expr 'a != (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && !c)'\'''

echo '$ test-expr '\''a != (B || !c)'\'''
test-expr 'a != (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || !c)'\'''

echo '$ test-expr '\''a && (B <= !c)'\'''
test-expr 'a && (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B <= !c)'\'''

echo '$ test-expr '\''a && (B >= !c)'\'''
test-expr 'a && (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= !c)'\'''

echo '$ test-expr '\''a && (B == !c)'\'''
test-expr 'a && (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B == !c)'\'''

echo '$ test-expr '\''a && (B != !c)'\'''
test-expr 'a && (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != !c)'\'''

echo '$ test-expr '\''a && (B && !c)'\'''
test-expr 'a && (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B && !c)'\'''

echo '$ test-expr '\''a && (B || !c)'\'''
test-expr 'a && (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B || !c)'\'''

echo '$ test-expr '\''a || (B <= !c)'\'''
test-expr 'a || (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B <= !c)'\'''

echo '$ test-expr '\''a || (B >= !c)'\'''
test-expr 'a || (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B >= !c)'\'''

echo '$ test-expr '\''a || (B == !c)'\'''
test-expr 'a || (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B == !c)'\'''

echo '$ test-expr '\''a || (B != !c)'\'''
test-expr 'a || (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B != !c)'\'''

echo '$ test-expr '\''a || (B && !c)'\'''
test-expr 'a || (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B && !c)'\'''

echo '$ test-expr '\''a || (B || !c)'\'''
test-expr 'a || (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B || !c)'\'''

echo '$ test-expr '\''a <= (B <= !C)'\'''
test-expr 'a <= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B <= !C)'\'''

echo '$ test-expr '\''a <= (B >= !C)'\'''
test-expr 'a <= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B >= !C)'\'''

echo '$ test-expr '\''a <= (B == !C)'\'''
test-expr 'a <= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B == !C)'\'''

echo '$ test-expr '\''a <= (B != !C)'\'''
test-expr 'a <= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B != !C)'\'''

echo '$ test-expr '\''a <= (B && !C)'\'''
test-expr 'a <= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B && !C)'\'''

echo '$ test-expr '\''a <= (B || !C)'\'''
test-expr 'a <= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (B || !C)'\'''

echo '$ test-expr '\''a >= (B <= !C)'\'''
test-expr 'a >= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B <= !C)'\'''

echo '$ test-expr '\''a >= (B >= !C)'\'''
test-expr 'a >= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B >= !C)'\'''

echo '$ test-expr '\''a >= (B == !C)'\'''
test-expr 'a >= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B == !C)'\'''

echo '$ test-expr '\''a >= (B != !C)'\'''
test-expr 'a >= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != !C)'\'''

echo '$ test-expr '\''a >= (B && !C)'\'''
test-expr 'a >= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && !C)'\'''

echo '$ test-expr '\''a >= (B || !C)'\'''
test-expr 'a >= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || !C)'\'''

echo '$ test-expr '\''a == (B <= !C)'\'''
test-expr 'a == (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B <= !C)'\'''

echo '$ test-expr '\''a == (B >= !C)'\'''
test-expr 'a == (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B >= !C)'\'''

echo '$ test-expr '\''a == (B == !C)'\'''
test-expr 'a == (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B == !C)'\'''

echo '$ test-expr '\''a == (B != !C)'\'''
test-expr 'a == (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B != !C)'\'''

echo '$ test-expr '\''a == (B && !C)'\'''
test-expr 'a == (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B && !C)'\'''

echo '$ test-expr '\''a == (B || !C)'\'''
test-expr 'a == (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (B || !C)'\'''

echo '$ test-expr '\''a != (B <= !C)'\'''
test-expr 'a != (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B <= !C)'\'''

echo '$ test-expr '\''a != (B >= !C)'\'''
test-expr 'a != (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= !C)'\'''

echo '$ test-expr '\''a != (B == !C)'\'''
test-expr 'a != (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B == !C)'\'''

echo '$ test-expr '\''a != (B != !C)'\'''
test-expr 'a != (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B != !C)'\'''

echo '$ test-expr '\''a != (B && !C)'\'''
test-expr 'a != (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && !C)'\'''

echo '$ test-expr '\''a != (B || !C)'\'''
test-expr 'a != (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || !C)'\'''

echo '$ test-expr '\''a && (B <= !C)'\'''
test-expr 'a && (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B <= !C)'\'''

echo '$ test-expr '\''a && (B >= !C)'\'''
test-expr 'a && (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= !C)'\'''

echo '$ test-expr '\''a && (B == !C)'\'''
test-expr 'a && (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B == !C)'\'''

echo '$ test-expr '\''a && (B != !C)'\'''
test-expr 'a && (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != !C)'\'''

echo '$ test-expr '\''a && (B && !C)'\'''
test-expr 'a && (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B && !C)'\'''

echo '$ test-expr '\''a && (B || !C)'\'''
test-expr 'a && (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (B || !C)'\'''

echo '$ test-expr '\''a || (B <= !C)'\'''
test-expr 'a || (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B <= !C)'\'''

echo '$ test-expr '\''a || (B >= !C)'\'''
test-expr 'a || (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B >= !C)'\'''

echo '$ test-expr '\''a || (B == !C)'\'''
test-expr 'a || (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B == !C)'\'''

echo '$ test-expr '\''a || (B != !C)'\'''
test-expr 'a || (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B != !C)'\'''

echo '$ test-expr '\''a || (B && !C)'\'''
test-expr 'a || (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B && !C)'\'''

echo '$ test-expr '\''a || (B || !C)'\'''
test-expr 'a || (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (B || !C)'\'''

echo '$ test-expr '\''a <= (!b <= c)'\'''
test-expr 'a <= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b <= c)'\'''

echo '$ test-expr '\''a <= (!b >= c)'\'''
test-expr 'a <= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b >= c)'\'''

echo '$ test-expr '\''a <= (!b == c)'\'''
test-expr 'a <= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b == c)'\'''

echo '$ test-expr '\''a <= (!b != c)'\'''
test-expr 'a <= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b != c)'\'''

echo '$ test-expr '\''a <= (!b && c)'\'''
test-expr 'a <= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b && c)'\'''

echo '$ test-expr '\''a <= (!b || c)'\'''
test-expr 'a <= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b || c)'\'''

echo '$ test-expr '\''a >= (!b <= c)'\'''
test-expr 'a >= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b <= c)'\'''

echo '$ test-expr '\''a >= (!b >= c)'\'''
test-expr 'a >= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b >= c)'\'''

echo '$ test-expr '\''a >= (!b == c)'\'''
test-expr 'a >= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b == c)'\'''

echo '$ test-expr '\''a >= (!b != c)'\'''
test-expr 'a >= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b != c)'\'''

echo '$ test-expr '\''a >= (!b && c)'\'''
test-expr 'a >= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b && c)'\'''

echo '$ test-expr '\''a >= (!b || c)'\'''
test-expr 'a >= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b || c)'\'''

echo '$ test-expr '\''a == (!b <= c)'\'''
test-expr 'a == (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b <= c)'\'''

echo '$ test-expr '\''a == (!b >= c)'\'''
test-expr 'a == (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b >= c)'\'''

echo '$ test-expr '\''a == (!b == c)'\'''
test-expr 'a == (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b == c)'\'''

echo '$ test-expr '\''a == (!b != c)'\'''
test-expr 'a == (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b != c)'\'''

echo '$ test-expr '\''a == (!b && c)'\'''
test-expr 'a == (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b && c)'\'''

echo '$ test-expr '\''a == (!b || c)'\'''
test-expr 'a == (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b || c)'\'''

echo '$ test-expr '\''a != (!b <= c)'\'''
test-expr 'a != (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b <= c)'\'''

echo '$ test-expr '\''a != (!b >= c)'\'''
test-expr 'a != (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b >= c)'\'''

echo '$ test-expr '\''a != (!b == c)'\'''
test-expr 'a != (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b == c)'\'''

echo '$ test-expr '\''a != (!b != c)'\'''
test-expr 'a != (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b != c)'\'''

echo '$ test-expr '\''a != (!b && c)'\'''
test-expr 'a != (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b && c)'\'''

echo '$ test-expr '\''a != (!b || c)'\'''
test-expr 'a != (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b || c)'\'''

echo '$ test-expr '\''a && (!b <= c)'\'''
test-expr 'a && (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b <= c)'\'''

echo '$ test-expr '\''a && (!b >= c)'\'''
test-expr 'a && (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b >= c)'\'''

echo '$ test-expr '\''a && (!b == c)'\'''
test-expr 'a && (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b == c)'\'''

echo '$ test-expr '\''a && (!b != c)'\'''
test-expr 'a && (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b != c)'\'''

echo '$ test-expr '\''a && (!b && c)'\'''
test-expr 'a && (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b && c)'\'''

echo '$ test-expr '\''a && (!b || c)'\'''
test-expr 'a && (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b || c)'\'''

echo '$ test-expr '\''a || (!b <= c)'\'''
test-expr 'a || (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b <= c)'\'''

echo '$ test-expr '\''a || (!b >= c)'\'''
test-expr 'a || (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b >= c)'\'''

echo '$ test-expr '\''a || (!b == c)'\'''
test-expr 'a || (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b == c)'\'''

echo '$ test-expr '\''a || (!b != c)'\'''
test-expr 'a || (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b != c)'\'''

echo '$ test-expr '\''a || (!b && c)'\'''
test-expr 'a || (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b && c)'\'''

echo '$ test-expr '\''a || (!b || c)'\'''
test-expr 'a || (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b || c)'\'''

echo '$ test-expr '\''a <= (!b <= C)'\'''
test-expr 'a <= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b <= C)'\'''

echo '$ test-expr '\''a <= (!b >= C)'\'''
test-expr 'a <= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b >= C)'\'''

echo '$ test-expr '\''a <= (!b == C)'\'''
test-expr 'a <= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b == C)'\'''

echo '$ test-expr '\''a <= (!b != C)'\'''
test-expr 'a <= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b != C)'\'''

echo '$ test-expr '\''a <= (!b && C)'\'''
test-expr 'a <= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b && C)'\'''

echo '$ test-expr '\''a <= (!b || C)'\'''
test-expr 'a <= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b || C)'\'''

echo '$ test-expr '\''a >= (!b <= C)'\'''
test-expr 'a >= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b <= C)'\'''

echo '$ test-expr '\''a >= (!b >= C)'\'''
test-expr 'a >= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b >= C)'\'''

echo '$ test-expr '\''a >= (!b == C)'\'''
test-expr 'a >= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b == C)'\'''

echo '$ test-expr '\''a >= (!b != C)'\'''
test-expr 'a >= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b != C)'\'''

echo '$ test-expr '\''a >= (!b && C)'\'''
test-expr 'a >= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b && C)'\'''

echo '$ test-expr '\''a >= (!b || C)'\'''
test-expr 'a >= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b || C)'\'''

echo '$ test-expr '\''a == (!b <= C)'\'''
test-expr 'a == (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b <= C)'\'''

echo '$ test-expr '\''a == (!b >= C)'\'''
test-expr 'a == (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b >= C)'\'''

echo '$ test-expr '\''a == (!b == C)'\'''
test-expr 'a == (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b == C)'\'''

echo '$ test-expr '\''a == (!b != C)'\'''
test-expr 'a == (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b != C)'\'''

echo '$ test-expr '\''a == (!b && C)'\'''
test-expr 'a == (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b && C)'\'''

echo '$ test-expr '\''a == (!b || C)'\'''
test-expr 'a == (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b || C)'\'''

echo '$ test-expr '\''a != (!b <= C)'\'''
test-expr 'a != (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b <= C)'\'''

echo '$ test-expr '\''a != (!b >= C)'\'''
test-expr 'a != (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b >= C)'\'''

echo '$ test-expr '\''a != (!b == C)'\'''
test-expr 'a != (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b == C)'\'''

echo '$ test-expr '\''a != (!b != C)'\'''
test-expr 'a != (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b != C)'\'''

echo '$ test-expr '\''a != (!b && C)'\'''
test-expr 'a != (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b && C)'\'''

echo '$ test-expr '\''a != (!b || C)'\'''
test-expr 'a != (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b || C)'\'''

echo '$ test-expr '\''a && (!b <= C)'\'''
test-expr 'a && (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b <= C)'\'''

echo '$ test-expr '\''a && (!b >= C)'\'''
test-expr 'a && (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b >= C)'\'''

echo '$ test-expr '\''a && (!b == C)'\'''
test-expr 'a && (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b == C)'\'''

echo '$ test-expr '\''a && (!b != C)'\'''
test-expr 'a && (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b != C)'\'''

echo '$ test-expr '\''a && (!b && C)'\'''
test-expr 'a && (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b && C)'\'''

echo '$ test-expr '\''a && (!b || C)'\'''
test-expr 'a && (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b || C)'\'''

echo '$ test-expr '\''a || (!b <= C)'\'''
test-expr 'a || (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b <= C)'\'''

echo '$ test-expr '\''a || (!b >= C)'\'''
test-expr 'a || (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b >= C)'\'''

echo '$ test-expr '\''a || (!b == C)'\'''
test-expr 'a || (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b == C)'\'''

echo '$ test-expr '\''a || (!b != C)'\'''
test-expr 'a || (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b != C)'\'''

echo '$ test-expr '\''a || (!b && C)'\'''
test-expr 'a || (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b && C)'\'''

echo '$ test-expr '\''a || (!b || C)'\'''
test-expr 'a || (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b || C)'\'''

echo '$ test-expr '\''a <= (!b <= !c)'\'''
test-expr 'a <= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b <= !c)'\'''

echo '$ test-expr '\''a <= (!b >= !c)'\'''
test-expr 'a <= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b >= !c)'\'''

echo '$ test-expr '\''a <= (!b == !c)'\'''
test-expr 'a <= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b == !c)'\'''

echo '$ test-expr '\''a <= (!b != !c)'\'''
test-expr 'a <= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b != !c)'\'''

echo '$ test-expr '\''a <= (!b && !c)'\'''
test-expr 'a <= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b && !c)'\'''

echo '$ test-expr '\''a <= (!b || !c)'\'''
test-expr 'a <= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b || !c)'\'''

echo '$ test-expr '\''a >= (!b <= !c)'\'''
test-expr 'a >= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b <= !c)'\'''

echo '$ test-expr '\''a >= (!b >= !c)'\'''
test-expr 'a >= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b >= !c)'\'''

echo '$ test-expr '\''a >= (!b == !c)'\'''
test-expr 'a >= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b == !c)'\'''

echo '$ test-expr '\''a >= (!b != !c)'\'''
test-expr 'a >= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b != !c)'\'''

echo '$ test-expr '\''a >= (!b && !c)'\'''
test-expr 'a >= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b && !c)'\'''

echo '$ test-expr '\''a >= (!b || !c)'\'''
test-expr 'a >= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b || !c)'\'''

echo '$ test-expr '\''a == (!b <= !c)'\'''
test-expr 'a == (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b <= !c)'\'''

echo '$ test-expr '\''a == (!b >= !c)'\'''
test-expr 'a == (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b >= !c)'\'''

echo '$ test-expr '\''a == (!b == !c)'\'''
test-expr 'a == (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b == !c)'\'''

echo '$ test-expr '\''a == (!b != !c)'\'''
test-expr 'a == (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b != !c)'\'''

echo '$ test-expr '\''a == (!b && !c)'\'''
test-expr 'a == (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b && !c)'\'''

echo '$ test-expr '\''a == (!b || !c)'\'''
test-expr 'a == (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b || !c)'\'''

echo '$ test-expr '\''a != (!b <= !c)'\'''
test-expr 'a != (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b <= !c)'\'''

echo '$ test-expr '\''a != (!b >= !c)'\'''
test-expr 'a != (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b >= !c)'\'''

echo '$ test-expr '\''a != (!b == !c)'\'''
test-expr 'a != (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b == !c)'\'''

echo '$ test-expr '\''a != (!b != !c)'\'''
test-expr 'a != (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b != !c)'\'''

echo '$ test-expr '\''a != (!b && !c)'\'''
test-expr 'a != (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b && !c)'\'''

echo '$ test-expr '\''a != (!b || !c)'\'''
test-expr 'a != (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b || !c)'\'''

echo '$ test-expr '\''a && (!b <= !c)'\'''
test-expr 'a && (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b <= !c)'\'''

echo '$ test-expr '\''a && (!b >= !c)'\'''
test-expr 'a && (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b >= !c)'\'''

echo '$ test-expr '\''a && (!b == !c)'\'''
test-expr 'a && (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b == !c)'\'''

echo '$ test-expr '\''a && (!b != !c)'\'''
test-expr 'a && (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b != !c)'\'''

echo '$ test-expr '\''a && (!b && !c)'\'''
test-expr 'a && (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b && !c)'\'''

echo '$ test-expr '\''a && (!b || !c)'\'''
test-expr 'a && (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b || !c)'\'''

echo '$ test-expr '\''a || (!b <= !c)'\'''
test-expr 'a || (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b <= !c)'\'''

echo '$ test-expr '\''a || (!b >= !c)'\'''
test-expr 'a || (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b >= !c)'\'''

echo '$ test-expr '\''a || (!b == !c)'\'''
test-expr 'a || (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b == !c)'\'''

echo '$ test-expr '\''a || (!b != !c)'\'''
test-expr 'a || (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b != !c)'\'''

echo '$ test-expr '\''a || (!b && !c)'\'''
test-expr 'a || (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b && !c)'\'''

echo '$ test-expr '\''a || (!b || !c)'\'''
test-expr 'a || (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b || !c)'\'''

echo '$ test-expr '\''a <= (!b <= !C)'\'''
test-expr 'a <= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b <= !C)'\'''

echo '$ test-expr '\''a <= (!b >= !C)'\'''
test-expr 'a <= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b >= !C)'\'''

echo '$ test-expr '\''a <= (!b == !C)'\'''
test-expr 'a <= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b == !C)'\'''

echo '$ test-expr '\''a <= (!b != !C)'\'''
test-expr 'a <= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b != !C)'\'''

echo '$ test-expr '\''a <= (!b && !C)'\'''
test-expr 'a <= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b && !C)'\'''

echo '$ test-expr '\''a <= (!b || !C)'\'''
test-expr 'a <= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!b || !C)'\'''

echo '$ test-expr '\''a >= (!b <= !C)'\'''
test-expr 'a >= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b <= !C)'\'''

echo '$ test-expr '\''a >= (!b >= !C)'\'''
test-expr 'a >= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b >= !C)'\'''

echo '$ test-expr '\''a >= (!b == !C)'\'''
test-expr 'a >= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b == !C)'\'''

echo '$ test-expr '\''a >= (!b != !C)'\'''
test-expr 'a >= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b != !C)'\'''

echo '$ test-expr '\''a >= (!b && !C)'\'''
test-expr 'a >= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b && !C)'\'''

echo '$ test-expr '\''a >= (!b || !C)'\'''
test-expr 'a >= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!b || !C)'\'''

echo '$ test-expr '\''a == (!b <= !C)'\'''
test-expr 'a == (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b <= !C)'\'''

echo '$ test-expr '\''a == (!b >= !C)'\'''
test-expr 'a == (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b >= !C)'\'''

echo '$ test-expr '\''a == (!b == !C)'\'''
test-expr 'a == (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b == !C)'\'''

echo '$ test-expr '\''a == (!b != !C)'\'''
test-expr 'a == (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b != !C)'\'''

echo '$ test-expr '\''a == (!b && !C)'\'''
test-expr 'a == (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b && !C)'\'''

echo '$ test-expr '\''a == (!b || !C)'\'''
test-expr 'a == (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!b || !C)'\'''

echo '$ test-expr '\''a != (!b <= !C)'\'''
test-expr 'a != (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b <= !C)'\'''

echo '$ test-expr '\''a != (!b >= !C)'\'''
test-expr 'a != (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b >= !C)'\'''

echo '$ test-expr '\''a != (!b == !C)'\'''
test-expr 'a != (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b == !C)'\'''

echo '$ test-expr '\''a != (!b != !C)'\'''
test-expr 'a != (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b != !C)'\'''

echo '$ test-expr '\''a != (!b && !C)'\'''
test-expr 'a != (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b && !C)'\'''

echo '$ test-expr '\''a != (!b || !C)'\'''
test-expr 'a != (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!b || !C)'\'''

echo '$ test-expr '\''a && (!b <= !C)'\'''
test-expr 'a && (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b <= !C)'\'''

echo '$ test-expr '\''a && (!b >= !C)'\'''
test-expr 'a && (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b >= !C)'\'''

echo '$ test-expr '\''a && (!b == !C)'\'''
test-expr 'a && (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b == !C)'\'''

echo '$ test-expr '\''a && (!b != !C)'\'''
test-expr 'a && (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b != !C)'\'''

echo '$ test-expr '\''a && (!b && !C)'\'''
test-expr 'a && (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b && !C)'\'''

echo '$ test-expr '\''a && (!b || !C)'\'''
test-expr 'a && (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!b || !C)'\'''

echo '$ test-expr '\''a || (!b <= !C)'\'''
test-expr 'a || (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b <= !C)'\'''

echo '$ test-expr '\''a || (!b >= !C)'\'''
test-expr 'a || (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b >= !C)'\'''

echo '$ test-expr '\''a || (!b == !C)'\'''
test-expr 'a || (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b == !C)'\'''

echo '$ test-expr '\''a || (!b != !C)'\'''
test-expr 'a || (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b != !C)'\'''

echo '$ test-expr '\''a || (!b && !C)'\'''
test-expr 'a || (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b && !C)'\'''

echo '$ test-expr '\''a || (!b || !C)'\'''
test-expr 'a || (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!b || !C)'\'''

echo '$ test-expr '\''a <= (!B <= c)'\'''
test-expr 'a <= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B <= c)'\'''

echo '$ test-expr '\''a <= (!B >= c)'\'''
test-expr 'a <= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B >= c)'\'''

echo '$ test-expr '\''a <= (!B == c)'\'''
test-expr 'a <= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B == c)'\'''

echo '$ test-expr '\''a <= (!B != c)'\'''
test-expr 'a <= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B != c)'\'''

echo '$ test-expr '\''a <= (!B && c)'\'''
test-expr 'a <= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B && c)'\'''

echo '$ test-expr '\''a <= (!B || c)'\'''
test-expr 'a <= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B || c)'\'''

echo '$ test-expr '\''a >= (!B <= c)'\'''
test-expr 'a >= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B <= c)'\'''

echo '$ test-expr '\''a >= (!B >= c)'\'''
test-expr 'a >= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B >= c)'\'''

echo '$ test-expr '\''a >= (!B == c)'\'''
test-expr 'a >= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B == c)'\'''

echo '$ test-expr '\''a >= (!B != c)'\'''
test-expr 'a >= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B != c)'\'''

echo '$ test-expr '\''a >= (!B && c)'\'''
test-expr 'a >= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B && c)'\'''

echo '$ test-expr '\''a >= (!B || c)'\'''
test-expr 'a >= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B || c)'\'''

echo '$ test-expr '\''a == (!B <= c)'\'''
test-expr 'a == (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B <= c)'\'''

echo '$ test-expr '\''a == (!B >= c)'\'''
test-expr 'a == (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B >= c)'\'''

echo '$ test-expr '\''a == (!B == c)'\'''
test-expr 'a == (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B == c)'\'''

echo '$ test-expr '\''a == (!B != c)'\'''
test-expr 'a == (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B != c)'\'''

echo '$ test-expr '\''a == (!B && c)'\'''
test-expr 'a == (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B && c)'\'''

echo '$ test-expr '\''a == (!B || c)'\'''
test-expr 'a == (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B || c)'\'''

echo '$ test-expr '\''a != (!B <= c)'\'''
test-expr 'a != (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B <= c)'\'''

echo '$ test-expr '\''a != (!B >= c)'\'''
test-expr 'a != (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B >= c)'\'''

echo '$ test-expr '\''a != (!B == c)'\'''
test-expr 'a != (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B == c)'\'''

echo '$ test-expr '\''a != (!B != c)'\'''
test-expr 'a != (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B != c)'\'''

echo '$ test-expr '\''a != (!B && c)'\'''
test-expr 'a != (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B && c)'\'''

echo '$ test-expr '\''a != (!B || c)'\'''
test-expr 'a != (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B || c)'\'''

echo '$ test-expr '\''a && (!B <= c)'\'''
test-expr 'a && (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B <= c)'\'''

echo '$ test-expr '\''a && (!B >= c)'\'''
test-expr 'a && (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B >= c)'\'''

echo '$ test-expr '\''a && (!B == c)'\'''
test-expr 'a && (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B == c)'\'''

echo '$ test-expr '\''a && (!B != c)'\'''
test-expr 'a && (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B != c)'\'''

echo '$ test-expr '\''a && (!B && c)'\'''
test-expr 'a && (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B && c)'\'''

echo '$ test-expr '\''a && (!B || c)'\'''
test-expr 'a && (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B || c)'\'''

echo '$ test-expr '\''a || (!B <= c)'\'''
test-expr 'a || (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B <= c)'\'''

echo '$ test-expr '\''a || (!B >= c)'\'''
test-expr 'a || (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B >= c)'\'''

echo '$ test-expr '\''a || (!B == c)'\'''
test-expr 'a || (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B == c)'\'''

echo '$ test-expr '\''a || (!B != c)'\'''
test-expr 'a || (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B != c)'\'''

echo '$ test-expr '\''a || (!B && c)'\'''
test-expr 'a || (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B && c)'\'''

echo '$ test-expr '\''a || (!B || c)'\'''
test-expr 'a || (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B || c)'\'''

echo '$ test-expr '\''a <= (!B <= C)'\'''
test-expr 'a <= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B <= C)'\'''

echo '$ test-expr '\''a <= (!B >= C)'\'''
test-expr 'a <= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B >= C)'\'''

echo '$ test-expr '\''a <= (!B == C)'\'''
test-expr 'a <= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B == C)'\'''

echo '$ test-expr '\''a <= (!B != C)'\'''
test-expr 'a <= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B != C)'\'''

echo '$ test-expr '\''a <= (!B && C)'\'''
test-expr 'a <= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B && C)'\'''

echo '$ test-expr '\''a <= (!B || C)'\'''
test-expr 'a <= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B || C)'\'''

echo '$ test-expr '\''a >= (!B <= C)'\'''
test-expr 'a >= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B <= C)'\'''

echo '$ test-expr '\''a >= (!B >= C)'\'''
test-expr 'a >= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B >= C)'\'''

echo '$ test-expr '\''a >= (!B == C)'\'''
test-expr 'a >= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B == C)'\'''

echo '$ test-expr '\''a >= (!B != C)'\'''
test-expr 'a >= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B != C)'\'''

echo '$ test-expr '\''a >= (!B && C)'\'''
test-expr 'a >= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B && C)'\'''

echo '$ test-expr '\''a >= (!B || C)'\'''
test-expr 'a >= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B || C)'\'''

echo '$ test-expr '\''a == (!B <= C)'\'''
test-expr 'a == (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B <= C)'\'''

echo '$ test-expr '\''a == (!B >= C)'\'''
test-expr 'a == (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B >= C)'\'''

echo '$ test-expr '\''a == (!B == C)'\'''
test-expr 'a == (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B == C)'\'''

echo '$ test-expr '\''a == (!B != C)'\'''
test-expr 'a == (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B != C)'\'''

echo '$ test-expr '\''a == (!B && C)'\'''
test-expr 'a == (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B && C)'\'''

echo '$ test-expr '\''a == (!B || C)'\'''
test-expr 'a == (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B || C)'\'''

echo '$ test-expr '\''a != (!B <= C)'\'''
test-expr 'a != (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B <= C)'\'''

echo '$ test-expr '\''a != (!B >= C)'\'''
test-expr 'a != (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B >= C)'\'''

echo '$ test-expr '\''a != (!B == C)'\'''
test-expr 'a != (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B == C)'\'''

echo '$ test-expr '\''a != (!B != C)'\'''
test-expr 'a != (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B != C)'\'''

echo '$ test-expr '\''a != (!B && C)'\'''
test-expr 'a != (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B && C)'\'''

echo '$ test-expr '\''a != (!B || C)'\'''
test-expr 'a != (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B || C)'\'''

echo '$ test-expr '\''a && (!B <= C)'\'''
test-expr 'a && (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B <= C)'\'''

echo '$ test-expr '\''a && (!B >= C)'\'''
test-expr 'a && (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B >= C)'\'''

echo '$ test-expr '\''a && (!B == C)'\'''
test-expr 'a && (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B == C)'\'''

echo '$ test-expr '\''a && (!B != C)'\'''
test-expr 'a && (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B != C)'\'''

echo '$ test-expr '\''a && (!B && C)'\'''
test-expr 'a && (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B && C)'\'''

echo '$ test-expr '\''a && (!B || C)'\'''
test-expr 'a && (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B || C)'\'''

echo '$ test-expr '\''a || (!B <= C)'\'''
test-expr 'a || (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B <= C)'\'''

echo '$ test-expr '\''a || (!B >= C)'\'''
test-expr 'a || (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B >= C)'\'''

echo '$ test-expr '\''a || (!B == C)'\'''
test-expr 'a || (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B == C)'\'''

echo '$ test-expr '\''a || (!B != C)'\'''
test-expr 'a || (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B != C)'\'''

echo '$ test-expr '\''a || (!B && C)'\'''
test-expr 'a || (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B && C)'\'''

echo '$ test-expr '\''a || (!B || C)'\'''
test-expr 'a || (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B || C)'\'''

echo '$ test-expr '\''a <= (!B <= !c)'\'''
test-expr 'a <= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B <= !c)'\'''

echo '$ test-expr '\''a <= (!B >= !c)'\'''
test-expr 'a <= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B >= !c)'\'''

echo '$ test-expr '\''a <= (!B == !c)'\'''
test-expr 'a <= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B == !c)'\'''

echo '$ test-expr '\''a <= (!B != !c)'\'''
test-expr 'a <= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B != !c)'\'''

echo '$ test-expr '\''a <= (!B && !c)'\'''
test-expr 'a <= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B && !c)'\'''

echo '$ test-expr '\''a <= (!B || !c)'\'''
test-expr 'a <= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B || !c)'\'''

echo '$ test-expr '\''a >= (!B <= !c)'\'''
test-expr 'a >= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B <= !c)'\'''

echo '$ test-expr '\''a >= (!B >= !c)'\'''
test-expr 'a >= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B >= !c)'\'''

echo '$ test-expr '\''a >= (!B == !c)'\'''
test-expr 'a >= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B == !c)'\'''

echo '$ test-expr '\''a >= (!B != !c)'\'''
test-expr 'a >= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B != !c)'\'''

echo '$ test-expr '\''a >= (!B && !c)'\'''
test-expr 'a >= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B && !c)'\'''

echo '$ test-expr '\''a >= (!B || !c)'\'''
test-expr 'a >= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B || !c)'\'''

echo '$ test-expr '\''a == (!B <= !c)'\'''
test-expr 'a == (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B <= !c)'\'''

echo '$ test-expr '\''a == (!B >= !c)'\'''
test-expr 'a == (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B >= !c)'\'''

echo '$ test-expr '\''a == (!B == !c)'\'''
test-expr 'a == (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B == !c)'\'''

echo '$ test-expr '\''a == (!B != !c)'\'''
test-expr 'a == (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B != !c)'\'''

echo '$ test-expr '\''a == (!B && !c)'\'''
test-expr 'a == (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B && !c)'\'''

echo '$ test-expr '\''a == (!B || !c)'\'''
test-expr 'a == (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B || !c)'\'''

echo '$ test-expr '\''a != (!B <= !c)'\'''
test-expr 'a != (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B <= !c)'\'''

echo '$ test-expr '\''a != (!B >= !c)'\'''
test-expr 'a != (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B >= !c)'\'''

echo '$ test-expr '\''a != (!B == !c)'\'''
test-expr 'a != (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B == !c)'\'''

echo '$ test-expr '\''a != (!B != !c)'\'''
test-expr 'a != (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B != !c)'\'''

echo '$ test-expr '\''a != (!B && !c)'\'''
test-expr 'a != (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B && !c)'\'''

echo '$ test-expr '\''a != (!B || !c)'\'''
test-expr 'a != (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B || !c)'\'''

echo '$ test-expr '\''a && (!B <= !c)'\'''
test-expr 'a && (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B <= !c)'\'''

echo '$ test-expr '\''a && (!B >= !c)'\'''
test-expr 'a && (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B >= !c)'\'''

echo '$ test-expr '\''a && (!B == !c)'\'''
test-expr 'a && (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B == !c)'\'''

echo '$ test-expr '\''a && (!B != !c)'\'''
test-expr 'a && (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B != !c)'\'''

echo '$ test-expr '\''a && (!B && !c)'\'''
test-expr 'a && (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B && !c)'\'''

echo '$ test-expr '\''a && (!B || !c)'\'''
test-expr 'a && (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B || !c)'\'''

echo '$ test-expr '\''a || (!B <= !c)'\'''
test-expr 'a || (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B <= !c)'\'''

echo '$ test-expr '\''a || (!B >= !c)'\'''
test-expr 'a || (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B >= !c)'\'''

echo '$ test-expr '\''a || (!B == !c)'\'''
test-expr 'a || (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B == !c)'\'''

echo '$ test-expr '\''a || (!B != !c)'\'''
test-expr 'a || (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B != !c)'\'''

echo '$ test-expr '\''a || (!B && !c)'\'''
test-expr 'a || (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B && !c)'\'''

echo '$ test-expr '\''a || (!B || !c)'\'''
test-expr 'a || (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B || !c)'\'''

echo '$ test-expr '\''a <= (!B <= !C)'\'''
test-expr 'a <= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B <= !C)'\'''

echo '$ test-expr '\''a <= (!B >= !C)'\'''
test-expr 'a <= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B >= !C)'\'''

echo '$ test-expr '\''a <= (!B == !C)'\'''
test-expr 'a <= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B == !C)'\'''

echo '$ test-expr '\''a <= (!B != !C)'\'''
test-expr 'a <= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B != !C)'\'''

echo '$ test-expr '\''a <= (!B && !C)'\'''
test-expr 'a <= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B && !C)'\'''

echo '$ test-expr '\''a <= (!B || !C)'\'''
test-expr 'a <= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a <= (!B || !C)'\'''

echo '$ test-expr '\''a >= (!B <= !C)'\'''
test-expr 'a >= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B <= !C)'\'''

echo '$ test-expr '\''a >= (!B >= !C)'\'''
test-expr 'a >= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B >= !C)'\'''

echo '$ test-expr '\''a >= (!B == !C)'\'''
test-expr 'a >= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B == !C)'\'''

echo '$ test-expr '\''a >= (!B != !C)'\'''
test-expr 'a >= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B != !C)'\'''

echo '$ test-expr '\''a >= (!B && !C)'\'''
test-expr 'a >= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B && !C)'\'''

echo '$ test-expr '\''a >= (!B || !C)'\'''
test-expr 'a >= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (!B || !C)'\'''

echo '$ test-expr '\''a == (!B <= !C)'\'''
test-expr 'a == (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B <= !C)'\'''

echo '$ test-expr '\''a == (!B >= !C)'\'''
test-expr 'a == (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B >= !C)'\'''

echo '$ test-expr '\''a == (!B == !C)'\'''
test-expr 'a == (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B == !C)'\'''

echo '$ test-expr '\''a == (!B != !C)'\'''
test-expr 'a == (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B != !C)'\'''

echo '$ test-expr '\''a == (!B && !C)'\'''
test-expr 'a == (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B && !C)'\'''

echo '$ test-expr '\''a == (!B || !C)'\'''
test-expr 'a == (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a == (!B || !C)'\'''

echo '$ test-expr '\''a != (!B <= !C)'\'''
test-expr 'a != (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B <= !C)'\'''

echo '$ test-expr '\''a != (!B >= !C)'\'''
test-expr 'a != (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B >= !C)'\'''

echo '$ test-expr '\''a != (!B == !C)'\'''
test-expr 'a != (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B == !C)'\'''

echo '$ test-expr '\''a != (!B != !C)'\'''
test-expr 'a != (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B != !C)'\'''

echo '$ test-expr '\''a != (!B && !C)'\'''
test-expr 'a != (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B && !C)'\'''

echo '$ test-expr '\''a != (!B || !C)'\'''
test-expr 'a != (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a != (!B || !C)'\'''

echo '$ test-expr '\''a && (!B <= !C)'\'''
test-expr 'a && (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B <= !C)'\'''

echo '$ test-expr '\''a && (!B >= !C)'\'''
test-expr 'a && (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B >= !C)'\'''

echo '$ test-expr '\''a && (!B == !C)'\'''
test-expr 'a && (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B == !C)'\'''

echo '$ test-expr '\''a && (!B != !C)'\'''
test-expr 'a && (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B != !C)'\'''

echo '$ test-expr '\''a && (!B && !C)'\'''
test-expr 'a && (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B && !C)'\'''

echo '$ test-expr '\''a && (!B || !C)'\'''
test-expr 'a && (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a && (!B || !C)'\'''

echo '$ test-expr '\''a || (!B <= !C)'\'''
test-expr 'a || (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B <= !C)'\'''

echo '$ test-expr '\''a || (!B >= !C)'\'''
test-expr 'a || (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B >= !C)'\'''

echo '$ test-expr '\''a || (!B == !C)'\'''
test-expr 'a || (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B == !C)'\'''

echo '$ test-expr '\''a || (!B != !C)'\'''
test-expr 'a || (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B != !C)'\'''

echo '$ test-expr '\''a || (!B && !C)'\'''
test-expr 'a || (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B && !C)'\'''

echo '$ test-expr '\''a || (!B || !C)'\'''
test-expr 'a || (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''a || (!B || !C)'\'''

echo '$ test-expr '\''A <= (b <= c)'\'''
test-expr 'A <= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b <= c)'\'''

echo '$ test-expr '\''A <= (b >= c)'\'''
test-expr 'A <= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b >= c)'\'''

echo '$ test-expr '\''A <= (b == c)'\'''
test-expr 'A <= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b == c)'\'''

echo '$ test-expr '\''A <= (b != c)'\'''
test-expr 'A <= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b != c)'\'''

echo '$ test-expr '\''A <= (b && c)'\'''
test-expr 'A <= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b && c)'\'''

echo '$ test-expr '\''A <= (b || c)'\'''
test-expr 'A <= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b || c)'\'''

echo '$ test-expr '\''A >= (b <= c)'\'''
test-expr 'A >= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b <= c)'\'''

echo '$ test-expr '\''A >= (b >= c)'\'''
test-expr 'A >= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b >= c)'\'''

echo '$ test-expr '\''A >= (b == c)'\'''
test-expr 'A >= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b == c)'\'''

echo '$ test-expr '\''A >= (b != c)'\'''
test-expr 'A >= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != c)'\'''

echo '$ test-expr '\''A >= (b && c)'\'''
test-expr 'A >= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && c)'\'''

echo '$ test-expr '\''A >= (b || c)'\'''
test-expr 'A >= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || c)'\'''

echo '$ test-expr '\''A == (b <= c)'\'''
test-expr 'A == (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b <= c)'\'''

echo '$ test-expr '\''A == (b >= c)'\'''
test-expr 'A == (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b >= c)'\'''

echo '$ test-expr '\''A == (b == c)'\'''
test-expr 'A == (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b == c)'\'''

echo '$ test-expr '\''A == (b != c)'\'''
test-expr 'A == (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b != c)'\'''

echo '$ test-expr '\''A == (b && c)'\'''
test-expr 'A == (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b && c)'\'''

echo '$ test-expr '\''A == (b || c)'\'''
test-expr 'A == (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b || c)'\'''

echo '$ test-expr '\''A != (b <= c)'\'''
test-expr 'A != (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b <= c)'\'''

echo '$ test-expr '\''A != (b >= c)'\'''
test-expr 'A != (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= c)'\'''

echo '$ test-expr '\''A != (b == c)'\'''
test-expr 'A != (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b == c)'\'''

echo '$ test-expr '\''A != (b != c)'\'''
test-expr 'A != (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b != c)'\'''

echo '$ test-expr '\''A != (b && c)'\'''
test-expr 'A != (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && c)'\'''

echo '$ test-expr '\''A != (b || c)'\'''
test-expr 'A != (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || c)'\'''

echo '$ test-expr '\''A && (b <= c)'\'''
test-expr 'A && (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b <= c)'\'''

echo '$ test-expr '\''A && (b >= c)'\'''
test-expr 'A && (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= c)'\'''

echo '$ test-expr '\''A && (b == c)'\'''
test-expr 'A && (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b == c)'\'''

echo '$ test-expr '\''A && (b != c)'\'''
test-expr 'A && (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != c)'\'''

echo '$ test-expr '\''A && (b && c)'\'''
test-expr 'A && (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b && c)'\'''

echo '$ test-expr '\''A && (b || c)'\'''
test-expr 'A && (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b || c)'\'''

echo '$ test-expr '\''A || (b <= c)'\'''
test-expr 'A || (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b <= c)'\'''

echo '$ test-expr '\''A || (b >= c)'\'''
test-expr 'A || (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b >= c)'\'''

echo '$ test-expr '\''A || (b == c)'\'''
test-expr 'A || (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b == c)'\'''

echo '$ test-expr '\''A || (b != c)'\'''
test-expr 'A || (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b != c)'\'''

echo '$ test-expr '\''A || (b && c)'\'''
test-expr 'A || (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b && c)'\'''

echo '$ test-expr '\''A || (b || c)'\'''
test-expr 'A || (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b || c)'\'''

echo '$ test-expr '\''A <= (b <= C)'\'''
test-expr 'A <= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b <= C)'\'''

echo '$ test-expr '\''A <= (b >= C)'\'''
test-expr 'A <= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b >= C)'\'''

echo '$ test-expr '\''A <= (b == C)'\'''
test-expr 'A <= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b == C)'\'''

echo '$ test-expr '\''A <= (b != C)'\'''
test-expr 'A <= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b != C)'\'''

echo '$ test-expr '\''A <= (b && C)'\'''
test-expr 'A <= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b && C)'\'''

echo '$ test-expr '\''A <= (b || C)'\'''
test-expr 'A <= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b || C)'\'''

echo '$ test-expr '\''A >= (b <= C)'\'''
test-expr 'A >= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b <= C)'\'''

echo '$ test-expr '\''A >= (b >= C)'\'''
test-expr 'A >= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b >= C)'\'''

echo '$ test-expr '\''A >= (b == C)'\'''
test-expr 'A >= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b == C)'\'''

echo '$ test-expr '\''A >= (b != C)'\'''
test-expr 'A >= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != C)'\'''

echo '$ test-expr '\''A >= (b && C)'\'''
test-expr 'A >= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && C)'\'''

echo '$ test-expr '\''A >= (b || C)'\'''
test-expr 'A >= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || C)'\'''

echo '$ test-expr '\''A == (b <= C)'\'''
test-expr 'A == (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b <= C)'\'''

echo '$ test-expr '\''A == (b >= C)'\'''
test-expr 'A == (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b >= C)'\'''

echo '$ test-expr '\''A == (b == C)'\'''
test-expr 'A == (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b == C)'\'''

echo '$ test-expr '\''A == (b != C)'\'''
test-expr 'A == (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b != C)'\'''

echo '$ test-expr '\''A == (b && C)'\'''
test-expr 'A == (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b && C)'\'''

echo '$ test-expr '\''A == (b || C)'\'''
test-expr 'A == (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b || C)'\'''

echo '$ test-expr '\''A != (b <= C)'\'''
test-expr 'A != (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b <= C)'\'''

echo '$ test-expr '\''A != (b >= C)'\'''
test-expr 'A != (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= C)'\'''

echo '$ test-expr '\''A != (b == C)'\'''
test-expr 'A != (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b == C)'\'''

echo '$ test-expr '\''A != (b != C)'\'''
test-expr 'A != (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b != C)'\'''

echo '$ test-expr '\''A != (b && C)'\'''
test-expr 'A != (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && C)'\'''

echo '$ test-expr '\''A != (b || C)'\'''
test-expr 'A != (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || C)'\'''

echo '$ test-expr '\''A && (b <= C)'\'''
test-expr 'A && (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b <= C)'\'''

echo '$ test-expr '\''A && (b >= C)'\'''
test-expr 'A && (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= C)'\'''

echo '$ test-expr '\''A && (b == C)'\'''
test-expr 'A && (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b == C)'\'''

echo '$ test-expr '\''A && (b != C)'\'''
test-expr 'A && (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != C)'\'''

echo '$ test-expr '\''A && (b && C)'\'''
test-expr 'A && (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b && C)'\'''

echo '$ test-expr '\''A && (b || C)'\'''
test-expr 'A && (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b || C)'\'''

echo '$ test-expr '\''A || (b <= C)'\'''
test-expr 'A || (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b <= C)'\'''

echo '$ test-expr '\''A || (b >= C)'\'''
test-expr 'A || (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b >= C)'\'''

echo '$ test-expr '\''A || (b == C)'\'''
test-expr 'A || (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b == C)'\'''

echo '$ test-expr '\''A || (b != C)'\'''
test-expr 'A || (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b != C)'\'''

echo '$ test-expr '\''A || (b && C)'\'''
test-expr 'A || (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b && C)'\'''

echo '$ test-expr '\''A || (b || C)'\'''
test-expr 'A || (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b || C)'\'''

echo '$ test-expr '\''A <= (b <= !c)'\'''
test-expr 'A <= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b <= !c)'\'''

echo '$ test-expr '\''A <= (b >= !c)'\'''
test-expr 'A <= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b >= !c)'\'''

echo '$ test-expr '\''A <= (b == !c)'\'''
test-expr 'A <= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b == !c)'\'''

echo '$ test-expr '\''A <= (b != !c)'\'''
test-expr 'A <= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b != !c)'\'''

echo '$ test-expr '\''A <= (b && !c)'\'''
test-expr 'A <= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b && !c)'\'''

echo '$ test-expr '\''A <= (b || !c)'\'''
test-expr 'A <= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b || !c)'\'''

echo '$ test-expr '\''A >= (b <= !c)'\'''
test-expr 'A >= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b <= !c)'\'''

echo '$ test-expr '\''A >= (b >= !c)'\'''
test-expr 'A >= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b >= !c)'\'''

echo '$ test-expr '\''A >= (b == !c)'\'''
test-expr 'A >= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b == !c)'\'''

echo '$ test-expr '\''A >= (b != !c)'\'''
test-expr 'A >= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != !c)'\'''

echo '$ test-expr '\''A >= (b && !c)'\'''
test-expr 'A >= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && !c)'\'''

echo '$ test-expr '\''A >= (b || !c)'\'''
test-expr 'A >= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || !c)'\'''

echo '$ test-expr '\''A == (b <= !c)'\'''
test-expr 'A == (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b <= !c)'\'''

echo '$ test-expr '\''A == (b >= !c)'\'''
test-expr 'A == (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b >= !c)'\'''

echo '$ test-expr '\''A == (b == !c)'\'''
test-expr 'A == (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b == !c)'\'''

echo '$ test-expr '\''A == (b != !c)'\'''
test-expr 'A == (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b != !c)'\'''

echo '$ test-expr '\''A == (b && !c)'\'''
test-expr 'A == (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b && !c)'\'''

echo '$ test-expr '\''A == (b || !c)'\'''
test-expr 'A == (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b || !c)'\'''

echo '$ test-expr '\''A != (b <= !c)'\'''
test-expr 'A != (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b <= !c)'\'''

echo '$ test-expr '\''A != (b >= !c)'\'''
test-expr 'A != (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= !c)'\'''

echo '$ test-expr '\''A != (b == !c)'\'''
test-expr 'A != (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b == !c)'\'''

echo '$ test-expr '\''A != (b != !c)'\'''
test-expr 'A != (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b != !c)'\'''

echo '$ test-expr '\''A != (b && !c)'\'''
test-expr 'A != (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && !c)'\'''

echo '$ test-expr '\''A != (b || !c)'\'''
test-expr 'A != (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || !c)'\'''

echo '$ test-expr '\''A && (b <= !c)'\'''
test-expr 'A && (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b <= !c)'\'''

echo '$ test-expr '\''A && (b >= !c)'\'''
test-expr 'A && (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= !c)'\'''

echo '$ test-expr '\''A && (b == !c)'\'''
test-expr 'A && (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b == !c)'\'''

echo '$ test-expr '\''A && (b != !c)'\'''
test-expr 'A && (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != !c)'\'''

echo '$ test-expr '\''A && (b && !c)'\'''
test-expr 'A && (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b && !c)'\'''

echo '$ test-expr '\''A && (b || !c)'\'''
test-expr 'A && (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b || !c)'\'''

echo '$ test-expr '\''A || (b <= !c)'\'''
test-expr 'A || (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b <= !c)'\'''

echo '$ test-expr '\''A || (b >= !c)'\'''
test-expr 'A || (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b >= !c)'\'''

echo '$ test-expr '\''A || (b == !c)'\'''
test-expr 'A || (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b == !c)'\'''

echo '$ test-expr '\''A || (b != !c)'\'''
test-expr 'A || (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b != !c)'\'''

echo '$ test-expr '\''A || (b && !c)'\'''
test-expr 'A || (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b && !c)'\'''

echo '$ test-expr '\''A || (b || !c)'\'''
test-expr 'A || (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b || !c)'\'''

echo '$ test-expr '\''A <= (b <= !C)'\'''
test-expr 'A <= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b <= !C)'\'''

echo '$ test-expr '\''A <= (b >= !C)'\'''
test-expr 'A <= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b >= !C)'\'''

echo '$ test-expr '\''A <= (b == !C)'\'''
test-expr 'A <= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b == !C)'\'''

echo '$ test-expr '\''A <= (b != !C)'\'''
test-expr 'A <= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b != !C)'\'''

echo '$ test-expr '\''A <= (b && !C)'\'''
test-expr 'A <= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b && !C)'\'''

echo '$ test-expr '\''A <= (b || !C)'\'''
test-expr 'A <= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (b || !C)'\'''

echo '$ test-expr '\''A >= (b <= !C)'\'''
test-expr 'A >= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b <= !C)'\'''

echo '$ test-expr '\''A >= (b >= !C)'\'''
test-expr 'A >= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b >= !C)'\'''

echo '$ test-expr '\''A >= (b == !C)'\'''
test-expr 'A >= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b == !C)'\'''

echo '$ test-expr '\''A >= (b != !C)'\'''
test-expr 'A >= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != !C)'\'''

echo '$ test-expr '\''A >= (b && !C)'\'''
test-expr 'A >= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && !C)'\'''

echo '$ test-expr '\''A >= (b || !C)'\'''
test-expr 'A >= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || !C)'\'''

echo '$ test-expr '\''A == (b <= !C)'\'''
test-expr 'A == (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b <= !C)'\'''

echo '$ test-expr '\''A == (b >= !C)'\'''
test-expr 'A == (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b >= !C)'\'''

echo '$ test-expr '\''A == (b == !C)'\'''
test-expr 'A == (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b == !C)'\'''

echo '$ test-expr '\''A == (b != !C)'\'''
test-expr 'A == (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b != !C)'\'''

echo '$ test-expr '\''A == (b && !C)'\'''
test-expr 'A == (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b && !C)'\'''

echo '$ test-expr '\''A == (b || !C)'\'''
test-expr 'A == (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (b || !C)'\'''

echo '$ test-expr '\''A != (b <= !C)'\'''
test-expr 'A != (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b <= !C)'\'''

echo '$ test-expr '\''A != (b >= !C)'\'''
test-expr 'A != (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= !C)'\'''

echo '$ test-expr '\''A != (b == !C)'\'''
test-expr 'A != (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b == !C)'\'''

echo '$ test-expr '\''A != (b != !C)'\'''
test-expr 'A != (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b != !C)'\'''

echo '$ test-expr '\''A != (b && !C)'\'''
test-expr 'A != (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && !C)'\'''

echo '$ test-expr '\''A != (b || !C)'\'''
test-expr 'A != (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || !C)'\'''

echo '$ test-expr '\''A && (b <= !C)'\'''
test-expr 'A && (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b <= !C)'\'''

echo '$ test-expr '\''A && (b >= !C)'\'''
test-expr 'A && (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= !C)'\'''

echo '$ test-expr '\''A && (b == !C)'\'''
test-expr 'A && (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b == !C)'\'''

echo '$ test-expr '\''A && (b != !C)'\'''
test-expr 'A && (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != !C)'\'''

echo '$ test-expr '\''A && (b && !C)'\'''
test-expr 'A && (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b && !C)'\'''

echo '$ test-expr '\''A && (b || !C)'\'''
test-expr 'A && (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (b || !C)'\'''

echo '$ test-expr '\''A || (b <= !C)'\'''
test-expr 'A || (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b <= !C)'\'''

echo '$ test-expr '\''A || (b >= !C)'\'''
test-expr 'A || (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b >= !C)'\'''

echo '$ test-expr '\''A || (b == !C)'\'''
test-expr 'A || (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b == !C)'\'''

echo '$ test-expr '\''A || (b != !C)'\'''
test-expr 'A || (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b != !C)'\'''

echo '$ test-expr '\''A || (b && !C)'\'''
test-expr 'A || (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b && !C)'\'''

echo '$ test-expr '\''A || (b || !C)'\'''
test-expr 'A || (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (b || !C)'\'''

echo '$ test-expr '\''A <= (B <= c)'\'''
test-expr 'A <= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B <= c)'\'''

echo '$ test-expr '\''A <= (B >= c)'\'''
test-expr 'A <= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B >= c)'\'''

echo '$ test-expr '\''A <= (B == c)'\'''
test-expr 'A <= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B == c)'\'''

echo '$ test-expr '\''A <= (B != c)'\'''
test-expr 'A <= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B != c)'\'''

echo '$ test-expr '\''A <= (B && c)'\'''
test-expr 'A <= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B && c)'\'''

echo '$ test-expr '\''A <= (B || c)'\'''
test-expr 'A <= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B || c)'\'''

echo '$ test-expr '\''A >= (B <= c)'\'''
test-expr 'A >= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B <= c)'\'''

echo '$ test-expr '\''A >= (B >= c)'\'''
test-expr 'A >= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B >= c)'\'''

echo '$ test-expr '\''A >= (B == c)'\'''
test-expr 'A >= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B == c)'\'''

echo '$ test-expr '\''A >= (B != c)'\'''
test-expr 'A >= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != c)'\'''

echo '$ test-expr '\''A >= (B && c)'\'''
test-expr 'A >= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && c)'\'''

echo '$ test-expr '\''A >= (B || c)'\'''
test-expr 'A >= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || c)'\'''

echo '$ test-expr '\''A == (B <= c)'\'''
test-expr 'A == (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B <= c)'\'''

echo '$ test-expr '\''A == (B >= c)'\'''
test-expr 'A == (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B >= c)'\'''

echo '$ test-expr '\''A == (B == c)'\'''
test-expr 'A == (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B == c)'\'''

echo '$ test-expr '\''A == (B != c)'\'''
test-expr 'A == (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B != c)'\'''

echo '$ test-expr '\''A == (B && c)'\'''
test-expr 'A == (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B && c)'\'''

echo '$ test-expr '\''A == (B || c)'\'''
test-expr 'A == (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B || c)'\'''

echo '$ test-expr '\''A != (B <= c)'\'''
test-expr 'A != (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B <= c)'\'''

echo '$ test-expr '\''A != (B >= c)'\'''
test-expr 'A != (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= c)'\'''

echo '$ test-expr '\''A != (B == c)'\'''
test-expr 'A != (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B == c)'\'''

echo '$ test-expr '\''A != (B != c)'\'''
test-expr 'A != (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B != c)'\'''

echo '$ test-expr '\''A != (B && c)'\'''
test-expr 'A != (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && c)'\'''

echo '$ test-expr '\''A != (B || c)'\'''
test-expr 'A != (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || c)'\'''

echo '$ test-expr '\''A && (B <= c)'\'''
test-expr 'A && (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B <= c)'\'''

echo '$ test-expr '\''A && (B >= c)'\'''
test-expr 'A && (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= c)'\'''

echo '$ test-expr '\''A && (B == c)'\'''
test-expr 'A && (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B == c)'\'''

echo '$ test-expr '\''A && (B != c)'\'''
test-expr 'A && (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != c)'\'''

echo '$ test-expr '\''A && (B && c)'\'''
test-expr 'A && (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B && c)'\'''

echo '$ test-expr '\''A && (B || c)'\'''
test-expr 'A && (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B || c)'\'''

echo '$ test-expr '\''A || (B <= c)'\'''
test-expr 'A || (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B <= c)'\'''

echo '$ test-expr '\''A || (B >= c)'\'''
test-expr 'A || (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B >= c)'\'''

echo '$ test-expr '\''A || (B == c)'\'''
test-expr 'A || (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B == c)'\'''

echo '$ test-expr '\''A || (B != c)'\'''
test-expr 'A || (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B != c)'\'''

echo '$ test-expr '\''A || (B && c)'\'''
test-expr 'A || (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B && c)'\'''

echo '$ test-expr '\''A || (B || c)'\'''
test-expr 'A || (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B || c)'\'''

echo '$ test-expr '\''A <= (B <= C)'\'''
test-expr 'A <= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B <= C)'\'''

echo '$ test-expr '\''A <= (B >= C)'\'''
test-expr 'A <= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B >= C)'\'''

echo '$ test-expr '\''A <= (B == C)'\'''
test-expr 'A <= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B == C)'\'''

echo '$ test-expr '\''A <= (B != C)'\'''
test-expr 'A <= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B != C)'\'''

echo '$ test-expr '\''A <= (B && C)'\'''
test-expr 'A <= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B && C)'\'''

echo '$ test-expr '\''A <= (B || C)'\'''
test-expr 'A <= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B || C)'\'''

echo '$ test-expr '\''A >= (B <= C)'\'''
test-expr 'A >= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B <= C)'\'''

echo '$ test-expr '\''A >= (B >= C)'\'''
test-expr 'A >= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B >= C)'\'''

echo '$ test-expr '\''A >= (B == C)'\'''
test-expr 'A >= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B == C)'\'''

echo '$ test-expr '\''A >= (B != C)'\'''
test-expr 'A >= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != C)'\'''

echo '$ test-expr '\''A >= (B && C)'\'''
test-expr 'A >= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && C)'\'''

echo '$ test-expr '\''A >= (B || C)'\'''
test-expr 'A >= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || C)'\'''

echo '$ test-expr '\''A == (B <= C)'\'''
test-expr 'A == (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B <= C)'\'''

echo '$ test-expr '\''A == (B >= C)'\'''
test-expr 'A == (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B >= C)'\'''

echo '$ test-expr '\''A == (B == C)'\'''
test-expr 'A == (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B == C)'\'''

echo '$ test-expr '\''A == (B != C)'\'''
test-expr 'A == (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B != C)'\'''

echo '$ test-expr '\''A == (B && C)'\'''
test-expr 'A == (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B && C)'\'''

echo '$ test-expr '\''A == (B || C)'\'''
test-expr 'A == (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B || C)'\'''

echo '$ test-expr '\''A != (B <= C)'\'''
test-expr 'A != (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B <= C)'\'''

echo '$ test-expr '\''A != (B >= C)'\'''
test-expr 'A != (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= C)'\'''

echo '$ test-expr '\''A != (B == C)'\'''
test-expr 'A != (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B == C)'\'''

echo '$ test-expr '\''A != (B != C)'\'''
test-expr 'A != (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B != C)'\'''

echo '$ test-expr '\''A != (B && C)'\'''
test-expr 'A != (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && C)'\'''

echo '$ test-expr '\''A != (B || C)'\'''
test-expr 'A != (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || C)'\'''

echo '$ test-expr '\''A && (B <= C)'\'''
test-expr 'A && (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B <= C)'\'''

echo '$ test-expr '\''A && (B >= C)'\'''
test-expr 'A && (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= C)'\'''

echo '$ test-expr '\''A && (B == C)'\'''
test-expr 'A && (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B == C)'\'''

echo '$ test-expr '\''A && (B != C)'\'''
test-expr 'A && (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != C)'\'''

echo '$ test-expr '\''A && (B && C)'\'''
test-expr 'A && (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B && C)'\'''

echo '$ test-expr '\''A && (B || C)'\'''
test-expr 'A && (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B || C)'\'''

echo '$ test-expr '\''A || (B <= C)'\'''
test-expr 'A || (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B <= C)'\'''

echo '$ test-expr '\''A || (B >= C)'\'''
test-expr 'A || (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B >= C)'\'''

echo '$ test-expr '\''A || (B == C)'\'''
test-expr 'A || (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B == C)'\'''

echo '$ test-expr '\''A || (B != C)'\'''
test-expr 'A || (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B != C)'\'''

echo '$ test-expr '\''A || (B && C)'\'''
test-expr 'A || (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B && C)'\'''

echo '$ test-expr '\''A || (B || C)'\'''
test-expr 'A || (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B || C)'\'''

echo '$ test-expr '\''A <= (B <= !c)'\'''
test-expr 'A <= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B <= !c)'\'''

echo '$ test-expr '\''A <= (B >= !c)'\'''
test-expr 'A <= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B >= !c)'\'''

echo '$ test-expr '\''A <= (B == !c)'\'''
test-expr 'A <= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B == !c)'\'''

echo '$ test-expr '\''A <= (B != !c)'\'''
test-expr 'A <= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B != !c)'\'''

echo '$ test-expr '\''A <= (B && !c)'\'''
test-expr 'A <= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B && !c)'\'''

echo '$ test-expr '\''A <= (B || !c)'\'''
test-expr 'A <= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B || !c)'\'''

echo '$ test-expr '\''A >= (B <= !c)'\'''
test-expr 'A >= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B <= !c)'\'''

echo '$ test-expr '\''A >= (B >= !c)'\'''
test-expr 'A >= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B >= !c)'\'''

echo '$ test-expr '\''A >= (B == !c)'\'''
test-expr 'A >= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B == !c)'\'''

echo '$ test-expr '\''A >= (B != !c)'\'''
test-expr 'A >= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != !c)'\'''

echo '$ test-expr '\''A >= (B && !c)'\'''
test-expr 'A >= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && !c)'\'''

echo '$ test-expr '\''A >= (B || !c)'\'''
test-expr 'A >= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || !c)'\'''

echo '$ test-expr '\''A == (B <= !c)'\'''
test-expr 'A == (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B <= !c)'\'''

echo '$ test-expr '\''A == (B >= !c)'\'''
test-expr 'A == (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B >= !c)'\'''

echo '$ test-expr '\''A == (B == !c)'\'''
test-expr 'A == (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B == !c)'\'''

echo '$ test-expr '\''A == (B != !c)'\'''
test-expr 'A == (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B != !c)'\'''

echo '$ test-expr '\''A == (B && !c)'\'''
test-expr 'A == (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B && !c)'\'''

echo '$ test-expr '\''A == (B || !c)'\'''
test-expr 'A == (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B || !c)'\'''

echo '$ test-expr '\''A != (B <= !c)'\'''
test-expr 'A != (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B <= !c)'\'''

echo '$ test-expr '\''A != (B >= !c)'\'''
test-expr 'A != (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= !c)'\'''

echo '$ test-expr '\''A != (B == !c)'\'''
test-expr 'A != (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B == !c)'\'''

echo '$ test-expr '\''A != (B != !c)'\'''
test-expr 'A != (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B != !c)'\'''

echo '$ test-expr '\''A != (B && !c)'\'''
test-expr 'A != (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && !c)'\'''

echo '$ test-expr '\''A != (B || !c)'\'''
test-expr 'A != (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || !c)'\'''

echo '$ test-expr '\''A && (B <= !c)'\'''
test-expr 'A && (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B <= !c)'\'''

echo '$ test-expr '\''A && (B >= !c)'\'''
test-expr 'A && (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= !c)'\'''

echo '$ test-expr '\''A && (B == !c)'\'''
test-expr 'A && (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B == !c)'\'''

echo '$ test-expr '\''A && (B != !c)'\'''
test-expr 'A && (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != !c)'\'''

echo '$ test-expr '\''A && (B && !c)'\'''
test-expr 'A && (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B && !c)'\'''

echo '$ test-expr '\''A && (B || !c)'\'''
test-expr 'A && (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B || !c)'\'''

echo '$ test-expr '\''A || (B <= !c)'\'''
test-expr 'A || (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B <= !c)'\'''

echo '$ test-expr '\''A || (B >= !c)'\'''
test-expr 'A || (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B >= !c)'\'''

echo '$ test-expr '\''A || (B == !c)'\'''
test-expr 'A || (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B == !c)'\'''

echo '$ test-expr '\''A || (B != !c)'\'''
test-expr 'A || (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B != !c)'\'''

echo '$ test-expr '\''A || (B && !c)'\'''
test-expr 'A || (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B && !c)'\'''

echo '$ test-expr '\''A || (B || !c)'\'''
test-expr 'A || (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B || !c)'\'''

echo '$ test-expr '\''A <= (B <= !C)'\'''
test-expr 'A <= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B <= !C)'\'''

echo '$ test-expr '\''A <= (B >= !C)'\'''
test-expr 'A <= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B >= !C)'\'''

echo '$ test-expr '\''A <= (B == !C)'\'''
test-expr 'A <= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B == !C)'\'''

echo '$ test-expr '\''A <= (B != !C)'\'''
test-expr 'A <= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B != !C)'\'''

echo '$ test-expr '\''A <= (B && !C)'\'''
test-expr 'A <= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B && !C)'\'''

echo '$ test-expr '\''A <= (B || !C)'\'''
test-expr 'A <= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (B || !C)'\'''

echo '$ test-expr '\''A >= (B <= !C)'\'''
test-expr 'A >= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B <= !C)'\'''

echo '$ test-expr '\''A >= (B >= !C)'\'''
test-expr 'A >= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B >= !C)'\'''

echo '$ test-expr '\''A >= (B == !C)'\'''
test-expr 'A >= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B == !C)'\'''

echo '$ test-expr '\''A >= (B != !C)'\'''
test-expr 'A >= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != !C)'\'''

echo '$ test-expr '\''A >= (B && !C)'\'''
test-expr 'A >= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && !C)'\'''

echo '$ test-expr '\''A >= (B || !C)'\'''
test-expr 'A >= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || !C)'\'''

echo '$ test-expr '\''A == (B <= !C)'\'''
test-expr 'A == (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B <= !C)'\'''

echo '$ test-expr '\''A == (B >= !C)'\'''
test-expr 'A == (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B >= !C)'\'''

echo '$ test-expr '\''A == (B == !C)'\'''
test-expr 'A == (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B == !C)'\'''

echo '$ test-expr '\''A == (B != !C)'\'''
test-expr 'A == (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B != !C)'\'''

echo '$ test-expr '\''A == (B && !C)'\'''
test-expr 'A == (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B && !C)'\'''

echo '$ test-expr '\''A == (B || !C)'\'''
test-expr 'A == (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (B || !C)'\'''

echo '$ test-expr '\''A != (B <= !C)'\'''
test-expr 'A != (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B <= !C)'\'''

echo '$ test-expr '\''A != (B >= !C)'\'''
test-expr 'A != (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= !C)'\'''

echo '$ test-expr '\''A != (B == !C)'\'''
test-expr 'A != (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B == !C)'\'''

echo '$ test-expr '\''A != (B != !C)'\'''
test-expr 'A != (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B != !C)'\'''

echo '$ test-expr '\''A != (B && !C)'\'''
test-expr 'A != (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && !C)'\'''

echo '$ test-expr '\''A != (B || !C)'\'''
test-expr 'A != (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || !C)'\'''

echo '$ test-expr '\''A && (B <= !C)'\'''
test-expr 'A && (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B <= !C)'\'''

echo '$ test-expr '\''A && (B >= !C)'\'''
test-expr 'A && (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= !C)'\'''

echo '$ test-expr '\''A && (B == !C)'\'''
test-expr 'A && (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B == !C)'\'''

echo '$ test-expr '\''A && (B != !C)'\'''
test-expr 'A && (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != !C)'\'''

echo '$ test-expr '\''A && (B && !C)'\'''
test-expr 'A && (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B && !C)'\'''

echo '$ test-expr '\''A && (B || !C)'\'''
test-expr 'A && (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (B || !C)'\'''

echo '$ test-expr '\''A || (B <= !C)'\'''
test-expr 'A || (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B <= !C)'\'''

echo '$ test-expr '\''A || (B >= !C)'\'''
test-expr 'A || (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B >= !C)'\'''

echo '$ test-expr '\''A || (B == !C)'\'''
test-expr 'A || (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B == !C)'\'''

echo '$ test-expr '\''A || (B != !C)'\'''
test-expr 'A || (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B != !C)'\'''

echo '$ test-expr '\''A || (B && !C)'\'''
test-expr 'A || (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B && !C)'\'''

echo '$ test-expr '\''A || (B || !C)'\'''
test-expr 'A || (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (B || !C)'\'''

echo '$ test-expr '\''A <= (!b <= c)'\'''
test-expr 'A <= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b <= c)'\'''

echo '$ test-expr '\''A <= (!b >= c)'\'''
test-expr 'A <= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b >= c)'\'''

echo '$ test-expr '\''A <= (!b == c)'\'''
test-expr 'A <= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b == c)'\'''

echo '$ test-expr '\''A <= (!b != c)'\'''
test-expr 'A <= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b != c)'\'''

echo '$ test-expr '\''A <= (!b && c)'\'''
test-expr 'A <= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b && c)'\'''

echo '$ test-expr '\''A <= (!b || c)'\'''
test-expr 'A <= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b || c)'\'''

echo '$ test-expr '\''A >= (!b <= c)'\'''
test-expr 'A >= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b <= c)'\'''

echo '$ test-expr '\''A >= (!b >= c)'\'''
test-expr 'A >= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b >= c)'\'''

echo '$ test-expr '\''A >= (!b == c)'\'''
test-expr 'A >= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b == c)'\'''

echo '$ test-expr '\''A >= (!b != c)'\'''
test-expr 'A >= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b != c)'\'''

echo '$ test-expr '\''A >= (!b && c)'\'''
test-expr 'A >= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b && c)'\'''

echo '$ test-expr '\''A >= (!b || c)'\'''
test-expr 'A >= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b || c)'\'''

echo '$ test-expr '\''A == (!b <= c)'\'''
test-expr 'A == (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b <= c)'\'''

echo '$ test-expr '\''A == (!b >= c)'\'''
test-expr 'A == (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b >= c)'\'''

echo '$ test-expr '\''A == (!b == c)'\'''
test-expr 'A == (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b == c)'\'''

echo '$ test-expr '\''A == (!b != c)'\'''
test-expr 'A == (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b != c)'\'''

echo '$ test-expr '\''A == (!b && c)'\'''
test-expr 'A == (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b && c)'\'''

echo '$ test-expr '\''A == (!b || c)'\'''
test-expr 'A == (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b || c)'\'''

echo '$ test-expr '\''A != (!b <= c)'\'''
test-expr 'A != (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b <= c)'\'''

echo '$ test-expr '\''A != (!b >= c)'\'''
test-expr 'A != (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b >= c)'\'''

echo '$ test-expr '\''A != (!b == c)'\'''
test-expr 'A != (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b == c)'\'''

echo '$ test-expr '\''A != (!b != c)'\'''
test-expr 'A != (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b != c)'\'''

echo '$ test-expr '\''A != (!b && c)'\'''
test-expr 'A != (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b && c)'\'''

echo '$ test-expr '\''A != (!b || c)'\'''
test-expr 'A != (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b || c)'\'''

echo '$ test-expr '\''A && (!b <= c)'\'''
test-expr 'A && (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b <= c)'\'''

echo '$ test-expr '\''A && (!b >= c)'\'''
test-expr 'A && (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b >= c)'\'''

echo '$ test-expr '\''A && (!b == c)'\'''
test-expr 'A && (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b == c)'\'''

echo '$ test-expr '\''A && (!b != c)'\'''
test-expr 'A && (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b != c)'\'''

echo '$ test-expr '\''A && (!b && c)'\'''
test-expr 'A && (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b && c)'\'''

echo '$ test-expr '\''A && (!b || c)'\'''
test-expr 'A && (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b || c)'\'''

echo '$ test-expr '\''A || (!b <= c)'\'''
test-expr 'A || (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b <= c)'\'''

echo '$ test-expr '\''A || (!b >= c)'\'''
test-expr 'A || (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b >= c)'\'''

echo '$ test-expr '\''A || (!b == c)'\'''
test-expr 'A || (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b == c)'\'''

echo '$ test-expr '\''A || (!b != c)'\'''
test-expr 'A || (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b != c)'\'''

echo '$ test-expr '\''A || (!b && c)'\'''
test-expr 'A || (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b && c)'\'''

echo '$ test-expr '\''A || (!b || c)'\'''
test-expr 'A || (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b || c)'\'''

echo '$ test-expr '\''A <= (!b <= C)'\'''
test-expr 'A <= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b <= C)'\'''

echo '$ test-expr '\''A <= (!b >= C)'\'''
test-expr 'A <= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b >= C)'\'''

echo '$ test-expr '\''A <= (!b == C)'\'''
test-expr 'A <= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b == C)'\'''

echo '$ test-expr '\''A <= (!b != C)'\'''
test-expr 'A <= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b != C)'\'''

echo '$ test-expr '\''A <= (!b && C)'\'''
test-expr 'A <= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b && C)'\'''

echo '$ test-expr '\''A <= (!b || C)'\'''
test-expr 'A <= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b || C)'\'''

echo '$ test-expr '\''A >= (!b <= C)'\'''
test-expr 'A >= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b <= C)'\'''

echo '$ test-expr '\''A >= (!b >= C)'\'''
test-expr 'A >= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b >= C)'\'''

echo '$ test-expr '\''A >= (!b == C)'\'''
test-expr 'A >= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b == C)'\'''

echo '$ test-expr '\''A >= (!b != C)'\'''
test-expr 'A >= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b != C)'\'''

echo '$ test-expr '\''A >= (!b && C)'\'''
test-expr 'A >= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b && C)'\'''

echo '$ test-expr '\''A >= (!b || C)'\'''
test-expr 'A >= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b || C)'\'''

echo '$ test-expr '\''A == (!b <= C)'\'''
test-expr 'A == (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b <= C)'\'''

echo '$ test-expr '\''A == (!b >= C)'\'''
test-expr 'A == (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b >= C)'\'''

echo '$ test-expr '\''A == (!b == C)'\'''
test-expr 'A == (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b == C)'\'''

echo '$ test-expr '\''A == (!b != C)'\'''
test-expr 'A == (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b != C)'\'''

echo '$ test-expr '\''A == (!b && C)'\'''
test-expr 'A == (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b && C)'\'''

echo '$ test-expr '\''A == (!b || C)'\'''
test-expr 'A == (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b || C)'\'''

echo '$ test-expr '\''A != (!b <= C)'\'''
test-expr 'A != (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b <= C)'\'''

echo '$ test-expr '\''A != (!b >= C)'\'''
test-expr 'A != (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b >= C)'\'''

echo '$ test-expr '\''A != (!b == C)'\'''
test-expr 'A != (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b == C)'\'''

echo '$ test-expr '\''A != (!b != C)'\'''
test-expr 'A != (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b != C)'\'''

echo '$ test-expr '\''A != (!b && C)'\'''
test-expr 'A != (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b && C)'\'''

echo '$ test-expr '\''A != (!b || C)'\'''
test-expr 'A != (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b || C)'\'''

echo '$ test-expr '\''A && (!b <= C)'\'''
test-expr 'A && (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b <= C)'\'''

echo '$ test-expr '\''A && (!b >= C)'\'''
test-expr 'A && (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b >= C)'\'''

echo '$ test-expr '\''A && (!b == C)'\'''
test-expr 'A && (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b == C)'\'''

echo '$ test-expr '\''A && (!b != C)'\'''
test-expr 'A && (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b != C)'\'''

echo '$ test-expr '\''A && (!b && C)'\'''
test-expr 'A && (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b && C)'\'''

echo '$ test-expr '\''A && (!b || C)'\'''
test-expr 'A && (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b || C)'\'''

echo '$ test-expr '\''A || (!b <= C)'\'''
test-expr 'A || (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b <= C)'\'''

echo '$ test-expr '\''A || (!b >= C)'\'''
test-expr 'A || (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b >= C)'\'''

echo '$ test-expr '\''A || (!b == C)'\'''
test-expr 'A || (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b == C)'\'''

echo '$ test-expr '\''A || (!b != C)'\'''
test-expr 'A || (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b != C)'\'''

echo '$ test-expr '\''A || (!b && C)'\'''
test-expr 'A || (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b && C)'\'''

echo '$ test-expr '\''A || (!b || C)'\'''
test-expr 'A || (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b || C)'\'''

echo '$ test-expr '\''A <= (!b <= !c)'\'''
test-expr 'A <= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b <= !c)'\'''

echo '$ test-expr '\''A <= (!b >= !c)'\'''
test-expr 'A <= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b >= !c)'\'''

echo '$ test-expr '\''A <= (!b == !c)'\'''
test-expr 'A <= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b == !c)'\'''

echo '$ test-expr '\''A <= (!b != !c)'\'''
test-expr 'A <= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b != !c)'\'''

echo '$ test-expr '\''A <= (!b && !c)'\'''
test-expr 'A <= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b && !c)'\'''

echo '$ test-expr '\''A <= (!b || !c)'\'''
test-expr 'A <= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b || !c)'\'''

echo '$ test-expr '\''A >= (!b <= !c)'\'''
test-expr 'A >= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b <= !c)'\'''

echo '$ test-expr '\''A >= (!b >= !c)'\'''
test-expr 'A >= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b >= !c)'\'''

echo '$ test-expr '\''A >= (!b == !c)'\'''
test-expr 'A >= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b == !c)'\'''

echo '$ test-expr '\''A >= (!b != !c)'\'''
test-expr 'A >= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b != !c)'\'''

echo '$ test-expr '\''A >= (!b && !c)'\'''
test-expr 'A >= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b && !c)'\'''

echo '$ test-expr '\''A >= (!b || !c)'\'''
test-expr 'A >= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b || !c)'\'''

echo '$ test-expr '\''A == (!b <= !c)'\'''
test-expr 'A == (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b <= !c)'\'''

echo '$ test-expr '\''A == (!b >= !c)'\'''
test-expr 'A == (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b >= !c)'\'''

echo '$ test-expr '\''A == (!b == !c)'\'''
test-expr 'A == (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b == !c)'\'''

echo '$ test-expr '\''A == (!b != !c)'\'''
test-expr 'A == (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b != !c)'\'''

echo '$ test-expr '\''A == (!b && !c)'\'''
test-expr 'A == (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b && !c)'\'''

echo '$ test-expr '\''A == (!b || !c)'\'''
test-expr 'A == (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b || !c)'\'''

echo '$ test-expr '\''A != (!b <= !c)'\'''
test-expr 'A != (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b <= !c)'\'''

echo '$ test-expr '\''A != (!b >= !c)'\'''
test-expr 'A != (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b >= !c)'\'''

echo '$ test-expr '\''A != (!b == !c)'\'''
test-expr 'A != (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b == !c)'\'''

echo '$ test-expr '\''A != (!b != !c)'\'''
test-expr 'A != (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b != !c)'\'''

echo '$ test-expr '\''A != (!b && !c)'\'''
test-expr 'A != (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b && !c)'\'''

echo '$ test-expr '\''A != (!b || !c)'\'''
test-expr 'A != (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b || !c)'\'''

echo '$ test-expr '\''A && (!b <= !c)'\'''
test-expr 'A && (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b <= !c)'\'''

echo '$ test-expr '\''A && (!b >= !c)'\'''
test-expr 'A && (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b >= !c)'\'''

echo '$ test-expr '\''A && (!b == !c)'\'''
test-expr 'A && (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b == !c)'\'''

echo '$ test-expr '\''A && (!b != !c)'\'''
test-expr 'A && (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b != !c)'\'''

echo '$ test-expr '\''A && (!b && !c)'\'''
test-expr 'A && (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b && !c)'\'''

echo '$ test-expr '\''A && (!b || !c)'\'''
test-expr 'A && (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b || !c)'\'''

echo '$ test-expr '\''A || (!b <= !c)'\'''
test-expr 'A || (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b <= !c)'\'''

echo '$ test-expr '\''A || (!b >= !c)'\'''
test-expr 'A || (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b >= !c)'\'''

echo '$ test-expr '\''A || (!b == !c)'\'''
test-expr 'A || (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b == !c)'\'''

echo '$ test-expr '\''A || (!b != !c)'\'''
test-expr 'A || (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b != !c)'\'''

echo '$ test-expr '\''A || (!b && !c)'\'''
test-expr 'A || (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b && !c)'\'''

echo '$ test-expr '\''A || (!b || !c)'\'''
test-expr 'A || (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b || !c)'\'''

echo '$ test-expr '\''A <= (!b <= !C)'\'''
test-expr 'A <= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b <= !C)'\'''

echo '$ test-expr '\''A <= (!b >= !C)'\'''
test-expr 'A <= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b >= !C)'\'''

echo '$ test-expr '\''A <= (!b == !C)'\'''
test-expr 'A <= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b == !C)'\'''

echo '$ test-expr '\''A <= (!b != !C)'\'''
test-expr 'A <= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b != !C)'\'''

echo '$ test-expr '\''A <= (!b && !C)'\'''
test-expr 'A <= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b && !C)'\'''

echo '$ test-expr '\''A <= (!b || !C)'\'''
test-expr 'A <= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!b || !C)'\'''

echo '$ test-expr '\''A >= (!b <= !C)'\'''
test-expr 'A >= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b <= !C)'\'''

echo '$ test-expr '\''A >= (!b >= !C)'\'''
test-expr 'A >= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b >= !C)'\'''

echo '$ test-expr '\''A >= (!b == !C)'\'''
test-expr 'A >= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b == !C)'\'''

echo '$ test-expr '\''A >= (!b != !C)'\'''
test-expr 'A >= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b != !C)'\'''

echo '$ test-expr '\''A >= (!b && !C)'\'''
test-expr 'A >= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b && !C)'\'''

echo '$ test-expr '\''A >= (!b || !C)'\'''
test-expr 'A >= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!b || !C)'\'''

echo '$ test-expr '\''A == (!b <= !C)'\'''
test-expr 'A == (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b <= !C)'\'''

echo '$ test-expr '\''A == (!b >= !C)'\'''
test-expr 'A == (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b >= !C)'\'''

echo '$ test-expr '\''A == (!b == !C)'\'''
test-expr 'A == (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b == !C)'\'''

echo '$ test-expr '\''A == (!b != !C)'\'''
test-expr 'A == (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b != !C)'\'''

echo '$ test-expr '\''A == (!b && !C)'\'''
test-expr 'A == (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b && !C)'\'''

echo '$ test-expr '\''A == (!b || !C)'\'''
test-expr 'A == (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!b || !C)'\'''

echo '$ test-expr '\''A != (!b <= !C)'\'''
test-expr 'A != (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b <= !C)'\'''

echo '$ test-expr '\''A != (!b >= !C)'\'''
test-expr 'A != (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b >= !C)'\'''

echo '$ test-expr '\''A != (!b == !C)'\'''
test-expr 'A != (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b == !C)'\'''

echo '$ test-expr '\''A != (!b != !C)'\'''
test-expr 'A != (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b != !C)'\'''

echo '$ test-expr '\''A != (!b && !C)'\'''
test-expr 'A != (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b && !C)'\'''

echo '$ test-expr '\''A != (!b || !C)'\'''
test-expr 'A != (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!b || !C)'\'''

echo '$ test-expr '\''A && (!b <= !C)'\'''
test-expr 'A && (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b <= !C)'\'''

echo '$ test-expr '\''A && (!b >= !C)'\'''
test-expr 'A && (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b >= !C)'\'''

echo '$ test-expr '\''A && (!b == !C)'\'''
test-expr 'A && (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b == !C)'\'''

echo '$ test-expr '\''A && (!b != !C)'\'''
test-expr 'A && (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b != !C)'\'''

echo '$ test-expr '\''A && (!b && !C)'\'''
test-expr 'A && (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b && !C)'\'''

echo '$ test-expr '\''A && (!b || !C)'\'''
test-expr 'A && (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!b || !C)'\'''

echo '$ test-expr '\''A || (!b <= !C)'\'''
test-expr 'A || (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b <= !C)'\'''

echo '$ test-expr '\''A || (!b >= !C)'\'''
test-expr 'A || (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b >= !C)'\'''

echo '$ test-expr '\''A || (!b == !C)'\'''
test-expr 'A || (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b == !C)'\'''

echo '$ test-expr '\''A || (!b != !C)'\'''
test-expr 'A || (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b != !C)'\'''

echo '$ test-expr '\''A || (!b && !C)'\'''
test-expr 'A || (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b && !C)'\'''

echo '$ test-expr '\''A || (!b || !C)'\'''
test-expr 'A || (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!b || !C)'\'''

echo '$ test-expr '\''A <= (!B <= c)'\'''
test-expr 'A <= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B <= c)'\'''

echo '$ test-expr '\''A <= (!B >= c)'\'''
test-expr 'A <= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B >= c)'\'''

echo '$ test-expr '\''A <= (!B == c)'\'''
test-expr 'A <= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B == c)'\'''

echo '$ test-expr '\''A <= (!B != c)'\'''
test-expr 'A <= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B != c)'\'''

echo '$ test-expr '\''A <= (!B && c)'\'''
test-expr 'A <= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B && c)'\'''

echo '$ test-expr '\''A <= (!B || c)'\'''
test-expr 'A <= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B || c)'\'''

echo '$ test-expr '\''A >= (!B <= c)'\'''
test-expr 'A >= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B <= c)'\'''

echo '$ test-expr '\''A >= (!B >= c)'\'''
test-expr 'A >= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B >= c)'\'''

echo '$ test-expr '\''A >= (!B == c)'\'''
test-expr 'A >= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B == c)'\'''

echo '$ test-expr '\''A >= (!B != c)'\'''
test-expr 'A >= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B != c)'\'''

echo '$ test-expr '\''A >= (!B && c)'\'''
test-expr 'A >= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B && c)'\'''

echo '$ test-expr '\''A >= (!B || c)'\'''
test-expr 'A >= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B || c)'\'''

echo '$ test-expr '\''A == (!B <= c)'\'''
test-expr 'A == (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B <= c)'\'''

echo '$ test-expr '\''A == (!B >= c)'\'''
test-expr 'A == (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B >= c)'\'''

echo '$ test-expr '\''A == (!B == c)'\'''
test-expr 'A == (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B == c)'\'''

echo '$ test-expr '\''A == (!B != c)'\'''
test-expr 'A == (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B != c)'\'''

echo '$ test-expr '\''A == (!B && c)'\'''
test-expr 'A == (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B && c)'\'''

echo '$ test-expr '\''A == (!B || c)'\'''
test-expr 'A == (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B || c)'\'''

echo '$ test-expr '\''A != (!B <= c)'\'''
test-expr 'A != (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B <= c)'\'''

echo '$ test-expr '\''A != (!B >= c)'\'''
test-expr 'A != (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B >= c)'\'''

echo '$ test-expr '\''A != (!B == c)'\'''
test-expr 'A != (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B == c)'\'''

echo '$ test-expr '\''A != (!B != c)'\'''
test-expr 'A != (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B != c)'\'''

echo '$ test-expr '\''A != (!B && c)'\'''
test-expr 'A != (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B && c)'\'''

echo '$ test-expr '\''A != (!B || c)'\'''
test-expr 'A != (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B || c)'\'''

echo '$ test-expr '\''A && (!B <= c)'\'''
test-expr 'A && (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B <= c)'\'''

echo '$ test-expr '\''A && (!B >= c)'\'''
test-expr 'A && (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B >= c)'\'''

echo '$ test-expr '\''A && (!B == c)'\'''
test-expr 'A && (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B == c)'\'''

echo '$ test-expr '\''A && (!B != c)'\'''
test-expr 'A && (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B != c)'\'''

echo '$ test-expr '\''A && (!B && c)'\'''
test-expr 'A && (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B && c)'\'''

echo '$ test-expr '\''A && (!B || c)'\'''
test-expr 'A && (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B || c)'\'''

echo '$ test-expr '\''A || (!B <= c)'\'''
test-expr 'A || (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B <= c)'\'''

echo '$ test-expr '\''A || (!B >= c)'\'''
test-expr 'A || (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B >= c)'\'''

echo '$ test-expr '\''A || (!B == c)'\'''
test-expr 'A || (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B == c)'\'''

echo '$ test-expr '\''A || (!B != c)'\'''
test-expr 'A || (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B != c)'\'''

echo '$ test-expr '\''A || (!B && c)'\'''
test-expr 'A || (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B && c)'\'''

echo '$ test-expr '\''A || (!B || c)'\'''
test-expr 'A || (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B || c)'\'''

echo '$ test-expr '\''A <= (!B <= C)'\'''
test-expr 'A <= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B <= C)'\'''

echo '$ test-expr '\''A <= (!B >= C)'\'''
test-expr 'A <= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B >= C)'\'''

echo '$ test-expr '\''A <= (!B == C)'\'''
test-expr 'A <= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B == C)'\'''

echo '$ test-expr '\''A <= (!B != C)'\'''
test-expr 'A <= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B != C)'\'''

echo '$ test-expr '\''A <= (!B && C)'\'''
test-expr 'A <= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B && C)'\'''

echo '$ test-expr '\''A <= (!B || C)'\'''
test-expr 'A <= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B || C)'\'''

echo '$ test-expr '\''A >= (!B <= C)'\'''
test-expr 'A >= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B <= C)'\'''

echo '$ test-expr '\''A >= (!B >= C)'\'''
test-expr 'A >= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B >= C)'\'''

echo '$ test-expr '\''A >= (!B == C)'\'''
test-expr 'A >= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B == C)'\'''

echo '$ test-expr '\''A >= (!B != C)'\'''
test-expr 'A >= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B != C)'\'''

echo '$ test-expr '\''A >= (!B && C)'\'''
test-expr 'A >= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B && C)'\'''

echo '$ test-expr '\''A >= (!B || C)'\'''
test-expr 'A >= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B || C)'\'''

echo '$ test-expr '\''A == (!B <= C)'\'''
test-expr 'A == (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B <= C)'\'''

echo '$ test-expr '\''A == (!B >= C)'\'''
test-expr 'A == (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B >= C)'\'''

echo '$ test-expr '\''A == (!B == C)'\'''
test-expr 'A == (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B == C)'\'''

echo '$ test-expr '\''A == (!B != C)'\'''
test-expr 'A == (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B != C)'\'''

echo '$ test-expr '\''A == (!B && C)'\'''
test-expr 'A == (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B && C)'\'''

echo '$ test-expr '\''A == (!B || C)'\'''
test-expr 'A == (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B || C)'\'''

echo '$ test-expr '\''A != (!B <= C)'\'''
test-expr 'A != (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B <= C)'\'''

echo '$ test-expr '\''A != (!B >= C)'\'''
test-expr 'A != (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B >= C)'\'''

echo '$ test-expr '\''A != (!B == C)'\'''
test-expr 'A != (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B == C)'\'''

echo '$ test-expr '\''A != (!B != C)'\'''
test-expr 'A != (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B != C)'\'''

echo '$ test-expr '\''A != (!B && C)'\'''
test-expr 'A != (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B && C)'\'''

echo '$ test-expr '\''A != (!B || C)'\'''
test-expr 'A != (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B || C)'\'''

echo '$ test-expr '\''A && (!B <= C)'\'''
test-expr 'A && (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B <= C)'\'''

echo '$ test-expr '\''A && (!B >= C)'\'''
test-expr 'A && (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B >= C)'\'''

echo '$ test-expr '\''A && (!B == C)'\'''
test-expr 'A && (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B == C)'\'''

echo '$ test-expr '\''A && (!B != C)'\'''
test-expr 'A && (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B != C)'\'''

echo '$ test-expr '\''A && (!B && C)'\'''
test-expr 'A && (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B && C)'\'''

echo '$ test-expr '\''A && (!B || C)'\'''
test-expr 'A && (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B || C)'\'''

echo '$ test-expr '\''A || (!B <= C)'\'''
test-expr 'A || (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B <= C)'\'''

echo '$ test-expr '\''A || (!B >= C)'\'''
test-expr 'A || (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B >= C)'\'''

echo '$ test-expr '\''A || (!B == C)'\'''
test-expr 'A || (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B == C)'\'''

echo '$ test-expr '\''A || (!B != C)'\'''
test-expr 'A || (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B != C)'\'''

echo '$ test-expr '\''A || (!B && C)'\'''
test-expr 'A || (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B && C)'\'''

echo '$ test-expr '\''A || (!B || C)'\'''
test-expr 'A || (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B || C)'\'''

echo '$ test-expr '\''A <= (!B <= !c)'\'''
test-expr 'A <= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B <= !c)'\'''

echo '$ test-expr '\''A <= (!B >= !c)'\'''
test-expr 'A <= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B >= !c)'\'''

echo '$ test-expr '\''A <= (!B == !c)'\'''
test-expr 'A <= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B == !c)'\'''

echo '$ test-expr '\''A <= (!B != !c)'\'''
test-expr 'A <= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B != !c)'\'''

echo '$ test-expr '\''A <= (!B && !c)'\'''
test-expr 'A <= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B && !c)'\'''

echo '$ test-expr '\''A <= (!B || !c)'\'''
test-expr 'A <= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B || !c)'\'''

echo '$ test-expr '\''A >= (!B <= !c)'\'''
test-expr 'A >= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B <= !c)'\'''

echo '$ test-expr '\''A >= (!B >= !c)'\'''
test-expr 'A >= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B >= !c)'\'''

echo '$ test-expr '\''A >= (!B == !c)'\'''
test-expr 'A >= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B == !c)'\'''

echo '$ test-expr '\''A >= (!B != !c)'\'''
test-expr 'A >= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B != !c)'\'''

echo '$ test-expr '\''A >= (!B && !c)'\'''
test-expr 'A >= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B && !c)'\'''

echo '$ test-expr '\''A >= (!B || !c)'\'''
test-expr 'A >= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B || !c)'\'''

echo '$ test-expr '\''A == (!B <= !c)'\'''
test-expr 'A == (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B <= !c)'\'''

echo '$ test-expr '\''A == (!B >= !c)'\'''
test-expr 'A == (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B >= !c)'\'''

echo '$ test-expr '\''A == (!B == !c)'\'''
test-expr 'A == (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B == !c)'\'''

echo '$ test-expr '\''A == (!B != !c)'\'''
test-expr 'A == (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B != !c)'\'''

echo '$ test-expr '\''A == (!B && !c)'\'''
test-expr 'A == (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B && !c)'\'''

echo '$ test-expr '\''A == (!B || !c)'\'''
test-expr 'A == (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B || !c)'\'''

echo '$ test-expr '\''A != (!B <= !c)'\'''
test-expr 'A != (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B <= !c)'\'''

echo '$ test-expr '\''A != (!B >= !c)'\'''
test-expr 'A != (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B >= !c)'\'''

echo '$ test-expr '\''A != (!B == !c)'\'''
test-expr 'A != (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B == !c)'\'''

echo '$ test-expr '\''A != (!B != !c)'\'''
test-expr 'A != (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B != !c)'\'''

echo '$ test-expr '\''A != (!B && !c)'\'''
test-expr 'A != (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B && !c)'\'''

echo '$ test-expr '\''A != (!B || !c)'\'''
test-expr 'A != (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B || !c)'\'''

echo '$ test-expr '\''A && (!B <= !c)'\'''
test-expr 'A && (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B <= !c)'\'''

echo '$ test-expr '\''A && (!B >= !c)'\'''
test-expr 'A && (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B >= !c)'\'''

echo '$ test-expr '\''A && (!B == !c)'\'''
test-expr 'A && (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B == !c)'\'''

echo '$ test-expr '\''A && (!B != !c)'\'''
test-expr 'A && (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B != !c)'\'''

echo '$ test-expr '\''A && (!B && !c)'\'''
test-expr 'A && (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B && !c)'\'''

echo '$ test-expr '\''A && (!B || !c)'\'''
test-expr 'A && (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B || !c)'\'''

echo '$ test-expr '\''A || (!B <= !c)'\'''
test-expr 'A || (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B <= !c)'\'''

echo '$ test-expr '\''A || (!B >= !c)'\'''
test-expr 'A || (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B >= !c)'\'''

echo '$ test-expr '\''A || (!B == !c)'\'''
test-expr 'A || (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B == !c)'\'''

echo '$ test-expr '\''A || (!B != !c)'\'''
test-expr 'A || (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B != !c)'\'''

echo '$ test-expr '\''A || (!B && !c)'\'''
test-expr 'A || (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B && !c)'\'''

echo '$ test-expr '\''A || (!B || !c)'\'''
test-expr 'A || (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B || !c)'\'''

echo '$ test-expr '\''A <= (!B <= !C)'\'''
test-expr 'A <= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B <= !C)'\'''

echo '$ test-expr '\''A <= (!B >= !C)'\'''
test-expr 'A <= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B >= !C)'\'''

echo '$ test-expr '\''A <= (!B == !C)'\'''
test-expr 'A <= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B == !C)'\'''

echo '$ test-expr '\''A <= (!B != !C)'\'''
test-expr 'A <= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B != !C)'\'''

echo '$ test-expr '\''A <= (!B && !C)'\'''
test-expr 'A <= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B && !C)'\'''

echo '$ test-expr '\''A <= (!B || !C)'\'''
test-expr 'A <= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A <= (!B || !C)'\'''

echo '$ test-expr '\''A >= (!B <= !C)'\'''
test-expr 'A >= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B <= !C)'\'''

echo '$ test-expr '\''A >= (!B >= !C)'\'''
test-expr 'A >= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B >= !C)'\'''

echo '$ test-expr '\''A >= (!B == !C)'\'''
test-expr 'A >= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B == !C)'\'''

echo '$ test-expr '\''A >= (!B != !C)'\'''
test-expr 'A >= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B != !C)'\'''

echo '$ test-expr '\''A >= (!B && !C)'\'''
test-expr 'A >= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B && !C)'\'''

echo '$ test-expr '\''A >= (!B || !C)'\'''
test-expr 'A >= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A >= (!B || !C)'\'''

echo '$ test-expr '\''A == (!B <= !C)'\'''
test-expr 'A == (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B <= !C)'\'''

echo '$ test-expr '\''A == (!B >= !C)'\'''
test-expr 'A == (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B >= !C)'\'''

echo '$ test-expr '\''A == (!B == !C)'\'''
test-expr 'A == (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B == !C)'\'''

echo '$ test-expr '\''A == (!B != !C)'\'''
test-expr 'A == (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B != !C)'\'''

echo '$ test-expr '\''A == (!B && !C)'\'''
test-expr 'A == (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B && !C)'\'''

echo '$ test-expr '\''A == (!B || !C)'\'''
test-expr 'A == (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A == (!B || !C)'\'''

echo '$ test-expr '\''A != (!B <= !C)'\'''
test-expr 'A != (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B <= !C)'\'''

echo '$ test-expr '\''A != (!B >= !C)'\'''
test-expr 'A != (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B >= !C)'\'''

echo '$ test-expr '\''A != (!B == !C)'\'''
test-expr 'A != (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B == !C)'\'''

echo '$ test-expr '\''A != (!B != !C)'\'''
test-expr 'A != (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B != !C)'\'''

echo '$ test-expr '\''A != (!B && !C)'\'''
test-expr 'A != (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B && !C)'\'''

echo '$ test-expr '\''A != (!B || !C)'\'''
test-expr 'A != (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A != (!B || !C)'\'''

echo '$ test-expr '\''A && (!B <= !C)'\'''
test-expr 'A && (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B <= !C)'\'''

echo '$ test-expr '\''A && (!B >= !C)'\'''
test-expr 'A && (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B >= !C)'\'''

echo '$ test-expr '\''A && (!B == !C)'\'''
test-expr 'A && (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B == !C)'\'''

echo '$ test-expr '\''A && (!B != !C)'\'''
test-expr 'A && (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B != !C)'\'''

echo '$ test-expr '\''A && (!B && !C)'\'''
test-expr 'A && (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B && !C)'\'''

echo '$ test-expr '\''A && (!B || !C)'\'''
test-expr 'A && (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A && (!B || !C)'\'''

echo '$ test-expr '\''A || (!B <= !C)'\'''
test-expr 'A || (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B <= !C)'\'''

echo '$ test-expr '\''A || (!B >= !C)'\'''
test-expr 'A || (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B >= !C)'\'''

echo '$ test-expr '\''A || (!B == !C)'\'''
test-expr 'A || (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B == !C)'\'''

echo '$ test-expr '\''A || (!B != !C)'\'''
test-expr 'A || (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B != !C)'\'''

echo '$ test-expr '\''A || (!B && !C)'\'''
test-expr 'A || (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B && !C)'\'''

echo '$ test-expr '\''A || (!B || !C)'\'''
test-expr 'A || (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''A || (!B || !C)'\'''

echo '$ test-expr '\''!a <= (b <= c)'\'''
test-expr '!a <= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b <= c)'\'''

echo '$ test-expr '\''!a <= (b >= c)'\'''
test-expr '!a <= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b >= c)'\'''

echo '$ test-expr '\''!a <= (b == c)'\'''
test-expr '!a <= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b == c)'\'''

echo '$ test-expr '\''!a <= (b != c)'\'''
test-expr '!a <= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b != c)'\'''

echo '$ test-expr '\''!a <= (b && c)'\'''
test-expr '!a <= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b && c)'\'''

echo '$ test-expr '\''!a <= (b || c)'\'''
test-expr '!a <= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b || c)'\'''

echo '$ test-expr '\''!a >= (b <= c)'\'''
test-expr '!a >= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b <= c)'\'''

echo '$ test-expr '\''!a >= (b >= c)'\'''
test-expr '!a >= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b >= c)'\'''

echo '$ test-expr '\''!a >= (b == c)'\'''
test-expr '!a >= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b == c)'\'''

echo '$ test-expr '\''!a >= (b != c)'\'''
test-expr '!a >= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b != c)'\'''

echo '$ test-expr '\''!a >= (b && c)'\'''
test-expr '!a >= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b && c)'\'''

echo '$ test-expr '\''!a >= (b || c)'\'''
test-expr '!a >= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b || c)'\'''

echo '$ test-expr '\''!a == (b <= c)'\'''
test-expr '!a == (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b <= c)'\'''

echo '$ test-expr '\''!a == (b >= c)'\'''
test-expr '!a == (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b >= c)'\'''

echo '$ test-expr '\''!a == (b == c)'\'''
test-expr '!a == (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b == c)'\'''

echo '$ test-expr '\''!a == (b != c)'\'''
test-expr '!a == (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b != c)'\'''

echo '$ test-expr '\''!a == (b && c)'\'''
test-expr '!a == (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b && c)'\'''

echo '$ test-expr '\''!a == (b || c)'\'''
test-expr '!a == (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b || c)'\'''

echo '$ test-expr '\''!a != (b <= c)'\'''
test-expr '!a != (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b <= c)'\'''

echo '$ test-expr '\''!a != (b >= c)'\'''
test-expr '!a != (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b >= c)'\'''

echo '$ test-expr '\''!a != (b == c)'\'''
test-expr '!a != (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b == c)'\'''

echo '$ test-expr '\''!a != (b != c)'\'''
test-expr '!a != (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b != c)'\'''

echo '$ test-expr '\''!a != (b && c)'\'''
test-expr '!a != (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b && c)'\'''

echo '$ test-expr '\''!a != (b || c)'\'''
test-expr '!a != (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b || c)'\'''

echo '$ test-expr '\''!a && (b <= c)'\'''
test-expr '!a && (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b <= c)'\'''

echo '$ test-expr '\''!a && (b >= c)'\'''
test-expr '!a && (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b >= c)'\'''

echo '$ test-expr '\''!a && (b == c)'\'''
test-expr '!a && (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b == c)'\'''

echo '$ test-expr '\''!a && (b != c)'\'''
test-expr '!a && (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b != c)'\'''

echo '$ test-expr '\''!a && (b && c)'\'''
test-expr '!a && (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b && c)'\'''

echo '$ test-expr '\''!a && (b || c)'\'''
test-expr '!a && (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b || c)'\'''

echo '$ test-expr '\''!a || (b <= c)'\'''
test-expr '!a || (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b <= c)'\'''

echo '$ test-expr '\''!a || (b >= c)'\'''
test-expr '!a || (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b >= c)'\'''

echo '$ test-expr '\''!a || (b == c)'\'''
test-expr '!a || (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b == c)'\'''

echo '$ test-expr '\''!a || (b != c)'\'''
test-expr '!a || (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b != c)'\'''

echo '$ test-expr '\''!a || (b && c)'\'''
test-expr '!a || (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b && c)'\'''

echo '$ test-expr '\''!a || (b || c)'\'''
test-expr '!a || (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b || c)'\'''

echo '$ test-expr '\''!a <= (b <= C)'\'''
test-expr '!a <= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b <= C)'\'''

echo '$ test-expr '\''!a <= (b >= C)'\'''
test-expr '!a <= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b >= C)'\'''

echo '$ test-expr '\''!a <= (b == C)'\'''
test-expr '!a <= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b == C)'\'''

echo '$ test-expr '\''!a <= (b != C)'\'''
test-expr '!a <= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b != C)'\'''

echo '$ test-expr '\''!a <= (b && C)'\'''
test-expr '!a <= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b && C)'\'''

echo '$ test-expr '\''!a <= (b || C)'\'''
test-expr '!a <= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b || C)'\'''

echo '$ test-expr '\''!a >= (b <= C)'\'''
test-expr '!a >= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b <= C)'\'''

echo '$ test-expr '\''!a >= (b >= C)'\'''
test-expr '!a >= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b >= C)'\'''

echo '$ test-expr '\''!a >= (b == C)'\'''
test-expr '!a >= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b == C)'\'''

echo '$ test-expr '\''!a >= (b != C)'\'''
test-expr '!a >= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b != C)'\'''

echo '$ test-expr '\''!a >= (b && C)'\'''
test-expr '!a >= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b && C)'\'''

echo '$ test-expr '\''!a >= (b || C)'\'''
test-expr '!a >= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b || C)'\'''

echo '$ test-expr '\''!a == (b <= C)'\'''
test-expr '!a == (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b <= C)'\'''

echo '$ test-expr '\''!a == (b >= C)'\'''
test-expr '!a == (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b >= C)'\'''

echo '$ test-expr '\''!a == (b == C)'\'''
test-expr '!a == (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b == C)'\'''

echo '$ test-expr '\''!a == (b != C)'\'''
test-expr '!a == (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b != C)'\'''

echo '$ test-expr '\''!a == (b && C)'\'''
test-expr '!a == (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b && C)'\'''

echo '$ test-expr '\''!a == (b || C)'\'''
test-expr '!a == (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b || C)'\'''

echo '$ test-expr '\''!a != (b <= C)'\'''
test-expr '!a != (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b <= C)'\'''

echo '$ test-expr '\''!a != (b >= C)'\'''
test-expr '!a != (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b >= C)'\'''

echo '$ test-expr '\''!a != (b == C)'\'''
test-expr '!a != (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b == C)'\'''

echo '$ test-expr '\''!a != (b != C)'\'''
test-expr '!a != (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b != C)'\'''

echo '$ test-expr '\''!a != (b && C)'\'''
test-expr '!a != (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b && C)'\'''

echo '$ test-expr '\''!a != (b || C)'\'''
test-expr '!a != (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b || C)'\'''

echo '$ test-expr '\''!a && (b <= C)'\'''
test-expr '!a && (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b <= C)'\'''

echo '$ test-expr '\''!a && (b >= C)'\'''
test-expr '!a && (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b >= C)'\'''

echo '$ test-expr '\''!a && (b == C)'\'''
test-expr '!a && (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b == C)'\'''

echo '$ test-expr '\''!a && (b != C)'\'''
test-expr '!a && (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b != C)'\'''

echo '$ test-expr '\''!a && (b && C)'\'''
test-expr '!a && (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b && C)'\'''

echo '$ test-expr '\''!a && (b || C)'\'''
test-expr '!a && (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b || C)'\'''

echo '$ test-expr '\''!a || (b <= C)'\'''
test-expr '!a || (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b <= C)'\'''

echo '$ test-expr '\''!a || (b >= C)'\'''
test-expr '!a || (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b >= C)'\'''

echo '$ test-expr '\''!a || (b == C)'\'''
test-expr '!a || (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b == C)'\'''

echo '$ test-expr '\''!a || (b != C)'\'''
test-expr '!a || (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b != C)'\'''

echo '$ test-expr '\''!a || (b && C)'\'''
test-expr '!a || (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b && C)'\'''

echo '$ test-expr '\''!a || (b || C)'\'''
test-expr '!a || (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b || C)'\'''

echo '$ test-expr '\''!a <= (b <= !c)'\'''
test-expr '!a <= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b <= !c)'\'''

echo '$ test-expr '\''!a <= (b >= !c)'\'''
test-expr '!a <= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b >= !c)'\'''

echo '$ test-expr '\''!a <= (b == !c)'\'''
test-expr '!a <= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b == !c)'\'''

echo '$ test-expr '\''!a <= (b != !c)'\'''
test-expr '!a <= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b != !c)'\'''

echo '$ test-expr '\''!a <= (b && !c)'\'''
test-expr '!a <= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b && !c)'\'''

echo '$ test-expr '\''!a <= (b || !c)'\'''
test-expr '!a <= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b || !c)'\'''

echo '$ test-expr '\''!a >= (b <= !c)'\'''
test-expr '!a >= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b <= !c)'\'''

echo '$ test-expr '\''!a >= (b >= !c)'\'''
test-expr '!a >= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b >= !c)'\'''

echo '$ test-expr '\''!a >= (b == !c)'\'''
test-expr '!a >= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b == !c)'\'''

echo '$ test-expr '\''!a >= (b != !c)'\'''
test-expr '!a >= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b != !c)'\'''

echo '$ test-expr '\''!a >= (b && !c)'\'''
test-expr '!a >= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b && !c)'\'''

echo '$ test-expr '\''!a >= (b || !c)'\'''
test-expr '!a >= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b || !c)'\'''

echo '$ test-expr '\''!a == (b <= !c)'\'''
test-expr '!a == (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b <= !c)'\'''

echo '$ test-expr '\''!a == (b >= !c)'\'''
test-expr '!a == (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b >= !c)'\'''

echo '$ test-expr '\''!a == (b == !c)'\'''
test-expr '!a == (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b == !c)'\'''

echo '$ test-expr '\''!a == (b != !c)'\'''
test-expr '!a == (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b != !c)'\'''

echo '$ test-expr '\''!a == (b && !c)'\'''
test-expr '!a == (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b && !c)'\'''

echo '$ test-expr '\''!a == (b || !c)'\'''
test-expr '!a == (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b || !c)'\'''

echo '$ test-expr '\''!a != (b <= !c)'\'''
test-expr '!a != (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b <= !c)'\'''

echo '$ test-expr '\''!a != (b >= !c)'\'''
test-expr '!a != (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b >= !c)'\'''

echo '$ test-expr '\''!a != (b == !c)'\'''
test-expr '!a != (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b == !c)'\'''

echo '$ test-expr '\''!a != (b != !c)'\'''
test-expr '!a != (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b != !c)'\'''

echo '$ test-expr '\''!a != (b && !c)'\'''
test-expr '!a != (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b && !c)'\'''

echo '$ test-expr '\''!a != (b || !c)'\'''
test-expr '!a != (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b || !c)'\'''

echo '$ test-expr '\''!a && (b <= !c)'\'''
test-expr '!a && (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b <= !c)'\'''

echo '$ test-expr '\''!a && (b >= !c)'\'''
test-expr '!a && (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b >= !c)'\'''

echo '$ test-expr '\''!a && (b == !c)'\'''
test-expr '!a && (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b == !c)'\'''

echo '$ test-expr '\''!a && (b != !c)'\'''
test-expr '!a && (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b != !c)'\'''

echo '$ test-expr '\''!a && (b && !c)'\'''
test-expr '!a && (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b && !c)'\'''

echo '$ test-expr '\''!a && (b || !c)'\'''
test-expr '!a && (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b || !c)'\'''

echo '$ test-expr '\''!a || (b <= !c)'\'''
test-expr '!a || (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b <= !c)'\'''

echo '$ test-expr '\''!a || (b >= !c)'\'''
test-expr '!a || (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b >= !c)'\'''

echo '$ test-expr '\''!a || (b == !c)'\'''
test-expr '!a || (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b == !c)'\'''

echo '$ test-expr '\''!a || (b != !c)'\'''
test-expr '!a || (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b != !c)'\'''

echo '$ test-expr '\''!a || (b && !c)'\'''
test-expr '!a || (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b && !c)'\'''

echo '$ test-expr '\''!a || (b || !c)'\'''
test-expr '!a || (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b || !c)'\'''

echo '$ test-expr '\''!a <= (b <= !C)'\'''
test-expr '!a <= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b <= !C)'\'''

echo '$ test-expr '\''!a <= (b >= !C)'\'''
test-expr '!a <= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b >= !C)'\'''

echo '$ test-expr '\''!a <= (b == !C)'\'''
test-expr '!a <= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b == !C)'\'''

echo '$ test-expr '\''!a <= (b != !C)'\'''
test-expr '!a <= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b != !C)'\'''

echo '$ test-expr '\''!a <= (b && !C)'\'''
test-expr '!a <= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b && !C)'\'''

echo '$ test-expr '\''!a <= (b || !C)'\'''
test-expr '!a <= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (b || !C)'\'''

echo '$ test-expr '\''!a >= (b <= !C)'\'''
test-expr '!a >= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b <= !C)'\'''

echo '$ test-expr '\''!a >= (b >= !C)'\'''
test-expr '!a >= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b >= !C)'\'''

echo '$ test-expr '\''!a >= (b == !C)'\'''
test-expr '!a >= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b == !C)'\'''

echo '$ test-expr '\''!a >= (b != !C)'\'''
test-expr '!a >= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b != !C)'\'''

echo '$ test-expr '\''!a >= (b && !C)'\'''
test-expr '!a >= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b && !C)'\'''

echo '$ test-expr '\''!a >= (b || !C)'\'''
test-expr '!a >= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (b || !C)'\'''

echo '$ test-expr '\''!a == (b <= !C)'\'''
test-expr '!a == (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b <= !C)'\'''

echo '$ test-expr '\''!a == (b >= !C)'\'''
test-expr '!a == (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b >= !C)'\'''

echo '$ test-expr '\''!a == (b == !C)'\'''
test-expr '!a == (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b == !C)'\'''

echo '$ test-expr '\''!a == (b != !C)'\'''
test-expr '!a == (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b != !C)'\'''

echo '$ test-expr '\''!a == (b && !C)'\'''
test-expr '!a == (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b && !C)'\'''

echo '$ test-expr '\''!a == (b || !C)'\'''
test-expr '!a == (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (b || !C)'\'''

echo '$ test-expr '\''!a != (b <= !C)'\'''
test-expr '!a != (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b <= !C)'\'''

echo '$ test-expr '\''!a != (b >= !C)'\'''
test-expr '!a != (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b >= !C)'\'''

echo '$ test-expr '\''!a != (b == !C)'\'''
test-expr '!a != (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b == !C)'\'''

echo '$ test-expr '\''!a != (b != !C)'\'''
test-expr '!a != (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b != !C)'\'''

echo '$ test-expr '\''!a != (b && !C)'\'''
test-expr '!a != (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b && !C)'\'''

echo '$ test-expr '\''!a != (b || !C)'\'''
test-expr '!a != (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (b || !C)'\'''

echo '$ test-expr '\''!a && (b <= !C)'\'''
test-expr '!a && (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b <= !C)'\'''

echo '$ test-expr '\''!a && (b >= !C)'\'''
test-expr '!a && (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b >= !C)'\'''

echo '$ test-expr '\''!a && (b == !C)'\'''
test-expr '!a && (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b == !C)'\'''

echo '$ test-expr '\''!a && (b != !C)'\'''
test-expr '!a && (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b != !C)'\'''

echo '$ test-expr '\''!a && (b && !C)'\'''
test-expr '!a && (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b && !C)'\'''

echo '$ test-expr '\''!a && (b || !C)'\'''
test-expr '!a && (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (b || !C)'\'''

echo '$ test-expr '\''!a || (b <= !C)'\'''
test-expr '!a || (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b <= !C)'\'''

echo '$ test-expr '\''!a || (b >= !C)'\'''
test-expr '!a || (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b >= !C)'\'''

echo '$ test-expr '\''!a || (b == !C)'\'''
test-expr '!a || (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b == !C)'\'''

echo '$ test-expr '\''!a || (b != !C)'\'''
test-expr '!a || (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b != !C)'\'''

echo '$ test-expr '\''!a || (b && !C)'\'''
test-expr '!a || (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b && !C)'\'''

echo '$ test-expr '\''!a || (b || !C)'\'''
test-expr '!a || (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (b || !C)'\'''

echo '$ test-expr '\''!a <= (B <= c)'\'''
test-expr '!a <= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B <= c)'\'''

echo '$ test-expr '\''!a <= (B >= c)'\'''
test-expr '!a <= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B >= c)'\'''

echo '$ test-expr '\''!a <= (B == c)'\'''
test-expr '!a <= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B == c)'\'''

echo '$ test-expr '\''!a <= (B != c)'\'''
test-expr '!a <= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B != c)'\'''

echo '$ test-expr '\''!a <= (B && c)'\'''
test-expr '!a <= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B && c)'\'''

echo '$ test-expr '\''!a <= (B || c)'\'''
test-expr '!a <= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B || c)'\'''

echo '$ test-expr '\''!a >= (B <= c)'\'''
test-expr '!a >= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B <= c)'\'''

echo '$ test-expr '\''!a >= (B >= c)'\'''
test-expr '!a >= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B >= c)'\'''

echo '$ test-expr '\''!a >= (B == c)'\'''
test-expr '!a >= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B == c)'\'''

echo '$ test-expr '\''!a >= (B != c)'\'''
test-expr '!a >= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B != c)'\'''

echo '$ test-expr '\''!a >= (B && c)'\'''
test-expr '!a >= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B && c)'\'''

echo '$ test-expr '\''!a >= (B || c)'\'''
test-expr '!a >= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B || c)'\'''

echo '$ test-expr '\''!a == (B <= c)'\'''
test-expr '!a == (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B <= c)'\'''

echo '$ test-expr '\''!a == (B >= c)'\'''
test-expr '!a == (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B >= c)'\'''

echo '$ test-expr '\''!a == (B == c)'\'''
test-expr '!a == (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B == c)'\'''

echo '$ test-expr '\''!a == (B != c)'\'''
test-expr '!a == (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B != c)'\'''

echo '$ test-expr '\''!a == (B && c)'\'''
test-expr '!a == (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B && c)'\'''

echo '$ test-expr '\''!a == (B || c)'\'''
test-expr '!a == (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B || c)'\'''

echo '$ test-expr '\''!a != (B <= c)'\'''
test-expr '!a != (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B <= c)'\'''

echo '$ test-expr '\''!a != (B >= c)'\'''
test-expr '!a != (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B >= c)'\'''

echo '$ test-expr '\''!a != (B == c)'\'''
test-expr '!a != (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B == c)'\'''

echo '$ test-expr '\''!a != (B != c)'\'''
test-expr '!a != (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B != c)'\'''

echo '$ test-expr '\''!a != (B && c)'\'''
test-expr '!a != (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B && c)'\'''

echo '$ test-expr '\''!a != (B || c)'\'''
test-expr '!a != (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B || c)'\'''

echo '$ test-expr '\''!a && (B <= c)'\'''
test-expr '!a && (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B <= c)'\'''

echo '$ test-expr '\''!a && (B >= c)'\'''
test-expr '!a && (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B >= c)'\'''

echo '$ test-expr '\''!a && (B == c)'\'''
test-expr '!a && (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B == c)'\'''

echo '$ test-expr '\''!a && (B != c)'\'''
test-expr '!a && (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B != c)'\'''

echo '$ test-expr '\''!a && (B && c)'\'''
test-expr '!a && (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B && c)'\'''

echo '$ test-expr '\''!a && (B || c)'\'''
test-expr '!a && (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B || c)'\'''

echo '$ test-expr '\''!a || (B <= c)'\'''
test-expr '!a || (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B <= c)'\'''

echo '$ test-expr '\''!a || (B >= c)'\'''
test-expr '!a || (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B >= c)'\'''

echo '$ test-expr '\''!a || (B == c)'\'''
test-expr '!a || (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B == c)'\'''

echo '$ test-expr '\''!a || (B != c)'\'''
test-expr '!a || (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B != c)'\'''

echo '$ test-expr '\''!a || (B && c)'\'''
test-expr '!a || (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B && c)'\'''

echo '$ test-expr '\''!a || (B || c)'\'''
test-expr '!a || (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B || c)'\'''

echo '$ test-expr '\''!a <= (B <= C)'\'''
test-expr '!a <= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B <= C)'\'''

echo '$ test-expr '\''!a <= (B >= C)'\'''
test-expr '!a <= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B >= C)'\'''

echo '$ test-expr '\''!a <= (B == C)'\'''
test-expr '!a <= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B == C)'\'''

echo '$ test-expr '\''!a <= (B != C)'\'''
test-expr '!a <= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B != C)'\'''

echo '$ test-expr '\''!a <= (B && C)'\'''
test-expr '!a <= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B && C)'\'''

echo '$ test-expr '\''!a <= (B || C)'\'''
test-expr '!a <= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B || C)'\'''

echo '$ test-expr '\''!a >= (B <= C)'\'''
test-expr '!a >= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B <= C)'\'''

echo '$ test-expr '\''!a >= (B >= C)'\'''
test-expr '!a >= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B >= C)'\'''

echo '$ test-expr '\''!a >= (B == C)'\'''
test-expr '!a >= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B == C)'\'''

echo '$ test-expr '\''!a >= (B != C)'\'''
test-expr '!a >= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B != C)'\'''

echo '$ test-expr '\''!a >= (B && C)'\'''
test-expr '!a >= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B && C)'\'''

echo '$ test-expr '\''!a >= (B || C)'\'''
test-expr '!a >= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B || C)'\'''

echo '$ test-expr '\''!a == (B <= C)'\'''
test-expr '!a == (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B <= C)'\'''

echo '$ test-expr '\''!a == (B >= C)'\'''
test-expr '!a == (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B >= C)'\'''

echo '$ test-expr '\''!a == (B == C)'\'''
test-expr '!a == (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B == C)'\'''

echo '$ test-expr '\''!a == (B != C)'\'''
test-expr '!a == (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B != C)'\'''

echo '$ test-expr '\''!a == (B && C)'\'''
test-expr '!a == (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B && C)'\'''

echo '$ test-expr '\''!a == (B || C)'\'''
test-expr '!a == (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B || C)'\'''

echo '$ test-expr '\''!a != (B <= C)'\'''
test-expr '!a != (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B <= C)'\'''

echo '$ test-expr '\''!a != (B >= C)'\'''
test-expr '!a != (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B >= C)'\'''

echo '$ test-expr '\''!a != (B == C)'\'''
test-expr '!a != (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B == C)'\'''

echo '$ test-expr '\''!a != (B != C)'\'''
test-expr '!a != (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B != C)'\'''

echo '$ test-expr '\''!a != (B && C)'\'''
test-expr '!a != (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B && C)'\'''

echo '$ test-expr '\''!a != (B || C)'\'''
test-expr '!a != (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B || C)'\'''

echo '$ test-expr '\''!a && (B <= C)'\'''
test-expr '!a && (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B <= C)'\'''

echo '$ test-expr '\''!a && (B >= C)'\'''
test-expr '!a && (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B >= C)'\'''

echo '$ test-expr '\''!a && (B == C)'\'''
test-expr '!a && (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B == C)'\'''

echo '$ test-expr '\''!a && (B != C)'\'''
test-expr '!a && (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B != C)'\'''

echo '$ test-expr '\''!a && (B && C)'\'''
test-expr '!a && (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B && C)'\'''

echo '$ test-expr '\''!a && (B || C)'\'''
test-expr '!a && (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B || C)'\'''

echo '$ test-expr '\''!a || (B <= C)'\'''
test-expr '!a || (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B <= C)'\'''

echo '$ test-expr '\''!a || (B >= C)'\'''
test-expr '!a || (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B >= C)'\'''

echo '$ test-expr '\''!a || (B == C)'\'''
test-expr '!a || (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B == C)'\'''

echo '$ test-expr '\''!a || (B != C)'\'''
test-expr '!a || (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B != C)'\'''

echo '$ test-expr '\''!a || (B && C)'\'''
test-expr '!a || (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B && C)'\'''

echo '$ test-expr '\''!a || (B || C)'\'''
test-expr '!a || (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B || C)'\'''

echo '$ test-expr '\''!a <= (B <= !c)'\'''
test-expr '!a <= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B <= !c)'\'''

echo '$ test-expr '\''!a <= (B >= !c)'\'''
test-expr '!a <= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B >= !c)'\'''

echo '$ test-expr '\''!a <= (B == !c)'\'''
test-expr '!a <= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B == !c)'\'''

echo '$ test-expr '\''!a <= (B != !c)'\'''
test-expr '!a <= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B != !c)'\'''

echo '$ test-expr '\''!a <= (B && !c)'\'''
test-expr '!a <= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B && !c)'\'''

echo '$ test-expr '\''!a <= (B || !c)'\'''
test-expr '!a <= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B || !c)'\'''

echo '$ test-expr '\''!a >= (B <= !c)'\'''
test-expr '!a >= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B <= !c)'\'''

echo '$ test-expr '\''!a >= (B >= !c)'\'''
test-expr '!a >= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B >= !c)'\'''

echo '$ test-expr '\''!a >= (B == !c)'\'''
test-expr '!a >= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B == !c)'\'''

echo '$ test-expr '\''!a >= (B != !c)'\'''
test-expr '!a >= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B != !c)'\'''

echo '$ test-expr '\''!a >= (B && !c)'\'''
test-expr '!a >= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B && !c)'\'''

echo '$ test-expr '\''!a >= (B || !c)'\'''
test-expr '!a >= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B || !c)'\'''

echo '$ test-expr '\''!a == (B <= !c)'\'''
test-expr '!a == (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B <= !c)'\'''

echo '$ test-expr '\''!a == (B >= !c)'\'''
test-expr '!a == (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B >= !c)'\'''

echo '$ test-expr '\''!a == (B == !c)'\'''
test-expr '!a == (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B == !c)'\'''

echo '$ test-expr '\''!a == (B != !c)'\'''
test-expr '!a == (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B != !c)'\'''

echo '$ test-expr '\''!a == (B && !c)'\'''
test-expr '!a == (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B && !c)'\'''

echo '$ test-expr '\''!a == (B || !c)'\'''
test-expr '!a == (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B || !c)'\'''

echo '$ test-expr '\''!a != (B <= !c)'\'''
test-expr '!a != (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B <= !c)'\'''

echo '$ test-expr '\''!a != (B >= !c)'\'''
test-expr '!a != (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B >= !c)'\'''

echo '$ test-expr '\''!a != (B == !c)'\'''
test-expr '!a != (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B == !c)'\'''

echo '$ test-expr '\''!a != (B != !c)'\'''
test-expr '!a != (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B != !c)'\'''

echo '$ test-expr '\''!a != (B && !c)'\'''
test-expr '!a != (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B && !c)'\'''

echo '$ test-expr '\''!a != (B || !c)'\'''
test-expr '!a != (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B || !c)'\'''

echo '$ test-expr '\''!a && (B <= !c)'\'''
test-expr '!a && (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B <= !c)'\'''

echo '$ test-expr '\''!a && (B >= !c)'\'''
test-expr '!a && (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B >= !c)'\'''

echo '$ test-expr '\''!a && (B == !c)'\'''
test-expr '!a && (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B == !c)'\'''

echo '$ test-expr '\''!a && (B != !c)'\'''
test-expr '!a && (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B != !c)'\'''

echo '$ test-expr '\''!a && (B && !c)'\'''
test-expr '!a && (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B && !c)'\'''

echo '$ test-expr '\''!a && (B || !c)'\'''
test-expr '!a && (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B || !c)'\'''

echo '$ test-expr '\''!a || (B <= !c)'\'''
test-expr '!a || (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B <= !c)'\'''

echo '$ test-expr '\''!a || (B >= !c)'\'''
test-expr '!a || (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B >= !c)'\'''

echo '$ test-expr '\''!a || (B == !c)'\'''
test-expr '!a || (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B == !c)'\'''

echo '$ test-expr '\''!a || (B != !c)'\'''
test-expr '!a || (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B != !c)'\'''

echo '$ test-expr '\''!a || (B && !c)'\'''
test-expr '!a || (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B && !c)'\'''

echo '$ test-expr '\''!a || (B || !c)'\'''
test-expr '!a || (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B || !c)'\'''

echo '$ test-expr '\''!a <= (B <= !C)'\'''
test-expr '!a <= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B <= !C)'\'''

echo '$ test-expr '\''!a <= (B >= !C)'\'''
test-expr '!a <= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B >= !C)'\'''

echo '$ test-expr '\''!a <= (B == !C)'\'''
test-expr '!a <= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B == !C)'\'''

echo '$ test-expr '\''!a <= (B != !C)'\'''
test-expr '!a <= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B != !C)'\'''

echo '$ test-expr '\''!a <= (B && !C)'\'''
test-expr '!a <= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B && !C)'\'''

echo '$ test-expr '\''!a <= (B || !C)'\'''
test-expr '!a <= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (B || !C)'\'''

echo '$ test-expr '\''!a >= (B <= !C)'\'''
test-expr '!a >= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B <= !C)'\'''

echo '$ test-expr '\''!a >= (B >= !C)'\'''
test-expr '!a >= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B >= !C)'\'''

echo '$ test-expr '\''!a >= (B == !C)'\'''
test-expr '!a >= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B == !C)'\'''

echo '$ test-expr '\''!a >= (B != !C)'\'''
test-expr '!a >= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B != !C)'\'''

echo '$ test-expr '\''!a >= (B && !C)'\'''
test-expr '!a >= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B && !C)'\'''

echo '$ test-expr '\''!a >= (B || !C)'\'''
test-expr '!a >= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (B || !C)'\'''

echo '$ test-expr '\''!a == (B <= !C)'\'''
test-expr '!a == (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B <= !C)'\'''

echo '$ test-expr '\''!a == (B >= !C)'\'''
test-expr '!a == (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B >= !C)'\'''

echo '$ test-expr '\''!a == (B == !C)'\'''
test-expr '!a == (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B == !C)'\'''

echo '$ test-expr '\''!a == (B != !C)'\'''
test-expr '!a == (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B != !C)'\'''

echo '$ test-expr '\''!a == (B && !C)'\'''
test-expr '!a == (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B && !C)'\'''

echo '$ test-expr '\''!a == (B || !C)'\'''
test-expr '!a == (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (B || !C)'\'''

echo '$ test-expr '\''!a != (B <= !C)'\'''
test-expr '!a != (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B <= !C)'\'''

echo '$ test-expr '\''!a != (B >= !C)'\'''
test-expr '!a != (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B >= !C)'\'''

echo '$ test-expr '\''!a != (B == !C)'\'''
test-expr '!a != (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B == !C)'\'''

echo '$ test-expr '\''!a != (B != !C)'\'''
test-expr '!a != (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B != !C)'\'''

echo '$ test-expr '\''!a != (B && !C)'\'''
test-expr '!a != (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B && !C)'\'''

echo '$ test-expr '\''!a != (B || !C)'\'''
test-expr '!a != (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (B || !C)'\'''

echo '$ test-expr '\''!a && (B <= !C)'\'''
test-expr '!a && (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B <= !C)'\'''

echo '$ test-expr '\''!a && (B >= !C)'\'''
test-expr '!a && (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B >= !C)'\'''

echo '$ test-expr '\''!a && (B == !C)'\'''
test-expr '!a && (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B == !C)'\'''

echo '$ test-expr '\''!a && (B != !C)'\'''
test-expr '!a && (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B != !C)'\'''

echo '$ test-expr '\''!a && (B && !C)'\'''
test-expr '!a && (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B && !C)'\'''

echo '$ test-expr '\''!a && (B || !C)'\'''
test-expr '!a && (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (B || !C)'\'''

echo '$ test-expr '\''!a || (B <= !C)'\'''
test-expr '!a || (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B <= !C)'\'''

echo '$ test-expr '\''!a || (B >= !C)'\'''
test-expr '!a || (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B >= !C)'\'''

echo '$ test-expr '\''!a || (B == !C)'\'''
test-expr '!a || (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B == !C)'\'''

echo '$ test-expr '\''!a || (B != !C)'\'''
test-expr '!a || (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B != !C)'\'''

echo '$ test-expr '\''!a || (B && !C)'\'''
test-expr '!a || (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B && !C)'\'''

echo '$ test-expr '\''!a || (B || !C)'\'''
test-expr '!a || (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (B || !C)'\'''

echo '$ test-expr '\''!a <= (!b <= c)'\'''
test-expr '!a <= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b <= c)'\'''

echo '$ test-expr '\''!a <= (!b >= c)'\'''
test-expr '!a <= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b >= c)'\'''

echo '$ test-expr '\''!a <= (!b == c)'\'''
test-expr '!a <= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b == c)'\'''

echo '$ test-expr '\''!a <= (!b != c)'\'''
test-expr '!a <= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b != c)'\'''

echo '$ test-expr '\''!a <= (!b && c)'\'''
test-expr '!a <= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b && c)'\'''

echo '$ test-expr '\''!a <= (!b || c)'\'''
test-expr '!a <= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b || c)'\'''

echo '$ test-expr '\''!a >= (!b <= c)'\'''
test-expr '!a >= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b <= c)'\'''

echo '$ test-expr '\''!a >= (!b >= c)'\'''
test-expr '!a >= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b >= c)'\'''

echo '$ test-expr '\''!a >= (!b == c)'\'''
test-expr '!a >= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b == c)'\'''

echo '$ test-expr '\''!a >= (!b != c)'\'''
test-expr '!a >= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b != c)'\'''

echo '$ test-expr '\''!a >= (!b && c)'\'''
test-expr '!a >= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b && c)'\'''

echo '$ test-expr '\''!a >= (!b || c)'\'''
test-expr '!a >= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b || c)'\'''

echo '$ test-expr '\''!a == (!b <= c)'\'''
test-expr '!a == (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b <= c)'\'''

echo '$ test-expr '\''!a == (!b >= c)'\'''
test-expr '!a == (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b >= c)'\'''

echo '$ test-expr '\''!a == (!b == c)'\'''
test-expr '!a == (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b == c)'\'''

echo '$ test-expr '\''!a == (!b != c)'\'''
test-expr '!a == (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b != c)'\'''

echo '$ test-expr '\''!a == (!b && c)'\'''
test-expr '!a == (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b && c)'\'''

echo '$ test-expr '\''!a == (!b || c)'\'''
test-expr '!a == (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b || c)'\'''

echo '$ test-expr '\''!a != (!b <= c)'\'''
test-expr '!a != (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b <= c)'\'''

echo '$ test-expr '\''!a != (!b >= c)'\'''
test-expr '!a != (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b >= c)'\'''

echo '$ test-expr '\''!a != (!b == c)'\'''
test-expr '!a != (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b == c)'\'''

echo '$ test-expr '\''!a != (!b != c)'\'''
test-expr '!a != (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b != c)'\'''

echo '$ test-expr '\''!a != (!b && c)'\'''
test-expr '!a != (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b && c)'\'''

echo '$ test-expr '\''!a != (!b || c)'\'''
test-expr '!a != (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b || c)'\'''

echo '$ test-expr '\''!a && (!b <= c)'\'''
test-expr '!a && (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b <= c)'\'''

echo '$ test-expr '\''!a && (!b >= c)'\'''
test-expr '!a && (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b >= c)'\'''

echo '$ test-expr '\''!a && (!b == c)'\'''
test-expr '!a && (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b == c)'\'''

echo '$ test-expr '\''!a && (!b != c)'\'''
test-expr '!a && (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b != c)'\'''

echo '$ test-expr '\''!a && (!b && c)'\'''
test-expr '!a && (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b && c)'\'''

echo '$ test-expr '\''!a && (!b || c)'\'''
test-expr '!a && (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b || c)'\'''

echo '$ test-expr '\''!a || (!b <= c)'\'''
test-expr '!a || (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b <= c)'\'''

echo '$ test-expr '\''!a || (!b >= c)'\'''
test-expr '!a || (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b >= c)'\'''

echo '$ test-expr '\''!a || (!b == c)'\'''
test-expr '!a || (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b == c)'\'''

echo '$ test-expr '\''!a || (!b != c)'\'''
test-expr '!a || (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b != c)'\'''

echo '$ test-expr '\''!a || (!b && c)'\'''
test-expr '!a || (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b && c)'\'''

echo '$ test-expr '\''!a || (!b || c)'\'''
test-expr '!a || (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b || c)'\'''

echo '$ test-expr '\''!a <= (!b <= C)'\'''
test-expr '!a <= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b <= C)'\'''

echo '$ test-expr '\''!a <= (!b >= C)'\'''
test-expr '!a <= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b >= C)'\'''

echo '$ test-expr '\''!a <= (!b == C)'\'''
test-expr '!a <= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b == C)'\'''

echo '$ test-expr '\''!a <= (!b != C)'\'''
test-expr '!a <= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b != C)'\'''

echo '$ test-expr '\''!a <= (!b && C)'\'''
test-expr '!a <= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b && C)'\'''

echo '$ test-expr '\''!a <= (!b || C)'\'''
test-expr '!a <= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b || C)'\'''

echo '$ test-expr '\''!a >= (!b <= C)'\'''
test-expr '!a >= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b <= C)'\'''

echo '$ test-expr '\''!a >= (!b >= C)'\'''
test-expr '!a >= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b >= C)'\'''

echo '$ test-expr '\''!a >= (!b == C)'\'''
test-expr '!a >= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b == C)'\'''

echo '$ test-expr '\''!a >= (!b != C)'\'''
test-expr '!a >= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b != C)'\'''

echo '$ test-expr '\''!a >= (!b && C)'\'''
test-expr '!a >= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b && C)'\'''

echo '$ test-expr '\''!a >= (!b || C)'\'''
test-expr '!a >= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b || C)'\'''

echo '$ test-expr '\''!a == (!b <= C)'\'''
test-expr '!a == (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b <= C)'\'''

echo '$ test-expr '\''!a == (!b >= C)'\'''
test-expr '!a == (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b >= C)'\'''

echo '$ test-expr '\''!a == (!b == C)'\'''
test-expr '!a == (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b == C)'\'''

echo '$ test-expr '\''!a == (!b != C)'\'''
test-expr '!a == (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b != C)'\'''

echo '$ test-expr '\''!a == (!b && C)'\'''
test-expr '!a == (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b && C)'\'''

echo '$ test-expr '\''!a == (!b || C)'\'''
test-expr '!a == (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b || C)'\'''

echo '$ test-expr '\''!a != (!b <= C)'\'''
test-expr '!a != (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b <= C)'\'''

echo '$ test-expr '\''!a != (!b >= C)'\'''
test-expr '!a != (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b >= C)'\'''

echo '$ test-expr '\''!a != (!b == C)'\'''
test-expr '!a != (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b == C)'\'''

echo '$ test-expr '\''!a != (!b != C)'\'''
test-expr '!a != (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b != C)'\'''

echo '$ test-expr '\''!a != (!b && C)'\'''
test-expr '!a != (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b && C)'\'''

echo '$ test-expr '\''!a != (!b || C)'\'''
test-expr '!a != (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b || C)'\'''

echo '$ test-expr '\''!a && (!b <= C)'\'''
test-expr '!a && (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b <= C)'\'''

echo '$ test-expr '\''!a && (!b >= C)'\'''
test-expr '!a && (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b >= C)'\'''

echo '$ test-expr '\''!a && (!b == C)'\'''
test-expr '!a && (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b == C)'\'''

echo '$ test-expr '\''!a && (!b != C)'\'''
test-expr '!a && (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b != C)'\'''

echo '$ test-expr '\''!a && (!b && C)'\'''
test-expr '!a && (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b && C)'\'''

echo '$ test-expr '\''!a && (!b || C)'\'''
test-expr '!a && (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b || C)'\'''

echo '$ test-expr '\''!a || (!b <= C)'\'''
test-expr '!a || (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b <= C)'\'''

echo '$ test-expr '\''!a || (!b >= C)'\'''
test-expr '!a || (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b >= C)'\'''

echo '$ test-expr '\''!a || (!b == C)'\'''
test-expr '!a || (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b == C)'\'''

echo '$ test-expr '\''!a || (!b != C)'\'''
test-expr '!a || (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b != C)'\'''

echo '$ test-expr '\''!a || (!b && C)'\'''
test-expr '!a || (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b && C)'\'''

echo '$ test-expr '\''!a || (!b || C)'\'''
test-expr '!a || (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b || C)'\'''

echo '$ test-expr '\''!a <= (!b <= !c)'\'''
test-expr '!a <= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b <= !c)'\'''

echo '$ test-expr '\''!a <= (!b >= !c)'\'''
test-expr '!a <= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b >= !c)'\'''

echo '$ test-expr '\''!a <= (!b == !c)'\'''
test-expr '!a <= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b == !c)'\'''

echo '$ test-expr '\''!a <= (!b != !c)'\'''
test-expr '!a <= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b != !c)'\'''

echo '$ test-expr '\''!a <= (!b && !c)'\'''
test-expr '!a <= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b && !c)'\'''

echo '$ test-expr '\''!a <= (!b || !c)'\'''
test-expr '!a <= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b || !c)'\'''

echo '$ test-expr '\''!a >= (!b <= !c)'\'''
test-expr '!a >= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b <= !c)'\'''

echo '$ test-expr '\''!a >= (!b >= !c)'\'''
test-expr '!a >= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b >= !c)'\'''

echo '$ test-expr '\''!a >= (!b == !c)'\'''
test-expr '!a >= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b == !c)'\'''

echo '$ test-expr '\''!a >= (!b != !c)'\'''
test-expr '!a >= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b != !c)'\'''

echo '$ test-expr '\''!a >= (!b && !c)'\'''
test-expr '!a >= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b && !c)'\'''

echo '$ test-expr '\''!a >= (!b || !c)'\'''
test-expr '!a >= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b || !c)'\'''

echo '$ test-expr '\''!a == (!b <= !c)'\'''
test-expr '!a == (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b <= !c)'\'''

echo '$ test-expr '\''!a == (!b >= !c)'\'''
test-expr '!a == (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b >= !c)'\'''

echo '$ test-expr '\''!a == (!b == !c)'\'''
test-expr '!a == (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b == !c)'\'''

echo '$ test-expr '\''!a == (!b != !c)'\'''
test-expr '!a == (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b != !c)'\'''

echo '$ test-expr '\''!a == (!b && !c)'\'''
test-expr '!a == (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b && !c)'\'''

echo '$ test-expr '\''!a == (!b || !c)'\'''
test-expr '!a == (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b || !c)'\'''

echo '$ test-expr '\''!a != (!b <= !c)'\'''
test-expr '!a != (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b <= !c)'\'''

echo '$ test-expr '\''!a != (!b >= !c)'\'''
test-expr '!a != (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b >= !c)'\'''

echo '$ test-expr '\''!a != (!b == !c)'\'''
test-expr '!a != (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b == !c)'\'''

echo '$ test-expr '\''!a != (!b != !c)'\'''
test-expr '!a != (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b != !c)'\'''

echo '$ test-expr '\''!a != (!b && !c)'\'''
test-expr '!a != (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b && !c)'\'''

echo '$ test-expr '\''!a != (!b || !c)'\'''
test-expr '!a != (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b || !c)'\'''

echo '$ test-expr '\''!a && (!b <= !c)'\'''
test-expr '!a && (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b <= !c)'\'''

echo '$ test-expr '\''!a && (!b >= !c)'\'''
test-expr '!a && (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b >= !c)'\'''

echo '$ test-expr '\''!a && (!b == !c)'\'''
test-expr '!a && (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b == !c)'\'''

echo '$ test-expr '\''!a && (!b != !c)'\'''
test-expr '!a && (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b != !c)'\'''

echo '$ test-expr '\''!a && (!b && !c)'\'''
test-expr '!a && (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b && !c)'\'''

echo '$ test-expr '\''!a && (!b || !c)'\'''
test-expr '!a && (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b || !c)'\'''

echo '$ test-expr '\''!a || (!b <= !c)'\'''
test-expr '!a || (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b <= !c)'\'''

echo '$ test-expr '\''!a || (!b >= !c)'\'''
test-expr '!a || (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b >= !c)'\'''

echo '$ test-expr '\''!a || (!b == !c)'\'''
test-expr '!a || (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b == !c)'\'''

echo '$ test-expr '\''!a || (!b != !c)'\'''
test-expr '!a || (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b != !c)'\'''

echo '$ test-expr '\''!a || (!b && !c)'\'''
test-expr '!a || (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b && !c)'\'''

echo '$ test-expr '\''!a || (!b || !c)'\'''
test-expr '!a || (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b || !c)'\'''

echo '$ test-expr '\''!a <= (!b <= !C)'\'''
test-expr '!a <= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b <= !C)'\'''

echo '$ test-expr '\''!a <= (!b >= !C)'\'''
test-expr '!a <= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b >= !C)'\'''

echo '$ test-expr '\''!a <= (!b == !C)'\'''
test-expr '!a <= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b == !C)'\'''

echo '$ test-expr '\''!a <= (!b != !C)'\'''
test-expr '!a <= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b != !C)'\'''

echo '$ test-expr '\''!a <= (!b && !C)'\'''
test-expr '!a <= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b && !C)'\'''

echo '$ test-expr '\''!a <= (!b || !C)'\'''
test-expr '!a <= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!b || !C)'\'''

echo '$ test-expr '\''!a >= (!b <= !C)'\'''
test-expr '!a >= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b <= !C)'\'''

echo '$ test-expr '\''!a >= (!b >= !C)'\'''
test-expr '!a >= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b >= !C)'\'''

echo '$ test-expr '\''!a >= (!b == !C)'\'''
test-expr '!a >= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b == !C)'\'''

echo '$ test-expr '\''!a >= (!b != !C)'\'''
test-expr '!a >= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b != !C)'\'''

echo '$ test-expr '\''!a >= (!b && !C)'\'''
test-expr '!a >= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b && !C)'\'''

echo '$ test-expr '\''!a >= (!b || !C)'\'''
test-expr '!a >= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!b || !C)'\'''

echo '$ test-expr '\''!a == (!b <= !C)'\'''
test-expr '!a == (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b <= !C)'\'''

echo '$ test-expr '\''!a == (!b >= !C)'\'''
test-expr '!a == (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b >= !C)'\'''

echo '$ test-expr '\''!a == (!b == !C)'\'''
test-expr '!a == (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b == !C)'\'''

echo '$ test-expr '\''!a == (!b != !C)'\'''
test-expr '!a == (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b != !C)'\'''

echo '$ test-expr '\''!a == (!b && !C)'\'''
test-expr '!a == (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b && !C)'\'''

echo '$ test-expr '\''!a == (!b || !C)'\'''
test-expr '!a == (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!b || !C)'\'''

echo '$ test-expr '\''!a != (!b <= !C)'\'''
test-expr '!a != (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b <= !C)'\'''

echo '$ test-expr '\''!a != (!b >= !C)'\'''
test-expr '!a != (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b >= !C)'\'''

echo '$ test-expr '\''!a != (!b == !C)'\'''
test-expr '!a != (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b == !C)'\'''

echo '$ test-expr '\''!a != (!b != !C)'\'''
test-expr '!a != (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b != !C)'\'''

echo '$ test-expr '\''!a != (!b && !C)'\'''
test-expr '!a != (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b && !C)'\'''

echo '$ test-expr '\''!a != (!b || !C)'\'''
test-expr '!a != (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!b || !C)'\'''

echo '$ test-expr '\''!a && (!b <= !C)'\'''
test-expr '!a && (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b <= !C)'\'''

echo '$ test-expr '\''!a && (!b >= !C)'\'''
test-expr '!a && (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b >= !C)'\'''

echo '$ test-expr '\''!a && (!b == !C)'\'''
test-expr '!a && (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b == !C)'\'''

echo '$ test-expr '\''!a && (!b != !C)'\'''
test-expr '!a && (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b != !C)'\'''

echo '$ test-expr '\''!a && (!b && !C)'\'''
test-expr '!a && (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b && !C)'\'''

echo '$ test-expr '\''!a && (!b || !C)'\'''
test-expr '!a && (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!b || !C)'\'''

echo '$ test-expr '\''!a || (!b <= !C)'\'''
test-expr '!a || (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b <= !C)'\'''

echo '$ test-expr '\''!a || (!b >= !C)'\'''
test-expr '!a || (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b >= !C)'\'''

echo '$ test-expr '\''!a || (!b == !C)'\'''
test-expr '!a || (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b == !C)'\'''

echo '$ test-expr '\''!a || (!b != !C)'\'''
test-expr '!a || (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b != !C)'\'''

echo '$ test-expr '\''!a || (!b && !C)'\'''
test-expr '!a || (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b && !C)'\'''

echo '$ test-expr '\''!a || (!b || !C)'\'''
test-expr '!a || (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!b || !C)'\'''

echo '$ test-expr '\''!a <= (!B <= c)'\'''
test-expr '!a <= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B <= c)'\'''

echo '$ test-expr '\''!a <= (!B >= c)'\'''
test-expr '!a <= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B >= c)'\'''

echo '$ test-expr '\''!a <= (!B == c)'\'''
test-expr '!a <= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B == c)'\'''

echo '$ test-expr '\''!a <= (!B != c)'\'''
test-expr '!a <= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B != c)'\'''

echo '$ test-expr '\''!a <= (!B && c)'\'''
test-expr '!a <= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B && c)'\'''

echo '$ test-expr '\''!a <= (!B || c)'\'''
test-expr '!a <= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B || c)'\'''

echo '$ test-expr '\''!a >= (!B <= c)'\'''
test-expr '!a >= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B <= c)'\'''

echo '$ test-expr '\''!a >= (!B >= c)'\'''
test-expr '!a >= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B >= c)'\'''

echo '$ test-expr '\''!a >= (!B == c)'\'''
test-expr '!a >= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B == c)'\'''

echo '$ test-expr '\''!a >= (!B != c)'\'''
test-expr '!a >= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B != c)'\'''

echo '$ test-expr '\''!a >= (!B && c)'\'''
test-expr '!a >= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B && c)'\'''

echo '$ test-expr '\''!a >= (!B || c)'\'''
test-expr '!a >= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B || c)'\'''

echo '$ test-expr '\''!a == (!B <= c)'\'''
test-expr '!a == (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B <= c)'\'''

echo '$ test-expr '\''!a == (!B >= c)'\'''
test-expr '!a == (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B >= c)'\'''

echo '$ test-expr '\''!a == (!B == c)'\'''
test-expr '!a == (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B == c)'\'''

echo '$ test-expr '\''!a == (!B != c)'\'''
test-expr '!a == (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B != c)'\'''

echo '$ test-expr '\''!a == (!B && c)'\'''
test-expr '!a == (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B && c)'\'''

echo '$ test-expr '\''!a == (!B || c)'\'''
test-expr '!a == (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B || c)'\'''

echo '$ test-expr '\''!a != (!B <= c)'\'''
test-expr '!a != (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B <= c)'\'''

echo '$ test-expr '\''!a != (!B >= c)'\'''
test-expr '!a != (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B >= c)'\'''

echo '$ test-expr '\''!a != (!B == c)'\'''
test-expr '!a != (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B == c)'\'''

echo '$ test-expr '\''!a != (!B != c)'\'''
test-expr '!a != (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B != c)'\'''

echo '$ test-expr '\''!a != (!B && c)'\'''
test-expr '!a != (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B && c)'\'''

echo '$ test-expr '\''!a != (!B || c)'\'''
test-expr '!a != (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B || c)'\'''

echo '$ test-expr '\''!a && (!B <= c)'\'''
test-expr '!a && (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B <= c)'\'''

echo '$ test-expr '\''!a && (!B >= c)'\'''
test-expr '!a && (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B >= c)'\'''

echo '$ test-expr '\''!a && (!B == c)'\'''
test-expr '!a && (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B == c)'\'''

echo '$ test-expr '\''!a && (!B != c)'\'''
test-expr '!a && (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B != c)'\'''

echo '$ test-expr '\''!a && (!B && c)'\'''
test-expr '!a && (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B && c)'\'''

echo '$ test-expr '\''!a && (!B || c)'\'''
test-expr '!a && (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B || c)'\'''

echo '$ test-expr '\''!a || (!B <= c)'\'''
test-expr '!a || (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B <= c)'\'''

echo '$ test-expr '\''!a || (!B >= c)'\'''
test-expr '!a || (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B >= c)'\'''

echo '$ test-expr '\''!a || (!B == c)'\'''
test-expr '!a || (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B == c)'\'''

echo '$ test-expr '\''!a || (!B != c)'\'''
test-expr '!a || (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B != c)'\'''

echo '$ test-expr '\''!a || (!B && c)'\'''
test-expr '!a || (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B && c)'\'''

echo '$ test-expr '\''!a || (!B || c)'\'''
test-expr '!a || (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B || c)'\'''

echo '$ test-expr '\''!a <= (!B <= C)'\'''
test-expr '!a <= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B <= C)'\'''

echo '$ test-expr '\''!a <= (!B >= C)'\'''
test-expr '!a <= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B >= C)'\'''

echo '$ test-expr '\''!a <= (!B == C)'\'''
test-expr '!a <= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B == C)'\'''

echo '$ test-expr '\''!a <= (!B != C)'\'''
test-expr '!a <= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B != C)'\'''

echo '$ test-expr '\''!a <= (!B && C)'\'''
test-expr '!a <= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B && C)'\'''

echo '$ test-expr '\''!a <= (!B || C)'\'''
test-expr '!a <= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B || C)'\'''

echo '$ test-expr '\''!a >= (!B <= C)'\'''
test-expr '!a >= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B <= C)'\'''

echo '$ test-expr '\''!a >= (!B >= C)'\'''
test-expr '!a >= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B >= C)'\'''

echo '$ test-expr '\''!a >= (!B == C)'\'''
test-expr '!a >= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B == C)'\'''

echo '$ test-expr '\''!a >= (!B != C)'\'''
test-expr '!a >= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B != C)'\'''

echo '$ test-expr '\''!a >= (!B && C)'\'''
test-expr '!a >= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B && C)'\'''

echo '$ test-expr '\''!a >= (!B || C)'\'''
test-expr '!a >= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B || C)'\'''

echo '$ test-expr '\''!a == (!B <= C)'\'''
test-expr '!a == (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B <= C)'\'''

echo '$ test-expr '\''!a == (!B >= C)'\'''
test-expr '!a == (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B >= C)'\'''

echo '$ test-expr '\''!a == (!B == C)'\'''
test-expr '!a == (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B == C)'\'''

echo '$ test-expr '\''!a == (!B != C)'\'''
test-expr '!a == (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B != C)'\'''

echo '$ test-expr '\''!a == (!B && C)'\'''
test-expr '!a == (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B && C)'\'''

echo '$ test-expr '\''!a == (!B || C)'\'''
test-expr '!a == (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B || C)'\'''

echo '$ test-expr '\''!a != (!B <= C)'\'''
test-expr '!a != (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B <= C)'\'''

echo '$ test-expr '\''!a != (!B >= C)'\'''
test-expr '!a != (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B >= C)'\'''

echo '$ test-expr '\''!a != (!B == C)'\'''
test-expr '!a != (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B == C)'\'''

echo '$ test-expr '\''!a != (!B != C)'\'''
test-expr '!a != (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B != C)'\'''

echo '$ test-expr '\''!a != (!B && C)'\'''
test-expr '!a != (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B && C)'\'''

echo '$ test-expr '\''!a != (!B || C)'\'''
test-expr '!a != (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B || C)'\'''

echo '$ test-expr '\''!a && (!B <= C)'\'''
test-expr '!a && (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B <= C)'\'''

echo '$ test-expr '\''!a && (!B >= C)'\'''
test-expr '!a && (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B >= C)'\'''

echo '$ test-expr '\''!a && (!B == C)'\'''
test-expr '!a && (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B == C)'\'''

echo '$ test-expr '\''!a && (!B != C)'\'''
test-expr '!a && (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B != C)'\'''

echo '$ test-expr '\''!a && (!B && C)'\'''
test-expr '!a && (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B && C)'\'''

echo '$ test-expr '\''!a && (!B || C)'\'''
test-expr '!a && (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B || C)'\'''

echo '$ test-expr '\''!a || (!B <= C)'\'''
test-expr '!a || (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B <= C)'\'''

echo '$ test-expr '\''!a || (!B >= C)'\'''
test-expr '!a || (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B >= C)'\'''

echo '$ test-expr '\''!a || (!B == C)'\'''
test-expr '!a || (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B == C)'\'''

echo '$ test-expr '\''!a || (!B != C)'\'''
test-expr '!a || (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B != C)'\'''

echo '$ test-expr '\''!a || (!B && C)'\'''
test-expr '!a || (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B && C)'\'''

echo '$ test-expr '\''!a || (!B || C)'\'''
test-expr '!a || (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B || C)'\'''

echo '$ test-expr '\''!a <= (!B <= !c)'\'''
test-expr '!a <= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B <= !c)'\'''

echo '$ test-expr '\''!a <= (!B >= !c)'\'''
test-expr '!a <= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B >= !c)'\'''

echo '$ test-expr '\''!a <= (!B == !c)'\'''
test-expr '!a <= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B == !c)'\'''

echo '$ test-expr '\''!a <= (!B != !c)'\'''
test-expr '!a <= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B != !c)'\'''

echo '$ test-expr '\''!a <= (!B && !c)'\'''
test-expr '!a <= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B && !c)'\'''

echo '$ test-expr '\''!a <= (!B || !c)'\'''
test-expr '!a <= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B || !c)'\'''

echo '$ test-expr '\''!a >= (!B <= !c)'\'''
test-expr '!a >= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B <= !c)'\'''

echo '$ test-expr '\''!a >= (!B >= !c)'\'''
test-expr '!a >= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B >= !c)'\'''

echo '$ test-expr '\''!a >= (!B == !c)'\'''
test-expr '!a >= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B == !c)'\'''

echo '$ test-expr '\''!a >= (!B != !c)'\'''
test-expr '!a >= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B != !c)'\'''

echo '$ test-expr '\''!a >= (!B && !c)'\'''
test-expr '!a >= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B && !c)'\'''

echo '$ test-expr '\''!a >= (!B || !c)'\'''
test-expr '!a >= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B || !c)'\'''

echo '$ test-expr '\''!a == (!B <= !c)'\'''
test-expr '!a == (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B <= !c)'\'''

echo '$ test-expr '\''!a == (!B >= !c)'\'''
test-expr '!a == (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B >= !c)'\'''

echo '$ test-expr '\''!a == (!B == !c)'\'''
test-expr '!a == (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B == !c)'\'''

echo '$ test-expr '\''!a == (!B != !c)'\'''
test-expr '!a == (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B != !c)'\'''

echo '$ test-expr '\''!a == (!B && !c)'\'''
test-expr '!a == (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B && !c)'\'''

echo '$ test-expr '\''!a == (!B || !c)'\'''
test-expr '!a == (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B || !c)'\'''

echo '$ test-expr '\''!a != (!B <= !c)'\'''
test-expr '!a != (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B <= !c)'\'''

echo '$ test-expr '\''!a != (!B >= !c)'\'''
test-expr '!a != (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B >= !c)'\'''

echo '$ test-expr '\''!a != (!B == !c)'\'''
test-expr '!a != (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B == !c)'\'''

echo '$ test-expr '\''!a != (!B != !c)'\'''
test-expr '!a != (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B != !c)'\'''

echo '$ test-expr '\''!a != (!B && !c)'\'''
test-expr '!a != (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B && !c)'\'''

echo '$ test-expr '\''!a != (!B || !c)'\'''
test-expr '!a != (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B || !c)'\'''

echo '$ test-expr '\''!a && (!B <= !c)'\'''
test-expr '!a && (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B <= !c)'\'''

echo '$ test-expr '\''!a && (!B >= !c)'\'''
test-expr '!a && (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B >= !c)'\'''

echo '$ test-expr '\''!a && (!B == !c)'\'''
test-expr '!a && (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B == !c)'\'''

echo '$ test-expr '\''!a && (!B != !c)'\'''
test-expr '!a && (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B != !c)'\'''

echo '$ test-expr '\''!a && (!B && !c)'\'''
test-expr '!a && (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B && !c)'\'''

echo '$ test-expr '\''!a && (!B || !c)'\'''
test-expr '!a && (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B || !c)'\'''

echo '$ test-expr '\''!a || (!B <= !c)'\'''
test-expr '!a || (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B <= !c)'\'''

echo '$ test-expr '\''!a || (!B >= !c)'\'''
test-expr '!a || (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B >= !c)'\'''

echo '$ test-expr '\''!a || (!B == !c)'\'''
test-expr '!a || (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B == !c)'\'''

echo '$ test-expr '\''!a || (!B != !c)'\'''
test-expr '!a || (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B != !c)'\'''

echo '$ test-expr '\''!a || (!B && !c)'\'''
test-expr '!a || (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B && !c)'\'''

echo '$ test-expr '\''!a || (!B || !c)'\'''
test-expr '!a || (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B || !c)'\'''

echo '$ test-expr '\''!a <= (!B <= !C)'\'''
test-expr '!a <= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B <= !C)'\'''

echo '$ test-expr '\''!a <= (!B >= !C)'\'''
test-expr '!a <= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B >= !C)'\'''

echo '$ test-expr '\''!a <= (!B == !C)'\'''
test-expr '!a <= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B == !C)'\'''

echo '$ test-expr '\''!a <= (!B != !C)'\'''
test-expr '!a <= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B != !C)'\'''

echo '$ test-expr '\''!a <= (!B && !C)'\'''
test-expr '!a <= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B && !C)'\'''

echo '$ test-expr '\''!a <= (!B || !C)'\'''
test-expr '!a <= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a <= (!B || !C)'\'''

echo '$ test-expr '\''!a >= (!B <= !C)'\'''
test-expr '!a >= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B <= !C)'\'''

echo '$ test-expr '\''!a >= (!B >= !C)'\'''
test-expr '!a >= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B >= !C)'\'''

echo '$ test-expr '\''!a >= (!B == !C)'\'''
test-expr '!a >= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B == !C)'\'''

echo '$ test-expr '\''!a >= (!B != !C)'\'''
test-expr '!a >= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B != !C)'\'''

echo '$ test-expr '\''!a >= (!B && !C)'\'''
test-expr '!a >= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B && !C)'\'''

echo '$ test-expr '\''!a >= (!B || !C)'\'''
test-expr '!a >= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a >= (!B || !C)'\'''

echo '$ test-expr '\''!a == (!B <= !C)'\'''
test-expr '!a == (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B <= !C)'\'''

echo '$ test-expr '\''!a == (!B >= !C)'\'''
test-expr '!a == (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B >= !C)'\'''

echo '$ test-expr '\''!a == (!B == !C)'\'''
test-expr '!a == (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B == !C)'\'''

echo '$ test-expr '\''!a == (!B != !C)'\'''
test-expr '!a == (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B != !C)'\'''

echo '$ test-expr '\''!a == (!B && !C)'\'''
test-expr '!a == (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B && !C)'\'''

echo '$ test-expr '\''!a == (!B || !C)'\'''
test-expr '!a == (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a == (!B || !C)'\'''

echo '$ test-expr '\''!a != (!B <= !C)'\'''
test-expr '!a != (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B <= !C)'\'''

echo '$ test-expr '\''!a != (!B >= !C)'\'''
test-expr '!a != (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B >= !C)'\'''

echo '$ test-expr '\''!a != (!B == !C)'\'''
test-expr '!a != (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B == !C)'\'''

echo '$ test-expr '\''!a != (!B != !C)'\'''
test-expr '!a != (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B != !C)'\'''

echo '$ test-expr '\''!a != (!B && !C)'\'''
test-expr '!a != (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B && !C)'\'''

echo '$ test-expr '\''!a != (!B || !C)'\'''
test-expr '!a != (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a != (!B || !C)'\'''

echo '$ test-expr '\''!a && (!B <= !C)'\'''
test-expr '!a && (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B <= !C)'\'''

echo '$ test-expr '\''!a && (!B >= !C)'\'''
test-expr '!a && (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B >= !C)'\'''

echo '$ test-expr '\''!a && (!B == !C)'\'''
test-expr '!a && (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B == !C)'\'''

echo '$ test-expr '\''!a && (!B != !C)'\'''
test-expr '!a && (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B != !C)'\'''

echo '$ test-expr '\''!a && (!B && !C)'\'''
test-expr '!a && (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B && !C)'\'''

echo '$ test-expr '\''!a && (!B || !C)'\'''
test-expr '!a && (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a && (!B || !C)'\'''

echo '$ test-expr '\''!a || (!B <= !C)'\'''
test-expr '!a || (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B <= !C)'\'''

echo '$ test-expr '\''!a || (!B >= !C)'\'''
test-expr '!a || (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B >= !C)'\'''

echo '$ test-expr '\''!a || (!B == !C)'\'''
test-expr '!a || (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B == !C)'\'''

echo '$ test-expr '\''!a || (!B != !C)'\'''
test-expr '!a || (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B != !C)'\'''

echo '$ test-expr '\''!a || (!B && !C)'\'''
test-expr '!a || (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B && !C)'\'''

echo '$ test-expr '\''!a || (!B || !C)'\'''
test-expr '!a || (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!a || (!B || !C)'\'''

echo '$ test-expr '\''!A <= (b <= c)'\'''
test-expr '!A <= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b <= c)'\'''

echo '$ test-expr '\''!A <= (b >= c)'\'''
test-expr '!A <= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b >= c)'\'''

echo '$ test-expr '\''!A <= (b == c)'\'''
test-expr '!A <= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b == c)'\'''

echo '$ test-expr '\''!A <= (b != c)'\'''
test-expr '!A <= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b != c)'\'''

echo '$ test-expr '\''!A <= (b && c)'\'''
test-expr '!A <= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b && c)'\'''

echo '$ test-expr '\''!A <= (b || c)'\'''
test-expr '!A <= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b || c)'\'''

echo '$ test-expr '\''!A >= (b <= c)'\'''
test-expr '!A >= (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b <= c)'\'''

echo '$ test-expr '\''!A >= (b >= c)'\'''
test-expr '!A >= (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b >= c)'\'''

echo '$ test-expr '\''!A >= (b == c)'\'''
test-expr '!A >= (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b == c)'\'''

echo '$ test-expr '\''!A >= (b != c)'\'''
test-expr '!A >= (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b != c)'\'''

echo '$ test-expr '\''!A >= (b && c)'\'''
test-expr '!A >= (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b && c)'\'''

echo '$ test-expr '\''!A >= (b || c)'\'''
test-expr '!A >= (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b || c)'\'''

echo '$ test-expr '\''!A == (b <= c)'\'''
test-expr '!A == (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b <= c)'\'''

echo '$ test-expr '\''!A == (b >= c)'\'''
test-expr '!A == (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b >= c)'\'''

echo '$ test-expr '\''!A == (b == c)'\'''
test-expr '!A == (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b == c)'\'''

echo '$ test-expr '\''!A == (b != c)'\'''
test-expr '!A == (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b != c)'\'''

echo '$ test-expr '\''!A == (b && c)'\'''
test-expr '!A == (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b && c)'\'''

echo '$ test-expr '\''!A == (b || c)'\'''
test-expr '!A == (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b || c)'\'''

echo '$ test-expr '\''!A != (b <= c)'\'''
test-expr '!A != (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b <= c)'\'''

echo '$ test-expr '\''!A != (b >= c)'\'''
test-expr '!A != (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b >= c)'\'''

echo '$ test-expr '\''!A != (b == c)'\'''
test-expr '!A != (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b == c)'\'''

echo '$ test-expr '\''!A != (b != c)'\'''
test-expr '!A != (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b != c)'\'''

echo '$ test-expr '\''!A != (b && c)'\'''
test-expr '!A != (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b && c)'\'''

echo '$ test-expr '\''!A != (b || c)'\'''
test-expr '!A != (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b || c)'\'''

echo '$ test-expr '\''!A && (b <= c)'\'''
test-expr '!A && (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b <= c)'\'''

echo '$ test-expr '\''!A && (b >= c)'\'''
test-expr '!A && (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b >= c)'\'''

echo '$ test-expr '\''!A && (b == c)'\'''
test-expr '!A && (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b == c)'\'''

echo '$ test-expr '\''!A && (b != c)'\'''
test-expr '!A && (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b != c)'\'''

echo '$ test-expr '\''!A && (b && c)'\'''
test-expr '!A && (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b && c)'\'''

echo '$ test-expr '\''!A && (b || c)'\'''
test-expr '!A && (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b || c)'\'''

echo '$ test-expr '\''!A || (b <= c)'\'''
test-expr '!A || (b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b <= c)'\'''

echo '$ test-expr '\''!A || (b >= c)'\'''
test-expr '!A || (b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b >= c)'\'''

echo '$ test-expr '\''!A || (b == c)'\'''
test-expr '!A || (b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b == c)'\'''

echo '$ test-expr '\''!A || (b != c)'\'''
test-expr '!A || (b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b != c)'\'''

echo '$ test-expr '\''!A || (b && c)'\'''
test-expr '!A || (b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b && c)'\'''

echo '$ test-expr '\''!A || (b || c)'\'''
test-expr '!A || (b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b || c)'\'''

echo '$ test-expr '\''!A <= (b <= C)'\'''
test-expr '!A <= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b <= C)'\'''

echo '$ test-expr '\''!A <= (b >= C)'\'''
test-expr '!A <= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b >= C)'\'''

echo '$ test-expr '\''!A <= (b == C)'\'''
test-expr '!A <= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b == C)'\'''

echo '$ test-expr '\''!A <= (b != C)'\'''
test-expr '!A <= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b != C)'\'''

echo '$ test-expr '\''!A <= (b && C)'\'''
test-expr '!A <= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b && C)'\'''

echo '$ test-expr '\''!A <= (b || C)'\'''
test-expr '!A <= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b || C)'\'''

echo '$ test-expr '\''!A >= (b <= C)'\'''
test-expr '!A >= (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b <= C)'\'''

echo '$ test-expr '\''!A >= (b >= C)'\'''
test-expr '!A >= (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b >= C)'\'''

echo '$ test-expr '\''!A >= (b == C)'\'''
test-expr '!A >= (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b == C)'\'''

echo '$ test-expr '\''!A >= (b != C)'\'''
test-expr '!A >= (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b != C)'\'''

echo '$ test-expr '\''!A >= (b && C)'\'''
test-expr '!A >= (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b && C)'\'''

echo '$ test-expr '\''!A >= (b || C)'\'''
test-expr '!A >= (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b || C)'\'''

echo '$ test-expr '\''!A == (b <= C)'\'''
test-expr '!A == (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b <= C)'\'''

echo '$ test-expr '\''!A == (b >= C)'\'''
test-expr '!A == (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b >= C)'\'''

echo '$ test-expr '\''!A == (b == C)'\'''
test-expr '!A == (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b == C)'\'''

echo '$ test-expr '\''!A == (b != C)'\'''
test-expr '!A == (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b != C)'\'''

echo '$ test-expr '\''!A == (b && C)'\'''
test-expr '!A == (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b && C)'\'''

echo '$ test-expr '\''!A == (b || C)'\'''
test-expr '!A == (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b || C)'\'''

echo '$ test-expr '\''!A != (b <= C)'\'''
test-expr '!A != (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b <= C)'\'''

echo '$ test-expr '\''!A != (b >= C)'\'''
test-expr '!A != (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b >= C)'\'''

echo '$ test-expr '\''!A != (b == C)'\'''
test-expr '!A != (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b == C)'\'''

echo '$ test-expr '\''!A != (b != C)'\'''
test-expr '!A != (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b != C)'\'''

echo '$ test-expr '\''!A != (b && C)'\'''
test-expr '!A != (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b && C)'\'''

echo '$ test-expr '\''!A != (b || C)'\'''
test-expr '!A != (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b || C)'\'''

echo '$ test-expr '\''!A && (b <= C)'\'''
test-expr '!A && (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b <= C)'\'''

echo '$ test-expr '\''!A && (b >= C)'\'''
test-expr '!A && (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b >= C)'\'''

echo '$ test-expr '\''!A && (b == C)'\'''
test-expr '!A && (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b == C)'\'''

echo '$ test-expr '\''!A && (b != C)'\'''
test-expr '!A && (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b != C)'\'''

echo '$ test-expr '\''!A && (b && C)'\'''
test-expr '!A && (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b && C)'\'''

echo '$ test-expr '\''!A && (b || C)'\'''
test-expr '!A && (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b || C)'\'''

echo '$ test-expr '\''!A || (b <= C)'\'''
test-expr '!A || (b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b <= C)'\'''

echo '$ test-expr '\''!A || (b >= C)'\'''
test-expr '!A || (b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b >= C)'\'''

echo '$ test-expr '\''!A || (b == C)'\'''
test-expr '!A || (b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b == C)'\'''

echo '$ test-expr '\''!A || (b != C)'\'''
test-expr '!A || (b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b != C)'\'''

echo '$ test-expr '\''!A || (b && C)'\'''
test-expr '!A || (b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b && C)'\'''

echo '$ test-expr '\''!A || (b || C)'\'''
test-expr '!A || (b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b || C)'\'''

echo '$ test-expr '\''!A <= (b <= !c)'\'''
test-expr '!A <= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b <= !c)'\'''

echo '$ test-expr '\''!A <= (b >= !c)'\'''
test-expr '!A <= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b >= !c)'\'''

echo '$ test-expr '\''!A <= (b == !c)'\'''
test-expr '!A <= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b == !c)'\'''

echo '$ test-expr '\''!A <= (b != !c)'\'''
test-expr '!A <= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b != !c)'\'''

echo '$ test-expr '\''!A <= (b && !c)'\'''
test-expr '!A <= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b && !c)'\'''

echo '$ test-expr '\''!A <= (b || !c)'\'''
test-expr '!A <= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b || !c)'\'''

echo '$ test-expr '\''!A >= (b <= !c)'\'''
test-expr '!A >= (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b <= !c)'\'''

echo '$ test-expr '\''!A >= (b >= !c)'\'''
test-expr '!A >= (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b >= !c)'\'''

echo '$ test-expr '\''!A >= (b == !c)'\'''
test-expr '!A >= (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b == !c)'\'''

echo '$ test-expr '\''!A >= (b != !c)'\'''
test-expr '!A >= (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b != !c)'\'''

echo '$ test-expr '\''!A >= (b && !c)'\'''
test-expr '!A >= (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b && !c)'\'''

echo '$ test-expr '\''!A >= (b || !c)'\'''
test-expr '!A >= (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b || !c)'\'''

echo '$ test-expr '\''!A == (b <= !c)'\'''
test-expr '!A == (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b <= !c)'\'''

echo '$ test-expr '\''!A == (b >= !c)'\'''
test-expr '!A == (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b >= !c)'\'''

echo '$ test-expr '\''!A == (b == !c)'\'''
test-expr '!A == (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b == !c)'\'''

echo '$ test-expr '\''!A == (b != !c)'\'''
test-expr '!A == (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b != !c)'\'''

echo '$ test-expr '\''!A == (b && !c)'\'''
test-expr '!A == (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b && !c)'\'''

echo '$ test-expr '\''!A == (b || !c)'\'''
test-expr '!A == (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b || !c)'\'''

echo '$ test-expr '\''!A != (b <= !c)'\'''
test-expr '!A != (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b <= !c)'\'''

echo '$ test-expr '\''!A != (b >= !c)'\'''
test-expr '!A != (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b >= !c)'\'''

echo '$ test-expr '\''!A != (b == !c)'\'''
test-expr '!A != (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b == !c)'\'''

echo '$ test-expr '\''!A != (b != !c)'\'''
test-expr '!A != (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b != !c)'\'''

echo '$ test-expr '\''!A != (b && !c)'\'''
test-expr '!A != (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b && !c)'\'''

echo '$ test-expr '\''!A != (b || !c)'\'''
test-expr '!A != (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b || !c)'\'''

echo '$ test-expr '\''!A && (b <= !c)'\'''
test-expr '!A && (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b <= !c)'\'''

echo '$ test-expr '\''!A && (b >= !c)'\'''
test-expr '!A && (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b >= !c)'\'''

echo '$ test-expr '\''!A && (b == !c)'\'''
test-expr '!A && (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b == !c)'\'''

echo '$ test-expr '\''!A && (b != !c)'\'''
test-expr '!A && (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b != !c)'\'''

echo '$ test-expr '\''!A && (b && !c)'\'''
test-expr '!A && (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b && !c)'\'''

echo '$ test-expr '\''!A && (b || !c)'\'''
test-expr '!A && (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b || !c)'\'''

echo '$ test-expr '\''!A || (b <= !c)'\'''
test-expr '!A || (b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b <= !c)'\'''

echo '$ test-expr '\''!A || (b >= !c)'\'''
test-expr '!A || (b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b >= !c)'\'''

echo '$ test-expr '\''!A || (b == !c)'\'''
test-expr '!A || (b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b == !c)'\'''

echo '$ test-expr '\''!A || (b != !c)'\'''
test-expr '!A || (b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b != !c)'\'''

echo '$ test-expr '\''!A || (b && !c)'\'''
test-expr '!A || (b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b && !c)'\'''

echo '$ test-expr '\''!A || (b || !c)'\'''
test-expr '!A || (b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b || !c)'\'''

echo '$ test-expr '\''!A <= (b <= !C)'\'''
test-expr '!A <= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b <= !C)'\'''

echo '$ test-expr '\''!A <= (b >= !C)'\'''
test-expr '!A <= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b >= !C)'\'''

echo '$ test-expr '\''!A <= (b == !C)'\'''
test-expr '!A <= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b == !C)'\'''

echo '$ test-expr '\''!A <= (b != !C)'\'''
test-expr '!A <= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b != !C)'\'''

echo '$ test-expr '\''!A <= (b && !C)'\'''
test-expr '!A <= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b && !C)'\'''

echo '$ test-expr '\''!A <= (b || !C)'\'''
test-expr '!A <= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (b || !C)'\'''

echo '$ test-expr '\''!A >= (b <= !C)'\'''
test-expr '!A >= (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b <= !C)'\'''

echo '$ test-expr '\''!A >= (b >= !C)'\'''
test-expr '!A >= (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b >= !C)'\'''

echo '$ test-expr '\''!A >= (b == !C)'\'''
test-expr '!A >= (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b == !C)'\'''

echo '$ test-expr '\''!A >= (b != !C)'\'''
test-expr '!A >= (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b != !C)'\'''

echo '$ test-expr '\''!A >= (b && !C)'\'''
test-expr '!A >= (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b && !C)'\'''

echo '$ test-expr '\''!A >= (b || !C)'\'''
test-expr '!A >= (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (b || !C)'\'''

echo '$ test-expr '\''!A == (b <= !C)'\'''
test-expr '!A == (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b <= !C)'\'''

echo '$ test-expr '\''!A == (b >= !C)'\'''
test-expr '!A == (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b >= !C)'\'''

echo '$ test-expr '\''!A == (b == !C)'\'''
test-expr '!A == (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b == !C)'\'''

echo '$ test-expr '\''!A == (b != !C)'\'''
test-expr '!A == (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b != !C)'\'''

echo '$ test-expr '\''!A == (b && !C)'\'''
test-expr '!A == (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b && !C)'\'''

echo '$ test-expr '\''!A == (b || !C)'\'''
test-expr '!A == (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (b || !C)'\'''

echo '$ test-expr '\''!A != (b <= !C)'\'''
test-expr '!A != (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b <= !C)'\'''

echo '$ test-expr '\''!A != (b >= !C)'\'''
test-expr '!A != (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b >= !C)'\'''

echo '$ test-expr '\''!A != (b == !C)'\'''
test-expr '!A != (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b == !C)'\'''

echo '$ test-expr '\''!A != (b != !C)'\'''
test-expr '!A != (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b != !C)'\'''

echo '$ test-expr '\''!A != (b && !C)'\'''
test-expr '!A != (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b && !C)'\'''

echo '$ test-expr '\''!A != (b || !C)'\'''
test-expr '!A != (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (b || !C)'\'''

echo '$ test-expr '\''!A && (b <= !C)'\'''
test-expr '!A && (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b <= !C)'\'''

echo '$ test-expr '\''!A && (b >= !C)'\'''
test-expr '!A && (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b >= !C)'\'''

echo '$ test-expr '\''!A && (b == !C)'\'''
test-expr '!A && (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b == !C)'\'''

echo '$ test-expr '\''!A && (b != !C)'\'''
test-expr '!A && (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b != !C)'\'''

echo '$ test-expr '\''!A && (b && !C)'\'''
test-expr '!A && (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b && !C)'\'''

echo '$ test-expr '\''!A && (b || !C)'\'''
test-expr '!A && (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (b || !C)'\'''

echo '$ test-expr '\''!A || (b <= !C)'\'''
test-expr '!A || (b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b <= !C)'\'''

echo '$ test-expr '\''!A || (b >= !C)'\'''
test-expr '!A || (b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b >= !C)'\'''

echo '$ test-expr '\''!A || (b == !C)'\'''
test-expr '!A || (b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b == !C)'\'''

echo '$ test-expr '\''!A || (b != !C)'\'''
test-expr '!A || (b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b != !C)'\'''

echo '$ test-expr '\''!A || (b && !C)'\'''
test-expr '!A || (b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b && !C)'\'''

echo '$ test-expr '\''!A || (b || !C)'\'''
test-expr '!A || (b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (b || !C)'\'''

echo '$ test-expr '\''!A <= (B <= c)'\'''
test-expr '!A <= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B <= c)'\'''

echo '$ test-expr '\''!A <= (B >= c)'\'''
test-expr '!A <= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B >= c)'\'''

echo '$ test-expr '\''!A <= (B == c)'\'''
test-expr '!A <= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B == c)'\'''

echo '$ test-expr '\''!A <= (B != c)'\'''
test-expr '!A <= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B != c)'\'''

echo '$ test-expr '\''!A <= (B && c)'\'''
test-expr '!A <= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B && c)'\'''

echo '$ test-expr '\''!A <= (B || c)'\'''
test-expr '!A <= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B || c)'\'''

echo '$ test-expr '\''!A >= (B <= c)'\'''
test-expr '!A >= (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B <= c)'\'''

echo '$ test-expr '\''!A >= (B >= c)'\'''
test-expr '!A >= (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B >= c)'\'''

echo '$ test-expr '\''!A >= (B == c)'\'''
test-expr '!A >= (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B == c)'\'''

echo '$ test-expr '\''!A >= (B != c)'\'''
test-expr '!A >= (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B != c)'\'''

echo '$ test-expr '\''!A >= (B && c)'\'''
test-expr '!A >= (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B && c)'\'''

echo '$ test-expr '\''!A >= (B || c)'\'''
test-expr '!A >= (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B || c)'\'''

echo '$ test-expr '\''!A == (B <= c)'\'''
test-expr '!A == (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B <= c)'\'''

echo '$ test-expr '\''!A == (B >= c)'\'''
test-expr '!A == (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B >= c)'\'''

echo '$ test-expr '\''!A == (B == c)'\'''
test-expr '!A == (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B == c)'\'''

echo '$ test-expr '\''!A == (B != c)'\'''
test-expr '!A == (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B != c)'\'''

echo '$ test-expr '\''!A == (B && c)'\'''
test-expr '!A == (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B && c)'\'''

echo '$ test-expr '\''!A == (B || c)'\'''
test-expr '!A == (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B || c)'\'''

echo '$ test-expr '\''!A != (B <= c)'\'''
test-expr '!A != (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B <= c)'\'''

echo '$ test-expr '\''!A != (B >= c)'\'''
test-expr '!A != (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B >= c)'\'''

echo '$ test-expr '\''!A != (B == c)'\'''
test-expr '!A != (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B == c)'\'''

echo '$ test-expr '\''!A != (B != c)'\'''
test-expr '!A != (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B != c)'\'''

echo '$ test-expr '\''!A != (B && c)'\'''
test-expr '!A != (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B && c)'\'''

echo '$ test-expr '\''!A != (B || c)'\'''
test-expr '!A != (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B || c)'\'''

echo '$ test-expr '\''!A && (B <= c)'\'''
test-expr '!A && (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B <= c)'\'''

echo '$ test-expr '\''!A && (B >= c)'\'''
test-expr '!A && (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B >= c)'\'''

echo '$ test-expr '\''!A && (B == c)'\'''
test-expr '!A && (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B == c)'\'''

echo '$ test-expr '\''!A && (B != c)'\'''
test-expr '!A && (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B != c)'\'''

echo '$ test-expr '\''!A && (B && c)'\'''
test-expr '!A && (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B && c)'\'''

echo '$ test-expr '\''!A && (B || c)'\'''
test-expr '!A && (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B || c)'\'''

echo '$ test-expr '\''!A || (B <= c)'\'''
test-expr '!A || (B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B <= c)'\'''

echo '$ test-expr '\''!A || (B >= c)'\'''
test-expr '!A || (B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B >= c)'\'''

echo '$ test-expr '\''!A || (B == c)'\'''
test-expr '!A || (B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B == c)'\'''

echo '$ test-expr '\''!A || (B != c)'\'''
test-expr '!A || (B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B != c)'\'''

echo '$ test-expr '\''!A || (B && c)'\'''
test-expr '!A || (B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B && c)'\'''

echo '$ test-expr '\''!A || (B || c)'\'''
test-expr '!A || (B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B || c)'\'''

echo '$ test-expr '\''!A <= (B <= C)'\'''
test-expr '!A <= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B <= C)'\'''

echo '$ test-expr '\''!A <= (B >= C)'\'''
test-expr '!A <= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B >= C)'\'''

echo '$ test-expr '\''!A <= (B == C)'\'''
test-expr '!A <= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B == C)'\'''

echo '$ test-expr '\''!A <= (B != C)'\'''
test-expr '!A <= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B != C)'\'''

echo '$ test-expr '\''!A <= (B && C)'\'''
test-expr '!A <= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B && C)'\'''

echo '$ test-expr '\''!A <= (B || C)'\'''
test-expr '!A <= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B || C)'\'''

echo '$ test-expr '\''!A >= (B <= C)'\'''
test-expr '!A >= (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B <= C)'\'''

echo '$ test-expr '\''!A >= (B >= C)'\'''
test-expr '!A >= (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B >= C)'\'''

echo '$ test-expr '\''!A >= (B == C)'\'''
test-expr '!A >= (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B == C)'\'''

echo '$ test-expr '\''!A >= (B != C)'\'''
test-expr '!A >= (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B != C)'\'''

echo '$ test-expr '\''!A >= (B && C)'\'''
test-expr '!A >= (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B && C)'\'''

echo '$ test-expr '\''!A >= (B || C)'\'''
test-expr '!A >= (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B || C)'\'''

echo '$ test-expr '\''!A == (B <= C)'\'''
test-expr '!A == (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B <= C)'\'''

echo '$ test-expr '\''!A == (B >= C)'\'''
test-expr '!A == (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B >= C)'\'''

echo '$ test-expr '\''!A == (B == C)'\'''
test-expr '!A == (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B == C)'\'''

echo '$ test-expr '\''!A == (B != C)'\'''
test-expr '!A == (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B != C)'\'''

echo '$ test-expr '\''!A == (B && C)'\'''
test-expr '!A == (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B && C)'\'''

echo '$ test-expr '\''!A == (B || C)'\'''
test-expr '!A == (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B || C)'\'''

echo '$ test-expr '\''!A != (B <= C)'\'''
test-expr '!A != (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B <= C)'\'''

echo '$ test-expr '\''!A != (B >= C)'\'''
test-expr '!A != (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B >= C)'\'''

echo '$ test-expr '\''!A != (B == C)'\'''
test-expr '!A != (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B == C)'\'''

echo '$ test-expr '\''!A != (B != C)'\'''
test-expr '!A != (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B != C)'\'''

echo '$ test-expr '\''!A != (B && C)'\'''
test-expr '!A != (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B && C)'\'''

echo '$ test-expr '\''!A != (B || C)'\'''
test-expr '!A != (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B || C)'\'''

echo '$ test-expr '\''!A && (B <= C)'\'''
test-expr '!A && (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B <= C)'\'''

echo '$ test-expr '\''!A && (B >= C)'\'''
test-expr '!A && (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B >= C)'\'''

echo '$ test-expr '\''!A && (B == C)'\'''
test-expr '!A && (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B == C)'\'''

echo '$ test-expr '\''!A && (B != C)'\'''
test-expr '!A && (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B != C)'\'''

echo '$ test-expr '\''!A && (B && C)'\'''
test-expr '!A && (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B && C)'\'''

echo '$ test-expr '\''!A && (B || C)'\'''
test-expr '!A && (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B || C)'\'''

echo '$ test-expr '\''!A || (B <= C)'\'''
test-expr '!A || (B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B <= C)'\'''

echo '$ test-expr '\''!A || (B >= C)'\'''
test-expr '!A || (B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B >= C)'\'''

echo '$ test-expr '\''!A || (B == C)'\'''
test-expr '!A || (B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B == C)'\'''

echo '$ test-expr '\''!A || (B != C)'\'''
test-expr '!A || (B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B != C)'\'''

echo '$ test-expr '\''!A || (B && C)'\'''
test-expr '!A || (B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B && C)'\'''

echo '$ test-expr '\''!A || (B || C)'\'''
test-expr '!A || (B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B || C)'\'''

echo '$ test-expr '\''!A <= (B <= !c)'\'''
test-expr '!A <= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B <= !c)'\'''

echo '$ test-expr '\''!A <= (B >= !c)'\'''
test-expr '!A <= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B >= !c)'\'''

echo '$ test-expr '\''!A <= (B == !c)'\'''
test-expr '!A <= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B == !c)'\'''

echo '$ test-expr '\''!A <= (B != !c)'\'''
test-expr '!A <= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B != !c)'\'''

echo '$ test-expr '\''!A <= (B && !c)'\'''
test-expr '!A <= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B && !c)'\'''

echo '$ test-expr '\''!A <= (B || !c)'\'''
test-expr '!A <= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B || !c)'\'''

echo '$ test-expr '\''!A >= (B <= !c)'\'''
test-expr '!A >= (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B <= !c)'\'''

echo '$ test-expr '\''!A >= (B >= !c)'\'''
test-expr '!A >= (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B >= !c)'\'''

echo '$ test-expr '\''!A >= (B == !c)'\'''
test-expr '!A >= (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B == !c)'\'''

echo '$ test-expr '\''!A >= (B != !c)'\'''
test-expr '!A >= (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B != !c)'\'''

echo '$ test-expr '\''!A >= (B && !c)'\'''
test-expr '!A >= (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B && !c)'\'''

echo '$ test-expr '\''!A >= (B || !c)'\'''
test-expr '!A >= (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B || !c)'\'''

echo '$ test-expr '\''!A == (B <= !c)'\'''
test-expr '!A == (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B <= !c)'\'''

echo '$ test-expr '\''!A == (B >= !c)'\'''
test-expr '!A == (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B >= !c)'\'''

echo '$ test-expr '\''!A == (B == !c)'\'''
test-expr '!A == (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B == !c)'\'''

echo '$ test-expr '\''!A == (B != !c)'\'''
test-expr '!A == (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B != !c)'\'''

echo '$ test-expr '\''!A == (B && !c)'\'''
test-expr '!A == (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B && !c)'\'''

echo '$ test-expr '\''!A == (B || !c)'\'''
test-expr '!A == (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B || !c)'\'''

echo '$ test-expr '\''!A != (B <= !c)'\'''
test-expr '!A != (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B <= !c)'\'''

echo '$ test-expr '\''!A != (B >= !c)'\'''
test-expr '!A != (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B >= !c)'\'''

echo '$ test-expr '\''!A != (B == !c)'\'''
test-expr '!A != (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B == !c)'\'''

echo '$ test-expr '\''!A != (B != !c)'\'''
test-expr '!A != (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B != !c)'\'''

echo '$ test-expr '\''!A != (B && !c)'\'''
test-expr '!A != (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B && !c)'\'''

echo '$ test-expr '\''!A != (B || !c)'\'''
test-expr '!A != (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B || !c)'\'''

echo '$ test-expr '\''!A && (B <= !c)'\'''
test-expr '!A && (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B <= !c)'\'''

echo '$ test-expr '\''!A && (B >= !c)'\'''
test-expr '!A && (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B >= !c)'\'''

echo '$ test-expr '\''!A && (B == !c)'\'''
test-expr '!A && (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B == !c)'\'''

echo '$ test-expr '\''!A && (B != !c)'\'''
test-expr '!A && (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B != !c)'\'''

echo '$ test-expr '\''!A && (B && !c)'\'''
test-expr '!A && (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B && !c)'\'''

echo '$ test-expr '\''!A && (B || !c)'\'''
test-expr '!A && (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B || !c)'\'''

echo '$ test-expr '\''!A || (B <= !c)'\'''
test-expr '!A || (B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B <= !c)'\'''

echo '$ test-expr '\''!A || (B >= !c)'\'''
test-expr '!A || (B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B >= !c)'\'''

echo '$ test-expr '\''!A || (B == !c)'\'''
test-expr '!A || (B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B == !c)'\'''

echo '$ test-expr '\''!A || (B != !c)'\'''
test-expr '!A || (B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B != !c)'\'''

echo '$ test-expr '\''!A || (B && !c)'\'''
test-expr '!A || (B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B && !c)'\'''

echo '$ test-expr '\''!A || (B || !c)'\'''
test-expr '!A || (B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B || !c)'\'''

echo '$ test-expr '\''!A <= (B <= !C)'\'''
test-expr '!A <= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B <= !C)'\'''

echo '$ test-expr '\''!A <= (B >= !C)'\'''
test-expr '!A <= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B >= !C)'\'''

echo '$ test-expr '\''!A <= (B == !C)'\'''
test-expr '!A <= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B == !C)'\'''

echo '$ test-expr '\''!A <= (B != !C)'\'''
test-expr '!A <= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B != !C)'\'''

echo '$ test-expr '\''!A <= (B && !C)'\'''
test-expr '!A <= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B && !C)'\'''

echo '$ test-expr '\''!A <= (B || !C)'\'''
test-expr '!A <= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (B || !C)'\'''

echo '$ test-expr '\''!A >= (B <= !C)'\'''
test-expr '!A >= (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B <= !C)'\'''

echo '$ test-expr '\''!A >= (B >= !C)'\'''
test-expr '!A >= (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B >= !C)'\'''

echo '$ test-expr '\''!A >= (B == !C)'\'''
test-expr '!A >= (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B == !C)'\'''

echo '$ test-expr '\''!A >= (B != !C)'\'''
test-expr '!A >= (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B != !C)'\'''

echo '$ test-expr '\''!A >= (B && !C)'\'''
test-expr '!A >= (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B && !C)'\'''

echo '$ test-expr '\''!A >= (B || !C)'\'''
test-expr '!A >= (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (B || !C)'\'''

echo '$ test-expr '\''!A == (B <= !C)'\'''
test-expr '!A == (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B <= !C)'\'''

echo '$ test-expr '\''!A == (B >= !C)'\'''
test-expr '!A == (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B >= !C)'\'''

echo '$ test-expr '\''!A == (B == !C)'\'''
test-expr '!A == (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B == !C)'\'''

echo '$ test-expr '\''!A == (B != !C)'\'''
test-expr '!A == (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B != !C)'\'''

echo '$ test-expr '\''!A == (B && !C)'\'''
test-expr '!A == (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B && !C)'\'''

echo '$ test-expr '\''!A == (B || !C)'\'''
test-expr '!A == (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (B || !C)'\'''

echo '$ test-expr '\''!A != (B <= !C)'\'''
test-expr '!A != (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B <= !C)'\'''

echo '$ test-expr '\''!A != (B >= !C)'\'''
test-expr '!A != (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B >= !C)'\'''

echo '$ test-expr '\''!A != (B == !C)'\'''
test-expr '!A != (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B == !C)'\'''

echo '$ test-expr '\''!A != (B != !C)'\'''
test-expr '!A != (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B != !C)'\'''

echo '$ test-expr '\''!A != (B && !C)'\'''
test-expr '!A != (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B && !C)'\'''

echo '$ test-expr '\''!A != (B || !C)'\'''
test-expr '!A != (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (B || !C)'\'''

echo '$ test-expr '\''!A && (B <= !C)'\'''
test-expr '!A && (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B <= !C)'\'''

echo '$ test-expr '\''!A && (B >= !C)'\'''
test-expr '!A && (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B >= !C)'\'''

echo '$ test-expr '\''!A && (B == !C)'\'''
test-expr '!A && (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B == !C)'\'''

echo '$ test-expr '\''!A && (B != !C)'\'''
test-expr '!A && (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B != !C)'\'''

echo '$ test-expr '\''!A && (B && !C)'\'''
test-expr '!A && (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B && !C)'\'''

echo '$ test-expr '\''!A && (B || !C)'\'''
test-expr '!A && (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (B || !C)'\'''

echo '$ test-expr '\''!A || (B <= !C)'\'''
test-expr '!A || (B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B <= !C)'\'''

echo '$ test-expr '\''!A || (B >= !C)'\'''
test-expr '!A || (B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B >= !C)'\'''

echo '$ test-expr '\''!A || (B == !C)'\'''
test-expr '!A || (B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B == !C)'\'''

echo '$ test-expr '\''!A || (B != !C)'\'''
test-expr '!A || (B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B != !C)'\'''

echo '$ test-expr '\''!A || (B && !C)'\'''
test-expr '!A || (B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B && !C)'\'''

echo '$ test-expr '\''!A || (B || !C)'\'''
test-expr '!A || (B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (B || !C)'\'''

echo '$ test-expr '\''!A <= (!b <= c)'\'''
test-expr '!A <= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b <= c)'\'''

echo '$ test-expr '\''!A <= (!b >= c)'\'''
test-expr '!A <= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b >= c)'\'''

echo '$ test-expr '\''!A <= (!b == c)'\'''
test-expr '!A <= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b == c)'\'''

echo '$ test-expr '\''!A <= (!b != c)'\'''
test-expr '!A <= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b != c)'\'''

echo '$ test-expr '\''!A <= (!b && c)'\'''
test-expr '!A <= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b && c)'\'''

echo '$ test-expr '\''!A <= (!b || c)'\'''
test-expr '!A <= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b || c)'\'''

echo '$ test-expr '\''!A >= (!b <= c)'\'''
test-expr '!A >= (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b <= c)'\'''

echo '$ test-expr '\''!A >= (!b >= c)'\'''
test-expr '!A >= (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b >= c)'\'''

echo '$ test-expr '\''!A >= (!b == c)'\'''
test-expr '!A >= (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b == c)'\'''

echo '$ test-expr '\''!A >= (!b != c)'\'''
test-expr '!A >= (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b != c)'\'''

echo '$ test-expr '\''!A >= (!b && c)'\'''
test-expr '!A >= (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b && c)'\'''

echo '$ test-expr '\''!A >= (!b || c)'\'''
test-expr '!A >= (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b || c)'\'''

echo '$ test-expr '\''!A == (!b <= c)'\'''
test-expr '!A == (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b <= c)'\'''

echo '$ test-expr '\''!A == (!b >= c)'\'''
test-expr '!A == (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b >= c)'\'''

echo '$ test-expr '\''!A == (!b == c)'\'''
test-expr '!A == (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b == c)'\'''

echo '$ test-expr '\''!A == (!b != c)'\'''
test-expr '!A == (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b != c)'\'''

echo '$ test-expr '\''!A == (!b && c)'\'''
test-expr '!A == (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b && c)'\'''

echo '$ test-expr '\''!A == (!b || c)'\'''
test-expr '!A == (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b || c)'\'''

echo '$ test-expr '\''!A != (!b <= c)'\'''
test-expr '!A != (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b <= c)'\'''

echo '$ test-expr '\''!A != (!b >= c)'\'''
test-expr '!A != (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b >= c)'\'''

echo '$ test-expr '\''!A != (!b == c)'\'''
test-expr '!A != (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b == c)'\'''

echo '$ test-expr '\''!A != (!b != c)'\'''
test-expr '!A != (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b != c)'\'''

echo '$ test-expr '\''!A != (!b && c)'\'''
test-expr '!A != (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b && c)'\'''

echo '$ test-expr '\''!A != (!b || c)'\'''
test-expr '!A != (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b || c)'\'''

echo '$ test-expr '\''!A && (!b <= c)'\'''
test-expr '!A && (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b <= c)'\'''

echo '$ test-expr '\''!A && (!b >= c)'\'''
test-expr '!A && (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b >= c)'\'''

echo '$ test-expr '\''!A && (!b == c)'\'''
test-expr '!A && (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b == c)'\'''

echo '$ test-expr '\''!A && (!b != c)'\'''
test-expr '!A && (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b != c)'\'''

echo '$ test-expr '\''!A && (!b && c)'\'''
test-expr '!A && (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b && c)'\'''

echo '$ test-expr '\''!A && (!b || c)'\'''
test-expr '!A && (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b || c)'\'''

echo '$ test-expr '\''!A || (!b <= c)'\'''
test-expr '!A || (!b <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b <= c)'\'''

echo '$ test-expr '\''!A || (!b >= c)'\'''
test-expr '!A || (!b >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b >= c)'\'''

echo '$ test-expr '\''!A || (!b == c)'\'''
test-expr '!A || (!b == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b == c)'\'''

echo '$ test-expr '\''!A || (!b != c)'\'''
test-expr '!A || (!b != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b != c)'\'''

echo '$ test-expr '\''!A || (!b && c)'\'''
test-expr '!A || (!b && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b && c)'\'''

echo '$ test-expr '\''!A || (!b || c)'\'''
test-expr '!A || (!b || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b || c)'\'''

echo '$ test-expr '\''!A <= (!b <= C)'\'''
test-expr '!A <= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b <= C)'\'''

echo '$ test-expr '\''!A <= (!b >= C)'\'''
test-expr '!A <= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b >= C)'\'''

echo '$ test-expr '\''!A <= (!b == C)'\'''
test-expr '!A <= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b == C)'\'''

echo '$ test-expr '\''!A <= (!b != C)'\'''
test-expr '!A <= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b != C)'\'''

echo '$ test-expr '\''!A <= (!b && C)'\'''
test-expr '!A <= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b && C)'\'''

echo '$ test-expr '\''!A <= (!b || C)'\'''
test-expr '!A <= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b || C)'\'''

echo '$ test-expr '\''!A >= (!b <= C)'\'''
test-expr '!A >= (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b <= C)'\'''

echo '$ test-expr '\''!A >= (!b >= C)'\'''
test-expr '!A >= (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b >= C)'\'''

echo '$ test-expr '\''!A >= (!b == C)'\'''
test-expr '!A >= (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b == C)'\'''

echo '$ test-expr '\''!A >= (!b != C)'\'''
test-expr '!A >= (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b != C)'\'''

echo '$ test-expr '\''!A >= (!b && C)'\'''
test-expr '!A >= (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b && C)'\'''

echo '$ test-expr '\''!A >= (!b || C)'\'''
test-expr '!A >= (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b || C)'\'''

echo '$ test-expr '\''!A == (!b <= C)'\'''
test-expr '!A == (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b <= C)'\'''

echo '$ test-expr '\''!A == (!b >= C)'\'''
test-expr '!A == (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b >= C)'\'''

echo '$ test-expr '\''!A == (!b == C)'\'''
test-expr '!A == (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b == C)'\'''

echo '$ test-expr '\''!A == (!b != C)'\'''
test-expr '!A == (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b != C)'\'''

echo '$ test-expr '\''!A == (!b && C)'\'''
test-expr '!A == (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b && C)'\'''

echo '$ test-expr '\''!A == (!b || C)'\'''
test-expr '!A == (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b || C)'\'''

echo '$ test-expr '\''!A != (!b <= C)'\'''
test-expr '!A != (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b <= C)'\'''

echo '$ test-expr '\''!A != (!b >= C)'\'''
test-expr '!A != (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b >= C)'\'''

echo '$ test-expr '\''!A != (!b == C)'\'''
test-expr '!A != (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b == C)'\'''

echo '$ test-expr '\''!A != (!b != C)'\'''
test-expr '!A != (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b != C)'\'''

echo '$ test-expr '\''!A != (!b && C)'\'''
test-expr '!A != (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b && C)'\'''

echo '$ test-expr '\''!A != (!b || C)'\'''
test-expr '!A != (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b || C)'\'''

echo '$ test-expr '\''!A && (!b <= C)'\'''
test-expr '!A && (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b <= C)'\'''

echo '$ test-expr '\''!A && (!b >= C)'\'''
test-expr '!A && (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b >= C)'\'''

echo '$ test-expr '\''!A && (!b == C)'\'''
test-expr '!A && (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b == C)'\'''

echo '$ test-expr '\''!A && (!b != C)'\'''
test-expr '!A && (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b != C)'\'''

echo '$ test-expr '\''!A && (!b && C)'\'''
test-expr '!A && (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b && C)'\'''

echo '$ test-expr '\''!A && (!b || C)'\'''
test-expr '!A && (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b || C)'\'''

echo '$ test-expr '\''!A || (!b <= C)'\'''
test-expr '!A || (!b <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b <= C)'\'''

echo '$ test-expr '\''!A || (!b >= C)'\'''
test-expr '!A || (!b >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b >= C)'\'''

echo '$ test-expr '\''!A || (!b == C)'\'''
test-expr '!A || (!b == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b == C)'\'''

echo '$ test-expr '\''!A || (!b != C)'\'''
test-expr '!A || (!b != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b != C)'\'''

echo '$ test-expr '\''!A || (!b && C)'\'''
test-expr '!A || (!b && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b && C)'\'''

echo '$ test-expr '\''!A || (!b || C)'\'''
test-expr '!A || (!b || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b || C)'\'''

echo '$ test-expr '\''!A <= (!b <= !c)'\'''
test-expr '!A <= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b <= !c)'\'''

echo '$ test-expr '\''!A <= (!b >= !c)'\'''
test-expr '!A <= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b >= !c)'\'''

echo '$ test-expr '\''!A <= (!b == !c)'\'''
test-expr '!A <= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b == !c)'\'''

echo '$ test-expr '\''!A <= (!b != !c)'\'''
test-expr '!A <= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b != !c)'\'''

echo '$ test-expr '\''!A <= (!b && !c)'\'''
test-expr '!A <= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b && !c)'\'''

echo '$ test-expr '\''!A <= (!b || !c)'\'''
test-expr '!A <= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b || !c)'\'''

echo '$ test-expr '\''!A >= (!b <= !c)'\'''
test-expr '!A >= (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b <= !c)'\'''

echo '$ test-expr '\''!A >= (!b >= !c)'\'''
test-expr '!A >= (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b >= !c)'\'''

echo '$ test-expr '\''!A >= (!b == !c)'\'''
test-expr '!A >= (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b == !c)'\'''

echo '$ test-expr '\''!A >= (!b != !c)'\'''
test-expr '!A >= (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b != !c)'\'''

echo '$ test-expr '\''!A >= (!b && !c)'\'''
test-expr '!A >= (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b && !c)'\'''

echo '$ test-expr '\''!A >= (!b || !c)'\'''
test-expr '!A >= (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b || !c)'\'''

echo '$ test-expr '\''!A == (!b <= !c)'\'''
test-expr '!A == (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b <= !c)'\'''

echo '$ test-expr '\''!A == (!b >= !c)'\'''
test-expr '!A == (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b >= !c)'\'''

echo '$ test-expr '\''!A == (!b == !c)'\'''
test-expr '!A == (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b == !c)'\'''

echo '$ test-expr '\''!A == (!b != !c)'\'''
test-expr '!A == (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b != !c)'\'''

echo '$ test-expr '\''!A == (!b && !c)'\'''
test-expr '!A == (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b && !c)'\'''

echo '$ test-expr '\''!A == (!b || !c)'\'''
test-expr '!A == (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b || !c)'\'''

echo '$ test-expr '\''!A != (!b <= !c)'\'''
test-expr '!A != (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b <= !c)'\'''

echo '$ test-expr '\''!A != (!b >= !c)'\'''
test-expr '!A != (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b >= !c)'\'''

echo '$ test-expr '\''!A != (!b == !c)'\'''
test-expr '!A != (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b == !c)'\'''

echo '$ test-expr '\''!A != (!b != !c)'\'''
test-expr '!A != (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b != !c)'\'''

echo '$ test-expr '\''!A != (!b && !c)'\'''
test-expr '!A != (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b && !c)'\'''

echo '$ test-expr '\''!A != (!b || !c)'\'''
test-expr '!A != (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b || !c)'\'''

echo '$ test-expr '\''!A && (!b <= !c)'\'''
test-expr '!A && (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b <= !c)'\'''

echo '$ test-expr '\''!A && (!b >= !c)'\'''
test-expr '!A && (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b >= !c)'\'''

echo '$ test-expr '\''!A && (!b == !c)'\'''
test-expr '!A && (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b == !c)'\'''

echo '$ test-expr '\''!A && (!b != !c)'\'''
test-expr '!A && (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b != !c)'\'''

echo '$ test-expr '\''!A && (!b && !c)'\'''
test-expr '!A && (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b && !c)'\'''

echo '$ test-expr '\''!A && (!b || !c)'\'''
test-expr '!A && (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b || !c)'\'''

echo '$ test-expr '\''!A || (!b <= !c)'\'''
test-expr '!A || (!b <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b <= !c)'\'''

echo '$ test-expr '\''!A || (!b >= !c)'\'''
test-expr '!A || (!b >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b >= !c)'\'''

echo '$ test-expr '\''!A || (!b == !c)'\'''
test-expr '!A || (!b == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b == !c)'\'''

echo '$ test-expr '\''!A || (!b != !c)'\'''
test-expr '!A || (!b != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b != !c)'\'''

echo '$ test-expr '\''!A || (!b && !c)'\'''
test-expr '!A || (!b && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b && !c)'\'''

echo '$ test-expr '\''!A || (!b || !c)'\'''
test-expr '!A || (!b || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b || !c)'\'''

echo '$ test-expr '\''!A <= (!b <= !C)'\'''
test-expr '!A <= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b <= !C)'\'''

echo '$ test-expr '\''!A <= (!b >= !C)'\'''
test-expr '!A <= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b >= !C)'\'''

echo '$ test-expr '\''!A <= (!b == !C)'\'''
test-expr '!A <= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b == !C)'\'''

echo '$ test-expr '\''!A <= (!b != !C)'\'''
test-expr '!A <= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b != !C)'\'''

echo '$ test-expr '\''!A <= (!b && !C)'\'''
test-expr '!A <= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b && !C)'\'''

echo '$ test-expr '\''!A <= (!b || !C)'\'''
test-expr '!A <= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!b || !C)'\'''

echo '$ test-expr '\''!A >= (!b <= !C)'\'''
test-expr '!A >= (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b <= !C)'\'''

echo '$ test-expr '\''!A >= (!b >= !C)'\'''
test-expr '!A >= (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b >= !C)'\'''

echo '$ test-expr '\''!A >= (!b == !C)'\'''
test-expr '!A >= (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b == !C)'\'''

echo '$ test-expr '\''!A >= (!b != !C)'\'''
test-expr '!A >= (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b != !C)'\'''

echo '$ test-expr '\''!A >= (!b && !C)'\'''
test-expr '!A >= (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b && !C)'\'''

echo '$ test-expr '\''!A >= (!b || !C)'\'''
test-expr '!A >= (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!b || !C)'\'''

echo '$ test-expr '\''!A == (!b <= !C)'\'''
test-expr '!A == (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b <= !C)'\'''

echo '$ test-expr '\''!A == (!b >= !C)'\'''
test-expr '!A == (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b >= !C)'\'''

echo '$ test-expr '\''!A == (!b == !C)'\'''
test-expr '!A == (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b == !C)'\'''

echo '$ test-expr '\''!A == (!b != !C)'\'''
test-expr '!A == (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b != !C)'\'''

echo '$ test-expr '\''!A == (!b && !C)'\'''
test-expr '!A == (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b && !C)'\'''

echo '$ test-expr '\''!A == (!b || !C)'\'''
test-expr '!A == (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!b || !C)'\'''

echo '$ test-expr '\''!A != (!b <= !C)'\'''
test-expr '!A != (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b <= !C)'\'''

echo '$ test-expr '\''!A != (!b >= !C)'\'''
test-expr '!A != (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b >= !C)'\'''

echo '$ test-expr '\''!A != (!b == !C)'\'''
test-expr '!A != (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b == !C)'\'''

echo '$ test-expr '\''!A != (!b != !C)'\'''
test-expr '!A != (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b != !C)'\'''

echo '$ test-expr '\''!A != (!b && !C)'\'''
test-expr '!A != (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b && !C)'\'''

echo '$ test-expr '\''!A != (!b || !C)'\'''
test-expr '!A != (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!b || !C)'\'''

echo '$ test-expr '\''!A && (!b <= !C)'\'''
test-expr '!A && (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b <= !C)'\'''

echo '$ test-expr '\''!A && (!b >= !C)'\'''
test-expr '!A && (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b >= !C)'\'''

echo '$ test-expr '\''!A && (!b == !C)'\'''
test-expr '!A && (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b == !C)'\'''

echo '$ test-expr '\''!A && (!b != !C)'\'''
test-expr '!A && (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b != !C)'\'''

echo '$ test-expr '\''!A && (!b && !C)'\'''
test-expr '!A && (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b && !C)'\'''

echo '$ test-expr '\''!A && (!b || !C)'\'''
test-expr '!A && (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!b || !C)'\'''

echo '$ test-expr '\''!A || (!b <= !C)'\'''
test-expr '!A || (!b <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b <= !C)'\'''

echo '$ test-expr '\''!A || (!b >= !C)'\'''
test-expr '!A || (!b >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b >= !C)'\'''

echo '$ test-expr '\''!A || (!b == !C)'\'''
test-expr '!A || (!b == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b == !C)'\'''

echo '$ test-expr '\''!A || (!b != !C)'\'''
test-expr '!A || (!b != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b != !C)'\'''

echo '$ test-expr '\''!A || (!b && !C)'\'''
test-expr '!A || (!b && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b && !C)'\'''

echo '$ test-expr '\''!A || (!b || !C)'\'''
test-expr '!A || (!b || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!b || !C)'\'''

echo '$ test-expr '\''!A <= (!B <= c)'\'''
test-expr '!A <= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B <= c)'\'''

echo '$ test-expr '\''!A <= (!B >= c)'\'''
test-expr '!A <= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B >= c)'\'''

echo '$ test-expr '\''!A <= (!B == c)'\'''
test-expr '!A <= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B == c)'\'''

echo '$ test-expr '\''!A <= (!B != c)'\'''
test-expr '!A <= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B != c)'\'''

echo '$ test-expr '\''!A <= (!B && c)'\'''
test-expr '!A <= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B && c)'\'''

echo '$ test-expr '\''!A <= (!B || c)'\'''
test-expr '!A <= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B || c)'\'''

echo '$ test-expr '\''!A >= (!B <= c)'\'''
test-expr '!A >= (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B <= c)'\'''

echo '$ test-expr '\''!A >= (!B >= c)'\'''
test-expr '!A >= (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B >= c)'\'''

echo '$ test-expr '\''!A >= (!B == c)'\'''
test-expr '!A >= (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B == c)'\'''

echo '$ test-expr '\''!A >= (!B != c)'\'''
test-expr '!A >= (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B != c)'\'''

echo '$ test-expr '\''!A >= (!B && c)'\'''
test-expr '!A >= (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B && c)'\'''

echo '$ test-expr '\''!A >= (!B || c)'\'''
test-expr '!A >= (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B || c)'\'''

echo '$ test-expr '\''!A == (!B <= c)'\'''
test-expr '!A == (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B <= c)'\'''

echo '$ test-expr '\''!A == (!B >= c)'\'''
test-expr '!A == (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B >= c)'\'''

echo '$ test-expr '\''!A == (!B == c)'\'''
test-expr '!A == (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B == c)'\'''

echo '$ test-expr '\''!A == (!B != c)'\'''
test-expr '!A == (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B != c)'\'''

echo '$ test-expr '\''!A == (!B && c)'\'''
test-expr '!A == (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B && c)'\'''

echo '$ test-expr '\''!A == (!B || c)'\'''
test-expr '!A == (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B || c)'\'''

echo '$ test-expr '\''!A != (!B <= c)'\'''
test-expr '!A != (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B <= c)'\'''

echo '$ test-expr '\''!A != (!B >= c)'\'''
test-expr '!A != (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B >= c)'\'''

echo '$ test-expr '\''!A != (!B == c)'\'''
test-expr '!A != (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B == c)'\'''

echo '$ test-expr '\''!A != (!B != c)'\'''
test-expr '!A != (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B != c)'\'''

echo '$ test-expr '\''!A != (!B && c)'\'''
test-expr '!A != (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B && c)'\'''

echo '$ test-expr '\''!A != (!B || c)'\'''
test-expr '!A != (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B || c)'\'''

echo '$ test-expr '\''!A && (!B <= c)'\'''
test-expr '!A && (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B <= c)'\'''

echo '$ test-expr '\''!A && (!B >= c)'\'''
test-expr '!A && (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B >= c)'\'''

echo '$ test-expr '\''!A && (!B == c)'\'''
test-expr '!A && (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B == c)'\'''

echo '$ test-expr '\''!A && (!B != c)'\'''
test-expr '!A && (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B != c)'\'''

echo '$ test-expr '\''!A && (!B && c)'\'''
test-expr '!A && (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B && c)'\'''

echo '$ test-expr '\''!A && (!B || c)'\'''
test-expr '!A && (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B || c)'\'''

echo '$ test-expr '\''!A || (!B <= c)'\'''
test-expr '!A || (!B <= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B <= c)'\'''

echo '$ test-expr '\''!A || (!B >= c)'\'''
test-expr '!A || (!B >= c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B >= c)'\'''

echo '$ test-expr '\''!A || (!B == c)'\'''
test-expr '!A || (!B == c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B == c)'\'''

echo '$ test-expr '\''!A || (!B != c)'\'''
test-expr '!A || (!B != c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B != c)'\'''

echo '$ test-expr '\''!A || (!B && c)'\'''
test-expr '!A || (!B && c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B && c)'\'''

echo '$ test-expr '\''!A || (!B || c)'\'''
test-expr '!A || (!B || c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B || c)'\'''

echo '$ test-expr '\''!A <= (!B <= C)'\'''
test-expr '!A <= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B <= C)'\'''

echo '$ test-expr '\''!A <= (!B >= C)'\'''
test-expr '!A <= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B >= C)'\'''

echo '$ test-expr '\''!A <= (!B == C)'\'''
test-expr '!A <= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B == C)'\'''

echo '$ test-expr '\''!A <= (!B != C)'\'''
test-expr '!A <= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B != C)'\'''

echo '$ test-expr '\''!A <= (!B && C)'\'''
test-expr '!A <= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B && C)'\'''

echo '$ test-expr '\''!A <= (!B || C)'\'''
test-expr '!A <= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B || C)'\'''

echo '$ test-expr '\''!A >= (!B <= C)'\'''
test-expr '!A >= (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B <= C)'\'''

echo '$ test-expr '\''!A >= (!B >= C)'\'''
test-expr '!A >= (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B >= C)'\'''

echo '$ test-expr '\''!A >= (!B == C)'\'''
test-expr '!A >= (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B == C)'\'''

echo '$ test-expr '\''!A >= (!B != C)'\'''
test-expr '!A >= (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B != C)'\'''

echo '$ test-expr '\''!A >= (!B && C)'\'''
test-expr '!A >= (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B && C)'\'''

echo '$ test-expr '\''!A >= (!B || C)'\'''
test-expr '!A >= (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B || C)'\'''

echo '$ test-expr '\''!A == (!B <= C)'\'''
test-expr '!A == (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B <= C)'\'''

echo '$ test-expr '\''!A == (!B >= C)'\'''
test-expr '!A == (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B >= C)'\'''

echo '$ test-expr '\''!A == (!B == C)'\'''
test-expr '!A == (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B == C)'\'''

echo '$ test-expr '\''!A == (!B != C)'\'''
test-expr '!A == (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B != C)'\'''

echo '$ test-expr '\''!A == (!B && C)'\'''
test-expr '!A == (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B && C)'\'''

echo '$ test-expr '\''!A == (!B || C)'\'''
test-expr '!A == (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B || C)'\'''

echo '$ test-expr '\''!A != (!B <= C)'\'''
test-expr '!A != (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B <= C)'\'''

echo '$ test-expr '\''!A != (!B >= C)'\'''
test-expr '!A != (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B >= C)'\'''

echo '$ test-expr '\''!A != (!B == C)'\'''
test-expr '!A != (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B == C)'\'''

echo '$ test-expr '\''!A != (!B != C)'\'''
test-expr '!A != (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B != C)'\'''

echo '$ test-expr '\''!A != (!B && C)'\'''
test-expr '!A != (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B && C)'\'''

echo '$ test-expr '\''!A != (!B || C)'\'''
test-expr '!A != (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B || C)'\'''

echo '$ test-expr '\''!A && (!B <= C)'\'''
test-expr '!A && (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B <= C)'\'''

echo '$ test-expr '\''!A && (!B >= C)'\'''
test-expr '!A && (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B >= C)'\'''

echo '$ test-expr '\''!A && (!B == C)'\'''
test-expr '!A && (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B == C)'\'''

echo '$ test-expr '\''!A && (!B != C)'\'''
test-expr '!A && (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B != C)'\'''

echo '$ test-expr '\''!A && (!B && C)'\'''
test-expr '!A && (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B && C)'\'''

echo '$ test-expr '\''!A && (!B || C)'\'''
test-expr '!A && (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B || C)'\'''

echo '$ test-expr '\''!A || (!B <= C)'\'''
test-expr '!A || (!B <= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B <= C)'\'''

echo '$ test-expr '\''!A || (!B >= C)'\'''
test-expr '!A || (!B >= C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B >= C)'\'''

echo '$ test-expr '\''!A || (!B == C)'\'''
test-expr '!A || (!B == C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B == C)'\'''

echo '$ test-expr '\''!A || (!B != C)'\'''
test-expr '!A || (!B != C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B != C)'\'''

echo '$ test-expr '\''!A || (!B && C)'\'''
test-expr '!A || (!B && C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B && C)'\'''

echo '$ test-expr '\''!A || (!B || C)'\'''
test-expr '!A || (!B || C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B || C)'\'''

echo '$ test-expr '\''!A <= (!B <= !c)'\'''
test-expr '!A <= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B <= !c)'\'''

echo '$ test-expr '\''!A <= (!B >= !c)'\'''
test-expr '!A <= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B >= !c)'\'''

echo '$ test-expr '\''!A <= (!B == !c)'\'''
test-expr '!A <= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B == !c)'\'''

echo '$ test-expr '\''!A <= (!B != !c)'\'''
test-expr '!A <= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B != !c)'\'''

echo '$ test-expr '\''!A <= (!B && !c)'\'''
test-expr '!A <= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B && !c)'\'''

echo '$ test-expr '\''!A <= (!B || !c)'\'''
test-expr '!A <= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B || !c)'\'''

echo '$ test-expr '\''!A >= (!B <= !c)'\'''
test-expr '!A >= (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B <= !c)'\'''

echo '$ test-expr '\''!A >= (!B >= !c)'\'''
test-expr '!A >= (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B >= !c)'\'''

echo '$ test-expr '\''!A >= (!B == !c)'\'''
test-expr '!A >= (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B == !c)'\'''

echo '$ test-expr '\''!A >= (!B != !c)'\'''
test-expr '!A >= (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B != !c)'\'''

echo '$ test-expr '\''!A >= (!B && !c)'\'''
test-expr '!A >= (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B && !c)'\'''

echo '$ test-expr '\''!A >= (!B || !c)'\'''
test-expr '!A >= (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B || !c)'\'''

echo '$ test-expr '\''!A == (!B <= !c)'\'''
test-expr '!A == (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B <= !c)'\'''

echo '$ test-expr '\''!A == (!B >= !c)'\'''
test-expr '!A == (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B >= !c)'\'''

echo '$ test-expr '\''!A == (!B == !c)'\'''
test-expr '!A == (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B == !c)'\'''

echo '$ test-expr '\''!A == (!B != !c)'\'''
test-expr '!A == (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B != !c)'\'''

echo '$ test-expr '\''!A == (!B && !c)'\'''
test-expr '!A == (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B && !c)'\'''

echo '$ test-expr '\''!A == (!B || !c)'\'''
test-expr '!A == (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B || !c)'\'''

echo '$ test-expr '\''!A != (!B <= !c)'\'''
test-expr '!A != (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B <= !c)'\'''

echo '$ test-expr '\''!A != (!B >= !c)'\'''
test-expr '!A != (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B >= !c)'\'''

echo '$ test-expr '\''!A != (!B == !c)'\'''
test-expr '!A != (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B == !c)'\'''

echo '$ test-expr '\''!A != (!B != !c)'\'''
test-expr '!A != (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B != !c)'\'''

echo '$ test-expr '\''!A != (!B && !c)'\'''
test-expr '!A != (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B && !c)'\'''

echo '$ test-expr '\''!A != (!B || !c)'\'''
test-expr '!A != (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B || !c)'\'''

echo '$ test-expr '\''!A && (!B <= !c)'\'''
test-expr '!A && (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B <= !c)'\'''

echo '$ test-expr '\''!A && (!B >= !c)'\'''
test-expr '!A && (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B >= !c)'\'''

echo '$ test-expr '\''!A && (!B == !c)'\'''
test-expr '!A && (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B == !c)'\'''

echo '$ test-expr '\''!A && (!B != !c)'\'''
test-expr '!A && (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B != !c)'\'''

echo '$ test-expr '\''!A && (!B && !c)'\'''
test-expr '!A && (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B && !c)'\'''

echo '$ test-expr '\''!A && (!B || !c)'\'''
test-expr '!A && (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B || !c)'\'''

echo '$ test-expr '\''!A || (!B <= !c)'\'''
test-expr '!A || (!B <= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B <= !c)'\'''

echo '$ test-expr '\''!A || (!B >= !c)'\'''
test-expr '!A || (!B >= !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B >= !c)'\'''

echo '$ test-expr '\''!A || (!B == !c)'\'''
test-expr '!A || (!B == !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B == !c)'\'''

echo '$ test-expr '\''!A || (!B != !c)'\'''
test-expr '!A || (!B != !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B != !c)'\'''

echo '$ test-expr '\''!A || (!B && !c)'\'''
test-expr '!A || (!B && !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B && !c)'\'''

echo '$ test-expr '\''!A || (!B || !c)'\'''
test-expr '!A || (!B || !c)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B || !c)'\'''

echo '$ test-expr '\''!A <= (!B <= !C)'\'''
test-expr '!A <= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B <= !C)'\'''

echo '$ test-expr '\''!A <= (!B >= !C)'\'''
test-expr '!A <= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B >= !C)'\'''

echo '$ test-expr '\''!A <= (!B == !C)'\'''
test-expr '!A <= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B == !C)'\'''

echo '$ test-expr '\''!A <= (!B != !C)'\'''
test-expr '!A <= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B != !C)'\'''

echo '$ test-expr '\''!A <= (!B && !C)'\'''
test-expr '!A <= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B && !C)'\'''

echo '$ test-expr '\''!A <= (!B || !C)'\'''
test-expr '!A <= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A <= (!B || !C)'\'''

echo '$ test-expr '\''!A >= (!B <= !C)'\'''
test-expr '!A >= (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B <= !C)'\'''

echo '$ test-expr '\''!A >= (!B >= !C)'\'''
test-expr '!A >= (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B >= !C)'\'''

echo '$ test-expr '\''!A >= (!B == !C)'\'''
test-expr '!A >= (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B == !C)'\'''

echo '$ test-expr '\''!A >= (!B != !C)'\'''
test-expr '!A >= (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B != !C)'\'''

echo '$ test-expr '\''!A >= (!B && !C)'\'''
test-expr '!A >= (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B && !C)'\'''

echo '$ test-expr '\''!A >= (!B || !C)'\'''
test-expr '!A >= (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A >= (!B || !C)'\'''

echo '$ test-expr '\''!A == (!B <= !C)'\'''
test-expr '!A == (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B <= !C)'\'''

echo '$ test-expr '\''!A == (!B >= !C)'\'''
test-expr '!A == (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B >= !C)'\'''

echo '$ test-expr '\''!A == (!B == !C)'\'''
test-expr '!A == (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B == !C)'\'''

echo '$ test-expr '\''!A == (!B != !C)'\'''
test-expr '!A == (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B != !C)'\'''

echo '$ test-expr '\''!A == (!B && !C)'\'''
test-expr '!A == (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B && !C)'\'''

echo '$ test-expr '\''!A == (!B || !C)'\'''
test-expr '!A == (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A == (!B || !C)'\'''

echo '$ test-expr '\''!A != (!B <= !C)'\'''
test-expr '!A != (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B <= !C)'\'''

echo '$ test-expr '\''!A != (!B >= !C)'\'''
test-expr '!A != (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B >= !C)'\'''

echo '$ test-expr '\''!A != (!B == !C)'\'''
test-expr '!A != (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B == !C)'\'''

echo '$ test-expr '\''!A != (!B != !C)'\'''
test-expr '!A != (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B != !C)'\'''

echo '$ test-expr '\''!A != (!B && !C)'\'''
test-expr '!A != (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B && !C)'\'''

echo '$ test-expr '\''!A != (!B || !C)'\'''
test-expr '!A != (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A != (!B || !C)'\'''

echo '$ test-expr '\''!A && (!B <= !C)'\'''
test-expr '!A && (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B <= !C)'\'''

echo '$ test-expr '\''!A && (!B >= !C)'\'''
test-expr '!A && (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B >= !C)'\'''

echo '$ test-expr '\''!A && (!B == !C)'\'''
test-expr '!A && (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B == !C)'\'''

echo '$ test-expr '\''!A && (!B != !C)'\'''
test-expr '!A && (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B != !C)'\'''

echo '$ test-expr '\''!A && (!B && !C)'\'''
test-expr '!A && (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B && !C)'\'''

echo '$ test-expr '\''!A && (!B || !C)'\'''
test-expr '!A && (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A && (!B || !C)'\'''

echo '$ test-expr '\''!A || (!B <= !C)'\'''
test-expr '!A || (!B <= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B <= !C)'\'''

echo '$ test-expr '\''!A || (!B >= !C)'\'''
test-expr '!A || (!B >= !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B >= !C)'\'''

echo '$ test-expr '\''!A || (!B == !C)'\'''
test-expr '!A || (!B == !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B == !C)'\'''

echo '$ test-expr '\''!A || (!B != !C)'\'''
test-expr '!A || (!B != !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B != !C)'\'''

echo '$ test-expr '\''!A || (!B && !C)'\'''
test-expr '!A || (!B && !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B && !C)'\'''

echo '$ test-expr '\''!A || (!B || !C)'\'''
test-expr '!A || (!B || !C)' 2>&1 ||
echo 'command failed: test-expr '\''!A || (!B || !C)'\'''
)

