#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C checker:text-litex-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L text-litex-lib.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }
$ shopt -s expand_aliases
$ alias json-litex='\''json-litex -p ../lib/test-litex.json'\''
$ json-litex <<< '\''{}'\''
$ json-litex <<< '\''{"a":null}'\''
json: error: <stdin>:1:6: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:6: {"a":null}
json: error: <stdin>:1:6:      ^
command failed: json-litex <<< '\''{"a":null}'\''
$ json-litex <<< '\''{"e":null}'\''
json: error: <stdin>:1:6: filter library: path check error: unexpected JSON literal
json: error: <stdin>:1:6: {"e":null}
json: error: <stdin>:1:6:      ^
command failed: json-litex <<< '\''{"e":null}'\''
$ json-litex <<< '\''{"a":{"b":{}}}'\''
$ json-litex <<< '\''{"a":{"b":[]}}'\''
$ json-litex <<< '\''{"a":{"b":""}}'\''
$ json-litex <<< '\''{"a":{"b":"\u007f"}}'\''
$ json-litex <<< '\''{"a":{"b":"\u0080"}}'\''
json: error: <stdin>:1:11: filter library: path check error: expression falsified: value at "/a/b" -> expression "/^[[:ascii:]]*$/ && #`\n` <= 1"
json: error: <stdin>:1:11: {"a":{"b":"\\u0080"}}
json: error: <stdin>:1:11:           ^
command failed: json-litex <<< '\''{"a":{"b":"\u0080"}}'\''
$ json-litex <<< '\''{"a":{"b":"foo\nbar"}}'\''
$ json-litex <<< '\''{"a":{"b":"foo\n\nbar"}}'\''
json: error: <stdin>:1:11: filter library: path check error: expression falsified: value at "/a/b" -> expression "/^[[:ascii:]]*$/ && #`\n` <= 1"
json: error: <stdin>:1:11: {"a":{"b":"foo\\n\\nbar"}}
json: error: <stdin>:1:11:           ^
command failed: json-litex <<< '\''{"a":{"b":"foo\n\nbar"}}'\''
$ json-litex <<< '\''{"c":{}}'\''
$ json-litex <<< '\''{"c":{"d":null}}'\''
$ json-litex <<< '\''{"c":{"d":123}}'\''
json: error: <stdin>:1:11: filter library: path check error: expression falsified: value at "/c/d" -> expression "null || date(`%Y-%m-%d`)"
json: error: <stdin>:1:11: {"c":{"d":123}}
json: error: <stdin>:1:11:           ^
command failed: json-litex <<< '\''{"c":{"d":123}}'\''
$ json-litex <<< '\''{"c":[{"d":"2018-09-10"},{"d":456}]}'\''
json: error: <stdin>:1:31: filter library: path check error: expression falsified: value at "/c/d" -> expression "null || date(`%Y-%m-%d`)"
json: error: <stdin>:1:31: {"c":[{"d":"2018-09-10"},{"d":456}]}
json: error: <stdin>:1:31:                               ^
command failed: json-litex <<< '\''{"c":[{"d":"2018-09-10"},{"d":456}]}'\'''
) -L text-litex-lib.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value --parse-only -Vf -- ../lib/json-litex.so "$@"; }'

echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ alias json-litex='\''json-litex -p ../lib/test-litex.json'\'''
alias json-litex='json-litex -p ../lib/test-litex.json' 2>&1 ||
echo 'command failed: alias json-litex='\''json-litex -p ../lib/test-litex.json'\'''

echo '$ json-litex <<< '\''{}'\'''
json-litex <<< '{}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{}'\'''

echo '$ json-litex <<< '\''{"a":null}'\'''
json-litex <<< '{"a":null}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":null}'\'''

echo '$ json-litex <<< '\''{"e":null}'\'''
json-litex <<< '{"e":null}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"e":null}'\'''

echo '$ json-litex <<< '\''{"a":{"b":{}}}'\'''
json-litex <<< '{"a":{"b":{}}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":{"b":{}}}'\'''

echo '$ json-litex <<< '\''{"a":{"b":[]}}'\'''
json-litex <<< '{"a":{"b":[]}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":{"b":[]}}'\'''

echo '$ json-litex <<< '\''{"a":{"b":""}}'\'''
json-litex <<< '{"a":{"b":""}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":{"b":""}}'\'''

echo '$ json-litex <<< '\''{"a":{"b":"\u007f"}}'\'''
json-litex <<< '{"a":{"b":"\u007f"}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":{"b":"\u007f"}}'\'''

echo '$ json-litex <<< '\''{"a":{"b":"\u0080"}}'\'''
json-litex <<< '{"a":{"b":"\u0080"}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":{"b":"\u0080"}}'\'''

echo '$ json-litex <<< '\''{"a":{"b":"foo\nbar"}}'\'''
json-litex <<< '{"a":{"b":"foo\nbar"}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":{"b":"foo\nbar"}}'\'''

echo '$ json-litex <<< '\''{"a":{"b":"foo\n\nbar"}}'\'''
json-litex <<< '{"a":{"b":"foo\n\nbar"}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"a":{"b":"foo\n\nbar"}}'\'''

echo '$ json-litex <<< '\''{"c":{}}'\'''
json-litex <<< '{"c":{}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"c":{}}'\'''

echo '$ json-litex <<< '\''{"c":{"d":null}}'\'''
json-litex <<< '{"c":{"d":null}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"c":{"d":null}}'\'''

echo '$ json-litex <<< '\''{"c":{"d":123}}'\'''
json-litex <<< '{"c":{"d":123}}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"c":{"d":123}}'\'''

echo '$ json-litex <<< '\''{"c":[{"d":"2018-09-10"},{"d":456}]}'\'''
json-litex <<< '{"c":[{"d":"2018-09-10"},{"d":456}]}' 2>&1 ||
echo 'command failed: json-litex <<< '\''{"c":[{"d":"2018-09-10"},{"d":456}]}'\'''
)

