#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict-expr5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr5.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }
$ json '\''a ~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}'
) -L dict-expr5.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'
json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); } 2>&1 ||
echo 'command failed: json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'

echo '$ json '\''a ~a b'\'' '\''a,b,c'\'''
json 'a ~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a ~b'\'' '\''a,b,c'\'''
json 'a ~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a c'\'' '\''a,b,c'\'''
json 'a ~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a ~c'\'' '\''a,b,c'\'''
json 'a ~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a b ~a'\'' '\''a,b,c'\'''
json 'a b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a b ~b'\'' '\''a,b,c'\'''
json 'a b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a b c'\'' '\''a,b,c'\'''
json 'a b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b c'\'' '\''a,b,c'\'''

echo '$ json '\''a b ~c'\'' '\''a,b,c'\'''
json 'a b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b ~a'\'' '\''a,b,c'\'''
json 'a ~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b b'\'' '\''a,b,c'\'''
json 'a ~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b c'\'' '\''a,b,c'\'''
json 'a ~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b ~c'\'' '\''a,b,c'\'''
json 'a ~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a c ~a'\'' '\''a,b,c'\'''
json 'a c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a c b'\'' '\''a,b,c'\'''
json 'a c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c b'\'' '\''a,b,c'\'''

echo '$ json '\''a c ~b'\'' '\''a,b,c'\'''
json 'a c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a c ~c'\'' '\''a,b,c'\'''
json 'a c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c ~a'\'' '\''a,b,c'\'''
json 'a ~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c b'\'' '\''a,b,c'\'''
json 'a ~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c ~b'\'' '\''a,b,c'\'''
json 'a ~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c c'\'' '\''a,b,c'\'''
json 'a ~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c c'\'' '\''a,b,c'\'''

echo '$ json '\''~a a b'\'' '\''a,b,c'\'''
json '~a a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a b'\'' '\''a,b,c'\'''

echo '$ json '\''~a a ~b'\'' '\''a,b,c'\'''
json '~a a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a a c'\'' '\''a,b,c'\'''
json '~a a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a c'\'' '\''a,b,c'\'''

echo '$ json '\''~a a ~c'\'' '\''a,b,c'\'''
json '~a a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a b a'\'' '\''a,b,c'\'''
json '~a b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b a'\'' '\''a,b,c'\'''

echo '$ json '\''~a b ~b'\'' '\''a,b,c'\'''
json '~a b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a b c'\'' '\''a,b,c'\'''
json '~a b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b c'\'' '\''a,b,c'\'''

echo '$ json '\''~a b ~c'\'' '\''a,b,c'\'''
json '~a b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b a'\'' '\''a,b,c'\'''
json '~a ~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b a'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b b'\'' '\''a,b,c'\'''
json '~a ~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b c'\'' '\''a,b,c'\'''
json '~a ~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b ~c'\'' '\''a,b,c'\'''
json '~a ~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a c a'\'' '\''a,b,c'\'''
json '~a c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c a'\'' '\''a,b,c'\'''

echo '$ json '\''~a c b'\'' '\''a,b,c'\'''
json '~a c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c b'\'' '\''a,b,c'\'''

echo '$ json '\''~a c ~b'\'' '\''a,b,c'\'''
json '~a c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a c ~c'\'' '\''a,b,c'\'''
json '~a c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c a'\'' '\''a,b,c'\'''
json '~a ~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c a'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c b'\'' '\''a,b,c'\'''
json '~a ~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c ~b'\'' '\''a,b,c'\'''
json '~a ~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c c'\'' '\''a,b,c'\'''
json '~a ~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c c'\'' '\''a,b,c'\'''

echo '$ json '\''b a ~a'\'' '\''a,b,c'\'''
json 'b a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b a ~b'\'' '\''a,b,c'\'''
json 'b a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b a c'\'' '\''a,b,c'\'''
json 'b a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a c'\'' '\''a,b,c'\'''

echo '$ json '\''b a ~c'\'' '\''a,b,c'\'''
json 'b a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a a'\'' '\''a,b,c'\'''
json 'b ~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a ~b'\'' '\''a,b,c'\'''
json 'b ~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a c'\'' '\''a,b,c'\'''
json 'b ~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a ~c'\'' '\''a,b,c'\'''
json 'b ~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b a'\'' '\''a,b,c'\'''
json 'b ~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b ~a'\'' '\''a,b,c'\'''
json 'b ~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b c'\'' '\''a,b,c'\'''
json 'b ~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b ~c'\'' '\''a,b,c'\'''
json 'b ~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b c a'\'' '\''a,b,c'\'''
json 'b c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c a'\'' '\''a,b,c'\'''

echo '$ json '\''b c ~a'\'' '\''a,b,c'\'''
json 'b c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b c ~b'\'' '\''a,b,c'\'''
json 'b c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b c ~c'\'' '\''a,b,c'\'''
json 'b c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c a'\'' '\''a,b,c'\'''
json 'b ~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c ~a'\'' '\''a,b,c'\'''
json 'b ~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c ~b'\'' '\''a,b,c'\'''
json 'b ~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c c'\'' '\''a,b,c'\'''
json 'b ~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c c'\'' '\''a,b,c'\'''

echo '$ json '\''~b a ~a'\'' '\''a,b,c'\'''
json '~b a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b a b'\'' '\''a,b,c'\'''
json '~b a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a b'\'' '\''a,b,c'\'''

echo '$ json '\''~b a c'\'' '\''a,b,c'\'''
json '~b a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a c'\'' '\''a,b,c'\'''

echo '$ json '\''~b a ~c'\'' '\''a,b,c'\'''
json '~b a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a a'\'' '\''a,b,c'\'''
json '~b ~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a b'\'' '\''a,b,c'\'''
json '~b ~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a b'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a c'\'' '\''a,b,c'\'''
json '~b ~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a ~c'\'' '\''a,b,c'\'''
json '~b ~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b b a'\'' '\''a,b,c'\'''
json '~b b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b a'\'' '\''a,b,c'\'''

echo '$ json '\''~b b ~a'\'' '\''a,b,c'\'''
json '~b b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b b c'\'' '\''a,b,c'\'''
json '~b b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b c'\'' '\''a,b,c'\'''

echo '$ json '\''~b b ~c'\'' '\''a,b,c'\'''
json '~b b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b c a'\'' '\''a,b,c'\'''
json '~b c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c a'\'' '\''a,b,c'\'''

echo '$ json '\''~b c ~a'\'' '\''a,b,c'\'''
json '~b c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b c b'\'' '\''a,b,c'\'''
json '~b c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c b'\'' '\''a,b,c'\'''

echo '$ json '\''~b c ~c'\'' '\''a,b,c'\'''
json '~b c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c a'\'' '\''a,b,c'\'''
json '~b ~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c ~a'\'' '\''a,b,c'\'''
json '~b ~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c b'\'' '\''a,b,c'\'''
json '~b ~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c b'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c c'\'' '\''a,b,c'\'''
json '~b ~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c c'\'' '\''a,b,c'\'''

echo '$ json '\''c a ~a'\'' '\''a,b,c'\'''
json 'c a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c a b'\'' '\''a,b,c'\'''
json 'c a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a b'\'' '\''a,b,c'\'''

echo '$ json '\''c a ~b'\'' '\''a,b,c'\'''
json 'c a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c a ~c'\'' '\''a,b,c'\'''
json 'c a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a a'\'' '\''a,b,c'\'''
json 'c ~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a b'\'' '\''a,b,c'\'''
json 'c ~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a ~b'\'' '\''a,b,c'\'''
json 'c ~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a ~c'\'' '\''a,b,c'\'''
json 'c ~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c b a'\'' '\''a,b,c'\'''
json 'c b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b a'\'' '\''a,b,c'\'''

echo '$ json '\''c b ~a'\'' '\''a,b,c'\'''
json 'c b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c b ~b'\'' '\''a,b,c'\'''
json 'c b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c b ~c'\'' '\''a,b,c'\'''
json 'c b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b a'\'' '\''a,b,c'\'''
json 'c ~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b ~a'\'' '\''a,b,c'\'''
json 'c ~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b b'\'' '\''a,b,c'\'''
json 'c ~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b ~c'\'' '\''a,b,c'\'''
json 'c ~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c a'\'' '\''a,b,c'\'''
json 'c ~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c ~a'\'' '\''a,b,c'\'''
json 'c ~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c b'\'' '\''a,b,c'\'''
json 'c ~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c ~b'\'' '\''a,b,c'\'''
json 'c ~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a ~a'\'' '\''a,b,c'\'''
json '~c a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c a b'\'' '\''a,b,c'\'''
json '~c a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a ~b'\'' '\''a,b,c'\'''
json '~c a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a c'\'' '\''a,b,c'\'''
json '~c a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a c'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a a'\'' '\''a,b,c'\'''
json '~c ~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a b'\'' '\''a,b,c'\'''
json '~c ~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a ~b'\'' '\''a,b,c'\'''
json '~c ~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a c'\'' '\''a,b,c'\'''
json '~c ~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a c'\'' '\''a,b,c'\'''

echo '$ json '\''~c b a'\'' '\''a,b,c'\'''
json '~c b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b a'\'' '\''a,b,c'\'''

echo '$ json '\''~c b ~a'\'' '\''a,b,c'\'''
json '~c b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c b ~b'\'' '\''a,b,c'\'''
json '~c b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c b c'\'' '\''a,b,c'\'''
json '~c b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b c'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b a'\'' '\''a,b,c'\'''
json '~c ~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b ~a'\'' '\''a,b,c'\'''
json '~c ~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b b'\'' '\''a,b,c'\'''
json '~c ~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b c'\'' '\''a,b,c'\'''
json '~c ~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b c'\'' '\''a,b,c'\'''

echo '$ json '\''~c c a'\'' '\''a,b,c'\'''
json '~c c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c a'\'' '\''a,b,c'\'''

echo '$ json '\''~c c ~a'\'' '\''a,b,c'\'''
json '~c c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c c b'\'' '\''a,b,c'\'''
json '~c c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c b'\'' '\''a,b,c'\'''

echo '$ json '\''~c c ~b'\'' '\''a,b,c'\'''
json '~c c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a|b'\'' '\''a,b,c'\'''
json 'a ~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a|~b'\'' '\''a,b,c'\'''
json 'a ~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a|c'\'' '\''a,b,c'\'''
json 'a ~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a|~c'\'' '\''a,b,c'\'''
json 'a ~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a b|~a'\'' '\''a,b,c'\'''
json 'a b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a b|~b'\'' '\''a,b,c'\'''
json 'a b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a b|c'\'' '\''a,b,c'\'''
json 'a b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b|c'\'' '\''a,b,c'\'''

echo '$ json '\''a b|~c'\'' '\''a,b,c'\'''
json 'a b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b|~a'\'' '\''a,b,c'\'''
json 'a ~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b|b'\'' '\''a,b,c'\'''
json 'a ~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b|c'\'' '\''a,b,c'\'''
json 'a ~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b|~c'\'' '\''a,b,c'\'''
json 'a ~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a c|~a'\'' '\''a,b,c'\'''
json 'a c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a c|b'\'' '\''a,b,c'\'''
json 'a c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c|b'\'' '\''a,b,c'\'''

echo '$ json '\''a c|~b'\'' '\''a,b,c'\'''
json 'a c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a c|~c'\'' '\''a,b,c'\'''
json 'a c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c|~a'\'' '\''a,b,c'\'''
json 'a ~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c|b'\'' '\''a,b,c'\'''
json 'a ~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c|~b'\'' '\''a,b,c'\'''
json 'a ~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c|c'\'' '\''a,b,c'\'''
json 'a ~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a a|b'\'' '\''a,b,c'\'''
json '~a a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a a|~b'\'' '\''a,b,c'\'''
json '~a a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a a|c'\'' '\''a,b,c'\'''
json '~a a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a a|~c'\'' '\''a,b,c'\'''
json '~a a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a b|a'\'' '\''a,b,c'\'''
json '~a b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a b|~b'\'' '\''a,b,c'\'''
json '~a b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a b|c'\'' '\''a,b,c'\'''
json '~a b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a b|~c'\'' '\''a,b,c'\'''
json '~a b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b|a'\'' '\''a,b,c'\'''
json '~a ~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b|b'\'' '\''a,b,c'\'''
json '~a ~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b|c'\'' '\''a,b,c'\'''
json '~a ~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b|~c'\'' '\''a,b,c'\'''
json '~a ~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a c|a'\'' '\''a,b,c'\'''
json '~a c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a c|b'\'' '\''a,b,c'\'''
json '~a c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a c|~b'\'' '\''a,b,c'\'''
json '~a c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a c|~c'\'' '\''a,b,c'\'''
json '~a c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c|a'\'' '\''a,b,c'\'''
json '~a ~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c|b'\'' '\''a,b,c'\'''
json '~a ~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c|~b'\'' '\''a,b,c'\'''
json '~a ~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c|c'\'' '\''a,b,c'\'''
json '~a ~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''b a|~a'\'' '\''a,b,c'\'''
json 'b a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b a|~b'\'' '\''a,b,c'\'''
json 'b a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b a|c'\'' '\''a,b,c'\'''
json 'b a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a|c'\'' '\''a,b,c'\'''

echo '$ json '\''b a|~c'\'' '\''a,b,c'\'''
json 'b a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a|a'\'' '\''a,b,c'\'''
json 'b ~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a|~b'\'' '\''a,b,c'\'''
json 'b ~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a|c'\'' '\''a,b,c'\'''
json 'b ~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a|~c'\'' '\''a,b,c'\'''
json 'b ~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b|a'\'' '\''a,b,c'\'''
json 'b ~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b|~a'\'' '\''a,b,c'\'''
json 'b ~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b|c'\'' '\''a,b,c'\'''
json 'b ~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b|~c'\'' '\''a,b,c'\'''
json 'b ~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b c|a'\'' '\''a,b,c'\'''
json 'b c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c|a'\'' '\''a,b,c'\'''

echo '$ json '\''b c|~a'\'' '\''a,b,c'\'''
json 'b c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b c|~b'\'' '\''a,b,c'\'''
json 'b c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b c|~c'\'' '\''a,b,c'\'''
json 'b c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c|a'\'' '\''a,b,c'\'''
json 'b ~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c|~a'\'' '\''a,b,c'\'''
json 'b ~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c|~b'\'' '\''a,b,c'\'''
json 'b ~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c|c'\'' '\''a,b,c'\'''
json 'b ~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b a|~a'\'' '\''a,b,c'\'''
json '~b a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b a|b'\'' '\''a,b,c'\'''
json '~b a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b a|c'\'' '\''a,b,c'\'''
json '~b a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b a|~c'\'' '\''a,b,c'\'''
json '~b a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a|a'\'' '\''a,b,c'\'''
json '~b ~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a|b'\'' '\''a,b,c'\'''
json '~b ~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a|c'\'' '\''a,b,c'\'''
json '~b ~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a|~c'\'' '\''a,b,c'\'''
json '~b ~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b b|a'\'' '\''a,b,c'\'''
json '~b b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b b|~a'\'' '\''a,b,c'\'''
json '~b b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b b|c'\'' '\''a,b,c'\'''
json '~b b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b b|~c'\'' '\''a,b,c'\'''
json '~b b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b c|a'\'' '\''a,b,c'\'''
json '~b c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b c|~a'\'' '\''a,b,c'\'''
json '~b c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b c|b'\'' '\''a,b,c'\'''
json '~b c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b c|~c'\'' '\''a,b,c'\'''
json '~b c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c|a'\'' '\''a,b,c'\'''
json '~b ~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c|~a'\'' '\''a,b,c'\'''
json '~b ~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c|b'\'' '\''a,b,c'\'''
json '~b ~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c|c'\'' '\''a,b,c'\'''
json '~b ~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''c a|~a'\'' '\''a,b,c'\'''
json 'c a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c a|b'\'' '\''a,b,c'\'''
json 'c a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a|b'\'' '\''a,b,c'\'''

echo '$ json '\''c a|~b'\'' '\''a,b,c'\'''
json 'c a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c a|~c'\'' '\''a,b,c'\'''
json 'c a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a|a'\'' '\''a,b,c'\'''
json 'c ~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a|b'\'' '\''a,b,c'\'''
json 'c ~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a|~b'\'' '\''a,b,c'\'''
json 'c ~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a|~c'\'' '\''a,b,c'\'''
json 'c ~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c b|a'\'' '\''a,b,c'\'''
json 'c b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b|a'\'' '\''a,b,c'\'''

echo '$ json '\''c b|~a'\'' '\''a,b,c'\'''
json 'c b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c b|~b'\'' '\''a,b,c'\'''
json 'c b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c b|~c'\'' '\''a,b,c'\'''
json 'c b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b|a'\'' '\''a,b,c'\'''
json 'c ~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b|~a'\'' '\''a,b,c'\'''
json 'c ~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b|b'\'' '\''a,b,c'\'''
json 'c ~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b|~c'\'' '\''a,b,c'\'''
json 'c ~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c|a'\'' '\''a,b,c'\'''
json 'c ~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c|~a'\'' '\''a,b,c'\'''
json 'c ~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c|b'\'' '\''a,b,c'\'''
json 'c ~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c|~b'\'' '\''a,b,c'\'''
json 'c ~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a|~a'\'' '\''a,b,c'\'''
json '~c a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c a|b'\'' '\''a,b,c'\'''
json '~c a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a|~b'\'' '\''a,b,c'\'''
json '~c a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a|c'\'' '\''a,b,c'\'''
json '~c a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a|a'\'' '\''a,b,c'\'''
json '~c ~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a|b'\'' '\''a,b,c'\'''
json '~c ~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a|~b'\'' '\''a,b,c'\'''
json '~c ~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a|c'\'' '\''a,b,c'\'''
json '~c ~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c b|a'\'' '\''a,b,c'\'''
json '~c b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c b|~a'\'' '\''a,b,c'\'''
json '~c b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c b|~b'\'' '\''a,b,c'\'''
json '~c b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c b|c'\'' '\''a,b,c'\'''
json '~c b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b|a'\'' '\''a,b,c'\'''
json '~c ~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b|~a'\'' '\''a,b,c'\'''
json '~c ~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b|b'\'' '\''a,b,c'\'''
json '~c ~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b|c'\'' '\''a,b,c'\'''
json '~c ~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c c|a'\'' '\''a,b,c'\'''
json '~c c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c c|~a'\'' '\''a,b,c'\'''
json '~c c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c c|b'\'' '\''a,b,c'\'''
json '~c c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c c|~b'\'' '\''a,b,c'\'''
json '~c c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a||b'\'' '\''a,b,c'\'''
json 'a ~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a||~b'\'' '\''a,b,c'\'''
json 'a ~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a||c'\'' '\''a,b,c'\'''
json 'a ~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a||~c'\'' '\''a,b,c'\'''
json 'a ~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a b||~a'\'' '\''a,b,c'\'''
json 'a b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a b||~b'\'' '\''a,b,c'\'''
json 'a b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a b||c'\'' '\''a,b,c'\'''
json 'a b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b||c'\'' '\''a,b,c'\'''

echo '$ json '\''a b||~c'\'' '\''a,b,c'\'''
json 'a b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b||~a'\'' '\''a,b,c'\'''
json 'a ~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b||b'\'' '\''a,b,c'\'''
json 'a ~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b||c'\'' '\''a,b,c'\'''
json 'a ~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b||~c'\'' '\''a,b,c'\'''
json 'a ~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a c||~a'\'' '\''a,b,c'\'''
json 'a c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a c||b'\'' '\''a,b,c'\'''
json 'a c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c||b'\'' '\''a,b,c'\'''

echo '$ json '\''a c||~b'\'' '\''a,b,c'\'''
json 'a c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a c||~c'\'' '\''a,b,c'\'''
json 'a c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c||~a'\'' '\''a,b,c'\'''
json 'a ~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c||b'\'' '\''a,b,c'\'''
json 'a ~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c||~b'\'' '\''a,b,c'\'''
json 'a ~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c||c'\'' '\''a,b,c'\'''
json 'a ~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a a||b'\'' '\''a,b,c'\'''
json '~a a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a a||~b'\'' '\''a,b,c'\'''
json '~a a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a a||c'\'' '\''a,b,c'\'''
json '~a a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a a||~c'\'' '\''a,b,c'\'''
json '~a a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a b||a'\'' '\''a,b,c'\'''
json '~a b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a b||~b'\'' '\''a,b,c'\'''
json '~a b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a b||c'\'' '\''a,b,c'\'''
json '~a b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a b||~c'\'' '\''a,b,c'\'''
json '~a b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b||a'\'' '\''a,b,c'\'''
json '~a ~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b||b'\'' '\''a,b,c'\'''
json '~a ~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b||c'\'' '\''a,b,c'\'''
json '~a ~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b||~c'\'' '\''a,b,c'\'''
json '~a ~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a c||a'\'' '\''a,b,c'\'''
json '~a c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a c||b'\'' '\''a,b,c'\'''
json '~a c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a c||~b'\'' '\''a,b,c'\'''
json '~a c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a c||~c'\'' '\''a,b,c'\'''
json '~a c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c||a'\'' '\''a,b,c'\'''
json '~a ~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c||b'\'' '\''a,b,c'\'''
json '~a ~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c||~b'\'' '\''a,b,c'\'''
json '~a ~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c||c'\'' '\''a,b,c'\'''
json '~a ~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''b a||~a'\'' '\''a,b,c'\'''
json 'b a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b a||~b'\'' '\''a,b,c'\'''
json 'b a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b a||c'\'' '\''a,b,c'\'''
json 'b a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a||c'\'' '\''a,b,c'\'''

echo '$ json '\''b a||~c'\'' '\''a,b,c'\'''
json 'b a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a||a'\'' '\''a,b,c'\'''
json 'b ~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a||~b'\'' '\''a,b,c'\'''
json 'b ~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a||c'\'' '\''a,b,c'\'''
json 'b ~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a||~c'\'' '\''a,b,c'\'''
json 'b ~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b||a'\'' '\''a,b,c'\'''
json 'b ~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b||~a'\'' '\''a,b,c'\'''
json 'b ~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b||c'\'' '\''a,b,c'\'''
json 'b ~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b||~c'\'' '\''a,b,c'\'''
json 'b ~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b c||a'\'' '\''a,b,c'\'''
json 'b c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c||a'\'' '\''a,b,c'\'''

echo '$ json '\''b c||~a'\'' '\''a,b,c'\'''
json 'b c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b c||~b'\'' '\''a,b,c'\'''
json 'b c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b c||~c'\'' '\''a,b,c'\'''
json 'b c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c||a'\'' '\''a,b,c'\'''
json 'b ~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c||~a'\'' '\''a,b,c'\'''
json 'b ~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c||~b'\'' '\''a,b,c'\'''
json 'b ~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c||c'\'' '\''a,b,c'\'''
json 'b ~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b a||~a'\'' '\''a,b,c'\'''
json '~b a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b a||b'\'' '\''a,b,c'\'''
json '~b a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b a||c'\'' '\''a,b,c'\'''
json '~b a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b a||~c'\'' '\''a,b,c'\'''
json '~b a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a||a'\'' '\''a,b,c'\'''
json '~b ~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a||b'\'' '\''a,b,c'\'''
json '~b ~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a||c'\'' '\''a,b,c'\'''
json '~b ~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a||~c'\'' '\''a,b,c'\'''
json '~b ~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b b||a'\'' '\''a,b,c'\'''
json '~b b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b b||~a'\'' '\''a,b,c'\'''
json '~b b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b b||c'\'' '\''a,b,c'\'''
json '~b b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b b||~c'\'' '\''a,b,c'\'''
json '~b b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b c||a'\'' '\''a,b,c'\'''
json '~b c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b c||~a'\'' '\''a,b,c'\'''
json '~b c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b c||b'\'' '\''a,b,c'\'''
json '~b c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b c||~c'\'' '\''a,b,c'\'''
json '~b c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c||a'\'' '\''a,b,c'\'''
json '~b ~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c||~a'\'' '\''a,b,c'\'''
json '~b ~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c||b'\'' '\''a,b,c'\'''
json '~b ~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c||c'\'' '\''a,b,c'\'''
json '~b ~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''c a||~a'\'' '\''a,b,c'\'''
json 'c a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c a||b'\'' '\''a,b,c'\'''
json 'c a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a||b'\'' '\''a,b,c'\'''

echo '$ json '\''c a||~b'\'' '\''a,b,c'\'''
json 'c a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c a||~c'\'' '\''a,b,c'\'''
json 'c a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a||a'\'' '\''a,b,c'\'''
json 'c ~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a||b'\'' '\''a,b,c'\'''
json 'c ~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a||~b'\'' '\''a,b,c'\'''
json 'c ~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a||~c'\'' '\''a,b,c'\'''
json 'c ~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c b||a'\'' '\''a,b,c'\'''
json 'c b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b||a'\'' '\''a,b,c'\'''

echo '$ json '\''c b||~a'\'' '\''a,b,c'\'''
json 'c b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c b||~b'\'' '\''a,b,c'\'''
json 'c b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c b||~c'\'' '\''a,b,c'\'''
json 'c b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b||a'\'' '\''a,b,c'\'''
json 'c ~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b||~a'\'' '\''a,b,c'\'''
json 'c ~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b||b'\'' '\''a,b,c'\'''
json 'c ~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b||~c'\'' '\''a,b,c'\'''
json 'c ~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c||a'\'' '\''a,b,c'\'''
json 'c ~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c||~a'\'' '\''a,b,c'\'''
json 'c ~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c||b'\'' '\''a,b,c'\'''
json 'c ~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c||~b'\'' '\''a,b,c'\'''
json 'c ~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a||~a'\'' '\''a,b,c'\'''
json '~c a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c a||b'\'' '\''a,b,c'\'''
json '~c a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a||~b'\'' '\''a,b,c'\'''
json '~c a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c a||c'\'' '\''a,b,c'\'''
json '~c a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a||a'\'' '\''a,b,c'\'''
json '~c ~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a||b'\'' '\''a,b,c'\'''
json '~c ~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a||~b'\'' '\''a,b,c'\'''
json '~c ~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a||c'\'' '\''a,b,c'\'''
json '~c ~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c b||a'\'' '\''a,b,c'\'''
json '~c b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c b||~a'\'' '\''a,b,c'\'''
json '~c b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c b||~b'\'' '\''a,b,c'\'''
json '~c b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c b||c'\'' '\''a,b,c'\'''
json '~c b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b||a'\'' '\''a,b,c'\'''
json '~c ~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b||~a'\'' '\''a,b,c'\'''
json '~c ~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b||b'\'' '\''a,b,c'\'''
json '~c ~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b||c'\'' '\''a,b,c'\'''
json '~c ~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c c||a'\'' '\''a,b,c'\'''
json '~c c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c c||~a'\'' '\''a,b,c'\'''
json '~c c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c c||b'\'' '\''a,b,c'\'''
json '~c c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c c||~b'\'' '\''a,b,c'\'''
json '~c c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a b'\'' '\''a,b,c'\'''
json 'a|~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a ~b'\'' '\''a,b,c'\'''
json 'a|~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a c'\'' '\''a,b,c'\'''
json 'a|~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a ~c'\'' '\''a,b,c'\'''
json 'a|~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|b ~a'\'' '\''a,b,c'\'''
json 'a|b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|b ~b'\'' '\''a,b,c'\'''
json 'a|b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|b c'\'' '\''a,b,c'\'''
json 'a|b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b c'\'' '\''a,b,c'\'''

echo '$ json '\''a|b ~c'\'' '\''a,b,c'\'''
json 'a|b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b ~a'\'' '\''a,b,c'\'''
json 'a|~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b b'\'' '\''a,b,c'\'''
json 'a|~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b c'\'' '\''a,b,c'\'''
json 'a|~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b ~c'\'' '\''a,b,c'\'''
json 'a|~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|c ~a'\'' '\''a,b,c'\'''
json 'a|c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|c b'\'' '\''a,b,c'\'''
json 'a|c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c b'\'' '\''a,b,c'\'''

echo '$ json '\''a|c ~b'\'' '\''a,b,c'\'''
json 'a|c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|c ~c'\'' '\''a,b,c'\'''
json 'a|c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c ~a'\'' '\''a,b,c'\'''
json 'a|~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c b'\'' '\''a,b,c'\'''
json 'a|~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c ~b'\'' '\''a,b,c'\'''
json 'a|~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c c'\'' '\''a,b,c'\'''
json 'a|~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a b'\'' '\''a,b,c'\'''
json '~a|a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a ~b'\'' '\''a,b,c'\'''
json '~a|a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a c'\'' '\''a,b,c'\'''
json '~a|a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a ~c'\'' '\''a,b,c'\'''
json '~a|a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b a'\'' '\''a,b,c'\'''
json '~a|b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b ~b'\'' '\''a,b,c'\'''
json '~a|b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b c'\'' '\''a,b,c'\'''
json '~a|b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b ~c'\'' '\''a,b,c'\'''
json '~a|b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b a'\'' '\''a,b,c'\'''
json '~a|~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b b'\'' '\''a,b,c'\'''
json '~a|~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b c'\'' '\''a,b,c'\'''
json '~a|~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b ~c'\'' '\''a,b,c'\'''
json '~a|~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c a'\'' '\''a,b,c'\'''
json '~a|c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c b'\'' '\''a,b,c'\'''
json '~a|c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c ~b'\'' '\''a,b,c'\'''
json '~a|c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c ~c'\'' '\''a,b,c'\'''
json '~a|c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c a'\'' '\''a,b,c'\'''
json '~a|~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c b'\'' '\''a,b,c'\'''
json '~a|~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c ~b'\'' '\''a,b,c'\'''
json '~a|~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c c'\'' '\''a,b,c'\'''
json '~a|~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c c'\'' '\''a,b,c'\'''

echo '$ json '\''b|a ~a'\'' '\''a,b,c'\'''
json 'b|a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|a ~b'\'' '\''a,b,c'\'''
json 'b|a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|a c'\'' '\''a,b,c'\'''
json 'b|a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a c'\'' '\''a,b,c'\'''

echo '$ json '\''b|a ~c'\'' '\''a,b,c'\'''
json 'b|a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a a'\'' '\''a,b,c'\'''
json 'b|~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a ~b'\'' '\''a,b,c'\'''
json 'b|~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a c'\'' '\''a,b,c'\'''
json 'b|~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a ~c'\'' '\''a,b,c'\'''
json 'b|~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b a'\'' '\''a,b,c'\'''
json 'b|~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b ~a'\'' '\''a,b,c'\'''
json 'b|~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b c'\'' '\''a,b,c'\'''
json 'b|~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b ~c'\'' '\''a,b,c'\'''
json 'b|~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|c a'\'' '\''a,b,c'\'''
json 'b|c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c a'\'' '\''a,b,c'\'''

echo '$ json '\''b|c ~a'\'' '\''a,b,c'\'''
json 'b|c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|c ~b'\'' '\''a,b,c'\'''
json 'b|c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|c ~c'\'' '\''a,b,c'\'''
json 'b|c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c a'\'' '\''a,b,c'\'''
json 'b|~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c ~a'\'' '\''a,b,c'\'''
json 'b|~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c ~b'\'' '\''a,b,c'\'''
json 'b|~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c c'\'' '\''a,b,c'\'''
json 'b|~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a ~a'\'' '\''a,b,c'\'''
json '~b|a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a b'\'' '\''a,b,c'\'''
json '~b|a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a c'\'' '\''a,b,c'\'''
json '~b|a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a ~c'\'' '\''a,b,c'\'''
json '~b|a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a a'\'' '\''a,b,c'\'''
json '~b|~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a b'\'' '\''a,b,c'\'''
json '~b|~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a c'\'' '\''a,b,c'\'''
json '~b|~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a ~c'\'' '\''a,b,c'\'''
json '~b|~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b a'\'' '\''a,b,c'\'''
json '~b|b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b ~a'\'' '\''a,b,c'\'''
json '~b|b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b c'\'' '\''a,b,c'\'''
json '~b|b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b ~c'\'' '\''a,b,c'\'''
json '~b|b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c a'\'' '\''a,b,c'\'''
json '~b|c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c ~a'\'' '\''a,b,c'\'''
json '~b|c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c b'\'' '\''a,b,c'\'''
json '~b|c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c ~c'\'' '\''a,b,c'\'''
json '~b|c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c a'\'' '\''a,b,c'\'''
json '~b|~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c ~a'\'' '\''a,b,c'\'''
json '~b|~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c b'\'' '\''a,b,c'\'''
json '~b|~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c c'\'' '\''a,b,c'\'''
json '~b|~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c c'\'' '\''a,b,c'\'''

echo '$ json '\''c|a ~a'\'' '\''a,b,c'\'''
json 'c|a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|a b'\'' '\''a,b,c'\'''
json 'c|a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a b'\'' '\''a,b,c'\'''

echo '$ json '\''c|a ~b'\'' '\''a,b,c'\'''
json 'c|a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|a ~c'\'' '\''a,b,c'\'''
json 'c|a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a a'\'' '\''a,b,c'\'''
json 'c|~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a b'\'' '\''a,b,c'\'''
json 'c|~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a ~b'\'' '\''a,b,c'\'''
json 'c|~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a ~c'\'' '\''a,b,c'\'''
json 'c|~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|b a'\'' '\''a,b,c'\'''
json 'c|b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b a'\'' '\''a,b,c'\'''

echo '$ json '\''c|b ~a'\'' '\''a,b,c'\'''
json 'c|b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|b ~b'\'' '\''a,b,c'\'''
json 'c|b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|b ~c'\'' '\''a,b,c'\'''
json 'c|b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b a'\'' '\''a,b,c'\'''
json 'c|~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b ~a'\'' '\''a,b,c'\'''
json 'c|~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b b'\'' '\''a,b,c'\'''
json 'c|~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b ~c'\'' '\''a,b,c'\'''
json 'c|~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c a'\'' '\''a,b,c'\'''
json 'c|~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c ~a'\'' '\''a,b,c'\'''
json 'c|~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c b'\'' '\''a,b,c'\'''
json 'c|~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c ~b'\'' '\''a,b,c'\'''
json 'c|~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a ~a'\'' '\''a,b,c'\'''
json '~c|a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a b'\'' '\''a,b,c'\'''
json '~c|a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a ~b'\'' '\''a,b,c'\'''
json '~c|a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a c'\'' '\''a,b,c'\'''
json '~c|a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a a'\'' '\''a,b,c'\'''
json '~c|~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a b'\'' '\''a,b,c'\'''
json '~c|~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a ~b'\'' '\''a,b,c'\'''
json '~c|~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a c'\'' '\''a,b,c'\'''
json '~c|~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b a'\'' '\''a,b,c'\'''
json '~c|b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b ~a'\'' '\''a,b,c'\'''
json '~c|b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b ~b'\'' '\''a,b,c'\'''
json '~c|b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b c'\'' '\''a,b,c'\'''
json '~c|b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b a'\'' '\''a,b,c'\'''
json '~c|~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b ~a'\'' '\''a,b,c'\'''
json '~c|~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b b'\'' '\''a,b,c'\'''
json '~c|~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b c'\'' '\''a,b,c'\'''
json '~c|~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c a'\'' '\''a,b,c'\'''
json '~c|c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c ~a'\'' '\''a,b,c'\'''
json '~c|c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c b'\'' '\''a,b,c'\'''
json '~c|c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c ~b'\'' '\''a,b,c'\'''
json '~c|c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a|b'\'' '\''a,b,c'\'''
json 'a|~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a|~b'\'' '\''a,b,c'\'''
json 'a|~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a|c'\'' '\''a,b,c'\'''
json 'a|~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a|~c'\'' '\''a,b,c'\'''
json 'a|~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|b|~a'\'' '\''a,b,c'\'''
json 'a|b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|b|~b'\'' '\''a,b,c'\'''
json 'a|b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|b|c'\'' '\''a,b,c'\'''
json 'a|b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b|c'\'' '\''a,b,c'\'''

echo '$ json '\''a|b|~c'\'' '\''a,b,c'\'''
json 'a|b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b|~a'\'' '\''a,b,c'\'''
json 'a|~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b|b'\'' '\''a,b,c'\'''
json 'a|~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b|c'\'' '\''a,b,c'\'''
json 'a|~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b|~c'\'' '\''a,b,c'\'''
json 'a|~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|c|~a'\'' '\''a,b,c'\'''
json 'a|c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|c|b'\'' '\''a,b,c'\'''
json 'a|c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c|b'\'' '\''a,b,c'\'''

echo '$ json '\''a|c|~b'\'' '\''a,b,c'\'''
json 'a|c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|c|~c'\'' '\''a,b,c'\'''
json 'a|c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c|~a'\'' '\''a,b,c'\'''
json 'a|~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c|b'\'' '\''a,b,c'\'''
json 'a|~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c|~b'\'' '\''a,b,c'\'''
json 'a|~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c|c'\'' '\''a,b,c'\'''
json 'a|~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a|b'\'' '\''a,b,c'\'''
json '~a|a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a|~b'\'' '\''a,b,c'\'''
json '~a|a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a|c'\'' '\''a,b,c'\'''
json '~a|a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a|~c'\'' '\''a,b,c'\'''
json '~a|a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b|a'\'' '\''a,b,c'\'''
json '~a|b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b|~b'\'' '\''a,b,c'\'''
json '~a|b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b|c'\'' '\''a,b,c'\'''
json '~a|b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b|~c'\'' '\''a,b,c'\'''
json '~a|b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b|a'\'' '\''a,b,c'\'''
json '~a|~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b|b'\'' '\''a,b,c'\'''
json '~a|~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b|c'\'' '\''a,b,c'\'''
json '~a|~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b|~c'\'' '\''a,b,c'\'''
json '~a|~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c|a'\'' '\''a,b,c'\'''
json '~a|c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c|b'\'' '\''a,b,c'\'''
json '~a|c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c|~b'\'' '\''a,b,c'\'''
json '~a|c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c|~c'\'' '\''a,b,c'\'''
json '~a|c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c|a'\'' '\''a,b,c'\'''
json '~a|~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c|b'\'' '\''a,b,c'\'''
json '~a|~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c|~b'\'' '\''a,b,c'\'''
json '~a|~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c|c'\'' '\''a,b,c'\'''
json '~a|~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''b|a|~a'\'' '\''a,b,c'\'''
json 'b|a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|a|~b'\'' '\''a,b,c'\'''
json 'b|a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|a|c'\'' '\''a,b,c'\'''
json 'b|a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a|c'\'' '\''a,b,c'\'''

echo '$ json '\''b|a|~c'\'' '\''a,b,c'\'''
json 'b|a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a|a'\'' '\''a,b,c'\'''
json 'b|~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a|~b'\'' '\''a,b,c'\'''
json 'b|~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a|c'\'' '\''a,b,c'\'''
json 'b|~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a|~c'\'' '\''a,b,c'\'''
json 'b|~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b|a'\'' '\''a,b,c'\'''
json 'b|~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b|~a'\'' '\''a,b,c'\'''
json 'b|~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b|c'\'' '\''a,b,c'\'''
json 'b|~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b|~c'\'' '\''a,b,c'\'''
json 'b|~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|c|a'\'' '\''a,b,c'\'''
json 'b|c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c|a'\'' '\''a,b,c'\'''

echo '$ json '\''b|c|~a'\'' '\''a,b,c'\'''
json 'b|c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|c|~b'\'' '\''a,b,c'\'''
json 'b|c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|c|~c'\'' '\''a,b,c'\'''
json 'b|c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c|a'\'' '\''a,b,c'\'''
json 'b|~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c|~a'\'' '\''a,b,c'\'''
json 'b|~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c|~b'\'' '\''a,b,c'\'''
json 'b|~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c|c'\'' '\''a,b,c'\'''
json 'b|~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a|~a'\'' '\''a,b,c'\'''
json '~b|a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a|b'\'' '\''a,b,c'\'''
json '~b|a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a|c'\'' '\''a,b,c'\'''
json '~b|a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a|~c'\'' '\''a,b,c'\'''
json '~b|a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a|a'\'' '\''a,b,c'\'''
json '~b|~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a|b'\'' '\''a,b,c'\'''
json '~b|~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a|c'\'' '\''a,b,c'\'''
json '~b|~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a|~c'\'' '\''a,b,c'\'''
json '~b|~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b|a'\'' '\''a,b,c'\'''
json '~b|b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b|~a'\'' '\''a,b,c'\'''
json '~b|b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b|c'\'' '\''a,b,c'\'''
json '~b|b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b|~c'\'' '\''a,b,c'\'''
json '~b|b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c|a'\'' '\''a,b,c'\'''
json '~b|c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c|~a'\'' '\''a,b,c'\'''
json '~b|c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c|b'\'' '\''a,b,c'\'''
json '~b|c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c|~c'\'' '\''a,b,c'\'''
json '~b|c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c|a'\'' '\''a,b,c'\'''
json '~b|~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c|~a'\'' '\''a,b,c'\'''
json '~b|~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c|b'\'' '\''a,b,c'\'''
json '~b|~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c|c'\'' '\''a,b,c'\'''
json '~b|~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''c|a|~a'\'' '\''a,b,c'\'''
json 'c|a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|a|b'\'' '\''a,b,c'\'''
json 'c|a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a|b'\'' '\''a,b,c'\'''

echo '$ json '\''c|a|~b'\'' '\''a,b,c'\'''
json 'c|a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|a|~c'\'' '\''a,b,c'\'''
json 'c|a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a|a'\'' '\''a,b,c'\'''
json 'c|~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a|b'\'' '\''a,b,c'\'''
json 'c|~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a|~b'\'' '\''a,b,c'\'''
json 'c|~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a|~c'\'' '\''a,b,c'\'''
json 'c|~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|b|a'\'' '\''a,b,c'\'''
json 'c|b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b|a'\'' '\''a,b,c'\'''

echo '$ json '\''c|b|~a'\'' '\''a,b,c'\'''
json 'c|b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|b|~b'\'' '\''a,b,c'\'''
json 'c|b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|b|~c'\'' '\''a,b,c'\'''
json 'c|b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b|a'\'' '\''a,b,c'\'''
json 'c|~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b|~a'\'' '\''a,b,c'\'''
json 'c|~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b|b'\'' '\''a,b,c'\'''
json 'c|~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b|~c'\'' '\''a,b,c'\'''
json 'c|~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c|a'\'' '\''a,b,c'\'''
json 'c|~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c|~a'\'' '\''a,b,c'\'''
json 'c|~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c|b'\'' '\''a,b,c'\'''
json 'c|~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c|~b'\'' '\''a,b,c'\'''
json 'c|~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a|~a'\'' '\''a,b,c'\'''
json '~c|a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a|b'\'' '\''a,b,c'\'''
json '~c|a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a|~b'\'' '\''a,b,c'\'''
json '~c|a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a|c'\'' '\''a,b,c'\'''
json '~c|a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a|a'\'' '\''a,b,c'\'''
json '~c|~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a|b'\'' '\''a,b,c'\'''
json '~c|~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a|~b'\'' '\''a,b,c'\'''
json '~c|~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a|c'\'' '\''a,b,c'\'''
json '~c|~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b|a'\'' '\''a,b,c'\'''
json '~c|b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b|~a'\'' '\''a,b,c'\'''
json '~c|b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b|~b'\'' '\''a,b,c'\'''
json '~c|b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b|c'\'' '\''a,b,c'\'''
json '~c|b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b|a'\'' '\''a,b,c'\'''
json '~c|~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b|~a'\'' '\''a,b,c'\'''
json '~c|~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b|b'\'' '\''a,b,c'\'''
json '~c|~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b|c'\'' '\''a,b,c'\'''
json '~c|~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c|a'\'' '\''a,b,c'\'''
json '~c|c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c|~a'\'' '\''a,b,c'\'''
json '~c|c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c|b'\'' '\''a,b,c'\'''
json '~c|c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c|~b'\'' '\''a,b,c'\'''
json '~c|c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a||b'\'' '\''a,b,c'\'''
json 'a|~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a||~b'\'' '\''a,b,c'\'''
json 'a|~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a||c'\'' '\''a,b,c'\'''
json 'a|~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a||~c'\'' '\''a,b,c'\'''
json 'a|~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|b||~a'\'' '\''a,b,c'\'''
json 'a|b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|b||~b'\'' '\''a,b,c'\'''
json 'a|b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|b||c'\'' '\''a,b,c'\'''
json 'a|b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b||c'\'' '\''a,b,c'\'''

echo '$ json '\''a|b||~c'\'' '\''a,b,c'\'''
json 'a|b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b||~a'\'' '\''a,b,c'\'''
json 'a|~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b||b'\'' '\''a,b,c'\'''
json 'a|~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b||c'\'' '\''a,b,c'\'''
json 'a|~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b||~c'\'' '\''a,b,c'\'''
json 'a|~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|c||~a'\'' '\''a,b,c'\'''
json 'a|c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|c||b'\'' '\''a,b,c'\'''
json 'a|c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c||b'\'' '\''a,b,c'\'''

echo '$ json '\''a|c||~b'\'' '\''a,b,c'\'''
json 'a|c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|c||~c'\'' '\''a,b,c'\'''
json 'a|c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c||~a'\'' '\''a,b,c'\'''
json 'a|~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c||b'\'' '\''a,b,c'\'''
json 'a|~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c||~b'\'' '\''a,b,c'\'''
json 'a|~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c||c'\'' '\''a,b,c'\'''
json 'a|~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a||b'\'' '\''a,b,c'\'''
json '~a|a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a||~b'\'' '\''a,b,c'\'''
json '~a|a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a||c'\'' '\''a,b,c'\'''
json '~a|a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a||~c'\'' '\''a,b,c'\'''
json '~a|a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b||a'\'' '\''a,b,c'\'''
json '~a|b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b||~b'\'' '\''a,b,c'\'''
json '~a|b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b||c'\'' '\''a,b,c'\'''
json '~a|b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b||~c'\'' '\''a,b,c'\'''
json '~a|b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b||a'\'' '\''a,b,c'\'''
json '~a|~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b||b'\'' '\''a,b,c'\'''
json '~a|~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b||c'\'' '\''a,b,c'\'''
json '~a|~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b||~c'\'' '\''a,b,c'\'''
json '~a|~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c||a'\'' '\''a,b,c'\'''
json '~a|c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c||b'\'' '\''a,b,c'\'''
json '~a|c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c||~b'\'' '\''a,b,c'\'''
json '~a|c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c||~c'\'' '\''a,b,c'\'''
json '~a|c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c||a'\'' '\''a,b,c'\'''
json '~a|~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c||b'\'' '\''a,b,c'\'''
json '~a|~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c||~b'\'' '\''a,b,c'\'''
json '~a|~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c||c'\'' '\''a,b,c'\'''
json '~a|~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''b|a||~a'\'' '\''a,b,c'\'''
json 'b|a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|a||~b'\'' '\''a,b,c'\'''
json 'b|a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|a||c'\'' '\''a,b,c'\'''
json 'b|a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a||c'\'' '\''a,b,c'\'''

echo '$ json '\''b|a||~c'\'' '\''a,b,c'\'''
json 'b|a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a||a'\'' '\''a,b,c'\'''
json 'b|~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a||~b'\'' '\''a,b,c'\'''
json 'b|~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a||c'\'' '\''a,b,c'\'''
json 'b|~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a||~c'\'' '\''a,b,c'\'''
json 'b|~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b||a'\'' '\''a,b,c'\'''
json 'b|~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b||~a'\'' '\''a,b,c'\'''
json 'b|~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b||c'\'' '\''a,b,c'\'''
json 'b|~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b||~c'\'' '\''a,b,c'\'''
json 'b|~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|c||a'\'' '\''a,b,c'\'''
json 'b|c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c||a'\'' '\''a,b,c'\'''

echo '$ json '\''b|c||~a'\'' '\''a,b,c'\'''
json 'b|c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|c||~b'\'' '\''a,b,c'\'''
json 'b|c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|c||~c'\'' '\''a,b,c'\'''
json 'b|c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c||a'\'' '\''a,b,c'\'''
json 'b|~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c||~a'\'' '\''a,b,c'\'''
json 'b|~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c||~b'\'' '\''a,b,c'\'''
json 'b|~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c||c'\'' '\''a,b,c'\'''
json 'b|~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a||~a'\'' '\''a,b,c'\'''
json '~b|a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a||b'\'' '\''a,b,c'\'''
json '~b|a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a||c'\'' '\''a,b,c'\'''
json '~b|a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a||~c'\'' '\''a,b,c'\'''
json '~b|a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a||a'\'' '\''a,b,c'\'''
json '~b|~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a||b'\'' '\''a,b,c'\'''
json '~b|~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a||c'\'' '\''a,b,c'\'''
json '~b|~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a||~c'\'' '\''a,b,c'\'''
json '~b|~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b||a'\'' '\''a,b,c'\'''
json '~b|b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b||~a'\'' '\''a,b,c'\'''
json '~b|b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b||c'\'' '\''a,b,c'\'''
json '~b|b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b||~c'\'' '\''a,b,c'\'''
json '~b|b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c||a'\'' '\''a,b,c'\'''
json '~b|c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c||~a'\'' '\''a,b,c'\'''
json '~b|c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c||b'\'' '\''a,b,c'\'''
json '~b|c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c||~c'\'' '\''a,b,c'\'''
json '~b|c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c||a'\'' '\''a,b,c'\'''
json '~b|~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c||~a'\'' '\''a,b,c'\'''
json '~b|~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c||b'\'' '\''a,b,c'\'''
json '~b|~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c||c'\'' '\''a,b,c'\'''
json '~b|~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''c|a||~a'\'' '\''a,b,c'\'''
json 'c|a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|a||b'\'' '\''a,b,c'\'''
json 'c|a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a||b'\'' '\''a,b,c'\'''

echo '$ json '\''c|a||~b'\'' '\''a,b,c'\'''
json 'c|a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|a||~c'\'' '\''a,b,c'\'''
json 'c|a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a||a'\'' '\''a,b,c'\'''
json 'c|~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a||b'\'' '\''a,b,c'\'''
json 'c|~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a||~b'\'' '\''a,b,c'\'''
json 'c|~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a||~c'\'' '\''a,b,c'\'''
json 'c|~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|b||a'\'' '\''a,b,c'\'''
json 'c|b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b||a'\'' '\''a,b,c'\'''

echo '$ json '\''c|b||~a'\'' '\''a,b,c'\'''
json 'c|b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|b||~b'\'' '\''a,b,c'\'''
json 'c|b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|b||~c'\'' '\''a,b,c'\'''
json 'c|b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b||a'\'' '\''a,b,c'\'''
json 'c|~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b||~a'\'' '\''a,b,c'\'''
json 'c|~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b||b'\'' '\''a,b,c'\'''
json 'c|~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b||~c'\'' '\''a,b,c'\'''
json 'c|~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c||a'\'' '\''a,b,c'\'''
json 'c|~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c||~a'\'' '\''a,b,c'\'''
json 'c|~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c||b'\'' '\''a,b,c'\'''
json 'c|~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c||~b'\'' '\''a,b,c'\'''
json 'c|~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a||~a'\'' '\''a,b,c'\'''
json '~c|a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a||b'\'' '\''a,b,c'\'''
json '~c|a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a||~b'\'' '\''a,b,c'\'''
json '~c|a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a||c'\'' '\''a,b,c'\'''
json '~c|a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a||a'\'' '\''a,b,c'\'''
json '~c|~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a||b'\'' '\''a,b,c'\'''
json '~c|~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a||~b'\'' '\''a,b,c'\'''
json '~c|~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a||c'\'' '\''a,b,c'\'''
json '~c|~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b||a'\'' '\''a,b,c'\'''
json '~c|b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b||~a'\'' '\''a,b,c'\'''
json '~c|b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b||~b'\'' '\''a,b,c'\'''
json '~c|b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b||c'\'' '\''a,b,c'\'''
json '~c|b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b||a'\'' '\''a,b,c'\'''
json '~c|~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b||~a'\'' '\''a,b,c'\'''
json '~c|~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b||b'\'' '\''a,b,c'\'''
json '~c|~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b||c'\'' '\''a,b,c'\'''
json '~c|~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c||a'\'' '\''a,b,c'\'''
json '~c|c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c||~a'\'' '\''a,b,c'\'''
json '~c|c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c||b'\'' '\''a,b,c'\'''
json '~c|c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c||~b'\'' '\''a,b,c'\'''
json '~c|c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a b'\'' '\''a,b,c'\'''
json 'a||~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a ~b'\'' '\''a,b,c'\'''
json 'a||~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a c'\'' '\''a,b,c'\'''
json 'a||~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a ~c'\'' '\''a,b,c'\'''
json 'a||~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||b ~a'\'' '\''a,b,c'\'''
json 'a||b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||b ~b'\'' '\''a,b,c'\'''
json 'a||b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||b c'\'' '\''a,b,c'\'''
json 'a||b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b c'\'' '\''a,b,c'\'''

echo '$ json '\''a||b ~c'\'' '\''a,b,c'\'''
json 'a||b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b ~a'\'' '\''a,b,c'\'''
json 'a||~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b b'\'' '\''a,b,c'\'''
json 'a||~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b c'\'' '\''a,b,c'\'''
json 'a||~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b ~c'\'' '\''a,b,c'\'''
json 'a||~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||c ~a'\'' '\''a,b,c'\'''
json 'a||c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||c b'\'' '\''a,b,c'\'''
json 'a||c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c b'\'' '\''a,b,c'\'''

echo '$ json '\''a||c ~b'\'' '\''a,b,c'\'''
json 'a||c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||c ~c'\'' '\''a,b,c'\'''
json 'a||c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c ~a'\'' '\''a,b,c'\'''
json 'a||~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c b'\'' '\''a,b,c'\'''
json 'a||~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c ~b'\'' '\''a,b,c'\'''
json 'a||~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c c'\'' '\''a,b,c'\'''
json 'a||~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a b'\'' '\''a,b,c'\'''
json '~a||a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a ~b'\'' '\''a,b,c'\'''
json '~a||a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a c'\'' '\''a,b,c'\'''
json '~a||a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a ~c'\'' '\''a,b,c'\'''
json '~a||a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b a'\'' '\''a,b,c'\'''
json '~a||b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b ~b'\'' '\''a,b,c'\'''
json '~a||b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b c'\'' '\''a,b,c'\'''
json '~a||b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b ~c'\'' '\''a,b,c'\'''
json '~a||b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b a'\'' '\''a,b,c'\'''
json '~a||~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b b'\'' '\''a,b,c'\'''
json '~a||~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b c'\'' '\''a,b,c'\'''
json '~a||~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b ~c'\'' '\''a,b,c'\'''
json '~a||~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c a'\'' '\''a,b,c'\'''
json '~a||c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c b'\'' '\''a,b,c'\'''
json '~a||c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c ~b'\'' '\''a,b,c'\'''
json '~a||c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c ~c'\'' '\''a,b,c'\'''
json '~a||c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c a'\'' '\''a,b,c'\'''
json '~a||~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c b'\'' '\''a,b,c'\'''
json '~a||~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c ~b'\'' '\''a,b,c'\'''
json '~a||~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c c'\'' '\''a,b,c'\'''
json '~a||~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c c'\'' '\''a,b,c'\'''

echo '$ json '\''b||a ~a'\'' '\''a,b,c'\'''
json 'b||a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||a ~b'\'' '\''a,b,c'\'''
json 'b||a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||a c'\'' '\''a,b,c'\'''
json 'b||a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a c'\'' '\''a,b,c'\'''

echo '$ json '\''b||a ~c'\'' '\''a,b,c'\'''
json 'b||a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a a'\'' '\''a,b,c'\'''
json 'b||~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a ~b'\'' '\''a,b,c'\'''
json 'b||~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a c'\'' '\''a,b,c'\'''
json 'b||~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a ~c'\'' '\''a,b,c'\'''
json 'b||~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b a'\'' '\''a,b,c'\'''
json 'b||~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b ~a'\'' '\''a,b,c'\'''
json 'b||~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b c'\'' '\''a,b,c'\'''
json 'b||~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b ~c'\'' '\''a,b,c'\'''
json 'b||~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||c a'\'' '\''a,b,c'\'''
json 'b||c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c a'\'' '\''a,b,c'\'''

echo '$ json '\''b||c ~a'\'' '\''a,b,c'\'''
json 'b||c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||c ~b'\'' '\''a,b,c'\'''
json 'b||c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||c ~c'\'' '\''a,b,c'\'''
json 'b||c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c a'\'' '\''a,b,c'\'''
json 'b||~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c ~a'\'' '\''a,b,c'\'''
json 'b||~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c ~b'\'' '\''a,b,c'\'''
json 'b||~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c c'\'' '\''a,b,c'\'''
json 'b||~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a ~a'\'' '\''a,b,c'\'''
json '~b||a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a b'\'' '\''a,b,c'\'''
json '~b||a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a c'\'' '\''a,b,c'\'''
json '~b||a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a ~c'\'' '\''a,b,c'\'''
json '~b||a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a a'\'' '\''a,b,c'\'''
json '~b||~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a b'\'' '\''a,b,c'\'''
json '~b||~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a c'\'' '\''a,b,c'\'''
json '~b||~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a ~c'\'' '\''a,b,c'\'''
json '~b||~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b a'\'' '\''a,b,c'\'''
json '~b||b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b ~a'\'' '\''a,b,c'\'''
json '~b||b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b c'\'' '\''a,b,c'\'''
json '~b||b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b ~c'\'' '\''a,b,c'\'''
json '~b||b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c a'\'' '\''a,b,c'\'''
json '~b||c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c ~a'\'' '\''a,b,c'\'''
json '~b||c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c b'\'' '\''a,b,c'\'''
json '~b||c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c ~c'\'' '\''a,b,c'\'''
json '~b||c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c a'\'' '\''a,b,c'\'''
json '~b||~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c ~a'\'' '\''a,b,c'\'''
json '~b||~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c b'\'' '\''a,b,c'\'''
json '~b||~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c c'\'' '\''a,b,c'\'''
json '~b||~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c c'\'' '\''a,b,c'\'''

echo '$ json '\''c||a ~a'\'' '\''a,b,c'\'''
json 'c||a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||a b'\'' '\''a,b,c'\'''
json 'c||a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a b'\'' '\''a,b,c'\'''

echo '$ json '\''c||a ~b'\'' '\''a,b,c'\'''
json 'c||a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||a ~c'\'' '\''a,b,c'\'''
json 'c||a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a a'\'' '\''a,b,c'\'''
json 'c||~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a b'\'' '\''a,b,c'\'''
json 'c||~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a ~b'\'' '\''a,b,c'\'''
json 'c||~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a ~c'\'' '\''a,b,c'\'''
json 'c||~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||b a'\'' '\''a,b,c'\'''
json 'c||b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b a'\'' '\''a,b,c'\'''

echo '$ json '\''c||b ~a'\'' '\''a,b,c'\'''
json 'c||b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||b ~b'\'' '\''a,b,c'\'''
json 'c||b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||b ~c'\'' '\''a,b,c'\'''
json 'c||b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b a'\'' '\''a,b,c'\'''
json 'c||~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b ~a'\'' '\''a,b,c'\'''
json 'c||~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b b'\'' '\''a,b,c'\'''
json 'c||~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b ~c'\'' '\''a,b,c'\'''
json 'c||~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c a'\'' '\''a,b,c'\'''
json 'c||~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c ~a'\'' '\''a,b,c'\'''
json 'c||~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c b'\'' '\''a,b,c'\'''
json 'c||~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c ~b'\'' '\''a,b,c'\'''
json 'c||~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a ~a'\'' '\''a,b,c'\'''
json '~c||a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a b'\'' '\''a,b,c'\'''
json '~c||a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a ~b'\'' '\''a,b,c'\'''
json '~c||a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a c'\'' '\''a,b,c'\'''
json '~c||a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a a'\'' '\''a,b,c'\'''
json '~c||~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a b'\'' '\''a,b,c'\'''
json '~c||~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a ~b'\'' '\''a,b,c'\'''
json '~c||~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a c'\'' '\''a,b,c'\'''
json '~c||~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b a'\'' '\''a,b,c'\'''
json '~c||b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b ~a'\'' '\''a,b,c'\'''
json '~c||b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b ~b'\'' '\''a,b,c'\'''
json '~c||b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b c'\'' '\''a,b,c'\'''
json '~c||b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b a'\'' '\''a,b,c'\'''
json '~c||~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b ~a'\'' '\''a,b,c'\'''
json '~c||~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b b'\'' '\''a,b,c'\'''
json '~c||~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b c'\'' '\''a,b,c'\'''
json '~c||~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c a'\'' '\''a,b,c'\'''
json '~c||c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c ~a'\'' '\''a,b,c'\'''
json '~c||c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c b'\'' '\''a,b,c'\'''
json '~c||c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c ~b'\'' '\''a,b,c'\'''
json '~c||c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a|b'\'' '\''a,b,c'\'''
json 'a||~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a|~b'\'' '\''a,b,c'\'''
json 'a||~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a|c'\'' '\''a,b,c'\'''
json 'a||~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a|~c'\'' '\''a,b,c'\'''
json 'a||~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||b|~a'\'' '\''a,b,c'\'''
json 'a||b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||b|~b'\'' '\''a,b,c'\'''
json 'a||b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||b|c'\'' '\''a,b,c'\'''
json 'a||b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b|c'\'' '\''a,b,c'\'''

echo '$ json '\''a||b|~c'\'' '\''a,b,c'\'''
json 'a||b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b|~a'\'' '\''a,b,c'\'''
json 'a||~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b|b'\'' '\''a,b,c'\'''
json 'a||~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b|c'\'' '\''a,b,c'\'''
json 'a||~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b|~c'\'' '\''a,b,c'\'''
json 'a||~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||c|~a'\'' '\''a,b,c'\'''
json 'a||c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||c|b'\'' '\''a,b,c'\'''
json 'a||c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c|b'\'' '\''a,b,c'\'''

echo '$ json '\''a||c|~b'\'' '\''a,b,c'\'''
json 'a||c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||c|~c'\'' '\''a,b,c'\'''
json 'a||c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c|~a'\'' '\''a,b,c'\'''
json 'a||~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c|b'\'' '\''a,b,c'\'''
json 'a||~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c|~b'\'' '\''a,b,c'\'''
json 'a||~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c|c'\'' '\''a,b,c'\'''
json 'a||~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a|b'\'' '\''a,b,c'\'''
json '~a||a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a|~b'\'' '\''a,b,c'\'''
json '~a||a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a|c'\'' '\''a,b,c'\'''
json '~a||a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a|~c'\'' '\''a,b,c'\'''
json '~a||a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b|a'\'' '\''a,b,c'\'''
json '~a||b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b|~b'\'' '\''a,b,c'\'''
json '~a||b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b|c'\'' '\''a,b,c'\'''
json '~a||b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b|~c'\'' '\''a,b,c'\'''
json '~a||b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b|a'\'' '\''a,b,c'\'''
json '~a||~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b|b'\'' '\''a,b,c'\'''
json '~a||~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b|c'\'' '\''a,b,c'\'''
json '~a||~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b|~c'\'' '\''a,b,c'\'''
json '~a||~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c|a'\'' '\''a,b,c'\'''
json '~a||c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c|b'\'' '\''a,b,c'\'''
json '~a||c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c|~b'\'' '\''a,b,c'\'''
json '~a||c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c|~c'\'' '\''a,b,c'\'''
json '~a||c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c|a'\'' '\''a,b,c'\'''
json '~a||~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c|b'\'' '\''a,b,c'\'''
json '~a||~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c|~b'\'' '\''a,b,c'\'''
json '~a||~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c|c'\'' '\''a,b,c'\'''
json '~a||~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''b||a|~a'\'' '\''a,b,c'\'''
json 'b||a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||a|~b'\'' '\''a,b,c'\'''
json 'b||a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||a|c'\'' '\''a,b,c'\'''
json 'b||a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a|c'\'' '\''a,b,c'\'''

echo '$ json '\''b||a|~c'\'' '\''a,b,c'\'''
json 'b||a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a|a'\'' '\''a,b,c'\'''
json 'b||~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a|~b'\'' '\''a,b,c'\'''
json 'b||~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a|c'\'' '\''a,b,c'\'''
json 'b||~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a|~c'\'' '\''a,b,c'\'''
json 'b||~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b|a'\'' '\''a,b,c'\'''
json 'b||~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b|~a'\'' '\''a,b,c'\'''
json 'b||~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b|c'\'' '\''a,b,c'\'''
json 'b||~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b|~c'\'' '\''a,b,c'\'''
json 'b||~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||c|a'\'' '\''a,b,c'\'''
json 'b||c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c|a'\'' '\''a,b,c'\'''

echo '$ json '\''b||c|~a'\'' '\''a,b,c'\'''
json 'b||c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||c|~b'\'' '\''a,b,c'\'''
json 'b||c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||c|~c'\'' '\''a,b,c'\'''
json 'b||c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c|a'\'' '\''a,b,c'\'''
json 'b||~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c|~a'\'' '\''a,b,c'\'''
json 'b||~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c|~b'\'' '\''a,b,c'\'''
json 'b||~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c|c'\'' '\''a,b,c'\'''
json 'b||~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a|~a'\'' '\''a,b,c'\'''
json '~b||a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a|b'\'' '\''a,b,c'\'''
json '~b||a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a|c'\'' '\''a,b,c'\'''
json '~b||a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a|~c'\'' '\''a,b,c'\'''
json '~b||a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a|a'\'' '\''a,b,c'\'''
json '~b||~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a|b'\'' '\''a,b,c'\'''
json '~b||~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a|c'\'' '\''a,b,c'\'''
json '~b||~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a|~c'\'' '\''a,b,c'\'''
json '~b||~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b|a'\'' '\''a,b,c'\'''
json '~b||b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b|~a'\'' '\''a,b,c'\'''
json '~b||b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b|c'\'' '\''a,b,c'\'''
json '~b||b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b|~c'\'' '\''a,b,c'\'''
json '~b||b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c|a'\'' '\''a,b,c'\'''
json '~b||c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c|~a'\'' '\''a,b,c'\'''
json '~b||c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c|b'\'' '\''a,b,c'\'''
json '~b||c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c|~c'\'' '\''a,b,c'\'''
json '~b||c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c|a'\'' '\''a,b,c'\'''
json '~b||~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c|~a'\'' '\''a,b,c'\'''
json '~b||~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c|b'\'' '\''a,b,c'\'''
json '~b||~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c|c'\'' '\''a,b,c'\'''
json '~b||~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''c||a|~a'\'' '\''a,b,c'\'''
json 'c||a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||a|b'\'' '\''a,b,c'\'''
json 'c||a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a|b'\'' '\''a,b,c'\'''

echo '$ json '\''c||a|~b'\'' '\''a,b,c'\'''
json 'c||a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||a|~c'\'' '\''a,b,c'\'''
json 'c||a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a|a'\'' '\''a,b,c'\'''
json 'c||~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a|b'\'' '\''a,b,c'\'''
json 'c||~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a|~b'\'' '\''a,b,c'\'''
json 'c||~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a|~c'\'' '\''a,b,c'\'''
json 'c||~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||b|a'\'' '\''a,b,c'\'''
json 'c||b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b|a'\'' '\''a,b,c'\'''

echo '$ json '\''c||b|~a'\'' '\''a,b,c'\'''
json 'c||b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||b|~b'\'' '\''a,b,c'\'''
json 'c||b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||b|~c'\'' '\''a,b,c'\'''
json 'c||b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b|a'\'' '\''a,b,c'\'''
json 'c||~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b|~a'\'' '\''a,b,c'\'''
json 'c||~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b|b'\'' '\''a,b,c'\'''
json 'c||~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b|~c'\'' '\''a,b,c'\'''
json 'c||~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c|a'\'' '\''a,b,c'\'''
json 'c||~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c|~a'\'' '\''a,b,c'\'''
json 'c||~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c|b'\'' '\''a,b,c'\'''
json 'c||~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c|~b'\'' '\''a,b,c'\'''
json 'c||~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a|~a'\'' '\''a,b,c'\'''
json '~c||a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a|b'\'' '\''a,b,c'\'''
json '~c||a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a|~b'\'' '\''a,b,c'\'''
json '~c||a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a|c'\'' '\''a,b,c'\'''
json '~c||a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a|a'\'' '\''a,b,c'\'''
json '~c||~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a|b'\'' '\''a,b,c'\'''
json '~c||~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a|~b'\'' '\''a,b,c'\'''
json '~c||~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a|c'\'' '\''a,b,c'\'''
json '~c||~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b|a'\'' '\''a,b,c'\'''
json '~c||b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b|~a'\'' '\''a,b,c'\'''
json '~c||b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b|~b'\'' '\''a,b,c'\'''
json '~c||b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b|c'\'' '\''a,b,c'\'''
json '~c||b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b|a'\'' '\''a,b,c'\'''
json '~c||~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b|~a'\'' '\''a,b,c'\'''
json '~c||~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b|b'\'' '\''a,b,c'\'''
json '~c||~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b|c'\'' '\''a,b,c'\'''
json '~c||~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c|a'\'' '\''a,b,c'\'''
json '~c||c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c|~a'\'' '\''a,b,c'\'''
json '~c||c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c|b'\'' '\''a,b,c'\'''
json '~c||c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c|~b'\'' '\''a,b,c'\'''
json '~c||c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a||b'\'' '\''a,b,c'\'''
json 'a||~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a||~b'\'' '\''a,b,c'\'''
json 'a||~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a||c'\'' '\''a,b,c'\'''
json 'a||~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a||~c'\'' '\''a,b,c'\'''
json 'a||~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||b||~a'\'' '\''a,b,c'\'''
json 'a||b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||b||~b'\'' '\''a,b,c'\'''
json 'a||b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||b||c'\'' '\''a,b,c'\'''
json 'a||b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b||c'\'' '\''a,b,c'\'''

echo '$ json '\''a||b||~c'\'' '\''a,b,c'\'''
json 'a||b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b||~a'\'' '\''a,b,c'\'''
json 'a||~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b||b'\'' '\''a,b,c'\'''
json 'a||~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b||c'\'' '\''a,b,c'\'''
json 'a||~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b||~c'\'' '\''a,b,c'\'''
json 'a||~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||c||~a'\'' '\''a,b,c'\'''
json 'a||c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||c||b'\'' '\''a,b,c'\'''
json 'a||c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c||b'\'' '\''a,b,c'\'''

echo '$ json '\''a||c||~b'\'' '\''a,b,c'\'''
json 'a||c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||c||~c'\'' '\''a,b,c'\'''
json 'a||c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c||~a'\'' '\''a,b,c'\'''
json 'a||~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c||b'\'' '\''a,b,c'\'''
json 'a||~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c||~b'\'' '\''a,b,c'\'''
json 'a||~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c||c'\'' '\''a,b,c'\'''
json 'a||~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a||b'\'' '\''a,b,c'\'''
json '~a||a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a||~b'\'' '\''a,b,c'\'''
json '~a||a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a||c'\'' '\''a,b,c'\'''
json '~a||a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a||~c'\'' '\''a,b,c'\'''
json '~a||a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b||a'\'' '\''a,b,c'\'''
json '~a||b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b||~b'\'' '\''a,b,c'\'''
json '~a||b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b||c'\'' '\''a,b,c'\'''
json '~a||b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b||~c'\'' '\''a,b,c'\'''
json '~a||b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b||a'\'' '\''a,b,c'\'''
json '~a||~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b||b'\'' '\''a,b,c'\'''
json '~a||~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b||c'\'' '\''a,b,c'\'''
json '~a||~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b||~c'\'' '\''a,b,c'\'''
json '~a||~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c||a'\'' '\''a,b,c'\'''
json '~a||c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c||b'\'' '\''a,b,c'\'''
json '~a||c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c||~b'\'' '\''a,b,c'\'''
json '~a||c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c||~c'\'' '\''a,b,c'\'''
json '~a||c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c||a'\'' '\''a,b,c'\'''
json '~a||~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c||b'\'' '\''a,b,c'\'''
json '~a||~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c||~b'\'' '\''a,b,c'\'''
json '~a||~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c||c'\'' '\''a,b,c'\'''
json '~a||~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''b||a||~a'\'' '\''a,b,c'\'''
json 'b||a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||a||~b'\'' '\''a,b,c'\'''
json 'b||a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||a||c'\'' '\''a,b,c'\'''
json 'b||a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a||c'\'' '\''a,b,c'\'''

echo '$ json '\''b||a||~c'\'' '\''a,b,c'\'''
json 'b||a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a||a'\'' '\''a,b,c'\'''
json 'b||~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a||~b'\'' '\''a,b,c'\'''
json 'b||~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a||c'\'' '\''a,b,c'\'''
json 'b||~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a||~c'\'' '\''a,b,c'\'''
json 'b||~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b||a'\'' '\''a,b,c'\'''
json 'b||~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b||~a'\'' '\''a,b,c'\'''
json 'b||~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b||c'\'' '\''a,b,c'\'''
json 'b||~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b||~c'\'' '\''a,b,c'\'''
json 'b||~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||c||a'\'' '\''a,b,c'\'''
json 'b||c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c||a'\'' '\''a,b,c'\'''

echo '$ json '\''b||c||~a'\'' '\''a,b,c'\'''
json 'b||c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||c||~b'\'' '\''a,b,c'\'''
json 'b||c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||c||~c'\'' '\''a,b,c'\'''
json 'b||c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c||a'\'' '\''a,b,c'\'''
json 'b||~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c||~a'\'' '\''a,b,c'\'''
json 'b||~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c||~b'\'' '\''a,b,c'\'''
json 'b||~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c||c'\'' '\''a,b,c'\'''
json 'b||~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a||~a'\'' '\''a,b,c'\'''
json '~b||a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a||b'\'' '\''a,b,c'\'''
json '~b||a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a||c'\'' '\''a,b,c'\'''
json '~b||a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a||~c'\'' '\''a,b,c'\'''
json '~b||a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a||a'\'' '\''a,b,c'\'''
json '~b||~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a||b'\'' '\''a,b,c'\'''
json '~b||~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a||c'\'' '\''a,b,c'\'''
json '~b||~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a||~c'\'' '\''a,b,c'\'''
json '~b||~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b||a'\'' '\''a,b,c'\'''
json '~b||b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b||~a'\'' '\''a,b,c'\'''
json '~b||b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b||c'\'' '\''a,b,c'\'''
json '~b||b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b||~c'\'' '\''a,b,c'\'''
json '~b||b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c||a'\'' '\''a,b,c'\'''
json '~b||c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c||~a'\'' '\''a,b,c'\'''
json '~b||c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c||b'\'' '\''a,b,c'\'''
json '~b||c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c||~c'\'' '\''a,b,c'\'''
json '~b||c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c||a'\'' '\''a,b,c'\'''
json '~b||~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c||~a'\'' '\''a,b,c'\'''
json '~b||~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c||b'\'' '\''a,b,c'\'''
json '~b||~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c||c'\'' '\''a,b,c'\'''
json '~b||~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''c||a||~a'\'' '\''a,b,c'\'''
json 'c||a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||a||b'\'' '\''a,b,c'\'''
json 'c||a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a||b'\'' '\''a,b,c'\'''

echo '$ json '\''c||a||~b'\'' '\''a,b,c'\'''
json 'c||a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||a||~c'\'' '\''a,b,c'\'''
json 'c||a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a||a'\'' '\''a,b,c'\'''
json 'c||~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a||b'\'' '\''a,b,c'\'''
json 'c||~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a||~b'\'' '\''a,b,c'\'''
json 'c||~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a||~c'\'' '\''a,b,c'\'''
json 'c||~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||b||a'\'' '\''a,b,c'\'''
json 'c||b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b||a'\'' '\''a,b,c'\'''

echo '$ json '\''c||b||~a'\'' '\''a,b,c'\'''
json 'c||b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||b||~b'\'' '\''a,b,c'\'''
json 'c||b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||b||~c'\'' '\''a,b,c'\'''
json 'c||b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b||a'\'' '\''a,b,c'\'''
json 'c||~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b||~a'\'' '\''a,b,c'\'''
json 'c||~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b||b'\'' '\''a,b,c'\'''
json 'c||~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b||~c'\'' '\''a,b,c'\'''
json 'c||~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c||a'\'' '\''a,b,c'\'''
json 'c||~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c||~a'\'' '\''a,b,c'\'''
json 'c||~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c||b'\'' '\''a,b,c'\'''
json 'c||~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c||~b'\'' '\''a,b,c'\'''
json 'c||~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a||~a'\'' '\''a,b,c'\'''
json '~c||a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a||b'\'' '\''a,b,c'\'''
json '~c||a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a||~b'\'' '\''a,b,c'\'''
json '~c||a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a||c'\'' '\''a,b,c'\'''
json '~c||a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a||a'\'' '\''a,b,c'\'''
json '~c||~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a||b'\'' '\''a,b,c'\'''
json '~c||~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a||~b'\'' '\''a,b,c'\'''
json '~c||~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a||c'\'' '\''a,b,c'\'''
json '~c||~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b||a'\'' '\''a,b,c'\'''
json '~c||b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b||~a'\'' '\''a,b,c'\'''
json '~c||b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b||~b'\'' '\''a,b,c'\'''
json '~c||b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b||c'\'' '\''a,b,c'\'''
json '~c||b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b||a'\'' '\''a,b,c'\'''
json '~c||~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b||~a'\'' '\''a,b,c'\'''
json '~c||~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b||b'\'' '\''a,b,c'\'''
json '~c||~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b||c'\'' '\''a,b,c'\'''
json '~c||~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c||a'\'' '\''a,b,c'\'''
json '~c||c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c||~a'\'' '\''a,b,c'\'''
json '~c||c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c||b'\'' '\''a,b,c'\'''
json '~c||c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c||~b'\'' '\''a,b,c'\'''
json '~c||c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c||~b'\'' '\''a,b,c'\'''
)

