#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C trie:sgb-words
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L sgb-words.old <(echo \
'$ test -x ../lib/test-trie
$ print() { printf '\''%s\n'\'' "$@"; }
$ set -o pipefail
$ wc -l < sgb-words.txt
5757
$ test-trie() { set -o pipefail && ../lib/test-trie -p 2M -D < sgb-words.txt; }
$ test-trie
iter:     29
sib-iter: 14
lvl-iter: 5757
$ test-trie() { set -o pipefail && ../lib/test-trie -p 2M -T "$@" < sgb-words.txt 2>&1 >/dev/null|sed -r '\''/fatal error:/{s|(fatal error: )\s*\./+|\1|;s/:[0-9]+:/:???:/}'\''; }
$ test-trie -l 5756
test-trie: fatal error: trie-impl.h:???:test_trie_lvl_iterator_inc: stack overflow
command failed: test-trie -l 5756
$ test-trie -l 5757'
) -L sgb-words.new <(
echo '$ test -x ../lib/test-trie'
test -x ../lib/test-trie 2>&1 ||
echo 'command failed: test -x ../lib/test-trie'

echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ wc -l < sgb-words.txt'
wc -l < sgb-words.txt 2>&1 ||
echo 'command failed: wc -l < sgb-words.txt'

echo '$ test-trie() { set -o pipefail && ../lib/test-trie -p 2M -D < sgb-words.txt; }'
test-trie() { set -o pipefail && ../lib/test-trie -p 2M -D < sgb-words.txt; } 2>&1 ||
echo 'command failed: test-trie() { set -o pipefail && ../lib/test-trie -p 2M -D < sgb-words.txt; }'

echo '$ test-trie'
test-trie 2>&1 ||
echo 'command failed: test-trie'

echo '$ test-trie() { set -o pipefail && ../lib/test-trie -p 2M -T "$@" < sgb-words.txt 2>&1 >/dev/null|sed -r '\''/fatal error:/{s|(fatal error: )\s*\./+|\1|;s/:[0-9]+:/:???:/}'\''; }'
test-trie() { set -o pipefail && ../lib/test-trie -p 2M -T "$@" < sgb-words.txt 2>&1 >/dev/null|sed -r '/fatal error:/{s|(fatal error: )\s*\./+|\1|;s/:[0-9]+:/:???:/}'; } 2>&1 ||
echo 'command failed: test-trie() { set -o pipefail && ../lib/test-trie -p 2M -T "$@" < sgb-words.txt 2>&1 >/dev/null|sed -r '\''/fatal error:/{s|(fatal error: )\s*\./+|\1|;s/:[0-9]+:/:???:/}'\''; }'

echo '$ test-trie -l 5756'
test-trie -l 5756 2>&1 ||
echo 'command failed: test-trie -l 5756'

echo '$ test-trie -l 5757'
test-trie -l 5757 2>&1 ||
echo 'command failed: test-trie -l 5757'
)

