#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -w51 -G type-gen-def-gcc
#

w=51
c=""
q=""

if [[ "$1" =~ ^-w[1-9][0-9]*$ ]]; then
    w="${1:2}"
    shift
fi
if [ "$1" == "-c" ]; then
    c="c"
    shift
fi
if [ "$1" == "-q" ]; then
    q="q"
fi

p=0
f=0

for t in \
    node-any \
    node-plain \
    node-object-any \
    node-object-any2 \
    node-dict-any \
    node-dict-any2 \
    node-open-array-any \
    node-open-array-plain \
    node-open-array-object-any \
    node-open-array-object-any2 \
    node-open-array-object-plain \
    node-open-array-object-plain2 \
    node-open-array-dict-any \
    node-open-array-dict-any2 \
    node-open-array-dict-plain \
    node-open-array-dict-plain2 \
    node-closed-array-empty \
    node-closed-array-any \
    node-closed-array-any2 \
    node-closed-array-plain \
    node-closed-array-plain2 \
    node-closed-array-object-any \
    node-closed-array-object-any2 \
    node-closed-array-object-any3 \
    node-closed-array-dict-any \
    node-closed-array-dict-any2 \
    node-closed-array-dict-any3 \
    node-closed-array-open-array-any \
    node-closed-array-open-array-any2 \
    node-open-array-closed-array-empty \
    node-open-array-closed-array-any \
    node-open-array-closed-array-any2 \
    node-object-open-array-any \
    node-object-open-array-any2 \
    node-object-closed-array-empty \
    node-object-closed-array-any \
    node-object-closed-array-any2 \
    node-dict-open-array-any \
    node-dict-open-array-any2 \
    node-dict-closed-array-empty \
    node-dict-closed-array-any \
    node-dict-closed-array-any2 \
    node-list-empty \
    node-list-any \
    node-list-any2 \
    node-list-plain \
    node-list-plain2 \
    node-list-object-any \
    node-list-object-any2 \
    node-list-dict-any \
    node-list-dict-any2 \
    node-list-open-array-any \
    node-list-open-array-any2 \
    node-list-closed-array-any \
    node-list-closed-array-any2 \
    node-object-list-any \
    node-object-list-any2 \
    node-dict-list-any \
    node-dict-list-any2 \
    node-open-array-list-empty \
    node-open-array-list-any \
    node-open-array-list-any2 \
    node-closed-array-list-any \
    node-closed-array-list-any2 \
    node-dict-expr \
    node-dict-expr2 \
    defs \
    json-type
do
    test -z "$q" &&
    printf >&2 "%-$((w + 6))s " "test: type-gen-def-gcc:$t"
    if ! type-gen-def-gcc/test-$t.sh &>/dev/null; then
        (( f ++ ))

        test -n "$q" &&
        echo >&2 -n "test: type-gen-def-gcc:$t "
        echo >&2 failed
    else
        (( p ++ ))

        test -z "$q" &&
        echo >&2 OK
    fi
done

if [ -z "$c" ]; then
    [ -z "$q" -o "$f" -gt 0 ] &&
    echo >&2
    echo "tests passed: $p"
    echo "tests failed: $f"
else
    echo "$p"
    echo "$f"
fi

exit $(( f != 0 ))

