#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict-expr-const
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr-const.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }
$ json '\''0'\''
000
$ json '\''1'\''
111
$ json '\''~0'\''
111
$ json '\''~1'\''
000
$ json '\''0&0'\''
000
$ json '\''0&1'\''
000
$ json '\''1&0'\''
000
$ json '\''1&1'\''
111
$ json '\''00'\''
000
$ json '\''01'\''
000
$ json '\''10'\''
000
$ json '\''11'\''
111
$ json '\''0|0'\''
000
$ json '\''0|1'\''
111
$ json '\''1|0'\''
111
$ json '\''1|1'\''
111
$ json '\''(0)'\''
000
$ json '\''(1)'\''
111
$ json '\''~(0)'\''
111
$ json '\''~(1)'\''
000
$ json '\''(0&0)'\''
000
$ json '\''(0&1)'\''
000
$ json '\''(1&0)'\''
000
$ json '\''(1&1)'\''
111
$ json '\''~(0&0)'\''
111
$ json '\''~(0&1)'\''
111
$ json '\''~(1&0)'\''
111
$ json '\''~(1&1)'\''
000
$ json '\''(00)'\''
000
$ json '\''(01)'\''
000
$ json '\''(10)'\''
000
$ json '\''(11)'\''
111
$ json '\''~(00)'\''
111
$ json '\''~(01)'\''
111
$ json '\''~(10)'\''
111
$ json '\''~(11)'\''
000
$ json '\''(0 0)'\''
000
$ json '\''(0 1)'\''
000
$ json '\''(1 0)'\''
000
$ json '\''(1 1)'\''
111
$ json '\''~(0 0)'\''
111
$ json '\''~(0 1)'\''
111
$ json '\''~(1 0)'\''
111
$ json '\''~(1 1)'\''
000
$ json '\''(0|0)'\''
000
$ json '\''(0|1)'\''
111
$ json '\''(1|0)'\''
111
$ json '\''(1|1)'\''
111
$ json '\''~(0|0)'\''
111
$ json '\''~(0|1)'\''
000
$ json '\''~(1|0)'\''
000
$ json '\''~(1|1)'\''
000
$ json '\''0||0'\''
000
000
$ json '\''0||~0'\''
000
111
$ json '\''~0||0'\''
111
000
$ json '\''~0||~0'\''
111
111
$ json '\''0||1'\''
000
111
$ json '\''0||~1'\''
000
000
$ json '\''~0||1'\''
111
111
$ json '\''~0||~1'\''
111
000
$ json '\''1||0'\''
111
000
$ json '\''1||~0'\''
111
111
$ json '\''~1||0'\''
000
000
$ json '\''~1||~0'\''
000
111
$ json '\''1||1'\''
111
111
$ json '\''1||~1'\''
111
000
$ json '\''~1||1'\''
000
111
$ json '\''~1||~1'\''
000
000'
) -L dict-expr-const.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'$'\n"'"$1"'"}'|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr 's|^/attr/expr/bits=||p'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }'

echo '$ json '\''0'\'''
json '0' 2>&1 ||
echo 'command failed: json '\''0'\'''

echo '$ json '\''1'\'''
json '1' 2>&1 ||
echo 'command failed: json '\''1'\'''

echo '$ json '\''~0'\'''
json '~0' 2>&1 ||
echo 'command failed: json '\''~0'\'''

echo '$ json '\''~1'\'''
json '~1' 2>&1 ||
echo 'command failed: json '\''~1'\'''

echo '$ json '\''0&0'\'''
json '0&0' 2>&1 ||
echo 'command failed: json '\''0&0'\'''

echo '$ json '\''0&1'\'''
json '0&1' 2>&1 ||
echo 'command failed: json '\''0&1'\'''

echo '$ json '\''1&0'\'''
json '1&0' 2>&1 ||
echo 'command failed: json '\''1&0'\'''

echo '$ json '\''1&1'\'''
json '1&1' 2>&1 ||
echo 'command failed: json '\''1&1'\'''

echo '$ json '\''00'\'''
json '00' 2>&1 ||
echo 'command failed: json '\''00'\'''

echo '$ json '\''01'\'''
json '01' 2>&1 ||
echo 'command failed: json '\''01'\'''

echo '$ json '\''10'\'''
json '10' 2>&1 ||
echo 'command failed: json '\''10'\'''

echo '$ json '\''11'\'''
json '11' 2>&1 ||
echo 'command failed: json '\''11'\'''

echo '$ json '\''0|0'\'''
json '0|0' 2>&1 ||
echo 'command failed: json '\''0|0'\'''

echo '$ json '\''0|1'\'''
json '0|1' 2>&1 ||
echo 'command failed: json '\''0|1'\'''

echo '$ json '\''1|0'\'''
json '1|0' 2>&1 ||
echo 'command failed: json '\''1|0'\'''

echo '$ json '\''1|1'\'''
json '1|1' 2>&1 ||
echo 'command failed: json '\''1|1'\'''

echo '$ json '\''(0)'\'''
json '(0)' 2>&1 ||
echo 'command failed: json '\''(0)'\'''

echo '$ json '\''(1)'\'''
json '(1)' 2>&1 ||
echo 'command failed: json '\''(1)'\'''

echo '$ json '\''~(0)'\'''
json '~(0)' 2>&1 ||
echo 'command failed: json '\''~(0)'\'''

echo '$ json '\''~(1)'\'''
json '~(1)' 2>&1 ||
echo 'command failed: json '\''~(1)'\'''

echo '$ json '\''(0&0)'\'''
json '(0&0)' 2>&1 ||
echo 'command failed: json '\''(0&0)'\'''

echo '$ json '\''(0&1)'\'''
json '(0&1)' 2>&1 ||
echo 'command failed: json '\''(0&1)'\'''

echo '$ json '\''(1&0)'\'''
json '(1&0)' 2>&1 ||
echo 'command failed: json '\''(1&0)'\'''

echo '$ json '\''(1&1)'\'''
json '(1&1)' 2>&1 ||
echo 'command failed: json '\''(1&1)'\'''

echo '$ json '\''~(0&0)'\'''
json '~(0&0)' 2>&1 ||
echo 'command failed: json '\''~(0&0)'\'''

echo '$ json '\''~(0&1)'\'''
json '~(0&1)' 2>&1 ||
echo 'command failed: json '\''~(0&1)'\'''

echo '$ json '\''~(1&0)'\'''
json '~(1&0)' 2>&1 ||
echo 'command failed: json '\''~(1&0)'\'''

echo '$ json '\''~(1&1)'\'''
json '~(1&1)' 2>&1 ||
echo 'command failed: json '\''~(1&1)'\'''

echo '$ json '\''(00)'\'''
json '(00)' 2>&1 ||
echo 'command failed: json '\''(00)'\'''

echo '$ json '\''(01)'\'''
json '(01)' 2>&1 ||
echo 'command failed: json '\''(01)'\'''

echo '$ json '\''(10)'\'''
json '(10)' 2>&1 ||
echo 'command failed: json '\''(10)'\'''

echo '$ json '\''(11)'\'''
json '(11)' 2>&1 ||
echo 'command failed: json '\''(11)'\'''

echo '$ json '\''~(00)'\'''
json '~(00)' 2>&1 ||
echo 'command failed: json '\''~(00)'\'''

echo '$ json '\''~(01)'\'''
json '~(01)' 2>&1 ||
echo 'command failed: json '\''~(01)'\'''

echo '$ json '\''~(10)'\'''
json '~(10)' 2>&1 ||
echo 'command failed: json '\''~(10)'\'''

echo '$ json '\''~(11)'\'''
json '~(11)' 2>&1 ||
echo 'command failed: json '\''~(11)'\'''

echo '$ json '\''(0 0)'\'''
json '(0 0)' 2>&1 ||
echo 'command failed: json '\''(0 0)'\'''

echo '$ json '\''(0 1)'\'''
json '(0 1)' 2>&1 ||
echo 'command failed: json '\''(0 1)'\'''

echo '$ json '\''(1 0)'\'''
json '(1 0)' 2>&1 ||
echo 'command failed: json '\''(1 0)'\'''

echo '$ json '\''(1 1)'\'''
json '(1 1)' 2>&1 ||
echo 'command failed: json '\''(1 1)'\'''

echo '$ json '\''~(0 0)'\'''
json '~(0 0)' 2>&1 ||
echo 'command failed: json '\''~(0 0)'\'''

echo '$ json '\''~(0 1)'\'''
json '~(0 1)' 2>&1 ||
echo 'command failed: json '\''~(0 1)'\'''

echo '$ json '\''~(1 0)'\'''
json '~(1 0)' 2>&1 ||
echo 'command failed: json '\''~(1 0)'\'''

echo '$ json '\''~(1 1)'\'''
json '~(1 1)' 2>&1 ||
echo 'command failed: json '\''~(1 1)'\'''

echo '$ json '\''(0|0)'\'''
json '(0|0)' 2>&1 ||
echo 'command failed: json '\''(0|0)'\'''

echo '$ json '\''(0|1)'\'''
json '(0|1)' 2>&1 ||
echo 'command failed: json '\''(0|1)'\'''

echo '$ json '\''(1|0)'\'''
json '(1|0)' 2>&1 ||
echo 'command failed: json '\''(1|0)'\'''

echo '$ json '\''(1|1)'\'''
json '(1|1)' 2>&1 ||
echo 'command failed: json '\''(1|1)'\'''

echo '$ json '\''~(0|0)'\'''
json '~(0|0)' 2>&1 ||
echo 'command failed: json '\''~(0|0)'\'''

echo '$ json '\''~(0|1)'\'''
json '~(0|1)' 2>&1 ||
echo 'command failed: json '\''~(0|1)'\'''

echo '$ json '\''~(1|0)'\'''
json '~(1|0)' 2>&1 ||
echo 'command failed: json '\''~(1|0)'\'''

echo '$ json '\''~(1|1)'\'''
json '~(1|1)' 2>&1 ||
echo 'command failed: json '\''~(1|1)'\'''

echo '$ json '\''0||0'\'''
json '0||0' 2>&1 ||
echo 'command failed: json '\''0||0'\'''

echo '$ json '\''0||~0'\'''
json '0||~0' 2>&1 ||
echo 'command failed: json '\''0||~0'\'''

echo '$ json '\''~0||0'\'''
json '~0||0' 2>&1 ||
echo 'command failed: json '\''~0||0'\'''

echo '$ json '\''~0||~0'\'''
json '~0||~0' 2>&1 ||
echo 'command failed: json '\''~0||~0'\'''

echo '$ json '\''0||1'\'''
json '0||1' 2>&1 ||
echo 'command failed: json '\''0||1'\'''

echo '$ json '\''0||~1'\'''
json '0||~1' 2>&1 ||
echo 'command failed: json '\''0||~1'\'''

echo '$ json '\''~0||1'\'''
json '~0||1' 2>&1 ||
echo 'command failed: json '\''~0||1'\'''

echo '$ json '\''~0||~1'\'''
json '~0||~1' 2>&1 ||
echo 'command failed: json '\''~0||~1'\'''

echo '$ json '\''1||0'\'''
json '1||0' 2>&1 ||
echo 'command failed: json '\''1||0'\'''

echo '$ json '\''1||~0'\'''
json '1||~0' 2>&1 ||
echo 'command failed: json '\''1||~0'\'''

echo '$ json '\''~1||0'\'''
json '~1||0' 2>&1 ||
echo 'command failed: json '\''~1||0'\'''

echo '$ json '\''~1||~0'\'''
json '~1||~0' 2>&1 ||
echo 'command failed: json '\''~1||~0'\'''

echo '$ json '\''1||1'\'''
json '1||1' 2>&1 ||
echo 'command failed: json '\''1||1'\'''

echo '$ json '\''1||~1'\'''
json '1||~1' 2>&1 ||
echo 'command failed: json '\''1||~1'\'''

echo '$ json '\''~1||1'\'''
json '~1||1' 2>&1 ||
echo 'command failed: json '\''~1||1'\'''

echo '$ json '\''~1||~1'\'''
json '~1||~1' 2>&1 ||
echo 'command failed: json '\''~1||~1'\'''
)

