#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array-list3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array-list3.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]'
) -L open-array-list3.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array"]}}'\'' <<< '\''[[],[]]'\'''
)

