#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-basic-object-basic-val-object-basic-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-basic-object-basic-val-object-basic-basic2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
{"faa":[{}],"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
{"faa":[{}],"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
{"faa":[{}],"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
{"faa":[{}],"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
{"faa":[{}],"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
{"faa":[{}],"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
{"faa":[{}],"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
{"faa":null,"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
{"faa":null,"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
{"faa":null,"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
{"faa":null,"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
{"faa":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
{"faa":null,"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
{"faa":null,"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
{"faa":false,"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
{"faa":false,"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
{"faa":false,"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
{"faa":false,"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
{"faa":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
{"faa":false,"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
{"faa":false,"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
{"faa":456,"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
{"faa":456,"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
{"faa":456,"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
{"faa":456,"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
{"faa":456,"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
{"faa":456,"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
{"faa":456,"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
{"faa":"bar","baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
{"faa":"bar","baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
{"faa":"bar","baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
{"faa":"bar","baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
{"faa":"bar","baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
{"faa":"bar","baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
{"faa":"bar","baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
{"faa":{},"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
{"faa":{},"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
{"faa":{},"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
{"faa":{},"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
{"faa":{},"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
{"faa":{},"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
{"faa":{},"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
{"faa":[],"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
{"faa":[],"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
{"faa":[],"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
{"faa":[],"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
{"faa":[],"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
{"faa":[],"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
{"faa":[],"baa":[]}
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
{"faa":[{}],"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
{"faa":[{}],"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
{"faa":[{}],"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
{"faa":[{}],"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
{"faa":[{}],"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
{"faa":[{}],"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
{"faa":[{}],"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
{"faa":null,"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
{"faa":null,"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
{"faa":null,"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
{"faa":null,"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
{"faa":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
{"faa":null,"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
{"faa":null,"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
{"faa":false,"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
{"faa":false,"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
{"faa":false,"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
{"faa":false,"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
{"faa":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
{"faa":false,"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
{"faa":false,"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
{"faa":456,"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
{"faa":456,"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
{"faa":456,"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
{"faa":456,"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
{"faa":456,"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
{"faa":456,"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
{"faa":456,"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
{"faa":"bar","baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
{"faa":"bar","baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
{"faa":"bar","baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
{"faa":"bar","baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
{"faa":"bar","baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
{"faa":"bar","baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
{"faa":"bar","baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
{"faa":{},"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
{"faa":{},"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
{"faa":{},"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
{"faa":{},"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
{"faa":{},"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
{"faa":{},"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
{"faa":{},"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
{"faa":[],"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
{"faa":[],"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
{"faa":[],"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
{"faa":[],"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
{"faa":[],"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
{"faa":[],"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
{"faa":[],"baa":[]}
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":[{}]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":456,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":456
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"bar","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"bar"
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":{},"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":{}
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":null}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":false}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":true}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":123}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":{}}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"faa":[],"baa":[]}
json: error: <stdin>:1:10:          ^
{"faa":[]
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
) -L list-basic-object-basic-val-object-basic-basic2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
)

