#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:38
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 38.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ norm-err() { sed -r '\''s|json\.so: fatal error:|\n\0|'\''; }
$ dict-gen() { ../lib/test-gen --dict --depth=1 "$@"; }
$ json -t <(dict-gen -T -k64 -e '\''~`63`'\'') -OV <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61" and "62"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
command failed: json -t <(dict-gen -T -k64 -e '\''~`63`'\'') -OV <<< '\''{}'\''
$ json -t <(dict-gen -T -k65 -e '\''~`64`'\'') -OV <<< '\''{}'\'' 2>&1|norm-err
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62" and "63"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
command failed: json -t <(dict-gen -T -k65 -e '\''~`64`'\'') -OV <<< '\''{}'\'' 2>&1|norm-err
$ dict-gen -V -k63|json -t <(dict-gen -T -k64 -e '\''~`63`'\'') -OV && echo OK
OK
$ set -o pipefail && dict-gen -V -k64|json -t <(dict-gen -T -k65 -e '\''~`64`'\'') -OV && echo OK
OK'
) -L 38.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ norm-err() { sed -r '\''s|json\.so: fatal error:|\n\0|'\''; }'
norm-err() { sed -r 's|json\.so: fatal error:|\n\0|'; } 2>&1 ||
echo 'command failed: norm-err() { sed -r '\''s|json\.so: fatal error:|\n\0|'\''; }'

echo '$ dict-gen() { ../lib/test-gen --dict --depth=1 "$@"; }'
dict-gen() { ../lib/test-gen --dict --depth=1 "$@"; } 2>&1 ||
echo 'command failed: dict-gen() { ../lib/test-gen --dict --depth=1 "$@"; }'

echo '$ json -t <(dict-gen -T -k64 -e '\''~`63`'\'') -OV <<< '\''{}'\'''
json -t <(dict-gen -T -k64 -e '~`63`') -OV <<< '{}' 2>&1 ||
echo 'command failed: json -t <(dict-gen -T -k64 -e '\''~`63`'\'') -OV <<< '\''{}'\'''

echo '$ json -t <(dict-gen -T -k65 -e '\''~`64`'\'') -OV <<< '\''{}'\'' 2>&1|norm-err'
json -t <(dict-gen -T -k65 -e '~`64`') -OV <<< '{}' 2>&1|norm-err 2>&1 ||
echo 'command failed: json -t <(dict-gen -T -k65 -e '\''~`64`'\'') -OV <<< '\''{}'\'' 2>&1|norm-err'

echo '$ dict-gen -V -k63|json -t <(dict-gen -T -k64 -e '\''~`63`'\'') -OV && echo OK'
dict-gen -V -k63|json -t <(dict-gen -T -k64 -e '~`63`') -OV && echo OK 2>&1 ||
echo 'command failed: dict-gen -V -k63|json -t <(dict-gen -T -k64 -e '\''~`63`'\'') -OV && echo OK'

echo '$ set -o pipefail && dict-gen -V -k64|json -t <(dict-gen -T -k65 -e '\''~`64`'\'') -OV && echo OK'
set -o pipefail && dict-gen -V -k64|json -t <(dict-gen -T -k65 -e '~`64`') -OV && echo OK 2>&1 ||
echo 'command failed: set -o pipefail && dict-gen -V -k64|json -t <(dict-gen -T -k65 -e '\''~`64`'\'') -OV && echo OK'
)

