#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:list5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list5.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''[]'\'''
) -L list5.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":false}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":false}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":true}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":true}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":123}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":123}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":null},{"plain":"foo"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"plain":"foo"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":null}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":null}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":true}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":true}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":123}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":123}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":false},{"plain":"foo"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"plain":"foo"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":null}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":null}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":false}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":false}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":123}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":123}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":true},{"plain":"foo"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"plain":"foo"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":null}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":null}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":false}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":false}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":true}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":true}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":123},{"plain":"foo"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"plain":"foo"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":null}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":null}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":false}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":false}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":true}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":true}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"plain":123}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"plain":123}]}'\'' <<< '\''[]'\'''
)

