#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-plain-basic-val-object-basic-basic3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-plain-basic-val-object-basic-basic3.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
{"faa":null,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
{"faa":null,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
{"faa":null,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
{"faa":null,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
{"faa":null,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
{"faa":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
{"faa":null,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
{"faa":null,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
{"faa":null,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
{"faa":null,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
{"faa":null,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
{"faa":null,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
{"faa":null,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
{"faa":null,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
{"faa":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
{"faa":null,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
{"faa":null,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
{"faa":null,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
{"faa":false,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
{"faa":false,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
{"faa":false,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
{"faa":false,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
{"faa":false,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
{"faa":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
{"faa":false,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
{"faa":false,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
{"faa":false,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
{"faa":false,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
{"faa":false,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
{"faa":false,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
{"faa":false,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
{"faa":false,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
{"faa":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
{"faa":false,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
{"faa":false,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
{"faa":false,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
{"faa":true,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
{"faa":true,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
{"faa":true,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
{"faa":true,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
{"faa":true,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
{"faa":true,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
{"faa":true,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
{"faa":true,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
{"faa":true,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
{"faa":true,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
{"faa":true,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
{"faa":true,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
{"faa":true,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
{"faa":true,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
{"faa":true,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
{"faa":true,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
{"faa":true,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":456}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":true,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":true,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
{"faa":true,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
{"faa":123,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
{"faa":123,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
{"faa":123,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
{"faa":123,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
{"faa":123,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
{"faa":123,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
{"faa":123,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
{"faa":123,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
{"faa":123,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
{"faa":123,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
{"faa":123,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
{"faa":123,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
{"faa":123,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
{"faa":123,"baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
{"faa":123,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
{"faa":123,"baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
{"faa":123,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":456}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":123,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":123,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
{"faa":123,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
{"faa":"foo","baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
{"faa":"foo","baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
{"faa":"foo","baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
{"faa":"foo","baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
{"faa":"foo","baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
{"faa":"foo","baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
{"faa":"foo","baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
{"faa":"foo","baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
{"faa":"foo","baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
{"faa":"foo","baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
{"faa":"foo","baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
{"faa":"foo","baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
{"faa":"foo","baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
{"faa":"foo","baa":456}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
{"faa":"foo","baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
{"faa":"foo","baa":"bar"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
{"faa":"foo","baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":456}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"foo","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"foo","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
{"faa":"foo","baa":[]}'
) -L list-object-plain-basic-val-object-basic-basic3.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
)

