/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 17-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */
import java.util.Random;
/**
 * <p>Alla fine del turno di ogni giocatore, ad esso gli viene
 * data una carta se durante la fase di attacco (o quella di
 * difesa del turno precedente) ha conquistato almeno un
 * territorio.</p>
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class DistributoreCarte {
    /** Contiene un numero casuale */
    private static final Random rand = new Random();
    
    /**
     * Estrae in modo casuale una stringa valida come nome
     * per una carta.
     * 
     * @return <code>String</code> contenente una carta casuale
     */
    private static String estraiCartaDalMazzo() {
        int pos = rand.nextInt(ElencoCarte.CARTE.length);
        return ElencoCarte.CARTE[pos];
    }
    /**
     * Distribuisce una carta a un giocatore che abbia
     * conquistato almeno un territorio durante il suo
     * turno di attacco (o il precedente turno di difesa).
     * 
     * @param g <code>Giocatore</code> al quale dare la carta
     * @return <code>true</code> se al giocatore viene data
     * una carta
     */
    public static boolean daiCarta(Giocatore g) {
        if(g.getPuoPescare()) {
            g.aggiungiCarta(estraiCartaDalMazzo());
            g.setPuoPescare(false);
            return true;
        }
        return false;
    }
}
