import java.io.IOException;

/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 19-mar-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

/**
 * Comando che stampa la versione corrente del programma.
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class ComandoVersione extends Comando {
    /** Nome del comando */
    private final String nomeComando = "versione";
    /** Versione del software */
    private final byte versione[] = {1,0,1};
    /* (non-Javadoc)
     * @see Comando#getNomeComando()
     */
    public String getNomeComando() {
        return this.nomeComando;
    }

    /* (non-Javadoc)
     * @see Comando#esegui(Giocatore, Tabellone)
     */
    public boolean esegui(Giocatore giocatore, Tabellone planisfero)
            throws IOException {
        StringBuffer ver = new StringBuffer();
        
        for(int i=0; i<versione.length; i++) {
            ver.append(versione[i]);
            if(i < (versione.length-1))
                ver.append(".");
        }
        
        giocatore.schermo.stampaln("jrisk " + ver + "\nCopyright  2005 Alessio Treglia");
        
        return false;
    }

}
