/*
 * Decompiled with CFR 0.152.
 */
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

class Lettore
extends FilterReader {
    private char next = '\u0000';
    public static Lettore in = new Lettore();

    public Lettore() {
        this(new InputStreamReader(System.in));
    }

    public Lettore(String s) {
        this(new StringReader(Lettore.termina(s)));
    }

    private static String termina(String s) {
        int lunghezza;
        if (s != null && (lunghezza = s.length()) > 0 && s.charAt(lunghezza - 1) != '\n') {
            s = String.valueOf(s) + '\n';
        }
        return s;
    }

    public Lettore(Reader rdr) {
        super(rdr);
    }

    public String leggiToken() {
        StringBuffer token = new StringBuffer();
        this.skipWhite();
        char ch = this.get();
        while (!Lettore.isWhite(ch)) {
            token.append(ch);
            ch = this.get();
        }
        return token.toString();
    }

    public String leggiString() {
        return this.leggiToken();
    }

    public char leggiChar() {
        while (this.eoln()) {
            this.skipEOLN();
        }
        return this.get();
    }

    public long leggiLong() {
        long numero;
        String token = this.leggiToken();
        try {
            numero = Long.parseLong(token);
        }
        catch (NumberFormatException e) {
            numero = 0L;
        }
        return numero;
    }

    public int leggiInt() {
        return (int)this.leggiLong();
    }

    public short leggiShort() {
        return (short)this.leggiLong();
    }

    public float leggiFloat() {
        float numero;
        String token = this.leggiToken();
        try {
            numero = new Float(token).floatValue();
        }
        catch (NumberFormatException e) {
            numero = 0.0f;
        }
        return numero;
    }

    public double leggiDouble() {
        double numero;
        String token = this.leggiToken();
        try {
            numero = new Double(token);
        }
        catch (NumberFormatException e) {
            numero = 0.0;
        }
        return numero;
    }

    public boolean leggiBoolean() {
        boolean b;
        String token = this.leggiToken();
        try {
            b = new Boolean(token);
        }
        catch (NumberFormatException e) {
            b = false;
        }
        return b;
    }

    public String leggiLinea() {
        StringBuffer line = new StringBuffer();
        while (!this.eoln()) {
            char ch = this.get();
            line.append(ch);
        }
        this.skipEOLN();
        return line.toString();
    }

    public void readln() {
        while (!this.eoln()) {
            char c = this.get();
        }
        this.skipEOLN();
    }

    public boolean eof() {
        char ch = this.peek();
        return ch == '\uffff';
    }

    public boolean eoln() {
        char ch = this.peek();
        return ch == '\n' || ch == '\r' || this.eof();
    }

    private char peek() {
        if (this.next == '\u0000') {
            this.next = this.scan();
        }
        return this.next;
    }

    private char get() {
        char ch = this.peek();
        this.next = '\u0000';
        return ch;
    }

    private char scan() {
        char ch;
        try {
            ch = (char)((FilterReader)this).in.read();
        }
        catch (IOException e) {
            ch = '\uffff';
        }
        return ch;
    }

    private void skipEOLN() {
        char ch = this.peek();
        if (ch == '\r') {
            this.get();
            ch = this.peek();
        }
        if (ch == '\n') {
            this.get();
        }
    }

    private void skipWhite() {
        char ch = this.peek();
        while (Lettore.isWhite(ch)) {
            this.get();
            ch = this.peek();
        }
    }

    private static boolean isWhite(char ch) {
        return Character.isWhitespace(ch);
    }

    private static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }
}

