/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import jedecma.Base64;
import jedecma.Jedecma;
import jedecma.Uti1;

public class JDBCMgr {
    static Connection connection;
    static Statement statement;
    static ResultSet resultSet;
    static boolean isOpen;
    static int dbType;
    static final int MYSQL = 1;
    static final int DERBY = 0;

    public void open() {
        if (isOpen) {
            Uti1.error("open: connection already active", true);
        } else {
            String url = "";
            String driverName = "";
            String user = "";
            String passwd = "";
            dbType = 0;
            if (Integer.parseInt(Jedecma.param.getProperty("dbtype")) == 1) {
                dbType = 1;
            }
            url = Jedecma.param.getProperty("dbname");
            driverName = Jedecma.param.getProperty("jdbcdriver");
            user = Jedecma.param.getProperty("dbuser");
            passwd = Base64.decode(Jedecma.param.getProperty("dbpass"));
            try {
                Class.forName(driverName);
                String connectionUrl = "";
                switch (dbType) {
                    case 1: {
                        connectionUrl = String.valueOf(url) + "?user=" + user + "&password=" + passwd + "&zeroDateTimeBehavior=convertToNull";
                        break;
                    }
                    case 0: {
                        connectionUrl = String.valueOf(url) + "; user=" + user + "; password=" + passwd;
                        break;
                    }
                    default: {
                        Uti1.error("dbType not supported:" + dbType, true);
                        System.err.println("dbType not supported:" + dbType);
                    }
                }
                connection = DriverManager.getConnection(connectionUrl);
                statement = connection.createStatement();
                System.out.println("Opening db connection type " + dbType + ": " + connection + " to: " + url);
            }
            catch (ClassNotFoundException ex) {
                Uti1.error("driver class not found:" + driverName, true);
                System.err.println(ex);
            }
            catch (SQLException ex) {
                String msg = JDBCMgr.SQLExceptionPrint(ex);
                if (msg.equals("")) {
                    msg = "*** unable to connect to database: " + url + " see log";
                }
                Uti1.error(msg, true);
                System.err.println(msg);
            }
            isOpen = true;
        }
    }

    public ResultSet executeQuery(String q) {
        return this.executeQuery(q, statement, 0);
    }

    public ResultSet executeQuery(String q, int lim) {
        return this.executeQuery(q, statement, lim);
    }

    public ResultSet executeQuery(String q, Statement stm, int lim) {
        if (isOpen) {
            if (connection == null || statement == null) {
                Uti1.error("No database to execute the query.", true);
                return resultSet;
            }
            try {
                if (lim > 0) {
                    if (dbType == 0) {
                        q = String.valueOf(q) + " FETCH FIRST " + lim + " ROWS ONLY";
                    }
                    if (dbType == 1) {
                        q = String.valueOf(q) + " limit " + lim;
                    }
                }
                System.out.println("Executing: " + q);
                System.out.println("connection: " + connection.toString());
                resultSet = statement.executeQuery(q);
                return resultSet;
            }
            catch (SQLException ex) {
                Uti1.error(ex.toString(), true);
                return resultSet;
            }
        }
        Uti1.error("exeQuery: connessione non attiva.", true);
        return null;
    }

    public int executeUpdate(String q) {
        int rowCount = 0;
        if (isOpen) {
            if (connection == null || statement == null) {
                Uti1.error("exeUpdate: database not found", true);
                rowCount = -1;
                System.out.println("exeUpdate: rc= " + rowCount);
                return rowCount;
            }
            try {
                System.out.println("Executing: " + q);
                System.out.println("connection: " + connection.toString());
                rowCount = statement.executeUpdate(q);
                System.out.println("exeUpdate: rc= " + rowCount);
                return rowCount;
            }
            catch (SQLIntegrityConstraintViolationException icve) {
                return -3;
            }
            catch (SQLException ex) {
                rowCount = 0;
                System.out.println("exeUpdate: rc= " + rowCount);
                System.out.println(ex.toString());
                return rowCount;
            }
        }
        Uti1.error("exeUpdate: connection not active", true);
        return -2;
    }

    public void close() {
        if (isOpen) {
            switch (dbType) {
                case 0: {
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException se) {
                        if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                            System.out.println("Derby shut down normally");
                            break;
                        }
                        System.err.println("Derby did not shut down normally");
                        System.err.println(se);
                    }
                    break;
                }
                case 1: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                            System.out.println("db connection closed: " + connection);
                            isOpen = false;
                            break;
                        }
                        Uti1.error("There is no db connection to close.", true);
                        break;
                    }
                    catch (SQLException ex) {
                        Uti1.error(ex.toString(), true);
                    }
                }
            }
        } else {
            Uti1.error("close: connection not active.", true);
        }
    }

    public boolean existTable(String table) {
        if (isOpen) {
            if (connection == null || statement == null) {
                Uti1.error("database not found", true);
                return false;
            }
            String q = "SELECT count(*) FROM " + table;
            try {
                System.out.println("Executing: " + q);
                System.out.println("connection: " + connection.toString());
                resultSet = statement.executeQuery(q);
                return true;
            }
            catch (SQLException ex) {
                System.err.println(ex);
                return false;
            }
        }
        Uti1.error("existTable: connection not active.", true);
        return false;
    }

    public int getDbType() {
        return dbType;
    }

    static String SQLExceptionPrint(SQLException sqle) {
        String s = "";
        while (sqle != null) {
            System.err.println("\n---SQLException Caught---\n");
            System.err.println("SQLState:   " + sqle.getSQLState());
            System.err.println("Severity: " + sqle.getErrorCode());
            System.err.println("Message:  " + sqle.getMessage());
            if (!s.equals("")) {
                s = String.valueOf(s) + "\n";
            }
            s = String.valueOf(s) + sqle.getMessage();
            sqle = sqle.getNextException();
        }
        return s;
    }
}

