/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import jedecma.Jedecma;
import jedecma.Uti1;

public class SimpleEula {
    private String EULA_PREF = "eula_";
    private String key;

    SimpleEula() {
        String language = Jedecma.param.getProperty("language");
        if (language.equals("")) {
            language = "en";
        }
        String s = "3.1.13";
        int i = s.lastIndexOf(46);
        this.key = String.valueOf(this.EULA_PREF) + s.substring(0, i) + "_" + language;
    }

    public void show() {
        if (!this.hasBeenShown()) {
            String title = "Jedecma 3.1.13 License Agreement";
            String msg = this.loadEula(this.key);
            if (Uti1.txtYN(msg, title, 1, null) == 1) {
                System.out.println("eula accepted");
                Properties props = Jedecma.param;
                props.put("eulashown", this.key);
                String parmfile = "jedecma.prm";
                try {
                    props.store(new FileOutputStream(parmfile), null);
                }
                catch (IOException ioe) {
                    System.out.println("unable to write parameter file " + parmfile);
                }
            } else {
                System.out.println("eula refused");
                Uti1.error("<html><body><center>Jedecma 3.1.13 20240101-0001<br>" + Jedecma.localMessagesBundle.getString("EULA_REFUSED") + "<br>" + "</center></body></html>", false);
                Jedecma.endProc();
            }
        }
    }

    private String loadEula(String key) {
        String text = "";
        String inputFile = String.valueOf(key) + ".txt";
        try {
            BufferedReader in = new BufferedReader(new FileReader(inputFile));
            String line = "";
            while ((line = in.readLine()) != null) {
                text = String.valueOf(text) + line + '\n';
            }
            text = String.valueOf(text);
            in.close();
        }
        catch (IOException ie) {
            System.out.println("unable to read eula file " + inputFile + " (" + ie + ")");
            Uti1.error("<html><body><center>Jedecma 3.1.13 20240101-0001<br>" + Jedecma.localMessagesBundle.getString("EULA_NOTFOUND") + "<br>" + inputFile + "</center></body></html>", true);
        }
        return text;
    }

    public boolean hasBeenShown() {
        String eulaShown = Jedecma.param.getProperty("eulashown");
        return eulaShown.toUpperCase().equals(this.key.toUpperCase());
    }

    public String getKey() {
        return this.key;
    }
}

