/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jedecma.AccessPane;
import jedecma.ActivationKey;
import jedecma.JDBCMgr;
import jedecma.MainMenu;
import jedecma.MyLock;
import jedecma.SimpleEula;
import jedecma.User;
import jedecma.Uti1;

public class Jedecma
extends JFrame {
    private static final long serialVersionUID = 1L;
    static final String progVers = "3.1.12";
    static final String progBuild = "20230410-1550";
    static Image logo1 = null;
    static Image logo2 = null;
    static JFrame mf;
    static JPanel mainPan;
    static MainMenu menu;
    static JDBCMgr dbmgr;
    static Properties param;
    static JLabel splash;
    static User user;
    static boolean multiuser;
    static String username;
    static String password;
    static String actstr;
    static String dict_file;
    static Vector<String> dict;
    static Font jTextAreaFont;
    static Font jComboBoxFont;
    static Font jTextFieldFont;
    static Font jLabelFont;
    static Font jTableFont;
    static String language;
    static String country;
    static Locale currentLocale;
    static ResourceBundle localMessagesBundle;
    static ActivationKey ak;

    static {
        multiuser = false;
        dict_file = "wrdcmpl.txt";
        dict = new Vector();
        jTableFont = null;
        language = "";
        country = "";
    }

    Jedecma() {
    }

    public static void endProc() {
        if (user != null) {
            MyLock.delLock(dbmgr, "%", Jedecma.user.userid);
        }
        dbmgr.close();
        System.out.println("+-----+");
        System.out.println("| Bye |");
        System.out.println("+-----+");
        System.exit(0);
    }

    private static void createAndShowGUI() {
        mainPan = new JPanel();
        mainPan.setPreferredSize(new Dimension(600, 460));
        mainPan.setLayout(new BorderLayout());
        mf.getContentPane().add((Component)mainPan, "Center");
        mainPan.add((Component)splash, "Center");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        mf.setDefaultCloseOperation(0);
        if (multiuser) {
            mf.setTitle("Jedecma 3.1.12 " + localMessagesBundle.getString("USER") + ": " + username);
        } else {
            mf.setTitle("Jedecma 3.1.12");
        }
        menu = new MainMenu();
        mf.setJMenuBar(menu.buildMenu());
        mf.pack();
        mf.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String s;
        String logo_file;
        Object wlogo;
        Font f;
        String s2;
        username = "";
        password = "";
        System.out.println("Jedecma rel.3.1.12 20230410-1550");
        System.out.println("java.version: " + System.getProperty("java.version"));
        System.out.println("java.vm.name: " + System.getProperty("java.vm.name"));
        System.out.println("java.runtime.name: " + System.getProperty("java.runtime.name"));
        System.out.println("os.name: " + System.getProperty("os.name") + " os.arch: " + System.getProperty("os.arch"));
        System.out.println("user.name: " + System.getProperty("user.name"));
        mf = new Jedecma();
        mf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                String s = "<html><body><center>Jedecma 3.1.12";
                s = String.valueOf(s) + "<br>" + localMessagesBundle.getString("QUIT_PROGRAM");
                if (Uti1.msgYN(s = String.valueOf(s) + "<br>" + localMessagesBundle.getString("ALL_WINDOWS_CLOSED"), localMessagesBundle.getString("END_JEDECMA"), 1, null) == 1) {
                    Jedecma.endProc();
                }
            }
        });
        int idx = -1;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            String kw = "multi";
            idx = arg.indexOf("--" + kw);
            if (idx >= 0) {
                multiuser = true;
                System.out.println("multiuser=" + multiuser);
            }
            if ((idx = arg.indexOf("--" + (kw = "user") + "=")) >= 0) {
                username = arg.substring(idx + kw.length() + 3, arg.length());
                System.out.println("user=" + username);
            }
            if ((idx = arg.indexOf("--" + (kw = "password") + "=")) >= 0) {
                password = arg.substring(idx + kw.length() + 3, arg.length());
            }
            ++i;
        }
        ak = new ActivationKey();
        param = Uti1.readProp();
        ak.readKey();
        if (!ak.isEenableMulti() && multiuser) {
            multiuser = false;
            System.out.println("multiuser=" + multiuser);
        }
        if (!(s2 = param.getProperty("jlabel_font")).equals("") && (f = Uti1.myFont(s2)) != null) {
            jLabelFont = f;
        }
        if (!(s2 = param.getProperty("jcombobox_font")).equals("") && (f = Uti1.myFont(s2)) != null) {
            jComboBoxFont = f;
        }
        if (!(s2 = param.getProperty("jtextarea_font")).equals("") && (f = Uti1.myFont(s2)) != null) {
            jTextAreaFont = f;
        }
        if (!(s2 = param.getProperty("jtextfield_font")).equals("") && (f = Uti1.myFont(s2)) != null) {
            jTextFieldFont = f;
        }
        if (!(s2 = param.getProperty("jtable_font")).equals("") && (f = Uti1.myFont(s2)) != null) {
            jTableFont = f;
        }
        if (!(s2 = param.getProperty("language")).equals("")) {
            language = s2;
        }
        if (!(s2 = param.getProperty("country")).equals("")) {
            country = s2;
        }
        String bgImg = param.getProperty("splash");
        ImageIcon img = new ImageIcon(bgImg);
        splash = new JLabel(img);
        String logo_file1 = param.getProperty("logo1");
        int p = logo_file1.indexOf("[");
        if (p > -1) {
            logo_file1 = logo_file1.substring(0, p).trim();
        }
        if (logo_file1.length() > 0) {
            wlogo = logo_file1;
            SwingUtilities.invokeLater(new Runnable((String)wlogo){
                private final /* synthetic */ String val$wlogo;
                {
                    this.val$wlogo = string;
                }

                @Override
                public void run() {
                    MediaTracker mt = new MediaTracker(mf);
                    logo1 = Toolkit.getDefaultToolkit().getImage(this.val$wlogo);
                    mt.addImage(logo1, 0);
                    try {
                        mt.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int stat = mt.statusID(0, false);
                    if (stat != 8) {
                        System.out.println("image: " + logo1 + " not loaded: status=" + stat);
                        logo1 = null;
                    } else {
                        System.out.println("loaded image " + logo1 + " width=" + logo1.getWidth(mf) + " height=" + logo1.getHeight(mf));
                    }
                }
            });
        }
        if ((p = (logo_file = param.getProperty("logo2")).indexOf("[")) > -1) {
            logo_file = logo_file.substring(0, p).trim();
        }
        if (logo_file.length() > 0) {
            wlogo = logo_file;
            SwingUtilities.invokeLater(new Runnable((String)wlogo){
                private final /* synthetic */ String val$wlogo;
                {
                    this.val$wlogo = string;
                }

                @Override
                public void run() {
                    MediaTracker mt = new MediaTracker(mf);
                    logo2 = Toolkit.getDefaultToolkit().getImage(this.val$wlogo);
                    mt.addImage(logo2, 0);
                    try {
                        mt.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int stat = mt.statusID(0, false);
                    if (stat != 8) {
                        System.out.println("image " + logo2 + " not loaded: status=" + stat);
                        logo2 = null;
                    } else {
                        System.out.println("loaded image " + logo2 + " width=" + logo2.getWidth(mf) + " height=" + logo2.getHeight(mf));
                    }
                }
            });
        }
        if (dict_file.length() > 0) {
            final String inputData = dict_file;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        int next;
                        FileInputStream stream = new FileInputStream(inputData);
                        InputStreamReader reader = new InputStreamReader(stream);
                        StreamTokenizer tokens = new StreamTokenizer(reader);
                        tokens.quoteChar(34);
                        tokens.eolIsSignificant(true);
                        while ((next = tokens.nextToken()) != -1) {
                            if (next != -3 || tokens.sval.length() <= 4) continue;
                            dict.addElement(tokens.sval.toUpperCase());
                        }
                    }
                    catch (Exception e) {
                        System.out.println("error loading file " + dict_file + ": " + e + "\n");
                    }
                    System.out.println("loaded " + dict.size() + " items from file: " + dict_file);
                }
            });
        }
        System.out.println("language: " + language + " country: " + country);
        currentLocale = new Locale(language, country);
        localMessagesBundle = ResourceBundle.getBundle("Messages", currentLocale);
        Date today = new Date();
        if (today.after(ak.getExpDate())) {
            Uti1.error("<html><body><center>Jedecma 3.1.12 20230410-1550<br>" + localMessagesBundle.getString("EXPIRED_LICENSE") + "<br>" + "</center></body></html>", true);
        }
        dbmgr = new JDBCMgr();
        dbmgr.open();
        SimpleEula eula = new SimpleEula();
        System.out.println("eula key: " + eula.getKey());
        eula.show();
        System.out.println("eula shown: " + param.getProperty("eulashown"));
        if (dbmgr.existTable("TBLLCKS")) {
            if (!multiuser) {
                username = "jedecma";
                password = "jedecma";
            }
            if (username.length() == 0 || password.length() == 0) {
                try {
                    wlogo = mf;
                    synchronized (wlogo) {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                JFrame jFrame = mf;
                                synchronized (jFrame) {
                                    AccessPane ap = new AccessPane();
                                    boolean auth = ap.auth;
                                    if (!auth) {
                                        Uti1.error(String.valueOf(localMessagesBundle.getString("USER")) + ": <" + username + "> " + localMessagesBundle.getString("INVALID_USER_OR_PASSWORD"), true);
                                    } else {
                                        username = ap.username;
                                        password = ap.password;
                                    }
                                    mf.notifyAll();
                                    return;
                                }
                            }
                        });
                        mf.wait();
                    }
                }
                catch (InterruptedException wlogo2) {
                    // empty catch block
                }
            }
            user = new User(username, password);
            System.out.println("user=" + user + " id=" + Jedecma.user.userid);
            if (Jedecma.user.userid < 0) {
                Uti1.error(String.valueOf(localMessagesBundle.getString("USER")) + ": <" + username + "> " + localMessagesBundle.getString("INVALID_USER_OR_PASSWORD"), true);
            }
            while (MyLock.setLock(dbmgr, "EXE", Jedecma.user.userid, false) < 0) {
                s = "<html><body><center>Jedecma 3.1.12";
                s = String.valueOf(s) + "<br>" + localMessagesBundle.getString("CANNOT_SET_EXELOCK");
                if (Uti1.msgYN(s = String.valueOf(s) + "</body></html>", localMessagesBundle.getString("FORCING_EXELOCK"), 0, null) != 1) {
                    dbmgr.close();
                    Uti1.error(localMessagesBundle.getString("INCORRECT_PROGRAM_TERMINATION"), true);
                    continue;
                }
                break;
            }
        } else {
            s = "<html><body><center>Jedecma 3.1.12";
            s = String.valueOf(s) + "<br>" + localMessagesBundle.getString("INCOMPLETE_DATABASE_LONG");
            if (Uti1.msgYN(s = String.valueOf(s) + "</body></html>", localMessagesBundle.getString("INCOMPLETE_DATABASE"), 0, null) != 1) {
                Uti1.error(localMessagesBundle.getString("INCOMPLETE_DATABASE"), true);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Jedecma.createAndShowGUI();
            }
        });
    }
}

